/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.support;

import java.io.IOException;
import java.io.InputStream;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreNotOpenException;
import org.jpc.support.SeekableIODevice;

public class RecordBackedSeekableIODevice
implements SeekableIODevice {
    private static final int RECORD_SIZE = 10240;
    private RecordStore diskRecordStore;
    private int diskLength;
    private int seekedPosition;
    private int loadedRecordID;
    private byte[] loadedRecord;
    private boolean loadedModified;

    public void seek(int n) throws IOException {
        this.seekedPosition = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write(byte[] byArray, int n, int n2) throws IOException {
        int n3 = n2;
        try {
            try {
                int n4 = this.seekedPosition / 10240 + 1;
                byte[] byArray2 = this.getRecord(n4);
                int n5 = 10240 - this.seekedPosition % 10240;
                System.arraycopy(byArray, n, byArray2, this.seekedPosition % 10240, n5);
                this.setRecord(n4, byArray2);
                ++n4;
                n += n5;
                n2 -= n5;
                this.seekedPosition += n5;
                while (n2 > 10240) {
                    byArray2 = new byte[10240];
                    System.arraycopy(byArray, n, byArray2, 0, 10240);
                    this.setRecord(n4, byArray2);
                    ++n4;
                    n += 10240;
                    n2 -= 10240;
                    this.seekedPosition += 10240;
                }
                byArray2 = this.getRecord(n4);
                System.arraycopy(byArray, n, byArray2, 0, n2);
                this.setRecord(n4, byArray2);
                this.seekedPosition += n2;
            }
            catch (RecordStoreNotOpenException recordStoreNotOpenException) {
                recordStoreNotOpenException.printStackTrace();
            }
        }
        catch (Throwable throwable) {}
        return n3 - n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        block5: {
            n3 = n2;
            try {
                try {
                    int n4 = this.seekedPosition / 10240 + 1;
                    byte[] byArray2 = this.getRecord(n4);
                    int n5 = Math.min(10240 - this.seekedPosition % 10240, n2);
                    System.arraycopy(byArray2, this.seekedPosition % 10240, byArray, n, n5);
                    ++n4;
                    n += n5;
                    n2 -= n5;
                    this.seekedPosition += n5;
                    while (n2 > 10240) {
                        byArray2 = this.getRecord(n4);
                        System.arraycopy(byArray2, 0, byArray, n, 10240);
                        ++n4;
                        n += 10240;
                        n2 -= 10240;
                        this.seekedPosition += 10240;
                    }
                    if (n2 <= 0) break block5;
                    byArray2 = this.getRecord(n4);
                    System.arraycopy(byArray2, 0, byArray, n, n2);
                    n2 -= n2;
                    this.seekedPosition += n2;
                }
                catch (RecordStoreNotOpenException recordStoreNotOpenException) {
                    recordStoreNotOpenException.printStackTrace();
                }
            }
            catch (Throwable throwable) {}
        }
        return n3 - n2;
    }

    private byte[] getRecord(int n) throws RecordStoreException {
        if (n == this.loadedRecordID) {
            return this.loadedRecord;
        }
        if (this.loadedModified) {
            System.err.println("Setting Record " + this.loadedRecordID);
            this.diskRecordStore.setRecord(this.loadedRecordID, this.loadedRecord, 0, this.loadedRecord.length);
        }
        this.loadedRecord = this.diskRecordStore.getRecord(n);
        this.loadedRecordID = n;
        return this.loadedRecord;
    }

    private void setRecord(int n, byte[] byArray) throws RecordStoreException {
        if (n == this.loadedRecordID) {
            this.loadedRecord = byArray;
            this.loadedModified = true;
            return;
        }
        System.err.println("Setting Record " + n);
        this.diskRecordStore.setRecord(n, byArray, 0, byArray.length);
    }

    public int length() {
        return this.diskLength;
    }

    public boolean readOnly() {
        return false;
    }

    public void configure(String string) throws Exception {
        int n;
        byte[] byArray;
        InputStream inputStream = this.getClass().getResourceAsStream("/" + string);
        System.err.println("Found Disk Input Stream..." + string);
        this.diskRecordStore = RecordStore.openRecordStore((String)string, (boolean)true);
        int n2 = this.diskRecordStore.getNumRecords();
        if (n2 > 0) {
            System.err.print("Existing Record Store Found...");
            byArray = this.diskRecordStore.getRecord(n2);
            if (byArray.length == 4) {
                this.diskLength = 0xFF & byArray[0] | (0xFF & byArray[1]) << 8 | (0xFF & byArray[2]) << 16 | (0xFF & byArray[3]) << 24;
                n = this.diskLength / 10240 + (this.diskLength % 10240 == 0 ? 0 : 1);
                if (n2 == n + 1) {
                    System.err.println("valid");
                    return;
                }
                System.err.println("requiredRecords = " + (n + 1) + ", actualRecords = " + n2);
            }
            System.err.println("corrupt");
            this.diskRecordStore.closeRecordStore();
            RecordStore.deleteRecordStore((String)string);
            this.diskRecordStore = RecordStore.openRecordStore((String)string, (boolean)true);
        }
        System.err.print("Created New Record Store");
        this.diskLength = 0;
        while (true) {
            byArray = new byte[10240];
            n = 0;
            while (n < 10240) {
                int n3 = inputStream.read(byArray, n, byArray.length - n);
                if (n3 < 0) {
                    if (n != 0) {
                        this.diskRecordStore.addRecord(byArray, 0, byArray.length);
                    }
                    byte[] byArray2 = new byte[]{(byte)this.diskLength, (byte)(this.diskLength >>> 8), (byte)(this.diskLength >>> 16), (byte)(this.diskLength >>> 24)};
                    this.diskRecordStore.addRecord(byArray2, 0, byArray2.length);
                    System.err.println(this.diskLength + " bytes in " + 10240 + " byte chunks");
                    return;
                }
                n += n3;
                this.diskLength += n3;
            }
            System.err.print(".");
            this.diskRecordStore.addRecord(byArray, 0, byArray.length);
        }
    }
}

