/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.support;

import java.io.IOException;
import java.io.InputStream;
import org.jpc.support.SeekableIODevice;

public abstract class StreamBackedSeekableIODevice
implements SeekableIODevice {
    private byte[] dataCache = new byte[4096];
    private InputStream source = null;
    private int imageOffset;
    private int limit;

    public StreamBackedSeekableIODevice(int n, int n2) {
        this.limit = n2;
        this.imageOffset = -1;
    }

    public void closeStream() throws IOException {
        if (this.source != null) {
            this.source.close();
        }
    }

    protected abstract InputStream resetStream() throws IOException;

    protected void seekTo(int n) throws IOException {
        if (this.source == null || this.imageOffset > n) {
            this.closeStream();
            this.source = this.resetStream();
            this.imageOffset = 0;
        }
        while (this.imageOffset < n) {
            int n2 = Math.min(this.dataCache.length, n - this.imageOffset);
            int n3 = this.source.read(this.dataCache, 0, n2);
            if (n3 < 0) {
                throw new IOException("Seek past end of device");
            }
            this.imageOffset += n3;
        }
    }

    public void seek(int n) throws IOException {
        if (n < 0 || n >= this.limit) {
            throw new IOException("seek offset out of range: " + n + " not in [0," + this.limit + "]");
        }
        this.seekTo(n);
    }

    public int write(byte[] byArray, int n, int n2) throws IOException {
        System.out.println("Write at pos " + n);
        throw new IOException("Device read only");
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = Math.min(byArray.length - n, n2);
        if (this.source == null) {
            this.seekTo(0);
        }
        int n4 = n3;
        while (n3 > 0) {
            int n5 = this.source.read(byArray, n, n3);
            if (n5 < 0) {
                return n5;
            }
            n3 -= n5;
            n += n5;
            this.imageOffset += n5;
        }
        return n4;
    }

    public int length() {
        return this.limit;
    }

    public boolean readOnly() {
        return true;
    }
}

