/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator.memory.codeblock;

import org.jpc.emulator.memory.AbstractMemory;
import org.jpc.emulator.memory.codeblock.ProtectedModeCodeBlock;
import org.jpc.emulator.memory.codeblock.RealModeCodeBlock;

public class MemoryTree
extends AbstractMemory {
    private long size;
    private Node root;
    private byte defaultValue;

    public MemoryTree(long l, int n) {
        this.defaultValue = (byte)n;
        this.root = new ConstantNode(this.defaultValue);
    }

    public boolean isCacheable() {
        return true;
    }

    public long getSize() {
        return this.size;
    }

    public byte getByte(int n) {
        return this.root.getByte(n);
    }

    public void setByte(int n, byte by) {
        this.root = this.root.setByte(by, n);
    }

    public ProtectedModeCodeBlock getProtectedModeCodeBlockAt(int n) {
        throw new IllegalStateException("Invalid Operation");
    }

    public RealModeCodeBlock getRealModeCodeBlockAt(int n) {
        throw new IllegalStateException("Invalid Operation");
    }

    class ConstantNode
    extends Node {
        byte value;

        ConstantNode(byte by) {
            this.value = by;
        }

        byte getByte(int n) {
            if (n == 0) {
                return this.value;
            }
            return MemoryTree.this.defaultValue;
        }

        Node setByte(byte by, int n) {
            if (n == 0) {
                this.value = by;
                return this;
            }
            ConstantNode constantNode = this;
            ConstantNode constantNode2 = new ConstantNode(MemoryTree.this.defaultValue);
            Node node = new BranchNode(constantNode, constantNode2);
            node = ((Node)node).setByte(by, n);
            return node;
        }
    }

    class BranchNode
    extends Node {
        Node left;
        Node right;

        BranchNode(Node node, Node node2) {
            this.left = node;
            this.right = node2;
        }

        byte getByte(int n) {
            if ((n & 1) == 0) {
                return this.left.getByte(n >>> 1);
            }
            return this.right.getByte(n >>> 1);
        }

        Node setByte(byte by, int n) {
            if ((n & 1) == 0) {
                this.left = this.left.setByte(by, n >>> 1);
            } else {
                this.right = this.right.setByte(by, n >>> 1);
            }
            if (this.left instanceof ConstantNode && this.right instanceof ConstantNode) {
                ConstantNode constantNode = (ConstantNode)this.left;
                ConstantNode constantNode2 = (ConstantNode)this.right;
                if (constantNode.value == constantNode2.value && constantNode.value == MemoryTree.this.defaultValue) {
                    return constantNode;
                }
            }
            return this;
        }
    }

    abstract class Node {
        Node() {
        }

        abstract byte getByte(int var1);

        abstract Node setByte(byte var1, int var2);
    }
}

