/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator.memory.codeblock;

import org.jpc.emulator.memory.PhysicalAddressSpace;
import org.jpc.emulator.memory.codeblock.ByteSourceWrappedMemory;
import org.jpc.emulator.memory.codeblock.CodeBlock;
import org.jpc.emulator.memory.codeblock.CodeBlockFactory;
import org.jpc.emulator.memory.codeblock.RealModeCodeBlock;
import org.jpc.emulator.memory.codeblock.SpanningCodeBlock;
import org.jpc.emulator.processor.Processor;

public class SpanningRealModeCodeBlock
extends SpanningCodeBlock
implements RealModeCodeBlock {
    private static final ByteSourceWrappedMemory byteSource = new ByteSourceWrappedMemory();
    private CodeBlockFactory[] factories;

    public SpanningRealModeCodeBlock(CodeBlockFactory[] codeBlockFactoryArray) {
        this.factories = codeBlockFactoryArray;
    }

    protected CodeBlock decode(Processor processor) {
        RealModeCodeBlock realModeCodeBlock = null;
        PhysicalAddressSpace physicalAddressSpace = processor.physicalMemory;
        int n = processor.getInstructionPointer();
        for (int i = 0; i < this.factories.length && realModeCodeBlock == null; ++i) {
            try {
                byteSource.set(physicalAddressSpace, n);
                realModeCodeBlock = this.factories[i].getRealModeCodeBlock(byteSource);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return realModeCodeBlock;
    }

    public String getDisplayString() {
        return "Spanning Real Mode CodeBlock";
    }
}

