/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator.memory.codeblock.basic;

import org.jpc.emulator.memory.codeblock.CodeBlock;
import org.jpc.emulator.memory.codeblock.basic.FirstStageCodeSet;
import org.jpc.emulator.processor.Processor;
import org.jpc.emulator.processor.ProcessorException;
import org.jpc.emulator.processor.Segment;
import org.jpc.emulator.processor.fpu64.FpuState;
import org.jpc.emulator.processor.fpu64.FpuState64;

public abstract class FirstStageCodeBlock
implements CodeBlock,
FirstStageCodeSet {
    protected static final ProcessorException exceptionDE = new ProcessorException(0, true);
    protected static final ProcessorException exceptionUD = new ProcessorException(6, true);
    protected static final ProcessorException exceptionNM = new ProcessorException(7, true);
    protected static final ProcessorException unimplemented = new ProcessorException(-1, true);
    protected static final boolean[] parityMap = new boolean[256];
    protected Processor cpu;
    protected FpuState fpu;
    protected int microcodesPosition;
    private int x86Count;
    protected int[] microcodes;
    protected int[] cumulativeX86Length;
    protected int executeCount;

    public FirstStageCodeBlock() {
    }

    public FirstStageCodeBlock(int[] nArray, int[] nArray2) {
        this.microcodes = nArray;
        this.cumulativeX86Length = nArray2;
        if (this.cumulativeX86Length.length == 0) {
            this.x86Count = 0;
        } else {
            int n = 1;
            for (int i = 1; i < this.cumulativeX86Length.length; ++i) {
                if (this.cumulativeX86Length[i] <= this.cumulativeX86Length[i - 1]) continue;
                ++n;
            }
            this.x86Count = n;
        }
    }

    public int getX86Length() {
        if (this.microcodes.length == 0) {
            return 0;
        }
        return this.cumulativeX86Length[this.microcodes.length - 1];
    }

    public int getX86Count() {
        return this.x86Count;
    }

    public String getDisplayString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.microcodes.length; ++i) {
            stringBuffer.append(this.microcodes[i] + "\n");
        }
        return stringBuffer.toString();
    }

    public boolean handleMemoryRegionChange(int n, int n2) {
        return false;
    }

    public int[] getMicrocodes() {
        int[] nArray = new int[this.microcodes.length];
        System.arraycopy(this.microcodes, 0, nArray, 0, nArray.length);
        return nArray;
    }

    protected final int getMicrocode() {
        int n = this.microcodes[this.microcodesPosition];
        ++this.microcodesPosition;
        return n;
    }

    public abstract int operandCount(int var1);

    public abstract int immediateCount(int var1);

    protected abstract void loadSegment(int var1, int var2);

    protected final void skipOperand() {
        int n = this.immediateCount(this.getMicrocode());
        this.microcodesPosition += n;
    }

    private final void standardFlags(byte by) {
        this.cpu.eflagsOverflow = false;
        this.cpu.eflagsCarry = false;
        this.cpu.eflagsZero = by == 0;
        this.cpu.eflagsParity = parityMap[by & 0xFF];
        this.cpu.eflagsSign = by < 0;
    }

    private final void standardFlags(short s) {
        this.cpu.eflagsOverflow = false;
        this.cpu.eflagsCarry = false;
        this.cpu.eflagsZero = s == 0;
        this.cpu.eflagsParity = parityMap[s & 0xFF];
        this.cpu.eflagsSign = s < 0;
    }

    private final void standardFlags(int n) {
        this.cpu.eflagsOverflow = false;
        this.cpu.eflagsCarry = false;
        this.cpu.eflagsZero = n == 0;
        this.cpu.eflagsParity = parityMap[n & 0xFF];
        this.cpu.eflagsSign = n < 0;
    }

    private double getDoubleOperand() {
        switch (this.getMicrocode()) {
            case 48: {
                return this.fpu.ST(0);
            }
            case 49: {
                return this.fpu.ST(1);
            }
            case 50: {
                return this.fpu.ST(2);
            }
            case 51: {
                return this.fpu.ST(3);
            }
            case 52: {
                return this.fpu.ST(4);
            }
            case 53: {
                return this.fpu.ST(5);
            }
            case 54: {
                return this.fpu.ST(6);
            }
            case 55: {
                return this.fpu.ST(7);
            }
        }
        --this.microcodesPosition;
        long l = this.getLongOperand();
        if (FpuState64.isSNaN(l)) {
            this.fpu.setInvalidOperation();
            this.fpu.checkExceptions();
            return Double.NaN;
        }
        return Double.longBitsToDouble(l);
    }

    private void setDoubleOperand(double d) {
        switch (this.getMicrocode()) {
            case 48: {
                this.fpu.setST(0, d);
                return;
            }
            case 49: {
                this.fpu.setST(1, d);
                return;
            }
            case 50: {
                this.fpu.setST(2, d);
                return;
            }
            case 51: {
                this.fpu.setST(3, d);
                return;
            }
            case 52: {
                this.fpu.setST(4, d);
                return;
            }
            case 53: {
                this.fpu.setST(5, d);
                return;
            }
            case 54: {
                this.fpu.setST(6, d);
                return;
            }
            case 55: {
                this.fpu.setST(7, d);
                return;
            }
        }
        --this.microcodesPosition;
        long l = Double.doubleToLongBits(d);
        this.setLongOperand(l);
    }

    private double getSingleOperand() {
        switch (this.getMicrocode()) {
            case 48: {
                return this.fpu.ST(0);
            }
            case 49: {
                return this.fpu.ST(1);
            }
            case 50: {
                return this.fpu.ST(2);
            }
            case 51: {
                return this.fpu.ST(3);
            }
            case 52: {
                return this.fpu.ST(4);
            }
            case 53: {
                return this.fpu.ST(5);
            }
            case 54: {
                return this.fpu.ST(6);
            }
            case 55: {
                return this.fpu.ST(7);
            }
        }
        --this.microcodesPosition;
        int n = this.getIntOperand();
        int n2 = n >> 23 & 0xFF;
        int n3 = n & 0x7FFFFF;
        if (n2 == 255 && (n3 & 0x400000) == 0 && n3 != 0) {
            this.fpu.setInvalidOperation();
            this.fpu.checkExceptions();
            return Double.NaN;
        }
        float f = Float.intBitsToFloat(n);
        return f;
    }

    private void setSingleOperand(double d) {
        switch (this.getMicrocode()) {
            case 48: {
                this.fpu.setST(0, d);
                return;
            }
            case 49: {
                this.fpu.setST(1, d);
                return;
            }
            case 50: {
                this.fpu.setST(2, d);
                return;
            }
            case 51: {
                this.fpu.setST(3, d);
                return;
            }
            case 52: {
                this.fpu.setST(4, d);
                return;
            }
            case 53: {
                this.fpu.setST(5, d);
                return;
            }
            case 54: {
                this.fpu.setST(6, d);
                return;
            }
            case 55: {
                this.fpu.setST(7, d);
                return;
            }
        }
        --this.microcodesPosition;
        int n = Float.floatToIntBits((float)d);
        this.setIntOperand(n);
    }

    private double getWordIntegerOperand() {
        short s = this.getShortOperand();
        return s;
    }

    private void setWordIntegerOperand(double d) {
        int n = (int)d;
        if (d > 32767.0 || d < -32768.0) {
            this.fpu.setInvalidOperation();
            this.fpu.checkExceptions();
            n = Short.MIN_VALUE;
        }
        this.setShortOperand((short)n);
    }

    private double getDoubleIntegerOperand() {
        int n = this.getIntOperand();
        return n;
    }

    private void setDoubleIntegerOperand(double d) {
        int n = (int)d;
        if (d > 2.147483647E9 || d < -2.147483648E9) {
            this.fpu.setInvalidOperation();
            this.fpu.checkExceptions();
            n = Integer.MIN_VALUE;
        }
        this.setIntOperand(n);
    }

    private double getQuadIntegerOperand() {
        long l = this.getLongOperand();
        return l;
    }

    private void setQuadIntegerOperand(double d) {
        long l = (long)d;
        if (d > 9.223372036854776E18 || d < -9.223372036854776E18) {
            this.fpu.setInvalidOperation();
            this.fpu.checkExceptions();
            l = Long.MIN_VALUE;
        }
        this.setLongOperand(l);
    }

    private void validateOperand(double d) throws ProcessorException {
        long l = Double.doubleToLongBits(d);
        if ((l >> 52 & 0x7FFL) == 0L && (l & 0xFFFFFFFFFFFFFL) != 0L) {
            this.fpu.setDenormalizedOperand();
            this.fpu.checkExceptions();
        }
    }

    private void checkResult(double d) throws ProcessorException {
        if (Double.isInfinite(d)) {
            this.fpu.setOverflow();
            this.fpu.checkExceptions();
        }
    }

    protected final void aaa() {
        if ((this.cpu.eax & 0xF) > 9 || this.cpu.eflagsAuxiliaryCarry) {
            int n = (this.cpu.eax & 0xFF) > 249 ? 256 : 0;
            this.cpu.eax = 0xFFFF0000 & this.cpu.eax | 0xF & this.cpu.eax + 6 | 0xFF00 & this.cpu.eax + 256 + n;
            this.cpu.eflagsAuxiliaryCarry = true;
            this.cpu.eflagsCarry = true;
        } else {
            this.cpu.eflagsAuxiliaryCarry = false;
            this.cpu.eflagsCarry = false;
            this.cpu.eax &= 0xFFFFFF0F;
        }
    }

    protected final void aad() throws ProcessorException {
        int n = this.cpu.eax & 0xFF;
        int n2 = this.cpu.eax >> 8 & 0xFF;
        int n3 = 0xFF & this.getByteOperand();
        int n4 = n2 * n3;
        int n5 = n4 + n;
        this.cpu.eax = this.cpu.eax & 0xFFFF0000 | n5 & 0xFF;
        this.standardFlags((byte)n5);
        this.cpu.eflagsAuxiliaryCarry = (n4 & 8) != (n5 & 8);
        this.cpu.eflagsCarry = n5 > 255;
        this.cpu.eflagsOverflow = (n5 & 0x80) != (n & 0x80);
    }

    protected final void aam() throws ProcessorException {
        int n = 0xFF & this.cpu.eax;
        int n2 = 0xFF & this.getByteOperand();
        if (n2 == 0) {
            throw exceptionDE;
        }
        int n3 = 0xFF & n / n2;
        int n4 = 0xFF & n % n2;
        this.cpu.eax &= 0xFFFF0000;
        this.cpu.eax |= n4 | n3 << 8;
        this.cpu.eflagsAuxiliaryCarry = false;
        this.cpu.eflagsCarry = false;
        this.standardFlags((byte)n4);
    }

    protected final void aas() {
        if ((this.cpu.eax & 0xF) > 9 || this.cpu.eflagsAuxiliaryCarry) {
            int n = (this.cpu.eax & 0xFF) < 6 ? 256 : 0;
            this.cpu.eax = 0xFFFF0000 & this.cpu.eax | 0xF & this.cpu.eax - 6 | 0xFF00 & this.cpu.eax - 256 - n;
            this.cpu.eflagsAuxiliaryCarry = true;
            this.cpu.eflagsCarry = true;
        } else {
            this.cpu.eflagsAuxiliaryCarry = false;
            this.cpu.eflagsCarry = false;
            this.cpu.eax &= 0xFFFFFF0F;
        }
    }

    protected final void adc_o8() throws ProcessorException {
        int n;
        int n2 = 0xFF & this.getByteOperand();
        int n3 = n = 0xFF & this.getByteOperand();
        if (this.cpu.eflagsCarry && n2 == 255) {
            this.setByteOperand((byte)n3);
            this.cpu.eflagsOverflow = false;
            this.cpu.eflagsCarry = true;
        } else {
            int n4 = this.cpu.eflagsCarry ? 1 : 0;
            this.setByteOperand((byte)(n3 += n2 + n4));
            boolean bl = this.cpu.eflagsCarry = (n3 & 0xFFFFFF00) != 0;
            this.cpu.eflagsOverflow = (byte)(n2 + n4) > 0 ? (byte)n3 < (byte)n : (byte)n3 > (byte)n;
        }
        this.cpu.eflagsAuxiliaryCarry = ((n ^ n2 ^ n3) & 0x10) != 0;
        this.cpu.eflagsZero = (byte)n3 == 0;
        this.cpu.eflagsParity = parityMap[0xFF & n3];
        this.cpu.eflagsSign = (byte)n3 < 0;
    }

    protected final void adc_o16() throws ProcessorException {
        int n;
        int n2 = 0xFFFF & this.getShortOperand();
        int n3 = n = 0xFFFF & this.getShortOperand();
        if (this.cpu.eflagsCarry && n2 == 65535) {
            this.setShortOperand((short)n3);
            this.cpu.eflagsOverflow = false;
            this.cpu.eflagsCarry = true;
        } else {
            int n4 = this.cpu.eflagsCarry ? 1 : 0;
            this.setShortOperand((short)(n3 += n2 + n4));
            boolean bl = this.cpu.eflagsCarry = (n3 & 0xFFFF0000) != 0;
            this.cpu.eflagsOverflow = (short)(n2 + n4) > 0 ? (short)n3 < (short)n : (short)n3 > (short)n;
        }
        this.cpu.eflagsAuxiliaryCarry = ((n ^ n2 ^ n3) & 0x10) != 0;
        this.cpu.eflagsZero = (short)n3 == 0;
        this.cpu.eflagsParity = parityMap[0xFF & n3];
        this.cpu.eflagsSign = (short)n3 < 0;
    }

    protected final void adc_o32() throws ProcessorException {
        long l;
        long l2 = 0xFFFFFFFFL & (long)this.getIntOperand();
        long l3 = l = 0xFFFFFFFFL & (long)this.getIntOperand();
        if (this.cpu.eflagsCarry && l2 == 0xFFFFFFFFL) {
            this.setIntOperand((int)l3);
            this.cpu.eflagsOverflow = false;
            this.cpu.eflagsCarry = true;
        } else {
            int n = this.cpu.eflagsCarry ? 1 : 0;
            this.setIntOperand((int)(l3 += l2 + (long)n));
            boolean bl = this.cpu.eflagsCarry = (l3 & 0xFFFFFFFF00000000L) != 0L;
            this.cpu.eflagsOverflow = (int)(l2 + (long)n) > 0 ? (int)l3 < (int)l : (int)l3 > (int)l;
        }
        this.cpu.eflagsAuxiliaryCarry = ((l ^ l2 ^ l3) & 0x10L) != 0L;
        this.cpu.eflagsZero = (int)l3 == 0;
        this.cpu.eflagsParity = parityMap[0xFF & (int)l3];
        this.cpu.eflagsSign = (int)l3 < 0;
    }

    protected final void add_o8() throws ProcessorException {
        int n = 0xFF & this.getByteOperand();
        int n2 = 0xFF & this.getByteOperand();
        int n3 = n + n2;
        this.setByteOperand((byte)n3);
        this.standardFlags((byte)n3);
        boolean bl = this.cpu.eflagsCarry = (n3 & 0xFFFFFF00) != 0;
        this.cpu.eflagsOverflow = (byte)n2 > 0 ? (byte)n3 < (byte)n : (byte)n3 > (byte)n;
        this.cpu.eflagsAuxiliaryCarry = ((n ^ n2 ^ n3) & 0x10) != 0;
    }

    protected final void add_o16() throws ProcessorException {
        int n = 0xFFFF & this.getShortOperand();
        int n2 = 0xFFFF & this.getShortOperand();
        int n3 = n2 + n;
        this.setShortOperand((short)n3);
        this.standardFlags((short)n3);
        boolean bl = this.cpu.eflagsCarry = (n3 & 0xFFFF0000) != 0;
        this.cpu.eflagsOverflow = (short)n > 0 ? (short)n3 < (short)n2 : (short)n3 > (short)n2;
        this.cpu.eflagsAuxiliaryCarry = ((n2 ^ n ^ n3) & 0x10) != 0;
    }

    protected final void add_o32() throws ProcessorException {
        long l = 0xFFFFFFFFL & (long)this.getIntOperand();
        long l2 = 0xFFFFFFFFL & (long)this.getIntOperand();
        long l3 = l + l2;
        this.setIntOperand((int)l3);
        this.standardFlags((int)l3);
        boolean bl = this.cpu.eflagsCarry = (l3 & 0xFFFFFFFF00000000L) != 0L;
        this.cpu.eflagsOverflow = (int)l2 > 0 ? (int)l3 < (int)l : (int)l3 > (int)l;
        this.cpu.eflagsAuxiliaryCarry = ((l ^ l2 ^ l3) & 0x10L) != 0L;
    }

    protected final void and_o8() throws ProcessorException {
        byte by = (byte)(this.getByteOperand() & this.getByteOperand());
        this.setByteOperand(by);
        this.standardFlags(by);
    }

    protected final void and_o16() throws ProcessorException {
        short s = (short)(this.getShortOperand() & this.getShortOperand());
        this.setShortOperand(s);
        this.standardFlags(s);
    }

    protected final void and_o32() throws ProcessorException {
        int n = this.getIntOperand() & this.getIntOperand();
        this.setIntOperand(n);
        this.standardFlags(n);
    }

    protected final void bsf_o16() throws ProcessorException {
        int n = 0xFFFF & this.getShortOperand();
        if (n == 0) {
            this.cpu.eflagsZero = true;
            this.skipOperand();
        } else {
            this.setShortOperand((short)FirstStageCodeBlock.numberOfTrailingZeros(n));
            this.cpu.eflagsZero = false;
        }
    }

    protected final void bsf_o32() throws ProcessorException {
        int n = this.getIntOperand();
        if (n == 0) {
            this.cpu.eflagsZero = true;
            this.skipOperand();
        } else {
            this.setIntOperand(FirstStageCodeBlock.numberOfTrailingZeros(n));
            this.cpu.eflagsZero = false;
        }
    }

    protected final void bsr_o16() throws ProcessorException {
        int n = 0xFFFF & this.getShortOperand();
        if (n == 0) {
            this.cpu.eflagsZero = true;
            this.skipOperand();
        } else {
            this.setShortOperand((short)(31 - FirstStageCodeBlock.numberOfLeadingZeros(n)));
            this.cpu.eflagsZero = false;
        }
    }

    protected final void bsr_o32() throws ProcessorException {
        int n = this.getIntOperand();
        if (n == 0) {
            this.cpu.eflagsZero = true;
            this.skipOperand();
        } else {
            this.setIntOperand(31 - FirstStageCodeBlock.numberOfLeadingZeros(n));
            this.cpu.eflagsZero = false;
        }
    }

    protected final void bswap() {
        this.setIntOperand(FirstStageCodeBlock.reverseBytes(this.getIntOperand()));
    }

    protected final void bt_o16() throws ProcessorException {
        short s = this.getShortOperand();
        switch (this.microcodes[this.microcodesPosition]) {
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                short s2 = this.getShortOperand();
                s = (short)(s & 0xF);
                this.cpu.eflagsCarry = (s2 & 1 << s) != 0;
                this.skipOperand();
                break;
            }
            default: {
                int n = this.getAddressOperand() + (s & 0xFFFFFFF8) / 8;
                Segment segment = this.getSegmentOperand();
                s = (short)(s & 7);
                byte by = segment.getByte(n);
                this.cpu.eflagsCarry = (by & 1 << s) != 0;
            }
        }
    }

    protected final void bt_o32() throws ProcessorException {
        int n = this.getIntOperand();
        switch (this.microcodes[this.microcodesPosition]) {
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                int n2 = this.getIntOperand();
                this.cpu.eflagsCarry = (n2 & 1 << (n &= 0x1F)) != 0;
                this.skipOperand();
                break;
            }
            default: {
                int n3 = this.getAddressOperand() + (n & 0xFFFFFFF8) / 8;
                Segment segment = this.getSegmentOperand();
                byte by = segment.getByte(n3);
                this.cpu.eflagsCarry = (by & 1 << (n &= 7)) != 0;
            }
        }
    }

    protected final void bt_o32_o8() throws ProcessorException {
        int n = 0x1F & this.getByteOperand();
        switch (this.microcodes[this.microcodesPosition]) {
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                int n2 = this.getIntOperand();
                this.cpu.eflagsCarry = (n2 & 1 << (n &= 0x1F)) != 0;
                this.skipOperand();
                break;
            }
            default: {
                int n3 = this.getAddressOperand() + (n & 0xFFFFFFF8) / 8;
                Segment segment = this.getSegmentOperand();
                byte by = segment.getByte(n3);
                this.cpu.eflagsCarry = (by & 1 << (n &= 7)) != 0;
            }
        }
    }

    protected final void bt_o16_o8() throws ProcessorException {
        int n = 0x1F & this.getByteOperand();
        switch (this.microcodes[this.microcodesPosition]) {
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                short s = this.getShortOperand();
                this.cpu.eflagsCarry = (s & 1 << (n &= 0xF)) != 0;
                this.skipOperand();
                break;
            }
            default: {
                int n2 = this.getAddressOperand() + (n & 0xFFFFFFF8) / 8;
                Segment segment = this.getSegmentOperand();
                byte by = segment.getByte(n2);
                this.cpu.eflagsCarry = (by & 1 << (n &= 7)) != 0;
            }
        }
    }

    protected final void btc_o16() throws ProcessorException {
        short s = this.getShortOperand();
        switch (this.microcodes[this.microcodesPosition]) {
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                short s2 = this.getShortOperand();
                s = (short)(s & 0xF);
                this.setShortOperand((short)(s2 ^ 1 << s));
                this.cpu.eflagsCarry = (s2 & 1 << s) != 0;
                break;
            }
            default: {
                int n = this.getAddressOperand() + (s & 0xFFFFFFF8) / 8;
                Segment segment = this.getSegmentOperand();
                s = (short)(s & 7);
                byte by = segment.getByte(n);
                segment.setByte(n, (byte)(by ^ 1 << s));
                this.cpu.eflagsCarry = (by & 1 << s) != 0;
            }
        }
    }

    protected final void btc_o32() throws ProcessorException {
        int n = this.getIntOperand();
        switch (this.microcodes[this.microcodesPosition]) {
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                int n2 = this.getIntOperand();
                this.setIntOperand(n2 ^ 1 << (n &= 0x1F));
                this.cpu.eflagsCarry = (n2 & 1 << n) != 0;
                break;
            }
            default: {
                int n3 = this.getAddressOperand() + (n & 0xFFFFFFF8) / 8;
                Segment segment = this.getSegmentOperand();
                byte by = segment.getByte(n3);
                segment.setByte(n3, (byte)(by ^ 1 << (n &= 7)));
                this.cpu.eflagsCarry = (by & 1 << n) != 0;
            }
        }
    }

    protected final void btc_o32_o8() throws ProcessorException {
        int n = 0x1F & this.getByteOperand();
        switch (this.microcodes[this.microcodesPosition]) {
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                int n2 = this.getIntOperand();
                this.setIntOperand(n2 ^ ~(1 << (n &= 0x1F)));
                this.cpu.eflagsCarry = (n2 & 1 << n) != 0;
                break;
            }
            default: {
                int n3 = this.getAddressOperand() + (n & 0xFFFFFFF8) / 8;
                Segment segment = this.getSegmentOperand();
                byte by = segment.getByte(n3);
                segment.setByte(n3, (byte)(by ^ ~(1 << (n &= 7))));
                this.cpu.eflagsCarry = (by & 1 << n) != 0;
            }
        }
    }

    protected final void btr_o16() throws ProcessorException {
        short s = this.getShortOperand();
        switch (this.microcodes[this.microcodesPosition]) {
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                short s2 = this.getShortOperand();
                s = (short)(s & 0xF);
                this.setShortOperand((short)(s2 & ~(1 << s)));
                this.cpu.eflagsCarry = (s2 & 1 << s) != 0;
                break;
            }
            default: {
                int n = this.getAddressOperand() + (s & 0xFFFFFFF8) / 8;
                Segment segment = this.getSegmentOperand();
                s = (short)(s & 7);
                byte by = segment.getByte(n);
                segment.setByte(n, (byte)(by & ~(1 << s)));
                this.cpu.eflagsCarry = (by & 1 << s) != 0;
            }
        }
    }

    protected final void btr_o32() throws ProcessorException {
        int n = this.getIntOperand();
        switch (this.microcodes[this.microcodesPosition]) {
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                int n2 = this.getIntOperand();
                this.setIntOperand(n2 & ~(1 << (n &= 0x1F)));
                this.cpu.eflagsCarry = (n2 & 1 << n) != 0;
                break;
            }
            default: {
                int n3 = this.getAddressOperand() + (n & 0xFFFFFFF8) / 8;
                Segment segment = this.getSegmentOperand();
                byte by = segment.getByte(n3);
                segment.setByte(n3, (byte)(by & ~(1 << (n &= 7))));
                this.cpu.eflagsCarry = (by & 1 << n) != 0;
            }
        }
    }

    protected final void btr_o32_o8() throws ProcessorException {
        int n = 0x1F & this.getByteOperand();
        switch (this.microcodes[this.microcodesPosition]) {
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                int n2 = this.getIntOperand();
                this.setIntOperand(n2 & ~(1 << (n &= 0x1F)));
                this.cpu.eflagsCarry = (n2 & 1 << n) != 0;
                break;
            }
            default: {
                int n3 = this.getAddressOperand() + (n & 0xFFFFFFF8) / 8;
                Segment segment = this.getSegmentOperand();
                byte by = segment.getByte(n3);
                segment.setByte(n3, (byte)(by & ~(1 << (n &= 7))));
                this.cpu.eflagsCarry = (by & 1 << n) != 0;
            }
        }
    }

    protected final void bts_o16() throws ProcessorException {
        short s = this.getShortOperand();
        switch (this.microcodes[this.microcodesPosition]) {
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                short s2 = this.getShortOperand();
                s = (short)(s & 0xF);
                this.setShortOperand((short)(s2 | 1 << s));
                this.cpu.eflagsCarry = (s2 & 1 << s) != 0;
                break;
            }
            default: {
                int n = this.getAddressOperand() + (s & 0xFFFFFFF8) / 8;
                Segment segment = this.getSegmentOperand();
                s = (short)(s & 7);
                byte by = segment.getByte(n);
                segment.setByte(n, (byte)(by | 1 << s));
                this.cpu.eflagsCarry = (by & 1 << s) != 0;
            }
        }
    }

    protected final void bts_o32() throws ProcessorException {
        int n = this.getIntOperand();
        switch (this.microcodes[this.microcodesPosition]) {
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                int n2 = this.getIntOperand();
                this.setIntOperand(n2 | 1 << (n &= 0x1F));
                this.cpu.eflagsCarry = (n2 & 1 << n) != 0;
                break;
            }
            default: {
                int n3 = this.getAddressOperand() + (n & 0xFFFFFFF8) / 8;
                Segment segment = this.getSegmentOperand();
                byte by = segment.getByte(n3);
                segment.setByte(n3, (byte)(by | 1 << (n &= 7)));
                this.cpu.eflagsCarry = (by & 1 << n) != 0;
            }
        }
    }

    protected final void bts_o32_o8() throws ProcessorException {
        int n = 0x1F & this.getByteOperand();
        switch (this.microcodes[this.microcodesPosition]) {
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                int n2 = this.getIntOperand();
                this.setIntOperand(n2 | 1 << (n &= 0x1F));
                this.cpu.eflagsCarry = (n2 & 1 << n) != 0;
                break;
            }
            default: {
                int n3 = this.getAddressOperand() + (n & 0xFFFFFFF8) / 8;
                Segment segment = this.getSegmentOperand();
                byte by = segment.getByte(n3);
                segment.setByte(n3, (byte)(by | 1 << (n &= 7)));
                this.cpu.eflagsCarry = (by & 1 << n) != 0;
            }
        }
    }

    protected final void cmc() {
        this.cpu.eflagsCarry = !this.cpu.eflagsCarry;
    }

    protected final void cbw() {
        this.cpu.eax = (this.cpu.eax & 0x80) == 0 ? (this.cpu.eax &= 0xFFFF00FF) : (this.cpu.eax |= 0xFF00);
    }

    protected final void cwd() {
        this.cpu.edx = (this.cpu.eax & 0x8000) == 0 ? (this.cpu.edx &= 0xFFFF0000) : (this.cpu.edx |= 0xFFFF);
    }

    protected final void cdq() {
        this.cpu.edx = (this.cpu.eax & Integer.MIN_VALUE) != 0 ? -1 : 0;
    }

    protected final void clc() {
        this.cpu.eflagsCarry = false;
    }

    protected final void cld() {
        this.cpu.eflagsDirection = false;
    }

    protected final void cli() {
        this.cpu.eflagsInterruptEnableSoon = false;
        this.cpu.eflagsInterruptEnable = false;
    }

    protected final void cmovb_o32() throws ProcessorException {
        if (this.cpu.eflagsCarry) {
            int n = this.getIntOperand();
            this.setIntOperand(n);
        } else {
            this.skipOperand();
            this.skipOperand();
        }
    }

    protected final void cmovnb_o32() throws ProcessorException {
        if (!this.cpu.eflagsCarry) {
            int n = this.getIntOperand();
            this.setIntOperand(n);
        } else {
            this.skipOperand();
            this.skipOperand();
        }
    }

    protected final void cmovbe_o32() throws ProcessorException {
        if (this.cpu.eflagsCarry || this.cpu.eflagsZero) {
            int n = this.getIntOperand();
            this.setIntOperand(n);
        } else {
            this.skipOperand();
            this.skipOperand();
        }
    }

    protected final void cmovnbe_o32() throws ProcessorException {
        if (!this.cpu.eflagsCarry && !this.cpu.eflagsZero) {
            int n = this.getIntOperand();
            this.setIntOperand(n);
        } else {
            this.skipOperand();
            this.skipOperand();
        }
    }

    protected final void cmovl_o32() throws ProcessorException {
        if (this.cpu.eflagsSign != this.cpu.eflagsOverflow) {
            int n = this.getIntOperand();
            this.setIntOperand(n);
        } else {
            this.skipOperand();
            this.skipOperand();
        }
    }

    protected final void cmovnl_o32() throws ProcessorException {
        if (this.cpu.eflagsSign == this.cpu.eflagsOverflow) {
            int n = this.getIntOperand();
            this.setIntOperand(n);
        } else {
            this.skipOperand();
            this.skipOperand();
        }
    }

    protected final void cmovle_o32() throws ProcessorException {
        if (this.cpu.eflagsZero || this.cpu.eflagsSign != this.cpu.eflagsOverflow) {
            int n = this.getIntOperand();
            this.setIntOperand(n);
        } else {
            this.skipOperand();
            this.skipOperand();
        }
    }

    protected final void cmovnle_o32() throws ProcessorException {
        if (!this.cpu.eflagsZero && this.cpu.eflagsSign == this.cpu.eflagsOverflow) {
            int n = this.getIntOperand();
            this.setIntOperand(n);
        } else {
            this.skipOperand();
            this.skipOperand();
        }
    }

    protected final void cmovo_o32() throws ProcessorException {
        if (this.cpu.eflagsOverflow) {
            int n = this.getIntOperand();
            this.setIntOperand(n);
        } else {
            this.skipOperand();
            this.skipOperand();
        }
    }

    protected final void cmovno_o32() throws ProcessorException {
        if (!this.cpu.eflagsOverflow) {
            int n = this.getIntOperand();
            this.setIntOperand(n);
        } else {
            this.skipOperand();
            this.skipOperand();
        }
    }

    protected final void cmovp_o32() throws ProcessorException {
        if (this.cpu.eflagsParity) {
            int n = this.getIntOperand();
            this.setIntOperand(n);
        } else {
            this.skipOperand();
            this.skipOperand();
        }
    }

    protected final void cmovnp_o32() throws ProcessorException {
        if (!this.cpu.eflagsParity) {
            int n = this.getIntOperand();
            this.setIntOperand(n);
        } else {
            this.skipOperand();
            this.skipOperand();
        }
    }

    protected final void cmovs_o32() throws ProcessorException {
        if (this.cpu.eflagsSign) {
            int n = this.getIntOperand();
            this.setIntOperand(n);
        } else {
            this.skipOperand();
            this.skipOperand();
        }
    }

    protected final void cmovns_o32() throws ProcessorException {
        if (!this.cpu.eflagsSign) {
            int n = this.getIntOperand();
            this.setIntOperand(n);
        } else {
            this.skipOperand();
            this.skipOperand();
        }
    }

    protected final void cmovz_o32() throws ProcessorException {
        if (this.cpu.eflagsZero) {
            int n = this.getIntOperand();
            this.setIntOperand(n);
        } else {
            this.skipOperand();
            this.skipOperand();
        }
    }

    protected final void cmovnz_o32() throws ProcessorException {
        if (!this.cpu.eflagsZero) {
            int n = this.getIntOperand();
            this.setIntOperand(n);
        } else {
            this.skipOperand();
            this.skipOperand();
        }
    }

    protected final void cmp_o8() throws ProcessorException {
        int n = 0xFF & this.getByteOperand();
        int n2 = 0xFF & this.getByteOperand();
        int n3 = n2 - n;
        this.standardFlags((byte)n3);
        boolean bl = this.cpu.eflagsCarry = (n3 & 0xFFFFFF00) != 0;
        this.cpu.eflagsOverflow = (byte)n < 0 ? (byte)n3 < (byte)n2 : (byte)n3 > (byte)n2;
        this.cpu.eflagsAuxiliaryCarry = ((n2 ^ n ^ n3) & 0x10) != 0;
    }

    protected final void cmp_o16() throws ProcessorException {
        int n = 0xFFFF & this.getShortOperand();
        int n2 = 0xFFFF & this.getShortOperand();
        int n3 = n2 - n;
        this.standardFlags((short)n3);
        boolean bl = this.cpu.eflagsCarry = (n3 & 0xFFFF0000) != 0;
        this.cpu.eflagsOverflow = (short)n < 0 ? (short)n3 < (short)n2 : (short)n3 > (short)n2;
        this.cpu.eflagsAuxiliaryCarry = ((n2 ^ n ^ n3) & 0x10) != 0;
    }

    protected final void cmp_o32() throws ProcessorException {
        long l = 0xFFFFFFFFL & (long)this.getIntOperand();
        long l2 = 0xFFFFFFFFL & (long)this.getIntOperand();
        long l3 = l2 - l;
        this.standardFlags((int)l3);
        boolean bl = this.cpu.eflagsCarry = (l3 & 0xFFFFFFFF00000000L) != 0L;
        this.cpu.eflagsOverflow = (int)l < 0 ? (int)l3 < (int)l2 : (int)l3 > (int)l2;
        this.cpu.eflagsAuxiliaryCarry = ((l2 ^ l ^ l3) & 0x10L) != 0L;
    }

    protected final void cmps_o8_a16() throws ProcessorException {
        int n = this.cpu.esi & 0xFFFF;
        int n2 = this.cpu.edi & 0xFFFF;
        int n3 = 0xFF & this.getByteOperand();
        int n4 = 0xFF & this.getByteOperand();
        if (this.cpu.eflagsDirection) {
            --n;
            --n2;
        } else {
            ++n;
            ++n2;
        }
        this.cpu.esi &= 0xFFFF0000;
        this.cpu.esi |= n & 0xFFFF;
        this.cpu.edi &= 0xFFFF0000;
        this.cpu.edi |= n2 & 0xFFFF;
        int n5 = n4 - n3;
        this.standardFlags((byte)n5);
        boolean bl = this.cpu.eflagsCarry = (n5 & 0xFFFFFF00) != 0;
        this.cpu.eflagsOverflow = (byte)n3 < 0 ? (byte)n5 < (byte)n4 : (byte)n5 > (byte)n4;
        this.cpu.eflagsAuxiliaryCarry = ((n4 ^ n3 ^ n5) & 0x10) != 0;
    }

    protected final void cmps_o16_a16() throws ProcessorException {
        int n = this.cpu.esi & 0xFFFF;
        int n2 = this.cpu.edi & 0xFFFF;
        int n3 = 0xFFFF & this.getShortOperand();
        int n4 = 0xFFFF & this.getShortOperand();
        if (this.cpu.eflagsDirection) {
            n -= 2;
            n2 -= 2;
        } else {
            n += 2;
            n2 += 2;
        }
        this.cpu.esi &= 0xFFFF0000;
        this.cpu.esi |= n & 0xFFFF;
        this.cpu.edi &= 0xFFFF0000;
        this.cpu.edi |= n2 & 0xFFFF;
        int n5 = n4 - n3;
        this.standardFlags((short)n5);
        boolean bl = this.cpu.eflagsCarry = (n5 & 0xFFFF0000) != 0;
        this.cpu.eflagsOverflow = (short)n3 < 0 ? (short)n5 < (short)n4 : (short)n5 > (short)n4;
        this.cpu.eflagsAuxiliaryCarry = ((n4 ^ n3 ^ n5) & 0x10) != 0;
    }

    protected final void cmps_o32_a16() {
        int n = this.cpu.esi & 0xFFFF;
        int n2 = this.cpu.edi & 0xFFFF;
        long l = 0xFFFFFFFFL & (long)this.getIntOperand();
        long l2 = 0xFFFFFFFFL & (long)this.getIntOperand();
        if (this.cpu.eflagsDirection) {
            n -= 4;
            n2 -= 4;
        } else {
            n += 4;
            n2 += 4;
        }
        this.cpu.esi &= 0xFFFF0000;
        this.cpu.esi |= n & 0xFFFF;
        this.cpu.edi &= 0xFFFF0000;
        this.cpu.edi |= n2 & 0xFFFF;
        long l3 = l2 - l;
        this.standardFlags((int)l3);
        boolean bl = this.cpu.eflagsCarry = (l3 & 0xFFFFFFFF00000000L) != 0L;
        this.cpu.eflagsOverflow = (int)l < 0 ? (int)l3 < (int)l2 : (int)l3 > (int)l2;
        this.cpu.eflagsAuxiliaryCarry = ((l2 ^ l ^ l3) & 0x10L) != 0L;
    }

    protected final void cmps_o8_a32() {
        int n = 0xFF & this.getByteOperand();
        int n2 = 0xFF & this.getByteOperand();
        if (this.cpu.eflagsDirection) {
            --this.cpu.esi;
            --this.cpu.edi;
        } else {
            ++this.cpu.esi;
            ++this.cpu.edi;
        }
        int n3 = n2 - n;
        this.standardFlags((byte)n3);
        boolean bl = this.cpu.eflagsCarry = (n3 & 0xFFFFFF00) != 0;
        this.cpu.eflagsOverflow = (byte)n < 0 ? (byte)n3 < (byte)n2 : (byte)n3 > (byte)n2;
        this.cpu.eflagsAuxiliaryCarry = ((n2 ^ n ^ n3) & 0x10) != 0;
    }

    protected final void cmps_o16_a32() {
        int n = 0xFFFF & this.getShortOperand();
        int n2 = 0xFFFF & this.getShortOperand();
        if (this.cpu.eflagsDirection) {
            this.cpu.esi -= 2;
            this.cpu.edi -= 2;
        } else {
            this.cpu.esi += 2;
            this.cpu.edi += 2;
        }
        int n3 = n2 - n;
        this.standardFlags((short)n3);
        boolean bl = this.cpu.eflagsCarry = (n3 & 0xFFFF0000) != 0;
        this.cpu.eflagsOverflow = (short)n < 0 ? (short)n3 < (short)n2 : (short)n3 > (short)n2;
        this.cpu.eflagsAuxiliaryCarry = ((n2 ^ n ^ n3) & 0x10) != 0;
    }

    protected final void cmps_o32_a32() {
        long l = 0xFFFFFFFFL & (long)this.getIntOperand();
        long l2 = 0xFFFFFFFFL & (long)this.getIntOperand();
        if (this.cpu.eflagsDirection) {
            this.cpu.esi -= 4;
            this.cpu.edi -= 4;
        } else {
            this.cpu.esi += 4;
            this.cpu.edi += 4;
        }
        long l3 = l2 - l;
        this.standardFlags((int)l3);
        boolean bl = this.cpu.eflagsCarry = (l3 & 0xFFFFFFFF00000000L) != 0L;
        this.cpu.eflagsOverflow = (int)l < 0 ? (int)l3 < (int)l2 : (int)l3 > (int)l2;
        this.cpu.eflagsAuxiliaryCarry = ((l2 ^ l ^ l3) & 0x10L) != 0L;
    }

    protected final void cmpxchg_o8() {
        byte by = this.getByteOperand();
        if ((byte)this.cpu.eax == by) {
            this.setByteOperand(this.getByteOperand());
            this.cpu.eflagsZero = true;
        } else {
            this.cpu.eax = this.cpu.eax & 0xFFFFFF00 | 0xFF & by;
            this.cpu.eflagsZero = false;
            this.skipOperand();
            this.skipOperand();
        }
    }

    protected final void cmpxchg_o16() {
        short s = this.getShortOperand();
        if ((short)this.cpu.eax == s) {
            this.setShortOperand(this.getShortOperand());
            this.cpu.eflagsZero = true;
        } else {
            this.cpu.eax = this.cpu.eax & 0xFFFF0000 | 0xFFFF & s;
            this.cpu.eflagsZero = false;
            this.skipOperand();
            this.skipOperand();
        }
    }

    protected final void cmpxchg_o32() {
        int n = this.getIntOperand();
        if (this.cpu.eax == n) {
            this.setIntOperand(this.getIntOperand());
            this.cpu.eflagsZero = true;
        } else {
            this.cpu.eax = n;
            this.cpu.eflagsZero = false;
            this.skipOperand();
            this.skipOperand();
        }
    }

    protected final void cmpxchg8b() {
        long l = (0xFFFFFFFFL & (long)this.cpu.edx) << 32 | 0xFFFFFFFFL & (long)this.cpu.eax;
        long l2 = this.getLongOperand();
        if (l == l2) {
            this.setLongOperand((0xFFFFFFFFL & (long)this.cpu.ecx) << 32 | 0xFFFFFFFFL & (long)this.cpu.ebx);
            this.cpu.eflagsZero = true;
        } else {
            this.cpu.eax = (int)l2;
            this.cpu.edx = (int)(l2 >>> 32);
            this.cpu.eflagsZero = false;
            this.skipOperand();
        }
    }

    protected final void cwde() {
        this.cpu.eax = (short)this.cpu.eax;
    }

    protected final void daa() {
        boolean bl;
        int n = this.cpu.eax & 0xFF;
        if ((this.cpu.eax & 0xF) > 9 || this.cpu.eflagsAuxiliaryCarry) {
            n += 6;
            this.cpu.eflagsAuxiliaryCarry = true;
        } else {
            this.cpu.eflagsAuxiliaryCarry = false;
        }
        if ((n & 0xFF) > 159 || this.cpu.eflagsCarry) {
            n += 96;
            bl = true;
        } else {
            bl = false;
        }
        this.cpu.eax = this.cpu.eax & 0xFFFFFF00 | 0xFF & n;
        this.standardFlags((byte)n);
        this.cpu.eflagsCarry = bl;
    }

    protected final void das() {
        boolean bl = false;
        int n = 0xFF & this.cpu.eax;
        if ((n & 0xF) > 9 || this.cpu.eflagsAuxiliaryCarry) {
            this.cpu.eflagsAuxiliaryCarry = true;
            this.cpu.eax = this.cpu.eax & 0xFFFFFF00 | this.cpu.eax - 6 & 0xFF;
            boolean bl2 = bl = n < 6 || this.cpu.eflagsCarry;
        }
        if (n > 153 || this.cpu.eflagsCarry) {
            this.cpu.eax = this.cpu.eax & 0xFFFFFF00 | this.cpu.eax - 96 & 0xFF;
            bl = true;
        }
        this.standardFlags((byte)this.cpu.eax);
        this.cpu.eflagsCarry = bl;
    }

    protected final void dec_o8() throws ProcessorException {
        byte by = (byte)(this.getByteOperand() - 1);
        this.setByteOperand(by);
        boolean bl = this.cpu.eflagsCarry;
        this.standardFlags(by);
        this.cpu.eflagsCarry = bl;
        this.cpu.eflagsOverflow = by == 127;
        this.cpu.eflagsAuxiliaryCarry = (by & 0xF) == 15;
    }

    protected final void dec_o16() throws ProcessorException {
        short s = (short)(this.getShortOperand() - 1);
        this.setShortOperand(s);
        boolean bl = this.cpu.eflagsCarry;
        this.standardFlags(s);
        this.cpu.eflagsCarry = bl;
        this.cpu.eflagsOverflow = s == Short.MAX_VALUE;
        this.cpu.eflagsAuxiliaryCarry = (s & 0xF) == 15;
    }

    protected final void dec_o32() throws ProcessorException {
        int n = this.getIntOperand() - 1;
        this.setIntOperand(n);
        boolean bl = this.cpu.eflagsCarry;
        this.standardFlags(n);
        this.cpu.eflagsCarry = bl;
        this.cpu.eflagsOverflow = n == Integer.MAX_VALUE;
        this.cpu.eflagsAuxiliaryCarry = (n & 0xF) == 15;
    }

    protected final void div_o8() throws ProcessorException {
        int n = this.getByteOperand() & 0xFF;
        if (n == 0) {
            throw exceptionDE;
        }
        int n2 = this.cpu.eax & 0xFFFF;
        int n3 = n2 / n;
        if (n3 > 255) {
            throw exceptionDE;
        }
        int n4 = n2 % n;
        this.cpu.eax = this.cpu.eax & 0xFFFF0000 | 0xFF & n3 | 0xFF00 & (n4 <<= 8);
    }

    protected final void div_o16() throws ProcessorException {
        int n = this.getShortOperand() & 0xFFFF;
        if (n == 0) {
            throw exceptionDE;
        }
        long l = (long)this.cpu.edx & 0xFFFFL;
        l <<= 16;
        long l2 = (l |= (long)this.cpu.eax & 0xFFFFL) / (long)n;
        if (l2 > 65535L) {
            throw exceptionDE;
        }
        long l3 = l % (long)n;
        this.cpu.eax = this.cpu.eax & 0xFFFF0000 | (int)(l2 & 0xFFFFL);
        this.cpu.edx = this.cpu.edx & 0xFFFF0000 | (int)(l3 & 0xFFFFL);
    }

    protected final void div_o32() throws ProcessorException {
        long l = 0xFFFFFFFFL & (long)this.getIntOperand();
        if (l == 0L) {
            throw exceptionDE;
        }
        long l2 = this.cpu.edx;
        l2 <<= 32;
        long l3 = (l2 |= 0xFFFFFFFFL & (long)this.cpu.eax) & 1L;
        long l4 = l2 >>> 1;
        long l5 = l4 / l;
        long l6 = l4 % l;
        long l7 = l5 << 1;
        long l8 = (l6 << 1) + l3;
        l7 += l8 / l;
        l8 %= l;
        if (l7 > 0xFFFFFFFFL) {
            throw exceptionDE;
        }
        this.cpu.eax = (int)l7;
        this.cpu.edx = (int)l8;
    }

    protected final void f2xm1() {
        throw new IllegalStateException("Instruction Fails When On MIDP");
    }

    protected final void fadd() {
        double d = this.getDoubleOperand();
        double d2 = this.getDoubleOperand();
        this.validateOperand(d2);
        this.validateOperand(d);
        double d3 = d2 + d;
        if (d2 == Double.NEGATIVE_INFINITY && d == Double.POSITIVE_INFINITY || d2 == Double.POSITIVE_INFINITY && d == Double.NEGATIVE_INFINITY) {
            this.fpu.setInvalidOperation();
            this.fpu.checkExceptions();
        }
        this.setDoubleOperand(d3);
        this.checkResult(d3);
    }

    protected final void fadd_sr() {
        double d = this.getSingleOperand();
        double d2 = this.fpu.ST(0);
        this.validateOperand(d2);
        this.validateOperand(d);
        double d3 = d2 + d;
        if (d2 == Double.NEGATIVE_INFINITY && d == Double.POSITIVE_INFINITY || d2 == Double.POSITIVE_INFINITY && d == Double.NEGATIVE_INFINITY) {
            this.fpu.setInvalidOperation();
            this.fpu.checkExceptions();
        }
        this.fpu.setST(0, d3);
        this.checkResult(d3);
    }

    protected final void fadd_dr() {
        double d = this.getDoubleOperand();
        double d2 = this.fpu.ST(0);
        this.validateOperand(d2);
        this.validateOperand(d);
        double d3 = d2 + d;
        if (d2 == Double.NEGATIVE_INFINITY && d == Double.POSITIVE_INFINITY || d2 == Double.POSITIVE_INFINITY && d == Double.NEGATIVE_INFINITY) {
            this.fpu.setInvalidOperation();
            this.fpu.checkExceptions();
        }
        this.fpu.setST(0, d3);
        this.checkResult(d3);
    }

    protected final void faddp() {
        double d = this.getDoubleOperand();
        double d2 = this.getDoubleOperand();
        this.validateOperand(d2);
        this.validateOperand(d);
        double d3 = d2 + d;
        if (d2 == Double.NEGATIVE_INFINITY && d == Double.POSITIVE_INFINITY || d2 == Double.POSITIVE_INFINITY && d == Double.NEGATIVE_INFINITY) {
            this.fpu.setInvalidOperation();
            this.fpu.checkExceptions();
        }
        this.setDoubleOperand(d3);
        this.fpu.pop();
        this.checkResult(d3);
    }

    protected final void fchs() {
        this.fpu.setST(0, -this.fpu.ST(0));
    }

    protected final void fclex() {
        this.fpu.clearExceptions();
    }

    protected final void fcom() {
        boolean bl;
        double d = this.fpu.ST(0);
        double d2 = this.getDoubleOperand();
        int n = 13;
        this.validateOperand(d);
        this.validateOperand(d2);
        boolean bl2 = bl = Double.isNaN(d) || Double.isNaN(d2);
        if (bl) {
            this.fpu.setInvalidOperation();
            this.fpu.checkExceptions();
        } else {
            n = d > d2 ? 0 : (d < d2 ? 1 : 8);
        }
        this.fpu.conditionCode &= 2;
        this.fpu.conditionCode |= n;
    }

    protected final void fcomp() {
        this.fcom();
        this.fpu.pop();
    }

    protected final void fcompp() {
        this.fcom();
        this.fpu.pop();
        this.fpu.pop();
    }

    protected final void fcom_sr() {
        boolean bl;
        double d = this.fpu.ST(0);
        double d2 = this.getDoubleOperand();
        int n = 13;
        this.validateOperand(d);
        this.validateOperand(d2);
        boolean bl2 = bl = Double.isNaN(d) || Double.isNaN(d2);
        if (bl) {
            this.fpu.setInvalidOperation();
            this.fpu.checkExceptions();
        } else {
            n = d > d2 ? 0 : (d < d2 ? 1 : 8);
        }
        this.fpu.conditionCode &= 2;
        this.fpu.conditionCode |= n;
        this.fpu.pop();
    }

    protected final void fcom_dr() {
        boolean bl;
        double d = this.fpu.ST(0);
        double d2 = this.getDoubleOperand();
        int n = 13;
        this.validateOperand(d);
        this.validateOperand(d2);
        boolean bl2 = bl = Double.isNaN(d) || Double.isNaN(d2);
        if (bl) {
            this.fpu.setInvalidOperation();
            this.fpu.checkExceptions();
        } else {
            n = d > d2 ? 0 : (d < d2 ? 1 : 8);
        }
        this.fpu.conditionCode &= 2;
        this.fpu.conditionCode |= n;
        this.fpu.pop();
    }

    protected final void fcomp_sr() {
        boolean bl;
        double d = this.fpu.ST(0);
        double d2 = this.getDoubleOperand();
        int n = 13;
        this.validateOperand(d);
        this.validateOperand(d2);
        boolean bl2 = bl = Double.isNaN(d) || Double.isNaN(d2);
        if (bl) {
            this.fpu.setInvalidOperation();
            this.fpu.checkExceptions();
        } else {
            n = d > d2 ? 0 : (d < d2 ? 1 : 8);
        }
        this.fpu.conditionCode &= 2;
        this.fpu.conditionCode |= n;
        this.fpu.pop();
    }

    protected final void fcomp_dr() {
        boolean bl;
        double d = this.fpu.ST(0);
        double d2 = this.getDoubleOperand();
        int n = 13;
        this.validateOperand(d);
        this.validateOperand(d2);
        boolean bl2 = bl = Double.isNaN(d) || Double.isNaN(d2);
        if (bl) {
            this.fpu.setInvalidOperation();
            this.fpu.checkExceptions();
        } else {
            n = d > d2 ? 0 : (d < d2 ? 1 : 8);
        }
        this.fpu.conditionCode &= 2;
        this.fpu.conditionCode |= n;
        this.fpu.pop();
    }

    protected final void fdiv() {
        double d = this.getDoubleOperand();
        double d2 = this.getDoubleOperand();
        this.validateOperand(d2);
        this.validateOperand(d);
        double d3 = d2 / d;
        if (d2 == 0.0 && d == 0.0 || Double.isInfinite(d2) && Double.isInfinite(d)) {
            this.fpu.setInvalidOperation();
        }
        if (d == 0.0 && !Double.isNaN(d2)) {
            this.fpu.setZeroDivide();
        }
        this.fpu.checkExceptions();
        this.setDoubleOperand(d3);
        this.checkResult(d3);
    }

    protected final void fdiv_dr() {
        double d = this.getDoubleOperand();
        double d2 = this.fpu.ST(0);
        this.validateOperand(d2);
        this.validateOperand(d);
        double d3 = d2 / d;
        if (d2 == 0.0 && d == 0.0 || Double.isInfinite(d2) && Double.isInfinite(d)) {
            this.fpu.setInvalidOperation();
        }
        if (d == 0.0 && !Double.isNaN(d2)) {
            this.fpu.setZeroDivide();
        }
        this.fpu.checkExceptions();
        this.fpu.setST(0, d3);
        this.checkResult(d3);
    }

    protected final void fdiv_sr() {
        double d = this.getSingleOperand();
        double d2 = this.fpu.ST(0);
        this.validateOperand(d2);
        this.validateOperand(d);
        double d3 = d2 / d;
        if (d2 == 0.0 && d == 0.0 || Double.isInfinite(d2) && Double.isInfinite(d)) {
            this.fpu.setInvalidOperation();
        }
        if (d == 0.0 && !Double.isNaN(d2)) {
            this.fpu.setZeroDivide();
        }
        this.fpu.checkExceptions();
        this.fpu.setST(0, d3);
        this.checkResult(d3);
    }

    protected final void fdivp() {
        double d = this.getDoubleOperand();
        double d2 = this.getDoubleOperand();
        this.validateOperand(d2);
        this.validateOperand(d);
        double d3 = d2 / d;
        if (d2 == 0.0 && d == 0.0 || Double.isInfinite(d2) && Double.isInfinite(d)) {
            this.fpu.setInvalidOperation();
        }
        if (d == 0.0 && !Double.isNaN(d2)) {
            this.fpu.setZeroDivide();
        }
        this.fpu.checkExceptions();
        this.setDoubleOperand(d3);
        this.fpu.pop();
        this.checkResult(d3);
    }

    protected final void fdivr() {
        double d = this.getDoubleOperand();
        double d2 = this.getDoubleOperand();
        this.validateOperand(d);
        this.validateOperand(d2);
        double d3 = d / d2;
        if (d == 0.0 && d2 == 0.0 || Double.isInfinite(d) && Double.isInfinite(d2)) {
            this.fpu.setInvalidOperation();
        }
        if (d2 == 0.0 && !Double.isNaN(d)) {
            this.fpu.setZeroDivide();
        }
        this.fpu.checkExceptions();
        this.setDoubleOperand(d3);
        this.checkResult(d3);
    }

    protected final void fdivr_sr() {
        double d = this.fpu.ST(0);
        double d2 = this.getSingleOperand();
        this.validateOperand(d2);
        this.validateOperand(d);
        double d3 = d2 / d;
        if (d2 == 0.0 && d == 0.0 || Double.isInfinite(d2) && Double.isInfinite(d)) {
            this.fpu.setInvalidOperation();
        }
        if (d == 0.0 && !Double.isNaN(d2)) {
            this.fpu.setZeroDivide();
        }
        this.fpu.checkExceptions();
        this.fpu.setST(0, d3);
        this.checkResult(d3);
    }

    protected final void fdivr_dr() {
        double d = this.fpu.ST(0);
        double d2 = this.getDoubleOperand();
        this.validateOperand(d2);
        this.validateOperand(d);
        double d3 = d2 / d;
        if (d2 == 0.0 && d == 0.0 || Double.isInfinite(d2) && Double.isInfinite(d)) {
            this.fpu.setInvalidOperation();
        }
        if (d == 0.0 && !Double.isNaN(d2)) {
            this.fpu.setZeroDivide();
        }
        this.fpu.checkExceptions();
        this.fpu.setST(0, d3);
        this.checkResult(d3);
    }

    protected final void fdivrp() {
        double d = this.getDoubleOperand();
        double d2 = this.getDoubleOperand();
        this.validateOperand(d);
        this.validateOperand(d2);
        double d3 = d / d2;
        if (d == 0.0 && d2 == 0.0 || Double.isInfinite(d) && Double.isInfinite(d2)) {
            this.fpu.setInvalidOperation();
        }
        if (d2 == 0.0 && !Double.isNaN(d)) {
            this.fpu.setZeroDivide();
        }
        this.fpu.checkExceptions();
        this.setDoubleOperand(d3);
        this.fpu.pop();
        this.checkResult(d3);
    }

    protected final void fidivr_wi() {
        double d = this.fpu.ST(0);
        double d2 = this.getWordIntegerOperand();
        this.validateOperand(d2);
        this.validateOperand(d);
        double d3 = d2 / d;
        if (d2 == 0.0 && d == 0.0 || Double.isInfinite(d2) && Double.isInfinite(d)) {
            this.fpu.setInvalidOperation();
        }
        if (d == 0.0 && !Double.isNaN(d2)) {
            this.fpu.setZeroDivide();
        }
        this.fpu.checkExceptions();
        this.fpu.setST(0, d3);
        this.checkResult(d3);
    }

    protected final void fidivr_di() {
        double d = this.fpu.ST(0);
        double d2 = this.getDoubleIntegerOperand();
        this.validateOperand(d2);
        this.validateOperand(d);
        double d3 = d2 / d;
        if (d2 == 0.0 && d == 0.0 || Double.isInfinite(d2) && Double.isInfinite(d)) {
            this.fpu.setInvalidOperation();
        }
        if (d == 0.0 && !Double.isNaN(d2)) {
            this.fpu.setZeroDivide();
        }
        this.fpu.checkExceptions();
        this.fpu.setST(0, d3);
        this.checkResult(d3);
    }

    protected final void fild_wi() {
        double d = this.getWordIntegerOperand();
        this.validateOperand(d);
        this.fpu.push(d);
    }

    protected final void fild_di() {
        double d = this.getDoubleIntegerOperand();
        this.validateOperand(d);
        this.fpu.push(d);
    }

    protected final void fild_qi() {
        double d = this.getQuadIntegerOperand();
        this.validateOperand(d);
        this.fpu.push(d);
    }

    protected final void fist_wi() {
        double d = this.fpu.ST(0);
        this.validateOperand(d);
        this.setWordIntegerOperand(d);
    }

    protected final void fist_di() {
        double d = this.fpu.ST(0);
        this.validateOperand(d);
        this.setDoubleIntegerOperand(d);
    }

    protected final void fistp_wi() {
        double d = this.fpu.ST(0);
        this.validateOperand(d);
        this.setWordIntegerOperand(d);
        this.fpu.pop();
    }

    protected final void fistp_di() {
        double d = this.fpu.ST(0);
        this.validateOperand(d);
        this.setDoubleIntegerOperand(d);
        this.fpu.pop();
    }

    protected final void fistp_qi() {
        double d = this.fpu.ST(0);
        this.validateOperand(d);
        this.setQuadIntegerOperand(d);
        this.fpu.pop();
    }

    protected final void fld() {
        double d = this.getDoubleOperand();
        this.validateOperand(d);
        this.fpu.push(d);
    }

    protected final void fld_dr() {
        double d = this.getDoubleOperand();
        this.validateOperand(d);
        this.fpu.push(d);
    }

    protected final void fld_sr() {
        double d = this.getSingleOperand();
        this.validateOperand(d);
        this.fpu.push(d);
    }

    protected final void fldz() {
        this.validateOperand(0.0);
        this.fpu.push(0.0);
    }

    protected final void fld1() {
        this.validateOperand(1.0);
        this.fpu.push(1.0);
    }

    protected final void fldcw() {
        this.fpu.setControl(this.getShortOperand());
    }

    protected final void fmul() {
        double d = this.getDoubleOperand();
        double d2 = this.getDoubleOperand();
        this.validateOperand(d);
        this.validateOperand(d2);
        double d3 = d * d2;
        if (Double.isInfinite(d) && d2 == 0.0 || Double.isInfinite(d2) && d == 0.0) {
            this.fpu.setInvalidOperation();
            this.fpu.checkExceptions();
        }
        this.setDoubleOperand(d3);
        this.checkResult(d3);
    }

    protected final void fmul_sr() {
        double d = this.getSingleOperand();
        double d2 = this.fpu.ST(0);
        this.validateOperand(d);
        this.validateOperand(d2);
        double d3 = d * d2;
        if (Double.isInfinite(d) && d2 == 0.0 || Double.isInfinite(d2) && d == 0.0) {
            this.fpu.setInvalidOperation();
            this.fpu.checkExceptions();
        }
        this.fpu.setST(0, d3);
        this.checkResult(d3);
    }

    protected final void fmul_dr() {
        double d = this.getDoubleOperand();
        double d2 = this.fpu.ST(0);
        this.validateOperand(d);
        this.validateOperand(d2);
        double d3 = d * d2;
        if (Double.isInfinite(d) && d2 == 0.0 || Double.isInfinite(d2) && d == 0.0) {
            this.fpu.setInvalidOperation();
            this.fpu.checkExceptions();
        }
        this.fpu.setST(0, d3);
        this.checkResult(d3);
    }

    protected final void fmulp() {
        double d = this.getDoubleOperand();
        double d2 = this.getDoubleOperand();
        this.validateOperand(d);
        this.validateOperand(d2);
        double d3 = d * d2;
        if (Double.isInfinite(d) && d2 == 0.0 || Double.isInfinite(d2) && d == 0.0) {
            this.fpu.setInvalidOperation();
            this.fpu.checkExceptions();
        }
        this.setDoubleOperand(d3);
        this.fpu.pop();
        this.checkResult(d3);
    }

    protected final void fninit() {
        FpuState64 fpuState64 = (FpuState64)this.fpu;
        fpuState64.init();
    }

    protected final void fprem() {
        throw new IllegalStateException("Instruction Fails When On MIDP");
    }

    protected final void fprem1() {
        throw new IllegalStateException("Instruction Fails When On MIDP");
    }

    protected final void frndint() {
        throw new IllegalStateException("Instruction Fails When On MIDP");
    }

    protected final void fscale() {
        throw new IllegalStateException("Instruction Fails When On MIDP");
    }

    protected final void fsincos() {
        throw new IllegalStateException("Instruction Fails When On MIDP");
    }

    protected final void fsqrt() {
        double d = this.fpu.ST(0);
        this.validateOperand(d);
        if (d < 0.0) {
            this.fpu.setInvalidOperation();
            this.fpu.checkExceptions();
        }
        double d2 = Math.sqrt(d);
        this.checkResult(d2);
        this.fpu.setST(0, d2);
    }

    protected final void fst_dr() {
        double d = this.fpu.ST(0);
        this.validateOperand(d);
        this.setDoubleOperand(d);
    }

    protected final void fstp() {
        double d = this.fpu.ST(0);
        this.validateOperand(d);
        this.setDoubleOperand(d);
        this.fpu.pop();
    }

    protected final void fstp_sr() {
        double d = this.fpu.ST(0);
        this.validateOperand(d);
        this.setSingleOperand(d);
        this.fpu.pop();
    }

    protected final void fstp_dr() {
        double d = this.fpu.ST(0);
        this.validateOperand(d);
        this.setDoubleOperand(d);
        this.fpu.pop();
    }

    protected final void fstcw() throws ProcessorException {
        this.setShortOperand((short)this.fpu.getControl());
    }

    protected final void fstsw() throws ProcessorException {
        this.setShortOperand((short)this.fpu.getStatus());
    }

    protected final void fsub() {
        double d = this.getDoubleOperand();
        double d2 = this.getDoubleOperand();
        this.validateOperand(d);
        this.validateOperand(d2);
        double d3 = d2 - d;
        if (d == Double.NEGATIVE_INFINITY && d2 == Double.NEGATIVE_INFINITY || d == Double.POSITIVE_INFINITY && d2 == Double.POSITIVE_INFINITY) {
            this.fpu.setInvalidOperation();
            this.fpu.checkExceptions();
        }
        this.setDoubleOperand(d3);
        this.checkResult(d3);
    }

    protected final void fsub_sr() {
        double d = this.fpu.ST(0);
        double d2 = this.getSingleOperand();
        this.validateOperand(d);
        this.validateOperand(d2);
        double d3 = d - d2;
        if (d == Double.NEGATIVE_INFINITY && d2 == Double.NEGATIVE_INFINITY || d == Double.POSITIVE_INFINITY && d2 == Double.POSITIVE_INFINITY) {
            this.fpu.setInvalidOperation();
            this.fpu.checkExceptions();
        }
        this.fpu.setST(0, d3);
        this.checkResult(d3);
    }

    protected final void fsub_dr() {
        double d = this.fpu.ST(0);
        double d2 = this.getDoubleOperand();
        this.validateOperand(d);
        this.validateOperand(d2);
        double d3 = d - d2;
        if (d == Double.NEGATIVE_INFINITY && d2 == Double.NEGATIVE_INFINITY || d == Double.POSITIVE_INFINITY && d2 == Double.POSITIVE_INFINITY) {
            this.fpu.setInvalidOperation();
            this.fpu.checkExceptions();
        }
        this.fpu.setST(0, d3);
        this.checkResult(d3);
    }

    protected final void fsubp() {
        double d = this.getDoubleOperand();
        double d2 = this.getDoubleOperand();
        this.validateOperand(d);
        this.validateOperand(d2);
        double d3 = d2 - d;
        if (d == Double.NEGATIVE_INFINITY && d2 == Double.NEGATIVE_INFINITY || d == Double.POSITIVE_INFINITY && d2 == Double.POSITIVE_INFINITY) {
            this.fpu.setInvalidOperation();
            this.fpu.checkExceptions();
        }
        this.setDoubleOperand(d3);
        this.fpu.pop();
        this.checkResult(d3);
    }

    protected final void fsubr() {
        double d = this.getDoubleOperand();
        double d2 = this.getDoubleOperand();
        this.validateOperand(d);
        this.validateOperand(d2);
        double d3 = d - d2;
        if (d == Double.NEGATIVE_INFINITY && d2 == Double.NEGATIVE_INFINITY || d == Double.POSITIVE_INFINITY && d2 == Double.POSITIVE_INFINITY) {
            this.fpu.setInvalidOperation();
            this.fpu.checkExceptions();
        }
        this.setDoubleOperand(d3);
        this.checkResult(d3);
    }

    protected final void fsubr_sr() {
        double d = this.getSingleOperand();
        double d2 = this.fpu.ST(0);
        this.validateOperand(d);
        this.validateOperand(d2);
        double d3 = d - d2;
        if (d == Double.NEGATIVE_INFINITY && d2 == Double.NEGATIVE_INFINITY || d == Double.POSITIVE_INFINITY && d2 == Double.POSITIVE_INFINITY) {
            this.fpu.setInvalidOperation();
            this.fpu.checkExceptions();
        }
        this.fpu.setST(0, d3);
        this.checkResult(d3);
    }

    protected final void fsubr_dr() {
        double d = this.getDoubleOperand();
        double d2 = this.fpu.ST(0);
        this.validateOperand(d);
        this.validateOperand(d2);
        double d3 = d - d2;
        if (d == Double.NEGATIVE_INFINITY && d2 == Double.NEGATIVE_INFINITY || d == Double.POSITIVE_INFINITY && d2 == Double.POSITIVE_INFINITY) {
            this.fpu.setInvalidOperation();
            this.fpu.checkExceptions();
        }
        this.fpu.setST(0, d3);
        this.checkResult(d3);
    }

    protected final void fsubrp() {
        double d = this.getDoubleOperand();
        double d2 = this.getDoubleOperand();
        this.validateOperand(d);
        this.validateOperand(d2);
        double d3 = d - d2;
        if (d == Double.NEGATIVE_INFINITY && d2 == Double.NEGATIVE_INFINITY || d == Double.POSITIVE_INFINITY && d2 == Double.POSITIVE_INFINITY) {
            this.fpu.setInvalidOperation();
            this.fpu.checkExceptions();
        }
        this.setDoubleOperand(d3);
        this.fpu.pop();
        this.checkResult(d3);
    }

    protected final void ftst() {
        double d = this.fpu.ST(0);
        double d2 = 0.0;
        int n = 13;
        this.validateOperand(d);
        if (Double.isNaN(d)) {
            this.fpu.setInvalidOperation();
            this.fpu.checkExceptions();
        } else {
            n = d > d2 ? 0 : (d < d2 ? 1 : 8);
        }
        this.fpu.conditionCode &= 2;
        this.fpu.conditionCode |= n;
    }

    protected final void fucom() {
        boolean bl;
        double d = this.fpu.ST(0);
        double d2 = this.getDoubleOperand();
        int n = 13;
        this.validateOperand(d);
        this.validateOperand(d2);
        boolean bl2 = bl = Double.isNaN(d) || Double.isNaN(d2);
        if (!bl) {
            n = d > d2 ? 0 : (d < d2 ? 1 : 8);
        }
        this.fpu.conditionCode &= 2;
        this.fpu.conditionCode |= n;
    }

    protected final void fucomp() {
        boolean bl;
        double d = this.fpu.ST(0);
        double d2 = this.getDoubleOperand();
        int n = 13;
        this.validateOperand(d);
        this.validateOperand(d2);
        boolean bl2 = bl = Double.isNaN(d) || Double.isNaN(d2);
        if (!bl) {
            n = d > d2 ? 0 : (d < d2 ? 1 : 8);
        }
        this.fpu.conditionCode &= 2;
        this.fpu.conditionCode |= n;
        this.fpu.pop();
    }

    protected final void fucompp() {
        boolean bl;
        double d = this.fpu.ST(0);
        double d2 = this.getDoubleOperand();
        int n = 13;
        this.validateOperand(d);
        this.validateOperand(d2);
        boolean bl2 = bl = Double.isNaN(d) || Double.isNaN(d2);
        if (!bl) {
            n = d > d2 ? 0 : (d < d2 ? 1 : 8);
        }
        this.fpu.conditionCode &= 2;
        this.fpu.conditionCode |= n;
        this.fpu.pop();
        this.fpu.pop();
    }

    protected final void fxch() {
        double d = this.fpu.ST(0);
        double d2 = this.getDoubleOperand();
        this.fpu.setST(0, d2);
        this.setDoubleOperand(d);
    }

    protected final void fyl2x() {
        throw new IllegalStateException("Instruction Fails When On MIDP");
    }

    protected final void fyl2xp1() {
        throw new IllegalStateException("Instruction Fails When On MIDP");
    }

    protected final void idiv_o8() throws ProcessorException {
        byte by = this.getByteOperand();
        if (by == 0) {
            throw exceptionDE;
        }
        short s = (short)this.cpu.eax;
        int n = s / by;
        int n2 = s % by;
        if (n > 127 || n < -128) {
            throw exceptionDE;
        }
        this.cpu.eax = this.cpu.eax & 0xFFFF0000 | 0xFF & n | (0xFF & n2) << 8;
    }

    protected final void idiv_o16() throws ProcessorException {
        short s = this.getShortOperand();
        if (s == 0) {
            throw exceptionDE;
        }
        int n = this.cpu.edx << 16 | this.cpu.eax & 0xFFFF;
        int n2 = n / s;
        int n3 = n % s;
        if (n2 > Short.MAX_VALUE || n2 < Short.MIN_VALUE) {
            throw exceptionDE;
        }
        this.cpu.eax = this.cpu.eax & 0xFFFF0000 | 0xFFFF & n2;
        this.cpu.edx = this.cpu.edx & 0xFFFF0000 | 0xFFFF & n3;
    }

    protected final void idiv_o32() throws ProcessorException {
        int n = this.getIntOperand();
        if (n == 0) {
            throw exceptionDE;
        }
        long l = (0xFFFFFFFFL & (long)this.cpu.edx) << 32;
        long l2 = (l |= 0xFFFFFFFFL & (long)this.cpu.eax) / (long)n;
        if (l2 > Integer.MAX_VALUE || l2 < Integer.MIN_VALUE) {
            throw exceptionDE;
        }
        long l3 = l % (long)n;
        this.cpu.eax = (int)l2;
        this.cpu.edx = (int)l3;
    }

    protected final void imul_o16() throws ProcessorException {
        short s = this.getShortOperand();
        short s2 = this.getShortOperand();
        int n = s * s2;
        this.setShortOperand((short)n);
        this.cpu.eflagsCarry = n != (short)n;
        this.cpu.eflagsOverflow = this.cpu.eflagsCarry;
    }

    protected final void imul_o32() throws ProcessorException {
        long l = this.getIntOperand();
        long l2 = this.getIntOperand();
        long l3 = l * l2;
        this.setIntOperand((int)l3);
        this.cpu.eflagsCarry = l3 != (long)((int)l3);
        this.cpu.eflagsOverflow = this.cpu.eflagsCarry;
    }

    protected final void imul_rega_o8() throws ProcessorException {
        byte by = (byte)this.cpu.eax;
        byte by2 = this.getByteOperand();
        int n = by * by2;
        this.cpu.eax = this.cpu.eax & 0xFFFF0000 | n & 0xFFFF;
        this.cpu.eflagsCarry = n != (byte)n;
        this.cpu.eflagsOverflow = this.cpu.eflagsCarry;
    }

    protected final void imul_rega_o16() throws ProcessorException {
        short s = (short)this.cpu.eax;
        short s2 = this.getShortOperand();
        int n = s * s2;
        this.cpu.eax = this.cpu.eax & 0xFFFF0000 | n & 0xFFFF;
        this.cpu.edx = this.cpu.edx & 0xFFFF0000 | n >>> 16;
        this.cpu.eflagsCarry = n != (short)n;
        this.cpu.eflagsOverflow = this.cpu.eflagsCarry;
    }

    protected final void imul_rega_o32() throws ProcessorException {
        long l = this.cpu.eax;
        long l2 = this.getIntOperand();
        long l3 = l * l2;
        this.cpu.eax = (int)l3;
        this.cpu.edx = (int)(l3 >>> 32);
        this.cpu.eflagsCarry = l3 != (long)((int)l3);
        this.cpu.eflagsOverflow = this.cpu.eflagsCarry;
    }

    protected final void inc_o8() throws ProcessorException {
        byte by = (byte)(this.getByteOperand() + 1);
        this.setByteOperand(by);
        boolean bl = this.cpu.eflagsCarry;
        this.standardFlags(by);
        this.cpu.eflagsCarry = bl;
        this.cpu.eflagsOverflow = by == -128;
        this.cpu.eflagsAuxiliaryCarry = (by & 0xF) == 0;
    }

    protected final void inc_o16() throws ProcessorException {
        short s = (short)(this.getShortOperand() + 1);
        this.setShortOperand(s);
        boolean bl = this.cpu.eflagsCarry;
        this.standardFlags(s);
        this.cpu.eflagsCarry = bl;
        this.cpu.eflagsOverflow = s == Short.MIN_VALUE;
        this.cpu.eflagsAuxiliaryCarry = (s & 0xF) == 0;
    }

    protected final void inc_o32() throws ProcessorException {
        int n = this.getIntOperand() + 1;
        this.setIntOperand(n);
        boolean bl = this.cpu.eflagsCarry;
        this.standardFlags(n);
        this.cpu.eflagsCarry = bl;
        this.cpu.eflagsOverflow = n == Integer.MIN_VALUE;
        this.cpu.eflagsAuxiliaryCarry = (n & 0xF) == 0;
    }

    protected final void lea_o16_a16() throws ProcessorException {
        int n = this.getAddressOperand();
        this.setShortOperand((short)n);
    }

    protected final void lea_o32_a32() throws ProcessorException {
        int n = this.getAddressOperand();
        this.setIntOperand(n);
    }

    protected final void lods_o8_a16() throws ProcessorException {
        byte by = this.getByteOperand();
        this.setByteOperand(by);
        int n = this.cpu.esi & 0xFFFF;
        n = this.cpu.eflagsDirection ? --n : ++n;
        this.cpu.esi &= 0xFFFF0000;
        this.cpu.esi |= n & 0xFFFF;
    }

    protected final void lods_o16_a16() throws ProcessorException {
        short s = this.getShortOperand();
        this.setShortOperand(s);
        int n = this.cpu.esi & 0xFFFF;
        n = this.cpu.eflagsDirection ? (n -= 2) : (n += 2);
        this.cpu.esi &= 0xFFFF0000;
        this.cpu.esi |= n & 0xFFFF;
    }

    protected final void lods_o32_a16() throws ProcessorException {
        int n = this.getIntOperand();
        this.setIntOperand(n);
        int n2 = this.cpu.esi & 0xFFFF;
        n2 = this.cpu.eflagsDirection ? (n2 -= 4) : (n2 += 4);
        this.cpu.esi &= 0xFFFF0000;
        this.cpu.esi |= n2 & 0xFFFF;
    }

    protected final void lods_o8_a32() throws ProcessorException {
        byte by = this.getByteOperand();
        this.setByteOperand(by);
        this.cpu.esi = this.cpu.eflagsDirection ? --this.cpu.esi : ++this.cpu.esi;
    }

    protected final void lods_o16_a32() throws ProcessorException {
        short s = this.getShortOperand();
        this.setShortOperand(s);
        this.cpu.esi = this.cpu.eflagsDirection ? (this.cpu.esi -= 2) : (this.cpu.esi += 2);
    }

    protected final void lods_o32_a32() throws ProcessorException {
        int n = this.getIntOperand();
        this.setIntOperand(n);
        this.cpu.esi = this.cpu.eflagsDirection ? (this.cpu.esi -= 4) : (this.cpu.esi += 4);
    }

    protected final void mov_o8() throws ProcessorException {
        byte by = this.getByteOperand();
        this.setByteOperand(by);
    }

    protected final void mov_o16() throws ProcessorException {
        short s = this.getShortOperand();
        if (this.microcodes[this.microcodesPosition] == 25) {
            throw exceptionUD;
        }
        this.setShortOperand(s);
    }

    protected final void mov_o32() throws ProcessorException {
        int n = this.getIntOperand();
        this.setIntOperand(n);
    }

    protected final void movs_o8_a16() throws ProcessorException {
        int n = this.cpu.esi & 0xFFFF;
        int n2 = this.cpu.edi & 0xFFFF;
        byte by = this.getByteOperand();
        this.setByteOperand(by);
        if (this.cpu.eflagsDirection) {
            --n;
            --n2;
        } else {
            ++n;
            ++n2;
        }
        this.cpu.esi &= 0xFFFF0000;
        this.cpu.esi |= n & 0xFFFF;
        this.cpu.edi &= 0xFFFF0000;
        this.cpu.edi |= n2 & 0xFFFF;
    }

    protected final void movs_o16_a16() throws ProcessorException {
        int n = this.cpu.esi & 0xFFFF;
        int n2 = this.cpu.edi & 0xFFFF;
        short s = this.getShortOperand();
        this.setShortOperand(s);
        if (this.cpu.eflagsDirection) {
            n -= 2;
            n2 -= 2;
        } else {
            n += 2;
            n2 += 2;
        }
        this.cpu.esi &= 0xFFFF0000;
        this.cpu.esi |= n & 0xFFFF;
        this.cpu.edi &= 0xFFFF0000;
        this.cpu.edi |= n2 & 0xFFFF;
    }

    protected final void movs_o32_a16() throws ProcessorException {
        int n = this.cpu.esi & 0xFFFF;
        int n2 = this.cpu.edi & 0xFFFF;
        int n3 = this.getIntOperand();
        this.setIntOperand(n3);
        if (this.cpu.eflagsDirection) {
            n -= 4;
            n2 -= 4;
        } else {
            n += 4;
            n2 += 4;
        }
        this.cpu.esi &= 0xFFFF0000;
        this.cpu.esi |= n & 0xFFFF;
        this.cpu.edi &= 0xFFFF0000;
        this.cpu.edi |= n2 & 0xFFFF;
    }

    protected final void movs_o8_a32() throws ProcessorException {
        byte by = this.getByteOperand();
        this.setByteOperand(by);
        if (this.cpu.eflagsDirection) {
            --this.cpu.esi;
            --this.cpu.edi;
        } else {
            ++this.cpu.esi;
            ++this.cpu.edi;
        }
    }

    protected final void movs_o16_a32() throws ProcessorException {
        short s = this.getShortOperand();
        this.setShortOperand(s);
        if (this.cpu.eflagsDirection) {
            this.cpu.esi -= 2;
            this.cpu.edi -= 2;
        } else {
            this.cpu.esi += 2;
            this.cpu.edi += 2;
        }
    }

    protected final void movs_o32_a32() throws ProcessorException {
        int n = this.getIntOperand();
        this.setIntOperand(n);
        if (this.cpu.eflagsDirection) {
            this.cpu.esi -= 4;
            this.cpu.edi -= 4;
        } else {
            this.cpu.esi += 4;
            this.cpu.edi += 4;
        }
    }

    protected final void movsx_o16_o8() throws ProcessorException {
        short s = this.getByteOperand();
        this.setShortOperand(s);
    }

    protected final void movsx_o32_o8() throws ProcessorException {
        byte by = this.getByteOperand();
        this.setIntOperand(by);
    }

    protected final void movsx_o16_o16() throws ProcessorException {
        short s = this.getShortOperand();
        this.setShortOperand(s);
    }

    protected final void movsx_o32_o16() throws ProcessorException {
        short s = this.getShortOperand();
        this.setIntOperand(s);
    }

    protected final void movzx_o16_o8() throws ProcessorException {
        short s = (short)(0xFF & this.getByteOperand());
        this.setShortOperand(s);
    }

    protected final void movzx_o32_o8() throws ProcessorException {
        int n = 0xFF & this.getByteOperand();
        this.setIntOperand(n);
    }

    protected final void movzx_o16_o16() throws ProcessorException {
        short s = this.getShortOperand();
        this.setShortOperand(s);
    }

    protected final void movzx_o32_o16() throws ProcessorException {
        int n = 0xFFFF & this.getShortOperand();
        this.setIntOperand(n);
    }

    protected final void mul_o8() {
        int n = this.cpu.eax & 0xFF;
        int n2 = this.getByteOperand() & 0xFF;
        int n3 = n * n2;
        this.cpu.eax &= 0xFFFF0000;
        this.cpu.eax |= n3 & 0xFFFF;
        this.cpu.eflagsCarry = (0xFF00 & n3) != 0;
        this.cpu.eflagsOverflow = this.cpu.eflagsCarry;
    }

    protected final void mul_o16() throws ProcessorException {
        int n = this.cpu.eax & 0xFFFF;
        int n2 = 0xFFFF & this.getShortOperand();
        int n3 = n * n2;
        this.cpu.eax = this.cpu.eax & 0xFFFF0000 | 0xFFFF & n3;
        this.cpu.edx = this.cpu.edx & 0xFFFF0000 | 0xFFFF & (n3 >>= 16);
        this.cpu.eflagsCarry = (n3 & 0xFFFF) != 0;
        this.cpu.eflagsOverflow = this.cpu.eflagsCarry;
    }

    protected final void mul_o32() throws ProcessorException {
        long l = (long)this.cpu.eax & 0xFFFFFFFFL;
        long l2 = 0xFFFFFFFFL & (long)this.getIntOperand();
        long l3 = l * l2;
        this.cpu.eax = (int)l3;
        this.cpu.edx = (int)(l3 >>>= 32);
        this.cpu.eflagsCarry = l3 != 0L;
        this.cpu.eflagsOverflow = this.cpu.eflagsCarry;
    }

    protected final void neg_o8() throws ProcessorException {
        byte by = this.getByteOperand();
        byte by2 = -by;
        this.setByteOperand(by2);
        this.cpu.eflagsCarry = by2 != 0;
        this.cpu.eflagsOverflow = by2 == -128;
        this.cpu.eflagsAuxiliaryCarry = (by & 0xF) > 0;
        this.cpu.eflagsZero = by2 == 0;
        this.cpu.eflagsParity = parityMap[0xFF & by2];
        this.cpu.eflagsSign = by2 < 0;
    }

    protected final void neg_o16() throws ProcessorException {
        short s = this.getShortOperand();
        short s2 = -s;
        this.setShortOperand(s2);
        this.cpu.eflagsCarry = s2 != 0;
        this.cpu.eflagsOverflow = s2 == Short.MIN_VALUE;
        this.cpu.eflagsAuxiliaryCarry = (s & 0xF) > 0;
        this.cpu.eflagsZero = s2 == 0;
        this.cpu.eflagsParity = parityMap[0xFF & s2];
        this.cpu.eflagsSign = s2 < 0;
    }

    protected final void neg_o32() throws ProcessorException {
        int n = this.getIntOperand();
        int n2 = -n;
        this.setIntOperand(n2);
        this.cpu.eflagsCarry = n2 != 0;
        this.cpu.eflagsOverflow = n2 == Integer.MIN_VALUE;
        this.cpu.eflagsAuxiliaryCarry = (n & 0xF) > 0;
        this.cpu.eflagsZero = n2 == 0;
        this.cpu.eflagsParity = parityMap[0xFF & n2];
        this.cpu.eflagsSign = n2 < 0;
    }

    protected final void not_o8() throws ProcessorException {
        byte by = this.getByteOperand();
        by = ~by;
        this.setByteOperand(by);
    }

    protected final void not_o16() throws ProcessorException {
        short s = this.getShortOperand();
        s = ~s;
        this.setShortOperand(s);
    }

    protected final void not_o32() throws ProcessorException {
        int n = this.getIntOperand();
        this.setIntOperand(n ^= 0xFFFFFFFF);
    }

    protected final void or_o8() throws ProcessorException {
        byte by = (byte)(this.getByteOperand() | this.getByteOperand());
        this.setByteOperand(by);
        this.standardFlags(by);
    }

    protected final void or_o16() throws ProcessorException {
        short s = (short)(this.getShortOperand() | this.getShortOperand());
        this.setShortOperand(s);
        this.standardFlags(s);
    }

    protected final void or_o32() throws ProcessorException {
        int n = this.getIntOperand() | this.getIntOperand();
        this.setIntOperand(n);
        this.standardFlags(n);
    }

    protected final void repe_cmps_o8_a16() throws ProcessorException {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = this.microcodesPosition;
        this.skipOperand();
        this.skipOperand();
        boolean bl = false;
        while ((this.cpu.ecx & 0xFFFF) != 0) {
            bl = true;
            this.microcodesPosition = n4;
            n3 = 0xFF & this.getByteOperand();
            n2 = 0xFF & this.getByteOperand();
            n = this.cpu.esi & 0xFFFF;
            int n5 = this.cpu.edi & 0xFFFF;
            if (this.cpu.eflagsDirection) {
                --n;
                --n5;
            } else {
                ++n;
                ++n5;
            }
            this.cpu.esi &= 0xFFFF0000;
            this.cpu.esi |= n & 0xFFFF;
            this.cpu.edi &= 0xFFFF0000;
            this.cpu.edi |= n5 & 0xFFFF;
            --this.cpu.ecx;
            if (n2 == n3) continue;
            break;
        }
        if (bl) {
            n = n2 - n3;
            this.standardFlags((byte)n);
            boolean bl2 = this.cpu.eflagsCarry = (n & 0xFFFFFF00) != 0;
            this.cpu.eflagsOverflow = (byte)n3 < 0 ? (byte)n < (byte)n2 : (byte)n > (byte)n2;
            this.cpu.eflagsAuxiliaryCarry = ((n2 ^ n3 ^ n) & 0x10) != 0;
        }
    }

    protected final void repe_cmps_o16_a16() throws ProcessorException {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = this.microcodesPosition;
        this.skipOperand();
        this.skipOperand();
        boolean bl = false;
        while ((this.cpu.ecx & 0xFFFF) != 0) {
            bl = true;
            this.microcodesPosition = n4;
            n3 = 0xFFFF & this.getShortOperand();
            n2 = 0xFFFF & this.getShortOperand();
            n = this.cpu.esi & 0xFFFF;
            int n5 = this.cpu.edi & 0xFFFF;
            if (this.cpu.eflagsDirection) {
                n -= 2;
                n5 -= 2;
            } else {
                n += 2;
                n5 += 2;
            }
            this.cpu.esi &= 0xFFFF0000;
            this.cpu.esi |= n & 0xFFFF;
            this.cpu.edi &= 0xFFFF0000;
            this.cpu.edi |= n5 & 0xFFFF;
            --this.cpu.ecx;
            if (n2 == n3) continue;
            break;
        }
        if (bl) {
            n = n2 - n3;
            this.standardFlags((short)n);
            boolean bl2 = this.cpu.eflagsCarry = (n & 0xFFFF0000) != 0;
            this.cpu.eflagsOverflow = (short)n3 < 0 ? (short)n < (short)n2 : (short)n > (short)n2;
            this.cpu.eflagsAuxiliaryCarry = ((n2 ^ n3 ^ n) & 0x10) != 0;
        }
    }

    protected final void repe_cmps_o8_a32() throws ProcessorException {
        this.executeCount += this.cpu.ecx - 1;
        int n = 0;
        int n2 = 0;
        int n3 = this.microcodesPosition;
        this.skipOperand();
        this.skipOperand();
        boolean bl = false;
        while (this.cpu.ecx != 0) {
            bl = true;
            this.microcodesPosition = n3;
            n2 = 0xFF & this.getByteOperand();
            n = 0xFF & this.getByteOperand();
            if (this.cpu.eflagsDirection) {
                --this.cpu.esi;
                --this.cpu.edi;
            } else {
                ++this.cpu.esi;
                ++this.cpu.edi;
            }
            --this.cpu.ecx;
            if (n == n2) continue;
        }
        if (bl) {
            int n4 = n - n2;
            this.standardFlags((byte)n4);
            boolean bl2 = this.cpu.eflagsCarry = (n4 & 0xFFFFFF00) != 0;
            this.cpu.eflagsOverflow = (byte)n2 < 0 ? (byte)n4 < (byte)n : (byte)n4 > (byte)n;
            this.cpu.eflagsAuxiliaryCarry = ((n ^ n2 ^ n4) & 0x10) != 0;
        }
    }

    protected final void repe_cmps_o16_a32() throws ProcessorException {
        this.executeCount += this.cpu.ecx - 1;
        int n = 0;
        int n2 = 0;
        int n3 = this.microcodesPosition;
        this.skipOperand();
        this.skipOperand();
        boolean bl = false;
        while (this.cpu.ecx != 0) {
            bl = true;
            this.microcodesPosition = n3;
            n2 = 0xFFFF & this.getShortOperand();
            n = 0xFFFF & this.getShortOperand();
            if (this.cpu.eflagsDirection) {
                this.cpu.esi -= 2;
                this.cpu.edi -= 2;
            } else {
                this.cpu.esi += 2;
                this.cpu.edi += 2;
            }
            --this.cpu.ecx;
            if (n == n2) continue;
        }
        if (bl) {
            int n4 = n - n2;
            this.standardFlags((short)n4);
            boolean bl2 = this.cpu.eflagsCarry = (n4 & 0xFFFF0000) != 0;
            this.cpu.eflagsOverflow = (short)n2 < 0 ? (short)n4 < (short)n : (short)n4 > (short)n;
            this.cpu.eflagsAuxiliaryCarry = ((n ^ n2 ^ n4) & 0x10) != 0;
        }
    }

    protected final void repe_cmps_o32_a32() throws ProcessorException {
        this.executeCount += this.cpu.ecx - 1;
        long l = 0L;
        long l2 = 0L;
        int n = this.microcodesPosition;
        this.skipOperand();
        this.skipOperand();
        boolean bl = false;
        while (this.cpu.ecx != 0) {
            bl = true;
            this.microcodesPosition = n;
            l2 = 0xFFFFFFFFL & (long)this.getIntOperand();
            l = 0xFFFFFFFFL & (long)this.getIntOperand();
            if (this.cpu.eflagsDirection) {
                this.cpu.esi -= 4;
                this.cpu.edi -= 4;
            } else {
                this.cpu.esi += 4;
                this.cpu.edi += 4;
            }
            --this.cpu.ecx;
            if (l == l2) continue;
        }
        if (bl) {
            long l3 = l - l2;
            this.standardFlags((int)l3);
            boolean bl2 = this.cpu.eflagsCarry = (l3 & 0xFFFFFFFF00000000L) != 0L;
            this.cpu.eflagsOverflow = (int)l2 < 0 ? (int)l3 < (int)l : (int)l3 > (int)l;
            this.cpu.eflagsAuxiliaryCarry = ((l ^ l2 ^ l3) & 0x10L) != 0L;
        }
    }

    protected final void repne_cmps_o8_a32() throws ProcessorException {
        this.executeCount += this.cpu.ecx - 1;
        int n = 0;
        int n2 = 0;
        int n3 = this.microcodesPosition;
        this.skipOperand();
        this.skipOperand();
        boolean bl = false;
        while (this.cpu.ecx != 0) {
            bl = true;
            this.microcodesPosition = n3;
            n2 = 0xFF & this.getByteOperand();
            n = 0xFF & this.getByteOperand();
            if (this.cpu.eflagsDirection) {
                --this.cpu.esi;
                --this.cpu.edi;
            } else {
                ++this.cpu.esi;
                ++this.cpu.edi;
            }
            --this.cpu.ecx;
            if (n != n2) continue;
        }
        if (bl) {
            int n4 = n - n2;
            this.standardFlags((byte)n4);
            boolean bl2 = this.cpu.eflagsCarry = (n4 & 0xFFFFFF00) != 0;
            this.cpu.eflagsOverflow = (byte)n2 < 0 ? (byte)n4 < (byte)n : (byte)n4 > (byte)n;
            this.cpu.eflagsAuxiliaryCarry = ((n ^ n2 ^ n4) & 0x10) != 0;
        }
    }

    protected final void repne_cmps_o16_a32() throws ProcessorException {
        this.executeCount += this.cpu.ecx - 1;
        int n = 0;
        int n2 = 0;
        int n3 = this.microcodesPosition;
        this.skipOperand();
        this.skipOperand();
        boolean bl = false;
        while (this.cpu.ecx != 0) {
            bl = true;
            this.microcodesPosition = n3;
            n2 = 0xFFFF & this.getShortOperand();
            n = 0xFFFF & this.getShortOperand();
            if (this.cpu.eflagsDirection) {
                this.cpu.esi -= 2;
                this.cpu.edi -= 2;
            } else {
                this.cpu.esi += 2;
                this.cpu.edi += 2;
            }
            --this.cpu.ecx;
            if (n != n2) continue;
        }
        if (bl) {
            int n4 = n - n2;
            this.standardFlags((short)n4);
            boolean bl2 = this.cpu.eflagsCarry = (n4 & 0xFFFF0000) != 0;
            this.cpu.eflagsOverflow = (short)n2 < 0 ? (short)n4 < (short)n : (short)n4 > (short)n;
            this.cpu.eflagsAuxiliaryCarry = ((n ^ n2 ^ n4) & 0x10) != 0;
        }
    }

    protected final void repne_cmps_o32_a32() throws ProcessorException {
        this.executeCount += this.cpu.ecx - 1;
        long l = 0L;
        long l2 = 0L;
        int n = this.microcodesPosition;
        this.skipOperand();
        this.skipOperand();
        boolean bl = false;
        while (this.cpu.ecx != 0) {
            bl = true;
            this.microcodesPosition = n;
            l2 = 0xFFFFFFFFL & (long)this.getIntOperand();
            l = 0xFFFFFFFFL & (long)this.getIntOperand();
            if (this.cpu.eflagsDirection) {
                this.cpu.esi -= 4;
                this.cpu.edi -= 4;
            } else {
                this.cpu.esi += 4;
                this.cpu.edi += 4;
            }
            --this.cpu.ecx;
            if (l != l2) continue;
        }
        if (bl) {
            long l3 = l - l2;
            this.standardFlags((int)l3);
            boolean bl2 = this.cpu.eflagsCarry = (l3 & 0xFFFFFFFF00000000L) != 0L;
            this.cpu.eflagsOverflow = (int)l2 < 0 ? (int)l3 < (int)l : (int)l3 > (int)l;
            this.cpu.eflagsAuxiliaryCarry = ((l ^ l2 ^ l3) & 0x10L) != 0L;
        }
    }

    protected final void rep_lods_o8_a32() {
        this.executeCount += this.cpu.ecx - 1;
        int n = this.microcodesPosition;
        this.skipOperand();
        this.skipOperand();
        while (this.cpu.ecx != 0) {
            this.microcodesPosition = n;
            this.setByteOperand(this.getByteOperand());
            this.cpu.esi = this.cpu.eflagsDirection ? --this.cpu.esi : ++this.cpu.esi;
            --this.cpu.ecx;
        }
    }

    protected final void rep_lods_o16_a32() {
        this.executeCount += this.cpu.ecx - 1;
        int n = this.microcodesPosition;
        this.skipOperand();
        this.skipOperand();
        while (this.cpu.ecx != 0) {
            this.microcodesPosition = n;
            this.setShortOperand(this.getShortOperand());
            this.cpu.esi = this.cpu.eflagsDirection ? (this.cpu.esi -= 2) : (this.cpu.esi += 2);
            --this.cpu.ecx;
        }
    }

    protected final void rep_lods_o32_a32() {
        this.executeCount += this.cpu.ecx - 1;
        int n = this.microcodesPosition;
        this.skipOperand();
        this.skipOperand();
        while (this.cpu.ecx != 0) {
            this.microcodesPosition = n;
            this.setIntOperand(this.getIntOperand());
            this.cpu.esi = this.cpu.eflagsDirection ? (this.cpu.esi -= 4) : (this.cpu.esi += 4);
            --this.cpu.ecx;
        }
    }

    protected final void rep_movs_o8_a16() throws ProcessorException {
        int n = this.microcodesPosition;
        this.skipOperand();
        this.skipOperand();
        while ((this.cpu.ecx & 0xFFFF) != 0) {
            this.microcodesPosition = n;
            int n2 = this.cpu.esi & 0xFFFF;
            int n3 = this.cpu.edi & 0xFFFF;
            byte by = this.getByteOperand();
            this.setByteOperand(by);
            if (this.cpu.eflagsDirection) {
                --n2;
                --n3;
            } else {
                ++n2;
                ++n3;
            }
            this.cpu.esi &= 0xFFFF0000;
            this.cpu.esi |= n2 & 0xFFFF;
            this.cpu.edi &= 0xFFFF0000;
            this.cpu.edi |= n3 & 0xFFFF;
            --this.cpu.ecx;
        }
    }

    protected final void rep_movs_o16_a16() throws ProcessorException {
        this.executeCount += this.cpu.ecx - 1;
        int n = this.microcodesPosition;
        this.skipOperand();
        this.skipOperand();
        this.executeCount += (this.cpu.ecx & 0xFFFF) - 1;
        while ((this.cpu.ecx & 0xFFFF) != 0) {
            this.microcodesPosition = n;
            int n2 = this.cpu.esi & 0xFFFF;
            int n3 = this.cpu.edi & 0xFFFF;
            short s = this.getShortOperand();
            this.setShortOperand(s);
            if (this.cpu.eflagsDirection) {
                n2 -= 2;
                n3 -= 2;
            } else {
                n2 += 2;
                n3 += 2;
            }
            this.cpu.esi &= 0xFFFF0000;
            this.cpu.esi |= n2 & 0xFFFF;
            this.cpu.edi &= 0xFFFF0000;
            this.cpu.edi |= n3 & 0xFFFF;
            --this.cpu.ecx;
        }
    }

    protected final void rep_movs_o32_a16() throws ProcessorException {
        int n = this.microcodesPosition;
        this.skipOperand();
        this.skipOperand();
        while ((this.cpu.ecx & 0xFFFF) != 0) {
            this.microcodesPosition = n;
            int n2 = this.cpu.esi & 0xFFFF;
            int n3 = this.cpu.edi & 0xFFFF;
            int n4 = this.getIntOperand();
            this.setIntOperand(n4);
            if (this.cpu.eflagsDirection) {
                n2 -= 4;
                n3 -= 4;
            } else {
                n2 += 4;
                n3 += 4;
            }
            this.cpu.esi &= 0xFFFF0000;
            this.cpu.esi |= n2 & 0xFFFF;
            this.cpu.edi &= 0xFFFF0000;
            this.cpu.edi |= n3 & 0xFFFF;
            --this.cpu.ecx;
        }
    }

    protected final void rep_movs_o8_a32() throws ProcessorException {
        this.executeCount += this.cpu.ecx - 1;
        int n = this.microcodesPosition;
        this.skipOperand();
        this.skipOperand();
        while (this.cpu.ecx != 0) {
            this.microcodesPosition = n;
            byte by = this.getByteOperand();
            this.setByteOperand(by);
            if (this.cpu.eflagsDirection) {
                --this.cpu.esi;
                --this.cpu.edi;
            } else {
                ++this.cpu.esi;
                ++this.cpu.edi;
            }
            --this.cpu.ecx;
        }
    }

    protected final void rep_movs_o16_a32() throws ProcessorException {
        this.executeCount += this.cpu.ecx - 1;
        int n = this.microcodesPosition;
        this.skipOperand();
        this.skipOperand();
        while (this.cpu.ecx != 0) {
            this.microcodesPosition = n;
            short s = this.getShortOperand();
            this.setShortOperand(s);
            if (this.cpu.eflagsDirection) {
                this.cpu.esi -= 2;
                this.cpu.edi -= 2;
            } else {
                this.cpu.esi += 2;
                this.cpu.edi += 2;
            }
            --this.cpu.ecx;
        }
    }

    protected final void rep_movs_o32_a32() throws ProcessorException {
        this.executeCount += this.cpu.ecx - 1;
        int n = this.microcodesPosition;
        this.skipOperand();
        this.skipOperand();
        while (this.cpu.ecx != 0) {
            this.microcodesPosition = n;
            int n2 = this.getIntOperand();
            this.setIntOperand(n2);
            if (this.cpu.eflagsDirection) {
                this.cpu.esi -= 4;
                this.cpu.edi -= 4;
            } else {
                this.cpu.esi += 4;
                this.cpu.edi += 4;
            }
            --this.cpu.ecx;
        }
    }

    protected final void repe_scas_o8_a16() throws ProcessorException {
        int n;
        int n2 = this.getByteOperand() & 0xFF;
        int n3 = 0;
        int n4 = this.microcodesPosition;
        this.skipOperand();
        boolean bl = false;
        while ((this.cpu.ecx & 0xFFFF) != 0) {
            bl = true;
            this.microcodesPosition = n4;
            n = this.cpu.edi & 0xFFFF;
            n3 = this.getByteOperand() & 0xFF;
            n = this.cpu.eflagsDirection ? --n : ++n;
            this.cpu.edi &= 0xFFFF0000;
            this.cpu.edi |= n & 0xFFFF;
            --this.cpu.ecx;
            if (n2 == n3) continue;
            break;
        }
        if (bl) {
            n = n2 - n3;
            this.standardFlags((byte)n);
            boolean bl2 = this.cpu.eflagsCarry = (n & 0xFFFFFF00) != 0;
            this.cpu.eflagsOverflow = (byte)n3 < 0 ? (byte)n < (byte)n2 : (byte)n > (byte)n2;
            this.cpu.eflagsAuxiliaryCarry = ((n2 ^ n3 ^ n) & 0x10) != 0;
        }
    }

    protected final void repe_scas_o16_a16() throws ProcessorException {
        int n;
        int n2 = this.getShortOperand() & 0xFFFF;
        int n3 = 0;
        int n4 = this.microcodesPosition;
        this.skipOperand();
        boolean bl = false;
        while ((this.cpu.ecx & 0xFFFF) != 0) {
            bl = true;
            this.microcodesPosition = n4;
            n = this.cpu.edi & 0xFFFF;
            n3 = this.getShortOperand() & 0xFFFF;
            n = this.cpu.eflagsDirection ? (n -= 2) : (n += 2);
            this.cpu.edi &= 0xFFFF0000;
            this.cpu.edi |= n & 0xFFFF;
            --this.cpu.ecx;
            if (n2 == n3) continue;
            break;
        }
        if (bl) {
            n = n2 - n3;
            this.standardFlags((short)n);
            boolean bl2 = this.cpu.eflagsCarry = (n & 0xFFFF0000) != 0;
            this.cpu.eflagsOverflow = (short)n3 < 0 ? (short)n < (short)n2 : (short)n > (short)n2;
            this.cpu.eflagsAuxiliaryCarry = ((n2 ^ n3 ^ n) & 0x10) != 0;
        }
    }

    protected final void repe_scas_o32_a16() throws ProcessorException {
        long l = (long)this.getIntOperand() & 0xFFFFFFFFL;
        long l2 = 0L;
        int n = this.microcodesPosition;
        this.skipOperand();
        boolean bl = false;
        while ((this.cpu.ecx & 0xFFFF) != 0) {
            bl = true;
            this.microcodesPosition = n;
            int n2 = this.cpu.edi & 0xFFFF;
            l2 = (long)this.getIntOperand() & 0xFFFFFFFFL;
            n2 = this.cpu.eflagsDirection ? (n2 -= 4) : (n2 += 4);
            this.cpu.edi &= 0xFFFF0000;
            this.cpu.edi |= n2 & 0xFFFF;
            --this.cpu.ecx;
            if (l == l2) continue;
            break;
        }
        if (bl) {
            long l3 = l - l2;
            this.standardFlags((int)l3);
            boolean bl2 = this.cpu.eflagsCarry = (l3 & 0xFFFFFFFF00000000L) != 0L;
            this.cpu.eflagsOverflow = (int)l2 < 0 ? (int)l3 < (int)l : (int)l3 > (int)l;
            this.cpu.eflagsAuxiliaryCarry = ((l ^ l2 ^ l3) & 0x10L) != 0L;
        }
    }

    protected final void repe_scas_o8_a32() throws ProcessorException {
        this.executeCount += this.cpu.ecx - 1;
        int n = this.getByteOperand() & 0xFF;
        int n2 = 0;
        int n3 = this.microcodesPosition;
        this.skipOperand();
        boolean bl = false;
        while (this.cpu.ecx != 0) {
            bl = true;
            this.microcodesPosition = n3;
            n2 = this.getByteOperand() & 0xFF;
            this.cpu.edi = this.cpu.eflagsDirection ? --this.cpu.edi : ++this.cpu.edi;
            --this.cpu.ecx;
            if (n == n2) continue;
        }
        if (bl) {
            int n4 = n - n2;
            this.standardFlags((byte)n4);
            boolean bl2 = this.cpu.eflagsCarry = (n4 & 0xFFFFFF00) != 0;
            this.cpu.eflagsOverflow = (byte)n2 < 0 ? (byte)n4 < (byte)n : (byte)n4 > (byte)n;
            this.cpu.eflagsAuxiliaryCarry = ((n ^ n2 ^ n4) & 0x10) != 0;
        }
    }

    protected final void repe_scas_o16_a32() throws ProcessorException {
        this.executeCount += this.cpu.ecx - 1;
        int n = this.getShortOperand() & 0xFFFF;
        int n2 = 0;
        int n3 = this.microcodesPosition;
        this.skipOperand();
        boolean bl = false;
        while (this.cpu.ecx != 0) {
            bl = true;
            this.microcodesPosition = n3;
            n2 = this.getShortOperand() & 0xFFFF;
            this.cpu.edi = this.cpu.eflagsDirection ? (this.cpu.edi -= 2) : (this.cpu.edi += 2);
            --this.cpu.ecx;
            if (n == n2) continue;
        }
        if (bl) {
            int n4 = n - n2;
            this.standardFlags((short)n4);
            boolean bl2 = this.cpu.eflagsCarry = (n4 & 0xFFFF0000) != 0;
            this.cpu.eflagsOverflow = (short)n2 < 0 ? (short)n4 < (short)n : (short)n4 > (short)n;
            this.cpu.eflagsAuxiliaryCarry = ((n ^ n2 ^ n4) & 0x10) != 0;
        }
    }

    protected final void repe_scas_o32_a32() throws ProcessorException {
        this.executeCount += this.cpu.ecx - 1;
        long l = (long)this.getIntOperand() & 0xFFFFFFFFL;
        long l2 = 0L;
        int n = this.microcodesPosition;
        this.skipOperand();
        boolean bl = false;
        while (this.cpu.ecx != 0) {
            bl = true;
            this.microcodesPosition = n;
            l2 = (long)this.getIntOperand() & 0xFFFFFFFFL;
            this.cpu.edi = this.cpu.eflagsDirection ? (this.cpu.edi -= 4) : (this.cpu.edi += 4);
            --this.cpu.ecx;
            if (l == l2) continue;
        }
        if (bl) {
            long l3 = l - l2;
            this.standardFlags((int)l3);
            boolean bl2 = this.cpu.eflagsCarry = (l3 & 0xFFFFFFFF00000000L) != 0L;
            this.cpu.eflagsOverflow = (int)l2 < 0 ? (int)l3 < (int)l : (int)l3 > (int)l;
            this.cpu.eflagsAuxiliaryCarry = ((l ^ l2 ^ l3) & 0x10L) != 0L;
        }
    }

    protected final void repne_scas_o8_a16() throws ProcessorException {
        int n;
        int n2 = this.getByteOperand() & 0xFF;
        int n3 = 0;
        int n4 = this.microcodesPosition;
        this.skipOperand();
        boolean bl = false;
        while ((this.cpu.ecx & 0xFFFF) != 0) {
            bl = true;
            this.microcodesPosition = n4;
            n = this.cpu.edi & 0xFFFF;
            n3 = this.getByteOperand() & 0xFF;
            n = this.cpu.eflagsDirection ? --n : ++n;
            this.cpu.edi &= 0xFFFF0000;
            this.cpu.edi |= n & 0xFFFF;
            --this.cpu.ecx;
            if (n2 != n3) continue;
            break;
        }
        if (bl) {
            n = n2 - n3;
            this.standardFlags((byte)n);
            boolean bl2 = this.cpu.eflagsCarry = (n & 0xFFFFFF00) != 0;
            this.cpu.eflagsOverflow = (byte)n3 < 0 ? (byte)n < (byte)n2 : (byte)n > (byte)n2;
            this.cpu.eflagsAuxiliaryCarry = ((n2 ^ n3 ^ n) & 0x10) != 0;
        }
    }

    protected final void repne_scas_o16_a16() throws ProcessorException {
        int n;
        int n2 = this.getShortOperand() & 0xFFFF;
        int n3 = 0;
        int n4 = this.microcodesPosition;
        this.skipOperand();
        boolean bl = false;
        while ((this.cpu.ecx & 0xFFFF) != 0) {
            bl = true;
            this.microcodesPosition = n4;
            n = this.cpu.edi & 0xFFFF;
            n3 = this.getShortOperand() & 0xFFFF;
            n = this.cpu.eflagsDirection ? (n -= 2) : (n += 2);
            this.cpu.edi &= 0xFFFF0000;
            this.cpu.edi |= n & 0xFFFF;
            --this.cpu.ecx;
            if (n2 != n3) continue;
            break;
        }
        if (bl) {
            n = n2 - n3;
            this.standardFlags((short)n);
            boolean bl2 = this.cpu.eflagsCarry = (n & 0xFFFF0000) != 0;
            this.cpu.eflagsOverflow = (short)n3 < 0 ? (short)n < (short)n2 : (short)n > (short)n2;
            this.cpu.eflagsAuxiliaryCarry = ((n2 ^ n3 ^ n) & 0x10) != 0;
        }
    }

    protected final void repne_scas_o32_a16() throws ProcessorException {
        long l = (long)this.getIntOperand() & 0xFFFFFFFFL;
        long l2 = 0L;
        int n = this.microcodesPosition;
        this.skipOperand();
        boolean bl = false;
        while ((this.cpu.ecx & 0xFFFF) != 0) {
            bl = true;
            this.microcodesPosition = n;
            int n2 = this.cpu.edi & 0xFFFF;
            l2 = (long)this.getIntOperand() & 0xFFFFFFFFL;
            n2 = this.cpu.eflagsDirection ? (n2 -= 4) : (n2 += 4);
            this.cpu.edi &= 0xFFFF0000;
            this.cpu.edi |= n2 & 0xFFFF;
            --this.cpu.ecx;
            if (l != l2) continue;
            break;
        }
        if (bl) {
            long l3 = l - l2;
            this.standardFlags((int)l3);
            boolean bl2 = this.cpu.eflagsCarry = (l3 & 0xFFFFFFFF00000000L) != 0L;
            this.cpu.eflagsOverflow = (int)l2 < 0 ? (int)l3 < (int)l : (int)l3 > (int)l;
            this.cpu.eflagsAuxiliaryCarry = ((l ^ l2 ^ l3) & 0x10L) != 0L;
        }
    }

    protected final void repne_scas_o8_a32() throws ProcessorException {
        this.executeCount += this.cpu.ecx - 1;
        int n = this.getByteOperand() & 0xFF;
        int n2 = 0;
        int n3 = this.microcodesPosition;
        this.skipOperand();
        boolean bl = false;
        while (this.cpu.ecx != 0) {
            bl = true;
            this.microcodesPosition = n3;
            n2 = this.getByteOperand() & 0xFF;
            this.cpu.edi = this.cpu.eflagsDirection ? --this.cpu.edi : ++this.cpu.edi;
            --this.cpu.ecx;
            if (n != n2) continue;
        }
        if (bl) {
            int n4 = n - n2;
            this.standardFlags((byte)n4);
            boolean bl2 = this.cpu.eflagsCarry = (n4 & 0xFFFFFF00) != 0;
            this.cpu.eflagsOverflow = (byte)n2 < 0 ? (byte)n4 < (byte)n : (byte)n4 > (byte)n;
            this.cpu.eflagsAuxiliaryCarry = ((n ^ n2 ^ n4) & 0x10) != 0;
        }
    }

    protected final void repne_scas_o16_a32() throws ProcessorException {
        this.executeCount += this.cpu.ecx - 1;
        int n = this.getShortOperand() & 0xFFFF;
        int n2 = 0;
        int n3 = this.microcodesPosition;
        this.skipOperand();
        boolean bl = false;
        while (this.cpu.ecx != 0) {
            bl = true;
            this.microcodesPosition = n3;
            n2 = this.getShortOperand() & 0xFFFF;
            this.cpu.edi = this.cpu.eflagsDirection ? (this.cpu.edi -= 2) : (this.cpu.edi += 2);
            --this.cpu.ecx;
            if (n != n2) continue;
        }
        if (bl) {
            int n4 = n - n2;
            this.standardFlags((short)n4);
            boolean bl2 = this.cpu.eflagsCarry = (n4 & 0xFFFF0000) != 0;
            this.cpu.eflagsOverflow = (short)n2 < 0 ? (short)n4 < (short)n : (short)n4 > (short)n;
            this.cpu.eflagsAuxiliaryCarry = ((n ^ n2 ^ n4) & 0x10) != 0;
        }
    }

    protected final void repne_scas_o32_a32() throws ProcessorException {
        this.executeCount += this.cpu.ecx - 1;
        long l = (long)this.getIntOperand() & 0xFFFFFFFFL;
        long l2 = 0L;
        int n = this.microcodesPosition;
        this.skipOperand();
        boolean bl = false;
        while (this.cpu.ecx != 0) {
            bl = true;
            this.microcodesPosition = n;
            l2 = (long)this.getIntOperand() & 0xFFFFFFFFL;
            this.cpu.edi = this.cpu.eflagsDirection ? (this.cpu.edi -= 4) : (this.cpu.edi += 4);
            --this.cpu.ecx;
            if (l != l2) continue;
        }
        if (bl) {
            long l3 = l - l2;
            this.standardFlags((int)l3);
            boolean bl2 = this.cpu.eflagsCarry = (l3 & 0xFFFFFFFF00000000L) != 0L;
            this.cpu.eflagsOverflow = (int)l2 < 0 ? (int)l3 < (int)l : (int)l3 > (int)l;
            this.cpu.eflagsAuxiliaryCarry = ((l ^ l2 ^ l3) & 0x10L) != 0L;
        }
    }

    protected final void rep_stos_o8_a16() throws ProcessorException {
        byte by = this.getByteOperand();
        int n = this.microcodesPosition;
        this.skipOperand();
        while ((this.cpu.ecx & 0xFFFF) != 0) {
            int n2 = this.cpu.edi & 0xFFFF;
            this.microcodesPosition = n;
            this.setByteOperand(by);
            n2 = this.cpu.eflagsDirection ? --n2 : ++n2;
            this.cpu.edi &= 0xFFFF0000;
            this.cpu.edi |= n2 & 0xFFFF;
            --this.cpu.ecx;
        }
    }

    protected final void rep_stos_o16_a16() throws ProcessorException {
        short s = this.getShortOperand();
        int n = this.microcodesPosition;
        this.skipOperand();
        while ((this.cpu.ecx & 0xFFFF) != 0) {
            int n2 = this.cpu.edi & 0xFFFF;
            this.microcodesPosition = n;
            this.setShortOperand(s);
            n2 = this.cpu.eflagsDirection ? (n2 -= 2) : (n2 += 2);
            this.cpu.edi &= 0xFFFF0000;
            this.cpu.edi |= n2 & 0xFFFF;
            --this.cpu.ecx;
        }
    }

    protected final void rep_stos_o32_a16() throws ProcessorException {
        int n = this.getIntOperand();
        int n2 = this.microcodesPosition;
        this.skipOperand();
        while ((this.cpu.ecx & 0xFFFF) != 0) {
            int n3 = this.cpu.edi & 0xFFFF;
            this.microcodesPosition = n2;
            this.setIntOperand(n);
            n3 = this.cpu.eflagsDirection ? (n3 -= 4) : (n3 += 4);
            this.cpu.edi &= 0xFFFF0000;
            this.cpu.edi |= n3 & 0xFFFF;
            --this.cpu.ecx;
        }
    }

    protected final void rep_stos_o8_a32() throws ProcessorException {
        this.executeCount += this.cpu.ecx - 1;
        byte by = this.getByteOperand();
        int n = this.microcodesPosition;
        this.skipOperand();
        while (this.cpu.ecx != 0) {
            this.microcodesPosition = n;
            this.setByteOperand(by);
            this.cpu.edi = this.cpu.eflagsDirection ? --this.cpu.edi : ++this.cpu.edi;
            --this.cpu.ecx;
        }
    }

    protected final void rep_stos_o16_a32() throws ProcessorException {
        this.executeCount += this.cpu.ecx - 1;
        short s = this.getShortOperand();
        int n = this.microcodesPosition;
        this.skipOperand();
        while (this.cpu.ecx != 0) {
            this.microcodesPosition = n;
            this.setShortOperand(s);
            this.cpu.edi = this.cpu.eflagsDirection ? (this.cpu.edi -= 2) : (this.cpu.edi += 2);
            --this.cpu.ecx;
        }
    }

    protected final void rep_stos_o32_a32() throws ProcessorException {
        this.executeCount += this.cpu.ecx - 1;
        int n = this.getIntOperand();
        int n2 = this.microcodesPosition;
        this.skipOperand();
        while (this.cpu.ecx != 0) {
            this.microcodesPosition = n2;
            this.setIntOperand(n);
            this.cpu.edi = this.cpu.eflagsDirection ? (this.cpu.edi -= 4) : (this.cpu.edi += 4);
            --this.cpu.ecx;
        }
    }

    protected final void rcl_o8() throws ProcessorException {
        int n = (this.getByteOperand() & 0x1F) % 9;
        if (n > 0) {
            int n2 = 0xFF & this.getByteOperand();
            int n3 = this.cpu.eflagsCarry ? 1 : 0;
            n2 |= n3 << 8;
            n2 = n2 << n | n2 >>> 9 - n;
            this.setByteOperand((byte)n2);
            boolean bl = this.cpu.eflagsCarry = (n2 & 0x100) != 0;
            if (n == 1) {
                boolean bl2 = (n2 & 0x80) != 0;
                this.cpu.eflagsOverflow = bl2 ^ this.cpu.eflagsCarry;
            }
        } else {
            this.skipOperand();
            this.skipOperand();
        }
    }

    protected final void rcl_o16() throws ProcessorException {
        int n = (this.getByteOperand() & 0x1F) % 17;
        if (n > 0) {
            int n2 = 0xFFFF & this.getShortOperand();
            int n3 = this.cpu.eflagsCarry ? 1 : 0;
            n2 |= n3 << 16;
            n2 = n2 << n | n2 >>> 17 - n;
            this.setShortOperand((short)n2);
            boolean bl = this.cpu.eflagsCarry = (n2 & 0x10000) != 0;
            if (n == 1) {
                boolean bl2 = (n2 & 0x8000) != 0;
                this.cpu.eflagsOverflow = bl2 ^ this.cpu.eflagsCarry;
            }
        } else {
            this.skipOperand();
            this.skipOperand();
        }
    }

    protected final void rcl_o32() throws ProcessorException {
        int n = this.getByteOperand() & 0x1F;
        if (n > 0) {
            long l = 0xFFFFFFFFL & (long)this.getIntOperand();
            long l2 = this.cpu.eflagsCarry ? 1L : 0L;
            l |= l2 << 32;
            l = l << n | l >>> 33 - n;
            this.setIntOperand((int)l);
            boolean bl = this.cpu.eflagsCarry = (l & 0x100000000L) != 0L;
            if (n == 1) {
                boolean bl2 = (l & 0x80000000L) != 0L;
                this.cpu.eflagsOverflow = bl2 ^ this.cpu.eflagsCarry;
            }
        } else {
            this.skipOperand();
            this.skipOperand();
        }
    }

    protected final void rcr_o8() throws ProcessorException {
        int n = (this.getByteOperand() & 0x1F) % 9;
        if (n > 0) {
            int n2 = 0xFF & this.getByteOperand();
            int n3 = this.cpu.eflagsCarry ? 1 : 0;
            n2 |= n3 << 8;
            n2 = n2 >>> n | n2 << 9 - n;
            this.setByteOperand((byte)n2);
            boolean bl = this.cpu.eflagsCarry = (n2 & 0x100) != 0;
            if (n == 1) {
                boolean bl2 = (n2 & 0x80) != 0;
                boolean bl3 = (n2 & 0x40) != 0;
                this.cpu.eflagsOverflow = bl2 ^ bl3;
            }
        } else {
            this.skipOperand();
            this.skipOperand();
        }
    }

    protected final void rcr_o16() throws ProcessorException {
        int n = (this.getByteOperand() & 0x1F) % 17;
        if (n > 0) {
            int n2 = 0xFFFF & this.getShortOperand();
            int n3 = this.cpu.eflagsCarry ? 1 : 0;
            n2 |= n3 << 16;
            n2 = n2 >>> n | n2 << 17 - n;
            this.setShortOperand((short)n2);
            boolean bl = this.cpu.eflagsCarry = (n2 & 0x10000) != 0;
            if (n == 1) {
                boolean bl2 = (n2 & 0x8000) != 0;
                boolean bl3 = (n2 & 0x4000) != 0;
                this.cpu.eflagsOverflow = bl2 ^ bl3;
            }
        } else {
            this.skipOperand();
            this.skipOperand();
        }
    }

    protected final void rcr_o32() throws ProcessorException {
        int n = this.getByteOperand() & 0x1F;
        if (n > 0) {
            long l = 0xFFFFFFFFL & (long)this.getIntOperand();
            long l2 = this.cpu.eflagsCarry ? 1L : 0L;
            l |= l2 << 32;
            l = l >>> n | l << 33 - n;
            this.setIntOperand((int)l);
            boolean bl = this.cpu.eflagsCarry = (l & 0x100000000L) != 0L;
            if (n == 1) {
                boolean bl2 = (l & 0x80000000L) != 0L;
                boolean bl3 = (l & 0x40000000L) != 0L;
                this.cpu.eflagsOverflow = bl2 ^ bl3;
            }
        } else {
            this.skipOperand();
            this.skipOperand();
        }
    }

    protected final void rol_o8() throws ProcessorException {
        int n = this.getByteOperand() & 7;
        if (n > 0) {
            int n2 = 0xFF & this.getByteOperand();
            n2 = n2 << n | n2 >>> 8 - n;
            this.setByteOperand((byte)n2);
            boolean bl = this.cpu.eflagsCarry = (n2 & 1) != 0;
            if (n == 1) {
                boolean bl2 = (n2 & 0x80) != 0;
                this.cpu.eflagsOverflow = bl2 ^ this.cpu.eflagsCarry;
            }
        } else {
            this.skipOperand();
            this.skipOperand();
        }
    }

    protected final void rol_o16() throws ProcessorException {
        int n = this.getByteOperand() & 0xF;
        if (n > 0) {
            int n2 = 0xFFFF & this.getShortOperand();
            n2 = n2 << n | n2 >>> 16 - n;
            this.setShortOperand((short)n2);
            boolean bl = this.cpu.eflagsCarry = (n2 & 1) != 0;
            if (n == 1) {
                boolean bl2 = (n2 & 0x8000) != 0;
                this.cpu.eflagsOverflow = bl2 ^ this.cpu.eflagsCarry;
            }
        } else {
            this.skipOperand();
            this.skipOperand();
        }
    }

    protected final void rol_o32() throws ProcessorException {
        int n = this.getByteOperand() & 0x1F;
        if (n > 0) {
            int n2 = this.getIntOperand();
            n2 = n2 << n | n2 >>> -n;
            this.setIntOperand(n2);
            boolean bl = this.cpu.eflagsCarry = (n2 & 1) != 0;
            if (n == 1) {
                boolean bl2 = (n2 & Integer.MIN_VALUE) != 0;
                this.cpu.eflagsOverflow = bl2 ^ this.cpu.eflagsCarry;
            }
        } else {
            this.skipOperand();
            this.skipOperand();
        }
    }

    protected final void ror_o8() throws ProcessorException {
        int n = this.getByteOperand() & 7;
        if (n > 0) {
            int n2 = 0xFF & this.getByteOperand();
            n2 = n2 >>> n | n2 << 8 - n;
            this.setByteOperand((byte)n2);
            boolean bl = this.cpu.eflagsCarry = (n2 & 0x80) != 0;
            if (n == 1) {
                boolean bl2 = (n2 & 0x40) != 0;
                this.cpu.eflagsOverflow = this.cpu.eflagsCarry ^ bl2;
            }
        } else {
            this.skipOperand();
            this.skipOperand();
        }
    }

    protected final void ror_o16() throws ProcessorException {
        int n = this.getByteOperand() & 0xF;
        if (n > 0) {
            int n2 = 0xFFFF & this.getShortOperand();
            n2 = n2 >>> n | n2 << 16 - n;
            this.setShortOperand((short)n2);
            boolean bl = this.cpu.eflagsCarry = (n2 & 0x8000) != 0;
            if (n == 1) {
                boolean bl2 = (n2 & 0x4000) != 0;
                this.cpu.eflagsOverflow = this.cpu.eflagsCarry ^ bl2;
            }
        } else {
            this.skipOperand();
            this.skipOperand();
        }
    }

    protected final void ror_o32() throws ProcessorException {
        int n = this.getByteOperand() & 0x1F;
        if (n > 0) {
            int n2 = this.getIntOperand();
            n2 = n2 >>> n | n2 << -n;
            this.setIntOperand(n2);
            boolean bl = this.cpu.eflagsCarry = (n2 & Integer.MIN_VALUE) != 0;
            if (n == 1) {
                boolean bl2 = (n2 & 0x40000000) != 0;
                this.cpu.eflagsOverflow = this.cpu.eflagsCarry ^ bl2;
            }
        } else {
            this.skipOperand();
            this.skipOperand();
        }
    }

    protected final void sar_o8() throws ProcessorException {
        int n = this.getByteOperand() & 0x1F;
        if (n > 0) {
            int n2 = this.getByteOperand();
            boolean bl = ((n2 >>= n - 1) & 1) != 0;
            this.setByteOperand((byte)(n2 >>= 1));
            this.cpu.eflagsCarry = bl;
            if (n == 1) {
                this.cpu.eflagsOverflow = false;
            }
            this.cpu.eflagsSign = (byte)n2 < 0;
            this.cpu.eflagsZero = (byte)n2 == 0;
            this.cpu.eflagsParity = parityMap[n2 & 0xFF];
        } else {
            this.skipOperand();
            this.skipOperand();
        }
    }

    protected final void sar_o16() throws ProcessorException {
        int n = this.getByteOperand() & 0x1F;
        if (n > 0) {
            int n2 = this.getShortOperand();
            boolean bl = ((n2 >>= n - 1) & 1) != 0;
            this.setShortOperand((short)(n2 >>= 1));
            this.cpu.eflagsCarry = bl;
            if (n == 1) {
                this.cpu.eflagsOverflow = false;
            }
            this.cpu.eflagsSign = (short)n2 < 0;
            this.cpu.eflagsZero = (short)n2 == 0;
            this.cpu.eflagsParity = parityMap[n2 & 0xFF];
        } else {
            this.skipOperand();
            this.skipOperand();
        }
    }

    protected final void sar_o32() throws ProcessorException {
        int n = this.getByteOperand() & 0x1F;
        if (n > 0) {
            int n2 = this.getIntOperand();
            boolean bl = ((n2 >>= n - 1) & 1) != 0;
            this.setIntOperand(n2 >>= 1);
            this.cpu.eflagsCarry = bl;
            if (n == 1) {
                this.cpu.eflagsOverflow = false;
            }
            this.cpu.eflagsSign = n2 < 0;
            this.cpu.eflagsZero = n2 == 0;
            this.cpu.eflagsParity = parityMap[n2 & 0xFF];
        } else {
            this.skipOperand();
            this.skipOperand();
        }
    }

    protected final void sbb_o8() throws ProcessorException {
        int n = 0xFF & this.getByteOperand();
        int n2 = 0xFF & this.getByteOperand();
        int n3 = this.cpu.eflagsCarry ? 1 : 0;
        int n4 = n2 - (n + n3);
        this.setByteOperand((byte)n4);
        this.standardFlags((byte)n4);
        boolean bl = this.cpu.eflagsCarry = (n4 & 0xFFFFFF00) != 0;
        this.cpu.eflagsOverflow = (byte)(n + n3) < 0 ? (byte)n4 < (byte)n2 : (byte)n4 > (byte)n2;
        this.cpu.eflagsAuxiliaryCarry = ((n2 ^ n ^ n4) & 0x10) != 0;
    }

    protected final void sbb_o16() throws ProcessorException {
        int n = 0xFFFF & this.getShortOperand();
        int n2 = 0xFFFF & this.getShortOperand();
        int n3 = this.cpu.eflagsCarry ? 1 : 0;
        int n4 = n2 - (n + n3);
        this.setShortOperand((short)n4);
        this.standardFlags((short)n4);
        boolean bl = this.cpu.eflagsCarry = (n4 & 0xFFFF0000) != 0;
        this.cpu.eflagsOverflow = (short)(n + n3) < 0 ? (short)n4 < (short)n2 : (short)n4 > (short)n2;
        this.cpu.eflagsAuxiliaryCarry = ((n2 ^ n ^ n4) & 0x10) != 0;
    }

    protected final void sbb_o32() throws ProcessorException {
        long l = 0xFFFFFFFFL & (long)this.getIntOperand();
        long l2 = 0xFFFFFFFFL & (long)this.getIntOperand();
        long l3 = this.cpu.eflagsCarry ? 1L : 0L;
        long l4 = l2 - (l + l3);
        this.setIntOperand((int)l4);
        this.standardFlags((int)l4);
        boolean bl = this.cpu.eflagsCarry = (l4 & 0xFFFFFFFF00000000L) != 0L;
        this.cpu.eflagsOverflow = (int)(l + l3) < 0 ? (int)l4 < (int)l2 : (int)l4 > (int)l2;
        this.cpu.eflagsAuxiliaryCarry = ((l2 ^ l ^ l4) & 0x10L) != 0L;
    }

    protected final void scas_o8_a16() throws ProcessorException {
        int n = 0xFF & this.getByteOperand();
        int n2 = 0xFF & this.getByteOperand();
        int n3 = this.cpu.edi & 0xFFFF;
        n3 = this.cpu.eflagsDirection ? --n3 : ++n3;
        this.cpu.edi &= 0xFFFF0000;
        this.cpu.edi |= n3 & 0xFFFF;
        int n4 = n - n2;
        this.standardFlags((byte)n4);
        boolean bl = this.cpu.eflagsCarry = (n4 & 0xFFFFFF00) != 0;
        this.cpu.eflagsOverflow = (byte)n2 < 0 ? (byte)n4 < (byte)n : (byte)n4 > (byte)n;
        this.cpu.eflagsAuxiliaryCarry = ((n ^ n2 ^ n4) & 0x10) != 0;
    }

    protected final void scas_o16_a16() throws ProcessorException {
        int n = 0xFFFF & this.getShortOperand();
        int n2 = 0xFFFF & this.getShortOperand();
        int n3 = this.cpu.edi & 0xFFFF;
        n3 = this.cpu.eflagsDirection ? (n3 -= 2) : (n3 += 2);
        this.cpu.edi &= 0xFFFF0000;
        this.cpu.edi |= n3 & 0xFFFF;
        int n4 = n - n2;
        this.standardFlags((short)n4);
        boolean bl = this.cpu.eflagsCarry = (n4 & 0xFFFF0000) != 0;
        this.cpu.eflagsOverflow = (short)n2 < 0 ? (short)n4 < (short)n : (short)n4 > (short)n;
        this.cpu.eflagsAuxiliaryCarry = ((n ^ n2 ^ n4) & 0x10) != 0;
    }

    protected final void scas_o32_a16() throws ProcessorException {
        long l = 0xFFFFFFFFL & (long)this.getIntOperand();
        long l2 = 0xFFFFFFFFL & (long)this.getIntOperand();
        int n = this.cpu.edi & 0xFFFF;
        n = this.cpu.eflagsDirection ? (n -= 4) : (n += 4);
        this.cpu.edi &= 0xFFFF0000;
        this.cpu.edi |= n & 0xFFFF;
        long l3 = l - l2;
        this.standardFlags((int)l3);
        boolean bl = this.cpu.eflagsCarry = (l3 & 0xFFFFFFFF00000000L) != 0L;
        this.cpu.eflagsOverflow = (int)l2 < 0 ? (int)l3 < (int)l : (int)l3 > (int)l;
        this.cpu.eflagsAuxiliaryCarry = ((l ^ l2 ^ l3) & 0x10L) != 0L;
    }

    protected final void scas_o8_a32() throws ProcessorException {
        int n = 0xFF & this.getByteOperand();
        int n2 = 0xFF & this.getByteOperand();
        this.cpu.edi = this.cpu.eflagsDirection ? --this.cpu.edi : ++this.cpu.edi;
        int n3 = n - n2;
        this.standardFlags((byte)n3);
        boolean bl = this.cpu.eflagsCarry = (n3 & 0xFFFFFF00) != 0;
        this.cpu.eflagsOverflow = (byte)n2 < 0 ? (byte)n3 < (byte)n : (byte)n3 > (byte)n;
        this.cpu.eflagsAuxiliaryCarry = ((n ^ n2 ^ n3) & 0x10) != 0;
    }

    protected final void scas_o16_a32() throws ProcessorException {
        int n = 0xFFFF & this.getShortOperand();
        int n2 = 0xFFFF & this.getShortOperand();
        this.cpu.edi = this.cpu.eflagsDirection ? (this.cpu.edi -= 2) : (this.cpu.edi += 2);
        int n3 = n - n2;
        this.standardFlags((short)n3);
        boolean bl = this.cpu.eflagsCarry = (n3 & 0xFFFF0000) != 0;
        this.cpu.eflagsOverflow = (short)n2 < 0 ? (short)n3 < (short)n : (short)n3 > (short)n;
        this.cpu.eflagsAuxiliaryCarry = ((n ^ n2 ^ n3) & 0x10) != 0;
    }

    protected final void scas_o32_a32() throws ProcessorException {
        long l = 0xFFFFFFFFL & (long)this.getIntOperand();
        long l2 = 0xFFFFFFFFL & (long)this.getIntOperand();
        this.cpu.edi = this.cpu.eflagsDirection ? (this.cpu.edi -= 4) : (this.cpu.edi += 4);
        long l3 = l - l2;
        this.standardFlags((int)l3);
        boolean bl = this.cpu.eflagsCarry = (l3 & 0xFFFFFFFF00000000L) != 0L;
        this.cpu.eflagsOverflow = (int)l2 < 0 ? (int)l3 < (int)l : (int)l3 > (int)l;
        this.cpu.eflagsAuxiliaryCarry = ((l ^ l2 ^ l3) & 0x10L) != 0L;
    }

    protected final void setb() throws ProcessorException {
        if (this.cpu.eflagsCarry) {
            this.setByteOperand((byte)1);
        } else {
            this.setByteOperand((byte)0);
        }
    }

    protected final void setnb() throws ProcessorException {
        if (!this.cpu.eflagsCarry) {
            this.setByteOperand((byte)1);
        } else {
            this.setByteOperand((byte)0);
        }
    }

    protected final void setbe() throws ProcessorException {
        if (this.cpu.eflagsCarry || this.cpu.eflagsZero) {
            this.setByteOperand((byte)1);
        } else {
            this.setByteOperand((byte)0);
        }
    }

    protected final void setnbe() throws ProcessorException {
        if (!this.cpu.eflagsCarry && !this.cpu.eflagsZero) {
            this.setByteOperand((byte)1);
        } else {
            this.setByteOperand((byte)0);
        }
    }

    protected final void setl() throws ProcessorException {
        if (this.cpu.eflagsSign != this.cpu.eflagsOverflow) {
            this.setByteOperand((byte)1);
        } else {
            this.setByteOperand((byte)0);
        }
    }

    protected final void setnl() throws ProcessorException {
        if (this.cpu.eflagsSign == this.cpu.eflagsOverflow) {
            this.setByteOperand((byte)1);
        } else {
            this.setByteOperand((byte)0);
        }
    }

    protected final void setle() throws ProcessorException {
        if (this.cpu.eflagsZero || this.cpu.eflagsSign != this.cpu.eflagsOverflow) {
            this.setByteOperand((byte)1);
        } else {
            this.setByteOperand((byte)0);
        }
    }

    protected final void setnle() throws ProcessorException {
        if (!this.cpu.eflagsZero && this.cpu.eflagsSign == this.cpu.eflagsOverflow) {
            this.setByteOperand((byte)1);
        } else {
            this.setByteOperand((byte)0);
        }
    }

    protected final void seto() throws ProcessorException {
        if (this.cpu.eflagsOverflow) {
            this.setByteOperand((byte)1);
        } else {
            this.setByteOperand((byte)0);
        }
    }

    protected final void setno() throws ProcessorException {
        if (!this.cpu.eflagsOverflow) {
            this.setByteOperand((byte)1);
        } else {
            this.setByteOperand((byte)0);
        }
    }

    protected final void setp() throws ProcessorException {
        if (this.cpu.eflagsParity) {
            this.setByteOperand((byte)1);
        } else {
            this.setByteOperand((byte)0);
        }
    }

    protected final void setnp() throws ProcessorException {
        if (!this.cpu.eflagsParity) {
            this.setByteOperand((byte)1);
        } else {
            this.setByteOperand((byte)0);
        }
    }

    protected final void sets() throws ProcessorException {
        if (this.cpu.eflagsSign) {
            this.setByteOperand((byte)1);
        } else {
            this.setByteOperand((byte)0);
        }
    }

    protected final void setns() throws ProcessorException {
        if (!this.cpu.eflagsSign) {
            this.setByteOperand((byte)1);
        } else {
            this.setByteOperand((byte)0);
        }
    }

    protected final void setz() throws ProcessorException {
        if (this.cpu.eflagsZero) {
            this.setByteOperand((byte)1);
        } else {
            this.setByteOperand((byte)0);
        }
    }

    protected final void setnz() throws ProcessorException {
        if (!this.cpu.eflagsZero) {
            this.setByteOperand((byte)1);
        } else {
            this.setByteOperand((byte)0);
        }
    }

    protected final void shl_o8() throws ProcessorException {
        int n = this.getByteOperand() & 0x1F;
        if (n > 0) {
            byte by = this.getByteOperand();
            byte by2 = (byte)(by << n - 1);
            boolean bl = (by2 & 0x80) != 0;
            by2 = (byte)(by2 << 1);
            this.setByteOperand(by2);
            this.cpu.eflagsCarry = bl;
            if (n == 1) {
                this.cpu.eflagsOverflow = (by2 & 0x80) != 0 ^ this.cpu.eflagsCarry;
            }
            this.cpu.eflagsZero = by2 == 0;
            this.cpu.eflagsSign = by2 < 0;
            this.cpu.eflagsParity = parityMap[by2 & 0xFF];
        } else {
            this.skipOperand();
            this.skipOperand();
        }
    }

    protected final void shl_o16() throws ProcessorException {
        int n = this.getByteOperand() & 0x1F;
        if (n > 0) {
            short s = this.getShortOperand();
            short s2 = (short)(s << n - 1);
            boolean bl = (s2 & 0x8000) != 0;
            s2 = (short)(s2 << 1);
            this.setShortOperand(s2);
            this.cpu.eflagsCarry = bl;
            if (n == 1) {
                this.cpu.eflagsOverflow = (s2 & 0x8000) != 0 ^ this.cpu.eflagsCarry;
            }
            this.cpu.eflagsZero = s2 == 0;
            this.cpu.eflagsSign = s2 < 0;
            this.cpu.eflagsParity = parityMap[s2 & 0xFF];
        } else {
            this.skipOperand();
            this.skipOperand();
        }
    }

    protected final void shl_o32() throws ProcessorException {
        int n = this.getByteOperand() & 0x1F;
        if (n > 0) {
            int n2 = this.getIntOperand();
            int n3 = n2 << n - 1;
            boolean bl = (n3 & Integer.MIN_VALUE) != 0;
            this.setIntOperand(n3 <<= 1);
            this.cpu.eflagsCarry = bl;
            if (n == 1) {
                this.cpu.eflagsOverflow = (n3 & Integer.MIN_VALUE) != 0 ^ this.cpu.eflagsCarry;
            }
            this.cpu.eflagsZero = n3 == 0;
            this.cpu.eflagsSign = n3 < 0;
            this.cpu.eflagsParity = parityMap[n3 & 0xFF];
        } else {
            this.skipOperand();
            this.skipOperand();
        }
    }

    protected final void shr_o8() throws ProcessorException {
        int n = this.getByteOperand() & 0x1F;
        if (n > 0) {
            int n2 = 0xFF & this.getByteOperand();
            int n3 = n2 >>> n - 1;
            boolean bl = (n3 & 1) != 0;
            this.setByteOperand((byte)(n3 >>>= 1));
            this.cpu.eflagsCarry = bl;
            if (n == 1) {
                this.cpu.eflagsOverflow = (n2 & 0x80) != 0;
            }
            this.cpu.eflagsZero = (byte)n3 == 0;
            this.cpu.eflagsSign = (byte)n3 < 0;
            this.cpu.eflagsParity = parityMap[n3 & 0xFF];
        } else {
            this.skipOperand();
            this.skipOperand();
        }
    }

    protected final void shr_o16() throws ProcessorException {
        int n = this.getByteOperand() & 0x1F;
        if (n > 0) {
            int n2 = 0xFFFF & this.getShortOperand();
            int n3 = n2 >>> n - 1;
            boolean bl = (n3 & 1) != 0;
            this.setShortOperand((short)(n3 >>>= 1));
            this.cpu.eflagsCarry = bl;
            if (n == 1) {
                this.cpu.eflagsOverflow = (n2 & 0x8000) != 0;
            }
            this.cpu.eflagsZero = (short)n3 == 0;
            this.cpu.eflagsSign = (short)n3 < 0;
            this.cpu.eflagsParity = parityMap[n3 & 0xFF];
        } else {
            this.skipOperand();
            this.skipOperand();
        }
    }

    protected final void shr_o32() throws ProcessorException {
        int n = this.getByteOperand() & 0x1F;
        if (n > 0) {
            int n2 = this.getIntOperand();
            int n3 = n2 >>> n - 1;
            boolean bl = (n3 & 1) != 0;
            this.setIntOperand(n3 >>>= 1);
            this.cpu.eflagsCarry = bl;
            if (n == 1) {
                this.cpu.eflagsOverflow = (n2 & Integer.MIN_VALUE) != 0;
            }
            this.cpu.eflagsZero = n3 == 0;
            this.cpu.eflagsSign = n3 < 0;
            this.cpu.eflagsParity = parityMap[n3 & 0xFF];
        } else {
            this.skipOperand();
            this.skipOperand();
        }
    }

    protected final void stc() {
        this.cpu.eflagsCarry = true;
    }

    protected final void std() {
        this.cpu.eflagsDirection = true;
    }

    protected final void sti() {
        this.cpu.eflagsInterruptEnableSoon = true;
        this.cpu.eflagsInterruptEnable = true;
    }

    protected final void stos_o8_a16() throws ProcessorException {
        byte by = this.getByteOperand();
        int n = this.cpu.edi & 0xFFFF;
        this.setByteOperand(by);
        n = this.cpu.eflagsDirection ? --n : ++n;
        this.cpu.edi &= 0xFFFF0000;
        this.cpu.edi |= n & 0xFFFF;
    }

    protected final void stos_o16_a16() throws ProcessorException {
        short s = this.getShortOperand();
        int n = this.cpu.edi & 0xFFFF;
        this.setShortOperand(s);
        n = this.cpu.eflagsDirection ? (n -= 2) : (n += 2);
        this.cpu.edi &= 0xFFFF0000;
        this.cpu.edi |= n & 0xFFFF;
    }

    protected final void stos_o32_a16() throws ProcessorException {
        int n = this.getIntOperand();
        int n2 = this.cpu.edi & 0xFFFF;
        this.setIntOperand(n);
        n2 = this.cpu.eflagsDirection ? (n2 -= 4) : (n2 += 4);
        this.cpu.edi &= 0xFFFF0000;
        this.cpu.edi |= n2 & 0xFFFF;
    }

    protected final void stos_o8_a32() throws ProcessorException {
        byte by = this.getByteOperand();
        this.setByteOperand(by);
        this.cpu.edi = this.cpu.eflagsDirection ? --this.cpu.edi : ++this.cpu.edi;
    }

    protected final void stos_o16_a32() throws ProcessorException {
        short s = this.getShortOperand();
        this.setShortOperand(s);
        this.cpu.edi = this.cpu.eflagsDirection ? (this.cpu.edi -= 2) : (this.cpu.edi += 2);
    }

    protected final void stos_o32_a32() throws ProcessorException {
        int n = this.getIntOperand();
        this.setIntOperand(n);
        this.cpu.edi = this.cpu.eflagsDirection ? (this.cpu.edi -= 4) : (this.cpu.edi += 4);
    }

    protected final void shrd_o16() throws ProcessorException {
        int n = 0xFFFF & this.getShortOperand();
        int n2 = this.getByteOperand() & 0x1F;
        if (n2 == 0) {
            this.skipOperand();
            this.skipOperand();
            return;
        }
        int n3 = 0xFFFF & this.getShortOperand();
        int n4 = n3 >>> n2 | n << 16 - n2;
        this.setShortOperand((short)n4);
        this.standardFlags((short)n4);
        boolean bl = this.cpu.eflagsCarry = (n3 >>> n2 - 1 & 1) == 1;
        if (n2 == 1) {
            this.cpu.eflagsOverflow = (n3 & 0x8000) != (n4 & 0x8000);
        }
    }

    protected final void shrd_o32() throws ProcessorException {
        int n = this.getIntOperand();
        int n2 = this.getByteOperand() & 0x1F;
        if (n2 == 0) {
            this.skipOperand();
            this.skipOperand();
            return;
        }
        int n3 = this.getIntOperand();
        int n4 = n3 >>> n2 | n << 32 - n2;
        this.setIntOperand(n4);
        this.standardFlags(n4);
        boolean bl = this.cpu.eflagsCarry = (n3 >>> n2 - 1 & 1) == 1;
        if (n2 == 1) {
            this.cpu.eflagsOverflow = (n3 & Integer.MIN_VALUE) != (n4 & Integer.MIN_VALUE);
        }
    }

    protected final void shld_o16() throws ProcessorException {
        int n = 0xFFFF & this.getShortOperand();
        int n2 = this.getByteOperand() & 0x1F;
        if (n2 == 0) {
            this.skipOperand();
            this.skipOperand();
            return;
        }
        int n3 = 0xFFFF & this.getShortOperand();
        int n4 = n3 << n2 | n >>> 16 - n2;
        this.setShortOperand((short)n4);
        this.standardFlags((short)n4);
        boolean bl = this.cpu.eflagsCarry = (n3 << n2 - 1 & 0x8000) == 32768;
        if (n2 == 1) {
            this.cpu.eflagsOverflow = (n3 & 0x8000) != (n4 & 0x8000);
        }
    }

    protected final void shld_o32() throws ProcessorException {
        int n = this.getIntOperand();
        int n2 = this.getByteOperand() & 0x1F;
        if (n2 == 0) {
            this.skipOperand();
            this.skipOperand();
            return;
        }
        int n3 = this.getIntOperand();
        int n4 = n3 << n2 | n >>> 32 - n2;
        this.setIntOperand(n4);
        this.standardFlags(n4);
        boolean bl = this.cpu.eflagsCarry = (n3 << n2 - 1 & Integer.MIN_VALUE) == Integer.MIN_VALUE;
        if (n2 == 1) {
            this.cpu.eflagsOverflow = (n3 & Integer.MIN_VALUE) != (n4 & Integer.MIN_VALUE);
        }
    }

    protected final void sub_o8() throws ProcessorException {
        int n = 0xFF & this.getByteOperand();
        int n2 = 0xFF & this.getByteOperand();
        int n3 = n2 - n;
        this.setByteOperand((byte)n3);
        this.standardFlags((byte)n3);
        boolean bl = this.cpu.eflagsCarry = (n3 & 0xFFFFFF00) != 0;
        this.cpu.eflagsOverflow = (byte)n < 0 ? (byte)n3 < (byte)n2 : (byte)n3 > (byte)n2;
        this.cpu.eflagsAuxiliaryCarry = ((n2 ^ n ^ n3) & 0x10) != 0;
    }

    protected final void sub_o16() throws ProcessorException {
        int n = 0xFFFF & this.getShortOperand();
        int n2 = 0xFFFF & this.getShortOperand();
        int n3 = n2 - n;
        this.setShortOperand((short)n3);
        this.standardFlags((short)n3);
        boolean bl = this.cpu.eflagsCarry = (n3 & 0xFFFF0000) != 0;
        this.cpu.eflagsOverflow = (short)n < 0 ? (short)n3 < (short)n2 : (short)n3 > (short)n2;
        this.cpu.eflagsAuxiliaryCarry = ((n2 ^ n ^ n3) & 0x10) != 0;
    }

    protected final void sub_o32() throws ProcessorException {
        long l = 0xFFFFFFFFL & (long)this.getIntOperand();
        long l2 = 0xFFFFFFFFL & (long)this.getIntOperand();
        long l3 = l2 - l;
        this.setIntOperand((int)l3);
        this.standardFlags((int)l3);
        boolean bl = this.cpu.eflagsCarry = (l3 & 0xFFFFFFFF00000000L) != 0L;
        this.cpu.eflagsOverflow = (int)l < 0 ? (int)l3 < (int)l2 : (int)l3 > (int)l2;
        this.cpu.eflagsAuxiliaryCarry = ((l2 ^ l ^ l3) & 0x10L) != 0L;
    }

    protected final void test_o8() throws ProcessorException {
        byte by = (byte)(this.getByteOperand() & this.getByteOperand());
        this.standardFlags(by);
    }

    protected final void test_o16() throws ProcessorException {
        short s = (short)(this.getShortOperand() & this.getShortOperand());
        this.standardFlags(s);
    }

    protected final void test_o32() throws ProcessorException {
        int n = this.getIntOperand() & this.getIntOperand();
        this.standardFlags(n);
    }

    protected final void waitOp() {
        if ((this.cpu.getCR0() & 6) == 6) {
            throw exceptionNM;
        }
    }

    protected final void xadd_o8() throws ProcessorException {
        int n = 0xFF & this.getByteOperand();
        int n2 = 0xFF & this.getByteOperand();
        this.setByteOperand((byte)n2);
        int n3 = n + n2;
        this.setByteOperand((byte)n3);
        this.standardFlags((byte)n3);
        boolean bl = this.cpu.eflagsCarry = (n3 & 0xFFFFFF00) != 0;
        this.cpu.eflagsOverflow = (byte)n2 > 0 ? (byte)n3 < (byte)n : (byte)n3 > (byte)n;
        this.cpu.eflagsAuxiliaryCarry = ((n ^ n2 ^ n3) & 0x10) != 0;
    }

    protected final void xadd_o16() throws ProcessorException {
        int n = 0xFFFF & this.getShortOperand();
        int n2 = 0xFFFF & this.getShortOperand();
        this.setShortOperand((short)n2);
        int n3 = n + n2;
        this.setShortOperand((short)n3);
        this.standardFlags((short)n3);
        boolean bl = this.cpu.eflagsCarry = (n3 & 0xFFFF0000) != 0;
        this.cpu.eflagsOverflow = (short)n2 > 0 ? (short)n3 < (short)n : (short)n3 > (short)n;
        this.cpu.eflagsAuxiliaryCarry = ((n ^ n2 ^ n3) & 0x10) != 0;
    }

    protected final void xadd_o32() throws ProcessorException {
        long l = 0xFFFFFFFFL & (long)this.getIntOperand();
        long l2 = 0xFFFFFFFFL & (long)this.getIntOperand();
        this.setIntOperand((int)l2);
        long l3 = l + l2;
        this.setIntOperand((int)l3);
        this.standardFlags((int)l3);
        boolean bl = this.cpu.eflagsCarry = (l3 & 0xFFFFFFFF00000000L) != 0L;
        this.cpu.eflagsOverflow = (int)l2 > 0 ? (int)l3 < (int)l : (int)l3 > (int)l;
        this.cpu.eflagsAuxiliaryCarry = ((l ^ l2 ^ l3) & 0x10L) != 0L;
    }

    protected final void xchg_o8() throws ProcessorException {
        byte by = this.getByteOperand();
        byte by2 = this.getByteOperand();
        this.setByteOperand(by2);
        this.setByteOperand(by);
    }

    protected final void xchg_o16() throws ProcessorException {
        short s = this.getShortOperand();
        short s2 = this.getShortOperand();
        this.setShortOperand(s2);
        this.setShortOperand(s);
    }

    protected final void xchg_o32() throws ProcessorException {
        int n = this.getIntOperand();
        int n2 = this.getIntOperand();
        this.setIntOperand(n2);
        this.setIntOperand(n);
    }

    protected final void xlat() {
        byte by = this.getByteOperand();
        this.setByteOperand(by);
    }

    protected final void xor_o8() throws ProcessorException {
        byte by = (byte)(this.getByteOperand() ^ this.getByteOperand());
        this.setByteOperand(by);
        this.standardFlags(by);
    }

    protected final void xor_o16() throws ProcessorException {
        short s = (short)(this.getShortOperand() ^ this.getShortOperand());
        this.setShortOperand(s);
        this.standardFlags(s);
    }

    protected final void xor_o32() throws ProcessorException {
        int n = this.getIntOperand() ^ this.getIntOperand();
        this.setIntOperand(n);
        this.standardFlags(n);
    }

    protected final Segment getSegmentOperand() {
        int n = this.getMicrocode();
        this.microcodesPosition += this.immediateCount(n);
        switch (n) {
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 338: 
            case 339: 
            case 340: 
            case 341: 
            case 342: 
            case 343: 
            case 344: 
            case 345: 
            case 346: 
            case 347: 
            case 348: 
            case 349: 
            case 350: 
            case 351: 
            case 352: 
            case 353: 
            case 354: 
            case 355: 
            case 356: 
            case 357: 
            case 358: 
            case 359: 
            case 360: 
            case 361: 
            case 362: 
            case 363: 
            case 364: 
            case 365: 
            case 366: 
            case 367: 
            case 368: 
            case 369: 
            case 370: 
            case 371: 
            case 372: 
            case 373: 
            case 374: 
            case 375: 
            case 376: 
            case 377: 
            case 378: 
            case 379: 
            case 380: 
            case 381: 
            case 382: 
            case 383: 
            case 384: 
            case 385: 
            case 386: 
            case 387: 
            case 388: 
            case 389: 
            case 390: 
            case 391: 
            case 392: 
            case 393: 
            case 394: 
            case 395: 
            case 396: 
            case 397: 
            case 398: 
            case 399: 
            case 400: 
            case 401: 
            case 402: 
            case 403: 
            case 404: 
            case 405: 
            case 406: 
            case 407: 
            case 408: 
            case 409: 
            case 410: 
            case 411: 
            case 412: 
            case 413: 
            case 414: 
            case 415: 
            case 416: 
            case 417: 
            case 418: 
            case 419: 
            case 420: 
            case 421: 
            case 422: 
            case 423: 
            case 424: 
            case 425: 
            case 426: 
            case 427: 
            case 428: 
            case 429: 
            case 430: 
            case 431: 
            case 432: 
            case 433: 
            case 434: 
            case 435: 
            case 436: 
            case 437: 
            case 438: 
            case 439: 
            case 440: 
            case 441: 
            case 442: 
            case 443: 
            case 444: 
            case 445: 
            case 446: 
            case 447: 
            case 448: 
            case 449: 
            case 450: 
            case 451: 
            case 452: 
            case 453: 
            case 454: 
            case 455: 
            case 456: 
            case 457: 
            case 458: 
            case 459: 
            case 460: 
            case 461: 
            case 462: 
            case 463: 
            case 464: 
            case 465: 
            case 466: 
            case 467: 
            case 468: 
            case 469: 
            case 470: 
            case 471: 
            case 472: 
            case 473: 
            case 474: 
            case 475: 
            case 476: 
            case 477: 
            case 478: 
            case 479: 
            case 480: 
            case 481: 
            case 482: 
            case 483: 
            case 484: 
            case 485: 
            case 486: 
            case 487: 
            case 488: 
            case 489: 
            case 490: 
            case 491: 
            case 492: 
            case 493: 
            case 494: 
            case 495: 
            case 496: 
            case 497: 
            case 498: 
            case 499: 
            case 500: 
            case 501: 
            case 502: 
            case 503: 
            case 504: 
            case 505: 
            case 506: 
            case 507: 
            case 508: 
            case 509: 
            case 510: 
            case 511: 
            case 512: 
            case 513: 
            case 514: 
            case 515: 
            case 516: 
            case 517: 
            case 518: 
            case 519: 
            case 520: 
            case 521: 
            case 522: 
            case 523: 
            case 524: 
            case 525: 
            case 526: 
            case 527: 
            case 528: 
            case 529: 
            case 530: 
            case 531: 
            case 532: 
            case 533: 
            case 534: 
            case 535: 
            case 536: 
            case 537: 
            case 538: 
            case 539: 
            case 540: 
            case 541: 
            case 542: 
            case 543: 
            case 544: 
            case 545: 
            case 546: 
            case 547: 
            case 548: 
            case 549: 
            case 550: 
            case 551: 
            case 552: 
            case 553: 
            case 554: 
            case 555: 
            case 556: 
            case 557: 
            case 558: 
            case 559: 
            case 560: 
            case 561: 
            case 562: 
            case 563: 
            case 564: 
            case 565: 
            case 566: 
            case 567: 
            case 568: 
            case 569: 
            case 570: 
            case 571: 
            case 572: 
            case 573: 
            case 574: 
            case 575: 
            case 576: 
            case 577: 
            case 578: 
            case 579: 
            case 580: 
            case 581: 
            case 582: 
            case 583: 
            case 584: 
            case 585: 
            case 586: 
            case 587: 
            case 588: 
            case 589: 
            case 590: 
            case 591: 
            case 592: 
            case 593: 
            case 594: 
            case 595: 
            case 596: 
            case 597: 
            case 598: 
            case 599: 
            case 600: 
            case 601: 
            case 602: 
            case 603: 
            case 604: 
            case 605: 
            case 606: 
            case 607: 
            case 608: 
            case 609: 
            case 610: 
            case 611: 
            case 612: 
            case 613: 
            case 614: 
            case 615: 
            case 616: 
            case 617: 
            case 618: 
            case 619: 
            case 620: 
            case 621: 
            case 622: 
            case 623: 
            case 624: 
            case 625: 
            case 626: 
            case 627: 
            case 628: 
            case 629: 
            case 630: 
            case 631: 
            case 632: 
            case 633: 
            case 634: 
            case 635: 
            case 636: 
            case 637: 
            case 638: 
            case 639: 
            case 640: 
            case 641: 
            case 642: 
            case 643: 
            case 644: 
            case 645: 
            case 646: 
            case 647: 
            case 648: 
            case 649: 
            case 650: 
            case 651: 
            case 652: 
            case 653: 
            case 654: 
            case 655: 
            case 656: 
            case 657: 
            case 658: 
            case 659: 
            case 660: 
            case 661: 
            case 662: 
            case 663: 
            case 664: 
            case 665: 
            case 666: 
            case 667: 
            case 668: 
            case 669: 
            case 670: 
            case 671: 
            case 672: 
            case 673: 
            case 674: 
            case 675: 
            case 676: 
            case 677: 
            case 678: 
            case 679: 
            case 680: 
            case 681: 
            case 682: 
            case 683: 
            case 684: 
            case 685: 
            case 686: 
            case 687: 
            case 688: 
            case 689: 
            case 690: 
            case 691: 
            case 692: 
            case 693: 
            case 694: 
            case 695: 
            case 696: 
            case 697: 
            case 698: 
            case 699: 
            case 700: 
            case 701: 
            case 702: 
            case 703: 
            case 704: 
            case 705: 
            case 706: 
            case 707: 
            case 708: 
            case 709: 
            case 710: 
            case 711: 
            case 712: 
            case 713: 
            case 714: 
            case 715: 
            case 716: 
            case 717: 
            case 718: 
            case 719: 
            case 720: 
            case 721: 
            case 722: 
            case 723: 
            case 724: 
            case 725: 
            case 726: 
            case 727: 
            case 728: 
            case 729: 
            case 730: 
            case 731: 
            case 732: 
            case 733: 
            case 734: 
            case 735: 
            case 736: 
            case 737: 
            case 738: 
            case 739: 
            case 740: 
            case 741: 
            case 742: 
            case 743: 
            case 744: 
            case 745: 
            case 746: 
            case 747: 
            case 748: 
            case 749: 
            case 750: 
            case 751: 
            case 752: 
            case 753: 
            case 754: 
            case 755: 
            case 756: 
            case 757: 
            case 758: 
            case 759: 
            case 760: 
            case 761: 
            case 762: 
            case 763: 
            case 764: 
            case 765: 
            case 766: 
            case 767: 
            case 768: 
            case 769: 
            case 770: 
            case 771: 
            case 772: 
            case 773: 
            case 774: 
            case 775: 
            case 776: 
            case 777: 
            case 778: 
            case 779: 
            case 780: 
            case 781: 
            case 782: 
            case 783: 
            case 784: 
            case 785: 
            case 786: 
            case 787: 
            case 788: 
            case 789: 
            case 790: 
            case 791: 
            case 792: 
            case 793: 
            case 794: 
            case 795: 
            case 796: 
            case 797: 
            case 798: 
            case 799: 
            case 800: 
            case 801: 
            case 802: 
            case 803: 
            case 804: 
            case 805: 
            case 806: 
            case 807: 
            case 808: 
            case 809: 
            case 810: 
            case 811: 
            case 812: 
            case 813: 
            case 814: 
            case 815: 
            case 816: 
            case 817: 
            case 818: 
            case 819: 
            case 820: 
            case 821: 
            case 822: 
            case 823: 
            case 824: 
            case 825: 
            case 826: 
            case 827: 
            case 828: 
            case 829: 
            case 830: 
            case 831: 
            case 832: 
            case 833: 
            case 834: 
            case 835: 
            case 836: 
            case 837: 
            case 838: 
            case 839: 
            case 840: 
            case 841: 
            case 842: 
            case 843: 
            case 844: 
            case 845: 
            case 846: 
            case 847: 
            case 848: 
            case 849: 
            case 850: 
            case 851: 
            case 852: 
            case 853: 
            case 854: 
            case 855: 
            case 856: 
            case 857: 
            case 858: 
            case 859: 
            case 860: 
            case 861: 
            case 862: 
            case 863: 
            case 864: 
            case 865: 
            case 866: 
            case 867: 
            case 868: 
            case 869: 
            case 870: 
            case 871: 
            case 872: 
            case 873: 
            case 874: 
            case 875: 
            case 876: 
            case 877: 
            case 878: 
            case 879: 
            case 880: 
            case 881: 
            case 882: 
            case 883: 
            case 884: 
            case 885: 
            case 886: 
            case 887: 
            case 888: 
            case 889: 
            case 890: 
            case 891: 
            case 892: 
            case 893: 
            case 894: 
            case 895: 
            case 896: 
            case 897: 
            case 898: 
            case 899: 
            case 900: 
            case 901: 
            case 902: 
            case 903: 
            case 904: 
            case 905: 
            case 906: 
            case 907: 
            case 908: 
            case 909: 
            case 910: 
            case 911: 
            case 912: 
            case 913: 
            case 914: 
            case 915: 
            case 916: 
            case 917: 
            case 918: 
            case 919: 
            case 920: 
            case 921: 
            case 922: 
            case 923: 
            case 924: 
            case 925: 
            case 926: 
            case 927: 
            case 928: 
            case 929: 
            case 930: 
            case 931: 
            case 932: 
            case 933: 
            case 934: 
            case 935: 
            case 936: 
            case 937: 
            case 938: 
            case 939: 
            case 940: 
            case 941: {
                return this.cpu.ds;
            }
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 198: 
            case 199: 
            case 200: 
            case 201: 
            case 202: 
            case 203: 
            case 204: 
            case 205: {
                return this.cpu.es;
            }
            case 109: 
            case 116: 
            case 230: 
            case 231: 
            case 232: 
            case 233: 
            case 234: 
            case 235: 
            case 236: 
            case 237: 
            case 238: 
            case 239: 
            case 240: 
            case 241: 
            case 242: 
            case 243: 
            case 244: 
            case 245: 
            case 246: 
            case 247: 
            case 248: 
            case 249: 
            case 250: 
            case 251: 
            case 252: 
            case 253: 
            case 2379: {
                return this.cpu.ss;
            }
        }
        System.err.println("Unimplemented GetSegment Operand: " + n);
        throw unimplemented;
    }

    protected final int getAddressOperand() {
        int n = this.getMicrocode();
        switch (n) {
            case 182: 
            case 206: 
            case 230: 
            case 254: 
            case 278: 
            case 302: {
                return this.cpu.ebx + this.cpu.esi & 0xFFFF;
            }
            case 183: 
            case 207: 
            case 231: 
            case 255: 
            case 279: 
            case 303: {
                return this.cpu.ebx + this.cpu.edi & 0xFFFF;
            }
            case 184: 
            case 208: 
            case 232: 
            case 256: 
            case 280: 
            case 304: {
                return this.cpu.ebp + this.cpu.esi & 0xFFFF;
            }
            case 185: 
            case 209: 
            case 233: 
            case 257: 
            case 281: 
            case 305: {
                return this.cpu.ebp + this.cpu.edi & 0xFFFF;
            }
            case 186: 
            case 210: 
            case 234: 
            case 258: 
            case 282: 
            case 306: {
                return this.cpu.esi & 0xFFFF;
            }
            case 187: 
            case 211: 
            case 235: 
            case 259: 
            case 283: 
            case 307: {
                return this.cpu.edi & 0xFFFF;
            }
            case 188: 
            case 212: 
            case 236: 
            case 260: 
            case 284: 
            case 308: {
                return this.getMicrocode() & 0xFFFF;
            }
            case 189: 
            case 213: 
            case 237: 
            case 261: 
            case 285: 
            case 309: {
                return this.cpu.ebx & 0xFFFF;
            }
            case 190: 
            case 198: 
            case 214: 
            case 222: 
            case 238: 
            case 246: 
            case 262: 
            case 270: 
            case 286: 
            case 294: 
            case 310: 
            case 318: {
                return this.cpu.ebx + this.cpu.esi + this.getMicrocode() & 0xFFFF;
            }
            case 191: 
            case 199: 
            case 215: 
            case 223: 
            case 239: 
            case 247: 
            case 263: 
            case 271: 
            case 287: 
            case 295: 
            case 311: 
            case 319: {
                return this.cpu.ebx + this.cpu.edi + this.getMicrocode() & 0xFFFF;
            }
            case 192: 
            case 200: 
            case 216: 
            case 224: 
            case 240: 
            case 248: 
            case 264: 
            case 272: 
            case 288: 
            case 296: 
            case 312: 
            case 320: {
                return this.cpu.ebp + this.cpu.esi + this.getMicrocode() & 0xFFFF;
            }
            case 193: 
            case 201: 
            case 217: 
            case 225: 
            case 241: 
            case 249: 
            case 265: 
            case 273: 
            case 289: 
            case 297: 
            case 313: 
            case 321: {
                return this.cpu.ebp + this.cpu.edi + this.getMicrocode() & 0xFFFF;
            }
            case 194: 
            case 202: 
            case 218: 
            case 226: 
            case 242: 
            case 250: 
            case 266: 
            case 274: 
            case 290: 
            case 298: 
            case 314: 
            case 322: {
                return this.cpu.esi + this.getMicrocode() & 0xFFFF;
            }
            case 195: 
            case 203: 
            case 219: 
            case 227: 
            case 243: 
            case 251: 
            case 267: 
            case 275: 
            case 291: 
            case 299: 
            case 315: 
            case 323: {
                return this.cpu.edi + this.getMicrocode() & 0xFFFF;
            }
            case 196: 
            case 204: 
            case 220: 
            case 228: 
            case 244: 
            case 252: 
            case 268: 
            case 276: 
            case 292: 
            case 300: 
            case 316: 
            case 324: {
                return this.cpu.ebp + this.getMicrocode() & 0xFFFF;
            }
            case 197: 
            case 205: 
            case 221: 
            case 229: 
            case 245: 
            case 253: 
            case 269: 
            case 277: 
            case 293: 
            case 301: 
            case 317: 
            case 325: {
                return this.cpu.ebx + this.getMicrocode() & 0xFFFF;
            }
            case 119: {
                return this.cpu.eax;
            }
            case 120: {
                return this.cpu.ecx;
            }
            case 121: {
                return this.cpu.edx;
            }
            case 122: {
                return this.cpu.ebx;
            }
            case 123: {
                return this.getMicrocode();
            }
            case 124: {
                return this.cpu.esi;
            }
            case 125: {
                return this.cpu.edi;
            }
            case 105: 
            case 126: {
                return this.cpu.eax + this.getMicrocode();
            }
            case 106: 
            case 127: {
                return this.cpu.ecx + this.getMicrocode();
            }
            case 107: 
            case 128: {
                return this.cpu.edx + this.getMicrocode();
            }
            case 108: 
            case 129: {
                return this.cpu.ebx + this.getMicrocode();
            }
            case 109: 
            case 130: {
                return this.cpu.ebp + this.getMicrocode();
            }
            case 110: 
            case 131: {
                return this.cpu.esi + this.getMicrocode();
            }
            case 111: 
            case 132: {
                return this.cpu.edi + this.getMicrocode();
            }
            case 112: 
            case 133: {
                return this.cpu.eax + this.getMicrocode();
            }
            case 113: 
            case 134: {
                return this.cpu.ecx + this.getMicrocode();
            }
            case 114: 
            case 135: {
                return this.cpu.edx + this.getMicrocode();
            }
            case 115: 
            case 136: {
                return this.cpu.ebx + this.getMicrocode();
            }
            case 116: 
            case 137: {
                return this.cpu.ebp + this.getMicrocode();
            }
            case 117: 
            case 138: {
                return this.cpu.esi + this.getMicrocode();
            }
            case 118: 
            case 139: {
                return this.cpu.edi + this.getMicrocode();
            }
            case 338: {
                return this.cpu.eax + this.cpu.eax;
            }
            case 339: {
                return this.cpu.eax + this.cpu.ecx;
            }
            case 340: {
                return this.cpu.eax + this.cpu.edx;
            }
            case 341: {
                return this.cpu.eax + this.cpu.ebx;
            }
            case 342: {
                return this.cpu.eax + this.cpu.esp;
            }
            case 343: {
                return this.cpu.eax + this.cpu.ebp;
            }
            case 344: {
                return this.cpu.eax + this.cpu.esi;
            }
            case 345: {
                return this.cpu.eax + this.cpu.edi;
            }
            case 346: {
                return this.cpu.ecx + this.cpu.ecx;
            }
            case 347: {
                return this.cpu.ecx + this.cpu.edx;
            }
            case 348: {
                return this.cpu.ecx + this.cpu.ebx;
            }
            case 349: 
            case 2161: {
                return this.cpu.ecx + this.cpu.esp;
            }
            case 350: 
            case 2162: {
                return this.cpu.ecx + this.cpu.ebp;
            }
            case 351: {
                return this.cpu.ecx + this.cpu.esi;
            }
            case 352: {
                return this.cpu.ecx + this.cpu.edi;
            }
            case 353: {
                return this.cpu.edx + this.cpu.edx;
            }
            case 354: {
                return this.cpu.edx + this.cpu.ebx;
            }
            case 355: {
                return this.cpu.edx + this.cpu.esp;
            }
            case 356: {
                return this.cpu.edx + this.cpu.ebp;
            }
            case 357: {
                return this.cpu.edx + this.cpu.esi;
            }
            case 358: {
                return this.cpu.edx + this.cpu.edi;
            }
            case 359: {
                return this.cpu.ebx + this.cpu.ebx;
            }
            case 360: {
                return this.cpu.ebx + this.cpu.esp;
            }
            case 361: {
                return this.cpu.ebx + this.cpu.ebp;
            }
            case 362: {
                return this.cpu.ebx + this.cpu.esi;
            }
            case 363: {
                return this.cpu.ebx + this.cpu.edi;
            }
            case 364: 
            case 2176: {
                return this.cpu.esp;
            }
            case 365: {
                return this.cpu.ebp + this.cpu.esp;
            }
            case 366: {
                return this.cpu.ebp + this.cpu.esi;
            }
            case 367: {
                return this.cpu.ebp + this.cpu.edi;
            }
            case 368: {
                return this.cpu.esi + this.cpu.esp;
            }
            case 369: {
                return this.cpu.esi + this.cpu.esi;
            }
            case 370: {
                return this.cpu.esi + this.cpu.edi;
            }
            case 371: 
            case 2183: {
                return this.cpu.edi + this.cpu.esp;
            }
            case 372: {
                return this.cpu.edi + this.cpu.edi;
            }
            case 373: {
                return (this.cpu.eax << 1) + this.cpu.eax;
            }
            case 374: {
                return (this.cpu.eax << 1) + this.cpu.ecx;
            }
            case 375: {
                return (this.cpu.eax << 1) + this.cpu.edx;
            }
            case 376: {
                return (this.cpu.eax << 1) + this.cpu.ebx;
            }
            case 377: {
                return (this.cpu.eax << 1) + this.cpu.esp;
            }
            case 378: {
                return (this.cpu.eax << 1) + this.getMicrocode();
            }
            case 379: {
                return (this.cpu.eax << 1) + this.cpu.esi;
            }
            case 380: {
                return (this.cpu.eax << 1) + this.cpu.edi;
            }
            case 381: {
                return (this.cpu.ecx << 1) + this.cpu.eax;
            }
            case 382: {
                return (this.cpu.ecx << 1) + this.cpu.ecx;
            }
            case 383: {
                return (this.cpu.ecx << 1) + this.cpu.edx;
            }
            case 384: {
                return (this.cpu.ecx << 1) + this.cpu.ebx;
            }
            case 385: {
                return (this.cpu.ecx << 1) + this.cpu.esp;
            }
            case 386: {
                return (this.cpu.ecx << 1) + this.getMicrocode();
            }
            case 387: {
                return (this.cpu.ecx << 1) + this.cpu.esi;
            }
            case 388: {
                return (this.cpu.ecx << 1) + this.cpu.edi;
            }
            case 389: {
                return (this.cpu.edx << 1) + this.cpu.eax;
            }
            case 390: {
                return (this.cpu.edx << 1) + this.cpu.ecx;
            }
            case 391: {
                return (this.cpu.edx << 1) + this.cpu.edx;
            }
            case 392: {
                return (this.cpu.edx << 1) + this.cpu.ebx;
            }
            case 393: {
                return (this.cpu.edx << 1) + this.cpu.esp;
            }
            case 394: {
                return (this.cpu.edx << 1) + this.getMicrocode();
            }
            case 395: {
                return (this.cpu.edx << 1) + this.cpu.esi;
            }
            case 396: {
                return (this.cpu.edx << 1) + this.cpu.edi;
            }
            case 397: {
                return (this.cpu.ebx << 1) + this.cpu.eax;
            }
            case 398: {
                return (this.cpu.ebx << 1) + this.cpu.ecx;
            }
            case 399: {
                return (this.cpu.ebx << 1) + this.cpu.edx;
            }
            case 400: {
                return (this.cpu.ebx << 1) + this.cpu.ebx;
            }
            case 401: {
                return (this.cpu.ebx << 1) + this.cpu.esp;
            }
            case 402: {
                return (this.cpu.ebx << 1) + this.getMicrocode();
            }
            case 403: {
                return (this.cpu.ebx << 1) + this.cpu.esi;
            }
            case 404: {
                return (this.cpu.ebx << 1) + this.cpu.edi;
            }
            case 405: {
                return (this.cpu.ebp << 1) + this.cpu.eax;
            }
            case 406: {
                return (this.cpu.ebp << 1) + this.cpu.ecx;
            }
            case 407: {
                return (this.cpu.ebp << 1) + this.cpu.edx;
            }
            case 408: {
                return (this.cpu.ebp << 1) + this.cpu.ebx;
            }
            case 409: {
                return (this.cpu.ebp << 1) + this.cpu.esp;
            }
            case 410: {
                return (this.cpu.ebp << 1) + this.getMicrocode();
            }
            case 411: {
                return (this.cpu.ebp << 1) + this.cpu.esi;
            }
            case 412: {
                return (this.cpu.ebp << 1) + this.cpu.edi;
            }
            case 413: {
                return (this.cpu.esi << 1) + this.cpu.eax;
            }
            case 414: {
                return (this.cpu.esi << 1) + this.cpu.ecx;
            }
            case 415: {
                return (this.cpu.esi << 1) + this.cpu.edx;
            }
            case 416: {
                return (this.cpu.esi << 1) + this.cpu.ebx;
            }
            case 417: {
                return (this.cpu.esi << 1) + this.cpu.esp;
            }
            case 418: {
                return (this.cpu.esi << 1) + this.getMicrocode();
            }
            case 419: {
                return (this.cpu.esi << 1) + this.cpu.esi;
            }
            case 420: {
                return (this.cpu.esi << 1) + this.cpu.edi;
            }
            case 421: {
                return (this.cpu.edi << 1) + this.cpu.eax;
            }
            case 422: {
                return (this.cpu.edi << 1) + this.cpu.ecx;
            }
            case 423: {
                return (this.cpu.edi << 1) + this.cpu.edx;
            }
            case 424: {
                return (this.cpu.edi << 1) + this.cpu.ebx;
            }
            case 425: {
                return (this.cpu.edi << 1) + this.cpu.esp;
            }
            case 426: {
                return (this.cpu.edi << 1) + this.getMicrocode();
            }
            case 427: {
                return (this.cpu.edi << 1) + this.cpu.esi;
            }
            case 428: {
                return (this.cpu.edi << 1) + this.cpu.edi;
            }
            case 429: {
                return (this.cpu.eax << 2) + this.cpu.eax;
            }
            case 430: {
                return (this.cpu.eax << 2) + this.cpu.ecx;
            }
            case 431: {
                return (this.cpu.eax << 2) + this.cpu.edx;
            }
            case 432: {
                return (this.cpu.eax << 2) + this.cpu.ebx;
            }
            case 433: 
            case 2245: {
                return (this.cpu.eax << 2) + this.cpu.esp;
            }
            case 434: {
                return (this.cpu.eax << 2) + this.getMicrocode();
            }
            case 435: {
                return (this.cpu.eax << 2) + this.cpu.esi;
            }
            case 436: {
                return (this.cpu.eax << 2) + this.cpu.edi;
            }
            case 437: {
                return (this.cpu.ecx << 2) + this.cpu.eax;
            }
            case 438: {
                return (this.cpu.ecx << 2) + this.cpu.ecx;
            }
            case 439: {
                return (this.cpu.ecx << 2) + this.cpu.edx;
            }
            case 440: {
                return (this.cpu.ecx << 2) + this.cpu.ebx;
            }
            case 441: {
                return (this.cpu.ecx << 2) + this.cpu.esp;
            }
            case 442: {
                return (this.cpu.ecx << 2) + this.getMicrocode();
            }
            case 443: {
                return (this.cpu.ecx << 2) + this.cpu.esi;
            }
            case 444: {
                return (this.cpu.ecx << 2) + this.cpu.edi;
            }
            case 445: {
                return (this.cpu.edx << 2) + this.cpu.eax;
            }
            case 446: {
                return (this.cpu.edx << 2) + this.cpu.ecx;
            }
            case 447: {
                return (this.cpu.edx << 2) + this.cpu.edx;
            }
            case 448: {
                return (this.cpu.edx << 2) + this.cpu.ebx;
            }
            case 449: {
                return (this.cpu.edx << 2) + this.cpu.esp;
            }
            case 450: {
                return (this.cpu.edx << 2) + this.getMicrocode();
            }
            case 451: {
                return (this.cpu.edx << 2) + this.cpu.esi;
            }
            case 452: {
                return (this.cpu.edx << 2) + this.cpu.edi;
            }
            case 453: {
                return (this.cpu.ebx << 2) + this.cpu.eax;
            }
            case 454: {
                return (this.cpu.ebx << 2) + this.cpu.ecx;
            }
            case 455: {
                return (this.cpu.ebx << 2) + this.cpu.edx;
            }
            case 456: {
                return (this.cpu.ebx << 2) + this.cpu.ebx;
            }
            case 457: {
                return (this.cpu.ebx << 2) + this.cpu.esp;
            }
            case 458: {
                return (this.cpu.ebx << 2) + this.getMicrocode();
            }
            case 459: {
                return (this.cpu.ebx << 2) + this.cpu.esi;
            }
            case 460: {
                return (this.cpu.ebx << 2) + this.cpu.edi;
            }
            case 461: {
                return (this.cpu.ebp << 2) + this.cpu.eax;
            }
            case 462: {
                return (this.cpu.ebp << 2) + this.cpu.ecx;
            }
            case 463: {
                return (this.cpu.ebp << 2) + this.cpu.edx;
            }
            case 464: {
                return (this.cpu.ebp << 2) + this.cpu.ebx;
            }
            case 465: {
                return (this.cpu.ebp << 2) + this.cpu.esp;
            }
            case 466: {
                return (this.cpu.ebp << 2) + this.getMicrocode();
            }
            case 467: {
                return (this.cpu.ebp << 2) + this.cpu.esi;
            }
            case 468: {
                return (this.cpu.ebp << 2) + this.cpu.edi;
            }
            case 469: {
                return (this.cpu.esi << 2) + this.cpu.eax;
            }
            case 470: {
                return (this.cpu.esi << 2) + this.cpu.ecx;
            }
            case 471: {
                return (this.cpu.esi << 2) + this.cpu.edx;
            }
            case 472: {
                return (this.cpu.esi << 2) + this.cpu.ebx;
            }
            case 473: {
                return (this.cpu.esi << 2) + this.cpu.esp;
            }
            case 474: {
                return (this.cpu.esi << 2) + this.getMicrocode();
            }
            case 475: {
                return (this.cpu.esi << 2) + this.cpu.esi;
            }
            case 476: {
                return (this.cpu.esi << 2) + this.cpu.edi;
            }
            case 477: {
                return (this.cpu.edi << 2) + this.cpu.eax;
            }
            case 478: {
                return (this.cpu.edi << 2) + this.cpu.ecx;
            }
            case 479: {
                return (this.cpu.edi << 2) + this.cpu.edx;
            }
            case 480: {
                return (this.cpu.edi << 2) + this.cpu.ebx;
            }
            case 481: {
                return (this.cpu.edi << 2) + this.cpu.esp;
            }
            case 482: {
                return (this.cpu.edi << 2) + this.getMicrocode();
            }
            case 483: {
                return (this.cpu.edi << 2) + this.cpu.esi;
            }
            case 484: {
                return (this.cpu.edi << 2) + this.cpu.edi;
            }
            case 485: {
                return (this.cpu.eax << 3) + this.cpu.eax;
            }
            case 486: {
                return (this.cpu.eax << 3) + this.cpu.ecx;
            }
            case 487: {
                return (this.cpu.eax << 3) + this.cpu.edx;
            }
            case 488: {
                return (this.cpu.eax << 3) + this.cpu.ebx;
            }
            case 489: {
                return (this.cpu.eax << 3) + this.cpu.esp;
            }
            case 490: {
                return (this.cpu.eax << 3) + this.getMicrocode();
            }
            case 491: {
                return (this.cpu.eax << 3) + this.cpu.esi;
            }
            case 492: {
                return (this.cpu.eax << 3) + this.cpu.edi;
            }
            case 493: {
                return (this.cpu.ecx << 3) + this.cpu.eax;
            }
            case 494: {
                return (this.cpu.ecx << 3) + this.cpu.ecx;
            }
            case 495: {
                return (this.cpu.ecx << 3) + this.cpu.edx;
            }
            case 496: {
                return (this.cpu.ecx << 3) + this.cpu.ebx;
            }
            case 497: {
                return (this.cpu.ecx << 3) + this.cpu.esp;
            }
            case 498: {
                return (this.cpu.ecx << 3) + this.getMicrocode();
            }
            case 499: {
                return (this.cpu.ecx << 3) + this.cpu.esi;
            }
            case 500: {
                return (this.cpu.ecx << 3) + this.cpu.edi;
            }
            case 501: {
                return (this.cpu.edx << 3) + this.cpu.eax;
            }
            case 502: {
                return (this.cpu.edx << 3) + this.cpu.ecx;
            }
            case 503: {
                return (this.cpu.edx << 3) + this.cpu.edx;
            }
            case 504: {
                return (this.cpu.edx << 3) + this.cpu.ebx;
            }
            case 505: {
                return (this.cpu.edx << 3) + this.cpu.esp;
            }
            case 506: {
                return (this.cpu.edx << 3) + this.getMicrocode();
            }
            case 507: {
                return (this.cpu.edx << 3) + this.cpu.esi;
            }
            case 508: {
                return (this.cpu.edx << 3) + this.cpu.edi;
            }
            case 509: {
                return (this.cpu.ebx << 3) + this.cpu.eax;
            }
            case 510: {
                return (this.cpu.ebx << 3) + this.cpu.ecx;
            }
            case 511: {
                return (this.cpu.ebx << 3) + this.cpu.edx;
            }
            case 512: {
                return (this.cpu.ebx << 3) + this.cpu.ebx;
            }
            case 513: {
                return (this.cpu.ebx << 3) + this.cpu.esp;
            }
            case 514: {
                return (this.cpu.ebx << 3) + this.getMicrocode();
            }
            case 515: {
                return (this.cpu.ebx << 3) + this.cpu.esi;
            }
            case 516: {
                return (this.cpu.ebx << 3) + this.cpu.edi;
            }
            case 517: {
                return (this.cpu.ebp << 3) + this.cpu.eax;
            }
            case 518: {
                return (this.cpu.ebp << 3) + this.cpu.ecx;
            }
            case 519: {
                return (this.cpu.ebp << 3) + this.cpu.edx;
            }
            case 520: {
                return (this.cpu.ebp << 3) + this.cpu.ebx;
            }
            case 521: {
                return (this.cpu.ebp << 3) + this.cpu.esp;
            }
            case 522: {
                return (this.cpu.ebp << 3) + this.getMicrocode();
            }
            case 523: {
                return (this.cpu.ebp << 3) + this.cpu.esi;
            }
            case 524: {
                return (this.cpu.ebp << 3) + this.cpu.edi;
            }
            case 525: {
                return (this.cpu.esi << 3) + this.cpu.eax;
            }
            case 526: {
                return (this.cpu.esi << 3) + this.cpu.ecx;
            }
            case 527: {
                return (this.cpu.esi << 3) + this.cpu.edx;
            }
            case 528: {
                return (this.cpu.esi << 3) + this.cpu.ebx;
            }
            case 529: {
                return (this.cpu.esi << 3) + this.cpu.esp;
            }
            case 530: {
                return (this.cpu.esi << 3) + this.getMicrocode();
            }
            case 531: {
                return (this.cpu.esi << 3) + this.cpu.esi;
            }
            case 532: {
                return (this.cpu.esi << 3) + this.cpu.edi;
            }
            case 533: {
                return (this.cpu.edi << 3) + this.cpu.eax;
            }
            case 534: {
                return (this.cpu.edi << 3) + this.cpu.ecx;
            }
            case 535: {
                return (this.cpu.edi << 3) + this.cpu.edx;
            }
            case 536: {
                return (this.cpu.edi << 3) + this.cpu.ebx;
            }
            case 537: {
                return (this.cpu.edi << 3) + this.cpu.esp;
            }
            case 538: {
                return (this.cpu.edi << 3) + this.getMicrocode();
            }
            case 539: {
                return (this.cpu.edi << 3) + this.cpu.esi;
            }
            case 540: {
                return (this.cpu.edi << 3) + this.cpu.edi;
            }
            case 541: {
                return this.cpu.eax + this.cpu.eax + this.getMicrocode();
            }
            case 542: {
                return this.cpu.eax + this.cpu.ecx + this.getMicrocode();
            }
            case 543: {
                return this.cpu.eax + this.cpu.edx + this.getMicrocode();
            }
            case 544: {
                return this.cpu.eax + this.cpu.ebx + this.getMicrocode();
            }
            case 545: 
            case 2357: {
                return this.cpu.eax + this.cpu.esp + this.getMicrocode();
            }
            case 546: 
            case 2358: {
                return this.cpu.eax + this.cpu.ebp + this.getMicrocode();
            }
            case 547: {
                return this.cpu.eax + this.cpu.esi + this.getMicrocode();
            }
            case 548: {
                return this.cpu.eax + this.cpu.edi + this.getMicrocode();
            }
            case 549: {
                return this.cpu.ecx + this.cpu.ecx + this.getMicrocode();
            }
            case 550: {
                return this.cpu.ecx + this.cpu.edx + this.getMicrocode();
            }
            case 551: {
                return this.cpu.ecx + this.cpu.ebx + this.getMicrocode();
            }
            case 552: 
            case 2364: {
                return this.cpu.ecx + this.cpu.esp + this.getMicrocode();
            }
            case 553: 
            case 2365: {
                return this.cpu.ecx + this.cpu.ebp + this.getMicrocode();
            }
            case 554: {
                return this.cpu.ecx + this.cpu.esi + this.getMicrocode();
            }
            case 555: {
                return this.cpu.ecx + this.cpu.edi + this.getMicrocode();
            }
            case 556: {
                return this.cpu.edx + this.cpu.edx + this.getMicrocode();
            }
            case 557: {
                return this.cpu.edx + this.cpu.ebx + this.getMicrocode();
            }
            case 558: 
            case 2370: {
                return this.cpu.edx + this.cpu.esp + this.getMicrocode();
            }
            case 559: 
            case 2371: {
                return this.cpu.edx + this.cpu.ebp + this.getMicrocode();
            }
            case 560: {
                return this.cpu.edx + this.cpu.esi + this.getMicrocode();
            }
            case 561: {
                return this.cpu.edx + this.cpu.edi + this.getMicrocode();
            }
            case 562: {
                return this.cpu.ebx + this.cpu.ebx + this.getMicrocode();
            }
            case 563: 
            case 2375: {
                return this.cpu.ebx + this.cpu.esp + this.getMicrocode();
            }
            case 564: 
            case 2376: {
                return this.cpu.ebx + this.cpu.ebp + this.getMicrocode();
            }
            case 565: {
                return this.cpu.ebx + this.cpu.esi + this.getMicrocode();
            }
            case 566: {
                return this.cpu.ebx + this.cpu.edi + this.getMicrocode();
            }
            case 567: 
            case 2379: {
                return this.cpu.esp + this.getMicrocode();
            }
            case 568: {
                return this.cpu.ebp + this.cpu.esp + this.getMicrocode();
            }
            case 569: 
            case 2381: {
                return this.cpu.ebp + this.cpu.ebp + this.getMicrocode();
            }
            case 570: 
            case 2382: {
                return this.cpu.ebp + this.cpu.esi + this.getMicrocode();
            }
            case 571: 
            case 2383: {
                return this.cpu.ebp + this.cpu.edi + this.getMicrocode();
            }
            case 572: 
            case 2384: {
                return this.cpu.esi + this.cpu.esp + this.getMicrocode();
            }
            case 573: {
                return this.cpu.esi + this.cpu.esi + this.getMicrocode();
            }
            case 574: {
                return this.cpu.esi + this.cpu.edi + this.getMicrocode();
            }
            case 575: {
                return this.cpu.edi + this.cpu.esp + this.getMicrocode();
            }
            case 576: {
                return this.cpu.edi + this.cpu.edi + this.getMicrocode();
            }
            case 577: {
                return (this.cpu.eax << 1) + this.cpu.eax + this.getMicrocode();
            }
            case 578: {
                return (this.cpu.eax << 1) + this.cpu.ecx + this.getMicrocode();
            }
            case 579: {
                return (this.cpu.eax << 1) + this.cpu.edx + this.getMicrocode();
            }
            case 580: {
                return (this.cpu.eax << 1) + this.cpu.ebx + this.getMicrocode();
            }
            case 581: {
                return (this.cpu.eax << 1) + this.cpu.esp + this.getMicrocode();
            }
            case 582: 
            case 2394: {
                return (this.cpu.eax << 1) + this.cpu.ebp + this.getMicrocode();
            }
            case 583: {
                return (this.cpu.eax << 1) + this.cpu.esi + this.getMicrocode();
            }
            case 584: {
                return (this.cpu.eax << 1) + this.cpu.edi + this.getMicrocode();
            }
            case 585: {
                return (this.cpu.ecx << 1) + this.cpu.eax + this.getMicrocode();
            }
            case 586: {
                return (this.cpu.ecx << 1) + this.cpu.ecx + this.getMicrocode();
            }
            case 587: {
                return (this.cpu.ecx << 1) + this.cpu.edx + this.getMicrocode();
            }
            case 588: {
                return (this.cpu.ecx << 1) + this.cpu.ebx + this.getMicrocode();
            }
            case 589: {
                return (this.cpu.ecx << 1) + this.cpu.esp + this.getMicrocode();
            }
            case 590: {
                return (this.cpu.ecx << 1) + this.cpu.ebp + this.getMicrocode();
            }
            case 591: {
                return (this.cpu.ecx << 1) + this.cpu.esi + this.getMicrocode();
            }
            case 592: {
                return (this.cpu.ecx << 1) + this.cpu.edi + this.getMicrocode();
            }
            case 593: {
                return (this.cpu.edx << 1) + this.cpu.eax + this.getMicrocode();
            }
            case 594: {
                return (this.cpu.edx << 1) + this.cpu.ecx + this.getMicrocode();
            }
            case 595: {
                return (this.cpu.edx << 1) + this.cpu.edx + this.getMicrocode();
            }
            case 596: {
                return (this.cpu.edx << 1) + this.cpu.ebx + this.getMicrocode();
            }
            case 597: 
            case 2409: {
                return (this.cpu.edx << 1) + this.cpu.esp + this.getMicrocode();
            }
            case 598: 
            case 2410: {
                return (this.cpu.edx << 1) + this.cpu.ebp + this.getMicrocode();
            }
            case 599: {
                return (this.cpu.edx << 1) + this.cpu.esi + this.getMicrocode();
            }
            case 600: {
                return (this.cpu.edx << 1) + this.cpu.edi + this.getMicrocode();
            }
            case 601: {
                return (this.cpu.ebx << 1) + this.cpu.eax + this.getMicrocode();
            }
            case 602: {
                return (this.cpu.ebx << 1) + this.cpu.ecx + this.getMicrocode();
            }
            case 603: {
                return (this.cpu.ebx << 1) + this.cpu.edx + this.getMicrocode();
            }
            case 604: {
                return (this.cpu.ebx << 1) + this.cpu.ebx + this.getMicrocode();
            }
            case 605: {
                return (this.cpu.ebx << 1) + this.cpu.esp + this.getMicrocode();
            }
            case 606: {
                return (this.cpu.ebx << 1) + this.cpu.ebp + this.getMicrocode();
            }
            case 607: {
                return (this.cpu.ebx << 1) + this.cpu.esi + this.getMicrocode();
            }
            case 608: {
                return (this.cpu.ebx << 1) + this.cpu.edi + this.getMicrocode();
            }
            case 609: {
                return (this.cpu.ebp << 1) + this.cpu.eax + this.getMicrocode();
            }
            case 610: {
                return (this.cpu.ebp << 1) + this.cpu.ecx + this.getMicrocode();
            }
            case 611: {
                return (this.cpu.ebp << 1) + this.cpu.edx + this.getMicrocode();
            }
            case 612: {
                return (this.cpu.ebp << 1) + this.cpu.ebx + this.getMicrocode();
            }
            case 613: {
                return (this.cpu.ebp << 1) + this.cpu.esp + this.getMicrocode();
            }
            case 614: 
            case 2426: {
                return (this.cpu.ebp << 1) + this.cpu.ebp + this.getMicrocode();
            }
            case 615: {
                return (this.cpu.ebp << 1) + this.cpu.esi + this.getMicrocode();
            }
            case 616: {
                return (this.cpu.ebp << 1) + this.cpu.edi + this.getMicrocode();
            }
            case 617: {
                return (this.cpu.esi << 1) + this.cpu.eax + this.getMicrocode();
            }
            case 618: {
                return (this.cpu.esi << 1) + this.cpu.ecx + this.getMicrocode();
            }
            case 619: {
                return (this.cpu.esi << 1) + this.cpu.edx + this.getMicrocode();
            }
            case 620: {
                return (this.cpu.esi << 1) + this.cpu.ebx + this.getMicrocode();
            }
            case 621: {
                return (this.cpu.esi << 1) + this.cpu.esp + this.getMicrocode();
            }
            case 622: {
                return (this.cpu.esi << 1) + this.cpu.ebp + this.getMicrocode();
            }
            case 623: {
                return (this.cpu.esi << 1) + this.cpu.esi + this.getMicrocode();
            }
            case 624: {
                return (this.cpu.esi << 1) + this.cpu.edi + this.getMicrocode();
            }
            case 625: {
                return (this.cpu.edi << 1) + this.cpu.eax + this.getMicrocode();
            }
            case 626: {
                return (this.cpu.edi << 1) + this.cpu.ecx + this.getMicrocode();
            }
            case 627: {
                return (this.cpu.edi << 1) + this.cpu.edx + this.getMicrocode();
            }
            case 628: {
                return (this.cpu.edi << 1) + this.cpu.ebx + this.getMicrocode();
            }
            case 629: 
            case 2441: {
                return (this.cpu.edi << 1) + this.cpu.esp + this.getMicrocode();
            }
            case 630: 
            case 2442: {
                return (this.cpu.edi << 1) + this.cpu.ebp + this.getMicrocode();
            }
            case 631: {
                return (this.cpu.edi << 1) + this.cpu.esi + this.getMicrocode();
            }
            case 632: {
                return (this.cpu.edi << 1) + this.cpu.edi + this.getMicrocode();
            }
            case 633: {
                return (this.cpu.eax << 2) + this.cpu.eax + this.getMicrocode();
            }
            case 634: {
                return (this.cpu.eax << 2) + this.cpu.ecx + this.getMicrocode();
            }
            case 635: {
                return (this.cpu.eax << 2) + this.cpu.edx + this.getMicrocode();
            }
            case 636: {
                return (this.cpu.eax << 2) + this.cpu.ebx + this.getMicrocode();
            }
            case 637: 
            case 2449: {
                return (this.cpu.eax << 2) + this.cpu.esp + this.getMicrocode();
            }
            case 638: 
            case 2450: {
                return (this.cpu.eax << 2) + this.cpu.ebp + this.getMicrocode();
            }
            case 639: {
                return (this.cpu.eax << 2) + this.cpu.esi + this.getMicrocode();
            }
            case 640: {
                return (this.cpu.eax << 2) + this.cpu.edi + this.getMicrocode();
            }
            case 641: {
                return (this.cpu.ecx << 2) + this.cpu.eax + this.getMicrocode();
            }
            case 642: {
                return (this.cpu.ecx << 2) + this.cpu.ecx + this.getMicrocode();
            }
            case 643: {
                return (this.cpu.ecx << 2) + this.cpu.edx + this.getMicrocode();
            }
            case 644: {
                return (this.cpu.ecx << 2) + this.cpu.ebx + this.getMicrocode();
            }
            case 645: 
            case 2457: {
                return (this.cpu.ecx << 2) + this.cpu.esp + this.getMicrocode();
            }
            case 646: 
            case 2458: {
                return (this.cpu.ecx << 2) + this.cpu.ebp + this.getMicrocode();
            }
            case 647: {
                return (this.cpu.ecx << 2) + this.cpu.esi + this.getMicrocode();
            }
            case 648: {
                return (this.cpu.ecx << 2) + this.cpu.edi + this.getMicrocode();
            }
            case 649: {
                return (this.cpu.edx << 2) + this.cpu.eax + this.getMicrocode();
            }
            case 650: {
                return (this.cpu.edx << 2) + this.cpu.ecx + this.getMicrocode();
            }
            case 651: {
                return (this.cpu.edx << 2) + this.cpu.edx + this.getMicrocode();
            }
            case 652: {
                return (this.cpu.edx << 2) + this.cpu.ebx + this.getMicrocode();
            }
            case 653: 
            case 2465: {
                return (this.cpu.edx << 2) + this.cpu.esp + this.getMicrocode();
            }
            case 654: 
            case 2466: {
                return (this.cpu.edx << 2) + this.cpu.ebp + this.getMicrocode();
            }
            case 655: {
                return (this.cpu.edx << 2) + this.cpu.esi + this.getMicrocode();
            }
            case 656: {
                return (this.cpu.edx << 2) + this.cpu.edi + this.getMicrocode();
            }
            case 657: {
                return (this.cpu.ebx << 2) + this.cpu.eax + this.getMicrocode();
            }
            case 658: {
                return (this.cpu.ebx << 2) + this.cpu.ecx + this.getMicrocode();
            }
            case 659: {
                return (this.cpu.ebx << 2) + this.cpu.edx + this.getMicrocode();
            }
            case 660: {
                return (this.cpu.ebx << 2) + this.cpu.ebx + this.getMicrocode();
            }
            case 661: 
            case 2473: {
                return (this.cpu.ebx << 2) + this.cpu.esp + this.getMicrocode();
            }
            case 662: 
            case 2474: {
                return (this.cpu.ebx << 2) + this.cpu.ebp + this.getMicrocode();
            }
            case 663: {
                return (this.cpu.ebx << 2) + this.cpu.esi + this.getMicrocode();
            }
            case 664: {
                return (this.cpu.ebx << 2) + this.cpu.edi + this.getMicrocode();
            }
            case 665: {
                return (this.cpu.ebp << 2) + this.cpu.eax + this.getMicrocode();
            }
            case 666: {
                return (this.cpu.ebp << 2) + this.cpu.ecx + this.getMicrocode();
            }
            case 667: {
                return (this.cpu.ebp << 2) + this.cpu.edx + this.getMicrocode();
            }
            case 668: {
                return (this.cpu.ebp << 2) + this.cpu.ebx + this.getMicrocode();
            }
            case 669: {
                return (this.cpu.ebp << 2) + this.cpu.esp + this.getMicrocode();
            }
            case 670: 
            case 2482: {
                return (this.cpu.ebp << 2) + this.cpu.ebp + this.getMicrocode();
            }
            case 671: {
                return (this.cpu.ebp << 2) + this.cpu.esi + this.getMicrocode();
            }
            case 672: {
                return (this.cpu.ebp << 2) + this.cpu.edi + this.getMicrocode();
            }
            case 673: {
                return (this.cpu.esi << 2) + this.cpu.eax + this.getMicrocode();
            }
            case 674: {
                return (this.cpu.esi << 2) + this.cpu.ecx + this.getMicrocode();
            }
            case 675: {
                return (this.cpu.esi << 2) + this.cpu.edx + this.getMicrocode();
            }
            case 676: {
                return (this.cpu.esi << 2) + this.cpu.ebx + this.getMicrocode();
            }
            case 677: 
            case 2489: {
                return (this.cpu.esi << 2) + this.cpu.esp + this.getMicrocode();
            }
            case 678: 
            case 2490: {
                return (this.cpu.esi << 2) + this.cpu.ebp + this.getMicrocode();
            }
            case 679: {
                return (this.cpu.esi << 2) + this.cpu.esi + this.getMicrocode();
            }
            case 680: {
                return (this.cpu.esi << 2) + this.cpu.edi + this.getMicrocode();
            }
            case 681: {
                return (this.cpu.edi << 2) + this.cpu.eax + this.getMicrocode();
            }
            case 682: {
                return (this.cpu.edi << 2) + this.cpu.ecx + this.getMicrocode();
            }
            case 683: {
                return (this.cpu.edi << 2) + this.cpu.edx + this.getMicrocode();
            }
            case 684: {
                return (this.cpu.edi << 2) + this.cpu.ebx + this.getMicrocode();
            }
            case 685: 
            case 2497: {
                return (this.cpu.edi << 2) + this.cpu.esp + this.getMicrocode();
            }
            case 686: 
            case 2498: {
                return (this.cpu.edi << 2) + this.cpu.ebp + this.getMicrocode();
            }
            case 687: {
                return (this.cpu.edi << 2) + this.cpu.esi + this.getMicrocode();
            }
            case 688: {
                return (this.cpu.edi << 2) + this.cpu.edi + this.getMicrocode();
            }
            case 689: {
                return (this.cpu.eax << 3) + this.cpu.eax + this.getMicrocode();
            }
            case 690: {
                return (this.cpu.eax << 3) + this.cpu.ecx + this.getMicrocode();
            }
            case 691: {
                return (this.cpu.eax << 3) + this.cpu.edx + this.getMicrocode();
            }
            case 692: {
                return (this.cpu.eax << 3) + this.cpu.ebx + this.getMicrocode();
            }
            case 693: 
            case 2505: {
                return (this.cpu.eax << 3) + this.cpu.esp + this.getMicrocode();
            }
            case 694: 
            case 2506: {
                return (this.cpu.eax << 3) + this.cpu.ebp + this.getMicrocode();
            }
            case 695: {
                return (this.cpu.eax << 3) + this.cpu.esi + this.getMicrocode();
            }
            case 696: {
                return (this.cpu.eax << 3) + this.cpu.edi + this.getMicrocode();
            }
            case 697: {
                return (this.cpu.ecx << 3) + this.cpu.eax + this.getMicrocode();
            }
            case 698: {
                return (this.cpu.ecx << 3) + this.cpu.ecx + this.getMicrocode();
            }
            case 699: {
                return (this.cpu.ecx << 3) + this.cpu.edx + this.getMicrocode();
            }
            case 700: {
                return (this.cpu.ecx << 3) + this.cpu.ebx + this.getMicrocode();
            }
            case 701: {
                return (this.cpu.ecx << 3) + this.cpu.esp + this.getMicrocode();
            }
            case 702: {
                return (this.cpu.ecx << 3) + this.cpu.ebp + this.getMicrocode();
            }
            case 703: {
                return (this.cpu.ecx << 3) + this.cpu.esi + this.getMicrocode();
            }
            case 704: {
                return (this.cpu.ecx << 3) + this.cpu.edi + this.getMicrocode();
            }
            case 705: {
                return (this.cpu.edx << 3) + this.cpu.eax + this.getMicrocode();
            }
            case 706: {
                return (this.cpu.edx << 3) + this.cpu.ecx + this.getMicrocode();
            }
            case 707: {
                return (this.cpu.edx << 3) + this.cpu.edx + this.getMicrocode();
            }
            case 708: {
                return (this.cpu.edx << 3) + this.cpu.ebx + this.getMicrocode();
            }
            case 709: {
                return (this.cpu.edx << 3) + this.cpu.esp + this.getMicrocode();
            }
            case 710: {
                return (this.cpu.edx << 3) + this.cpu.ebp + this.getMicrocode();
            }
            case 711: {
                return (this.cpu.edx << 3) + this.cpu.esi + this.getMicrocode();
            }
            case 712: {
                return (this.cpu.edx << 3) + this.cpu.edi + this.getMicrocode();
            }
            case 713: {
                return (this.cpu.ebx << 3) + this.cpu.eax + this.getMicrocode();
            }
            case 714: {
                return (this.cpu.ebx << 3) + this.cpu.ecx + this.getMicrocode();
            }
            case 715: {
                return (this.cpu.ebx << 3) + this.cpu.edx + this.getMicrocode();
            }
            case 716: {
                return (this.cpu.ebx << 3) + this.cpu.ebx + this.getMicrocode();
            }
            case 717: 
            case 2529: {
                return (this.cpu.ebx << 3) + this.cpu.esp + this.getMicrocode();
            }
            case 718: 
            case 2530: {
                return (this.cpu.ebx << 3) + this.cpu.ebp + this.getMicrocode();
            }
            case 719: {
                return (this.cpu.ebx << 3) + this.cpu.esi + this.getMicrocode();
            }
            case 720: {
                return (this.cpu.ebx << 3) + this.cpu.edi + this.getMicrocode();
            }
            case 721: {
                return (this.cpu.ebp << 3) + this.cpu.eax + this.getMicrocode();
            }
            case 722: {
                return (this.cpu.ebp << 3) + this.cpu.ecx + this.getMicrocode();
            }
            case 723: {
                return (this.cpu.ebp << 3) + this.cpu.edx + this.getMicrocode();
            }
            case 724: {
                return (this.cpu.ebp << 3) + this.cpu.ebx + this.getMicrocode();
            }
            case 725: 
            case 2537: {
                return (this.cpu.ebp << 3) + this.cpu.esp + this.getMicrocode();
            }
            case 726: 
            case 2538: {
                return (this.cpu.ebp << 3) + this.cpu.ebp + this.getMicrocode();
            }
            case 727: {
                return (this.cpu.ebp << 3) + this.cpu.esi + this.getMicrocode();
            }
            case 728: {
                return (this.cpu.ebp << 3) + this.cpu.edi + this.getMicrocode();
            }
            case 729: {
                return (this.cpu.esi << 3) + this.cpu.eax + this.getMicrocode();
            }
            case 730: {
                return (this.cpu.esi << 3) + this.cpu.ecx + this.getMicrocode();
            }
            case 731: {
                return (this.cpu.esi << 3) + this.cpu.edx + this.getMicrocode();
            }
            case 732: {
                return (this.cpu.esi << 3) + this.cpu.ebx + this.getMicrocode();
            }
            case 733: 
            case 2545: {
                return (this.cpu.esi << 3) + this.cpu.esp + this.getMicrocode();
            }
            case 734: 
            case 2546: {
                return (this.cpu.esi << 3) + this.cpu.ebp + this.getMicrocode();
            }
            case 735: {
                return (this.cpu.esi << 3) + this.cpu.esi + this.getMicrocode();
            }
            case 736: {
                return (this.cpu.esi << 3) + this.cpu.edi + this.getMicrocode();
            }
            case 737: {
                return (this.cpu.edi << 3) + this.cpu.eax + this.getMicrocode();
            }
            case 738: {
                return (this.cpu.edi << 3) + this.cpu.ecx + this.getMicrocode();
            }
            case 739: {
                return (this.cpu.edi << 3) + this.cpu.edx + this.getMicrocode();
            }
            case 740: {
                return (this.cpu.edi << 3) + this.cpu.ebx + this.getMicrocode();
            }
            case 741: 
            case 2553: {
                return (this.cpu.edi << 3) + this.cpu.esp + this.getMicrocode();
            }
            case 742: 
            case 2554: {
                return (this.cpu.edi << 3) + this.cpu.ebp + this.getMicrocode();
            }
            case 743: {
                return (this.cpu.edi << 3) + this.cpu.esi + this.getMicrocode();
            }
            case 744: {
                return (this.cpu.edi << 3) + this.cpu.edi + this.getMicrocode();
            }
            case 745: {
                return this.cpu.eax + this.cpu.ecx + this.getMicrocode();
            }
            case 746: {
                return this.cpu.eax + this.cpu.edx + this.getMicrocode();
            }
            case 747: {
                return this.cpu.eax + this.cpu.ebx + this.getMicrocode();
            }
            case 748: 
            case 2560: {
                return this.cpu.eax + this.cpu.esp + this.getMicrocode();
            }
            case 749: 
            case 2561: {
                return this.cpu.eax + this.cpu.ebp + this.getMicrocode();
            }
            case 750: {
                return this.cpu.eax + this.cpu.esi + this.getMicrocode();
            }
            case 751: {
                return this.cpu.eax + this.cpu.edi + this.getMicrocode();
            }
            case 752: {
                return this.cpu.ecx + this.cpu.edx + this.getMicrocode();
            }
            case 753: {
                return this.cpu.ecx + this.cpu.ebx + this.getMicrocode();
            }
            case 754: 
            case 2566: {
                return this.cpu.ecx + this.cpu.esp + this.getMicrocode();
            }
            case 755: 
            case 2567: {
                return this.cpu.ecx + this.cpu.ebp + this.getMicrocode();
            }
            case 756: {
                return this.cpu.ecx + this.cpu.esi + this.getMicrocode();
            }
            case 757: {
                return this.cpu.ecx + this.cpu.edi + this.getMicrocode();
            }
            case 758: {
                return this.cpu.edx + this.cpu.ebx + this.getMicrocode();
            }
            case 759: {
                return this.cpu.edx + this.cpu.esp + this.getMicrocode();
            }
            case 760: {
                return this.cpu.edx + this.cpu.ebp + this.getMicrocode();
            }
            case 761: {
                return this.cpu.edx + this.cpu.esi + this.getMicrocode();
            }
            case 762: {
                return this.cpu.edx + this.cpu.edi + this.getMicrocode();
            }
            case 763: {
                return this.cpu.ebx + this.cpu.esp + this.getMicrocode();
            }
            case 764: {
                return this.cpu.ebx + this.cpu.ebp + this.getMicrocode();
            }
            case 765: {
                return this.cpu.ebx + this.cpu.esi + this.getMicrocode();
            }
            case 766: {
                return this.cpu.ebx + this.cpu.edi + this.getMicrocode();
            }
            case 767: 
            case 2579: {
                return this.cpu.esp + this.getMicrocode();
            }
            case 768: {
                return this.cpu.ebp + this.cpu.esp + this.getMicrocode();
            }
            case 769: {
                return this.cpu.ebp + this.cpu.esi + this.getMicrocode();
            }
            case 770: 
            case 2582: {
                return this.cpu.ebp + this.cpu.edi + this.getMicrocode();
            }
            case 771: 
            case 2583: {
                return this.cpu.esi + this.cpu.esp + this.getMicrocode();
            }
            case 772: {
                return this.cpu.esi + this.cpu.edi + this.getMicrocode();
            }
            case 773: {
                return this.cpu.edi + this.cpu.esp + this.getMicrocode();
            }
            case 774: {
                return (this.cpu.eax << 1) + this.cpu.eax + this.getMicrocode();
            }
            case 775: {
                return (this.cpu.eax << 1) + this.cpu.ecx + this.getMicrocode();
            }
            case 776: {
                return (this.cpu.eax << 1) + this.cpu.edx + this.getMicrocode();
            }
            case 777: {
                return (this.cpu.eax << 1) + this.cpu.ebx + this.getMicrocode();
            }
            case 778: {
                return (this.cpu.eax << 1) + this.cpu.esp + this.getMicrocode();
            }
            case 779: {
                return (this.cpu.eax << 1) + this.cpu.ebp + this.getMicrocode();
            }
            case 780: {
                return (this.cpu.eax << 1) + this.cpu.esi + this.getMicrocode();
            }
            case 781: {
                return (this.cpu.eax << 1) + this.cpu.edi + this.getMicrocode();
            }
            case 782: {
                return (this.cpu.ecx << 1) + this.cpu.eax + this.getMicrocode();
            }
            case 783: {
                return (this.cpu.ecx << 1) + this.cpu.ecx + this.getMicrocode();
            }
            case 784: {
                return (this.cpu.ecx << 1) + this.cpu.edx + this.getMicrocode();
            }
            case 785: {
                return (this.cpu.ecx << 1) + this.cpu.ebx + this.getMicrocode();
            }
            case 786: {
                return (this.cpu.ecx << 1) + this.cpu.esp + this.getMicrocode();
            }
            case 787: {
                return (this.cpu.ecx << 1) + this.cpu.ebp + this.getMicrocode();
            }
            case 788: {
                return (this.cpu.ecx << 1) + this.cpu.esi + this.getMicrocode();
            }
            case 789: {
                return (this.cpu.ecx << 1) + this.cpu.edi + this.getMicrocode();
            }
            case 790: {
                return (this.cpu.edx << 1) + this.cpu.eax + this.getMicrocode();
            }
            case 791: {
                return (this.cpu.edx << 1) + this.cpu.ecx + this.getMicrocode();
            }
            case 792: {
                return (this.cpu.edx << 1) + this.cpu.edx + this.getMicrocode();
            }
            case 793: {
                return (this.cpu.edx << 1) + this.cpu.ebx + this.getMicrocode();
            }
            case 794: {
                return (this.cpu.edx << 1) + this.cpu.esp + this.getMicrocode();
            }
            case 795: {
                return (this.cpu.edx << 1) + this.cpu.ebp + this.getMicrocode();
            }
            case 796: {
                return (this.cpu.edx << 1) + this.cpu.esi + this.getMicrocode();
            }
            case 797: {
                return (this.cpu.edx << 1) + this.cpu.edi + this.getMicrocode();
            }
            case 798: {
                return (this.cpu.ebx << 1) + this.cpu.eax + this.getMicrocode();
            }
            case 799: {
                return (this.cpu.ebx << 1) + this.cpu.ecx + this.getMicrocode();
            }
            case 800: {
                return (this.cpu.ebx << 1) + this.cpu.edx + this.getMicrocode();
            }
            case 801: {
                return (this.cpu.ebx << 1) + this.cpu.ebx + this.getMicrocode();
            }
            case 802: {
                return (this.cpu.ebx << 1) + this.cpu.esp + this.getMicrocode();
            }
            case 803: {
                return (this.cpu.ebx << 1) + this.cpu.ebp + this.getMicrocode();
            }
            case 804: {
                return (this.cpu.ebx << 1) + this.cpu.esi + this.getMicrocode();
            }
            case 805: {
                return (this.cpu.ebx << 1) + this.cpu.edi + this.getMicrocode();
            }
            case 806: {
                return (this.cpu.ebp << 1) + this.cpu.eax + this.getMicrocode();
            }
            case 807: {
                return (this.cpu.ebp << 1) + this.cpu.ecx + this.getMicrocode();
            }
            case 808: {
                return (this.cpu.ebp << 1) + this.cpu.edx + this.getMicrocode();
            }
            case 809: {
                return (this.cpu.ebp << 1) + this.cpu.ebx + this.getMicrocode();
            }
            case 810: {
                return (this.cpu.ebp << 1) + this.cpu.esp + this.getMicrocode();
            }
            case 811: {
                return (this.cpu.ebp << 1) + this.cpu.ebp + this.getMicrocode();
            }
            case 812: {
                return (this.cpu.ebp << 1) + this.cpu.esi + this.getMicrocode();
            }
            case 813: {
                return (this.cpu.ebp << 1) + this.cpu.edi + this.getMicrocode();
            }
            case 814: {
                return (this.cpu.esi << 1) + this.cpu.eax + this.getMicrocode();
            }
            case 815: {
                return (this.cpu.esi << 1) + this.cpu.ecx + this.getMicrocode();
            }
            case 816: {
                return (this.cpu.esi << 1) + this.cpu.edx + this.getMicrocode();
            }
            case 817: {
                return (this.cpu.esi << 1) + this.cpu.ebx + this.getMicrocode();
            }
            case 818: {
                return (this.cpu.esi << 1) + this.cpu.esp + this.getMicrocode();
            }
            case 819: {
                return (this.cpu.esi << 1) + this.cpu.ebp + this.getMicrocode();
            }
            case 820: {
                return (this.cpu.esi << 1) + this.cpu.esi + this.getMicrocode();
            }
            case 821: {
                return (this.cpu.esi << 1) + this.cpu.edi + this.getMicrocode();
            }
            case 822: {
                return (this.cpu.edi << 1) + this.cpu.eax + this.getMicrocode();
            }
            case 823: {
                return (this.cpu.edi << 1) + this.cpu.ecx + this.getMicrocode();
            }
            case 824: {
                return (this.cpu.edi << 1) + this.cpu.edx + this.getMicrocode();
            }
            case 825: {
                return (this.cpu.edi << 1) + this.cpu.ebx + this.getMicrocode();
            }
            case 826: {
                return (this.cpu.edi << 1) + this.cpu.esp + this.getMicrocode();
            }
            case 827: {
                return (this.cpu.edi << 1) + this.cpu.ebp + this.getMicrocode();
            }
            case 828: {
                return (this.cpu.edi << 1) + this.cpu.esi + this.getMicrocode();
            }
            case 829: {
                return (this.cpu.edi << 1) + this.cpu.edi + this.getMicrocode();
            }
            case 830: {
                return (this.cpu.eax << 2) + this.cpu.eax + this.getMicrocode();
            }
            case 831: {
                return (this.cpu.eax << 2) + this.cpu.ecx + this.getMicrocode();
            }
            case 832: {
                return (this.cpu.eax << 2) + this.cpu.edx + this.getMicrocode();
            }
            case 833: {
                return (this.cpu.eax << 2) + this.cpu.ebx + this.getMicrocode();
            }
            case 834: {
                return (this.cpu.eax << 2) + this.cpu.esp + this.getMicrocode();
            }
            case 835: 
            case 2647: {
                return (this.cpu.eax << 2) + this.cpu.ebp + this.getMicrocode();
            }
            case 836: {
                return (this.cpu.eax << 2) + this.cpu.esi + this.getMicrocode();
            }
            case 837: {
                return (this.cpu.eax << 2) + this.cpu.edi + this.getMicrocode();
            }
            case 838: {
                return (this.cpu.ecx << 2) + this.cpu.eax + this.getMicrocode();
            }
            case 839: {
                return (this.cpu.ecx << 2) + this.cpu.ecx + this.getMicrocode();
            }
            case 840: {
                return (this.cpu.ecx << 2) + this.cpu.edx + this.getMicrocode();
            }
            case 841: {
                return (this.cpu.ecx << 2) + this.cpu.ebx + this.getMicrocode();
            }
            case 842: 
            case 2654: {
                return (this.cpu.ecx << 2) + this.cpu.esp + this.getMicrocode();
            }
            case 843: 
            case 2655: {
                return (this.cpu.ecx << 2) + this.cpu.ebp + this.getMicrocode();
            }
            case 844: {
                return (this.cpu.ecx << 2) + this.cpu.esi + this.getMicrocode();
            }
            case 845: {
                return (this.cpu.ecx << 2) + this.cpu.edi + this.getMicrocode();
            }
            case 846: {
                return (this.cpu.edx << 2) + this.cpu.eax + this.getMicrocode();
            }
            case 847: {
                return (this.cpu.edx << 2) + this.cpu.ecx + this.getMicrocode();
            }
            case 848: {
                return (this.cpu.edx << 2) + this.cpu.edx + this.getMicrocode();
            }
            case 849: {
                return (this.cpu.edx << 2) + this.cpu.ebx + this.getMicrocode();
            }
            case 850: 
            case 2662: {
                return (this.cpu.edx << 2) + this.cpu.esp + this.getMicrocode();
            }
            case 851: 
            case 2663: {
                return (this.cpu.edx << 2) + this.cpu.ebp + this.getMicrocode();
            }
            case 852: {
                return (this.cpu.edx << 2) + this.cpu.esi + this.getMicrocode();
            }
            case 853: {
                return (this.cpu.edx << 2) + this.cpu.edi + this.getMicrocode();
            }
            case 854: {
                return (this.cpu.ebx << 2) + this.cpu.eax + this.getMicrocode();
            }
            case 855: {
                return (this.cpu.ebx << 2) + this.cpu.ecx + this.getMicrocode();
            }
            case 856: {
                return (this.cpu.ebx << 2) + this.cpu.edx + this.getMicrocode();
            }
            case 857: {
                return (this.cpu.ebx << 2) + this.cpu.ebx + this.getMicrocode();
            }
            case 858: 
            case 2670: {
                return (this.cpu.ebx << 2) + this.cpu.esp + this.getMicrocode();
            }
            case 859: 
            case 2671: {
                return (this.cpu.ebx << 2) + this.cpu.ebp + this.getMicrocode();
            }
            case 860: {
                return (this.cpu.ebx << 2) + this.cpu.esi + this.getMicrocode();
            }
            case 861: {
                return (this.cpu.ebx << 2) + this.cpu.edi + this.getMicrocode();
            }
            case 862: {
                return (this.cpu.ebp << 2) + this.cpu.eax + this.getMicrocode();
            }
            case 863: {
                return (this.cpu.ebp << 2) + this.cpu.ecx + this.getMicrocode();
            }
            case 864: {
                return (this.cpu.ebp << 2) + this.cpu.edx + this.getMicrocode();
            }
            case 865: {
                return (this.cpu.ebp << 2) + this.cpu.ebx + this.getMicrocode();
            }
            case 866: 
            case 2678: {
                return (this.cpu.ebp << 2) + this.cpu.esp + this.getMicrocode();
            }
            case 867: 
            case 2679: {
                return (this.cpu.ebp << 2) + this.cpu.ebp + this.getMicrocode();
            }
            case 868: {
                return (this.cpu.ebp << 2) + this.cpu.esi + this.getMicrocode();
            }
            case 869: {
                return (this.cpu.ebp << 2) + this.cpu.edi + this.getMicrocode();
            }
            case 870: {
                return (this.cpu.esi << 2) + this.cpu.eax + this.getMicrocode();
            }
            case 871: {
                return (this.cpu.esi << 2) + this.cpu.ecx + this.getMicrocode();
            }
            case 872: {
                return (this.cpu.esi << 2) + this.cpu.edx + this.getMicrocode();
            }
            case 873: {
                return (this.cpu.esi << 2) + this.cpu.ebx + this.getMicrocode();
            }
            case 874: 
            case 2686: {
                return (this.cpu.esi << 2) + this.cpu.esp + this.getMicrocode();
            }
            case 875: 
            case 2687: {
                return (this.cpu.esi << 2) + this.cpu.ebp + this.getMicrocode();
            }
            case 876: {
                return (this.cpu.esi << 2) + this.cpu.esi + this.getMicrocode();
            }
            case 877: {
                return (this.cpu.esi << 2) + this.cpu.edi + this.getMicrocode();
            }
            case 878: {
                return (this.cpu.edi << 2) + this.cpu.eax + this.getMicrocode();
            }
            case 879: {
                return (this.cpu.edi << 2) + this.cpu.ecx + this.getMicrocode();
            }
            case 880: {
                return (this.cpu.edi << 2) + this.cpu.edx + this.getMicrocode();
            }
            case 881: {
                return (this.cpu.edi << 2) + this.cpu.ebx + this.getMicrocode();
            }
            case 882: 
            case 2694: {
                return (this.cpu.edi << 2) + this.cpu.esp + this.getMicrocode();
            }
            case 883: 
            case 2695: {
                return (this.cpu.edi << 2) + this.cpu.ebp + this.getMicrocode();
            }
            case 884: {
                return (this.cpu.edi << 2) + this.cpu.esi + this.getMicrocode();
            }
            case 885: {
                return (this.cpu.edi << 2) + this.cpu.edi + this.getMicrocode();
            }
            case 886: {
                return (this.cpu.eax << 3) + this.cpu.eax + this.getMicrocode();
            }
            case 887: {
                return (this.cpu.eax << 3) + this.cpu.ecx + this.getMicrocode();
            }
            case 888: {
                return (this.cpu.eax << 3) + this.cpu.edx + this.getMicrocode();
            }
            case 889: {
                return (this.cpu.eax << 3) + this.cpu.ebx + this.getMicrocode();
            }
            case 890: {
                return (this.cpu.eax << 3) + this.cpu.esp + this.getMicrocode();
            }
            case 891: {
                return (this.cpu.eax << 3) + this.cpu.ebp + this.getMicrocode();
            }
            case 892: {
                return (this.cpu.eax << 3) + this.cpu.esi + this.getMicrocode();
            }
            case 893: {
                return (this.cpu.eax << 3) + this.cpu.edi + this.getMicrocode();
            }
            case 894: {
                return (this.cpu.ecx << 3) + this.cpu.eax + this.getMicrocode();
            }
            case 895: {
                return (this.cpu.ecx << 3) + this.cpu.ecx + this.getMicrocode();
            }
            case 896: {
                return (this.cpu.ecx << 3) + this.cpu.edx + this.getMicrocode();
            }
            case 897: {
                return (this.cpu.ecx << 3) + this.cpu.ebx + this.getMicrocode();
            }
            case 898: {
                return (this.cpu.ecx << 3) + this.cpu.esp + this.getMicrocode();
            }
            case 899: {
                return (this.cpu.ecx << 3) + this.cpu.ebp + this.getMicrocode();
            }
            case 900: {
                return (this.cpu.ecx << 3) + this.cpu.esi + this.getMicrocode();
            }
            case 901: {
                return (this.cpu.ecx << 3) + this.cpu.edi + this.getMicrocode();
            }
            case 902: {
                return (this.cpu.edx << 3) + this.cpu.eax + this.getMicrocode();
            }
            case 903: {
                return (this.cpu.edx << 3) + this.cpu.ecx + this.getMicrocode();
            }
            case 904: {
                return (this.cpu.edx << 3) + this.cpu.edx + this.getMicrocode();
            }
            case 905: {
                return (this.cpu.edx << 3) + this.cpu.ebx + this.getMicrocode();
            }
            case 906: {
                return (this.cpu.edx << 3) + this.cpu.esp + this.getMicrocode();
            }
            case 907: {
                return (this.cpu.edx << 3) + this.cpu.ebp + this.getMicrocode();
            }
            case 908: {
                return (this.cpu.edx << 3) + this.cpu.esi + this.getMicrocode();
            }
            case 909: {
                return (this.cpu.edx << 3) + this.cpu.edi + this.getMicrocode();
            }
            case 910: {
                return (this.cpu.ebx << 3) + this.cpu.eax + this.getMicrocode();
            }
            case 911: {
                return (this.cpu.ebx << 3) + this.cpu.ecx + this.getMicrocode();
            }
            case 912: {
                return (this.cpu.ebx << 3) + this.cpu.edx + this.getMicrocode();
            }
            case 913: {
                return (this.cpu.ebx << 3) + this.cpu.ebx + this.getMicrocode();
            }
            case 914: {
                return (this.cpu.ebx << 3) + this.cpu.esp + this.getMicrocode();
            }
            case 915: {
                return (this.cpu.ebx << 3) + this.cpu.ebp + this.getMicrocode();
            }
            case 916: {
                return (this.cpu.ebx << 3) + this.cpu.esi + this.getMicrocode();
            }
            case 917: {
                return (this.cpu.ebx << 3) + this.cpu.edi + this.getMicrocode();
            }
            case 918: {
                return (this.cpu.ebp << 3) + this.cpu.eax + this.getMicrocode();
            }
            case 919: {
                return (this.cpu.ebp << 3) + this.cpu.ecx + this.getMicrocode();
            }
            case 920: {
                return (this.cpu.ebp << 3) + this.cpu.edx + this.getMicrocode();
            }
            case 921: {
                return (this.cpu.ebp << 3) + this.cpu.ebx + this.getMicrocode();
            }
            case 922: {
                return (this.cpu.ebp << 3) + this.cpu.esp + this.getMicrocode();
            }
            case 923: {
                return (this.cpu.ebp << 3) + this.cpu.ebp + this.getMicrocode();
            }
            case 924: {
                return (this.cpu.ebp << 3) + this.cpu.esi + this.getMicrocode();
            }
            case 925: {
                return (this.cpu.ebp << 3) + this.cpu.edi + this.getMicrocode();
            }
            case 926: {
                return (this.cpu.esi << 3) + this.cpu.eax + this.getMicrocode();
            }
            case 927: {
                return (this.cpu.esi << 3) + this.cpu.ecx + this.getMicrocode();
            }
            case 928: {
                return (this.cpu.esi << 3) + this.cpu.edx + this.getMicrocode();
            }
            case 929: {
                return (this.cpu.esi << 3) + this.cpu.ebx + this.getMicrocode();
            }
            case 930: {
                return (this.cpu.esi << 3) + this.cpu.esp + this.getMicrocode();
            }
            case 931: {
                return (this.cpu.esi << 3) + this.cpu.ebp + this.getMicrocode();
            }
            case 932: {
                return (this.cpu.esi << 3) + this.cpu.esi + this.getMicrocode();
            }
            case 933: {
                return (this.cpu.esi << 3) + this.cpu.edi + this.getMicrocode();
            }
            case 934: {
                return (this.cpu.edi << 3) + this.cpu.eax + this.getMicrocode();
            }
            case 935: {
                return (this.cpu.edi << 3) + this.cpu.ecx + this.getMicrocode();
            }
            case 936: {
                return (this.cpu.edi << 3) + this.cpu.edx + this.getMicrocode();
            }
            case 937: {
                return (this.cpu.edi << 3) + this.cpu.ebx + this.getMicrocode();
            }
            case 938: {
                return (this.cpu.edi << 3) + this.cpu.esp + this.getMicrocode();
            }
            case 939: {
                return (this.cpu.edi << 3) + this.cpu.ebp + this.getMicrocode();
            }
            case 940: {
                return (this.cpu.edi << 3) + this.cpu.esi + this.getMicrocode();
            }
            case 941: {
                return (this.cpu.edi << 3) + this.cpu.edi + this.getMicrocode();
            }
        }
        System.err.println("Unimplemented GetAddress Operand: " + n);
        throw unimplemented;
    }

    protected byte getByteOperand() {
        int n = this.getMicrocode();
        switch (n) {
            case 47: {
                return 1;
            }
            case 0: {
                return (byte)this.cpu.eax;
            }
            case 4: {
                return (byte)(this.cpu.eax >> 8);
            }
            case 1: {
                return (byte)this.cpu.ecx;
            }
            case 5: {
                return (byte)(this.cpu.ecx >> 8);
            }
            case 2: {
                return (byte)this.cpu.edx;
            }
            case 6: {
                return (byte)(this.cpu.edx >> 8);
            }
            case 3: {
                return (byte)this.cpu.ebx;
            }
            case 7: {
                return (byte)(this.cpu.ebx >> 8);
            }
            case 41: {
                return (byte)this.getMicrocode();
            }
        }
        return this.getByteMemoryOperand(n);
    }

    /*
     * Opcode count of 21791 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    private final byte getByteMemoryOperand(int n) {
        switch (n) {
            case 326: {
                return this.cpu.es.getByte(this.cpu.ebx + (0xFF & this.cpu.eax) & 0xFFFF);
            }
            case 327: {
                return this.cpu.cs.getByte(this.cpu.ebx + (0xFF & this.cpu.eax) & 0xFFFF);
            }
            case 328: {
                return this.cpu.ss.getByte(this.cpu.ebx + (0xFF & this.cpu.eax) & 0xFFFF);
            }
            case 329: {
                return this.cpu.ds.getByte(this.cpu.ebx + (0xFF & this.cpu.eax) & 0xFFFF);
            }
            case 330: {
                return this.cpu.fs.getByte(this.cpu.ebx + (0xFF & this.cpu.eax) & 0xFFFF);
            }
            case 331: {
                return this.cpu.gs.getByte(this.cpu.ebx + (0xFF & this.cpu.eax) & 0xFFFF);
            }
            case 182: {
                return this.cpu.es.getByte(this.cpu.ebx + this.cpu.esi & 0xFFFF);
            }
            case 183: {
                return this.cpu.es.getByte(this.cpu.ebx + this.cpu.edi & 0xFFFF);
            }
            case 184: {
                return this.cpu.es.getByte(this.cpu.ebp + this.cpu.esi & 0xFFFF);
            }
            case 185: {
                return this.cpu.es.getByte(this.cpu.ebp + this.cpu.edi & 0xFFFF);
            }
            case 186: {
                return this.cpu.es.getByte(this.cpu.esi & 0xFFFF);
            }
            case 187: {
                return this.cpu.es.getByte(this.cpu.edi & 0xFFFF);
            }
            case 188: {
                return this.cpu.es.getByte(this.getMicrocode() & 0xFFFF);
            }
            case 189: {
                return this.cpu.es.getByte(this.cpu.ebx & 0xFFFF);
            }
            case 190: {
                return this.cpu.es.getByte(this.cpu.ebx + this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 191: {
                return this.cpu.es.getByte(this.cpu.ebx + this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 192: {
                return this.cpu.es.getByte(this.cpu.ebp + this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 193: {
                return this.cpu.es.getByte(this.cpu.ebp + this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 194: {
                return this.cpu.es.getByte(this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 195: {
                return this.cpu.es.getByte(this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 196: {
                return this.cpu.es.getByte(this.cpu.ebp + this.getMicrocode() & 0xFFFF);
            }
            case 197: {
                return this.cpu.es.getByte(this.cpu.ebx + this.getMicrocode() & 0xFFFF);
            }
            case 198: {
                return this.cpu.es.getByte(this.cpu.ebx + this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 199: {
                return this.cpu.es.getByte(this.cpu.ebx + this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 200: {
                return this.cpu.es.getByte(this.cpu.ebp + this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 201: {
                return this.cpu.es.getByte(this.cpu.ebp + this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 202: {
                return this.cpu.es.getByte(this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 203: {
                return this.cpu.es.getByte(this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 204: {
                return this.cpu.es.getByte(this.cpu.ebp + this.getMicrocode() & 0xFFFF);
            }
            case 205: {
                return this.cpu.es.getByte(this.cpu.ebx + this.getMicrocode() & 0xFFFF);
            }
            case 206: {
                return this.cpu.cs.getByte(this.cpu.ebx + this.cpu.esi & 0xFFFF);
            }
            case 207: {
                return this.cpu.cs.getByte(this.cpu.ebx + this.cpu.edi & 0xFFFF);
            }
            case 208: {
                return this.cpu.cs.getByte(this.cpu.ebp + this.cpu.esi & 0xFFFF);
            }
            case 209: {
                return this.cpu.cs.getByte(this.cpu.ebp + this.cpu.edi & 0xFFFF);
            }
            case 210: {
                return this.cpu.cs.getByte(this.cpu.esi & 0xFFFF);
            }
            case 211: {
                return this.cpu.cs.getByte(this.cpu.edi & 0xFFFF);
            }
            case 212: {
                return this.cpu.cs.getByte(this.getMicrocode() & 0xFFFF);
            }
            case 213: {
                return this.cpu.cs.getByte(this.cpu.ebx & 0xFFFF);
            }
            case 214: {
                return this.cpu.cs.getByte(this.cpu.ebx + this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 215: {
                return this.cpu.cs.getByte(this.cpu.ebx + this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 216: {
                return this.cpu.cs.getByte(this.cpu.ebp + this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 217: {
                return this.cpu.cs.getByte(this.cpu.ebp + this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 218: {
                return this.cpu.cs.getByte(this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 219: {
                return this.cpu.cs.getByte(this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 220: {
                return this.cpu.cs.getByte(this.cpu.ebp + this.getMicrocode() & 0xFFFF);
            }
            case 221: {
                return this.cpu.cs.getByte(this.cpu.ebx + this.getMicrocode() & 0xFFFF);
            }
            case 222: {
                return this.cpu.cs.getByte(this.cpu.ebx + this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 223: {
                return this.cpu.cs.getByte(this.cpu.ebx + this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 224: {
                return this.cpu.cs.getByte(this.cpu.ebp + this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 225: {
                return this.cpu.cs.getByte(this.cpu.ebp + this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 226: {
                return this.cpu.cs.getByte(this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 227: {
                return this.cpu.cs.getByte(this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 228: {
                return this.cpu.cs.getByte(this.cpu.ebp + this.getMicrocode() & 0xFFFF);
            }
            case 229: {
                return this.cpu.cs.getByte(this.cpu.ebx + this.getMicrocode() & 0xFFFF);
            }
            case 230: {
                return this.cpu.ss.getByte(this.cpu.ebx + this.cpu.esi & 0xFFFF);
            }
            case 231: {
                return this.cpu.ss.getByte(this.cpu.ebx + this.cpu.edi & 0xFFFF);
            }
            case 232: {
                return this.cpu.ss.getByte(this.cpu.ebp + this.cpu.esi & 0xFFFF);
            }
            case 233: {
                return this.cpu.ss.getByte(this.cpu.ebp + this.cpu.edi & 0xFFFF);
            }
            case 234: {
                return this.cpu.ss.getByte(this.cpu.esi & 0xFFFF);
            }
            case 235: {
                return this.cpu.ss.getByte(this.cpu.edi & 0xFFFF);
            }
            case 236: {
                return this.cpu.ss.getByte(this.getMicrocode() & 0xFFFF);
            }
            case 237: {
                return this.cpu.ss.getByte(this.cpu.ebx & 0xFFFF);
            }
            case 238: {
                return this.cpu.ss.getByte(this.cpu.ebx + this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 239: {
                return this.cpu.ss.getByte(this.cpu.ebx + this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 240: {
                return this.cpu.ss.getByte(this.cpu.ebp + this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 241: {
                return this.cpu.ss.getByte(this.cpu.ebp + this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 242: {
                return this.cpu.ss.getByte(this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 243: {
                return this.cpu.ss.getByte(this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 244: {
                return this.cpu.ss.getByte(this.cpu.ebp + this.getMicrocode() & 0xFFFF);
            }
            case 245: {
                return this.cpu.ss.getByte(this.cpu.ebx + this.getMicrocode() & 0xFFFF);
            }
            case 246: {
                return this.cpu.ss.getByte(this.cpu.ebx + this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 247: {
                return this.cpu.ss.getByte(this.cpu.ebx + this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 248: {
                return this.cpu.ss.getByte(this.cpu.ebp + this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 249: {
                return this.cpu.ss.getByte(this.cpu.ebp + this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 250: {
                return this.cpu.ss.getByte(this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 251: {
                return this.cpu.ss.getByte(this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 252: {
                return this.cpu.ss.getByte(this.cpu.ebp + this.getMicrocode() & 0xFFFF);
            }
            case 253: {
                return this.cpu.ss.getByte(this.cpu.ebx + this.getMicrocode() & 0xFFFF);
            }
            case 254: {
                return this.cpu.ds.getByte(this.cpu.ebx + this.cpu.esi & 0xFFFF);
            }
            case 255: {
                return this.cpu.ds.getByte(this.cpu.ebx + this.cpu.edi & 0xFFFF);
            }
            case 256: {
                return this.cpu.ds.getByte(this.cpu.ebp + this.cpu.esi & 0xFFFF);
            }
            case 257: {
                return this.cpu.ds.getByte(this.cpu.ebp + this.cpu.edi & 0xFFFF);
            }
            case 258: {
                return this.cpu.ds.getByte(this.cpu.esi & 0xFFFF);
            }
            case 259: {
                return this.cpu.ds.getByte(this.cpu.edi & 0xFFFF);
            }
            case 260: {
                return this.cpu.ds.getByte(this.getMicrocode() & 0xFFFF);
            }
            case 261: {
                return this.cpu.ds.getByte(this.cpu.ebx & 0xFFFF);
            }
            case 262: {
                return this.cpu.ds.getByte(this.cpu.ebx + this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 263: {
                return this.cpu.ds.getByte(this.cpu.ebx + this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 264: {
                return this.cpu.ds.getByte(this.cpu.ebp + this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 265: {
                return this.cpu.ds.getByte(this.cpu.ebp + this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 266: {
                return this.cpu.ds.getByte(this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 267: {
                return this.cpu.ds.getByte(this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 268: {
                return this.cpu.ds.getByte(this.cpu.ebp + this.getMicrocode() & 0xFFFF);
            }
            case 269: {
                return this.cpu.ds.getByte(this.cpu.ebx + this.getMicrocode() & 0xFFFF);
            }
            case 270: {
                return this.cpu.ds.getByte(this.cpu.ebx + this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 271: {
                return this.cpu.ds.getByte(this.cpu.ebx + this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 272: {
                return this.cpu.ds.getByte(this.cpu.ebp + this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 273: {
                return this.cpu.ds.getByte(this.cpu.ebp + this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 274: {
                return this.cpu.ds.getByte(this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 275: {
                return this.cpu.ds.getByte(this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 276: {
                return this.cpu.ds.getByte(this.cpu.ebp + this.getMicrocode() & 0xFFFF);
            }
            case 277: {
                return this.cpu.ds.getByte(this.cpu.ebx + this.getMicrocode() & 0xFFFF);
            }
            case 278: {
                return this.cpu.fs.getByte(this.cpu.ebx + this.cpu.esi & 0xFFFF);
            }
            case 279: {
                return this.cpu.fs.getByte(this.cpu.ebx + this.cpu.edi & 0xFFFF);
            }
            case 280: {
                return this.cpu.fs.getByte(this.cpu.ebp + this.cpu.esi & 0xFFFF);
            }
            case 281: {
                return this.cpu.fs.getByte(this.cpu.ebp + this.cpu.edi & 0xFFFF);
            }
            case 282: {
                return this.cpu.fs.getByte(this.cpu.esi & 0xFFFF);
            }
            case 283: {
                return this.cpu.fs.getByte(this.cpu.edi & 0xFFFF);
            }
            case 284: {
                return this.cpu.fs.getByte(this.getMicrocode() & 0xFFFF);
            }
            case 285: {
                return this.cpu.fs.getByte(this.cpu.ebx & 0xFFFF);
            }
            case 286: {
                return this.cpu.fs.getByte(this.cpu.ebx + this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 287: {
                return this.cpu.fs.getByte(this.cpu.ebx + this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 288: {
                return this.cpu.fs.getByte(this.cpu.ebp + this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 289: {
                return this.cpu.fs.getByte(this.cpu.ebp + this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 290: {
                return this.cpu.fs.getByte(this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 291: {
                return this.cpu.fs.getByte(this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 292: {
                return this.cpu.fs.getByte(this.cpu.ebp + this.getMicrocode() & 0xFFFF);
            }
            case 293: {
                return this.cpu.fs.getByte(this.cpu.ebx + this.getMicrocode() & 0xFFFF);
            }
            case 294: {
                return this.cpu.fs.getByte(this.cpu.ebx + this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 295: {
                return this.cpu.fs.getByte(this.cpu.ebx + this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 296: {
                return this.cpu.fs.getByte(this.cpu.ebp + this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 297: {
                return this.cpu.fs.getByte(this.cpu.ebp + this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 298: {
                return this.cpu.fs.getByte(this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 299: {
                return this.cpu.fs.getByte(this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 300: {
                return this.cpu.fs.getByte(this.cpu.ebp + this.getMicrocode() & 0xFFFF);
            }
            case 301: {
                return this.cpu.fs.getByte(this.cpu.ebx + this.getMicrocode() & 0xFFFF);
            }
            case 302: {
                return this.cpu.gs.getByte(this.cpu.ebx + this.cpu.esi & 0xFFFF);
            }
            case 303: {
                return this.cpu.gs.getByte(this.cpu.ebx + this.cpu.edi & 0xFFFF);
            }
            case 304: {
                return this.cpu.gs.getByte(this.cpu.ebp + this.cpu.esi & 0xFFFF);
            }
            case 305: {
                return this.cpu.gs.getByte(this.cpu.ebp + this.cpu.edi & 0xFFFF);
            }
            case 306: {
                return this.cpu.gs.getByte(this.cpu.esi & 0xFFFF);
            }
            case 307: {
                return this.cpu.gs.getByte(this.cpu.edi & 0xFFFF);
            }
            case 308: {
                return this.cpu.gs.getByte(this.getMicrocode() & 0xFFFF);
            }
            case 309: {
                return this.cpu.gs.getByte(this.cpu.ebx & 0xFFFF);
            }
            case 310: {
                return this.cpu.gs.getByte(this.cpu.ebx + this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 311: {
                return this.cpu.gs.getByte(this.cpu.ebx + this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 312: {
                return this.cpu.gs.getByte(this.cpu.ebp + this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 313: {
                return this.cpu.gs.getByte(this.cpu.ebp + this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 314: {
                return this.cpu.gs.getByte(this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 315: {
                return this.cpu.gs.getByte(this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 316: {
                return this.cpu.gs.getByte(this.cpu.ebp + this.getMicrocode() & 0xFFFF);
            }
            case 317: {
                return this.cpu.gs.getByte(this.cpu.ebx + this.getMicrocode() & 0xFFFF);
            }
            case 318: {
                return this.cpu.gs.getByte(this.cpu.ebx + this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 319: {
                return this.cpu.gs.getByte(this.cpu.ebx + this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 320: {
                return this.cpu.gs.getByte(this.cpu.ebp + this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 321: {
                return this.cpu.gs.getByte(this.cpu.ebp + this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 322: {
                return this.cpu.gs.getByte(this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 323: {
                return this.cpu.gs.getByte(this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 324: {
                return this.cpu.gs.getByte(this.cpu.ebp + this.getMicrocode() & 0xFFFF);
            }
            case 325: {
                return this.cpu.gs.getByte(this.cpu.ebx + this.getMicrocode() & 0xFFFF);
            }
            case 332: {
                return this.cpu.es.getByte(this.cpu.ebx + (0xFF & this.cpu.eax));
            }
            case 333: {
                return this.cpu.cs.getByte(this.cpu.ebx + (0xFF & this.cpu.eax));
            }
            case 334: {
                return this.cpu.ss.getByte(this.cpu.ebx + (0xFF & this.cpu.eax));
            }
            case 335: {
                return this.cpu.ds.getByte(this.cpu.ebx + (0xFF & this.cpu.eax));
            }
            case 336: {
                return this.cpu.fs.getByte(this.cpu.ebx + (0xFF & this.cpu.eax));
            }
            case 337: {
                return this.cpu.gs.getByte(this.cpu.ebx + (0xFF & this.cpu.eax));
            }
            case 56: {
                return this.cpu.es.getByte(this.cpu.eax);
            }
            case 57: {
                return this.cpu.es.getByte(this.cpu.ecx);
            }
            case 58: {
                return this.cpu.es.getByte(this.cpu.edx);
            }
            case 59: {
                return this.cpu.es.getByte(this.cpu.ebx);
            }
            case 60: {
                return this.cpu.es.getByte(this.getMicrocode());
            }
            case 61: {
                return this.cpu.es.getByte(this.cpu.esi);
            }
            case 62: {
                return this.cpu.es.getByte(this.cpu.edi);
            }
            case 63: {
                return this.cpu.es.getByte(this.cpu.eax + this.getMicrocode());
            }
            case 64: {
                return this.cpu.es.getByte(this.cpu.ecx + this.getMicrocode());
            }
            case 65: {
                return this.cpu.es.getByte(this.cpu.edx + this.getMicrocode());
            }
            case 66: {
                return this.cpu.es.getByte(this.cpu.ebx + this.getMicrocode());
            }
            case 67: {
                return this.cpu.es.getByte(this.cpu.ebp + this.getMicrocode());
            }
            case 68: {
                return this.cpu.es.getByte(this.cpu.esi + this.getMicrocode());
            }
            case 69: {
                return this.cpu.es.getByte(this.cpu.edi + this.getMicrocode());
            }
            case 70: {
                return this.cpu.es.getByte(this.cpu.eax + this.getMicrocode());
            }
            case 71: {
                return this.cpu.es.getByte(this.cpu.ecx + this.getMicrocode());
            }
            case 72: {
                return this.cpu.es.getByte(this.cpu.edx + this.getMicrocode());
            }
            case 73: {
                return this.cpu.es.getByte(this.cpu.ebx + this.getMicrocode());
            }
            case 74: {
                return this.cpu.es.getByte(this.cpu.ebp + this.getMicrocode());
            }
            case 75: {
                return this.cpu.es.getByte(this.cpu.esi + this.getMicrocode());
            }
            case 76: {
                return this.cpu.es.getByte(this.cpu.edi + this.getMicrocode());
            }
            case 84: {
                return this.cpu.cs.getByte(this.cpu.eax + this.getMicrocode());
            }
            case 85: {
                return this.cpu.cs.getByte(this.cpu.ecx + this.getMicrocode());
            }
            case 86: {
                return this.cpu.cs.getByte(this.cpu.edx + this.getMicrocode());
            }
            case 87: {
                return this.cpu.cs.getByte(this.cpu.ebx + this.getMicrocode());
            }
            case 88: {
                return this.cpu.cs.getByte(this.cpu.ebp + this.getMicrocode());
            }
            case 89: {
                return this.cpu.cs.getByte(this.cpu.esi + this.getMicrocode());
            }
            case 90: {
                return this.cpu.cs.getByte(this.cpu.edi + this.getMicrocode());
            }
            case 82: {
                return this.cpu.cs.getByte(this.cpu.esi);
            }
            case 105: {
                return this.cpu.ss.getByte(this.cpu.eax + this.getMicrocode());
            }
            case 106: {
                return this.cpu.ss.getByte(this.cpu.ecx + this.getMicrocode());
            }
            case 107: {
                return this.cpu.ss.getByte(this.cpu.edx + this.getMicrocode());
            }
            case 108: {
                return this.cpu.ss.getByte(this.cpu.ebx + this.getMicrocode());
            }
            case 109: {
                return this.cpu.ss.getByte(this.cpu.ebp + this.getMicrocode());
            }
            case 110: {
                return this.cpu.ss.getByte(this.cpu.esi + this.getMicrocode());
            }
            case 111: {
                return this.cpu.ss.getByte(this.cpu.edi + this.getMicrocode());
            }
            case 112: {
                return this.cpu.ss.getByte(this.cpu.eax + this.getMicrocode());
            }
            case 113: {
                return this.cpu.ss.getByte(this.cpu.ecx + this.getMicrocode());
            }
            case 114: {
                return this.cpu.ss.getByte(this.cpu.edx + this.getMicrocode());
            }
            case 115: {
                return this.cpu.ss.getByte(this.cpu.ebx + this.getMicrocode());
            }
            case 116: {
                return this.cpu.ss.getByte(this.cpu.ebp + this.getMicrocode());
            }
            case 117: {
                return this.cpu.ss.getByte(this.cpu.esi + this.getMicrocode());
            }
            case 118: {
                return this.cpu.ss.getByte(this.cpu.edi + this.getMicrocode());
            }
            case 91: {
                return this.cpu.cs.getByte(this.cpu.eax + this.getMicrocode());
            }
            case 92: {
                return this.cpu.cs.getByte(this.cpu.ecx + this.getMicrocode());
            }
            case 93: {
                return this.cpu.cs.getByte(this.cpu.edx + this.getMicrocode());
            }
            case 94: {
                return this.cpu.cs.getByte(this.cpu.ebx + this.getMicrocode());
            }
            case 95: {
                return this.cpu.cs.getByte(this.cpu.ebp + this.getMicrocode());
            }
            case 96: {
                return this.cpu.cs.getByte(this.cpu.esi + this.getMicrocode());
            }
            case 97: {
                return this.cpu.cs.getByte(this.cpu.edi + this.getMicrocode());
            }
            case 119: {
                return this.cpu.ds.getByte(this.cpu.eax);
            }
            case 120: {
                return this.cpu.ds.getByte(this.cpu.ecx);
            }
            case 121: {
                return this.cpu.ds.getByte(this.cpu.edx);
            }
            case 122: {
                return this.cpu.ds.getByte(this.cpu.ebx);
            }
            case 123: {
                return this.cpu.ds.getByte(this.getMicrocode());
            }
            case 124: {
                return this.cpu.ds.getByte(this.cpu.esi);
            }
            case 125: {
                return this.cpu.ds.getByte(this.cpu.edi);
            }
            case 126: {
                return this.cpu.ds.getByte(this.cpu.eax + this.getMicrocode());
            }
            case 127: {
                return this.cpu.ds.getByte(this.cpu.ecx + this.getMicrocode());
            }
            case 128: {
                return this.cpu.ds.getByte(this.cpu.edx + this.getMicrocode());
            }
            case 129: {
                return this.cpu.ds.getByte(this.cpu.ebx + this.getMicrocode());
            }
            case 130: {
                return this.cpu.ds.getByte(this.cpu.ebp + this.getMicrocode());
            }
            case 131: {
                return this.cpu.ds.getByte(this.cpu.esi + this.getMicrocode());
            }
            case 132: {
                return this.cpu.ds.getByte(this.cpu.edi + this.getMicrocode());
            }
            case 133: {
                return this.cpu.ds.getByte(this.cpu.eax + this.getMicrocode());
            }
            case 134: {
                return this.cpu.ds.getByte(this.cpu.ecx + this.getMicrocode());
            }
            case 135: {
                return this.cpu.ds.getByte(this.cpu.edx + this.getMicrocode());
            }
            case 136: {
                return this.cpu.ds.getByte(this.cpu.ebx + this.getMicrocode());
            }
            case 137: {
                return this.cpu.ds.getByte(this.cpu.ebp + this.getMicrocode());
            }
            case 138: {
                return this.cpu.ds.getByte(this.cpu.esi + this.getMicrocode());
            }
            case 139: {
                return this.cpu.ds.getByte(this.cpu.edi + this.getMicrocode());
            }
            case 338: {
                return this.cpu.ds.getByte(this.cpu.eax + this.cpu.eax);
            }
            case 339: {
                return this.cpu.ds.getByte(this.cpu.eax + this.cpu.ecx);
            }
            case 340: {
                return this.cpu.ds.getByte(this.cpu.eax + this.cpu.edx);
            }
            case 341: {
                return this.cpu.ds.getByte(this.cpu.eax + this.cpu.ebx);
            }
            case 342: {
                return this.cpu.ds.getByte(this.cpu.eax + this.cpu.esp);
            }
            case 343: {
                return this.cpu.ds.getByte(this.cpu.eax + this.cpu.ebp);
            }
            case 344: {
                return this.cpu.ds.getByte(this.cpu.eax + this.cpu.esi);
            }
            case 345: {
                return this.cpu.ds.getByte(this.cpu.eax + this.cpu.edi);
            }
            case 346: {
                return this.cpu.ds.getByte(this.cpu.ecx + this.cpu.ecx);
            }
            case 347: {
                return this.cpu.ds.getByte(this.cpu.ecx + this.cpu.edx);
            }
            case 348: {
                return this.cpu.ds.getByte(this.cpu.ecx + this.cpu.ebx);
            }
            case 349: {
                return this.cpu.ds.getByte(this.cpu.ecx + this.cpu.esp);
            }
            case 350: {
                return this.cpu.ds.getByte(this.cpu.ecx + this.cpu.ebp);
            }
            case 351: {
                return this.cpu.ds.getByte(this.cpu.ecx + this.cpu.esi);
            }
            case 352: {
                return this.cpu.ds.getByte(this.cpu.ecx + this.cpu.edi);
            }
            case 353: {
                return this.cpu.ds.getByte(this.cpu.edx + this.cpu.edx);
            }
            case 354: {
                return this.cpu.ds.getByte(this.cpu.edx + this.cpu.ebx);
            }
            case 355: {
                return this.cpu.ds.getByte(this.cpu.edx + this.cpu.esp);
            }
            case 356: {
                return this.cpu.ds.getByte(this.cpu.edx + this.cpu.ebp);
            }
            case 357: {
                return this.cpu.ds.getByte(this.cpu.edx + this.cpu.esi);
            }
            case 358: {
                return this.cpu.ds.getByte(this.cpu.edx + this.cpu.edi);
            }
            case 359: {
                return this.cpu.ds.getByte(this.cpu.ebx + this.cpu.ebx);
            }
            case 360: {
                return this.cpu.ds.getByte(this.cpu.ebx + this.cpu.esp);
            }
            case 361: {
                return this.cpu.ds.getByte(this.cpu.ebx + this.cpu.ebp);
            }
            case 362: {
                return this.cpu.ds.getByte(this.cpu.ebx + this.cpu.esi);
            }
            case 363: {
                return this.cpu.ds.getByte(this.cpu.ebx + this.cpu.edi);
            }
            case 364: {
                return this.cpu.ds.getByte(this.cpu.esp);
            }
            case 365: {
                return this.cpu.ds.getByte(this.cpu.ebp + this.cpu.esp);
            }
            case 366: {
                return this.cpu.ds.getByte(this.cpu.ebp + this.cpu.esi);
            }
            case 367: {
                return this.cpu.ds.getByte(this.cpu.ebp + this.cpu.edi);
            }
            case 368: {
                return this.cpu.ds.getByte(this.cpu.esi + this.cpu.esp);
            }
            case 369: {
                return this.cpu.ds.getByte(this.cpu.esi + this.cpu.esi);
            }
            case 370: {
                return this.cpu.ds.getByte(this.cpu.esi + this.cpu.edi);
            }
            case 371: {
                return this.cpu.ds.getByte(this.cpu.edi + this.cpu.esp);
            }
            case 372: {
                return this.cpu.ds.getByte(this.cpu.edi + this.cpu.edi);
            }
            case 373: {
                return this.cpu.ds.getByte((this.cpu.eax << 1) + this.cpu.eax);
            }
            case 374: {
                return this.cpu.ds.getByte((this.cpu.eax << 1) + this.cpu.ecx);
            }
            case 375: {
                return this.cpu.ds.getByte((this.cpu.eax << 1) + this.cpu.edx);
            }
            case 376: {
                return this.cpu.ds.getByte((this.cpu.eax << 1) + this.cpu.ebx);
            }
            case 377: {
                return this.cpu.ds.getByte((this.cpu.eax << 1) + this.cpu.esp);
            }
            case 378: {
                return this.cpu.ds.getByte((this.cpu.eax << 1) + this.getMicrocode());
            }
            case 379: {
                return this.cpu.ds.getByte((this.cpu.eax << 1) + this.cpu.esi);
            }
            case 380: {
                return this.cpu.ds.getByte((this.cpu.eax << 1) + this.cpu.edi);
            }
            case 381: {
                return this.cpu.ds.getByte((this.cpu.ecx << 1) + this.cpu.eax);
            }
            case 382: {
                return this.cpu.ds.getByte((this.cpu.ecx << 1) + this.cpu.ecx);
            }
            case 383: {
                return this.cpu.ds.getByte((this.cpu.ecx << 1) + this.cpu.edx);
            }
            case 384: {
                return this.cpu.ds.getByte((this.cpu.ecx << 1) + this.cpu.ebx);
            }
            case 385: {
                return this.cpu.ds.getByte((this.cpu.ecx << 1) + this.cpu.esp);
            }
            case 386: {
                return this.cpu.ds.getByte((this.cpu.ecx << 1) + this.getMicrocode());
            }
            case 387: {
                return this.cpu.ds.getByte((this.cpu.ecx << 1) + this.cpu.esi);
            }
            case 388: {
                return this.cpu.ds.getByte((this.cpu.ecx << 1) + this.cpu.edi);
            }
            case 389: {
                return this.cpu.ds.getByte((this.cpu.edx << 1) + this.cpu.eax);
            }
            case 390: {
                return this.cpu.ds.getByte((this.cpu.edx << 1) + this.cpu.ecx);
            }
            case 391: {
                return this.cpu.ds.getByte((this.cpu.edx << 1) + this.cpu.edx);
            }
            case 392: {
                return this.cpu.ds.getByte((this.cpu.edx << 1) + this.cpu.ebx);
            }
            case 393: {
                return this.cpu.ds.getByte((this.cpu.edx << 1) + this.cpu.esp);
            }
            case 394: {
                return this.cpu.ds.getByte((this.cpu.edx << 1) + this.getMicrocode());
            }
            case 395: {
                return this.cpu.ds.getByte((this.cpu.edx << 1) + this.cpu.esi);
            }
            case 396: {
                return this.cpu.ds.getByte((this.cpu.edx << 1) + this.cpu.edi);
            }
            case 397: {
                return this.cpu.ds.getByte((this.cpu.ebx << 1) + this.cpu.eax);
            }
            case 398: {
                return this.cpu.ds.getByte((this.cpu.ebx << 1) + this.cpu.ecx);
            }
            case 399: {
                return this.cpu.ds.getByte((this.cpu.ebx << 1) + this.cpu.edx);
            }
            case 400: {
                return this.cpu.ds.getByte((this.cpu.ebx << 1) + this.cpu.ebx);
            }
            case 401: {
                return this.cpu.ds.getByte((this.cpu.ebx << 1) + this.cpu.esp);
            }
            case 402: {
                return this.cpu.ds.getByte((this.cpu.ebx << 1) + this.getMicrocode());
            }
            case 403: {
                return this.cpu.ds.getByte((this.cpu.ebx << 1) + this.cpu.esi);
            }
            case 404: {
                return this.cpu.ds.getByte((this.cpu.ebx << 1) + this.cpu.edi);
            }
            case 405: {
                return this.cpu.ds.getByte((this.cpu.ebp << 1) + this.cpu.eax);
            }
            case 406: {
                return this.cpu.ds.getByte((this.cpu.ebp << 1) + this.cpu.ecx);
            }
            case 407: {
                return this.cpu.ds.getByte((this.cpu.ebp << 1) + this.cpu.edx);
            }
            case 408: {
                return this.cpu.ds.getByte((this.cpu.ebp << 1) + this.cpu.ebx);
            }
            case 409: {
                return this.cpu.ds.getByte((this.cpu.ebp << 1) + this.cpu.esp);
            }
            case 410: {
                return this.cpu.ds.getByte((this.cpu.ebp << 1) + this.getMicrocode());
            }
            case 411: {
                return this.cpu.ds.getByte((this.cpu.ebp << 1) + this.cpu.esi);
            }
            case 412: {
                return this.cpu.ds.getByte((this.cpu.ebp << 1) + this.cpu.edi);
            }
            case 413: {
                return this.cpu.ds.getByte((this.cpu.esi << 1) + this.cpu.eax);
            }
            case 414: {
                return this.cpu.ds.getByte((this.cpu.esi << 1) + this.cpu.ecx);
            }
            case 415: {
                return this.cpu.ds.getByte((this.cpu.esi << 1) + this.cpu.edx);
            }
            case 416: {
                return this.cpu.ds.getByte((this.cpu.esi << 1) + this.cpu.ebx);
            }
            case 417: {
                return this.cpu.ds.getByte((this.cpu.esi << 1) + this.cpu.esp);
            }
            case 418: {
                return this.cpu.ds.getByte((this.cpu.esi << 1) + this.getMicrocode());
            }
            case 419: {
                return this.cpu.ds.getByte((this.cpu.esi << 1) + this.cpu.esi);
            }
            case 420: {
                return this.cpu.ds.getByte((this.cpu.esi << 1) + this.cpu.edi);
            }
            case 421: {
                return this.cpu.ds.getByte((this.cpu.edi << 1) + this.cpu.eax);
            }
            case 422: {
                return this.cpu.ds.getByte((this.cpu.edi << 1) + this.cpu.ecx);
            }
            case 423: {
                return this.cpu.ds.getByte((this.cpu.edi << 1) + this.cpu.edx);
            }
            case 424: {
                return this.cpu.ds.getByte((this.cpu.edi << 1) + this.cpu.ebx);
            }
            case 425: {
                return this.cpu.ds.getByte((this.cpu.edi << 1) + this.cpu.esp);
            }
            case 426: {
                return this.cpu.ds.getByte((this.cpu.edi << 1) + this.getMicrocode());
            }
            case 427: {
                return this.cpu.ds.getByte((this.cpu.edi << 1) + this.cpu.esi);
            }
            case 428: {
                return this.cpu.ds.getByte((this.cpu.edi << 1) + this.cpu.edi);
            }
            case 429: {
                return this.cpu.ds.getByte((this.cpu.eax << 2) + this.cpu.eax);
            }
            case 430: {
                return this.cpu.ds.getByte((this.cpu.eax << 2) + this.cpu.ecx);
            }
            case 431: {
                return this.cpu.ds.getByte((this.cpu.eax << 2) + this.cpu.edx);
            }
            case 432: {
                return this.cpu.ds.getByte((this.cpu.eax << 2) + this.cpu.ebx);
            }
            case 433: {
                return this.cpu.ds.getByte((this.cpu.eax << 2) + this.cpu.esp);
            }
            case 434: {
                return this.cpu.ds.getByte((this.cpu.eax << 2) + this.getMicrocode());
            }
            case 435: {
                return this.cpu.ds.getByte((this.cpu.eax << 2) + this.cpu.esi);
            }
            case 436: {
                return this.cpu.ds.getByte((this.cpu.eax << 2) + this.cpu.edi);
            }
            case 437: {
                return this.cpu.ds.getByte((this.cpu.ecx << 2) + this.cpu.eax);
            }
            case 438: {
                return this.cpu.ds.getByte((this.cpu.ecx << 2) + this.cpu.ecx);
            }
            case 439: {
                return this.cpu.ds.getByte((this.cpu.ecx << 2) + this.cpu.edx);
            }
            case 440: {
                return this.cpu.ds.getByte((this.cpu.ecx << 2) + this.cpu.ebx);
            }
            case 441: {
                return this.cpu.ds.getByte((this.cpu.ecx << 2) + this.cpu.esp);
            }
            case 442: {
                return this.cpu.ds.getByte((this.cpu.ecx << 2) + this.getMicrocode());
            }
            case 443: {
                return this.cpu.ds.getByte((this.cpu.ecx << 2) + this.cpu.esi);
            }
            case 444: {
                return this.cpu.ds.getByte((this.cpu.ecx << 2) + this.cpu.edi);
            }
            case 445: {
                return this.cpu.ds.getByte((this.cpu.edx << 2) + this.cpu.eax);
            }
            case 446: {
                return this.cpu.ds.getByte((this.cpu.edx << 2) + this.cpu.ecx);
            }
            case 447: {
                return this.cpu.ds.getByte((this.cpu.edx << 2) + this.cpu.edx);
            }
            case 448: {
                return this.cpu.ds.getByte((this.cpu.edx << 2) + this.cpu.ebx);
            }
            case 449: {
                return this.cpu.ds.getByte((this.cpu.edx << 2) + this.cpu.esp);
            }
            case 450: {
                return this.cpu.ds.getByte((this.cpu.edx << 2) + this.getMicrocode());
            }
            case 451: {
                return this.cpu.ds.getByte((this.cpu.edx << 2) + this.cpu.esi);
            }
            case 452: {
                return this.cpu.ds.getByte((this.cpu.edx << 2) + this.cpu.edi);
            }
            case 453: {
                return this.cpu.ds.getByte((this.cpu.ebx << 2) + this.cpu.eax);
            }
            case 454: {
                return this.cpu.ds.getByte((this.cpu.ebx << 2) + this.cpu.ecx);
            }
            case 455: {
                return this.cpu.ds.getByte((this.cpu.ebx << 2) + this.cpu.edx);
            }
            case 456: {
                return this.cpu.ds.getByte((this.cpu.ebx << 2) + this.cpu.ebx);
            }
            case 457: {
                return this.cpu.ds.getByte((this.cpu.ebx << 2) + this.cpu.esp);
            }
            case 458: {
                return this.cpu.ds.getByte((this.cpu.ebx << 2) + this.getMicrocode());
            }
            case 459: {
                return this.cpu.ds.getByte((this.cpu.ebx << 2) + this.cpu.esi);
            }
            case 460: {
                return this.cpu.ds.getByte((this.cpu.ebx << 2) + this.cpu.edi);
            }
            case 461: {
                return this.cpu.ds.getByte((this.cpu.ebp << 2) + this.cpu.eax);
            }
            case 462: {
                return this.cpu.ds.getByte((this.cpu.ebp << 2) + this.cpu.ecx);
            }
            case 463: {
                return this.cpu.ds.getByte((this.cpu.ebp << 2) + this.cpu.edx);
            }
            case 464: {
                return this.cpu.ds.getByte((this.cpu.ebp << 2) + this.cpu.ebx);
            }
            case 465: {
                return this.cpu.ds.getByte((this.cpu.ebp << 2) + this.cpu.esp);
            }
            case 466: {
                return this.cpu.ds.getByte((this.cpu.ebp << 2) + this.getMicrocode());
            }
            case 467: {
                return this.cpu.ds.getByte((this.cpu.ebp << 2) + this.cpu.esi);
            }
            case 468: {
                return this.cpu.ds.getByte((this.cpu.ebp << 2) + this.cpu.edi);
            }
            case 469: {
                return this.cpu.ds.getByte((this.cpu.esi << 2) + this.cpu.eax);
            }
            case 470: {
                return this.cpu.ds.getByte((this.cpu.esi << 2) + this.cpu.ecx);
            }
            case 471: {
                return this.cpu.ds.getByte((this.cpu.esi << 2) + this.cpu.edx);
            }
            case 472: {
                return this.cpu.ds.getByte((this.cpu.esi << 2) + this.cpu.ebx);
            }
            case 473: {
                return this.cpu.ds.getByte((this.cpu.esi << 2) + this.cpu.esp);
            }
            case 474: {
                return this.cpu.ds.getByte((this.cpu.esi << 2) + this.getMicrocode());
            }
            case 475: {
                return this.cpu.ds.getByte((this.cpu.esi << 2) + this.cpu.esi);
            }
            case 476: {
                return this.cpu.ds.getByte((this.cpu.esi << 2) + this.cpu.edi);
            }
            case 477: {
                return this.cpu.ds.getByte((this.cpu.edi << 2) + this.cpu.eax);
            }
            case 478: {
                return this.cpu.ds.getByte((this.cpu.edi << 2) + this.cpu.ecx);
            }
            case 479: {
                return this.cpu.ds.getByte((this.cpu.edi << 2) + this.cpu.edx);
            }
            case 480: {
                return this.cpu.ds.getByte((this.cpu.edi << 2) + this.cpu.ebx);
            }
            case 481: {
                return this.cpu.ds.getByte((this.cpu.edi << 2) + this.cpu.esp);
            }
            case 482: {
                return this.cpu.ds.getByte((this.cpu.edi << 2) + this.getMicrocode());
            }
            case 483: {
                return this.cpu.ds.getByte((this.cpu.edi << 2) + this.cpu.esi);
            }
            case 484: {
                return this.cpu.ds.getByte((this.cpu.edi << 2) + this.cpu.edi);
            }
            case 485: {
                return this.cpu.ds.getByte((this.cpu.eax << 3) + this.cpu.eax);
            }
            case 486: {
                return this.cpu.ds.getByte((this.cpu.eax << 3) + this.cpu.ecx);
            }
            case 487: {
                return this.cpu.ds.getByte((this.cpu.eax << 3) + this.cpu.edx);
            }
            case 488: {
                return this.cpu.ds.getByte((this.cpu.eax << 3) + this.cpu.ebx);
            }
            case 489: {
                return this.cpu.ds.getByte((this.cpu.eax << 3) + this.cpu.esp);
            }
            case 490: {
                return this.cpu.ds.getByte((this.cpu.eax << 3) + this.getMicrocode());
            }
            case 491: {
                return this.cpu.ds.getByte((this.cpu.eax << 3) + this.cpu.esi);
            }
            case 492: {
                return this.cpu.ds.getByte((this.cpu.eax << 3) + this.cpu.edi);
            }
            case 493: {
                return this.cpu.ds.getByte((this.cpu.ecx << 3) + this.cpu.eax);
            }
            case 494: {
                return this.cpu.ds.getByte((this.cpu.ecx << 3) + this.cpu.ecx);
            }
            case 495: {
                return this.cpu.ds.getByte((this.cpu.ecx << 3) + this.cpu.edx);
            }
            case 496: {
                return this.cpu.ds.getByte((this.cpu.ecx << 3) + this.cpu.ebx);
            }
            case 497: {
                return this.cpu.ds.getByte((this.cpu.ecx << 3) + this.cpu.esp);
            }
            case 498: {
                return this.cpu.ds.getByte((this.cpu.ecx << 3) + this.getMicrocode());
            }
            case 499: {
                return this.cpu.ds.getByte((this.cpu.ecx << 3) + this.cpu.esi);
            }
            case 500: {
                return this.cpu.ds.getByte((this.cpu.ecx << 3) + this.cpu.edi);
            }
            case 501: {
                return this.cpu.ds.getByte((this.cpu.edx << 3) + this.cpu.eax);
            }
            case 502: {
                return this.cpu.ds.getByte((this.cpu.edx << 3) + this.cpu.ecx);
            }
            case 503: {
                return this.cpu.ds.getByte((this.cpu.edx << 3) + this.cpu.edx);
            }
            case 504: {
                return this.cpu.ds.getByte((this.cpu.edx << 3) + this.cpu.ebx);
            }
            case 505: {
                return this.cpu.ds.getByte((this.cpu.edx << 3) + this.cpu.esp);
            }
            case 506: {
                return this.cpu.ds.getByte((this.cpu.edx << 3) + this.getMicrocode());
            }
            case 507: {
                return this.cpu.ds.getByte((this.cpu.edx << 3) + this.cpu.esi);
            }
            case 508: {
                return this.cpu.ds.getByte((this.cpu.edx << 3) + this.cpu.edi);
            }
            case 509: {
                return this.cpu.ds.getByte((this.cpu.ebx << 3) + this.cpu.eax);
            }
            case 510: {
                return this.cpu.ds.getByte((this.cpu.ebx << 3) + this.cpu.ecx);
            }
            case 511: {
                return this.cpu.ds.getByte((this.cpu.ebx << 3) + this.cpu.edx);
            }
            case 512: {
                return this.cpu.ds.getByte((this.cpu.ebx << 3) + this.cpu.ebx);
            }
            case 513: {
                return this.cpu.ds.getByte((this.cpu.ebx << 3) + this.cpu.esp);
            }
            case 514: {
                return this.cpu.ds.getByte((this.cpu.ebx << 3) + this.getMicrocode());
            }
            case 515: {
                return this.cpu.ds.getByte((this.cpu.ebx << 3) + this.cpu.esi);
            }
            case 516: {
                return this.cpu.ds.getByte((this.cpu.ebx << 3) + this.cpu.edi);
            }
            case 517: {
                return this.cpu.ds.getByte((this.cpu.ebp << 3) + this.cpu.eax);
            }
            case 518: {
                return this.cpu.ds.getByte((this.cpu.ebp << 3) + this.cpu.ecx);
            }
            case 519: {
                return this.cpu.ds.getByte((this.cpu.ebp << 3) + this.cpu.edx);
            }
            case 520: {
                return this.cpu.ds.getByte((this.cpu.ebp << 3) + this.cpu.ebx);
            }
            case 521: {
                return this.cpu.ds.getByte((this.cpu.ebp << 3) + this.cpu.esp);
            }
            case 522: {
                return this.cpu.ds.getByte((this.cpu.ebp << 3) + this.getMicrocode());
            }
            case 523: {
                return this.cpu.ds.getByte((this.cpu.ebp << 3) + this.cpu.esi);
            }
            case 524: {
                return this.cpu.ds.getByte((this.cpu.ebp << 3) + this.cpu.edi);
            }
            case 525: {
                return this.cpu.ds.getByte((this.cpu.esi << 3) + this.cpu.eax);
            }
            case 526: {
                return this.cpu.ds.getByte((this.cpu.esi << 3) + this.cpu.ecx);
            }
            case 527: {
                return this.cpu.ds.getByte((this.cpu.esi << 3) + this.cpu.edx);
            }
            case 528: {
                return this.cpu.ds.getByte((this.cpu.esi << 3) + this.cpu.ebx);
            }
            case 529: {
                return this.cpu.ds.getByte((this.cpu.esi << 3) + this.cpu.esp);
            }
            case 530: {
                return this.cpu.ds.getByte((this.cpu.esi << 3) + this.getMicrocode());
            }
            case 531: {
                return this.cpu.ds.getByte((this.cpu.esi << 3) + this.cpu.esi);
            }
            case 532: {
                return this.cpu.ds.getByte((this.cpu.esi << 3) + this.cpu.edi);
            }
            case 533: {
                return this.cpu.ds.getByte((this.cpu.edi << 3) + this.cpu.eax);
            }
            case 534: {
                return this.cpu.ds.getByte((this.cpu.edi << 3) + this.cpu.ecx);
            }
            case 535: {
                return this.cpu.ds.getByte((this.cpu.edi << 3) + this.cpu.edx);
            }
            case 536: {
                return this.cpu.ds.getByte((this.cpu.edi << 3) + this.cpu.ebx);
            }
            case 537: {
                return this.cpu.ds.getByte((this.cpu.edi << 3) + this.cpu.esp);
            }
            case 538: {
                return this.cpu.ds.getByte((this.cpu.edi << 3) + this.getMicrocode());
            }
            case 539: {
                return this.cpu.ds.getByte((this.cpu.edi << 3) + this.cpu.esi);
            }
            case 540: {
                return this.cpu.ds.getByte((this.cpu.edi << 3) + this.cpu.edi);
            }
            case 541: {
                return this.cpu.ds.getByte(this.cpu.eax + this.cpu.eax + this.getMicrocode());
            }
            case 542: {
                return this.cpu.ds.getByte(this.cpu.eax + this.cpu.ecx + this.getMicrocode());
            }
            case 543: {
                return this.cpu.ds.getByte(this.cpu.eax + this.cpu.edx + this.getMicrocode());
            }
            case 544: {
                return this.cpu.ds.getByte(this.cpu.eax + this.cpu.ebx + this.getMicrocode());
            }
            case 545: {
                return this.cpu.ds.getByte(this.cpu.eax + this.cpu.esp + this.getMicrocode());
            }
            case 546: {
                return this.cpu.ds.getByte(this.cpu.eax + this.cpu.ebp + this.getMicrocode());
            }
            case 547: {
                return this.cpu.ds.getByte(this.cpu.eax + this.cpu.esi + this.getMicrocode());
            }
            case 548: {
                return this.cpu.ds.getByte(this.cpu.eax + this.cpu.edi + this.getMicrocode());
            }
            case 549: {
                return this.cpu.ds.getByte(this.cpu.ecx + this.cpu.ecx + this.getMicrocode());
            }
            case 550: {
                return this.cpu.ds.getByte(this.cpu.ecx + this.cpu.edx + this.getMicrocode());
            }
            case 551: {
                return this.cpu.ds.getByte(this.cpu.ecx + this.cpu.ebx + this.getMicrocode());
            }
            case 552: {
                return this.cpu.ds.getByte(this.cpu.ecx + this.cpu.esp + this.getMicrocode());
            }
            case 553: {
                return this.cpu.ds.getByte(this.cpu.ecx + this.cpu.ebp + this.getMicrocode());
            }
            case 554: {
                return this.cpu.ds.getByte(this.cpu.ecx + this.cpu.esi + this.getMicrocode());
            }
            case 555: {
                return this.cpu.ds.getByte(this.cpu.ecx + this.cpu.edi + this.getMicrocode());
            }
            case 556: {
                return this.cpu.ds.getByte(this.cpu.edx + this.cpu.edx + this.getMicrocode());
            }
            case 557: {
                return this.cpu.ds.getByte(this.cpu.edx + this.cpu.ebx + this.getMicrocode());
            }
            case 558: {
                return this.cpu.ds.getByte(this.cpu.edx + this.cpu.esp + this.getMicrocode());
            }
            case 559: {
                return this.cpu.ds.getByte(this.cpu.edx + this.cpu.ebp + this.getMicrocode());
            }
            case 560: {
                return this.cpu.ds.getByte(this.cpu.edx + this.cpu.esi + this.getMicrocode());
            }
            case 561: {
                return this.cpu.ds.getByte(this.cpu.edx + this.cpu.edi + this.getMicrocode());
            }
            case 562: {
                return this.cpu.ds.getByte(this.cpu.ebx + this.cpu.ebx + this.getMicrocode());
            }
            case 563: {
                return this.cpu.ds.getByte(this.cpu.ebx + this.cpu.esp + this.getMicrocode());
            }
            case 564: {
                return this.cpu.ds.getByte(this.cpu.ebx + this.cpu.ebp + this.getMicrocode());
            }
            case 565: {
                return this.cpu.ds.getByte(this.cpu.ebx + this.cpu.esi + this.getMicrocode());
            }
            case 566: {
                return this.cpu.ds.getByte(this.cpu.ebx + this.cpu.edi + this.getMicrocode());
            }
            case 567: {
                return this.cpu.ds.getByte(this.cpu.esp + this.getMicrocode());
            }
            case 568: {
                return this.cpu.ds.getByte(this.cpu.ebp + this.cpu.esp + this.getMicrocode());
            }
            case 569: {
                return this.cpu.ds.getByte(this.cpu.ebp + this.cpu.ebp + this.getMicrocode());
            }
            case 570: {
                return this.cpu.ds.getByte(this.cpu.ebp + this.cpu.esi + this.getMicrocode());
            }
            case 571: {
                return this.cpu.ds.getByte(this.cpu.ebp + this.cpu.edi + this.getMicrocode());
            }
            case 572: {
                return this.cpu.ds.getByte(this.cpu.esi + this.cpu.esp + this.getMicrocode());
            }
            case 573: {
                return this.cpu.ds.getByte(this.cpu.esi + this.cpu.esi + this.getMicrocode());
            }
            case 574: {
                return this.cpu.ds.getByte(this.cpu.esi + this.cpu.edi + this.getMicrocode());
            }
            case 575: {
                return this.cpu.ds.getByte(this.cpu.edi + this.cpu.esp + this.getMicrocode());
            }
            case 576: {
                return this.cpu.ds.getByte(this.cpu.edi + this.cpu.edi + this.getMicrocode());
            }
            case 577: {
                return this.cpu.ds.getByte((this.cpu.eax << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 578: {
                return this.cpu.ds.getByte((this.cpu.eax << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 579: {
                return this.cpu.ds.getByte((this.cpu.eax << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 580: {
                return this.cpu.ds.getByte((this.cpu.eax << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 581: {
                return this.cpu.ds.getByte((this.cpu.eax << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 582: {
                return this.cpu.ds.getByte((this.cpu.eax << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 583: {
                return this.cpu.ds.getByte((this.cpu.eax << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 584: {
                return this.cpu.ds.getByte((this.cpu.eax << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 585: {
                return this.cpu.ds.getByte((this.cpu.ecx << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 586: {
                return this.cpu.ds.getByte((this.cpu.ecx << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 587: {
                return this.cpu.ds.getByte((this.cpu.ecx << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 588: {
                return this.cpu.ds.getByte((this.cpu.ecx << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 589: {
                return this.cpu.ds.getByte((this.cpu.ecx << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 590: {
                return this.cpu.ds.getByte((this.cpu.ecx << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 591: {
                return this.cpu.ds.getByte((this.cpu.ecx << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 592: {
                return this.cpu.ds.getByte((this.cpu.ecx << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 593: {
                return this.cpu.ds.getByte((this.cpu.edx << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 594: {
                return this.cpu.ds.getByte((this.cpu.edx << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 595: {
                return this.cpu.ds.getByte((this.cpu.edx << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 596: {
                return this.cpu.ds.getByte((this.cpu.edx << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 597: {
                return this.cpu.ds.getByte((this.cpu.edx << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 598: {
                return this.cpu.ds.getByte((this.cpu.edx << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 599: {
                return this.cpu.ds.getByte((this.cpu.edx << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 600: {
                return this.cpu.ds.getByte((this.cpu.edx << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 601: {
                return this.cpu.ds.getByte((this.cpu.ebx << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 602: {
                return this.cpu.ds.getByte((this.cpu.ebx << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 603: {
                return this.cpu.ds.getByte((this.cpu.ebx << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 604: {
                return this.cpu.ds.getByte((this.cpu.ebx << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 605: {
                return this.cpu.ds.getByte((this.cpu.ebx << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 606: {
                return this.cpu.ds.getByte((this.cpu.ebx << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 607: {
                return this.cpu.ds.getByte((this.cpu.ebx << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 608: {
                return this.cpu.ds.getByte((this.cpu.ebx << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 609: {
                return this.cpu.ds.getByte((this.cpu.ebp << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 610: {
                return this.cpu.ds.getByte((this.cpu.ebp << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 611: {
                return this.cpu.ds.getByte((this.cpu.ebp << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 612: {
                return this.cpu.ds.getByte((this.cpu.ebp << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 613: {
                return this.cpu.ds.getByte((this.cpu.ebp << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 614: {
                return this.cpu.ds.getByte((this.cpu.ebp << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 615: {
                return this.cpu.ds.getByte((this.cpu.ebp << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 616: {
                return this.cpu.ds.getByte((this.cpu.ebp << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 617: {
                return this.cpu.ds.getByte((this.cpu.esi << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 618: {
                return this.cpu.ds.getByte((this.cpu.esi << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 619: {
                return this.cpu.ds.getByte((this.cpu.esi << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 620: {
                return this.cpu.ds.getByte((this.cpu.esi << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 621: {
                return this.cpu.ds.getByte((this.cpu.esi << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 622: {
                return this.cpu.ds.getByte((this.cpu.esi << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 623: {
                return this.cpu.ds.getByte((this.cpu.esi << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 624: {
                return this.cpu.ds.getByte((this.cpu.esi << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 625: {
                return this.cpu.ds.getByte((this.cpu.edi << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 626: {
                return this.cpu.ds.getByte((this.cpu.edi << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 627: {
                return this.cpu.ds.getByte((this.cpu.edi << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 628: {
                return this.cpu.ds.getByte((this.cpu.edi << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 629: {
                return this.cpu.ds.getByte((this.cpu.edi << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 630: {
                return this.cpu.ds.getByte((this.cpu.edi << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 631: {
                return this.cpu.ds.getByte((this.cpu.edi << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 632: {
                return this.cpu.ds.getByte((this.cpu.edi << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 633: {
                return this.cpu.ds.getByte((this.cpu.eax << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 634: {
                return this.cpu.ds.getByte((this.cpu.eax << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 635: {
                return this.cpu.ds.getByte((this.cpu.eax << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 636: {
                return this.cpu.ds.getByte((this.cpu.eax << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 637: {
                return this.cpu.ds.getByte((this.cpu.eax << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 638: {
                return this.cpu.ds.getByte((this.cpu.eax << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 639: {
                return this.cpu.ds.getByte((this.cpu.eax << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 640: {
                return this.cpu.ds.getByte((this.cpu.eax << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 641: {
                return this.cpu.ds.getByte((this.cpu.ecx << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 642: {
                return this.cpu.ds.getByte((this.cpu.ecx << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 643: {
                return this.cpu.ds.getByte((this.cpu.ecx << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 644: {
                return this.cpu.ds.getByte((this.cpu.ecx << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 645: {
                return this.cpu.ds.getByte((this.cpu.ecx << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 646: {
                return this.cpu.ds.getByte((this.cpu.ecx << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 647: {
                return this.cpu.ds.getByte((this.cpu.ecx << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 648: {
                return this.cpu.ds.getByte((this.cpu.ecx << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 649: {
                return this.cpu.ds.getByte((this.cpu.edx << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 650: {
                return this.cpu.ds.getByte((this.cpu.edx << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 651: {
                return this.cpu.ds.getByte((this.cpu.edx << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 652: {
                return this.cpu.ds.getByte((this.cpu.edx << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 653: {
                return this.cpu.ds.getByte((this.cpu.edx << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 654: {
                return this.cpu.ds.getByte((this.cpu.edx << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 655: {
                return this.cpu.ds.getByte((this.cpu.edx << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 656: {
                return this.cpu.ds.getByte((this.cpu.edx << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 657: {
                return this.cpu.ds.getByte((this.cpu.ebx << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 658: {
                return this.cpu.ds.getByte((this.cpu.ebx << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 659: {
                return this.cpu.ds.getByte((this.cpu.ebx << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 660: {
                return this.cpu.ds.getByte((this.cpu.ebx << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 661: {
                return this.cpu.ds.getByte((this.cpu.ebx << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 662: {
                return this.cpu.ds.getByte((this.cpu.ebx << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 663: {
                return this.cpu.ds.getByte((this.cpu.ebx << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 664: {
                return this.cpu.ds.getByte((this.cpu.ebx << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 665: {
                return this.cpu.ds.getByte((this.cpu.ebp << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 666: {
                return this.cpu.ds.getByte((this.cpu.ebp << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 667: {
                return this.cpu.ds.getByte((this.cpu.ebp << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 668: {
                return this.cpu.ds.getByte((this.cpu.ebp << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 669: {
                return this.cpu.ds.getByte((this.cpu.ebp << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 670: {
                return this.cpu.ds.getByte((this.cpu.ebp << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 671: {
                return this.cpu.ds.getByte((this.cpu.ebp << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 672: {
                return this.cpu.ds.getByte((this.cpu.ebp << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 673: {
                return this.cpu.ds.getByte((this.cpu.esi << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 674: {
                return this.cpu.ds.getByte((this.cpu.esi << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 675: {
                return this.cpu.ds.getByte((this.cpu.esi << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 676: {
                return this.cpu.ds.getByte((this.cpu.esi << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 677: {
                return this.cpu.ds.getByte((this.cpu.esi << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 678: {
                return this.cpu.ds.getByte((this.cpu.esi << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 679: {
                return this.cpu.ds.getByte((this.cpu.esi << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 680: {
                return this.cpu.ds.getByte((this.cpu.esi << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 681: {
                return this.cpu.ds.getByte((this.cpu.edi << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 682: {
                return this.cpu.ds.getByte((this.cpu.edi << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 683: {
                return this.cpu.ds.getByte((this.cpu.edi << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 684: {
                return this.cpu.ds.getByte((this.cpu.edi << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 685: {
                return this.cpu.ds.getByte((this.cpu.edi << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 686: {
                return this.cpu.ds.getByte((this.cpu.edi << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 687: {
                return this.cpu.ds.getByte((this.cpu.edi << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 688: {
                return this.cpu.ds.getByte((this.cpu.edi << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 689: {
                return this.cpu.ds.getByte((this.cpu.eax << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 690: {
                return this.cpu.ds.getByte((this.cpu.eax << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 691: {
                return this.cpu.ds.getByte((this.cpu.eax << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 692: {
                return this.cpu.ds.getByte((this.cpu.eax << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 693: {
                return this.cpu.ds.getByte((this.cpu.eax << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 694: {
                return this.cpu.ds.getByte((this.cpu.eax << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 695: {
                return this.cpu.ds.getByte((this.cpu.eax << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 696: {
                return this.cpu.ds.getByte((this.cpu.eax << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 697: {
                return this.cpu.ds.getByte((this.cpu.ecx << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 698: {
                return this.cpu.ds.getByte((this.cpu.ecx << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 699: {
                return this.cpu.ds.getByte((this.cpu.ecx << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 700: {
                return this.cpu.ds.getByte((this.cpu.ecx << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 701: {
                return this.cpu.ds.getByte((this.cpu.ecx << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 702: {
                return this.cpu.ds.getByte((this.cpu.ecx << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 703: {
                return this.cpu.ds.getByte((this.cpu.ecx << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 704: {
                return this.cpu.ds.getByte((this.cpu.ecx << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 705: {
                return this.cpu.ds.getByte((this.cpu.edx << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 706: {
                return this.cpu.ds.getByte((this.cpu.edx << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 707: {
                return this.cpu.ds.getByte((this.cpu.edx << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 708: {
                return this.cpu.ds.getByte((this.cpu.edx << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 709: {
                return this.cpu.ds.getByte((this.cpu.edx << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 710: {
                return this.cpu.ds.getByte((this.cpu.edx << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 711: {
                return this.cpu.ds.getByte((this.cpu.edx << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 712: {
                return this.cpu.ds.getByte((this.cpu.edx << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 713: {
                return this.cpu.ds.getByte((this.cpu.ebx << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 714: {
                return this.cpu.ds.getByte((this.cpu.ebx << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 715: {
                return this.cpu.ds.getByte((this.cpu.ebx << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 716: {
                return this.cpu.ds.getByte((this.cpu.ebx << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 717: {
                return this.cpu.ds.getByte((this.cpu.ebx << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 718: {
                return this.cpu.ds.getByte((this.cpu.ebx << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 719: {
                return this.cpu.ds.getByte((this.cpu.ebx << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 720: {
                return this.cpu.ds.getByte((this.cpu.ebx << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 721: {
                return this.cpu.ds.getByte((this.cpu.ebp << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 722: {
                return this.cpu.ds.getByte((this.cpu.ebp << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 723: {
                return this.cpu.ds.getByte((this.cpu.ebp << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 724: {
                return this.cpu.ds.getByte((this.cpu.ebp << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 725: {
                return this.cpu.ds.getByte((this.cpu.ebp << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 726: {
                return this.cpu.ds.getByte((this.cpu.ebp << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 727: {
                return this.cpu.ds.getByte((this.cpu.ebp << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 728: {
                return this.cpu.ds.getByte((this.cpu.ebp << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 729: {
                return this.cpu.ds.getByte((this.cpu.esi << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 730: {
                return this.cpu.ds.getByte((this.cpu.esi << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 731: {
                return this.cpu.ds.getByte((this.cpu.esi << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 732: {
                return this.cpu.ds.getByte((this.cpu.esi << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 733: {
                return this.cpu.ds.getByte((this.cpu.esi << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 734: {
                return this.cpu.ds.getByte((this.cpu.esi << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 735: {
                return this.cpu.ds.getByte((this.cpu.esi << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 736: {
                return this.cpu.ds.getByte((this.cpu.esi << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 737: {
                return this.cpu.ds.getByte((this.cpu.edi << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 738: {
                return this.cpu.ds.getByte((this.cpu.edi << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 739: {
                return this.cpu.ds.getByte((this.cpu.edi << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 740: {
                return this.cpu.ds.getByte((this.cpu.edi << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 741: {
                return this.cpu.ds.getByte((this.cpu.edi << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 742: {
                return this.cpu.ds.getByte((this.cpu.edi << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 743: {
                return this.cpu.ds.getByte((this.cpu.edi << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 744: {
                return this.cpu.ds.getByte((this.cpu.edi << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 745: {
                return this.cpu.ds.getByte(this.cpu.eax + this.cpu.ecx + this.getMicrocode());
            }
            case 746: {
                return this.cpu.ds.getByte(this.cpu.eax + this.cpu.edx + this.getMicrocode());
            }
            case 747: {
                return this.cpu.ds.getByte(this.cpu.eax + this.cpu.ebx + this.getMicrocode());
            }
            case 748: {
                return this.cpu.ds.getByte(this.cpu.eax + this.cpu.esp + this.getMicrocode());
            }
            case 749: {
                return this.cpu.ds.getByte(this.cpu.eax + this.cpu.ebp + this.getMicrocode());
            }
            case 750: {
                return this.cpu.ds.getByte(this.cpu.eax + this.cpu.esi + this.getMicrocode());
            }
            case 751: {
                return this.cpu.ds.getByte(this.cpu.eax + this.cpu.edi + this.getMicrocode());
            }
            case 752: {
                return this.cpu.ds.getByte(this.cpu.ecx + this.cpu.edx + this.getMicrocode());
            }
            case 753: {
                return this.cpu.ds.getByte(this.cpu.ecx + this.cpu.ebx + this.getMicrocode());
            }
            case 754: {
                return this.cpu.ds.getByte(this.cpu.ecx + this.cpu.esp + this.getMicrocode());
            }
            case 755: {
                return this.cpu.ds.getByte(this.cpu.ecx + this.cpu.ebp + this.getMicrocode());
            }
            case 756: {
                return this.cpu.ds.getByte(this.cpu.ecx + this.cpu.esi + this.getMicrocode());
            }
            case 757: {
                return this.cpu.ds.getByte(this.cpu.ecx + this.cpu.edi + this.getMicrocode());
            }
            case 758: {
                return this.cpu.ds.getByte(this.cpu.edx + this.cpu.ebx + this.getMicrocode());
            }
            case 759: {
                return this.cpu.ds.getByte(this.cpu.edx + this.cpu.esp + this.getMicrocode());
            }
            case 760: {
                return this.cpu.ds.getByte(this.cpu.edx + this.cpu.ebp + this.getMicrocode());
            }
            case 761: {
                return this.cpu.ds.getByte(this.cpu.edx + this.cpu.esi + this.getMicrocode());
            }
            case 762: {
                return this.cpu.ds.getByte(this.cpu.edx + this.cpu.edi + this.getMicrocode());
            }
            case 763: {
                return this.cpu.ds.getByte(this.cpu.ebx + this.cpu.esp + this.getMicrocode());
            }
            case 764: {
                return this.cpu.ds.getByte(this.cpu.ebx + this.cpu.ebp + this.getMicrocode());
            }
            case 765: {
                return this.cpu.ds.getByte(this.cpu.ebx + this.cpu.esi + this.getMicrocode());
            }
            case 766: {
                return this.cpu.ds.getByte(this.cpu.ebx + this.cpu.edi + this.getMicrocode());
            }
            case 767: {
                return this.cpu.ds.getByte(this.cpu.esp + this.getMicrocode());
            }
            case 768: {
                return this.cpu.ds.getByte(this.cpu.ebp + this.cpu.esp + this.getMicrocode());
            }
            case 769: {
                return this.cpu.ds.getByte(this.cpu.ebp + this.cpu.esi + this.getMicrocode());
            }
            case 770: {
                return this.cpu.ds.getByte(this.cpu.ebp + this.cpu.edi + this.getMicrocode());
            }
            case 771: {
                return this.cpu.ds.getByte(this.cpu.esi + this.cpu.esp + this.getMicrocode());
            }
            case 772: {
                return this.cpu.ds.getByte(this.cpu.esi + this.cpu.edi + this.getMicrocode());
            }
            case 773: {
                return this.cpu.ds.getByte(this.cpu.edi + this.cpu.esp + this.getMicrocode());
            }
            case 774: {
                return this.cpu.ds.getByte((this.cpu.eax << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 775: {
                return this.cpu.ds.getByte((this.cpu.eax << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 776: {
                return this.cpu.ds.getByte((this.cpu.eax << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 777: {
                return this.cpu.ds.getByte((this.cpu.eax << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 778: {
                return this.cpu.ds.getByte((this.cpu.eax << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 779: {
                return this.cpu.ds.getByte((this.cpu.eax << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 780: {
                return this.cpu.ds.getByte((this.cpu.eax << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 781: {
                return this.cpu.ds.getByte((this.cpu.eax << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 782: {
                return this.cpu.ds.getByte((this.cpu.ecx << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 783: {
                return this.cpu.ds.getByte((this.cpu.ecx << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 784: {
                return this.cpu.ds.getByte((this.cpu.ecx << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 785: {
                return this.cpu.ds.getByte((this.cpu.ecx << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 786: {
                return this.cpu.ds.getByte((this.cpu.ecx << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 787: {
                return this.cpu.ds.getByte((this.cpu.ecx << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 788: {
                return this.cpu.ds.getByte((this.cpu.ecx << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 789: {
                return this.cpu.ds.getByte((this.cpu.ecx << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 790: {
                return this.cpu.ds.getByte((this.cpu.edx << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 791: {
                return this.cpu.ds.getByte((this.cpu.edx << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 792: {
                return this.cpu.ds.getByte((this.cpu.edx << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 793: {
                return this.cpu.ds.getByte((this.cpu.edx << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 794: {
                return this.cpu.ds.getByte((this.cpu.edx << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 795: {
                return this.cpu.ds.getByte((this.cpu.edx << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 796: {
                return this.cpu.ds.getByte((this.cpu.edx << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 797: {
                return this.cpu.ds.getByte((this.cpu.edx << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 798: {
                return this.cpu.ds.getByte((this.cpu.ebx << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 799: {
                return this.cpu.ds.getByte((this.cpu.ebx << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 800: {
                return this.cpu.ds.getByte((this.cpu.ebx << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 801: {
                return this.cpu.ds.getByte((this.cpu.ebx << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 802: {
                return this.cpu.ds.getByte((this.cpu.ebx << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 803: {
                return this.cpu.ds.getByte((this.cpu.ebx << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 804: {
                return this.cpu.ds.getByte((this.cpu.ebx << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 805: {
                return this.cpu.ds.getByte((this.cpu.ebx << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 806: {
                return this.cpu.ds.getByte((this.cpu.ebp << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 807: {
                return this.cpu.ds.getByte((this.cpu.ebp << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 808: {
                return this.cpu.ds.getByte((this.cpu.ebp << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 809: {
                return this.cpu.ds.getByte((this.cpu.ebp << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 810: {
                return this.cpu.ds.getByte((this.cpu.ebp << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 811: {
                return this.cpu.ds.getByte((this.cpu.ebp << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 812: {
                return this.cpu.ds.getByte((this.cpu.ebp << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 813: {
                return this.cpu.ds.getByte((this.cpu.ebp << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 814: {
                return this.cpu.ds.getByte((this.cpu.esi << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 815: {
                return this.cpu.ds.getByte((this.cpu.esi << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 816: {
                return this.cpu.ds.getByte((this.cpu.esi << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 817: {
                return this.cpu.ds.getByte((this.cpu.esi << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 818: {
                return this.cpu.ds.getByte((this.cpu.esi << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 819: {
                return this.cpu.ds.getByte((this.cpu.esi << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 820: {
                return this.cpu.ds.getByte((this.cpu.esi << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 821: {
                return this.cpu.ds.getByte((this.cpu.esi << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 822: {
                return this.cpu.ds.getByte((this.cpu.edi << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 823: {
                return this.cpu.ds.getByte((this.cpu.edi << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 824: {
                return this.cpu.ds.getByte((this.cpu.edi << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 825: {
                return this.cpu.ds.getByte((this.cpu.edi << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 826: {
                return this.cpu.ds.getByte((this.cpu.edi << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 827: {
                return this.cpu.ds.getByte((this.cpu.edi << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 828: {
                return this.cpu.ds.getByte((this.cpu.edi << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 829: {
                return this.cpu.ds.getByte((this.cpu.edi << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 830: {
                return this.cpu.ds.getByte((this.cpu.eax << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 831: {
                return this.cpu.ds.getByte((this.cpu.eax << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 832: {
                return this.cpu.ds.getByte((this.cpu.eax << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 833: {
                return this.cpu.ds.getByte((this.cpu.eax << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 834: {
                return this.cpu.ds.getByte((this.cpu.eax << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 835: {
                return this.cpu.ds.getByte((this.cpu.eax << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 836: {
                return this.cpu.ds.getByte((this.cpu.eax << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 837: {
                return this.cpu.ds.getByte((this.cpu.eax << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 838: {
                return this.cpu.ds.getByte((this.cpu.ecx << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 839: {
                return this.cpu.ds.getByte((this.cpu.ecx << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 840: {
                return this.cpu.ds.getByte((this.cpu.ecx << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 841: {
                return this.cpu.ds.getByte((this.cpu.ecx << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 842: {
                return this.cpu.ds.getByte((this.cpu.ecx << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 843: {
                return this.cpu.ds.getByte((this.cpu.ecx << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 844: {
                return this.cpu.ds.getByte((this.cpu.ecx << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 845: {
                return this.cpu.ds.getByte((this.cpu.ecx << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 846: {
                return this.cpu.ds.getByte((this.cpu.edx << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 847: {
                return this.cpu.ds.getByte((this.cpu.edx << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 848: {
                return this.cpu.ds.getByte((this.cpu.edx << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 849: {
                return this.cpu.ds.getByte((this.cpu.edx << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 850: {
                return this.cpu.ds.getByte((this.cpu.edx << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 851: {
                return this.cpu.ds.getByte((this.cpu.edx << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 852: {
                return this.cpu.ds.getByte((this.cpu.edx << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 853: {
                return this.cpu.ds.getByte((this.cpu.edx << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 854: {
                return this.cpu.ds.getByte((this.cpu.ebx << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 855: {
                return this.cpu.ds.getByte((this.cpu.ebx << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 856: {
                return this.cpu.ds.getByte((this.cpu.ebx << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 857: {
                return this.cpu.ds.getByte((this.cpu.ebx << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 858: {
                return this.cpu.ds.getByte((this.cpu.ebx << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 859: {
                return this.cpu.ds.getByte((this.cpu.ebx << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 860: {
                return this.cpu.ds.getByte((this.cpu.ebx << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 861: {
                return this.cpu.ds.getByte((this.cpu.ebx << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 862: {
                return this.cpu.ds.getByte((this.cpu.ebp << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 863: {
                return this.cpu.ds.getByte((this.cpu.ebp << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 864: {
                return this.cpu.ds.getByte((this.cpu.ebp << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 865: {
                return this.cpu.ds.getByte((this.cpu.ebp << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 866: {
                return this.cpu.ds.getByte((this.cpu.ebp << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 867: {
                return this.cpu.ds.getByte((this.cpu.ebp << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 868: {
                return this.cpu.ds.getByte((this.cpu.ebp << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 869: {
                return this.cpu.ds.getByte((this.cpu.ebp << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 870: {
                return this.cpu.ds.getByte((this.cpu.esi << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 871: {
                return this.cpu.ds.getByte((this.cpu.esi << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 872: {
                return this.cpu.ds.getByte((this.cpu.esi << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 873: {
                return this.cpu.ds.getByte((this.cpu.esi << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 874: {
                return this.cpu.ds.getByte((this.cpu.esi << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 875: {
                return this.cpu.ds.getByte((this.cpu.esi << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 876: {
                return this.cpu.ds.getByte((this.cpu.esi << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 877: {
                return this.cpu.ds.getByte((this.cpu.esi << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 878: {
                return this.cpu.ds.getByte((this.cpu.edi << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 879: {
                return this.cpu.ds.getByte((this.cpu.edi << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 880: {
                return this.cpu.ds.getByte((this.cpu.edi << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 881: {
                return this.cpu.ds.getByte((this.cpu.edi << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 882: {
                return this.cpu.ds.getByte((this.cpu.edi << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 883: {
                return this.cpu.ds.getByte((this.cpu.edi << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 884: {
                return this.cpu.ds.getByte((this.cpu.edi << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 885: {
                return this.cpu.ds.getByte((this.cpu.edi << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 886: {
                return this.cpu.ds.getByte((this.cpu.eax << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 887: {
                return this.cpu.ds.getByte((this.cpu.eax << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 888: {
                return this.cpu.ds.getByte((this.cpu.eax << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 889: {
                return this.cpu.ds.getByte((this.cpu.eax << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 890: {
                return this.cpu.ds.getByte((this.cpu.eax << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 891: {
                return this.cpu.ds.getByte((this.cpu.eax << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 892: {
                return this.cpu.ds.getByte((this.cpu.eax << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 893: {
                return this.cpu.ds.getByte((this.cpu.eax << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 894: {
                return this.cpu.ds.getByte((this.cpu.ecx << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 895: {
                return this.cpu.ds.getByte((this.cpu.ecx << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 896: {
                return this.cpu.ds.getByte((this.cpu.ecx << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 897: {
                return this.cpu.ds.getByte((this.cpu.ecx << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 898: {
                return this.cpu.ds.getByte((this.cpu.ecx << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 899: {
                return this.cpu.ds.getByte((this.cpu.ecx << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 900: {
                return this.cpu.ds.getByte((this.cpu.ecx << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 901: {
                return this.cpu.ds.getByte((this.cpu.ecx << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 902: {
                return this.cpu.ds.getByte((this.cpu.edx << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 903: {
                return this.cpu.ds.getByte((this.cpu.edx << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 904: {
                return this.cpu.ds.getByte((this.cpu.edx << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 905: {
                return this.cpu.ds.getByte((this.cpu.edx << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 906: {
                return this.cpu.ds.getByte((this.cpu.edx << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 907: {
                return this.cpu.ds.getByte((this.cpu.edx << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 908: {
                return this.cpu.ds.getByte((this.cpu.edx << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 909: {
                return this.cpu.ds.getByte((this.cpu.edx << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 910: {
                return this.cpu.ds.getByte((this.cpu.ebx << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 911: {
                return this.cpu.ds.getByte((this.cpu.ebx << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 912: {
                return this.cpu.ds.getByte((this.cpu.ebx << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 913: {
                return this.cpu.ds.getByte((this.cpu.ebx << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 914: {
                return this.cpu.ds.getByte((this.cpu.ebx << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 915: {
                return this.cpu.ds.getByte((this.cpu.ebx << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 916: {
                return this.cpu.ds.getByte((this.cpu.ebx << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 917: {
                return this.cpu.ds.getByte((this.cpu.ebx << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 918: {
                return this.cpu.ds.getByte((this.cpu.ebp << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 919: {
                return this.cpu.ds.getByte((this.cpu.ebp << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 920: {
                return this.cpu.ds.getByte((this.cpu.ebp << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 921: {
                return this.cpu.ds.getByte((this.cpu.ebp << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 922: {
                return this.cpu.ds.getByte((this.cpu.ebp << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 923: {
                return this.cpu.ds.getByte((this.cpu.ebp << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 924: {
                return this.cpu.ds.getByte((this.cpu.ebp << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 925: {
                return this.cpu.ds.getByte((this.cpu.ebp << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 926: {
                return this.cpu.ds.getByte((this.cpu.esi << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 927: {
                return this.cpu.ds.getByte((this.cpu.esi << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 928: {
                return this.cpu.ds.getByte((this.cpu.esi << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 929: {
                return this.cpu.ds.getByte((this.cpu.esi << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 930: {
                return this.cpu.ds.getByte((this.cpu.esi << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 931: {
                return this.cpu.ds.getByte((this.cpu.esi << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 932: {
                return this.cpu.ds.getByte((this.cpu.esi << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 933: {
                return this.cpu.ds.getByte((this.cpu.esi << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 934: {
                return this.cpu.ds.getByte((this.cpu.edi << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 935: {
                return this.cpu.ds.getByte((this.cpu.edi << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 936: {
                return this.cpu.ds.getByte((this.cpu.edi << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 937: {
                return this.cpu.ds.getByte((this.cpu.edi << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 938: {
                return this.cpu.ds.getByte((this.cpu.edi << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 939: {
                return this.cpu.ds.getByte((this.cpu.edi << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 940: {
                return this.cpu.ds.getByte((this.cpu.edi << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 941: {
                return this.cpu.ds.getByte((this.cpu.edi << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 2150: {
                return this.cpu.ss.getByte(this.cpu.eax + this.cpu.eax);
            }
            case 2151: {
                return this.cpu.ss.getByte(this.cpu.eax + this.cpu.ecx);
            }
            case 2152: {
                return this.cpu.ss.getByte(this.cpu.eax + this.cpu.edx);
            }
            case 2153: {
                return this.cpu.ss.getByte(this.cpu.eax + this.cpu.ebx);
            }
            case 2154: {
                return this.cpu.ss.getByte(this.cpu.eax + this.cpu.esp);
            }
            case 2155: {
                return this.cpu.ss.getByte(this.cpu.eax + this.cpu.ebp);
            }
            case 2156: {
                return this.cpu.ss.getByte(this.cpu.eax + this.cpu.esi);
            }
            case 2157: {
                return this.cpu.ss.getByte(this.cpu.eax + this.cpu.edi);
            }
            case 2158: {
                return this.cpu.ss.getByte(this.cpu.ecx + this.cpu.ecx);
            }
            case 2159: {
                return this.cpu.ss.getByte(this.cpu.ecx + this.cpu.edx);
            }
            case 2160: {
                return this.cpu.ss.getByte(this.cpu.ecx + this.cpu.ebx);
            }
            case 2161: {
                return this.cpu.ss.getByte(this.cpu.ecx + this.cpu.esp);
            }
            case 2162: {
                return this.cpu.ss.getByte(this.cpu.ecx + this.cpu.ebp);
            }
            case 2163: {
                return this.cpu.ss.getByte(this.cpu.ecx + this.cpu.esi);
            }
            case 2164: {
                return this.cpu.ss.getByte(this.cpu.ecx + this.cpu.edi);
            }
            case 2165: {
                return this.cpu.ss.getByte(this.cpu.edx + this.cpu.edx);
            }
            case 2166: {
                return this.cpu.ss.getByte(this.cpu.edx + this.cpu.ebx);
            }
            case 2167: {
                return this.cpu.ss.getByte(this.cpu.edx + this.cpu.esp);
            }
            case 2168: {
                return this.cpu.ss.getByte(this.cpu.edx + this.cpu.ebp);
            }
            case 2169: {
                return this.cpu.ss.getByte(this.cpu.edx + this.cpu.esi);
            }
            case 2170: {
                return this.cpu.ss.getByte(this.cpu.edx + this.cpu.edi);
            }
            case 2171: {
                return this.cpu.ss.getByte(this.cpu.ebx + this.cpu.ebx);
            }
            case 2172: {
                return this.cpu.ss.getByte(this.cpu.ebx + this.cpu.esp);
            }
            case 2173: {
                return this.cpu.ss.getByte(this.cpu.ebx + this.cpu.ebp);
            }
            case 2174: {
                return this.cpu.ss.getByte(this.cpu.ebx + this.cpu.esi);
            }
            case 2175: {
                return this.cpu.ss.getByte(this.cpu.ebx + this.cpu.edi);
            }
            case 2176: {
                return this.cpu.ss.getByte(this.cpu.esp);
            }
            case 2177: {
                return this.cpu.ss.getByte(this.cpu.ebp + this.cpu.esp);
            }
            case 2178: {
                return this.cpu.ss.getByte(this.cpu.ebp + this.cpu.esi);
            }
            case 2179: {
                return this.cpu.ss.getByte(this.cpu.ebp + this.cpu.edi);
            }
            case 2180: {
                return this.cpu.ss.getByte(this.cpu.esi + this.cpu.esp);
            }
            case 2181: {
                return this.cpu.ss.getByte(this.cpu.esi + this.cpu.esi);
            }
            case 2182: {
                return this.cpu.ss.getByte(this.cpu.esi + this.cpu.edi);
            }
            case 2183: {
                return this.cpu.ss.getByte(this.cpu.edi + this.cpu.esp);
            }
            case 2184: {
                return this.cpu.ss.getByte(this.cpu.edi + this.cpu.edi);
            }
            case 2185: {
                return this.cpu.ss.getByte((this.cpu.eax << 1) + this.cpu.eax);
            }
            case 2186: {
                return this.cpu.ss.getByte((this.cpu.eax << 1) + this.cpu.ecx);
            }
            case 2187: {
                return this.cpu.ss.getByte((this.cpu.eax << 1) + this.cpu.edx);
            }
            case 2188: {
                return this.cpu.ss.getByte((this.cpu.eax << 1) + this.cpu.ebx);
            }
            case 2189: {
                return this.cpu.ss.getByte((this.cpu.eax << 1) + this.cpu.esp);
            }
            case 2190: {
                return this.cpu.ss.getByte((this.cpu.eax << 1) + this.getMicrocode());
            }
            case 2191: {
                return this.cpu.ss.getByte((this.cpu.eax << 1) + this.cpu.esi);
            }
            case 2192: {
                return this.cpu.ss.getByte((this.cpu.eax << 1) + this.cpu.edi);
            }
            case 2193: {
                return this.cpu.ss.getByte((this.cpu.ecx << 1) + this.cpu.eax);
            }
            case 2194: {
                return this.cpu.ss.getByte((this.cpu.ecx << 1) + this.cpu.ecx);
            }
            case 2195: {
                return this.cpu.ss.getByte((this.cpu.ecx << 1) + this.cpu.edx);
            }
            case 2196: {
                return this.cpu.ss.getByte((this.cpu.ecx << 1) + this.cpu.ebx);
            }
            case 2197: {
                return this.cpu.ss.getByte((this.cpu.ecx << 1) + this.cpu.esp);
            }
            case 2198: {
                return this.cpu.ss.getByte((this.cpu.ecx << 1) + this.getMicrocode());
            }
            case 2199: {
                return this.cpu.ss.getByte((this.cpu.ecx << 1) + this.cpu.esi);
            }
            case 2200: {
                return this.cpu.ss.getByte((this.cpu.ecx << 1) + this.cpu.edi);
            }
            case 2201: {
                return this.cpu.ss.getByte((this.cpu.edx << 1) + this.cpu.eax);
            }
            case 2202: {
                return this.cpu.ss.getByte((this.cpu.edx << 1) + this.cpu.ecx);
            }
            case 2203: {
                return this.cpu.ss.getByte((this.cpu.edx << 1) + this.cpu.edx);
            }
            case 2204: {
                return this.cpu.ss.getByte((this.cpu.edx << 1) + this.cpu.ebx);
            }
            case 2205: {
                return this.cpu.ss.getByte((this.cpu.edx << 1) + this.cpu.esp);
            }
            case 2206: {
                return this.cpu.ss.getByte((this.cpu.edx << 1) + this.getMicrocode());
            }
            case 2207: {
                return this.cpu.ss.getByte((this.cpu.edx << 1) + this.cpu.esi);
            }
            case 2208: {
                return this.cpu.ss.getByte((this.cpu.edx << 1) + this.cpu.edi);
            }
            case 2209: {
                return this.cpu.ss.getByte((this.cpu.ebx << 1) + this.cpu.eax);
            }
            case 2210: {
                return this.cpu.ss.getByte((this.cpu.ebx << 1) + this.cpu.ecx);
            }
            case 2211: {
                return this.cpu.ss.getByte((this.cpu.ebx << 1) + this.cpu.edx);
            }
            case 2212: {
                return this.cpu.ss.getByte((this.cpu.ebx << 1) + this.cpu.ebx);
            }
            case 2213: {
                return this.cpu.ss.getByte((this.cpu.ebx << 1) + this.cpu.esp);
            }
            case 2214: {
                return this.cpu.ss.getByte((this.cpu.ebx << 1) + this.getMicrocode());
            }
            case 2215: {
                return this.cpu.ss.getByte((this.cpu.ebx << 1) + this.cpu.esi);
            }
            case 2216: {
                return this.cpu.ss.getByte((this.cpu.ebx << 1) + this.cpu.edi);
            }
            case 2217: {
                return this.cpu.ss.getByte((this.cpu.ebp << 1) + this.cpu.eax);
            }
            case 2218: {
                return this.cpu.ss.getByte((this.cpu.ebp << 1) + this.cpu.ecx);
            }
            case 2219: {
                return this.cpu.ss.getByte((this.cpu.ebp << 1) + this.cpu.edx);
            }
            case 2220: {
                return this.cpu.ss.getByte((this.cpu.ebp << 1) + this.cpu.ebx);
            }
            case 2221: {
                return this.cpu.ss.getByte((this.cpu.ebp << 1) + this.cpu.esp);
            }
            case 2222: {
                return this.cpu.ss.getByte((this.cpu.ebp << 1) + this.getMicrocode());
            }
            case 2223: {
                return this.cpu.ss.getByte((this.cpu.ebp << 1) + this.cpu.esi);
            }
            case 2224: {
                return this.cpu.ss.getByte((this.cpu.ebp << 1) + this.cpu.edi);
            }
            case 2225: {
                return this.cpu.ss.getByte((this.cpu.esi << 1) + this.cpu.eax);
            }
            case 2226: {
                return this.cpu.ss.getByte((this.cpu.esi << 1) + this.cpu.ecx);
            }
            case 2227: {
                return this.cpu.ss.getByte((this.cpu.esi << 1) + this.cpu.edx);
            }
            case 2228: {
                return this.cpu.ss.getByte((this.cpu.esi << 1) + this.cpu.ebx);
            }
            case 2229: {
                return this.cpu.ss.getByte((this.cpu.esi << 1) + this.cpu.esp);
            }
            case 2230: {
                return this.cpu.ss.getByte((this.cpu.esi << 1) + this.getMicrocode());
            }
            case 2231: {
                return this.cpu.ss.getByte((this.cpu.esi << 1) + this.cpu.esi);
            }
            case 2232: {
                return this.cpu.ss.getByte((this.cpu.esi << 1) + this.cpu.edi);
            }
            case 2233: {
                return this.cpu.ss.getByte((this.cpu.edi << 1) + this.cpu.eax);
            }
            case 2234: {
                return this.cpu.ss.getByte((this.cpu.edi << 1) + this.cpu.ecx);
            }
            case 2235: {
                return this.cpu.ss.getByte((this.cpu.edi << 1) + this.cpu.edx);
            }
            case 2236: {
                return this.cpu.ss.getByte((this.cpu.edi << 1) + this.cpu.ebx);
            }
            case 2237: {
                return this.cpu.ss.getByte((this.cpu.edi << 1) + this.cpu.esp);
            }
            case 2238: {
                return this.cpu.ss.getByte((this.cpu.edi << 1) + this.getMicrocode());
            }
            case 2239: {
                return this.cpu.ss.getByte((this.cpu.edi << 1) + this.cpu.esi);
            }
            case 2240: {
                return this.cpu.ss.getByte((this.cpu.edi << 1) + this.cpu.edi);
            }
            case 2241: {
                return this.cpu.ss.getByte((this.cpu.eax << 2) + this.cpu.eax);
            }
            case 2242: {
                return this.cpu.ss.getByte((this.cpu.eax << 2) + this.cpu.ecx);
            }
            case 2243: {
                return this.cpu.ss.getByte((this.cpu.eax << 2) + this.cpu.edx);
            }
            case 2244: {
                return this.cpu.ss.getByte((this.cpu.eax << 2) + this.cpu.ebx);
            }
            case 2245: {
                return this.cpu.ss.getByte((this.cpu.eax << 2) + this.cpu.esp);
            }
            case 2246: {
                return this.cpu.ss.getByte((this.cpu.eax << 2) + this.getMicrocode());
            }
            case 2247: {
                return this.cpu.ss.getByte((this.cpu.eax << 2) + this.cpu.esi);
            }
            case 2248: {
                return this.cpu.ss.getByte((this.cpu.eax << 2) + this.cpu.edi);
            }
            case 2249: {
                return this.cpu.ss.getByte((this.cpu.ecx << 2) + this.cpu.eax);
            }
            case 2250: {
                return this.cpu.ss.getByte((this.cpu.ecx << 2) + this.cpu.ecx);
            }
            case 2251: {
                return this.cpu.ss.getByte((this.cpu.ecx << 2) + this.cpu.edx);
            }
            case 2252: {
                return this.cpu.ss.getByte((this.cpu.ecx << 2) + this.cpu.ebx);
            }
            case 2253: {
                return this.cpu.ss.getByte((this.cpu.ecx << 2) + this.cpu.esp);
            }
            case 2254: {
                return this.cpu.ss.getByte((this.cpu.ecx << 2) + this.getMicrocode());
            }
            case 2255: {
                return this.cpu.ss.getByte((this.cpu.ecx << 2) + this.cpu.esi);
            }
            case 2256: {
                return this.cpu.ss.getByte((this.cpu.ecx << 2) + this.cpu.edi);
            }
            case 2257: {
                return this.cpu.ss.getByte((this.cpu.edx << 2) + this.cpu.eax);
            }
            case 2258: {
                return this.cpu.ss.getByte((this.cpu.edx << 2) + this.cpu.ecx);
            }
            case 2259: {
                return this.cpu.ss.getByte((this.cpu.edx << 2) + this.cpu.edx);
            }
            case 2260: {
                return this.cpu.ss.getByte((this.cpu.edx << 2) + this.cpu.ebx);
            }
            case 2261: {
                return this.cpu.ss.getByte((this.cpu.edx << 2) + this.cpu.esp);
            }
            case 2262: {
                return this.cpu.ss.getByte((this.cpu.edx << 2) + this.getMicrocode());
            }
            case 2263: {
                return this.cpu.ss.getByte((this.cpu.edx << 2) + this.cpu.esi);
            }
            case 2264: {
                return this.cpu.ss.getByte((this.cpu.edx << 2) + this.cpu.edi);
            }
            case 2265: {
                return this.cpu.ss.getByte((this.cpu.ebx << 2) + this.cpu.eax);
            }
            case 2266: {
                return this.cpu.ss.getByte((this.cpu.ebx << 2) + this.cpu.ecx);
            }
            case 2267: {
                return this.cpu.ss.getByte((this.cpu.ebx << 2) + this.cpu.edx);
            }
            case 2268: {
                return this.cpu.ss.getByte((this.cpu.ebx << 2) + this.cpu.ebx);
            }
            case 2269: {
                return this.cpu.ss.getByte((this.cpu.ebx << 2) + this.cpu.esp);
            }
            case 2270: {
                return this.cpu.ss.getByte((this.cpu.ebx << 2) + this.getMicrocode());
            }
            case 2271: {
                return this.cpu.ss.getByte((this.cpu.ebx << 2) + this.cpu.esi);
            }
            case 2272: {
                return this.cpu.ss.getByte((this.cpu.ebx << 2) + this.cpu.edi);
            }
            case 2273: {
                return this.cpu.ss.getByte((this.cpu.ebp << 2) + this.cpu.eax);
            }
            case 2274: {
                return this.cpu.ss.getByte((this.cpu.ebp << 2) + this.cpu.ecx);
            }
            case 2275: {
                return this.cpu.ss.getByte((this.cpu.ebp << 2) + this.cpu.edx);
            }
            case 2276: {
                return this.cpu.ss.getByte((this.cpu.ebp << 2) + this.cpu.ebx);
            }
            case 2277: {
                return this.cpu.ss.getByte((this.cpu.ebp << 2) + this.cpu.esp);
            }
            case 2278: {
                return this.cpu.ss.getByte((this.cpu.ebp << 2) + this.getMicrocode());
            }
            case 2279: {
                return this.cpu.ss.getByte((this.cpu.ebp << 2) + this.cpu.esi);
            }
            case 2280: {
                return this.cpu.ss.getByte((this.cpu.ebp << 2) + this.cpu.edi);
            }
            case 2281: {
                return this.cpu.ss.getByte((this.cpu.esi << 2) + this.cpu.eax);
            }
            case 2282: {
                return this.cpu.ss.getByte((this.cpu.esi << 2) + this.cpu.ecx);
            }
            case 2283: {
                return this.cpu.ss.getByte((this.cpu.esi << 2) + this.cpu.edx);
            }
            case 2284: {
                return this.cpu.ss.getByte((this.cpu.esi << 2) + this.cpu.ebx);
            }
            case 2285: {
                return this.cpu.ss.getByte((this.cpu.esi << 2) + this.cpu.esp);
            }
            case 2286: {
                return this.cpu.ss.getByte((this.cpu.esi << 2) + this.getMicrocode());
            }
            case 2287: {
                return this.cpu.ss.getByte((this.cpu.esi << 2) + this.cpu.esi);
            }
            case 2288: {
                return this.cpu.ss.getByte((this.cpu.esi << 2) + this.cpu.edi);
            }
            case 2289: {
                return this.cpu.ss.getByte((this.cpu.edi << 2) + this.cpu.eax);
            }
            case 2290: {
                return this.cpu.ss.getByte((this.cpu.edi << 2) + this.cpu.ecx);
            }
            case 2291: {
                return this.cpu.ss.getByte((this.cpu.edi << 2) + this.cpu.edx);
            }
            case 2292: {
                return this.cpu.ss.getByte((this.cpu.edi << 2) + this.cpu.ebx);
            }
            case 2293: {
                return this.cpu.ss.getByte((this.cpu.edi << 2) + this.cpu.esp);
            }
            case 2294: {
                return this.cpu.ss.getByte((this.cpu.edi << 2) + this.getMicrocode());
            }
            case 2295: {
                return this.cpu.ss.getByte((this.cpu.edi << 2) + this.cpu.esi);
            }
            case 2296: {
                return this.cpu.ss.getByte((this.cpu.edi << 2) + this.cpu.edi);
            }
            case 2297: {
                return this.cpu.ss.getByte((this.cpu.eax << 3) + this.cpu.eax);
            }
            case 2298: {
                return this.cpu.ss.getByte((this.cpu.eax << 3) + this.cpu.ecx);
            }
            case 2299: {
                return this.cpu.ss.getByte((this.cpu.eax << 3) + this.cpu.edx);
            }
            case 2300: {
                return this.cpu.ss.getByte((this.cpu.eax << 3) + this.cpu.ebx);
            }
            case 2301: {
                return this.cpu.ss.getByte((this.cpu.eax << 3) + this.cpu.esp);
            }
            case 2302: {
                return this.cpu.ss.getByte((this.cpu.eax << 3) + this.getMicrocode());
            }
            case 2303: {
                return this.cpu.ss.getByte((this.cpu.eax << 3) + this.cpu.esi);
            }
            case 2304: {
                return this.cpu.ss.getByte((this.cpu.eax << 3) + this.cpu.edi);
            }
            case 2305: {
                return this.cpu.ss.getByte((this.cpu.ecx << 3) + this.cpu.eax);
            }
            case 2306: {
                return this.cpu.ss.getByte((this.cpu.ecx << 3) + this.cpu.ecx);
            }
            case 2307: {
                return this.cpu.ss.getByte((this.cpu.ecx << 3) + this.cpu.edx);
            }
            case 2308: {
                return this.cpu.ss.getByte((this.cpu.ecx << 3) + this.cpu.ebx);
            }
            case 2309: {
                return this.cpu.ss.getByte((this.cpu.ecx << 3) + this.cpu.esp);
            }
            case 2310: {
                return this.cpu.ss.getByte((this.cpu.ecx << 3) + this.getMicrocode());
            }
            case 2311: {
                return this.cpu.ss.getByte((this.cpu.ecx << 3) + this.cpu.esi);
            }
            case 2312: {
                return this.cpu.ss.getByte((this.cpu.ecx << 3) + this.cpu.edi);
            }
            case 2313: {
                return this.cpu.ss.getByte((this.cpu.edx << 3) + this.cpu.eax);
            }
            case 2314: {
                return this.cpu.ss.getByte((this.cpu.edx << 3) + this.cpu.ecx);
            }
            case 2315: {
                return this.cpu.ss.getByte((this.cpu.edx << 3) + this.cpu.edx);
            }
            case 2316: {
                return this.cpu.ss.getByte((this.cpu.edx << 3) + this.cpu.ebx);
            }
            case 2317: {
                return this.cpu.ss.getByte((this.cpu.edx << 3) + this.cpu.esp);
            }
            case 2318: {
                return this.cpu.ss.getByte((this.cpu.edx << 3) + this.getMicrocode());
            }
            case 2319: {
                return this.cpu.ss.getByte((this.cpu.edx << 3) + this.cpu.esi);
            }
            case 2320: {
                return this.cpu.ss.getByte((this.cpu.edx << 3) + this.cpu.edi);
            }
            case 2321: {
                return this.cpu.ss.getByte((this.cpu.ebx << 3) + this.cpu.eax);
            }
            case 2322: {
                return this.cpu.ss.getByte((this.cpu.ebx << 3) + this.cpu.ecx);
            }
            case 2323: {
                return this.cpu.ss.getByte((this.cpu.ebx << 3) + this.cpu.edx);
            }
            case 2324: {
                return this.cpu.ss.getByte((this.cpu.ebx << 3) + this.cpu.ebx);
            }
            case 2325: {
                return this.cpu.ss.getByte((this.cpu.ebx << 3) + this.cpu.esp);
            }
            case 2326: {
                return this.cpu.ss.getByte((this.cpu.ebx << 3) + this.getMicrocode());
            }
            case 2327: {
                return this.cpu.ss.getByte((this.cpu.ebx << 3) + this.cpu.esi);
            }
            case 2328: {
                return this.cpu.ss.getByte((this.cpu.ebx << 3) + this.cpu.edi);
            }
            case 2329: {
                return this.cpu.ss.getByte((this.cpu.ebp << 3) + this.cpu.eax);
            }
            case 2330: {
                return this.cpu.ss.getByte((this.cpu.ebp << 3) + this.cpu.ecx);
            }
            case 2331: {
                return this.cpu.ss.getByte((this.cpu.ebp << 3) + this.cpu.edx);
            }
            case 2332: {
                return this.cpu.ss.getByte((this.cpu.ebp << 3) + this.cpu.ebx);
            }
            case 2333: {
                return this.cpu.ss.getByte((this.cpu.ebp << 3) + this.cpu.esp);
            }
            case 2334: {
                return this.cpu.ss.getByte((this.cpu.ebp << 3) + this.getMicrocode());
            }
            case 2335: {
                return this.cpu.ss.getByte((this.cpu.ebp << 3) + this.cpu.esi);
            }
            case 2336: {
                return this.cpu.ss.getByte((this.cpu.ebp << 3) + this.cpu.edi);
            }
            case 2337: {
                return this.cpu.ss.getByte((this.cpu.esi << 3) + this.cpu.eax);
            }
            case 2338: {
                return this.cpu.ss.getByte((this.cpu.esi << 3) + this.cpu.ecx);
            }
            case 2339: {
                return this.cpu.ss.getByte((this.cpu.esi << 3) + this.cpu.edx);
            }
            case 2340: {
                return this.cpu.ss.getByte((this.cpu.esi << 3) + this.cpu.ebx);
            }
            case 2341: {
                return this.cpu.ss.getByte((this.cpu.esi << 3) + this.cpu.esp);
            }
            case 2342: {
                return this.cpu.ss.getByte((this.cpu.esi << 3) + this.getMicrocode());
            }
            case 2343: {
                return this.cpu.ss.getByte((this.cpu.esi << 3) + this.cpu.esi);
            }
            case 2344: {
                return this.cpu.ss.getByte((this.cpu.esi << 3) + this.cpu.edi);
            }
            case 2345: {
                return this.cpu.ss.getByte((this.cpu.edi << 3) + this.cpu.eax);
            }
            case 2346: {
                return this.cpu.ss.getByte((this.cpu.edi << 3) + this.cpu.ecx);
            }
            case 2347: {
                return this.cpu.ss.getByte((this.cpu.edi << 3) + this.cpu.edx);
            }
            case 2348: {
                return this.cpu.ss.getByte((this.cpu.edi << 3) + this.cpu.ebx);
            }
            case 2349: {
                return this.cpu.ss.getByte((this.cpu.edi << 3) + this.cpu.esp);
            }
            case 2350: {
                return this.cpu.ss.getByte((this.cpu.edi << 3) + this.getMicrocode());
            }
            case 2351: {
                return this.cpu.ss.getByte((this.cpu.edi << 3) + this.cpu.esi);
            }
            case 2352: {
                return this.cpu.ss.getByte((this.cpu.edi << 3) + this.cpu.edi);
            }
            case 2353: {
                return this.cpu.ss.getByte(this.cpu.eax + this.cpu.eax + this.getMicrocode());
            }
            case 2354: {
                return this.cpu.ss.getByte(this.cpu.eax + this.cpu.ecx + this.getMicrocode());
            }
            case 2355: {
                return this.cpu.ss.getByte(this.cpu.eax + this.cpu.edx + this.getMicrocode());
            }
            case 2356: {
                return this.cpu.ss.getByte(this.cpu.eax + this.cpu.ebx + this.getMicrocode());
            }
            case 2357: {
                return this.cpu.ss.getByte(this.cpu.eax + this.cpu.esp + this.getMicrocode());
            }
            case 2358: {
                return this.cpu.ss.getByte(this.cpu.eax + this.cpu.ebp + this.getMicrocode());
            }
            case 2359: {
                return this.cpu.ss.getByte(this.cpu.eax + this.cpu.esi + this.getMicrocode());
            }
            case 2360: {
                return this.cpu.ss.getByte(this.cpu.eax + this.cpu.edi + this.getMicrocode());
            }
            case 2361: {
                return this.cpu.ss.getByte(this.cpu.ecx + this.cpu.ecx + this.getMicrocode());
            }
            case 2362: {
                return this.cpu.ss.getByte(this.cpu.ecx + this.cpu.edx + this.getMicrocode());
            }
            case 2363: {
                return this.cpu.ss.getByte(this.cpu.ecx + this.cpu.ebx + this.getMicrocode());
            }
            case 2364: {
                return this.cpu.ss.getByte(this.cpu.ecx + this.cpu.esp + this.getMicrocode());
            }
            case 2365: {
                return this.cpu.ss.getByte(this.cpu.ecx + this.cpu.ebp + this.getMicrocode());
            }
            case 2366: {
                return this.cpu.ss.getByte(this.cpu.ecx + this.cpu.esi + this.getMicrocode());
            }
            case 2367: {
                return this.cpu.ss.getByte(this.cpu.ecx + this.cpu.edi + this.getMicrocode());
            }
            case 2368: {
                return this.cpu.ss.getByte(this.cpu.edx + this.cpu.edx + this.getMicrocode());
            }
            case 2369: {
                return this.cpu.ss.getByte(this.cpu.edx + this.cpu.ebx + this.getMicrocode());
            }
            case 2370: {
                return this.cpu.ss.getByte(this.cpu.edx + this.cpu.esp + this.getMicrocode());
            }
            case 2371: {
                return this.cpu.ss.getByte(this.cpu.edx + this.cpu.ebp + this.getMicrocode());
            }
            case 2372: {
                return this.cpu.ss.getByte(this.cpu.edx + this.cpu.esi + this.getMicrocode());
            }
            case 2373: {
                return this.cpu.ss.getByte(this.cpu.edx + this.cpu.edi + this.getMicrocode());
            }
            case 2374: {
                return this.cpu.ss.getByte(this.cpu.ebx + this.cpu.ebx + this.getMicrocode());
            }
            case 2375: {
                return this.cpu.ss.getByte(this.cpu.ebx + this.cpu.esp + this.getMicrocode());
            }
            case 2376: {
                return this.cpu.ss.getByte(this.cpu.ebx + this.cpu.ebp + this.getMicrocode());
            }
            case 2377: {
                return this.cpu.ss.getByte(this.cpu.ebx + this.cpu.esi + this.getMicrocode());
            }
            case 2378: {
                return this.cpu.ss.getByte(this.cpu.ebx + this.cpu.edi + this.getMicrocode());
            }
            case 2379: {
                return this.cpu.ss.getByte(this.cpu.esp + this.getMicrocode());
            }
            case 2380: {
                return this.cpu.ss.getByte(this.cpu.ebp + this.cpu.esp + this.getMicrocode());
            }
            case 2381: {
                return this.cpu.ss.getByte(this.cpu.ebp + this.cpu.ebp + this.getMicrocode());
            }
            case 2382: {
                return this.cpu.ss.getByte(this.cpu.ebp + this.cpu.esi + this.getMicrocode());
            }
            case 2383: {
                return this.cpu.ss.getByte(this.cpu.ebp + this.cpu.edi + this.getMicrocode());
            }
            case 2384: {
                return this.cpu.ss.getByte(this.cpu.esi + this.cpu.esp + this.getMicrocode());
            }
            case 2385: {
                return this.cpu.ss.getByte(this.cpu.esi + this.cpu.esi + this.getMicrocode());
            }
            case 2386: {
                return this.cpu.ss.getByte(this.cpu.esi + this.cpu.edi + this.getMicrocode());
            }
            case 2387: {
                return this.cpu.ss.getByte(this.cpu.edi + this.cpu.esp + this.getMicrocode());
            }
            case 2388: {
                return this.cpu.ss.getByte(this.cpu.edi + this.cpu.edi + this.getMicrocode());
            }
            case 2389: {
                return this.cpu.ss.getByte((this.cpu.eax << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 2390: {
                return this.cpu.ss.getByte((this.cpu.eax << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 2391: {
                return this.cpu.ss.getByte((this.cpu.eax << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 2392: {
                return this.cpu.ss.getByte((this.cpu.eax << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 2393: {
                return this.cpu.ss.getByte((this.cpu.eax << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 2394: {
                return this.cpu.ss.getByte((this.cpu.eax << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 2395: {
                return this.cpu.ss.getByte((this.cpu.eax << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 2396: {
                return this.cpu.ss.getByte((this.cpu.eax << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 2397: {
                return this.cpu.ss.getByte((this.cpu.ecx << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 2398: {
                return this.cpu.ss.getByte((this.cpu.ecx << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 2399: {
                return this.cpu.ss.getByte((this.cpu.ecx << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 2400: {
                return this.cpu.ss.getByte((this.cpu.ecx << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 2401: {
                return this.cpu.ss.getByte((this.cpu.ecx << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 2402: {
                return this.cpu.ss.getByte((this.cpu.ecx << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 2403: {
                return this.cpu.ss.getByte((this.cpu.ecx << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 2404: {
                return this.cpu.ss.getByte((this.cpu.ecx << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 2405: {
                return this.cpu.ss.getByte((this.cpu.edx << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 2406: {
                return this.cpu.ss.getByte((this.cpu.edx << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 2407: {
                return this.cpu.ss.getByte((this.cpu.edx << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 2408: {
                return this.cpu.ss.getByte((this.cpu.edx << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 2409: {
                return this.cpu.ss.getByte((this.cpu.edx << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 2410: {
                return this.cpu.ss.getByte((this.cpu.edx << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 2411: {
                return this.cpu.ss.getByte((this.cpu.edx << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 2412: {
                return this.cpu.ss.getByte((this.cpu.edx << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 2413: {
                return this.cpu.ss.getByte((this.cpu.ebx << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 2414: {
                return this.cpu.ss.getByte((this.cpu.ebx << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 2415: {
                return this.cpu.ss.getByte((this.cpu.ebx << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 2416: {
                return this.cpu.ss.getByte((this.cpu.ebx << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 2417: {
                return this.cpu.ss.getByte((this.cpu.ebx << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 2418: {
                return this.cpu.ss.getByte((this.cpu.ebx << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 2419: {
                return this.cpu.ss.getByte((this.cpu.ebx << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 2420: {
                return this.cpu.ss.getByte((this.cpu.ebx << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 2421: {
                return this.cpu.ss.getByte((this.cpu.ebp << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 2422: {
                return this.cpu.ss.getByte((this.cpu.ebp << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 2423: {
                return this.cpu.ss.getByte((this.cpu.ebp << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 2424: {
                return this.cpu.ss.getByte((this.cpu.ebp << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 2425: {
                return this.cpu.ss.getByte((this.cpu.ebp << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 2426: {
                return this.cpu.ss.getByte((this.cpu.ebp << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 2427: {
                return this.cpu.ss.getByte((this.cpu.ebp << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 2428: {
                return this.cpu.ss.getByte((this.cpu.ebp << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 2429: {
                return this.cpu.ss.getByte((this.cpu.esi << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 2430: {
                return this.cpu.ss.getByte((this.cpu.esi << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 2431: {
                return this.cpu.ss.getByte((this.cpu.esi << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 2432: {
                return this.cpu.ss.getByte((this.cpu.esi << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 2433: {
                return this.cpu.ss.getByte((this.cpu.esi << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 2434: {
                return this.cpu.ss.getByte((this.cpu.esi << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 2435: {
                return this.cpu.ss.getByte((this.cpu.esi << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 2436: {
                return this.cpu.ss.getByte((this.cpu.esi << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 2437: {
                return this.cpu.ss.getByte((this.cpu.edi << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 2438: {
                return this.cpu.ss.getByte((this.cpu.edi << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 2439: {
                return this.cpu.ss.getByte((this.cpu.edi << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 2440: {
                return this.cpu.ss.getByte((this.cpu.edi << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 2441: {
                return this.cpu.ss.getByte((this.cpu.edi << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 2442: {
                return this.cpu.ss.getByte((this.cpu.edi << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 2443: {
                return this.cpu.ss.getByte((this.cpu.edi << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 2444: {
                return this.cpu.ss.getByte((this.cpu.edi << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 2445: {
                return this.cpu.ss.getByte((this.cpu.eax << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 2446: {
                return this.cpu.ss.getByte((this.cpu.eax << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 2447: {
                return this.cpu.ss.getByte((this.cpu.eax << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 2448: {
                return this.cpu.ss.getByte((this.cpu.eax << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 2449: {
                return this.cpu.ss.getByte((this.cpu.eax << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 2450: {
                return this.cpu.ss.getByte((this.cpu.eax << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 2451: {
                return this.cpu.ss.getByte((this.cpu.eax << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 2452: {
                return this.cpu.ss.getByte((this.cpu.eax << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 2453: {
                return this.cpu.ss.getByte((this.cpu.ecx << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 2454: {
                return this.cpu.ss.getByte((this.cpu.ecx << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 2455: {
                return this.cpu.ss.getByte((this.cpu.ecx << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 2456: {
                return this.cpu.ss.getByte((this.cpu.ecx << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 2457: {
                return this.cpu.ss.getByte((this.cpu.ecx << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 2458: {
                return this.cpu.ss.getByte((this.cpu.ecx << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 2459: {
                return this.cpu.ss.getByte((this.cpu.ecx << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 2460: {
                return this.cpu.ss.getByte((this.cpu.ecx << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 2461: {
                return this.cpu.ss.getByte((this.cpu.edx << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 2462: {
                return this.cpu.ss.getByte((this.cpu.edx << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 2463: {
                return this.cpu.ss.getByte((this.cpu.edx << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 2464: {
                return this.cpu.ss.getByte((this.cpu.edx << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 2465: {
                return this.cpu.ss.getByte((this.cpu.edx << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 2466: {
                return this.cpu.ss.getByte((this.cpu.edx << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 2467: {
                return this.cpu.ss.getByte((this.cpu.edx << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 2468: {
                return this.cpu.ss.getByte((this.cpu.edx << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 2469: {
                return this.cpu.ss.getByte((this.cpu.ebx << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 2470: {
                return this.cpu.ss.getByte((this.cpu.ebx << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 2471: {
                return this.cpu.ss.getByte((this.cpu.ebx << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 2472: {
                return this.cpu.ss.getByte((this.cpu.ebx << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 2473: {
                return this.cpu.ss.getByte((this.cpu.ebx << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 2474: {
                return this.cpu.ss.getByte((this.cpu.ebx << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 2475: {
                return this.cpu.ss.getByte((this.cpu.ebx << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 2476: {
                return this.cpu.ss.getByte((this.cpu.ebx << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 2477: {
                return this.cpu.ss.getByte((this.cpu.ebp << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 2478: {
                return this.cpu.ss.getByte((this.cpu.ebp << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 2479: {
                return this.cpu.ss.getByte((this.cpu.ebp << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 2480: {
                return this.cpu.ss.getByte((this.cpu.ebp << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 2481: {
                return this.cpu.ss.getByte((this.cpu.ebp << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 2482: {
                return this.cpu.ss.getByte((this.cpu.ebp << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 2483: {
                return this.cpu.ss.getByte((this.cpu.ebp << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 2484: {
                return this.cpu.ss.getByte((this.cpu.ebp << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 2485: {
                return this.cpu.ss.getByte((this.cpu.esi << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 2486: {
                return this.cpu.ss.getByte((this.cpu.esi << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 2487: {
                return this.cpu.ss.getByte((this.cpu.esi << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 2488: {
                return this.cpu.ss.getByte((this.cpu.esi << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 2489: {
                return this.cpu.ss.getByte((this.cpu.esi << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 2490: {
                return this.cpu.ss.getByte((this.cpu.esi << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 2491: {
                return this.cpu.ss.getByte((this.cpu.esi << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 2492: {
                return this.cpu.ss.getByte((this.cpu.esi << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 2493: {
                return this.cpu.ss.getByte((this.cpu.edi << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 2494: {
                return this.cpu.ss.getByte((this.cpu.edi << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 2495: {
                return this.cpu.ss.getByte((this.cpu.edi << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 2496: {
                return this.cpu.ss.getByte((this.cpu.edi << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 2497: {
                return this.cpu.ss.getByte((this.cpu.edi << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 2498: {
                return this.cpu.ss.getByte((this.cpu.edi << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 2499: {
                return this.cpu.ss.getByte((this.cpu.edi << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 2500: {
                return this.cpu.ss.getByte((this.cpu.edi << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 2501: {
                return this.cpu.ss.getByte((this.cpu.eax << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 2502: {
                return this.cpu.ss.getByte((this.cpu.eax << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 2503: {
                return this.cpu.ss.getByte((this.cpu.eax << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 2504: {
                return this.cpu.ss.getByte((this.cpu.eax << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 2505: {
                return this.cpu.ss.getByte((this.cpu.eax << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 2506: {
                return this.cpu.ss.getByte((this.cpu.eax << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 2507: {
                return this.cpu.ss.getByte((this.cpu.eax << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 2508: {
                return this.cpu.ss.getByte((this.cpu.eax << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 2509: {
                return this.cpu.ss.getByte((this.cpu.ecx << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 2510: {
                return this.cpu.ss.getByte((this.cpu.ecx << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 2511: {
                return this.cpu.ss.getByte((this.cpu.ecx << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 2512: {
                return this.cpu.ss.getByte((this.cpu.ecx << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 2513: {
                return this.cpu.ss.getByte((this.cpu.ecx << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 2514: {
                return this.cpu.ss.getByte((this.cpu.ecx << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 2515: {
                return this.cpu.ss.getByte((this.cpu.ecx << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 2516: {
                return this.cpu.ss.getByte((this.cpu.ecx << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 2517: {
                return this.cpu.ss.getByte((this.cpu.edx << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 2518: {
                return this.cpu.ss.getByte((this.cpu.edx << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 2519: {
                return this.cpu.ss.getByte((this.cpu.edx << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 2520: {
                return this.cpu.ss.getByte((this.cpu.edx << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 2521: {
                return this.cpu.ss.getByte((this.cpu.edx << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 2522: {
                return this.cpu.ss.getByte((this.cpu.edx << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 2523: {
                return this.cpu.ss.getByte((this.cpu.edx << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 2524: {
                return this.cpu.ss.getByte((this.cpu.edx << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 2525: {
                return this.cpu.ss.getByte((this.cpu.ebx << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 2526: {
                return this.cpu.ss.getByte((this.cpu.ebx << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 2527: {
                return this.cpu.ss.getByte((this.cpu.ebx << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 2528: {
                return this.cpu.ss.getByte((this.cpu.ebx << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 2529: {
                return this.cpu.ss.getByte((this.cpu.ebx << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 2530: {
                return this.cpu.ss.getByte((this.cpu.ebx << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 2531: {
                return this.cpu.ss.getByte((this.cpu.ebx << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 2532: {
                return this.cpu.ss.getByte((this.cpu.ebx << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 2533: {
                return this.cpu.ss.getByte((this.cpu.ebp << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 2534: {
                return this.cpu.ss.getByte((this.cpu.ebp << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 2535: {
                return this.cpu.ss.getByte((this.cpu.ebp << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 2536: {
                return this.cpu.ss.getByte((this.cpu.ebp << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 2537: {
                return this.cpu.ss.getByte((this.cpu.ebp << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 2538: {
                return this.cpu.ss.getByte((this.cpu.ebp << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 2539: {
                return this.cpu.ss.getByte((this.cpu.ebp << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 2540: {
                return this.cpu.ss.getByte((this.cpu.ebp << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 2541: {
                return this.cpu.ss.getByte((this.cpu.esi << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 2542: {
                return this.cpu.ss.getByte((this.cpu.esi << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 2543: {
                return this.cpu.ss.getByte((this.cpu.esi << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 2544: {
                return this.cpu.ss.getByte((this.cpu.esi << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 2545: {
                return this.cpu.ss.getByte((this.cpu.esi << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 2546: {
                return this.cpu.ss.getByte((this.cpu.esi << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 2547: {
                return this.cpu.ss.getByte((this.cpu.esi << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 2548: {
                return this.cpu.ss.getByte((this.cpu.esi << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 2549: {
                return this.cpu.ss.getByte((this.cpu.edi << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 2550: {
                return this.cpu.ss.getByte((this.cpu.edi << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 2551: {
                return this.cpu.ss.getByte((this.cpu.edi << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 2552: {
                return this.cpu.ss.getByte((this.cpu.edi << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 2553: {
                return this.cpu.ss.getByte((this.cpu.edi << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 2554: {
                return this.cpu.ss.getByte((this.cpu.edi << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 2555: {
                return this.cpu.ss.getByte((this.cpu.edi << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 2556: {
                return this.cpu.ss.getByte((this.cpu.edi << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 2557: {
                return this.cpu.ss.getByte(this.cpu.eax + this.cpu.ecx + this.getMicrocode());
            }
            case 2558: {
                return this.cpu.ss.getByte(this.cpu.eax + this.cpu.edx + this.getMicrocode());
            }
            case 2559: {
                return this.cpu.ss.getByte(this.cpu.eax + this.cpu.ebx + this.getMicrocode());
            }
            case 2560: {
                return this.cpu.ss.getByte(this.cpu.eax + this.cpu.esp + this.getMicrocode());
            }
            case 2561: {
                return this.cpu.ss.getByte(this.cpu.eax + this.cpu.ebp + this.getMicrocode());
            }
            case 2562: {
                return this.cpu.ss.getByte(this.cpu.eax + this.cpu.esi + this.getMicrocode());
            }
            case 2563: {
                return this.cpu.ss.getByte(this.cpu.eax + this.cpu.edi + this.getMicrocode());
            }
            case 2564: {
                return this.cpu.ss.getByte(this.cpu.ecx + this.cpu.edx + this.getMicrocode());
            }
            case 2565: {
                return this.cpu.ss.getByte(this.cpu.ecx + this.cpu.ebx + this.getMicrocode());
            }
            case 2566: {
                return this.cpu.ss.getByte(this.cpu.ecx + this.cpu.esp + this.getMicrocode());
            }
            case 2567: {
                return this.cpu.ss.getByte(this.cpu.ecx + this.cpu.ebp + this.getMicrocode());
            }
            case 2568: {
                return this.cpu.ss.getByte(this.cpu.ecx + this.cpu.esi + this.getMicrocode());
            }
            case 2569: {
                return this.cpu.ss.getByte(this.cpu.ecx + this.cpu.edi + this.getMicrocode());
            }
            case 2570: {
                return this.cpu.ss.getByte(this.cpu.edx + this.cpu.ebx + this.getMicrocode());
            }
            case 2571: {
                return this.cpu.ss.getByte(this.cpu.edx + this.cpu.esp + this.getMicrocode());
            }
            case 2572: {
                return this.cpu.ss.getByte(this.cpu.edx + this.cpu.ebp + this.getMicrocode());
            }
            case 2573: {
                return this.cpu.ss.getByte(this.cpu.edx + this.cpu.esi + this.getMicrocode());
            }
            case 2574: {
                return this.cpu.ss.getByte(this.cpu.edx + this.cpu.edi + this.getMicrocode());
            }
            case 2575: {
                return this.cpu.ss.getByte(this.cpu.ebx + this.cpu.esp + this.getMicrocode());
            }
            case 2576: {
                return this.cpu.ss.getByte(this.cpu.ebx + this.cpu.ebp + this.getMicrocode());
            }
            case 2577: {
                return this.cpu.ss.getByte(this.cpu.ebx + this.cpu.esi + this.getMicrocode());
            }
            case 2578: {
                return this.cpu.ss.getByte(this.cpu.ebx + this.cpu.edi + this.getMicrocode());
            }
            case 2579: {
                return this.cpu.ss.getByte(this.cpu.esp + this.getMicrocode());
            }
            case 2580: {
                return this.cpu.ss.getByte(this.cpu.ebp + this.cpu.esp + this.getMicrocode());
            }
            case 2581: {
                return this.cpu.ss.getByte(this.cpu.ebp + this.cpu.esi + this.getMicrocode());
            }
            case 2582: {
                return this.cpu.ss.getByte(this.cpu.ebp + this.cpu.edi + this.getMicrocode());
            }
            case 2583: {
                return this.cpu.ss.getByte(this.cpu.esi + this.cpu.esp + this.getMicrocode());
            }
            case 2584: {
                return this.cpu.ss.getByte(this.cpu.esi + this.cpu.edi + this.getMicrocode());
            }
            case 2585: {
                return this.cpu.ss.getByte(this.cpu.edi + this.cpu.esp + this.getMicrocode());
            }
            case 2586: {
                return this.cpu.ss.getByte((this.cpu.eax << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 2587: {
                return this.cpu.ss.getByte((this.cpu.eax << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 2588: {
                return this.cpu.ss.getByte((this.cpu.eax << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 2589: {
                return this.cpu.ss.getByte((this.cpu.eax << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 2590: {
                return this.cpu.ss.getByte((this.cpu.eax << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 2591: {
                return this.cpu.ss.getByte((this.cpu.eax << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 2592: {
                return this.cpu.ss.getByte((this.cpu.eax << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 2593: {
                return this.cpu.ss.getByte((this.cpu.eax << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 2594: {
                return this.cpu.ss.getByte((this.cpu.ecx << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 2595: {
                return this.cpu.ss.getByte((this.cpu.ecx << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 2596: {
                return this.cpu.ss.getByte((this.cpu.ecx << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 2597: {
                return this.cpu.ss.getByte((this.cpu.ecx << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 2598: {
                return this.cpu.ss.getByte((this.cpu.ecx << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 2599: {
                return this.cpu.ss.getByte((this.cpu.ecx << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 2600: {
                return this.cpu.ss.getByte((this.cpu.ecx << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 2601: {
                return this.cpu.ss.getByte((this.cpu.ecx << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 2602: {
                return this.cpu.ss.getByte((this.cpu.edx << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 2603: {
                return this.cpu.ss.getByte((this.cpu.edx << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 2604: {
                return this.cpu.ss.getByte((this.cpu.edx << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 2605: {
                return this.cpu.ss.getByte((this.cpu.edx << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 2606: {
                return this.cpu.ss.getByte((this.cpu.edx << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 2607: {
                return this.cpu.ss.getByte((this.cpu.edx << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 2608: {
                return this.cpu.ss.getByte((this.cpu.edx << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 2609: {
                return this.cpu.ss.getByte((this.cpu.edx << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 2610: {
                return this.cpu.ss.getByte((this.cpu.ebx << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 2611: {
                return this.cpu.ss.getByte((this.cpu.ebx << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 2612: {
                return this.cpu.ss.getByte((this.cpu.ebx << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 2613: {
                return this.cpu.ss.getByte((this.cpu.ebx << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 2614: {
                return this.cpu.ss.getByte((this.cpu.ebx << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 2615: {
                return this.cpu.ss.getByte((this.cpu.ebx << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 2616: {
                return this.cpu.ss.getByte((this.cpu.ebx << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 2617: {
                return this.cpu.ss.getByte((this.cpu.ebx << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 2618: {
                return this.cpu.ss.getByte((this.cpu.ebp << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 2619: {
                return this.cpu.ss.getByte((this.cpu.ebp << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 2620: {
                return this.cpu.ss.getByte((this.cpu.ebp << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 2621: {
                return this.cpu.ss.getByte((this.cpu.ebp << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 2622: {
                return this.cpu.ss.getByte((this.cpu.ebp << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 2623: {
                return this.cpu.ss.getByte((this.cpu.ebp << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 2624: {
                return this.cpu.ss.getByte((this.cpu.ebp << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 2625: {
                return this.cpu.ss.getByte((this.cpu.ebp << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 2626: {
                return this.cpu.ss.getByte((this.cpu.esi << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 2627: {
                return this.cpu.ss.getByte((this.cpu.esi << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 2628: {
                return this.cpu.ss.getByte((this.cpu.esi << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 2629: {
                return this.cpu.ss.getByte((this.cpu.esi << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 2630: {
                return this.cpu.ss.getByte((this.cpu.esi << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 2631: {
                return this.cpu.ss.getByte((this.cpu.esi << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 2632: {
                return this.cpu.ss.getByte((this.cpu.esi << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 2633: {
                return this.cpu.ss.getByte((this.cpu.esi << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 2634: {
                return this.cpu.ss.getByte((this.cpu.edi << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 2635: {
                return this.cpu.ss.getByte((this.cpu.edi << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 2636: {
                return this.cpu.ss.getByte((this.cpu.edi << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 2637: {
                return this.cpu.ss.getByte((this.cpu.edi << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 2638: {
                return this.cpu.ss.getByte((this.cpu.edi << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 2639: {
                return this.cpu.ss.getByte((this.cpu.edi << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 2640: {
                return this.cpu.ss.getByte((this.cpu.edi << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 2641: {
                return this.cpu.ss.getByte((this.cpu.edi << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 2642: {
                return this.cpu.ss.getByte((this.cpu.eax << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 2643: {
                return this.cpu.ss.getByte((this.cpu.eax << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 2644: {
                return this.cpu.ss.getByte((this.cpu.eax << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 2645: {
                return this.cpu.ss.getByte((this.cpu.eax << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 2646: {
                return this.cpu.ss.getByte((this.cpu.eax << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 2647: {
                return this.cpu.ss.getByte((this.cpu.eax << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 2648: {
                return this.cpu.ss.getByte((this.cpu.eax << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 2649: {
                return this.cpu.ss.getByte((this.cpu.eax << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 2650: {
                return this.cpu.ss.getByte((this.cpu.ecx << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 2651: {
                return this.cpu.ss.getByte((this.cpu.ecx << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 2652: {
                return this.cpu.ss.getByte((this.cpu.ecx << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 2653: {
                return this.cpu.ss.getByte((this.cpu.ecx << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 2654: {
                return this.cpu.ss.getByte((this.cpu.ecx << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 2655: {
                return this.cpu.ss.getByte((this.cpu.ecx << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 2656: {
                return this.cpu.ss.getByte((this.cpu.ecx << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 2657: {
                return this.cpu.ss.getByte((this.cpu.ecx << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 2658: {
                return this.cpu.ss.getByte((this.cpu.edx << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 2659: {
                return this.cpu.ss.getByte((this.cpu.edx << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 2660: {
                return this.cpu.ss.getByte((this.cpu.edx << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 2661: {
                return this.cpu.ss.getByte((this.cpu.edx << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 2662: {
                return this.cpu.ss.getByte((this.cpu.edx << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 2663: {
                return this.cpu.ss.getByte((this.cpu.edx << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 2664: {
                return this.cpu.ss.getByte((this.cpu.edx << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 2665: {
                return this.cpu.ss.getByte((this.cpu.edx << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 2666: {
                return this.cpu.ss.getByte((this.cpu.ebx << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 2667: {
                return this.cpu.ss.getByte((this.cpu.ebx << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 2668: {
                return this.cpu.ss.getByte((this.cpu.ebx << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 2669: {
                return this.cpu.ss.getByte((this.cpu.ebx << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 2670: {
                return this.cpu.ss.getByte((this.cpu.ebx << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 2671: {
                return this.cpu.ss.getByte((this.cpu.ebx << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 2672: {
                return this.cpu.ss.getByte((this.cpu.ebx << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 2673: {
                return this.cpu.ss.getByte((this.cpu.ebx << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 2674: {
                return this.cpu.ss.getByte((this.cpu.ebp << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 2675: {
                return this.cpu.ss.getByte((this.cpu.ebp << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 2676: {
                return this.cpu.ss.getByte((this.cpu.ebp << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 2677: {
                return this.cpu.ss.getByte((this.cpu.ebp << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 2678: {
                return this.cpu.ss.getByte((this.cpu.ebp << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 2679: {
                return this.cpu.ss.getByte((this.cpu.ebp << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 2680: {
                return this.cpu.ss.getByte((this.cpu.ebp << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 2681: {
                return this.cpu.ss.getByte((this.cpu.ebp << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 2682: {
                return this.cpu.ss.getByte((this.cpu.esi << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 2683: {
                return this.cpu.ss.getByte((this.cpu.esi << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 2684: {
                return this.cpu.ss.getByte((this.cpu.esi << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 2685: {
                return this.cpu.ss.getByte((this.cpu.esi << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 2686: {
                return this.cpu.ss.getByte((this.cpu.esi << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 2687: {
                return this.cpu.ss.getByte((this.cpu.esi << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 2688: {
                return this.cpu.ss.getByte((this.cpu.esi << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 2689: {
                return this.cpu.ss.getByte((this.cpu.esi << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 2690: {
                return this.cpu.ss.getByte((this.cpu.edi << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 2691: {
                return this.cpu.ss.getByte((this.cpu.edi << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 2692: {
                return this.cpu.ss.getByte((this.cpu.edi << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 2693: {
                return this.cpu.ss.getByte((this.cpu.edi << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 2694: {
                return this.cpu.ss.getByte((this.cpu.edi << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 2695: {
                return this.cpu.ss.getByte((this.cpu.edi << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 2696: {
                return this.cpu.ss.getByte((this.cpu.edi << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 2697: {
                return this.cpu.ss.getByte((this.cpu.edi << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 2698: {
                return this.cpu.ss.getByte((this.cpu.eax << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 2699: {
                return this.cpu.ss.getByte((this.cpu.eax << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 2700: {
                return this.cpu.ss.getByte((this.cpu.eax << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 2701: {
                return this.cpu.ss.getByte((this.cpu.eax << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 2702: {
                return this.cpu.ss.getByte((this.cpu.eax << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 2703: {
                return this.cpu.ss.getByte((this.cpu.eax << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 2704: {
                return this.cpu.ss.getByte((this.cpu.eax << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 2705: {
                return this.cpu.ss.getByte((this.cpu.eax << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 2706: {
                return this.cpu.ss.getByte((this.cpu.ecx << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 2707: {
                return this.cpu.ss.getByte((this.cpu.ecx << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 2708: {
                return this.cpu.ss.getByte((this.cpu.ecx << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 2709: {
                return this.cpu.ss.getByte((this.cpu.ecx << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 2710: {
                return this.cpu.ss.getByte((this.cpu.ecx << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 2711: {
                return this.cpu.ss.getByte((this.cpu.ecx << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 2712: {
                return this.cpu.ss.getByte((this.cpu.ecx << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 2713: {
                return this.cpu.ss.getByte((this.cpu.ecx << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 2714: {
                return this.cpu.ss.getByte((this.cpu.edx << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 2715: {
                return this.cpu.ss.getByte((this.cpu.edx << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 2716: {
                return this.cpu.ss.getByte((this.cpu.edx << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 2717: {
                return this.cpu.ss.getByte((this.cpu.edx << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 2718: {
                return this.cpu.ss.getByte((this.cpu.edx << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 2719: {
                return this.cpu.ss.getByte((this.cpu.edx << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 2720: {
                return this.cpu.ss.getByte((this.cpu.edx << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 2721: {
                return this.cpu.ss.getByte((this.cpu.edx << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 2722: {
                return this.cpu.ss.getByte((this.cpu.ebx << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 2723: {
                return this.cpu.ss.getByte((this.cpu.ebx << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 2724: {
                return this.cpu.ss.getByte((this.cpu.ebx << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 2725: {
                return this.cpu.ss.getByte((this.cpu.ebx << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 2726: {
                return this.cpu.ss.getByte((this.cpu.ebx << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 2727: {
                return this.cpu.ss.getByte((this.cpu.ebx << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 2728: {
                return this.cpu.ss.getByte((this.cpu.ebx << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 2729: {
                return this.cpu.ss.getByte((this.cpu.ebx << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 2730: {
                return this.cpu.ss.getByte((this.cpu.ebp << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 2731: {
                return this.cpu.ss.getByte((this.cpu.ebp << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 2732: {
                return this.cpu.ss.getByte((this.cpu.ebp << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 2733: {
                return this.cpu.ss.getByte((this.cpu.ebp << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 2734: {
                return this.cpu.ss.getByte((this.cpu.ebp << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 2735: {
                return this.cpu.ss.getByte((this.cpu.ebp << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 2736: {
                return this.cpu.ss.getByte((this.cpu.ebp << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 2737: {
                return this.cpu.ss.getByte((this.cpu.ebp << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 2738: {
                return this.cpu.ss.getByte((this.cpu.esi << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 2739: {
                return this.cpu.ss.getByte((this.cpu.esi << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 2740: {
                return this.cpu.ss.getByte((this.cpu.esi << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 2741: {
                return this.cpu.ss.getByte((this.cpu.esi << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 2742: {
                return this.cpu.ss.getByte((this.cpu.esi << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 2743: {
                return this.cpu.ss.getByte((this.cpu.esi << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 2744: {
                return this.cpu.ss.getByte((this.cpu.esi << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 2745: {
                return this.cpu.ss.getByte((this.cpu.esi << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 2746: {
                return this.cpu.ss.getByte((this.cpu.edi << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 2747: {
                return this.cpu.ss.getByte((this.cpu.edi << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 2748: {
                return this.cpu.ss.getByte((this.cpu.edi << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 2749: {
                return this.cpu.ss.getByte((this.cpu.edi << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 2750: {
                return this.cpu.ss.getByte((this.cpu.edi << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 2751: {
                return this.cpu.ss.getByte((this.cpu.edi << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 2752: {
                return this.cpu.ss.getByte((this.cpu.edi << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 2753: {
                return this.cpu.ss.getByte((this.cpu.edi << 3) + this.cpu.edi + this.getMicrocode());
            }
        }
        System.err.println("Unimplemented GetByte Operand: " + n);
        throw unimplemented;
    }

    protected final short getShortOperand() {
        int n = this.getMicrocode();
        switch (n) {
            case 8: {
                return (short)this.cpu.eax;
            }
            case 9: {
                return (short)this.cpu.ecx;
            }
            case 10: {
                return (short)this.cpu.edx;
            }
            case 11: {
                return (short)this.cpu.ebx;
            }
            case 12: {
                return (short)this.cpu.esp;
            }
            case 13: {
                return (short)this.cpu.ebp;
            }
            case 14: {
                return (short)this.cpu.esi;
            }
            case 15: {
                return (short)this.cpu.edi;
            }
            case 41: {
                return (short)this.getMicrocode();
            }
            case 42: {
                return (short)this.getMicrocode();
            }
            case 27: {
                return (short)this.cpu.ds.getSelector();
            }
            case 26: {
                return (short)this.cpu.ss.getSelector();
            }
            case 24: {
                return (short)this.cpu.es.getSelector();
            }
            case 25: {
                return (short)this.cpu.cs.getSelector();
            }
            case 28: {
                return (short)this.cpu.fs.getSelector();
            }
            case 29: {
                return (short)this.cpu.gs.getSelector();
            }
        }
        return this.getShortMemoryOperand(n);
    }

    /*
     * Opcode count of 21456 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    private final short getShortMemoryOperand(int n) {
        switch (n) {
            case 182: {
                return this.cpu.es.getWord(this.cpu.ebx + this.cpu.esi & 0xFFFF);
            }
            case 183: {
                return this.cpu.es.getWord(this.cpu.ebx + this.cpu.edi & 0xFFFF);
            }
            case 184: {
                return this.cpu.es.getWord(this.cpu.ebp + this.cpu.esi & 0xFFFF);
            }
            case 185: {
                return this.cpu.es.getWord(this.cpu.ebp + this.cpu.edi & 0xFFFF);
            }
            case 186: {
                return this.cpu.es.getWord(this.cpu.esi & 0xFFFF);
            }
            case 187: {
                return this.cpu.es.getWord(this.cpu.edi & 0xFFFF);
            }
            case 188: {
                return this.cpu.es.getWord(this.getMicrocode() & 0xFFFF);
            }
            case 189: {
                return this.cpu.es.getWord(this.cpu.ebx & 0xFFFF);
            }
            case 190: {
                return this.cpu.es.getWord(this.cpu.ebx + this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 191: {
                return this.cpu.es.getWord(this.cpu.ebx + this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 192: {
                return this.cpu.es.getWord(this.cpu.ebp + this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 193: {
                return this.cpu.es.getWord(this.cpu.ebp + this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 194: {
                return this.cpu.es.getWord(this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 195: {
                return this.cpu.es.getWord(this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 196: {
                return this.cpu.es.getWord(this.cpu.ebp + this.getMicrocode() & 0xFFFF);
            }
            case 197: {
                return this.cpu.es.getWord(this.cpu.ebx + this.getMicrocode() & 0xFFFF);
            }
            case 198: {
                return this.cpu.es.getWord(this.cpu.ebx + this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 199: {
                return this.cpu.es.getWord(this.cpu.ebx + this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 200: {
                return this.cpu.es.getWord(this.cpu.ebp + this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 201: {
                return this.cpu.es.getWord(this.cpu.ebp + this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 202: {
                return this.cpu.es.getWord(this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 203: {
                return this.cpu.es.getWord(this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 204: {
                return this.cpu.es.getWord(this.cpu.ebp + this.getMicrocode() & 0xFFFF);
            }
            case 205: {
                return this.cpu.es.getWord(this.cpu.ebx + this.getMicrocode() & 0xFFFF);
            }
            case 206: {
                return this.cpu.cs.getWord(this.cpu.ebx + this.cpu.esi & 0xFFFF);
            }
            case 207: {
                return this.cpu.cs.getWord(this.cpu.ebx + this.cpu.edi & 0xFFFF);
            }
            case 208: {
                return this.cpu.cs.getWord(this.cpu.ebp + this.cpu.esi & 0xFFFF);
            }
            case 209: {
                return this.cpu.cs.getWord(this.cpu.ebp + this.cpu.edi & 0xFFFF);
            }
            case 210: {
                return this.cpu.cs.getWord(this.cpu.esi & 0xFFFF);
            }
            case 211: {
                return this.cpu.cs.getWord(this.cpu.edi & 0xFFFF);
            }
            case 212: {
                return this.cpu.cs.getWord(this.getMicrocode() & 0xFFFF);
            }
            case 213: {
                return this.cpu.cs.getWord(this.cpu.ebx & 0xFFFF);
            }
            case 214: {
                return this.cpu.cs.getWord(this.cpu.ebx + this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 215: {
                return this.cpu.cs.getWord(this.cpu.ebx + this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 216: {
                return this.cpu.cs.getWord(this.cpu.ebp + this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 217: {
                return this.cpu.cs.getWord(this.cpu.ebp + this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 218: {
                return this.cpu.cs.getWord(this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 219: {
                return this.cpu.cs.getWord(this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 220: {
                return this.cpu.cs.getWord(this.cpu.ebp + this.getMicrocode() & 0xFFFF);
            }
            case 221: {
                return this.cpu.cs.getWord(this.cpu.ebx + this.getMicrocode() & 0xFFFF);
            }
            case 222: {
                return this.cpu.cs.getWord(this.cpu.ebx + this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 223: {
                return this.cpu.cs.getWord(this.cpu.ebx + this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 224: {
                return this.cpu.cs.getWord(this.cpu.ebp + this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 225: {
                return this.cpu.cs.getWord(this.cpu.ebp + this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 226: {
                return this.cpu.cs.getWord(this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 227: {
                return this.cpu.cs.getWord(this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 228: {
                return this.cpu.cs.getWord(this.cpu.ebp + this.getMicrocode() & 0xFFFF);
            }
            case 229: {
                return this.cpu.cs.getWord(this.cpu.ebx + this.getMicrocode() & 0xFFFF);
            }
            case 230: {
                return this.cpu.ss.getWord(this.cpu.ebx + this.cpu.esi & 0xFFFF);
            }
            case 231: {
                return this.cpu.ss.getWord(this.cpu.ebx + this.cpu.edi & 0xFFFF);
            }
            case 232: {
                return this.cpu.ss.getWord(this.cpu.ebp + this.cpu.esi & 0xFFFF);
            }
            case 233: {
                return this.cpu.ss.getWord(this.cpu.ebp + this.cpu.edi & 0xFFFF);
            }
            case 234: {
                return this.cpu.ss.getWord(this.cpu.esi & 0xFFFF);
            }
            case 235: {
                return this.cpu.ss.getWord(this.cpu.edi & 0xFFFF);
            }
            case 236: {
                return this.cpu.ss.getWord(this.getMicrocode() & 0xFFFF);
            }
            case 237: {
                return this.cpu.ss.getWord(this.cpu.ebx & 0xFFFF);
            }
            case 238: {
                return this.cpu.ss.getWord(this.cpu.ebx + this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 239: {
                return this.cpu.ss.getWord(this.cpu.ebx + this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 240: {
                return this.cpu.ss.getWord(this.cpu.ebp + this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 241: {
                return this.cpu.ss.getWord(this.cpu.ebp + this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 242: {
                return this.cpu.ss.getWord(this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 243: {
                return this.cpu.ss.getWord(this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 244: {
                return this.cpu.ss.getWord(this.cpu.ebp + this.getMicrocode() & 0xFFFF);
            }
            case 245: {
                return this.cpu.ss.getWord(this.cpu.ebx + this.getMicrocode() & 0xFFFF);
            }
            case 246: {
                return this.cpu.ss.getWord(this.cpu.ebx + this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 247: {
                return this.cpu.ss.getWord(this.cpu.ebx + this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 248: {
                return this.cpu.ss.getWord(this.cpu.ebp + this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 249: {
                return this.cpu.ss.getWord(this.cpu.ebp + this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 250: {
                return this.cpu.ss.getWord(this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 251: {
                return this.cpu.ss.getWord(this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 252: {
                return this.cpu.ss.getWord(this.cpu.ebp + this.getMicrocode() & 0xFFFF);
            }
            case 253: {
                return this.cpu.ss.getWord(this.cpu.ebx + this.getMicrocode() & 0xFFFF);
            }
            case 254: {
                return this.cpu.ds.getWord(this.cpu.ebx + this.cpu.esi & 0xFFFF);
            }
            case 255: {
                return this.cpu.ds.getWord(this.cpu.ebx + this.cpu.edi & 0xFFFF);
            }
            case 256: {
                return this.cpu.ds.getWord(this.cpu.ebp + this.cpu.esi & 0xFFFF);
            }
            case 257: {
                return this.cpu.ds.getWord(this.cpu.ebp + this.cpu.edi & 0xFFFF);
            }
            case 258: {
                return this.cpu.ds.getWord(this.cpu.esi & 0xFFFF);
            }
            case 259: {
                return this.cpu.ds.getWord(this.cpu.edi & 0xFFFF);
            }
            case 260: {
                return this.cpu.ds.getWord(this.getMicrocode() & 0xFFFF);
            }
            case 261: {
                return this.cpu.ds.getWord(this.cpu.ebx & 0xFFFF);
            }
            case 262: {
                return this.cpu.ds.getWord(this.cpu.ebx + this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 263: {
                return this.cpu.ds.getWord(this.cpu.ebx + this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 264: {
                return this.cpu.ds.getWord(this.cpu.ebp + this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 265: {
                return this.cpu.ds.getWord(this.cpu.ebp + this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 266: {
                return this.cpu.ds.getWord(this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 267: {
                return this.cpu.ds.getWord(this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 268: {
                return this.cpu.ds.getWord(this.cpu.ebp + this.getMicrocode() & 0xFFFF);
            }
            case 269: {
                return this.cpu.ds.getWord(this.cpu.ebx + this.getMicrocode() & 0xFFFF);
            }
            case 270: {
                return this.cpu.ds.getWord(this.cpu.ebx + this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 271: {
                return this.cpu.ds.getWord(this.cpu.ebx + this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 272: {
                return this.cpu.ds.getWord(this.cpu.ebp + this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 273: {
                return this.cpu.ds.getWord(this.cpu.ebp + this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 274: {
                return this.cpu.ds.getWord(this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 275: {
                return this.cpu.ds.getWord(this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 276: {
                return this.cpu.ds.getWord(this.cpu.ebp + this.getMicrocode() & 0xFFFF);
            }
            case 277: {
                return this.cpu.ds.getWord(this.cpu.ebx + this.getMicrocode() & 0xFFFF);
            }
            case 278: {
                return this.cpu.fs.getWord(this.cpu.ebx + this.cpu.esi & 0xFFFF);
            }
            case 279: {
                return this.cpu.fs.getWord(this.cpu.ebx + this.cpu.edi & 0xFFFF);
            }
            case 280: {
                return this.cpu.fs.getWord(this.cpu.ebp + this.cpu.esi & 0xFFFF);
            }
            case 281: {
                return this.cpu.fs.getWord(this.cpu.ebp + this.cpu.edi & 0xFFFF);
            }
            case 282: {
                return this.cpu.fs.getWord(this.cpu.esi & 0xFFFF);
            }
            case 283: {
                return this.cpu.fs.getWord(this.cpu.edi & 0xFFFF);
            }
            case 284: {
                return this.cpu.fs.getWord(this.getMicrocode() & 0xFFFF);
            }
            case 285: {
                return this.cpu.fs.getWord(this.cpu.ebx & 0xFFFF);
            }
            case 286: {
                return this.cpu.fs.getWord(this.cpu.ebx + this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 287: {
                return this.cpu.fs.getWord(this.cpu.ebx + this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 288: {
                return this.cpu.fs.getWord(this.cpu.ebp + this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 289: {
                return this.cpu.fs.getWord(this.cpu.ebp + this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 290: {
                return this.cpu.fs.getWord(this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 291: {
                return this.cpu.fs.getWord(this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 292: {
                return this.cpu.fs.getWord(this.cpu.ebp + this.getMicrocode() & 0xFFFF);
            }
            case 293: {
                return this.cpu.fs.getWord(this.cpu.ebx + this.getMicrocode() & 0xFFFF);
            }
            case 294: {
                return this.cpu.fs.getWord(this.cpu.ebx + this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 295: {
                return this.cpu.fs.getWord(this.cpu.ebx + this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 296: {
                return this.cpu.fs.getWord(this.cpu.ebp + this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 297: {
                return this.cpu.fs.getWord(this.cpu.ebp + this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 298: {
                return this.cpu.fs.getWord(this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 299: {
                return this.cpu.fs.getWord(this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 300: {
                return this.cpu.fs.getWord(this.cpu.ebp + this.getMicrocode() & 0xFFFF);
            }
            case 301: {
                return this.cpu.fs.getWord(this.cpu.ebx + this.getMicrocode() & 0xFFFF);
            }
            case 302: {
                return this.cpu.gs.getWord(this.cpu.ebx + this.cpu.esi & 0xFFFF);
            }
            case 303: {
                return this.cpu.gs.getWord(this.cpu.ebx + this.cpu.edi & 0xFFFF);
            }
            case 304: {
                return this.cpu.gs.getWord(this.cpu.ebp + this.cpu.esi & 0xFFFF);
            }
            case 305: {
                return this.cpu.gs.getWord(this.cpu.ebp + this.cpu.edi & 0xFFFF);
            }
            case 306: {
                return this.cpu.gs.getWord(this.cpu.esi & 0xFFFF);
            }
            case 307: {
                return this.cpu.gs.getWord(this.cpu.edi & 0xFFFF);
            }
            case 308: {
                return this.cpu.gs.getWord(this.getMicrocode() & 0xFFFF);
            }
            case 309: {
                return this.cpu.gs.getWord(this.cpu.ebx & 0xFFFF);
            }
            case 310: {
                return this.cpu.gs.getWord(this.cpu.ebx + this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 311: {
                return this.cpu.gs.getWord(this.cpu.ebx + this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 312: {
                return this.cpu.gs.getWord(this.cpu.ebp + this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 313: {
                return this.cpu.gs.getWord(this.cpu.ebp + this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 314: {
                return this.cpu.gs.getWord(this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 315: {
                return this.cpu.gs.getWord(this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 316: {
                return this.cpu.gs.getWord(this.cpu.ebp + this.getMicrocode() & 0xFFFF);
            }
            case 317: {
                return this.cpu.gs.getWord(this.cpu.ebx + this.getMicrocode() & 0xFFFF);
            }
            case 318: {
                return this.cpu.gs.getWord(this.cpu.ebx + this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 319: {
                return this.cpu.gs.getWord(this.cpu.ebx + this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 320: {
                return this.cpu.gs.getWord(this.cpu.ebp + this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 321: {
                return this.cpu.gs.getWord(this.cpu.ebp + this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 322: {
                return this.cpu.gs.getWord(this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 323: {
                return this.cpu.gs.getWord(this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 324: {
                return this.cpu.gs.getWord(this.cpu.ebp + this.getMicrocode() & 0xFFFF);
            }
            case 325: {
                return this.cpu.gs.getWord(this.cpu.ebx + this.getMicrocode() & 0xFFFF);
            }
            case 56: {
                return this.cpu.es.getWord(this.cpu.eax);
            }
            case 57: {
                return this.cpu.es.getWord(this.cpu.ecx);
            }
            case 58: {
                return this.cpu.es.getWord(this.cpu.edx);
            }
            case 59: {
                return this.cpu.es.getWord(this.cpu.ebx);
            }
            case 60: {
                return this.cpu.es.getWord(this.getMicrocode());
            }
            case 61: {
                return this.cpu.es.getWord(this.cpu.esi);
            }
            case 62: {
                return this.cpu.es.getWord(this.cpu.edi);
            }
            case 63: {
                return this.cpu.es.getWord(this.cpu.eax + this.getMicrocode());
            }
            case 64: {
                return this.cpu.es.getWord(this.cpu.ecx + this.getMicrocode());
            }
            case 65: {
                return this.cpu.es.getWord(this.cpu.edx + this.getMicrocode());
            }
            case 66: {
                return this.cpu.es.getWord(this.cpu.ebx + this.getMicrocode());
            }
            case 67: {
                return this.cpu.es.getWord(this.cpu.ebp + this.getMicrocode());
            }
            case 68: {
                return this.cpu.es.getWord(this.cpu.esi + this.getMicrocode());
            }
            case 69: {
                return this.cpu.es.getWord(this.cpu.edi + this.getMicrocode());
            }
            case 70: {
                return this.cpu.es.getWord(this.cpu.eax + this.getMicrocode());
            }
            case 71: {
                return this.cpu.es.getWord(this.cpu.ecx + this.getMicrocode());
            }
            case 72: {
                return this.cpu.es.getWord(this.cpu.edx + this.getMicrocode());
            }
            case 73: {
                return this.cpu.es.getWord(this.cpu.ebx + this.getMicrocode());
            }
            case 74: {
                return this.cpu.es.getWord(this.cpu.ebp + this.getMicrocode());
            }
            case 75: {
                return this.cpu.es.getWord(this.cpu.esi + this.getMicrocode());
            }
            case 76: {
                return this.cpu.es.getWord(this.cpu.edi + this.getMicrocode());
            }
            case 102: {
                return this.cpu.ss.getWord(this.getMicrocode());
            }
            case 105: {
                return this.cpu.ss.getWord(this.cpu.eax + this.getMicrocode());
            }
            case 106: {
                return this.cpu.ss.getWord(this.cpu.ecx + this.getMicrocode());
            }
            case 107: {
                return this.cpu.ss.getWord(this.cpu.edx + this.getMicrocode());
            }
            case 108: {
                return this.cpu.ss.getWord(this.cpu.ebx + this.getMicrocode());
            }
            case 109: {
                return this.cpu.ss.getWord(this.cpu.ebp + this.getMicrocode());
            }
            case 110: {
                return this.cpu.ss.getWord(this.cpu.esi + this.getMicrocode());
            }
            case 111: {
                return this.cpu.ss.getWord(this.cpu.edi + this.getMicrocode());
            }
            case 112: {
                return this.cpu.ss.getWord(this.cpu.eax + this.getMicrocode());
            }
            case 113: {
                return this.cpu.ss.getWord(this.cpu.ecx + this.getMicrocode());
            }
            case 114: {
                return this.cpu.ss.getWord(this.cpu.edx + this.getMicrocode());
            }
            case 115: {
                return this.cpu.ss.getWord(this.cpu.ebx + this.getMicrocode());
            }
            case 116: {
                return this.cpu.ss.getWord(this.cpu.ebp + this.getMicrocode());
            }
            case 117: {
                return this.cpu.ss.getWord(this.cpu.esi + this.getMicrocode());
            }
            case 118: {
                return this.cpu.ss.getWord(this.cpu.edi + this.getMicrocode());
            }
            case 119: {
                return this.cpu.ds.getWord(this.cpu.eax);
            }
            case 120: {
                return this.cpu.ds.getWord(this.cpu.ecx);
            }
            case 121: {
                return this.cpu.ds.getWord(this.cpu.edx);
            }
            case 122: {
                return this.cpu.ds.getWord(this.cpu.ebx);
            }
            case 123: {
                return this.cpu.ds.getWord(this.getMicrocode());
            }
            case 124: {
                return this.cpu.ds.getWord(this.cpu.esi);
            }
            case 125: {
                return this.cpu.ds.getWord(this.cpu.edi);
            }
            case 126: {
                return this.cpu.ds.getWord(this.cpu.eax + this.getMicrocode());
            }
            case 127: {
                return this.cpu.ds.getWord(this.cpu.ecx + this.getMicrocode());
            }
            case 128: {
                return this.cpu.ds.getWord(this.cpu.edx + this.getMicrocode());
            }
            case 129: {
                return this.cpu.ds.getWord(this.cpu.ebx + this.getMicrocode());
            }
            case 130: {
                return this.cpu.ds.getWord(this.cpu.ebp + this.getMicrocode());
            }
            case 131: {
                return this.cpu.ds.getWord(this.cpu.esi + this.getMicrocode());
            }
            case 132: {
                return this.cpu.ds.getWord(this.cpu.edi + this.getMicrocode());
            }
            case 133: {
                return this.cpu.ds.getWord(this.cpu.eax + this.getMicrocode());
            }
            case 134: {
                return this.cpu.ds.getWord(this.cpu.ecx + this.getMicrocode());
            }
            case 135: {
                return this.cpu.ds.getWord(this.cpu.edx + this.getMicrocode());
            }
            case 136: {
                return this.cpu.ds.getWord(this.cpu.ebx + this.getMicrocode());
            }
            case 137: {
                return this.cpu.ds.getWord(this.cpu.ebp + this.getMicrocode());
            }
            case 138: {
                return this.cpu.ds.getWord(this.cpu.esi + this.getMicrocode());
            }
            case 139: {
                return this.cpu.ds.getWord(this.cpu.edi + this.getMicrocode());
            }
            case 338: {
                return this.cpu.ds.getWord(this.cpu.eax + this.cpu.eax);
            }
            case 339: {
                return this.cpu.ds.getWord(this.cpu.eax + this.cpu.ecx);
            }
            case 340: {
                return this.cpu.ds.getWord(this.cpu.eax + this.cpu.edx);
            }
            case 341: {
                return this.cpu.ds.getWord(this.cpu.eax + this.cpu.ebx);
            }
            case 342: {
                return this.cpu.ds.getWord(this.cpu.eax + this.cpu.esp);
            }
            case 343: {
                return this.cpu.ds.getWord(this.cpu.eax + this.cpu.ebp);
            }
            case 344: {
                return this.cpu.ds.getWord(this.cpu.eax + this.cpu.esi);
            }
            case 345: {
                return this.cpu.ds.getWord(this.cpu.eax + this.cpu.edi);
            }
            case 346: {
                return this.cpu.ds.getWord(this.cpu.ecx + this.cpu.ecx);
            }
            case 347: {
                return this.cpu.ds.getWord(this.cpu.ecx + this.cpu.edx);
            }
            case 348: {
                return this.cpu.ds.getWord(this.cpu.ecx + this.cpu.ebx);
            }
            case 349: {
                return this.cpu.ds.getWord(this.cpu.ecx + this.cpu.esp);
            }
            case 350: {
                return this.cpu.ds.getWord(this.cpu.ecx + this.cpu.ebp);
            }
            case 351: {
                return this.cpu.ds.getWord(this.cpu.ecx + this.cpu.esi);
            }
            case 352: {
                return this.cpu.ds.getWord(this.cpu.ecx + this.cpu.edi);
            }
            case 353: {
                return this.cpu.ds.getWord(this.cpu.edx + this.cpu.edx);
            }
            case 354: {
                return this.cpu.ds.getWord(this.cpu.edx + this.cpu.ebx);
            }
            case 355: {
                return this.cpu.ds.getWord(this.cpu.edx + this.cpu.esp);
            }
            case 356: {
                return this.cpu.ds.getWord(this.cpu.edx + this.cpu.ebp);
            }
            case 357: {
                return this.cpu.ds.getWord(this.cpu.edx + this.cpu.esi);
            }
            case 358: {
                return this.cpu.ds.getWord(this.cpu.edx + this.cpu.edi);
            }
            case 359: {
                return this.cpu.ds.getWord(this.cpu.ebx + this.cpu.ebx);
            }
            case 360: {
                return this.cpu.ds.getWord(this.cpu.ebx + this.cpu.esp);
            }
            case 361: {
                return this.cpu.ds.getWord(this.cpu.ebx + this.cpu.ebp);
            }
            case 362: {
                return this.cpu.ds.getWord(this.cpu.ebx + this.cpu.esi);
            }
            case 363: {
                return this.cpu.ds.getWord(this.cpu.ebx + this.cpu.edi);
            }
            case 364: {
                return this.cpu.ds.getWord(this.cpu.esp);
            }
            case 365: {
                return this.cpu.ds.getWord(this.cpu.ebp + this.cpu.esp);
            }
            case 366: {
                return this.cpu.ds.getWord(this.cpu.ebp + this.cpu.esi);
            }
            case 367: {
                return this.cpu.ds.getWord(this.cpu.ebp + this.cpu.edi);
            }
            case 368: {
                return this.cpu.ds.getWord(this.cpu.esi + this.cpu.esp);
            }
            case 369: {
                return this.cpu.ds.getWord(this.cpu.esi + this.cpu.esi);
            }
            case 370: {
                return this.cpu.ds.getWord(this.cpu.esi + this.cpu.edi);
            }
            case 371: {
                return this.cpu.ds.getWord(this.cpu.edi + this.cpu.esp);
            }
            case 372: {
                return this.cpu.ds.getWord(this.cpu.edi + this.cpu.edi);
            }
            case 373: {
                return this.cpu.ds.getWord((this.cpu.eax << 1) + this.cpu.eax);
            }
            case 374: {
                return this.cpu.ds.getWord((this.cpu.eax << 1) + this.cpu.ecx);
            }
            case 375: {
                return this.cpu.ds.getWord((this.cpu.eax << 1) + this.cpu.edx);
            }
            case 376: {
                return this.cpu.ds.getWord((this.cpu.eax << 1) + this.cpu.ebx);
            }
            case 377: {
                return this.cpu.ds.getWord((this.cpu.eax << 1) + this.cpu.esp);
            }
            case 378: {
                return this.cpu.ds.getWord((this.cpu.eax << 1) + this.getMicrocode());
            }
            case 379: {
                return this.cpu.ds.getWord((this.cpu.eax << 1) + this.cpu.esi);
            }
            case 380: {
                return this.cpu.ds.getWord((this.cpu.eax << 1) + this.cpu.edi);
            }
            case 381: {
                return this.cpu.ds.getWord((this.cpu.ecx << 1) + this.cpu.eax);
            }
            case 382: {
                return this.cpu.ds.getWord((this.cpu.ecx << 1) + this.cpu.ecx);
            }
            case 383: {
                return this.cpu.ds.getWord((this.cpu.ecx << 1) + this.cpu.edx);
            }
            case 384: {
                return this.cpu.ds.getWord((this.cpu.ecx << 1) + this.cpu.ebx);
            }
            case 385: {
                return this.cpu.ds.getWord((this.cpu.ecx << 1) + this.cpu.esp);
            }
            case 386: {
                return this.cpu.ds.getWord((this.cpu.ecx << 1) + this.getMicrocode());
            }
            case 387: {
                return this.cpu.ds.getWord((this.cpu.ecx << 1) + this.cpu.esi);
            }
            case 388: {
                return this.cpu.ds.getWord((this.cpu.ecx << 1) + this.cpu.edi);
            }
            case 389: {
                return this.cpu.ds.getWord((this.cpu.edx << 1) + this.cpu.eax);
            }
            case 390: {
                return this.cpu.ds.getWord((this.cpu.edx << 1) + this.cpu.ecx);
            }
            case 391: {
                return this.cpu.ds.getWord((this.cpu.edx << 1) + this.cpu.edx);
            }
            case 392: {
                return this.cpu.ds.getWord((this.cpu.edx << 1) + this.cpu.ebx);
            }
            case 393: {
                return this.cpu.ds.getWord((this.cpu.edx << 1) + this.cpu.esp);
            }
            case 394: {
                return this.cpu.ds.getWord((this.cpu.edx << 1) + this.getMicrocode());
            }
            case 395: {
                return this.cpu.ds.getWord((this.cpu.edx << 1) + this.cpu.esi);
            }
            case 396: {
                return this.cpu.ds.getWord((this.cpu.edx << 1) + this.cpu.edi);
            }
            case 397: {
                return this.cpu.ds.getWord((this.cpu.ebx << 1) + this.cpu.eax);
            }
            case 398: {
                return this.cpu.ds.getWord((this.cpu.ebx << 1) + this.cpu.ecx);
            }
            case 399: {
                return this.cpu.ds.getWord((this.cpu.ebx << 1) + this.cpu.edx);
            }
            case 400: {
                return this.cpu.ds.getWord((this.cpu.ebx << 1) + this.cpu.ebx);
            }
            case 401: {
                return this.cpu.ds.getWord((this.cpu.ebx << 1) + this.cpu.esp);
            }
            case 402: {
                return this.cpu.ds.getWord((this.cpu.ebx << 1) + this.getMicrocode());
            }
            case 403: {
                return this.cpu.ds.getWord((this.cpu.ebx << 1) + this.cpu.esi);
            }
            case 404: {
                return this.cpu.ds.getWord((this.cpu.ebx << 1) + this.cpu.edi);
            }
            case 405: {
                return this.cpu.ds.getWord((this.cpu.ebp << 1) + this.cpu.eax);
            }
            case 406: {
                return this.cpu.ds.getWord((this.cpu.ebp << 1) + this.cpu.ecx);
            }
            case 407: {
                return this.cpu.ds.getWord((this.cpu.ebp << 1) + this.cpu.edx);
            }
            case 408: {
                return this.cpu.ds.getWord((this.cpu.ebp << 1) + this.cpu.ebx);
            }
            case 409: {
                return this.cpu.ds.getWord((this.cpu.ebp << 1) + this.cpu.esp);
            }
            case 410: {
                return this.cpu.ds.getWord((this.cpu.ebp << 1) + this.getMicrocode());
            }
            case 411: {
                return this.cpu.ds.getWord((this.cpu.ebp << 1) + this.cpu.esi);
            }
            case 412: {
                return this.cpu.ds.getWord((this.cpu.ebp << 1) + this.cpu.edi);
            }
            case 413: {
                return this.cpu.ds.getWord((this.cpu.esi << 1) + this.cpu.eax);
            }
            case 414: {
                return this.cpu.ds.getWord((this.cpu.esi << 1) + this.cpu.ecx);
            }
            case 415: {
                return this.cpu.ds.getWord((this.cpu.esi << 1) + this.cpu.edx);
            }
            case 416: {
                return this.cpu.ds.getWord((this.cpu.esi << 1) + this.cpu.ebx);
            }
            case 417: {
                return this.cpu.ds.getWord((this.cpu.esi << 1) + this.cpu.esp);
            }
            case 418: {
                return this.cpu.ds.getWord((this.cpu.esi << 1) + this.getMicrocode());
            }
            case 419: {
                return this.cpu.ds.getWord((this.cpu.esi << 1) + this.cpu.esi);
            }
            case 420: {
                return this.cpu.ds.getWord((this.cpu.esi << 1) + this.cpu.edi);
            }
            case 421: {
                return this.cpu.ds.getWord((this.cpu.edi << 1) + this.cpu.eax);
            }
            case 422: {
                return this.cpu.ds.getWord((this.cpu.edi << 1) + this.cpu.ecx);
            }
            case 423: {
                return this.cpu.ds.getWord((this.cpu.edi << 1) + this.cpu.edx);
            }
            case 424: {
                return this.cpu.ds.getWord((this.cpu.edi << 1) + this.cpu.ebx);
            }
            case 425: {
                return this.cpu.ds.getWord((this.cpu.edi << 1) + this.cpu.esp);
            }
            case 426: {
                return this.cpu.ds.getWord((this.cpu.edi << 1) + this.getMicrocode());
            }
            case 427: {
                return this.cpu.ds.getWord((this.cpu.edi << 1) + this.cpu.esi);
            }
            case 428: {
                return this.cpu.ds.getWord((this.cpu.edi << 1) + this.cpu.edi);
            }
            case 429: {
                return this.cpu.ds.getWord((this.cpu.eax << 2) + this.cpu.eax);
            }
            case 430: {
                return this.cpu.ds.getWord((this.cpu.eax << 2) + this.cpu.ecx);
            }
            case 431: {
                return this.cpu.ds.getWord((this.cpu.eax << 2) + this.cpu.edx);
            }
            case 432: {
                return this.cpu.ds.getWord((this.cpu.eax << 2) + this.cpu.ebx);
            }
            case 433: {
                return this.cpu.ds.getWord((this.cpu.eax << 2) + this.cpu.esp);
            }
            case 434: {
                return this.cpu.ds.getWord((this.cpu.eax << 2) + this.getMicrocode());
            }
            case 435: {
                return this.cpu.ds.getWord((this.cpu.eax << 2) + this.cpu.esi);
            }
            case 436: {
                return this.cpu.ds.getWord((this.cpu.eax << 2) + this.cpu.edi);
            }
            case 437: {
                return this.cpu.ds.getWord((this.cpu.ecx << 2) + this.cpu.eax);
            }
            case 438: {
                return this.cpu.ds.getWord((this.cpu.ecx << 2) + this.cpu.ecx);
            }
            case 439: {
                return this.cpu.ds.getWord((this.cpu.ecx << 2) + this.cpu.edx);
            }
            case 440: {
                return this.cpu.ds.getWord((this.cpu.ecx << 2) + this.cpu.ebx);
            }
            case 441: {
                return this.cpu.ds.getWord((this.cpu.ecx << 2) + this.cpu.esp);
            }
            case 442: {
                return this.cpu.ds.getWord((this.cpu.ecx << 2) + this.getMicrocode());
            }
            case 443: {
                return this.cpu.ds.getWord((this.cpu.ecx << 2) + this.cpu.esi);
            }
            case 444: {
                return this.cpu.ds.getWord((this.cpu.ecx << 2) + this.cpu.edi);
            }
            case 445: {
                return this.cpu.ds.getWord((this.cpu.edx << 2) + this.cpu.eax);
            }
            case 446: {
                return this.cpu.ds.getWord((this.cpu.edx << 2) + this.cpu.ecx);
            }
            case 447: {
                return this.cpu.ds.getWord((this.cpu.edx << 2) + this.cpu.edx);
            }
            case 448: {
                return this.cpu.ds.getWord((this.cpu.edx << 2) + this.cpu.ebx);
            }
            case 449: {
                return this.cpu.ds.getWord((this.cpu.edx << 2) + this.cpu.esp);
            }
            case 450: {
                return this.cpu.ds.getWord((this.cpu.edx << 2) + this.getMicrocode());
            }
            case 451: {
                return this.cpu.ds.getWord((this.cpu.edx << 2) + this.cpu.esi);
            }
            case 452: {
                return this.cpu.ds.getWord((this.cpu.edx << 2) + this.cpu.edi);
            }
            case 453: {
                return this.cpu.ds.getWord((this.cpu.ebx << 2) + this.cpu.eax);
            }
            case 454: {
                return this.cpu.ds.getWord((this.cpu.ebx << 2) + this.cpu.ecx);
            }
            case 455: {
                return this.cpu.ds.getWord((this.cpu.ebx << 2) + this.cpu.edx);
            }
            case 456: {
                return this.cpu.ds.getWord((this.cpu.ebx << 2) + this.cpu.ebx);
            }
            case 457: {
                return this.cpu.ds.getWord((this.cpu.ebx << 2) + this.cpu.esp);
            }
            case 458: {
                return this.cpu.ds.getWord((this.cpu.ebx << 2) + this.getMicrocode());
            }
            case 459: {
                return this.cpu.ds.getWord((this.cpu.ebx << 2) + this.cpu.esi);
            }
            case 460: {
                return this.cpu.ds.getWord((this.cpu.ebx << 2) + this.cpu.edi);
            }
            case 461: {
                return this.cpu.ds.getWord((this.cpu.ebp << 2) + this.cpu.eax);
            }
            case 462: {
                return this.cpu.ds.getWord((this.cpu.ebp << 2) + this.cpu.ecx);
            }
            case 463: {
                return this.cpu.ds.getWord((this.cpu.ebp << 2) + this.cpu.edx);
            }
            case 464: {
                return this.cpu.ds.getWord((this.cpu.ebp << 2) + this.cpu.ebx);
            }
            case 465: {
                return this.cpu.ds.getWord((this.cpu.ebp << 2) + this.cpu.esp);
            }
            case 466: {
                return this.cpu.ds.getWord((this.cpu.ebp << 2) + this.getMicrocode());
            }
            case 467: {
                return this.cpu.ds.getWord((this.cpu.ebp << 2) + this.cpu.esi);
            }
            case 468: {
                return this.cpu.ds.getWord((this.cpu.ebp << 2) + this.cpu.edi);
            }
            case 469: {
                return this.cpu.ds.getWord((this.cpu.esi << 2) + this.cpu.eax);
            }
            case 470: {
                return this.cpu.ds.getWord((this.cpu.esi << 2) + this.cpu.ecx);
            }
            case 471: {
                return this.cpu.ds.getWord((this.cpu.esi << 2) + this.cpu.edx);
            }
            case 472: {
                return this.cpu.ds.getWord((this.cpu.esi << 2) + this.cpu.ebx);
            }
            case 473: {
                return this.cpu.ds.getWord((this.cpu.esi << 2) + this.cpu.esp);
            }
            case 474: {
                return this.cpu.ds.getWord((this.cpu.esi << 2) + this.getMicrocode());
            }
            case 475: {
                return this.cpu.ds.getWord((this.cpu.esi << 2) + this.cpu.esi);
            }
            case 476: {
                return this.cpu.ds.getWord((this.cpu.esi << 2) + this.cpu.edi);
            }
            case 477: {
                return this.cpu.ds.getWord((this.cpu.edi << 2) + this.cpu.eax);
            }
            case 478: {
                return this.cpu.ds.getWord((this.cpu.edi << 2) + this.cpu.ecx);
            }
            case 479: {
                return this.cpu.ds.getWord((this.cpu.edi << 2) + this.cpu.edx);
            }
            case 480: {
                return this.cpu.ds.getWord((this.cpu.edi << 2) + this.cpu.ebx);
            }
            case 481: {
                return this.cpu.ds.getWord((this.cpu.edi << 2) + this.cpu.esp);
            }
            case 482: {
                return this.cpu.ds.getWord((this.cpu.edi << 2) + this.getMicrocode());
            }
            case 483: {
                return this.cpu.ds.getWord((this.cpu.edi << 2) + this.cpu.esi);
            }
            case 484: {
                return this.cpu.ds.getWord((this.cpu.edi << 2) + this.cpu.edi);
            }
            case 485: {
                return this.cpu.ds.getWord((this.cpu.eax << 3) + this.cpu.eax);
            }
            case 486: {
                return this.cpu.ds.getWord((this.cpu.eax << 3) + this.cpu.ecx);
            }
            case 487: {
                return this.cpu.ds.getWord((this.cpu.eax << 3) + this.cpu.edx);
            }
            case 488: {
                return this.cpu.ds.getWord((this.cpu.eax << 3) + this.cpu.ebx);
            }
            case 489: {
                return this.cpu.ds.getWord((this.cpu.eax << 3) + this.cpu.esp);
            }
            case 490: {
                return this.cpu.ds.getWord((this.cpu.eax << 3) + this.getMicrocode());
            }
            case 491: {
                return this.cpu.ds.getWord((this.cpu.eax << 3) + this.cpu.esi);
            }
            case 492: {
                return this.cpu.ds.getWord((this.cpu.eax << 3) + this.cpu.edi);
            }
            case 493: {
                return this.cpu.ds.getWord((this.cpu.ecx << 3) + this.cpu.eax);
            }
            case 494: {
                return this.cpu.ds.getWord((this.cpu.ecx << 3) + this.cpu.ecx);
            }
            case 495: {
                return this.cpu.ds.getWord((this.cpu.ecx << 3) + this.cpu.edx);
            }
            case 496: {
                return this.cpu.ds.getWord((this.cpu.ecx << 3) + this.cpu.ebx);
            }
            case 497: {
                return this.cpu.ds.getWord((this.cpu.ecx << 3) + this.cpu.esp);
            }
            case 498: {
                return this.cpu.ds.getWord((this.cpu.ecx << 3) + this.getMicrocode());
            }
            case 499: {
                return this.cpu.ds.getWord((this.cpu.ecx << 3) + this.cpu.esi);
            }
            case 500: {
                return this.cpu.ds.getWord((this.cpu.ecx << 3) + this.cpu.edi);
            }
            case 501: {
                return this.cpu.ds.getWord((this.cpu.edx << 3) + this.cpu.eax);
            }
            case 502: {
                return this.cpu.ds.getWord((this.cpu.edx << 3) + this.cpu.ecx);
            }
            case 503: {
                return this.cpu.ds.getWord((this.cpu.edx << 3) + this.cpu.edx);
            }
            case 504: {
                return this.cpu.ds.getWord((this.cpu.edx << 3) + this.cpu.ebx);
            }
            case 505: {
                return this.cpu.ds.getWord((this.cpu.edx << 3) + this.cpu.esp);
            }
            case 506: {
                return this.cpu.ds.getWord((this.cpu.edx << 3) + this.getMicrocode());
            }
            case 507: {
                return this.cpu.ds.getWord((this.cpu.edx << 3) + this.cpu.esi);
            }
            case 508: {
                return this.cpu.ds.getWord((this.cpu.edx << 3) + this.cpu.edi);
            }
            case 509: {
                return this.cpu.ds.getWord((this.cpu.ebx << 3) + this.cpu.eax);
            }
            case 510: {
                return this.cpu.ds.getWord((this.cpu.ebx << 3) + this.cpu.ecx);
            }
            case 511: {
                return this.cpu.ds.getWord((this.cpu.ebx << 3) + this.cpu.edx);
            }
            case 512: {
                return this.cpu.ds.getWord((this.cpu.ebx << 3) + this.cpu.ebx);
            }
            case 513: {
                return this.cpu.ds.getWord((this.cpu.ebx << 3) + this.cpu.esp);
            }
            case 514: {
                return this.cpu.ds.getWord((this.cpu.ebx << 3) + this.getMicrocode());
            }
            case 515: {
                return this.cpu.ds.getWord((this.cpu.ebx << 3) + this.cpu.esi);
            }
            case 516: {
                return this.cpu.ds.getWord((this.cpu.ebx << 3) + this.cpu.edi);
            }
            case 517: {
                return this.cpu.ds.getWord((this.cpu.ebp << 3) + this.cpu.eax);
            }
            case 518: {
                return this.cpu.ds.getWord((this.cpu.ebp << 3) + this.cpu.ecx);
            }
            case 519: {
                return this.cpu.ds.getWord((this.cpu.ebp << 3) + this.cpu.edx);
            }
            case 520: {
                return this.cpu.ds.getWord((this.cpu.ebp << 3) + this.cpu.ebx);
            }
            case 521: {
                return this.cpu.ds.getWord((this.cpu.ebp << 3) + this.cpu.esp);
            }
            case 522: {
                return this.cpu.ds.getWord((this.cpu.ebp << 3) + this.getMicrocode());
            }
            case 523: {
                return this.cpu.ds.getWord((this.cpu.ebp << 3) + this.cpu.esi);
            }
            case 524: {
                return this.cpu.ds.getWord((this.cpu.ebp << 3) + this.cpu.edi);
            }
            case 525: {
                return this.cpu.ds.getWord((this.cpu.esi << 3) + this.cpu.eax);
            }
            case 526: {
                return this.cpu.ds.getWord((this.cpu.esi << 3) + this.cpu.ecx);
            }
            case 527: {
                return this.cpu.ds.getWord((this.cpu.esi << 3) + this.cpu.edx);
            }
            case 528: {
                return this.cpu.ds.getWord((this.cpu.esi << 3) + this.cpu.ebx);
            }
            case 529: {
                return this.cpu.ds.getWord((this.cpu.esi << 3) + this.cpu.esp);
            }
            case 530: {
                return this.cpu.ds.getWord((this.cpu.esi << 3) + this.getMicrocode());
            }
            case 531: {
                return this.cpu.ds.getWord((this.cpu.esi << 3) + this.cpu.esi);
            }
            case 532: {
                return this.cpu.ds.getWord((this.cpu.esi << 3) + this.cpu.edi);
            }
            case 533: {
                return this.cpu.ds.getWord((this.cpu.edi << 3) + this.cpu.eax);
            }
            case 534: {
                return this.cpu.ds.getWord((this.cpu.edi << 3) + this.cpu.ecx);
            }
            case 535: {
                return this.cpu.ds.getWord((this.cpu.edi << 3) + this.cpu.edx);
            }
            case 536: {
                return this.cpu.ds.getWord((this.cpu.edi << 3) + this.cpu.ebx);
            }
            case 537: {
                return this.cpu.ds.getWord((this.cpu.edi << 3) + this.cpu.esp);
            }
            case 538: {
                return this.cpu.ds.getWord((this.cpu.edi << 3) + this.getMicrocode());
            }
            case 539: {
                return this.cpu.ds.getWord((this.cpu.edi << 3) + this.cpu.esi);
            }
            case 540: {
                return this.cpu.ds.getWord((this.cpu.edi << 3) + this.cpu.edi);
            }
            case 541: {
                return this.cpu.ds.getWord(this.cpu.eax + this.cpu.eax + this.getMicrocode());
            }
            case 542: {
                return this.cpu.ds.getWord(this.cpu.eax + this.cpu.ecx + this.getMicrocode());
            }
            case 543: {
                return this.cpu.ds.getWord(this.cpu.eax + this.cpu.edx + this.getMicrocode());
            }
            case 544: {
                return this.cpu.ds.getWord(this.cpu.eax + this.cpu.ebx + this.getMicrocode());
            }
            case 545: {
                return this.cpu.ds.getWord(this.cpu.eax + this.cpu.esp + this.getMicrocode());
            }
            case 546: {
                return this.cpu.ds.getWord(this.cpu.eax + this.cpu.ebp + this.getMicrocode());
            }
            case 547: {
                return this.cpu.ds.getWord(this.cpu.eax + this.cpu.esi + this.getMicrocode());
            }
            case 548: {
                return this.cpu.ds.getWord(this.cpu.eax + this.cpu.edi + this.getMicrocode());
            }
            case 549: {
                return this.cpu.ds.getWord(this.cpu.ecx + this.cpu.ecx + this.getMicrocode());
            }
            case 550: {
                return this.cpu.ds.getWord(this.cpu.ecx + this.cpu.edx + this.getMicrocode());
            }
            case 551: {
                return this.cpu.ds.getWord(this.cpu.ecx + this.cpu.ebx + this.getMicrocode());
            }
            case 552: {
                return this.cpu.ds.getWord(this.cpu.ecx + this.cpu.esp + this.getMicrocode());
            }
            case 553: {
                return this.cpu.ds.getWord(this.cpu.ecx + this.cpu.ebp + this.getMicrocode());
            }
            case 554: {
                return this.cpu.ds.getWord(this.cpu.ecx + this.cpu.esi + this.getMicrocode());
            }
            case 555: {
                return this.cpu.ds.getWord(this.cpu.ecx + this.cpu.edi + this.getMicrocode());
            }
            case 556: {
                return this.cpu.ds.getWord(this.cpu.edx + this.cpu.edx + this.getMicrocode());
            }
            case 557: {
                return this.cpu.ds.getWord(this.cpu.edx + this.cpu.ebx + this.getMicrocode());
            }
            case 558: {
                return this.cpu.ds.getWord(this.cpu.edx + this.cpu.esp + this.getMicrocode());
            }
            case 559: {
                return this.cpu.ds.getWord(this.cpu.edx + this.cpu.ebp + this.getMicrocode());
            }
            case 560: {
                return this.cpu.ds.getWord(this.cpu.edx + this.cpu.esi + this.getMicrocode());
            }
            case 561: {
                return this.cpu.ds.getWord(this.cpu.edx + this.cpu.edi + this.getMicrocode());
            }
            case 562: {
                return this.cpu.ds.getWord(this.cpu.ebx + this.cpu.ebx + this.getMicrocode());
            }
            case 563: {
                return this.cpu.ds.getWord(this.cpu.ebx + this.cpu.esp + this.getMicrocode());
            }
            case 564: {
                return this.cpu.ds.getWord(this.cpu.ebx + this.cpu.ebp + this.getMicrocode());
            }
            case 565: {
                return this.cpu.ds.getWord(this.cpu.ebx + this.cpu.esi + this.getMicrocode());
            }
            case 566: {
                return this.cpu.ds.getWord(this.cpu.ebx + this.cpu.edi + this.getMicrocode());
            }
            case 567: {
                return this.cpu.ds.getWord(this.cpu.esp + this.getMicrocode());
            }
            case 568: {
                return this.cpu.ds.getWord(this.cpu.ebp + this.cpu.esp + this.getMicrocode());
            }
            case 569: {
                return this.cpu.ds.getWord(this.cpu.ebp + this.cpu.ebp + this.getMicrocode());
            }
            case 570: {
                return this.cpu.ds.getWord(this.cpu.ebp + this.cpu.esi + this.getMicrocode());
            }
            case 571: {
                return this.cpu.ds.getWord(this.cpu.ebp + this.cpu.edi + this.getMicrocode());
            }
            case 572: {
                return this.cpu.ds.getWord(this.cpu.esi + this.cpu.esp + this.getMicrocode());
            }
            case 573: {
                return this.cpu.ds.getWord(this.cpu.esi + this.cpu.esi + this.getMicrocode());
            }
            case 574: {
                return this.cpu.ds.getWord(this.cpu.esi + this.cpu.edi + this.getMicrocode());
            }
            case 575: {
                return this.cpu.ds.getWord(this.cpu.edi + this.cpu.esp + this.getMicrocode());
            }
            case 576: {
                return this.cpu.ds.getWord(this.cpu.edi + this.cpu.edi + this.getMicrocode());
            }
            case 577: {
                return this.cpu.ds.getWord((this.cpu.eax << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 578: {
                return this.cpu.ds.getWord((this.cpu.eax << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 579: {
                return this.cpu.ds.getWord((this.cpu.eax << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 580: {
                return this.cpu.ds.getWord((this.cpu.eax << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 581: {
                return this.cpu.ds.getWord((this.cpu.eax << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 582: {
                return this.cpu.ds.getWord((this.cpu.eax << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 583: {
                return this.cpu.ds.getWord((this.cpu.eax << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 584: {
                return this.cpu.ds.getWord((this.cpu.eax << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 585: {
                return this.cpu.ds.getWord((this.cpu.ecx << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 586: {
                return this.cpu.ds.getWord((this.cpu.ecx << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 587: {
                return this.cpu.ds.getWord((this.cpu.ecx << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 588: {
                return this.cpu.ds.getWord((this.cpu.ecx << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 589: {
                return this.cpu.ds.getWord((this.cpu.ecx << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 590: {
                return this.cpu.ds.getWord((this.cpu.ecx << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 591: {
                return this.cpu.ds.getWord((this.cpu.ecx << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 592: {
                return this.cpu.ds.getWord((this.cpu.ecx << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 593: {
                return this.cpu.ds.getWord((this.cpu.edx << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 594: {
                return this.cpu.ds.getWord((this.cpu.edx << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 595: {
                return this.cpu.ds.getWord((this.cpu.edx << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 596: {
                return this.cpu.ds.getWord((this.cpu.edx << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 597: {
                return this.cpu.ds.getWord((this.cpu.edx << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 598: {
                return this.cpu.ds.getWord((this.cpu.edx << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 599: {
                return this.cpu.ds.getWord((this.cpu.edx << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 600: {
                return this.cpu.ds.getWord((this.cpu.edx << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 601: {
                return this.cpu.ds.getWord((this.cpu.ebx << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 602: {
                return this.cpu.ds.getWord((this.cpu.ebx << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 603: {
                return this.cpu.ds.getWord((this.cpu.ebx << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 604: {
                return this.cpu.ds.getWord((this.cpu.ebx << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 605: {
                return this.cpu.ds.getWord((this.cpu.ebx << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 606: {
                return this.cpu.ds.getWord((this.cpu.ebx << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 607: {
                return this.cpu.ds.getWord((this.cpu.ebx << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 608: {
                return this.cpu.ds.getWord((this.cpu.ebx << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 609: {
                return this.cpu.ds.getWord((this.cpu.ebp << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 610: {
                return this.cpu.ds.getWord((this.cpu.ebp << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 611: {
                return this.cpu.ds.getWord((this.cpu.ebp << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 612: {
                return this.cpu.ds.getWord((this.cpu.ebp << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 613: {
                return this.cpu.ds.getWord((this.cpu.ebp << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 614: {
                return this.cpu.ds.getWord((this.cpu.ebp << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 615: {
                return this.cpu.ds.getWord((this.cpu.ebp << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 616: {
                return this.cpu.ds.getWord((this.cpu.ebp << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 617: {
                return this.cpu.ds.getWord((this.cpu.esi << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 618: {
                return this.cpu.ds.getWord((this.cpu.esi << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 619: {
                return this.cpu.ds.getWord((this.cpu.esi << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 620: {
                return this.cpu.ds.getWord((this.cpu.esi << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 621: {
                return this.cpu.ds.getWord((this.cpu.esi << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 622: {
                return this.cpu.ds.getWord((this.cpu.esi << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 623: {
                return this.cpu.ds.getWord((this.cpu.esi << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 624: {
                return this.cpu.ds.getWord((this.cpu.esi << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 625: {
                return this.cpu.ds.getWord((this.cpu.edi << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 626: {
                return this.cpu.ds.getWord((this.cpu.edi << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 627: {
                return this.cpu.ds.getWord((this.cpu.edi << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 628: {
                return this.cpu.ds.getWord((this.cpu.edi << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 629: {
                return this.cpu.ds.getWord((this.cpu.edi << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 630: {
                return this.cpu.ds.getWord((this.cpu.edi << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 631: {
                return this.cpu.ds.getWord((this.cpu.edi << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 632: {
                return this.cpu.ds.getWord((this.cpu.edi << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 633: {
                return this.cpu.ds.getWord((this.cpu.eax << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 634: {
                return this.cpu.ds.getWord((this.cpu.eax << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 635: {
                return this.cpu.ds.getWord((this.cpu.eax << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 636: {
                return this.cpu.ds.getWord((this.cpu.eax << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 637: {
                return this.cpu.ds.getWord((this.cpu.eax << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 638: {
                return this.cpu.ds.getWord((this.cpu.eax << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 639: {
                return this.cpu.ds.getWord((this.cpu.eax << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 640: {
                return this.cpu.ds.getWord((this.cpu.eax << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 641: {
                return this.cpu.ds.getWord((this.cpu.ecx << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 642: {
                return this.cpu.ds.getWord((this.cpu.ecx << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 643: {
                return this.cpu.ds.getWord((this.cpu.ecx << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 644: {
                return this.cpu.ds.getWord((this.cpu.ecx << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 645: {
                return this.cpu.ds.getWord((this.cpu.ecx << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 646: {
                return this.cpu.ds.getWord((this.cpu.ecx << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 647: {
                return this.cpu.ds.getWord((this.cpu.ecx << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 648: {
                return this.cpu.ds.getWord((this.cpu.ecx << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 649: {
                return this.cpu.ds.getWord((this.cpu.edx << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 650: {
                return this.cpu.ds.getWord((this.cpu.edx << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 651: {
                return this.cpu.ds.getWord((this.cpu.edx << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 652: {
                return this.cpu.ds.getWord((this.cpu.edx << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 653: {
                return this.cpu.ds.getWord((this.cpu.edx << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 654: {
                return this.cpu.ds.getWord((this.cpu.edx << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 655: {
                return this.cpu.ds.getWord((this.cpu.edx << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 656: {
                return this.cpu.ds.getWord((this.cpu.edx << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 657: {
                return this.cpu.ds.getWord((this.cpu.ebx << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 658: {
                return this.cpu.ds.getWord((this.cpu.ebx << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 659: {
                return this.cpu.ds.getWord((this.cpu.ebx << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 660: {
                return this.cpu.ds.getWord((this.cpu.ebx << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 661: {
                return this.cpu.ds.getWord((this.cpu.ebx << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 662: {
                return this.cpu.ds.getWord((this.cpu.ebx << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 663: {
                return this.cpu.ds.getWord((this.cpu.ebx << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 664: {
                return this.cpu.ds.getWord((this.cpu.ebx << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 665: {
                return this.cpu.ds.getWord((this.cpu.ebp << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 666: {
                return this.cpu.ds.getWord((this.cpu.ebp << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 667: {
                return this.cpu.ds.getWord((this.cpu.ebp << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 668: {
                return this.cpu.ds.getWord((this.cpu.ebp << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 669: {
                return this.cpu.ds.getWord((this.cpu.ebp << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 670: {
                return this.cpu.ds.getWord((this.cpu.ebp << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 671: {
                return this.cpu.ds.getWord((this.cpu.ebp << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 672: {
                return this.cpu.ds.getWord((this.cpu.ebp << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 673: {
                return this.cpu.ds.getWord((this.cpu.esi << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 674: {
                return this.cpu.ds.getWord((this.cpu.esi << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 675: {
                return this.cpu.ds.getWord((this.cpu.esi << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 676: {
                return this.cpu.ds.getWord((this.cpu.esi << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 677: {
                return this.cpu.ds.getWord((this.cpu.esi << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 678: {
                return this.cpu.ds.getWord((this.cpu.esi << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 679: {
                return this.cpu.ds.getWord((this.cpu.esi << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 680: {
                return this.cpu.ds.getWord((this.cpu.esi << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 681: {
                return this.cpu.ds.getWord((this.cpu.edi << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 682: {
                return this.cpu.ds.getWord((this.cpu.edi << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 683: {
                return this.cpu.ds.getWord((this.cpu.edi << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 684: {
                return this.cpu.ds.getWord((this.cpu.edi << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 685: {
                return this.cpu.ds.getWord((this.cpu.edi << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 686: {
                return this.cpu.ds.getWord((this.cpu.edi << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 687: {
                return this.cpu.ds.getWord((this.cpu.edi << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 688: {
                return this.cpu.ds.getWord((this.cpu.edi << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 689: {
                return this.cpu.ds.getWord((this.cpu.eax << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 690: {
                return this.cpu.ds.getWord((this.cpu.eax << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 691: {
                return this.cpu.ds.getWord((this.cpu.eax << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 692: {
                return this.cpu.ds.getWord((this.cpu.eax << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 693: {
                return this.cpu.ds.getWord((this.cpu.eax << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 694: {
                return this.cpu.ds.getWord((this.cpu.eax << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 695: {
                return this.cpu.ds.getWord((this.cpu.eax << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 696: {
                return this.cpu.ds.getWord((this.cpu.eax << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 697: {
                return this.cpu.ds.getWord((this.cpu.ecx << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 698: {
                return this.cpu.ds.getWord((this.cpu.ecx << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 699: {
                return this.cpu.ds.getWord((this.cpu.ecx << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 700: {
                return this.cpu.ds.getWord((this.cpu.ecx << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 701: {
                return this.cpu.ds.getWord((this.cpu.ecx << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 702: {
                return this.cpu.ds.getWord((this.cpu.ecx << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 703: {
                return this.cpu.ds.getWord((this.cpu.ecx << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 704: {
                return this.cpu.ds.getWord((this.cpu.ecx << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 705: {
                return this.cpu.ds.getWord((this.cpu.edx << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 706: {
                return this.cpu.ds.getWord((this.cpu.edx << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 707: {
                return this.cpu.ds.getWord((this.cpu.edx << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 708: {
                return this.cpu.ds.getWord((this.cpu.edx << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 709: {
                return this.cpu.ds.getWord((this.cpu.edx << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 710: {
                return this.cpu.ds.getWord((this.cpu.edx << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 711: {
                return this.cpu.ds.getWord((this.cpu.edx << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 712: {
                return this.cpu.ds.getWord((this.cpu.edx << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 713: {
                return this.cpu.ds.getWord((this.cpu.ebx << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 714: {
                return this.cpu.ds.getWord((this.cpu.ebx << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 715: {
                return this.cpu.ds.getWord((this.cpu.ebx << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 716: {
                return this.cpu.ds.getWord((this.cpu.ebx << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 717: {
                return this.cpu.ds.getWord((this.cpu.ebx << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 718: {
                return this.cpu.ds.getWord((this.cpu.ebx << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 719: {
                return this.cpu.ds.getWord((this.cpu.ebx << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 720: {
                return this.cpu.ds.getWord((this.cpu.ebx << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 721: {
                return this.cpu.ds.getWord((this.cpu.ebp << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 722: {
                return this.cpu.ds.getWord((this.cpu.ebp << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 723: {
                return this.cpu.ds.getWord((this.cpu.ebp << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 724: {
                return this.cpu.ds.getWord((this.cpu.ebp << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 725: {
                return this.cpu.ds.getWord((this.cpu.ebp << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 726: {
                return this.cpu.ds.getWord((this.cpu.ebp << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 727: {
                return this.cpu.ds.getWord((this.cpu.ebp << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 728: {
                return this.cpu.ds.getWord((this.cpu.ebp << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 729: {
                return this.cpu.ds.getWord((this.cpu.esi << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 730: {
                return this.cpu.ds.getWord((this.cpu.esi << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 731: {
                return this.cpu.ds.getWord((this.cpu.esi << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 732: {
                return this.cpu.ds.getWord((this.cpu.esi << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 733: {
                return this.cpu.ds.getWord((this.cpu.esi << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 734: {
                return this.cpu.ds.getWord((this.cpu.esi << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 735: {
                return this.cpu.ds.getWord((this.cpu.esi << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 736: {
                return this.cpu.ds.getWord((this.cpu.esi << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 737: {
                return this.cpu.ds.getWord((this.cpu.edi << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 738: {
                return this.cpu.ds.getWord((this.cpu.edi << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 739: {
                return this.cpu.ds.getWord((this.cpu.edi << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 740: {
                return this.cpu.ds.getWord((this.cpu.edi << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 741: {
                return this.cpu.ds.getWord((this.cpu.edi << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 742: {
                return this.cpu.ds.getWord((this.cpu.edi << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 743: {
                return this.cpu.ds.getWord((this.cpu.edi << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 744: {
                return this.cpu.ds.getWord((this.cpu.edi << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 745: {
                return this.cpu.ds.getWord(this.cpu.eax + this.cpu.ecx + this.getMicrocode());
            }
            case 746: {
                return this.cpu.ds.getWord(this.cpu.eax + this.cpu.edx + this.getMicrocode());
            }
            case 747: {
                return this.cpu.ds.getWord(this.cpu.eax + this.cpu.ebx + this.getMicrocode());
            }
            case 748: {
                return this.cpu.ds.getWord(this.cpu.eax + this.cpu.esp + this.getMicrocode());
            }
            case 749: {
                return this.cpu.ds.getWord(this.cpu.eax + this.cpu.ebp + this.getMicrocode());
            }
            case 750: {
                return this.cpu.ds.getWord(this.cpu.eax + this.cpu.esi + this.getMicrocode());
            }
            case 751: {
                return this.cpu.ds.getWord(this.cpu.eax + this.cpu.edi + this.getMicrocode());
            }
            case 752: {
                return this.cpu.ds.getWord(this.cpu.ecx + this.cpu.edx + this.getMicrocode());
            }
            case 753: {
                return this.cpu.ds.getWord(this.cpu.ecx + this.cpu.ebx + this.getMicrocode());
            }
            case 754: {
                return this.cpu.ds.getWord(this.cpu.ecx + this.cpu.esp + this.getMicrocode());
            }
            case 755: {
                return this.cpu.ds.getWord(this.cpu.ecx + this.cpu.ebp + this.getMicrocode());
            }
            case 756: {
                return this.cpu.ds.getWord(this.cpu.ecx + this.cpu.esi + this.getMicrocode());
            }
            case 757: {
                return this.cpu.ds.getWord(this.cpu.ecx + this.cpu.edi + this.getMicrocode());
            }
            case 758: {
                return this.cpu.ds.getWord(this.cpu.edx + this.cpu.ebx + this.getMicrocode());
            }
            case 759: {
                return this.cpu.ds.getWord(this.cpu.edx + this.cpu.esp + this.getMicrocode());
            }
            case 760: {
                return this.cpu.ds.getWord(this.cpu.edx + this.cpu.ebp + this.getMicrocode());
            }
            case 761: {
                return this.cpu.ds.getWord(this.cpu.edx + this.cpu.esi + this.getMicrocode());
            }
            case 762: {
                return this.cpu.ds.getWord(this.cpu.edx + this.cpu.edi + this.getMicrocode());
            }
            case 763: {
                return this.cpu.ds.getWord(this.cpu.ebx + this.cpu.esp + this.getMicrocode());
            }
            case 764: {
                return this.cpu.ds.getWord(this.cpu.ebx + this.cpu.ebp + this.getMicrocode());
            }
            case 765: {
                return this.cpu.ds.getWord(this.cpu.ebx + this.cpu.esi + this.getMicrocode());
            }
            case 766: {
                return this.cpu.ds.getWord(this.cpu.ebx + this.cpu.edi + this.getMicrocode());
            }
            case 767: {
                return this.cpu.ds.getWord(this.cpu.esp + this.getMicrocode());
            }
            case 768: {
                return this.cpu.ds.getWord(this.cpu.ebp + this.cpu.esp + this.getMicrocode());
            }
            case 769: {
                return this.cpu.ds.getWord(this.cpu.ebp + this.cpu.esi + this.getMicrocode());
            }
            case 770: {
                return this.cpu.ds.getWord(this.cpu.ebp + this.cpu.edi + this.getMicrocode());
            }
            case 771: {
                return this.cpu.ds.getWord(this.cpu.esi + this.cpu.esp + this.getMicrocode());
            }
            case 772: {
                return this.cpu.ds.getWord(this.cpu.esi + this.cpu.edi + this.getMicrocode());
            }
            case 773: {
                return this.cpu.ds.getWord(this.cpu.edi + this.cpu.esp + this.getMicrocode());
            }
            case 774: {
                return this.cpu.ds.getWord((this.cpu.eax << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 775: {
                return this.cpu.ds.getWord((this.cpu.eax << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 776: {
                return this.cpu.ds.getWord((this.cpu.eax << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 777: {
                return this.cpu.ds.getWord((this.cpu.eax << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 778: {
                return this.cpu.ds.getWord((this.cpu.eax << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 779: {
                return this.cpu.ds.getWord((this.cpu.eax << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 780: {
                return this.cpu.ds.getWord((this.cpu.eax << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 781: {
                return this.cpu.ds.getWord((this.cpu.eax << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 782: {
                return this.cpu.ds.getWord((this.cpu.ecx << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 783: {
                return this.cpu.ds.getWord((this.cpu.ecx << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 784: {
                return this.cpu.ds.getWord((this.cpu.ecx << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 785: {
                return this.cpu.ds.getWord((this.cpu.ecx << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 786: {
                return this.cpu.ds.getWord((this.cpu.ecx << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 787: {
                return this.cpu.ds.getWord((this.cpu.ecx << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 788: {
                return this.cpu.ds.getWord((this.cpu.ecx << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 789: {
                return this.cpu.ds.getWord((this.cpu.ecx << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 790: {
                return this.cpu.ds.getWord((this.cpu.edx << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 791: {
                return this.cpu.ds.getWord((this.cpu.edx << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 792: {
                return this.cpu.ds.getWord((this.cpu.edx << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 793: {
                return this.cpu.ds.getWord((this.cpu.edx << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 794: {
                return this.cpu.ds.getWord((this.cpu.edx << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 795: {
                return this.cpu.ds.getWord((this.cpu.edx << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 796: {
                return this.cpu.ds.getWord((this.cpu.edx << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 797: {
                return this.cpu.ds.getWord((this.cpu.edx << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 798: {
                return this.cpu.ds.getWord((this.cpu.ebx << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 799: {
                return this.cpu.ds.getWord((this.cpu.ebx << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 800: {
                return this.cpu.ds.getWord((this.cpu.ebx << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 801: {
                return this.cpu.ds.getWord((this.cpu.ebx << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 802: {
                return this.cpu.ds.getWord((this.cpu.ebx << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 803: {
                return this.cpu.ds.getWord((this.cpu.ebx << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 804: {
                return this.cpu.ds.getWord((this.cpu.ebx << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 805: {
                return this.cpu.ds.getWord((this.cpu.ebx << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 806: {
                return this.cpu.ds.getWord((this.cpu.ebp << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 807: {
                return this.cpu.ds.getWord((this.cpu.ebp << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 808: {
                return this.cpu.ds.getWord((this.cpu.ebp << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 809: {
                return this.cpu.ds.getWord((this.cpu.ebp << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 810: {
                return this.cpu.ds.getWord((this.cpu.ebp << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 811: {
                return this.cpu.ds.getWord((this.cpu.ebp << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 812: {
                return this.cpu.ds.getWord((this.cpu.ebp << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 813: {
                return this.cpu.ds.getWord((this.cpu.ebp << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 814: {
                return this.cpu.ds.getWord((this.cpu.esi << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 815: {
                return this.cpu.ds.getWord((this.cpu.esi << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 816: {
                return this.cpu.ds.getWord((this.cpu.esi << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 817: {
                return this.cpu.ds.getWord((this.cpu.esi << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 818: {
                return this.cpu.ds.getWord((this.cpu.esi << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 819: {
                return this.cpu.ds.getWord((this.cpu.esi << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 820: {
                return this.cpu.ds.getWord((this.cpu.esi << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 821: {
                return this.cpu.ds.getWord((this.cpu.esi << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 822: {
                return this.cpu.ds.getWord((this.cpu.edi << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 823: {
                return this.cpu.ds.getWord((this.cpu.edi << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 824: {
                return this.cpu.ds.getWord((this.cpu.edi << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 825: {
                return this.cpu.ds.getWord((this.cpu.edi << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 826: {
                return this.cpu.ds.getWord((this.cpu.edi << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 827: {
                return this.cpu.ds.getWord((this.cpu.edi << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 828: {
                return this.cpu.ds.getWord((this.cpu.edi << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 829: {
                return this.cpu.ds.getWord((this.cpu.edi << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 830: {
                return this.cpu.ds.getWord((this.cpu.eax << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 831: {
                return this.cpu.ds.getWord((this.cpu.eax << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 832: {
                return this.cpu.ds.getWord((this.cpu.eax << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 833: {
                return this.cpu.ds.getWord((this.cpu.eax << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 834: {
                return this.cpu.ds.getWord((this.cpu.eax << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 835: {
                return this.cpu.ds.getWord((this.cpu.eax << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 836: {
                return this.cpu.ds.getWord((this.cpu.eax << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 837: {
                return this.cpu.ds.getWord((this.cpu.eax << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 838: {
                return this.cpu.ds.getWord((this.cpu.ecx << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 839: {
                return this.cpu.ds.getWord((this.cpu.ecx << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 840: {
                return this.cpu.ds.getWord((this.cpu.ecx << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 841: {
                return this.cpu.ds.getWord((this.cpu.ecx << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 842: {
                return this.cpu.ds.getWord((this.cpu.ecx << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 843: {
                return this.cpu.ds.getWord((this.cpu.ecx << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 844: {
                return this.cpu.ds.getWord((this.cpu.ecx << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 845: {
                return this.cpu.ds.getWord((this.cpu.ecx << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 846: {
                return this.cpu.ds.getWord((this.cpu.edx << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 847: {
                return this.cpu.ds.getWord((this.cpu.edx << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 848: {
                return this.cpu.ds.getWord((this.cpu.edx << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 849: {
                return this.cpu.ds.getWord((this.cpu.edx << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 850: {
                return this.cpu.ds.getWord((this.cpu.edx << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 851: {
                return this.cpu.ds.getWord((this.cpu.edx << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 852: {
                return this.cpu.ds.getWord((this.cpu.edx << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 853: {
                return this.cpu.ds.getWord((this.cpu.edx << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 854: {
                return this.cpu.ds.getWord((this.cpu.ebx << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 855: {
                return this.cpu.ds.getWord((this.cpu.ebx << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 856: {
                return this.cpu.ds.getWord((this.cpu.ebx << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 857: {
                return this.cpu.ds.getWord((this.cpu.ebx << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 858: {
                return this.cpu.ds.getWord((this.cpu.ebx << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 859: {
                return this.cpu.ds.getWord((this.cpu.ebx << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 860: {
                return this.cpu.ds.getWord((this.cpu.ebx << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 861: {
                return this.cpu.ds.getWord((this.cpu.ebx << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 862: {
                return this.cpu.ds.getWord((this.cpu.ebp << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 863: {
                return this.cpu.ds.getWord((this.cpu.ebp << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 864: {
                return this.cpu.ds.getWord((this.cpu.ebp << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 865: {
                return this.cpu.ds.getWord((this.cpu.ebp << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 866: {
                return this.cpu.ds.getWord((this.cpu.ebp << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 867: {
                return this.cpu.ds.getWord((this.cpu.ebp << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 868: {
                return this.cpu.ds.getWord((this.cpu.ebp << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 869: {
                return this.cpu.ds.getWord((this.cpu.ebp << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 870: {
                return this.cpu.ds.getWord((this.cpu.esi << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 871: {
                return this.cpu.ds.getWord((this.cpu.esi << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 872: {
                return this.cpu.ds.getWord((this.cpu.esi << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 873: {
                return this.cpu.ds.getWord((this.cpu.esi << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 874: {
                return this.cpu.ds.getWord((this.cpu.esi << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 875: {
                return this.cpu.ds.getWord((this.cpu.esi << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 876: {
                return this.cpu.ds.getWord((this.cpu.esi << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 877: {
                return this.cpu.ds.getWord((this.cpu.esi << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 878: {
                return this.cpu.ds.getWord((this.cpu.edi << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 879: {
                return this.cpu.ds.getWord((this.cpu.edi << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 880: {
                return this.cpu.ds.getWord((this.cpu.edi << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 881: {
                return this.cpu.ds.getWord((this.cpu.edi << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 882: {
                return this.cpu.ds.getWord((this.cpu.edi << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 883: {
                return this.cpu.ds.getWord((this.cpu.edi << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 884: {
                return this.cpu.ds.getWord((this.cpu.edi << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 885: {
                return this.cpu.ds.getWord((this.cpu.edi << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 886: {
                return this.cpu.ds.getWord((this.cpu.eax << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 887: {
                return this.cpu.ds.getWord((this.cpu.eax << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 888: {
                return this.cpu.ds.getWord((this.cpu.eax << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 889: {
                return this.cpu.ds.getWord((this.cpu.eax << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 890: {
                return this.cpu.ds.getWord((this.cpu.eax << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 891: {
                return this.cpu.ds.getWord((this.cpu.eax << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 892: {
                return this.cpu.ds.getWord((this.cpu.eax << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 893: {
                return this.cpu.ds.getWord((this.cpu.eax << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 894: {
                return this.cpu.ds.getWord((this.cpu.ecx << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 895: {
                return this.cpu.ds.getWord((this.cpu.ecx << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 896: {
                return this.cpu.ds.getWord((this.cpu.ecx << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 897: {
                return this.cpu.ds.getWord((this.cpu.ecx << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 898: {
                return this.cpu.ds.getWord((this.cpu.ecx << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 899: {
                return this.cpu.ds.getWord((this.cpu.ecx << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 900: {
                return this.cpu.ds.getWord((this.cpu.ecx << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 901: {
                return this.cpu.ds.getWord((this.cpu.ecx << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 902: {
                return this.cpu.ds.getWord((this.cpu.edx << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 903: {
                return this.cpu.ds.getWord((this.cpu.edx << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 904: {
                return this.cpu.ds.getWord((this.cpu.edx << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 905: {
                return this.cpu.ds.getWord((this.cpu.edx << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 906: {
                return this.cpu.ds.getWord((this.cpu.edx << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 907: {
                return this.cpu.ds.getWord((this.cpu.edx << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 908: {
                return this.cpu.ds.getWord((this.cpu.edx << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 909: {
                return this.cpu.ds.getWord((this.cpu.edx << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 910: {
                return this.cpu.ds.getWord((this.cpu.ebx << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 911: {
                return this.cpu.ds.getWord((this.cpu.ebx << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 912: {
                return this.cpu.ds.getWord((this.cpu.ebx << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 913: {
                return this.cpu.ds.getWord((this.cpu.ebx << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 914: {
                return this.cpu.ds.getWord((this.cpu.ebx << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 915: {
                return this.cpu.ds.getWord((this.cpu.ebx << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 916: {
                return this.cpu.ds.getWord((this.cpu.ebx << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 917: {
                return this.cpu.ds.getWord((this.cpu.ebx << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 918: {
                return this.cpu.ds.getWord((this.cpu.ebp << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 919: {
                return this.cpu.ds.getWord((this.cpu.ebp << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 920: {
                return this.cpu.ds.getWord((this.cpu.ebp << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 921: {
                return this.cpu.ds.getWord((this.cpu.ebp << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 922: {
                return this.cpu.ds.getWord((this.cpu.ebp << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 923: {
                return this.cpu.ds.getWord((this.cpu.ebp << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 924: {
                return this.cpu.ds.getWord((this.cpu.ebp << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 925: {
                return this.cpu.ds.getWord((this.cpu.ebp << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 926: {
                return this.cpu.ds.getWord((this.cpu.esi << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 927: {
                return this.cpu.ds.getWord((this.cpu.esi << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 928: {
                return this.cpu.ds.getWord((this.cpu.esi << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 929: {
                return this.cpu.ds.getWord((this.cpu.esi << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 930: {
                return this.cpu.ds.getWord((this.cpu.esi << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 931: {
                return this.cpu.ds.getWord((this.cpu.esi << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 932: {
                return this.cpu.ds.getWord((this.cpu.esi << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 933: {
                return this.cpu.ds.getWord((this.cpu.esi << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 934: {
                return this.cpu.ds.getWord((this.cpu.edi << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 935: {
                return this.cpu.ds.getWord((this.cpu.edi << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 936: {
                return this.cpu.ds.getWord((this.cpu.edi << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 937: {
                return this.cpu.ds.getWord((this.cpu.edi << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 938: {
                return this.cpu.ds.getWord((this.cpu.edi << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 939: {
                return this.cpu.ds.getWord((this.cpu.edi << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 940: {
                return this.cpu.ds.getWord((this.cpu.edi << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 941: {
                return this.cpu.ds.getWord((this.cpu.edi << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 2150: {
                return this.cpu.ss.getWord(this.cpu.eax + this.cpu.eax);
            }
            case 2151: {
                return this.cpu.ss.getWord(this.cpu.eax + this.cpu.ecx);
            }
            case 2152: {
                return this.cpu.ss.getWord(this.cpu.eax + this.cpu.edx);
            }
            case 2153: {
                return this.cpu.ss.getWord(this.cpu.eax + this.cpu.ebx);
            }
            case 2154: {
                return this.cpu.ss.getWord(this.cpu.eax + this.cpu.esp);
            }
            case 2155: {
                return this.cpu.ss.getWord(this.cpu.eax + this.cpu.ebp);
            }
            case 2156: {
                return this.cpu.ss.getWord(this.cpu.eax + this.cpu.esi);
            }
            case 2157: {
                return this.cpu.ss.getWord(this.cpu.eax + this.cpu.edi);
            }
            case 2158: {
                return this.cpu.ss.getWord(this.cpu.ecx + this.cpu.ecx);
            }
            case 2159: {
                return this.cpu.ss.getWord(this.cpu.ecx + this.cpu.edx);
            }
            case 2160: {
                return this.cpu.ss.getWord(this.cpu.ecx + this.cpu.ebx);
            }
            case 2161: {
                return this.cpu.ss.getWord(this.cpu.ecx + this.cpu.esp);
            }
            case 2162: {
                return this.cpu.ss.getWord(this.cpu.ecx + this.cpu.ebp);
            }
            case 2163: {
                return this.cpu.ss.getWord(this.cpu.ecx + this.cpu.esi);
            }
            case 2164: {
                return this.cpu.ss.getWord(this.cpu.ecx + this.cpu.edi);
            }
            case 2165: {
                return this.cpu.ss.getWord(this.cpu.edx + this.cpu.edx);
            }
            case 2166: {
                return this.cpu.ss.getWord(this.cpu.edx + this.cpu.ebx);
            }
            case 2167: {
                return this.cpu.ss.getWord(this.cpu.edx + this.cpu.esp);
            }
            case 2168: {
                return this.cpu.ss.getWord(this.cpu.edx + this.cpu.ebp);
            }
            case 2169: {
                return this.cpu.ss.getWord(this.cpu.edx + this.cpu.esi);
            }
            case 2170: {
                return this.cpu.ss.getWord(this.cpu.edx + this.cpu.edi);
            }
            case 2171: {
                return this.cpu.ss.getWord(this.cpu.ebx + this.cpu.ebx);
            }
            case 2172: {
                return this.cpu.ss.getWord(this.cpu.ebx + this.cpu.esp);
            }
            case 2173: {
                return this.cpu.ss.getWord(this.cpu.ebx + this.cpu.ebp);
            }
            case 2174: {
                return this.cpu.ss.getWord(this.cpu.ebx + this.cpu.esi);
            }
            case 2175: {
                return this.cpu.ss.getWord(this.cpu.ebx + this.cpu.edi);
            }
            case 2176: {
                return this.cpu.ss.getWord(this.cpu.esp);
            }
            case 2177: {
                return this.cpu.ss.getWord(this.cpu.ebp + this.cpu.esp);
            }
            case 2178: {
                return this.cpu.ss.getWord(this.cpu.ebp + this.cpu.esi);
            }
            case 2179: {
                return this.cpu.ss.getWord(this.cpu.ebp + this.cpu.edi);
            }
            case 2180: {
                return this.cpu.ss.getWord(this.cpu.esi + this.cpu.esp);
            }
            case 2181: {
                return this.cpu.ss.getWord(this.cpu.esi + this.cpu.esi);
            }
            case 2182: {
                return this.cpu.ss.getWord(this.cpu.esi + this.cpu.edi);
            }
            case 2183: {
                return this.cpu.ss.getWord(this.cpu.edi + this.cpu.esp);
            }
            case 2184: {
                return this.cpu.ss.getWord(this.cpu.edi + this.cpu.edi);
            }
            case 2185: {
                return this.cpu.ss.getWord((this.cpu.eax << 1) + this.cpu.eax);
            }
            case 2186: {
                return this.cpu.ss.getWord((this.cpu.eax << 1) + this.cpu.ecx);
            }
            case 2187: {
                return this.cpu.ss.getWord((this.cpu.eax << 1) + this.cpu.edx);
            }
            case 2188: {
                return this.cpu.ss.getWord((this.cpu.eax << 1) + this.cpu.ebx);
            }
            case 2189: {
                return this.cpu.ss.getWord((this.cpu.eax << 1) + this.cpu.esp);
            }
            case 2190: {
                return this.cpu.ss.getWord((this.cpu.eax << 1) + this.getMicrocode());
            }
            case 2191: {
                return this.cpu.ss.getWord((this.cpu.eax << 1) + this.cpu.esi);
            }
            case 2192: {
                return this.cpu.ss.getWord((this.cpu.eax << 1) + this.cpu.edi);
            }
            case 2193: {
                return this.cpu.ss.getWord((this.cpu.ecx << 1) + this.cpu.eax);
            }
            case 2194: {
                return this.cpu.ss.getWord((this.cpu.ecx << 1) + this.cpu.ecx);
            }
            case 2195: {
                return this.cpu.ss.getWord((this.cpu.ecx << 1) + this.cpu.edx);
            }
            case 2196: {
                return this.cpu.ss.getWord((this.cpu.ecx << 1) + this.cpu.ebx);
            }
            case 2197: {
                return this.cpu.ss.getWord((this.cpu.ecx << 1) + this.cpu.esp);
            }
            case 2198: {
                return this.cpu.ss.getWord((this.cpu.ecx << 1) + this.getMicrocode());
            }
            case 2199: {
                return this.cpu.ss.getWord((this.cpu.ecx << 1) + this.cpu.esi);
            }
            case 2200: {
                return this.cpu.ss.getWord((this.cpu.ecx << 1) + this.cpu.edi);
            }
            case 2201: {
                return this.cpu.ss.getWord((this.cpu.edx << 1) + this.cpu.eax);
            }
            case 2202: {
                return this.cpu.ss.getWord((this.cpu.edx << 1) + this.cpu.ecx);
            }
            case 2203: {
                return this.cpu.ss.getWord((this.cpu.edx << 1) + this.cpu.edx);
            }
            case 2204: {
                return this.cpu.ss.getWord((this.cpu.edx << 1) + this.cpu.ebx);
            }
            case 2205: {
                return this.cpu.ss.getWord((this.cpu.edx << 1) + this.cpu.esp);
            }
            case 2206: {
                return this.cpu.ss.getWord((this.cpu.edx << 1) + this.getMicrocode());
            }
            case 2207: {
                return this.cpu.ss.getWord((this.cpu.edx << 1) + this.cpu.esi);
            }
            case 2208: {
                return this.cpu.ss.getWord((this.cpu.edx << 1) + this.cpu.edi);
            }
            case 2209: {
                return this.cpu.ss.getWord((this.cpu.ebx << 1) + this.cpu.eax);
            }
            case 2210: {
                return this.cpu.ss.getWord((this.cpu.ebx << 1) + this.cpu.ecx);
            }
            case 2211: {
                return this.cpu.ss.getWord((this.cpu.ebx << 1) + this.cpu.edx);
            }
            case 2212: {
                return this.cpu.ss.getWord((this.cpu.ebx << 1) + this.cpu.ebx);
            }
            case 2213: {
                return this.cpu.ss.getWord((this.cpu.ebx << 1) + this.cpu.esp);
            }
            case 2214: {
                return this.cpu.ss.getWord((this.cpu.ebx << 1) + this.getMicrocode());
            }
            case 2215: {
                return this.cpu.ss.getWord((this.cpu.ebx << 1) + this.cpu.esi);
            }
            case 2216: {
                return this.cpu.ss.getWord((this.cpu.ebx << 1) + this.cpu.edi);
            }
            case 2217: {
                return this.cpu.ss.getWord((this.cpu.ebp << 1) + this.cpu.eax);
            }
            case 2218: {
                return this.cpu.ss.getWord((this.cpu.ebp << 1) + this.cpu.ecx);
            }
            case 2219: {
                return this.cpu.ss.getWord((this.cpu.ebp << 1) + this.cpu.edx);
            }
            case 2220: {
                return this.cpu.ss.getWord((this.cpu.ebp << 1) + this.cpu.ebx);
            }
            case 2221: {
                return this.cpu.ss.getWord((this.cpu.ebp << 1) + this.cpu.esp);
            }
            case 2222: {
                return this.cpu.ss.getWord((this.cpu.ebp << 1) + this.getMicrocode());
            }
            case 2223: {
                return this.cpu.ss.getWord((this.cpu.ebp << 1) + this.cpu.esi);
            }
            case 2224: {
                return this.cpu.ss.getWord((this.cpu.ebp << 1) + this.cpu.edi);
            }
            case 2225: {
                return this.cpu.ss.getWord((this.cpu.esi << 1) + this.cpu.eax);
            }
            case 2226: {
                return this.cpu.ss.getWord((this.cpu.esi << 1) + this.cpu.ecx);
            }
            case 2227: {
                return this.cpu.ss.getWord((this.cpu.esi << 1) + this.cpu.edx);
            }
            case 2228: {
                return this.cpu.ss.getWord((this.cpu.esi << 1) + this.cpu.ebx);
            }
            case 2229: {
                return this.cpu.ss.getWord((this.cpu.esi << 1) + this.cpu.esp);
            }
            case 2230: {
                return this.cpu.ss.getWord((this.cpu.esi << 1) + this.getMicrocode());
            }
            case 2231: {
                return this.cpu.ss.getWord((this.cpu.esi << 1) + this.cpu.esi);
            }
            case 2232: {
                return this.cpu.ss.getWord((this.cpu.esi << 1) + this.cpu.edi);
            }
            case 2233: {
                return this.cpu.ss.getWord((this.cpu.edi << 1) + this.cpu.eax);
            }
            case 2234: {
                return this.cpu.ss.getWord((this.cpu.edi << 1) + this.cpu.ecx);
            }
            case 2235: {
                return this.cpu.ss.getWord((this.cpu.edi << 1) + this.cpu.edx);
            }
            case 2236: {
                return this.cpu.ss.getWord((this.cpu.edi << 1) + this.cpu.ebx);
            }
            case 2237: {
                return this.cpu.ss.getWord((this.cpu.edi << 1) + this.cpu.esp);
            }
            case 2238: {
                return this.cpu.ss.getWord((this.cpu.edi << 1) + this.getMicrocode());
            }
            case 2239: {
                return this.cpu.ss.getWord((this.cpu.edi << 1) + this.cpu.esi);
            }
            case 2240: {
                return this.cpu.ss.getWord((this.cpu.edi << 1) + this.cpu.edi);
            }
            case 2241: {
                return this.cpu.ss.getWord((this.cpu.eax << 2) + this.cpu.eax);
            }
            case 2242: {
                return this.cpu.ss.getWord((this.cpu.eax << 2) + this.cpu.ecx);
            }
            case 2243: {
                return this.cpu.ss.getWord((this.cpu.eax << 2) + this.cpu.edx);
            }
            case 2244: {
                return this.cpu.ss.getWord((this.cpu.eax << 2) + this.cpu.ebx);
            }
            case 2245: {
                return this.cpu.ss.getWord((this.cpu.eax << 2) + this.cpu.esp);
            }
            case 2246: {
                return this.cpu.ss.getWord((this.cpu.eax << 2) + this.getMicrocode());
            }
            case 2247: {
                return this.cpu.ss.getWord((this.cpu.eax << 2) + this.cpu.esi);
            }
            case 2248: {
                return this.cpu.ss.getWord((this.cpu.eax << 2) + this.cpu.edi);
            }
            case 2249: {
                return this.cpu.ss.getWord((this.cpu.ecx << 2) + this.cpu.eax);
            }
            case 2250: {
                return this.cpu.ss.getWord((this.cpu.ecx << 2) + this.cpu.ecx);
            }
            case 2251: {
                return this.cpu.ss.getWord((this.cpu.ecx << 2) + this.cpu.edx);
            }
            case 2252: {
                return this.cpu.ss.getWord((this.cpu.ecx << 2) + this.cpu.ebx);
            }
            case 2253: {
                return this.cpu.ss.getWord((this.cpu.ecx << 2) + this.cpu.esp);
            }
            case 2254: {
                return this.cpu.ss.getWord((this.cpu.ecx << 2) + this.getMicrocode());
            }
            case 2255: {
                return this.cpu.ss.getWord((this.cpu.ecx << 2) + this.cpu.esi);
            }
            case 2256: {
                return this.cpu.ss.getWord((this.cpu.ecx << 2) + this.cpu.edi);
            }
            case 2257: {
                return this.cpu.ss.getWord((this.cpu.edx << 2) + this.cpu.eax);
            }
            case 2258: {
                return this.cpu.ss.getWord((this.cpu.edx << 2) + this.cpu.ecx);
            }
            case 2259: {
                return this.cpu.ss.getWord((this.cpu.edx << 2) + this.cpu.edx);
            }
            case 2260: {
                return this.cpu.ss.getWord((this.cpu.edx << 2) + this.cpu.ebx);
            }
            case 2261: {
                return this.cpu.ss.getWord((this.cpu.edx << 2) + this.cpu.esp);
            }
            case 2262: {
                return this.cpu.ss.getWord((this.cpu.edx << 2) + this.getMicrocode());
            }
            case 2263: {
                return this.cpu.ss.getWord((this.cpu.edx << 2) + this.cpu.esi);
            }
            case 2264: {
                return this.cpu.ss.getWord((this.cpu.edx << 2) + this.cpu.edi);
            }
            case 2265: {
                return this.cpu.ss.getWord((this.cpu.ebx << 2) + this.cpu.eax);
            }
            case 2266: {
                return this.cpu.ss.getWord((this.cpu.ebx << 2) + this.cpu.ecx);
            }
            case 2267: {
                return this.cpu.ss.getWord((this.cpu.ebx << 2) + this.cpu.edx);
            }
            case 2268: {
                return this.cpu.ss.getWord((this.cpu.ebx << 2) + this.cpu.ebx);
            }
            case 2269: {
                return this.cpu.ss.getWord((this.cpu.ebx << 2) + this.cpu.esp);
            }
            case 2270: {
                return this.cpu.ss.getWord((this.cpu.ebx << 2) + this.getMicrocode());
            }
            case 2271: {
                return this.cpu.ss.getWord((this.cpu.ebx << 2) + this.cpu.esi);
            }
            case 2272: {
                return this.cpu.ss.getWord((this.cpu.ebx << 2) + this.cpu.edi);
            }
            case 2273: {
                return this.cpu.ss.getWord((this.cpu.ebp << 2) + this.cpu.eax);
            }
            case 2274: {
                return this.cpu.ss.getWord((this.cpu.ebp << 2) + this.cpu.ecx);
            }
            case 2275: {
                return this.cpu.ss.getWord((this.cpu.ebp << 2) + this.cpu.edx);
            }
            case 2276: {
                return this.cpu.ss.getWord((this.cpu.ebp << 2) + this.cpu.ebx);
            }
            case 2277: {
                return this.cpu.ss.getWord((this.cpu.ebp << 2) + this.cpu.esp);
            }
            case 2278: {
                return this.cpu.ss.getWord((this.cpu.ebp << 2) + this.getMicrocode());
            }
            case 2279: {
                return this.cpu.ss.getWord((this.cpu.ebp << 2) + this.cpu.esi);
            }
            case 2280: {
                return this.cpu.ss.getWord((this.cpu.ebp << 2) + this.cpu.edi);
            }
            case 2281: {
                return this.cpu.ss.getWord((this.cpu.esi << 2) + this.cpu.eax);
            }
            case 2282: {
                return this.cpu.ss.getWord((this.cpu.esi << 2) + this.cpu.ecx);
            }
            case 2283: {
                return this.cpu.ss.getWord((this.cpu.esi << 2) + this.cpu.edx);
            }
            case 2284: {
                return this.cpu.ss.getWord((this.cpu.esi << 2) + this.cpu.ebx);
            }
            case 2285: {
                return this.cpu.ss.getWord((this.cpu.esi << 2) + this.cpu.esp);
            }
            case 2286: {
                return this.cpu.ss.getWord((this.cpu.esi << 2) + this.getMicrocode());
            }
            case 2287: {
                return this.cpu.ss.getWord((this.cpu.esi << 2) + this.cpu.esi);
            }
            case 2288: {
                return this.cpu.ss.getWord((this.cpu.esi << 2) + this.cpu.edi);
            }
            case 2289: {
                return this.cpu.ss.getWord((this.cpu.edi << 2) + this.cpu.eax);
            }
            case 2290: {
                return this.cpu.ss.getWord((this.cpu.edi << 2) + this.cpu.ecx);
            }
            case 2291: {
                return this.cpu.ss.getWord((this.cpu.edi << 2) + this.cpu.edx);
            }
            case 2292: {
                return this.cpu.ss.getWord((this.cpu.edi << 2) + this.cpu.ebx);
            }
            case 2293: {
                return this.cpu.ss.getWord((this.cpu.edi << 2) + this.cpu.esp);
            }
            case 2294: {
                return this.cpu.ss.getWord((this.cpu.edi << 2) + this.getMicrocode());
            }
            case 2295: {
                return this.cpu.ss.getWord((this.cpu.edi << 2) + this.cpu.esi);
            }
            case 2296: {
                return this.cpu.ss.getWord((this.cpu.edi << 2) + this.cpu.edi);
            }
            case 2297: {
                return this.cpu.ss.getWord((this.cpu.eax << 3) + this.cpu.eax);
            }
            case 2298: {
                return this.cpu.ss.getWord((this.cpu.eax << 3) + this.cpu.ecx);
            }
            case 2299: {
                return this.cpu.ss.getWord((this.cpu.eax << 3) + this.cpu.edx);
            }
            case 2300: {
                return this.cpu.ss.getWord((this.cpu.eax << 3) + this.cpu.ebx);
            }
            case 2301: {
                return this.cpu.ss.getWord((this.cpu.eax << 3) + this.cpu.esp);
            }
            case 2302: {
                return this.cpu.ss.getWord((this.cpu.eax << 3) + this.getMicrocode());
            }
            case 2303: {
                return this.cpu.ss.getWord((this.cpu.eax << 3) + this.cpu.esi);
            }
            case 2304: {
                return this.cpu.ss.getWord((this.cpu.eax << 3) + this.cpu.edi);
            }
            case 2305: {
                return this.cpu.ss.getWord((this.cpu.ecx << 3) + this.cpu.eax);
            }
            case 2306: {
                return this.cpu.ss.getWord((this.cpu.ecx << 3) + this.cpu.ecx);
            }
            case 2307: {
                return this.cpu.ss.getWord((this.cpu.ecx << 3) + this.cpu.edx);
            }
            case 2308: {
                return this.cpu.ss.getWord((this.cpu.ecx << 3) + this.cpu.ebx);
            }
            case 2309: {
                return this.cpu.ss.getWord((this.cpu.ecx << 3) + this.cpu.esp);
            }
            case 2310: {
                return this.cpu.ss.getWord((this.cpu.ecx << 3) + this.getMicrocode());
            }
            case 2311: {
                return this.cpu.ss.getWord((this.cpu.ecx << 3) + this.cpu.esi);
            }
            case 2312: {
                return this.cpu.ss.getWord((this.cpu.ecx << 3) + this.cpu.edi);
            }
            case 2313: {
                return this.cpu.ss.getWord((this.cpu.edx << 3) + this.cpu.eax);
            }
            case 2314: {
                return this.cpu.ss.getWord((this.cpu.edx << 3) + this.cpu.ecx);
            }
            case 2315: {
                return this.cpu.ss.getWord((this.cpu.edx << 3) + this.cpu.edx);
            }
            case 2316: {
                return this.cpu.ss.getWord((this.cpu.edx << 3) + this.cpu.ebx);
            }
            case 2317: {
                return this.cpu.ss.getWord((this.cpu.edx << 3) + this.cpu.esp);
            }
            case 2318: {
                return this.cpu.ss.getWord((this.cpu.edx << 3) + this.getMicrocode());
            }
            case 2319: {
                return this.cpu.ss.getWord((this.cpu.edx << 3) + this.cpu.esi);
            }
            case 2320: {
                return this.cpu.ss.getWord((this.cpu.edx << 3) + this.cpu.edi);
            }
            case 2321: {
                return this.cpu.ss.getWord((this.cpu.ebx << 3) + this.cpu.eax);
            }
            case 2322: {
                return this.cpu.ss.getWord((this.cpu.ebx << 3) + this.cpu.ecx);
            }
            case 2323: {
                return this.cpu.ss.getWord((this.cpu.ebx << 3) + this.cpu.edx);
            }
            case 2324: {
                return this.cpu.ss.getWord((this.cpu.ebx << 3) + this.cpu.ebx);
            }
            case 2325: {
                return this.cpu.ss.getWord((this.cpu.ebx << 3) + this.cpu.esp);
            }
            case 2326: {
                return this.cpu.ss.getWord((this.cpu.ebx << 3) + this.getMicrocode());
            }
            case 2327: {
                return this.cpu.ss.getWord((this.cpu.ebx << 3) + this.cpu.esi);
            }
            case 2328: {
                return this.cpu.ss.getWord((this.cpu.ebx << 3) + this.cpu.edi);
            }
            case 2329: {
                return this.cpu.ss.getWord((this.cpu.ebp << 3) + this.cpu.eax);
            }
            case 2330: {
                return this.cpu.ss.getWord((this.cpu.ebp << 3) + this.cpu.ecx);
            }
            case 2331: {
                return this.cpu.ss.getWord((this.cpu.ebp << 3) + this.cpu.edx);
            }
            case 2332: {
                return this.cpu.ss.getWord((this.cpu.ebp << 3) + this.cpu.ebx);
            }
            case 2333: {
                return this.cpu.ss.getWord((this.cpu.ebp << 3) + this.cpu.esp);
            }
            case 2334: {
                return this.cpu.ss.getWord((this.cpu.ebp << 3) + this.getMicrocode());
            }
            case 2335: {
                return this.cpu.ss.getWord((this.cpu.ebp << 3) + this.cpu.esi);
            }
            case 2336: {
                return this.cpu.ss.getWord((this.cpu.ebp << 3) + this.cpu.edi);
            }
            case 2337: {
                return this.cpu.ss.getWord((this.cpu.esi << 3) + this.cpu.eax);
            }
            case 2338: {
                return this.cpu.ss.getWord((this.cpu.esi << 3) + this.cpu.ecx);
            }
            case 2339: {
                return this.cpu.ss.getWord((this.cpu.esi << 3) + this.cpu.edx);
            }
            case 2340: {
                return this.cpu.ss.getWord((this.cpu.esi << 3) + this.cpu.ebx);
            }
            case 2341: {
                return this.cpu.ss.getWord((this.cpu.esi << 3) + this.cpu.esp);
            }
            case 2342: {
                return this.cpu.ss.getWord((this.cpu.esi << 3) + this.getMicrocode());
            }
            case 2343: {
                return this.cpu.ss.getWord((this.cpu.esi << 3) + this.cpu.esi);
            }
            case 2344: {
                return this.cpu.ss.getWord((this.cpu.esi << 3) + this.cpu.edi);
            }
            case 2345: {
                return this.cpu.ss.getWord((this.cpu.edi << 3) + this.cpu.eax);
            }
            case 2346: {
                return this.cpu.ss.getWord((this.cpu.edi << 3) + this.cpu.ecx);
            }
            case 2347: {
                return this.cpu.ss.getWord((this.cpu.edi << 3) + this.cpu.edx);
            }
            case 2348: {
                return this.cpu.ss.getWord((this.cpu.edi << 3) + this.cpu.ebx);
            }
            case 2349: {
                return this.cpu.ss.getWord((this.cpu.edi << 3) + this.cpu.esp);
            }
            case 2350: {
                return this.cpu.ss.getWord((this.cpu.edi << 3) + this.getMicrocode());
            }
            case 2351: {
                return this.cpu.ss.getWord((this.cpu.edi << 3) + this.cpu.esi);
            }
            case 2352: {
                return this.cpu.ss.getWord((this.cpu.edi << 3) + this.cpu.edi);
            }
            case 2353: {
                return this.cpu.ss.getWord(this.cpu.eax + this.cpu.eax + this.getMicrocode());
            }
            case 2354: {
                return this.cpu.ss.getWord(this.cpu.eax + this.cpu.ecx + this.getMicrocode());
            }
            case 2355: {
                return this.cpu.ss.getWord(this.cpu.eax + this.cpu.edx + this.getMicrocode());
            }
            case 2356: {
                return this.cpu.ss.getWord(this.cpu.eax + this.cpu.ebx + this.getMicrocode());
            }
            case 2357: {
                return this.cpu.ss.getWord(this.cpu.eax + this.cpu.esp + this.getMicrocode());
            }
            case 2358: {
                return this.cpu.ss.getWord(this.cpu.eax + this.cpu.ebp + this.getMicrocode());
            }
            case 2359: {
                return this.cpu.ss.getWord(this.cpu.eax + this.cpu.esi + this.getMicrocode());
            }
            case 2360: {
                return this.cpu.ss.getWord(this.cpu.eax + this.cpu.edi + this.getMicrocode());
            }
            case 2361: {
                return this.cpu.ss.getWord(this.cpu.ecx + this.cpu.ecx + this.getMicrocode());
            }
            case 2362: {
                return this.cpu.ss.getWord(this.cpu.ecx + this.cpu.edx + this.getMicrocode());
            }
            case 2363: {
                return this.cpu.ss.getWord(this.cpu.ecx + this.cpu.ebx + this.getMicrocode());
            }
            case 2364: {
                return this.cpu.ss.getWord(this.cpu.ecx + this.cpu.esp + this.getMicrocode());
            }
            case 2365: {
                return this.cpu.ss.getWord(this.cpu.ecx + this.cpu.ebp + this.getMicrocode());
            }
            case 2366: {
                return this.cpu.ss.getWord(this.cpu.ecx + this.cpu.esi + this.getMicrocode());
            }
            case 2367: {
                return this.cpu.ss.getWord(this.cpu.ecx + this.cpu.edi + this.getMicrocode());
            }
            case 2368: {
                return this.cpu.ss.getWord(this.cpu.edx + this.cpu.edx + this.getMicrocode());
            }
            case 2369: {
                return this.cpu.ss.getWord(this.cpu.edx + this.cpu.ebx + this.getMicrocode());
            }
            case 2370: {
                return this.cpu.ss.getWord(this.cpu.edx + this.cpu.esp + this.getMicrocode());
            }
            case 2371: {
                return this.cpu.ss.getWord(this.cpu.edx + this.cpu.ebp + this.getMicrocode());
            }
            case 2372: {
                return this.cpu.ss.getWord(this.cpu.edx + this.cpu.esi + this.getMicrocode());
            }
            case 2373: {
                return this.cpu.ss.getWord(this.cpu.edx + this.cpu.edi + this.getMicrocode());
            }
            case 2374: {
                return this.cpu.ss.getWord(this.cpu.ebx + this.cpu.ebx + this.getMicrocode());
            }
            case 2375: {
                return this.cpu.ss.getWord(this.cpu.ebx + this.cpu.esp + this.getMicrocode());
            }
            case 2376: {
                return this.cpu.ss.getWord(this.cpu.ebx + this.cpu.ebp + this.getMicrocode());
            }
            case 2377: {
                return this.cpu.ss.getWord(this.cpu.ebx + this.cpu.esi + this.getMicrocode());
            }
            case 2378: {
                return this.cpu.ss.getWord(this.cpu.ebx + this.cpu.edi + this.getMicrocode());
            }
            case 2379: {
                return this.cpu.ss.getWord(this.cpu.esp + this.getMicrocode());
            }
            case 2380: {
                return this.cpu.ss.getWord(this.cpu.ebp + this.cpu.esp + this.getMicrocode());
            }
            case 2381: {
                return this.cpu.ss.getWord(this.cpu.ebp + this.cpu.ebp + this.getMicrocode());
            }
            case 2382: {
                return this.cpu.ss.getWord(this.cpu.ebp + this.cpu.esi + this.getMicrocode());
            }
            case 2383: {
                return this.cpu.ss.getWord(this.cpu.ebp + this.cpu.edi + this.getMicrocode());
            }
            case 2384: {
                return this.cpu.ss.getWord(this.cpu.esi + this.cpu.esp + this.getMicrocode());
            }
            case 2385: {
                return this.cpu.ss.getWord(this.cpu.esi + this.cpu.esi + this.getMicrocode());
            }
            case 2386: {
                return this.cpu.ss.getWord(this.cpu.esi + this.cpu.edi + this.getMicrocode());
            }
            case 2387: {
                return this.cpu.ss.getWord(this.cpu.edi + this.cpu.esp + this.getMicrocode());
            }
            case 2388: {
                return this.cpu.ss.getWord(this.cpu.edi + this.cpu.edi + this.getMicrocode());
            }
            case 2389: {
                return this.cpu.ss.getWord((this.cpu.eax << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 2390: {
                return this.cpu.ss.getWord((this.cpu.eax << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 2391: {
                return this.cpu.ss.getWord((this.cpu.eax << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 2392: {
                return this.cpu.ss.getWord((this.cpu.eax << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 2393: {
                return this.cpu.ss.getWord((this.cpu.eax << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 2394: {
                return this.cpu.ss.getWord((this.cpu.eax << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 2395: {
                return this.cpu.ss.getWord((this.cpu.eax << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 2396: {
                return this.cpu.ss.getWord((this.cpu.eax << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 2397: {
                return this.cpu.ss.getWord((this.cpu.ecx << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 2398: {
                return this.cpu.ss.getWord((this.cpu.ecx << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 2399: {
                return this.cpu.ss.getWord((this.cpu.ecx << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 2400: {
                return this.cpu.ss.getWord((this.cpu.ecx << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 2401: {
                return this.cpu.ss.getWord((this.cpu.ecx << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 2402: {
                return this.cpu.ss.getWord((this.cpu.ecx << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 2403: {
                return this.cpu.ss.getWord((this.cpu.ecx << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 2404: {
                return this.cpu.ss.getWord((this.cpu.ecx << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 2405: {
                return this.cpu.ss.getWord((this.cpu.edx << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 2406: {
                return this.cpu.ss.getWord((this.cpu.edx << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 2407: {
                return this.cpu.ss.getWord((this.cpu.edx << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 2408: {
                return this.cpu.ss.getWord((this.cpu.edx << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 2409: {
                return this.cpu.ss.getWord((this.cpu.edx << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 2410: {
                return this.cpu.ss.getWord((this.cpu.edx << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 2411: {
                return this.cpu.ss.getWord((this.cpu.edx << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 2412: {
                return this.cpu.ss.getWord((this.cpu.edx << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 2413: {
                return this.cpu.ss.getWord((this.cpu.ebx << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 2414: {
                return this.cpu.ss.getWord((this.cpu.ebx << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 2415: {
                return this.cpu.ss.getWord((this.cpu.ebx << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 2416: {
                return this.cpu.ss.getWord((this.cpu.ebx << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 2417: {
                return this.cpu.ss.getWord((this.cpu.ebx << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 2418: {
                return this.cpu.ss.getWord((this.cpu.ebx << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 2419: {
                return this.cpu.ss.getWord((this.cpu.ebx << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 2420: {
                return this.cpu.ss.getWord((this.cpu.ebx << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 2421: {
                return this.cpu.ss.getWord((this.cpu.ebp << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 2422: {
                return this.cpu.ss.getWord((this.cpu.ebp << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 2423: {
                return this.cpu.ss.getWord((this.cpu.ebp << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 2424: {
                return this.cpu.ss.getWord((this.cpu.ebp << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 2425: {
                return this.cpu.ss.getWord((this.cpu.ebp << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 2426: {
                return this.cpu.ss.getWord((this.cpu.ebp << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 2427: {
                return this.cpu.ss.getWord((this.cpu.ebp << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 2428: {
                return this.cpu.ss.getWord((this.cpu.ebp << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 2429: {
                return this.cpu.ss.getWord((this.cpu.esi << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 2430: {
                return this.cpu.ss.getWord((this.cpu.esi << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 2431: {
                return this.cpu.ss.getWord((this.cpu.esi << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 2432: {
                return this.cpu.ss.getWord((this.cpu.esi << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 2433: {
                return this.cpu.ss.getWord((this.cpu.esi << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 2434: {
                return this.cpu.ss.getWord((this.cpu.esi << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 2435: {
                return this.cpu.ss.getWord((this.cpu.esi << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 2436: {
                return this.cpu.ss.getWord((this.cpu.esi << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 2437: {
                return this.cpu.ss.getWord((this.cpu.edi << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 2438: {
                return this.cpu.ss.getWord((this.cpu.edi << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 2439: {
                return this.cpu.ss.getWord((this.cpu.edi << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 2440: {
                return this.cpu.ss.getWord((this.cpu.edi << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 2441: {
                return this.cpu.ss.getWord((this.cpu.edi << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 2442: {
                return this.cpu.ss.getWord((this.cpu.edi << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 2443: {
                return this.cpu.ss.getWord((this.cpu.edi << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 2444: {
                return this.cpu.ss.getWord((this.cpu.edi << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 2445: {
                return this.cpu.ss.getWord((this.cpu.eax << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 2446: {
                return this.cpu.ss.getWord((this.cpu.eax << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 2447: {
                return this.cpu.ss.getWord((this.cpu.eax << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 2448: {
                return this.cpu.ss.getWord((this.cpu.eax << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 2449: {
                return this.cpu.ss.getWord((this.cpu.eax << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 2450: {
                return this.cpu.ss.getWord((this.cpu.eax << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 2451: {
                return this.cpu.ss.getWord((this.cpu.eax << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 2452: {
                return this.cpu.ss.getWord((this.cpu.eax << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 2453: {
                return this.cpu.ss.getWord((this.cpu.ecx << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 2454: {
                return this.cpu.ss.getWord((this.cpu.ecx << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 2455: {
                return this.cpu.ss.getWord((this.cpu.ecx << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 2456: {
                return this.cpu.ss.getWord((this.cpu.ecx << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 2457: {
                return this.cpu.ss.getWord((this.cpu.ecx << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 2458: {
                return this.cpu.ss.getWord((this.cpu.ecx << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 2459: {
                return this.cpu.ss.getWord((this.cpu.ecx << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 2460: {
                return this.cpu.ss.getWord((this.cpu.ecx << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 2461: {
                return this.cpu.ss.getWord((this.cpu.edx << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 2462: {
                return this.cpu.ss.getWord((this.cpu.edx << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 2463: {
                return this.cpu.ss.getWord((this.cpu.edx << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 2464: {
                return this.cpu.ss.getWord((this.cpu.edx << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 2465: {
                return this.cpu.ss.getWord((this.cpu.edx << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 2466: {
                return this.cpu.ss.getWord((this.cpu.edx << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 2467: {
                return this.cpu.ss.getWord((this.cpu.edx << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 2468: {
                return this.cpu.ss.getWord((this.cpu.edx << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 2469: {
                return this.cpu.ss.getWord((this.cpu.ebx << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 2470: {
                return this.cpu.ss.getWord((this.cpu.ebx << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 2471: {
                return this.cpu.ss.getWord((this.cpu.ebx << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 2472: {
                return this.cpu.ss.getWord((this.cpu.ebx << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 2473: {
                return this.cpu.ss.getWord((this.cpu.ebx << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 2474: {
                return this.cpu.ss.getWord((this.cpu.ebx << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 2475: {
                return this.cpu.ss.getWord((this.cpu.ebx << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 2476: {
                return this.cpu.ss.getWord((this.cpu.ebx << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 2477: {
                return this.cpu.ss.getWord((this.cpu.ebp << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 2478: {
                return this.cpu.ss.getWord((this.cpu.ebp << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 2479: {
                return this.cpu.ss.getWord((this.cpu.ebp << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 2480: {
                return this.cpu.ss.getWord((this.cpu.ebp << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 2481: {
                return this.cpu.ss.getWord((this.cpu.ebp << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 2482: {
                return this.cpu.ss.getWord((this.cpu.ebp << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 2483: {
                return this.cpu.ss.getWord((this.cpu.ebp << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 2484: {
                return this.cpu.ss.getWord((this.cpu.ebp << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 2485: {
                return this.cpu.ss.getWord((this.cpu.esi << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 2486: {
                return this.cpu.ss.getWord((this.cpu.esi << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 2487: {
                return this.cpu.ss.getWord((this.cpu.esi << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 2488: {
                return this.cpu.ss.getWord((this.cpu.esi << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 2489: {
                return this.cpu.ss.getWord((this.cpu.esi << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 2490: {
                return this.cpu.ss.getWord((this.cpu.esi << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 2491: {
                return this.cpu.ss.getWord((this.cpu.esi << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 2492: {
                return this.cpu.ss.getWord((this.cpu.esi << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 2493: {
                return this.cpu.ss.getWord((this.cpu.edi << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 2494: {
                return this.cpu.ss.getWord((this.cpu.edi << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 2495: {
                return this.cpu.ss.getWord((this.cpu.edi << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 2496: {
                return this.cpu.ss.getWord((this.cpu.edi << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 2497: {
                return this.cpu.ss.getWord((this.cpu.edi << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 2498: {
                return this.cpu.ss.getWord((this.cpu.edi << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 2499: {
                return this.cpu.ss.getWord((this.cpu.edi << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 2500: {
                return this.cpu.ss.getWord((this.cpu.edi << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 2501: {
                return this.cpu.ss.getWord((this.cpu.eax << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 2502: {
                return this.cpu.ss.getWord((this.cpu.eax << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 2503: {
                return this.cpu.ss.getWord((this.cpu.eax << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 2504: {
                return this.cpu.ss.getWord((this.cpu.eax << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 2505: {
                return this.cpu.ss.getWord((this.cpu.eax << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 2506: {
                return this.cpu.ss.getWord((this.cpu.eax << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 2507: {
                return this.cpu.ss.getWord((this.cpu.eax << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 2508: {
                return this.cpu.ss.getWord((this.cpu.eax << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 2509: {
                return this.cpu.ss.getWord((this.cpu.ecx << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 2510: {
                return this.cpu.ss.getWord((this.cpu.ecx << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 2511: {
                return this.cpu.ss.getWord((this.cpu.ecx << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 2512: {
                return this.cpu.ss.getWord((this.cpu.ecx << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 2513: {
                return this.cpu.ss.getWord((this.cpu.ecx << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 2514: {
                return this.cpu.ss.getWord((this.cpu.ecx << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 2515: {
                return this.cpu.ss.getWord((this.cpu.ecx << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 2516: {
                return this.cpu.ss.getWord((this.cpu.ecx << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 2517: {
                return this.cpu.ss.getWord((this.cpu.edx << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 2518: {
                return this.cpu.ss.getWord((this.cpu.edx << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 2519: {
                return this.cpu.ss.getWord((this.cpu.edx << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 2520: {
                return this.cpu.ss.getWord((this.cpu.edx << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 2521: {
                return this.cpu.ss.getWord((this.cpu.edx << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 2522: {
                return this.cpu.ss.getWord((this.cpu.edx << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 2523: {
                return this.cpu.ss.getWord((this.cpu.edx << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 2524: {
                return this.cpu.ss.getWord((this.cpu.edx << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 2525: {
                return this.cpu.ss.getWord((this.cpu.ebx << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 2526: {
                return this.cpu.ss.getWord((this.cpu.ebx << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 2527: {
                return this.cpu.ss.getWord((this.cpu.ebx << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 2528: {
                return this.cpu.ss.getWord((this.cpu.ebx << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 2529: {
                return this.cpu.ss.getWord((this.cpu.ebx << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 2530: {
                return this.cpu.ss.getWord((this.cpu.ebx << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 2531: {
                return this.cpu.ss.getWord((this.cpu.ebx << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 2532: {
                return this.cpu.ss.getWord((this.cpu.ebx << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 2533: {
                return this.cpu.ss.getWord((this.cpu.ebp << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 2534: {
                return this.cpu.ss.getWord((this.cpu.ebp << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 2535: {
                return this.cpu.ss.getWord((this.cpu.ebp << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 2536: {
                return this.cpu.ss.getWord((this.cpu.ebp << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 2537: {
                return this.cpu.ss.getWord((this.cpu.ebp << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 2538: {
                return this.cpu.ss.getWord((this.cpu.ebp << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 2539: {
                return this.cpu.ss.getWord((this.cpu.ebp << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 2540: {
                return this.cpu.ss.getWord((this.cpu.ebp << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 2541: {
                return this.cpu.ss.getWord((this.cpu.esi << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 2542: {
                return this.cpu.ss.getWord((this.cpu.esi << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 2543: {
                return this.cpu.ss.getWord((this.cpu.esi << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 2544: {
                return this.cpu.ss.getWord((this.cpu.esi << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 2545: {
                return this.cpu.ss.getWord((this.cpu.esi << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 2546: {
                return this.cpu.ss.getWord((this.cpu.esi << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 2547: {
                return this.cpu.ss.getWord((this.cpu.esi << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 2548: {
                return this.cpu.ss.getWord((this.cpu.esi << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 2549: {
                return this.cpu.ss.getWord((this.cpu.edi << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 2550: {
                return this.cpu.ss.getWord((this.cpu.edi << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 2551: {
                return this.cpu.ss.getWord((this.cpu.edi << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 2552: {
                return this.cpu.ss.getWord((this.cpu.edi << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 2553: {
                return this.cpu.ss.getWord((this.cpu.edi << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 2554: {
                return this.cpu.ss.getWord((this.cpu.edi << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 2555: {
                return this.cpu.ss.getWord((this.cpu.edi << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 2556: {
                return this.cpu.ss.getWord((this.cpu.edi << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 2557: {
                return this.cpu.ss.getWord(this.cpu.eax + this.cpu.ecx + this.getMicrocode());
            }
            case 2558: {
                return this.cpu.ss.getWord(this.cpu.eax + this.cpu.edx + this.getMicrocode());
            }
            case 2559: {
                return this.cpu.ss.getWord(this.cpu.eax + this.cpu.ebx + this.getMicrocode());
            }
            case 2560: {
                return this.cpu.ss.getWord(this.cpu.eax + this.cpu.esp + this.getMicrocode());
            }
            case 2561: {
                return this.cpu.ss.getWord(this.cpu.eax + this.cpu.ebp + this.getMicrocode());
            }
            case 2562: {
                return this.cpu.ss.getWord(this.cpu.eax + this.cpu.esi + this.getMicrocode());
            }
            case 2563: {
                return this.cpu.ss.getWord(this.cpu.eax + this.cpu.edi + this.getMicrocode());
            }
            case 2564: {
                return this.cpu.ss.getWord(this.cpu.ecx + this.cpu.edx + this.getMicrocode());
            }
            case 2565: {
                return this.cpu.ss.getWord(this.cpu.ecx + this.cpu.ebx + this.getMicrocode());
            }
            case 2566: {
                return this.cpu.ss.getWord(this.cpu.ecx + this.cpu.esp + this.getMicrocode());
            }
            case 2567: {
                return this.cpu.ss.getWord(this.cpu.ecx + this.cpu.ebp + this.getMicrocode());
            }
            case 2568: {
                return this.cpu.ss.getWord(this.cpu.ecx + this.cpu.esi + this.getMicrocode());
            }
            case 2569: {
                return this.cpu.ss.getWord(this.cpu.ecx + this.cpu.edi + this.getMicrocode());
            }
            case 2570: {
                return this.cpu.ss.getWord(this.cpu.edx + this.cpu.ebx + this.getMicrocode());
            }
            case 2571: {
                return this.cpu.ss.getWord(this.cpu.edx + this.cpu.esp + this.getMicrocode());
            }
            case 2572: {
                return this.cpu.ss.getWord(this.cpu.edx + this.cpu.ebp + this.getMicrocode());
            }
            case 2573: {
                return this.cpu.ss.getWord(this.cpu.edx + this.cpu.esi + this.getMicrocode());
            }
            case 2574: {
                return this.cpu.ss.getWord(this.cpu.edx + this.cpu.edi + this.getMicrocode());
            }
            case 2575: {
                return this.cpu.ss.getWord(this.cpu.ebx + this.cpu.esp + this.getMicrocode());
            }
            case 2576: {
                return this.cpu.ss.getWord(this.cpu.ebx + this.cpu.ebp + this.getMicrocode());
            }
            case 2577: {
                return this.cpu.ss.getWord(this.cpu.ebx + this.cpu.esi + this.getMicrocode());
            }
            case 2578: {
                return this.cpu.ss.getWord(this.cpu.ebx + this.cpu.edi + this.getMicrocode());
            }
            case 2579: {
                return this.cpu.ss.getWord(this.cpu.esp + this.getMicrocode());
            }
            case 2580: {
                return this.cpu.ss.getWord(this.cpu.ebp + this.cpu.esp + this.getMicrocode());
            }
            case 2581: {
                return this.cpu.ss.getWord(this.cpu.ebp + this.cpu.esi + this.getMicrocode());
            }
            case 2582: {
                return this.cpu.ss.getWord(this.cpu.ebp + this.cpu.edi + this.getMicrocode());
            }
            case 2583: {
                return this.cpu.ss.getWord(this.cpu.esi + this.cpu.esp + this.getMicrocode());
            }
            case 2584: {
                return this.cpu.ss.getWord(this.cpu.esi + this.cpu.edi + this.getMicrocode());
            }
            case 2585: {
                return this.cpu.ss.getWord(this.cpu.edi + this.cpu.esp + this.getMicrocode());
            }
            case 2586: {
                return this.cpu.ss.getWord((this.cpu.eax << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 2587: {
                return this.cpu.ss.getWord((this.cpu.eax << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 2588: {
                return this.cpu.ss.getWord((this.cpu.eax << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 2589: {
                return this.cpu.ss.getWord((this.cpu.eax << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 2590: {
                return this.cpu.ss.getWord((this.cpu.eax << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 2591: {
                return this.cpu.ss.getWord((this.cpu.eax << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 2592: {
                return this.cpu.ss.getWord((this.cpu.eax << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 2593: {
                return this.cpu.ss.getWord((this.cpu.eax << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 2594: {
                return this.cpu.ss.getWord((this.cpu.ecx << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 2595: {
                return this.cpu.ss.getWord((this.cpu.ecx << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 2596: {
                return this.cpu.ss.getWord((this.cpu.ecx << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 2597: {
                return this.cpu.ss.getWord((this.cpu.ecx << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 2598: {
                return this.cpu.ss.getWord((this.cpu.ecx << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 2599: {
                return this.cpu.ss.getWord((this.cpu.ecx << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 2600: {
                return this.cpu.ss.getWord((this.cpu.ecx << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 2601: {
                return this.cpu.ss.getWord((this.cpu.ecx << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 2602: {
                return this.cpu.ss.getWord((this.cpu.edx << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 2603: {
                return this.cpu.ss.getWord((this.cpu.edx << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 2604: {
                return this.cpu.ss.getWord((this.cpu.edx << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 2605: {
                return this.cpu.ss.getWord((this.cpu.edx << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 2606: {
                return this.cpu.ss.getWord((this.cpu.edx << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 2607: {
                return this.cpu.ss.getWord((this.cpu.edx << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 2608: {
                return this.cpu.ss.getWord((this.cpu.edx << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 2609: {
                return this.cpu.ss.getWord((this.cpu.edx << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 2610: {
                return this.cpu.ss.getWord((this.cpu.ebx << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 2611: {
                return this.cpu.ss.getWord((this.cpu.ebx << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 2612: {
                return this.cpu.ss.getWord((this.cpu.ebx << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 2613: {
                return this.cpu.ss.getWord((this.cpu.ebx << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 2614: {
                return this.cpu.ss.getWord((this.cpu.ebx << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 2615: {
                return this.cpu.ss.getWord((this.cpu.ebx << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 2616: {
                return this.cpu.ss.getWord((this.cpu.ebx << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 2617: {
                return this.cpu.ss.getWord((this.cpu.ebx << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 2618: {
                return this.cpu.ss.getWord((this.cpu.ebp << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 2619: {
                return this.cpu.ss.getWord((this.cpu.ebp << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 2620: {
                return this.cpu.ss.getWord((this.cpu.ebp << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 2621: {
                return this.cpu.ss.getWord((this.cpu.ebp << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 2622: {
                return this.cpu.ss.getWord((this.cpu.ebp << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 2623: {
                return this.cpu.ss.getWord((this.cpu.ebp << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 2624: {
                return this.cpu.ss.getWord((this.cpu.ebp << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 2625: {
                return this.cpu.ss.getWord((this.cpu.ebp << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 2626: {
                return this.cpu.ss.getWord((this.cpu.esi << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 2627: {
                return this.cpu.ss.getWord((this.cpu.esi << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 2628: {
                return this.cpu.ss.getWord((this.cpu.esi << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 2629: {
                return this.cpu.ss.getWord((this.cpu.esi << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 2630: {
                return this.cpu.ss.getWord((this.cpu.esi << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 2631: {
                return this.cpu.ss.getWord((this.cpu.esi << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 2632: {
                return this.cpu.ss.getWord((this.cpu.esi << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 2633: {
                return this.cpu.ss.getWord((this.cpu.esi << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 2634: {
                return this.cpu.ss.getWord((this.cpu.edi << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 2635: {
                return this.cpu.ss.getWord((this.cpu.edi << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 2636: {
                return this.cpu.ss.getWord((this.cpu.edi << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 2637: {
                return this.cpu.ss.getWord((this.cpu.edi << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 2638: {
                return this.cpu.ss.getWord((this.cpu.edi << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 2639: {
                return this.cpu.ss.getWord((this.cpu.edi << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 2640: {
                return this.cpu.ss.getWord((this.cpu.edi << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 2641: {
                return this.cpu.ss.getWord((this.cpu.edi << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 2642: {
                return this.cpu.ss.getWord((this.cpu.eax << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 2643: {
                return this.cpu.ss.getWord((this.cpu.eax << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 2644: {
                return this.cpu.ss.getWord((this.cpu.eax << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 2645: {
                return this.cpu.ss.getWord((this.cpu.eax << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 2646: {
                return this.cpu.ss.getWord((this.cpu.eax << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 2647: {
                return this.cpu.ss.getWord((this.cpu.eax << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 2648: {
                return this.cpu.ss.getWord((this.cpu.eax << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 2649: {
                return this.cpu.ss.getWord((this.cpu.eax << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 2650: {
                return this.cpu.ss.getWord((this.cpu.ecx << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 2651: {
                return this.cpu.ss.getWord((this.cpu.ecx << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 2652: {
                return this.cpu.ss.getWord((this.cpu.ecx << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 2653: {
                return this.cpu.ss.getWord((this.cpu.ecx << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 2654: {
                return this.cpu.ss.getWord((this.cpu.ecx << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 2655: {
                return this.cpu.ss.getWord((this.cpu.ecx << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 2656: {
                return this.cpu.ss.getWord((this.cpu.ecx << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 2657: {
                return this.cpu.ss.getWord((this.cpu.ecx << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 2658: {
                return this.cpu.ss.getWord((this.cpu.edx << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 2659: {
                return this.cpu.ss.getWord((this.cpu.edx << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 2660: {
                return this.cpu.ss.getWord((this.cpu.edx << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 2661: {
                return this.cpu.ss.getWord((this.cpu.edx << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 2662: {
                return this.cpu.ss.getWord((this.cpu.edx << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 2663: {
                return this.cpu.ss.getWord((this.cpu.edx << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 2664: {
                return this.cpu.ss.getWord((this.cpu.edx << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 2665: {
                return this.cpu.ss.getWord((this.cpu.edx << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 2666: {
                return this.cpu.ss.getWord((this.cpu.ebx << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 2667: {
                return this.cpu.ss.getWord((this.cpu.ebx << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 2668: {
                return this.cpu.ss.getWord((this.cpu.ebx << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 2669: {
                return this.cpu.ss.getWord((this.cpu.ebx << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 2670: {
                return this.cpu.ss.getWord((this.cpu.ebx << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 2671: {
                return this.cpu.ss.getWord((this.cpu.ebx << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 2672: {
                return this.cpu.ss.getWord((this.cpu.ebx << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 2673: {
                return this.cpu.ss.getWord((this.cpu.ebx << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 2674: {
                return this.cpu.ss.getWord((this.cpu.ebp << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 2675: {
                return this.cpu.ss.getWord((this.cpu.ebp << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 2676: {
                return this.cpu.ss.getWord((this.cpu.ebp << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 2677: {
                return this.cpu.ss.getWord((this.cpu.ebp << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 2678: {
                return this.cpu.ss.getWord((this.cpu.ebp << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 2679: {
                return this.cpu.ss.getWord((this.cpu.ebp << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 2680: {
                return this.cpu.ss.getWord((this.cpu.ebp << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 2681: {
                return this.cpu.ss.getWord((this.cpu.ebp << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 2682: {
                return this.cpu.ss.getWord((this.cpu.esi << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 2683: {
                return this.cpu.ss.getWord((this.cpu.esi << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 2684: {
                return this.cpu.ss.getWord((this.cpu.esi << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 2685: {
                return this.cpu.ss.getWord((this.cpu.esi << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 2686: {
                return this.cpu.ss.getWord((this.cpu.esi << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 2687: {
                return this.cpu.ss.getWord((this.cpu.esi << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 2688: {
                return this.cpu.ss.getWord((this.cpu.esi << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 2689: {
                return this.cpu.ss.getWord((this.cpu.esi << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 2690: {
                return this.cpu.ss.getWord((this.cpu.edi << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 2691: {
                return this.cpu.ss.getWord((this.cpu.edi << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 2692: {
                return this.cpu.ss.getWord((this.cpu.edi << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 2693: {
                return this.cpu.ss.getWord((this.cpu.edi << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 2694: {
                return this.cpu.ss.getWord((this.cpu.edi << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 2695: {
                return this.cpu.ss.getWord((this.cpu.edi << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 2696: {
                return this.cpu.ss.getWord((this.cpu.edi << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 2697: {
                return this.cpu.ss.getWord((this.cpu.edi << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 2698: {
                return this.cpu.ss.getWord((this.cpu.eax << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 2699: {
                return this.cpu.ss.getWord((this.cpu.eax << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 2700: {
                return this.cpu.ss.getWord((this.cpu.eax << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 2701: {
                return this.cpu.ss.getWord((this.cpu.eax << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 2702: {
                return this.cpu.ss.getWord((this.cpu.eax << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 2703: {
                return this.cpu.ss.getWord((this.cpu.eax << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 2704: {
                return this.cpu.ss.getWord((this.cpu.eax << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 2705: {
                return this.cpu.ss.getWord((this.cpu.eax << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 2706: {
                return this.cpu.ss.getWord((this.cpu.ecx << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 2707: {
                return this.cpu.ss.getWord((this.cpu.ecx << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 2708: {
                return this.cpu.ss.getWord((this.cpu.ecx << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 2709: {
                return this.cpu.ss.getWord((this.cpu.ecx << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 2710: {
                return this.cpu.ss.getWord((this.cpu.ecx << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 2711: {
                return this.cpu.ss.getWord((this.cpu.ecx << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 2712: {
                return this.cpu.ss.getWord((this.cpu.ecx << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 2713: {
                return this.cpu.ss.getWord((this.cpu.ecx << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 2714: {
                return this.cpu.ss.getWord((this.cpu.edx << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 2715: {
                return this.cpu.ss.getWord((this.cpu.edx << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 2716: {
                return this.cpu.ss.getWord((this.cpu.edx << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 2717: {
                return this.cpu.ss.getWord((this.cpu.edx << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 2718: {
                return this.cpu.ss.getWord((this.cpu.edx << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 2719: {
                return this.cpu.ss.getWord((this.cpu.edx << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 2720: {
                return this.cpu.ss.getWord((this.cpu.edx << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 2721: {
                return this.cpu.ss.getWord((this.cpu.edx << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 2722: {
                return this.cpu.ss.getWord((this.cpu.ebx << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 2723: {
                return this.cpu.ss.getWord((this.cpu.ebx << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 2724: {
                return this.cpu.ss.getWord((this.cpu.ebx << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 2725: {
                return this.cpu.ss.getWord((this.cpu.ebx << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 2726: {
                return this.cpu.ss.getWord((this.cpu.ebx << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 2727: {
                return this.cpu.ss.getWord((this.cpu.ebx << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 2728: {
                return this.cpu.ss.getWord((this.cpu.ebx << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 2729: {
                return this.cpu.ss.getWord((this.cpu.ebx << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 2730: {
                return this.cpu.ss.getWord((this.cpu.ebp << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 2731: {
                return this.cpu.ss.getWord((this.cpu.ebp << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 2732: {
                return this.cpu.ss.getWord((this.cpu.ebp << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 2733: {
                return this.cpu.ss.getWord((this.cpu.ebp << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 2734: {
                return this.cpu.ss.getWord((this.cpu.ebp << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 2735: {
                return this.cpu.ss.getWord((this.cpu.ebp << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 2736: {
                return this.cpu.ss.getWord((this.cpu.ebp << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 2737: {
                return this.cpu.ss.getWord((this.cpu.ebp << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 2738: {
                return this.cpu.ss.getWord((this.cpu.esi << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 2739: {
                return this.cpu.ss.getWord((this.cpu.esi << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 2740: {
                return this.cpu.ss.getWord((this.cpu.esi << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 2741: {
                return this.cpu.ss.getWord((this.cpu.esi << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 2742: {
                return this.cpu.ss.getWord((this.cpu.esi << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 2743: {
                return this.cpu.ss.getWord((this.cpu.esi << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 2744: {
                return this.cpu.ss.getWord((this.cpu.esi << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 2745: {
                return this.cpu.ss.getWord((this.cpu.esi << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 2746: {
                return this.cpu.ss.getWord((this.cpu.edi << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 2747: {
                return this.cpu.ss.getWord((this.cpu.edi << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 2748: {
                return this.cpu.ss.getWord((this.cpu.edi << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 2749: {
                return this.cpu.ss.getWord((this.cpu.edi << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 2750: {
                return this.cpu.ss.getWord((this.cpu.edi << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 2751: {
                return this.cpu.ss.getWord((this.cpu.edi << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 2752: {
                return this.cpu.ss.getWord((this.cpu.edi << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 2753: {
                return this.cpu.ss.getWord((this.cpu.edi << 3) + this.cpu.edi + this.getMicrocode());
            }
        }
        System.err.println("Unimplemented GetShort Operand: " + n);
        throw unimplemented;
    }

    protected final int getIntOperand() {
        int n = this.getMicrocode();
        switch (n) {
            case 16: {
                return this.cpu.eax;
            }
            case 17: {
                return this.cpu.ecx;
            }
            case 18: {
                return this.cpu.edx;
            }
            case 19: {
                return this.cpu.ebx;
            }
            case 20: {
                return this.cpu.esp;
            }
            case 21: {
                return this.cpu.ebp;
            }
            case 22: {
                return this.cpu.esi;
            }
            case 23: {
                return this.cpu.edi;
            }
            case 30: {
                return this.cpu.getCR0();
            }
            case 32: {
                return this.cpu.getCR2();
            }
            case 33: {
                return this.cpu.getCR3();
            }
            case 34: {
                return this.cpu.getCR4();
            }
            case 35: {
                return this.cpu.getDR0();
            }
            case 36: {
                return this.cpu.getDR1();
            }
            case 37: {
                return this.cpu.getDR2();
            }
            case 38: {
                return this.cpu.getDR3();
            }
            case 39: {
                return this.cpu.getDR6();
            }
            case 40: {
                return this.cpu.getDR7();
            }
            case 46: {
                return this.getMicrocode();
            }
            case 41: {
                return this.getMicrocode();
            }
            case 42: {
                return this.getMicrocode();
            }
            case 43: {
                return this.getMicrocode();
            }
            case 44: {
                return this.getMicrocode();
            }
            case 24: {
                return 0xFFFF & this.cpu.es.getSelector();
            }
            case 25: {
                return 0xFFFF & this.cpu.cs.getSelector();
            }
            case 26: {
                return 0xFFFF & this.cpu.ss.getSelector();
            }
            case 27: {
                return 0xFFFF & this.cpu.ds.getSelector();
            }
            case 28: {
                return 0xFFFF & this.cpu.fs.getSelector();
            }
            case 29: {
                return 0xFFFF & this.cpu.gs.getSelector();
            }
        }
        return this.getIntMemoryOperand(n);
    }

    /*
     * Opcode count of 21951 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    private final int getIntMemoryOperand(int n) {
        switch (n) {
            case 182: {
                return this.cpu.es.getDoubleWord(this.cpu.ebx + this.cpu.esi & 0xFFFF);
            }
            case 183: {
                return this.cpu.es.getDoubleWord(this.cpu.ebx + this.cpu.edi & 0xFFFF);
            }
            case 184: {
                return this.cpu.es.getDoubleWord(this.cpu.ebp + this.cpu.esi & 0xFFFF);
            }
            case 185: {
                return this.cpu.es.getDoubleWord(this.cpu.ebp + this.cpu.edi & 0xFFFF);
            }
            case 186: {
                return this.cpu.es.getDoubleWord(this.cpu.esi & 0xFFFF);
            }
            case 187: {
                return this.cpu.es.getDoubleWord(this.cpu.edi & 0xFFFF);
            }
            case 188: {
                return this.cpu.es.getDoubleWord(this.getMicrocode() & 0xFFFF);
            }
            case 189: {
                return this.cpu.es.getDoubleWord(this.cpu.ebx & 0xFFFF);
            }
            case 190: {
                return this.cpu.es.getDoubleWord(this.cpu.ebx + this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 191: {
                return this.cpu.es.getDoubleWord(this.cpu.ebx + this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 192: {
                return this.cpu.es.getDoubleWord(this.cpu.ebp + this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 193: {
                return this.cpu.es.getDoubleWord(this.cpu.ebp + this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 194: {
                return this.cpu.es.getDoubleWord(this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 195: {
                return this.cpu.es.getDoubleWord(this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 196: {
                return this.cpu.es.getDoubleWord(this.cpu.ebp + this.getMicrocode() & 0xFFFF);
            }
            case 197: {
                return this.cpu.es.getDoubleWord(this.cpu.ebx + this.getMicrocode() & 0xFFFF);
            }
            case 198: {
                return this.cpu.es.getDoubleWord(this.cpu.ebx + this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 199: {
                return this.cpu.es.getDoubleWord(this.cpu.ebx + this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 200: {
                return this.cpu.es.getDoubleWord(this.cpu.ebp + this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 201: {
                return this.cpu.es.getDoubleWord(this.cpu.ebp + this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 202: {
                return this.cpu.es.getDoubleWord(this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 203: {
                return this.cpu.es.getDoubleWord(this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 204: {
                return this.cpu.es.getDoubleWord(this.cpu.ebp + this.getMicrocode() & 0xFFFF);
            }
            case 205: {
                return this.cpu.es.getDoubleWord(this.cpu.ebx + this.getMicrocode() & 0xFFFF);
            }
            case 206: {
                return this.cpu.cs.getDoubleWord(this.cpu.ebx + this.cpu.esi & 0xFFFF);
            }
            case 207: {
                return this.cpu.cs.getDoubleWord(this.cpu.ebx + this.cpu.edi & 0xFFFF);
            }
            case 208: {
                return this.cpu.cs.getDoubleWord(this.cpu.ebp + this.cpu.esi & 0xFFFF);
            }
            case 209: {
                return this.cpu.cs.getDoubleWord(this.cpu.ebp + this.cpu.edi & 0xFFFF);
            }
            case 210: {
                return this.cpu.cs.getDoubleWord(this.cpu.esi & 0xFFFF);
            }
            case 211: {
                return this.cpu.cs.getDoubleWord(this.cpu.edi & 0xFFFF);
            }
            case 212: {
                return this.cpu.cs.getDoubleWord(this.getMicrocode() & 0xFFFF);
            }
            case 213: {
                return this.cpu.cs.getDoubleWord(this.cpu.ebx & 0xFFFF);
            }
            case 214: {
                return this.cpu.cs.getDoubleWord(this.cpu.ebx + this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 215: {
                return this.cpu.cs.getDoubleWord(this.cpu.ebx + this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 216: {
                return this.cpu.cs.getDoubleWord(this.cpu.ebp + this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 217: {
                return this.cpu.cs.getDoubleWord(this.cpu.ebp + this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 218: {
                return this.cpu.cs.getDoubleWord(this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 219: {
                return this.cpu.cs.getDoubleWord(this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 220: {
                return this.cpu.cs.getDoubleWord(this.cpu.ebp + this.getMicrocode() & 0xFFFF);
            }
            case 221: {
                return this.cpu.cs.getDoubleWord(this.cpu.ebx + this.getMicrocode() & 0xFFFF);
            }
            case 222: {
                return this.cpu.cs.getDoubleWord(this.cpu.ebx + this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 223: {
                return this.cpu.cs.getDoubleWord(this.cpu.ebx + this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 224: {
                return this.cpu.cs.getDoubleWord(this.cpu.ebp + this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 225: {
                return this.cpu.cs.getDoubleWord(this.cpu.ebp + this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 226: {
                return this.cpu.cs.getDoubleWord(this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 227: {
                return this.cpu.cs.getDoubleWord(this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 228: {
                return this.cpu.cs.getDoubleWord(this.cpu.ebp + this.getMicrocode() & 0xFFFF);
            }
            case 229: {
                return this.cpu.cs.getDoubleWord(this.cpu.ebx + this.getMicrocode() & 0xFFFF);
            }
            case 230: {
                return this.cpu.ss.getDoubleWord(this.cpu.ebx + this.cpu.esi & 0xFFFF);
            }
            case 231: {
                return this.cpu.ss.getDoubleWord(this.cpu.ebx + this.cpu.edi & 0xFFFF);
            }
            case 232: {
                return this.cpu.ss.getDoubleWord(this.cpu.ebp + this.cpu.esi & 0xFFFF);
            }
            case 233: {
                return this.cpu.ss.getDoubleWord(this.cpu.ebp + this.cpu.edi & 0xFFFF);
            }
            case 234: {
                return this.cpu.ss.getDoubleWord(this.cpu.esi & 0xFFFF);
            }
            case 235: {
                return this.cpu.ss.getDoubleWord(this.cpu.edi & 0xFFFF);
            }
            case 236: {
                return this.cpu.ss.getDoubleWord(this.getMicrocode() & 0xFFFF);
            }
            case 237: {
                return this.cpu.ss.getDoubleWord(this.cpu.ebx & 0xFFFF);
            }
            case 238: {
                return this.cpu.ss.getDoubleWord(this.cpu.ebx + this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 239: {
                return this.cpu.ss.getDoubleWord(this.cpu.ebx + this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 240: {
                return this.cpu.ss.getDoubleWord(this.cpu.ebp + this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 241: {
                return this.cpu.ss.getDoubleWord(this.cpu.ebp + this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 242: {
                return this.cpu.ss.getDoubleWord(this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 243: {
                return this.cpu.ss.getDoubleWord(this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 244: {
                return this.cpu.ss.getDoubleWord(this.cpu.ebp + this.getMicrocode() & 0xFFFF);
            }
            case 245: {
                return this.cpu.ss.getDoubleWord(this.cpu.ebx + this.getMicrocode() & 0xFFFF);
            }
            case 246: {
                return this.cpu.ss.getDoubleWord(this.cpu.ebx + this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 247: {
                return this.cpu.ss.getDoubleWord(this.cpu.ebx + this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 248: {
                return this.cpu.ss.getDoubleWord(this.cpu.ebp + this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 249: {
                return this.cpu.ss.getDoubleWord(this.cpu.ebp + this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 250: {
                return this.cpu.ss.getDoubleWord(this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 251: {
                return this.cpu.ss.getDoubleWord(this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 252: {
                return this.cpu.ss.getDoubleWord(this.cpu.ebp + this.getMicrocode() & 0xFFFF);
            }
            case 253: {
                return this.cpu.ss.getDoubleWord(this.cpu.ebx + this.getMicrocode() & 0xFFFF);
            }
            case 254: {
                return this.cpu.ds.getDoubleWord(this.cpu.ebx + this.cpu.esi & 0xFFFF);
            }
            case 255: {
                return this.cpu.ds.getDoubleWord(this.cpu.ebx + this.cpu.edi & 0xFFFF);
            }
            case 256: {
                return this.cpu.ds.getDoubleWord(this.cpu.ebp + this.cpu.esi & 0xFFFF);
            }
            case 257: {
                return this.cpu.ds.getDoubleWord(this.cpu.ebp + this.cpu.edi & 0xFFFF);
            }
            case 258: {
                return this.cpu.ds.getDoubleWord(this.cpu.esi & 0xFFFF);
            }
            case 259: {
                return this.cpu.ds.getDoubleWord(this.cpu.edi & 0xFFFF);
            }
            case 260: {
                return this.cpu.ds.getDoubleWord(this.getMicrocode() & 0xFFFF);
            }
            case 261: {
                return this.cpu.ds.getDoubleWord(this.cpu.ebx & 0xFFFF);
            }
            case 262: {
                return this.cpu.ds.getDoubleWord(this.cpu.ebx + this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 263: {
                return this.cpu.ds.getDoubleWord(this.cpu.ebx + this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 264: {
                return this.cpu.ds.getDoubleWord(this.cpu.ebp + this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 265: {
                return this.cpu.ds.getDoubleWord(this.cpu.ebp + this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 266: {
                return this.cpu.ds.getDoubleWord(this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 267: {
                return this.cpu.ds.getDoubleWord(this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 268: {
                return this.cpu.ds.getDoubleWord(this.cpu.ebp + this.getMicrocode() & 0xFFFF);
            }
            case 269: {
                return this.cpu.ds.getDoubleWord(this.cpu.ebx + this.getMicrocode() & 0xFFFF);
            }
            case 270: {
                return this.cpu.ds.getDoubleWord(this.cpu.ebx + this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 271: {
                return this.cpu.ds.getDoubleWord(this.cpu.ebx + this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 272: {
                return this.cpu.ds.getDoubleWord(this.cpu.ebp + this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 273: {
                return this.cpu.ds.getDoubleWord(this.cpu.ebp + this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 274: {
                return this.cpu.ds.getDoubleWord(this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 275: {
                return this.cpu.ds.getDoubleWord(this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 276: {
                return this.cpu.ds.getDoubleWord(this.cpu.ebp + this.getMicrocode() & 0xFFFF);
            }
            case 277: {
                return this.cpu.ds.getDoubleWord(this.cpu.ebx + this.getMicrocode() & 0xFFFF);
            }
            case 278: {
                return this.cpu.fs.getDoubleWord(this.cpu.ebx + this.cpu.esi & 0xFFFF);
            }
            case 279: {
                return this.cpu.fs.getDoubleWord(this.cpu.ebx + this.cpu.edi & 0xFFFF);
            }
            case 280: {
                return this.cpu.fs.getDoubleWord(this.cpu.ebp + this.cpu.esi & 0xFFFF);
            }
            case 281: {
                return this.cpu.fs.getDoubleWord(this.cpu.ebp + this.cpu.edi & 0xFFFF);
            }
            case 282: {
                return this.cpu.fs.getDoubleWord(this.cpu.esi & 0xFFFF);
            }
            case 283: {
                return this.cpu.fs.getDoubleWord(this.cpu.edi & 0xFFFF);
            }
            case 284: {
                return this.cpu.fs.getDoubleWord(this.getMicrocode() & 0xFFFF);
            }
            case 285: {
                return this.cpu.fs.getDoubleWord(this.cpu.ebx & 0xFFFF);
            }
            case 286: {
                return this.cpu.fs.getDoubleWord(this.cpu.ebx + this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 287: {
                return this.cpu.fs.getDoubleWord(this.cpu.ebx + this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 288: {
                return this.cpu.fs.getDoubleWord(this.cpu.ebp + this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 289: {
                return this.cpu.fs.getDoubleWord(this.cpu.ebp + this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 290: {
                return this.cpu.fs.getDoubleWord(this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 291: {
                return this.cpu.fs.getDoubleWord(this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 292: {
                return this.cpu.fs.getDoubleWord(this.cpu.ebp + this.getMicrocode() & 0xFFFF);
            }
            case 293: {
                return this.cpu.fs.getDoubleWord(this.cpu.ebx + this.getMicrocode() & 0xFFFF);
            }
            case 294: {
                return this.cpu.fs.getDoubleWord(this.cpu.ebx + this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 295: {
                return this.cpu.fs.getDoubleWord(this.cpu.ebx + this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 296: {
                return this.cpu.fs.getDoubleWord(this.cpu.ebp + this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 297: {
                return this.cpu.fs.getDoubleWord(this.cpu.ebp + this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 298: {
                return this.cpu.fs.getDoubleWord(this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 299: {
                return this.cpu.fs.getDoubleWord(this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 300: {
                return this.cpu.fs.getDoubleWord(this.cpu.ebp + this.getMicrocode() & 0xFFFF);
            }
            case 301: {
                return this.cpu.fs.getDoubleWord(this.cpu.ebx + this.getMicrocode() & 0xFFFF);
            }
            case 302: {
                return this.cpu.gs.getDoubleWord(this.cpu.ebx + this.cpu.esi & 0xFFFF);
            }
            case 303: {
                return this.cpu.gs.getDoubleWord(this.cpu.ebx + this.cpu.edi & 0xFFFF);
            }
            case 304: {
                return this.cpu.gs.getDoubleWord(this.cpu.ebp + this.cpu.esi & 0xFFFF);
            }
            case 305: {
                return this.cpu.gs.getDoubleWord(this.cpu.ebp + this.cpu.edi & 0xFFFF);
            }
            case 306: {
                return this.cpu.gs.getDoubleWord(this.cpu.esi & 0xFFFF);
            }
            case 307: {
                return this.cpu.gs.getDoubleWord(this.cpu.edi & 0xFFFF);
            }
            case 308: {
                return this.cpu.gs.getDoubleWord(this.getMicrocode() & 0xFFFF);
            }
            case 309: {
                return this.cpu.gs.getDoubleWord(this.cpu.ebx & 0xFFFF);
            }
            case 310: {
                return this.cpu.gs.getDoubleWord(this.cpu.ebx + this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 311: {
                return this.cpu.gs.getDoubleWord(this.cpu.ebx + this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 312: {
                return this.cpu.gs.getDoubleWord(this.cpu.ebp + this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 313: {
                return this.cpu.gs.getDoubleWord(this.cpu.ebp + this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 314: {
                return this.cpu.gs.getDoubleWord(this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 315: {
                return this.cpu.gs.getDoubleWord(this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 316: {
                return this.cpu.gs.getDoubleWord(this.cpu.ebp + this.getMicrocode() & 0xFFFF);
            }
            case 317: {
                return this.cpu.gs.getDoubleWord(this.cpu.ebx + this.getMicrocode() & 0xFFFF);
            }
            case 318: {
                return this.cpu.gs.getDoubleWord(this.cpu.ebx + this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 319: {
                return this.cpu.gs.getDoubleWord(this.cpu.ebx + this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 320: {
                return this.cpu.gs.getDoubleWord(this.cpu.ebp + this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 321: {
                return this.cpu.gs.getDoubleWord(this.cpu.ebp + this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 322: {
                return this.cpu.gs.getDoubleWord(this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 323: {
                return this.cpu.gs.getDoubleWord(this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 324: {
                return this.cpu.gs.getDoubleWord(this.cpu.ebp + this.getMicrocode() & 0xFFFF);
            }
            case 325: {
                return this.cpu.gs.getDoubleWord(this.cpu.ebx + this.getMicrocode() & 0xFFFF);
            }
            case 56: {
                return this.cpu.es.getDoubleWord(this.cpu.eax);
            }
            case 57: {
                return this.cpu.es.getDoubleWord(this.cpu.ecx);
            }
            case 58: {
                return this.cpu.es.getDoubleWord(this.cpu.edx);
            }
            case 59: {
                return this.cpu.es.getDoubleWord(this.cpu.ebx);
            }
            case 60: {
                return this.cpu.es.getDoubleWord(this.getMicrocode());
            }
            case 61: {
                return this.cpu.es.getDoubleWord(this.cpu.esi);
            }
            case 62: {
                return this.cpu.es.getDoubleWord(this.cpu.edi);
            }
            case 63: {
                return this.cpu.es.getDoubleWord(this.cpu.eax + this.getMicrocode());
            }
            case 64: {
                return this.cpu.es.getDoubleWord(this.cpu.ecx + this.getMicrocode());
            }
            case 65: {
                return this.cpu.es.getDoubleWord(this.cpu.edx + this.getMicrocode());
            }
            case 66: {
                return this.cpu.es.getDoubleWord(this.cpu.ebx + this.getMicrocode());
            }
            case 67: {
                return this.cpu.es.getDoubleWord(this.cpu.ebp + this.getMicrocode());
            }
            case 68: {
                return this.cpu.es.getDoubleWord(this.cpu.esi + this.getMicrocode());
            }
            case 69: {
                return this.cpu.es.getDoubleWord(this.cpu.edi + this.getMicrocode());
            }
            case 70: {
                return this.cpu.es.getDoubleWord(this.cpu.eax + this.getMicrocode());
            }
            case 71: {
                return this.cpu.es.getDoubleWord(this.cpu.ecx + this.getMicrocode());
            }
            case 72: {
                return this.cpu.es.getDoubleWord(this.cpu.edx + this.getMicrocode());
            }
            case 73: {
                return this.cpu.es.getDoubleWord(this.cpu.ebx + this.getMicrocode());
            }
            case 74: {
                return this.cpu.es.getDoubleWord(this.cpu.ebp + this.getMicrocode());
            }
            case 75: {
                return this.cpu.es.getDoubleWord(this.cpu.esi + this.getMicrocode());
            }
            case 76: {
                return this.cpu.es.getDoubleWord(this.cpu.edi + this.getMicrocode());
            }
            case 161: {
                return this.cpu.gs.getDoubleWord(this.cpu.eax);
            }
            case 162: {
                return this.cpu.gs.getDoubleWord(this.cpu.ecx);
            }
            case 163: {
                return this.cpu.gs.getDoubleWord(this.cpu.edx);
            }
            case 164: {
                return this.cpu.gs.getDoubleWord(this.cpu.ebx);
            }
            case 165: {
                return this.cpu.gs.getDoubleWord(this.getMicrocode());
            }
            case 166: {
                return this.cpu.gs.getDoubleWord(this.cpu.esi);
            }
            case 167: {
                return this.cpu.gs.getDoubleWord(this.cpu.edi);
            }
            case 168: {
                return this.cpu.gs.getDoubleWord(this.cpu.eax + this.getMicrocode());
            }
            case 169: {
                return this.cpu.gs.getDoubleWord(this.cpu.ecx + this.getMicrocode());
            }
            case 170: {
                return this.cpu.gs.getDoubleWord(this.cpu.edx + this.getMicrocode());
            }
            case 171: {
                return this.cpu.gs.getDoubleWord(this.cpu.ebx + this.getMicrocode());
            }
            case 172: {
                return this.cpu.gs.getDoubleWord(this.cpu.ebp + this.getMicrocode());
            }
            case 173: {
                return this.cpu.gs.getDoubleWord(this.cpu.esi + this.getMicrocode());
            }
            case 174: {
                return this.cpu.gs.getDoubleWord(this.cpu.edi + this.getMicrocode());
            }
            case 175: {
                return this.cpu.gs.getDoubleWord(this.cpu.eax + this.getMicrocode());
            }
            case 176: {
                return this.cpu.gs.getDoubleWord(this.cpu.ecx + this.getMicrocode());
            }
            case 177: {
                return this.cpu.gs.getDoubleWord(this.cpu.edx + this.getMicrocode());
            }
            case 178: {
                return this.cpu.gs.getDoubleWord(this.cpu.ebx + this.getMicrocode());
            }
            case 179: {
                return this.cpu.gs.getDoubleWord(this.cpu.ebp + this.getMicrocode());
            }
            case 180: {
                return this.cpu.gs.getDoubleWord(this.cpu.esi + this.getMicrocode());
            }
            case 181: {
                return this.cpu.gs.getDoubleWord(this.cpu.edi + this.getMicrocode());
            }
            case 91: {
                return this.cpu.cs.getDoubleWord(this.cpu.eax + this.getMicrocode());
            }
            case 92: {
                return this.cpu.cs.getDoubleWord(this.cpu.ecx + this.getMicrocode());
            }
            case 93: {
                return this.cpu.cs.getDoubleWord(this.cpu.edx + this.getMicrocode());
            }
            case 94: {
                return this.cpu.cs.getDoubleWord(this.cpu.ebx + this.getMicrocode());
            }
            case 95: {
                return this.cpu.cs.getDoubleWord(this.cpu.ebp + this.getMicrocode());
            }
            case 96: {
                return this.cpu.cs.getDoubleWord(this.cpu.esi + this.getMicrocode());
            }
            case 97: {
                return this.cpu.cs.getDoubleWord(this.cpu.edi + this.getMicrocode());
            }
            case 102: {
                return this.cpu.ss.getDoubleWord(this.getMicrocode());
            }
            case 105: {
                return this.cpu.ss.getDoubleWord(this.cpu.eax + this.getMicrocode());
            }
            case 106: {
                return this.cpu.ss.getDoubleWord(this.cpu.ecx + this.getMicrocode());
            }
            case 107: {
                return this.cpu.ss.getDoubleWord(this.cpu.edx + this.getMicrocode());
            }
            case 108: {
                return this.cpu.ss.getDoubleWord(this.cpu.ebx + this.getMicrocode());
            }
            case 109: {
                return this.cpu.ss.getDoubleWord(this.cpu.ebp + this.getMicrocode());
            }
            case 110: {
                return this.cpu.ss.getDoubleWord(this.cpu.esi + this.getMicrocode());
            }
            case 111: {
                return this.cpu.ss.getDoubleWord(this.cpu.edi + this.getMicrocode());
            }
            case 112: {
                return this.cpu.ss.getDoubleWord(this.cpu.eax + this.getMicrocode());
            }
            case 113: {
                return this.cpu.ss.getDoubleWord(this.cpu.ecx + this.getMicrocode());
            }
            case 114: {
                return this.cpu.ss.getDoubleWord(this.cpu.edx + this.getMicrocode());
            }
            case 115: {
                return this.cpu.ss.getDoubleWord(this.cpu.ebx + this.getMicrocode());
            }
            case 116: {
                return this.cpu.ss.getDoubleWord(this.cpu.ebp + this.getMicrocode());
            }
            case 117: {
                return this.cpu.ss.getDoubleWord(this.cpu.esi + this.getMicrocode());
            }
            case 118: {
                return this.cpu.ss.getDoubleWord(this.cpu.edi + this.getMicrocode());
            }
            case 119: {
                return this.cpu.ds.getDoubleWord(this.cpu.eax);
            }
            case 120: {
                return this.cpu.ds.getDoubleWord(this.cpu.ecx);
            }
            case 121: {
                return this.cpu.ds.getDoubleWord(this.cpu.edx);
            }
            case 122: {
                return this.cpu.ds.getDoubleWord(this.cpu.ebx);
            }
            case 123: {
                return this.cpu.ds.getDoubleWord(this.getMicrocode());
            }
            case 124: {
                return this.cpu.ds.getDoubleWord(this.cpu.esi);
            }
            case 125: {
                return this.cpu.ds.getDoubleWord(this.cpu.edi);
            }
            case 126: {
                return this.cpu.ds.getDoubleWord(this.cpu.eax + this.getMicrocode());
            }
            case 127: {
                return this.cpu.ds.getDoubleWord(this.cpu.ecx + this.getMicrocode());
            }
            case 128: {
                return this.cpu.ds.getDoubleWord(this.cpu.edx + this.getMicrocode());
            }
            case 129: {
                return this.cpu.ds.getDoubleWord(this.cpu.ebx + this.getMicrocode());
            }
            case 130: {
                return this.cpu.ds.getDoubleWord(this.cpu.ebp + this.getMicrocode());
            }
            case 131: {
                return this.cpu.ds.getDoubleWord(this.cpu.esi + this.getMicrocode());
            }
            case 132: {
                return this.cpu.ds.getDoubleWord(this.cpu.edi + this.getMicrocode());
            }
            case 133: {
                return this.cpu.ds.getDoubleWord(this.cpu.eax + this.getMicrocode());
            }
            case 134: {
                return this.cpu.ds.getDoubleWord(this.cpu.ecx + this.getMicrocode());
            }
            case 135: {
                return this.cpu.ds.getDoubleWord(this.cpu.edx + this.getMicrocode());
            }
            case 136: {
                return this.cpu.ds.getDoubleWord(this.cpu.ebx + this.getMicrocode());
            }
            case 137: {
                return this.cpu.ds.getDoubleWord(this.cpu.ebp + this.getMicrocode());
            }
            case 138: {
                return this.cpu.ds.getDoubleWord(this.cpu.esi + this.getMicrocode());
            }
            case 139: {
                return this.cpu.ds.getDoubleWord(this.cpu.edi + this.getMicrocode());
            }
            case 140: {
                return this.cpu.fs.getDoubleWord(this.cpu.eax);
            }
            case 141: {
                return this.cpu.fs.getDoubleWord(this.cpu.ecx);
            }
            case 142: {
                return this.cpu.fs.getDoubleWord(this.cpu.edx);
            }
            case 143: {
                return this.cpu.fs.getDoubleWord(this.cpu.ebx);
            }
            case 144: {
                return this.cpu.fs.getDoubleWord(this.getMicrocode());
            }
            case 145: {
                return this.cpu.fs.getDoubleWord(this.cpu.esi);
            }
            case 146: {
                return this.cpu.fs.getDoubleWord(this.cpu.edi);
            }
            case 147: {
                return this.cpu.fs.getDoubleWord(this.cpu.eax + this.getMicrocode());
            }
            case 148: {
                return this.cpu.fs.getDoubleWord(this.cpu.ecx + this.getMicrocode());
            }
            case 149: {
                return this.cpu.fs.getDoubleWord(this.cpu.edx + this.getMicrocode());
            }
            case 150: {
                return this.cpu.fs.getDoubleWord(this.cpu.ebx + this.getMicrocode());
            }
            case 151: {
                return this.cpu.fs.getDoubleWord(this.cpu.ebp + this.getMicrocode());
            }
            case 152: {
                return this.cpu.fs.getDoubleWord(this.cpu.esi + this.getMicrocode());
            }
            case 153: {
                return this.cpu.fs.getDoubleWord(this.cpu.edi + this.getMicrocode());
            }
            case 154: {
                return this.cpu.fs.getDoubleWord(this.cpu.eax + this.getMicrocode());
            }
            case 155: {
                return this.cpu.fs.getDoubleWord(this.cpu.ecx + this.getMicrocode());
            }
            case 156: {
                return this.cpu.fs.getDoubleWord(this.cpu.edx + this.getMicrocode());
            }
            case 157: {
                return this.cpu.fs.getDoubleWord(this.cpu.ebx + this.getMicrocode());
            }
            case 158: {
                return this.cpu.fs.getDoubleWord(this.cpu.ebp + this.getMicrocode());
            }
            case 159: {
                return this.cpu.fs.getDoubleWord(this.cpu.esi + this.getMicrocode());
            }
            case 160: {
                return this.cpu.fs.getDoubleWord(this.cpu.edi + this.getMicrocode());
            }
            case 338: {
                return this.cpu.ds.getDoubleWord(this.cpu.eax + this.cpu.eax);
            }
            case 339: {
                return this.cpu.ds.getDoubleWord(this.cpu.eax + this.cpu.ecx);
            }
            case 340: {
                return this.cpu.ds.getDoubleWord(this.cpu.eax + this.cpu.edx);
            }
            case 341: {
                return this.cpu.ds.getDoubleWord(this.cpu.eax + this.cpu.ebx);
            }
            case 342: {
                return this.cpu.ds.getDoubleWord(this.cpu.eax + this.cpu.esp);
            }
            case 343: {
                return this.cpu.ds.getDoubleWord(this.cpu.eax + this.cpu.ebp);
            }
            case 344: {
                return this.cpu.ds.getDoubleWord(this.cpu.eax + this.cpu.esi);
            }
            case 345: {
                return this.cpu.ds.getDoubleWord(this.cpu.eax + this.cpu.edi);
            }
            case 346: {
                return this.cpu.ds.getDoubleWord(this.cpu.ecx + this.cpu.ecx);
            }
            case 347: {
                return this.cpu.ds.getDoubleWord(this.cpu.ecx + this.cpu.edx);
            }
            case 348: {
                return this.cpu.ds.getDoubleWord(this.cpu.ecx + this.cpu.ebx);
            }
            case 349: {
                return this.cpu.ds.getDoubleWord(this.cpu.ecx + this.cpu.esp);
            }
            case 350: {
                return this.cpu.ds.getDoubleWord(this.cpu.ecx + this.cpu.ebp);
            }
            case 351: {
                return this.cpu.ds.getDoubleWord(this.cpu.ecx + this.cpu.esi);
            }
            case 352: {
                return this.cpu.ds.getDoubleWord(this.cpu.ecx + this.cpu.edi);
            }
            case 353: {
                return this.cpu.ds.getDoubleWord(this.cpu.edx + this.cpu.edx);
            }
            case 354: {
                return this.cpu.ds.getDoubleWord(this.cpu.edx + this.cpu.ebx);
            }
            case 355: {
                return this.cpu.ds.getDoubleWord(this.cpu.edx + this.cpu.esp);
            }
            case 356: {
                return this.cpu.ds.getDoubleWord(this.cpu.edx + this.cpu.ebp);
            }
            case 357: {
                return this.cpu.ds.getDoubleWord(this.cpu.edx + this.cpu.esi);
            }
            case 358: {
                return this.cpu.ds.getDoubleWord(this.cpu.edx + this.cpu.edi);
            }
            case 359: {
                return this.cpu.ds.getDoubleWord(this.cpu.ebx + this.cpu.ebx);
            }
            case 360: {
                return this.cpu.ds.getDoubleWord(this.cpu.ebx + this.cpu.esp);
            }
            case 361: {
                return this.cpu.ds.getDoubleWord(this.cpu.ebx + this.cpu.ebp);
            }
            case 362: {
                return this.cpu.ds.getDoubleWord(this.cpu.ebx + this.cpu.esi);
            }
            case 363: {
                return this.cpu.ds.getDoubleWord(this.cpu.ebx + this.cpu.edi);
            }
            case 364: {
                return this.cpu.ds.getDoubleWord(this.cpu.esp);
            }
            case 365: {
                return this.cpu.ds.getDoubleWord(this.cpu.ebp + this.cpu.esp);
            }
            case 366: {
                return this.cpu.ds.getDoubleWord(this.cpu.ebp + this.cpu.esi);
            }
            case 367: {
                return this.cpu.ds.getDoubleWord(this.cpu.ebp + this.cpu.edi);
            }
            case 368: {
                return this.cpu.ds.getDoubleWord(this.cpu.esi + this.cpu.esp);
            }
            case 369: {
                return this.cpu.ds.getDoubleWord(this.cpu.esi + this.cpu.esi);
            }
            case 370: {
                return this.cpu.ds.getDoubleWord(this.cpu.esi + this.cpu.edi);
            }
            case 371: {
                return this.cpu.ds.getDoubleWord(this.cpu.edi + this.cpu.esp);
            }
            case 372: {
                return this.cpu.ds.getDoubleWord(this.cpu.edi + this.cpu.edi);
            }
            case 373: {
                return this.cpu.ds.getDoubleWord((this.cpu.eax << 1) + this.cpu.eax);
            }
            case 374: {
                return this.cpu.ds.getDoubleWord((this.cpu.eax << 1) + this.cpu.ecx);
            }
            case 375: {
                return this.cpu.ds.getDoubleWord((this.cpu.eax << 1) + this.cpu.edx);
            }
            case 376: {
                return this.cpu.ds.getDoubleWord((this.cpu.eax << 1) + this.cpu.ebx);
            }
            case 377: {
                return this.cpu.ds.getDoubleWord((this.cpu.eax << 1) + this.cpu.esp);
            }
            case 378: {
                return this.cpu.ds.getDoubleWord((this.cpu.eax << 1) + this.getMicrocode());
            }
            case 379: {
                return this.cpu.ds.getDoubleWord((this.cpu.eax << 1) + this.cpu.esi);
            }
            case 380: {
                return this.cpu.ds.getDoubleWord((this.cpu.eax << 1) + this.cpu.edi);
            }
            case 381: {
                return this.cpu.ds.getDoubleWord((this.cpu.ecx << 1) + this.cpu.eax);
            }
            case 382: {
                return this.cpu.ds.getDoubleWord((this.cpu.ecx << 1) + this.cpu.ecx);
            }
            case 383: {
                return this.cpu.ds.getDoubleWord((this.cpu.ecx << 1) + this.cpu.edx);
            }
            case 384: {
                return this.cpu.ds.getDoubleWord((this.cpu.ecx << 1) + this.cpu.ebx);
            }
            case 385: {
                return this.cpu.ds.getDoubleWord((this.cpu.ecx << 1) + this.cpu.esp);
            }
            case 386: {
                return this.cpu.ds.getDoubleWord((this.cpu.ecx << 1) + this.getMicrocode());
            }
            case 387: {
                return this.cpu.ds.getDoubleWord((this.cpu.ecx << 1) + this.cpu.esi);
            }
            case 388: {
                return this.cpu.ds.getDoubleWord((this.cpu.ecx << 1) + this.cpu.edi);
            }
            case 389: {
                return this.cpu.ds.getDoubleWord((this.cpu.edx << 1) + this.cpu.eax);
            }
            case 390: {
                return this.cpu.ds.getDoubleWord((this.cpu.edx << 1) + this.cpu.ecx);
            }
            case 391: {
                return this.cpu.ds.getDoubleWord((this.cpu.edx << 1) + this.cpu.edx);
            }
            case 392: {
                return this.cpu.ds.getDoubleWord((this.cpu.edx << 1) + this.cpu.ebx);
            }
            case 393: {
                return this.cpu.ds.getDoubleWord((this.cpu.edx << 1) + this.cpu.esp);
            }
            case 394: {
                return this.cpu.ds.getDoubleWord((this.cpu.edx << 1) + this.getMicrocode());
            }
            case 395: {
                return this.cpu.ds.getDoubleWord((this.cpu.edx << 1) + this.cpu.esi);
            }
            case 396: {
                return this.cpu.ds.getDoubleWord((this.cpu.edx << 1) + this.cpu.edi);
            }
            case 397: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebx << 1) + this.cpu.eax);
            }
            case 398: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebx << 1) + this.cpu.ecx);
            }
            case 399: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebx << 1) + this.cpu.edx);
            }
            case 400: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebx << 1) + this.cpu.ebx);
            }
            case 401: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebx << 1) + this.cpu.esp);
            }
            case 402: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebx << 1) + this.getMicrocode());
            }
            case 403: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebx << 1) + this.cpu.esi);
            }
            case 404: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebx << 1) + this.cpu.edi);
            }
            case 405: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebp << 1) + this.cpu.eax);
            }
            case 406: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebp << 1) + this.cpu.ecx);
            }
            case 407: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebp << 1) + this.cpu.edx);
            }
            case 408: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebp << 1) + this.cpu.ebx);
            }
            case 409: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebp << 1) + this.cpu.esp);
            }
            case 410: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebp << 1) + this.getMicrocode());
            }
            case 411: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebp << 1) + this.cpu.esi);
            }
            case 412: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebp << 1) + this.cpu.edi);
            }
            case 413: {
                return this.cpu.ds.getDoubleWord((this.cpu.esi << 1) + this.cpu.eax);
            }
            case 414: {
                return this.cpu.ds.getDoubleWord((this.cpu.esi << 1) + this.cpu.ecx);
            }
            case 415: {
                return this.cpu.ds.getDoubleWord((this.cpu.esi << 1) + this.cpu.edx);
            }
            case 416: {
                return this.cpu.ds.getDoubleWord((this.cpu.esi << 1) + this.cpu.ebx);
            }
            case 417: {
                return this.cpu.ds.getDoubleWord((this.cpu.esi << 1) + this.cpu.esp);
            }
            case 418: {
                return this.cpu.ds.getDoubleWord((this.cpu.esi << 1) + this.getMicrocode());
            }
            case 419: {
                return this.cpu.ds.getDoubleWord((this.cpu.esi << 1) + this.cpu.esi);
            }
            case 420: {
                return this.cpu.ds.getDoubleWord((this.cpu.esi << 1) + this.cpu.edi);
            }
            case 421: {
                return this.cpu.ds.getDoubleWord((this.cpu.edi << 1) + this.cpu.eax);
            }
            case 422: {
                return this.cpu.ds.getDoubleWord((this.cpu.edi << 1) + this.cpu.ecx);
            }
            case 423: {
                return this.cpu.ds.getDoubleWord((this.cpu.edi << 1) + this.cpu.edx);
            }
            case 424: {
                return this.cpu.ds.getDoubleWord((this.cpu.edi << 1) + this.cpu.ebx);
            }
            case 425: {
                return this.cpu.ds.getDoubleWord((this.cpu.edi << 1) + this.cpu.esp);
            }
            case 426: {
                return this.cpu.ds.getDoubleWord((this.cpu.edi << 1) + this.getMicrocode());
            }
            case 427: {
                return this.cpu.ds.getDoubleWord((this.cpu.edi << 1) + this.cpu.esi);
            }
            case 428: {
                return this.cpu.ds.getDoubleWord((this.cpu.edi << 1) + this.cpu.edi);
            }
            case 429: {
                return this.cpu.ds.getDoubleWord((this.cpu.eax << 2) + this.cpu.eax);
            }
            case 430: {
                return this.cpu.ds.getDoubleWord((this.cpu.eax << 2) + this.cpu.ecx);
            }
            case 431: {
                return this.cpu.ds.getDoubleWord((this.cpu.eax << 2) + this.cpu.edx);
            }
            case 432: {
                return this.cpu.ds.getDoubleWord((this.cpu.eax << 2) + this.cpu.ebx);
            }
            case 433: {
                return this.cpu.ds.getDoubleWord((this.cpu.eax << 2) + this.cpu.esp);
            }
            case 434: {
                return this.cpu.ds.getDoubleWord((this.cpu.eax << 2) + this.getMicrocode());
            }
            case 435: {
                return this.cpu.ds.getDoubleWord((this.cpu.eax << 2) + this.cpu.esi);
            }
            case 436: {
                return this.cpu.ds.getDoubleWord((this.cpu.eax << 2) + this.cpu.edi);
            }
            case 437: {
                return this.cpu.ds.getDoubleWord((this.cpu.ecx << 2) + this.cpu.eax);
            }
            case 438: {
                return this.cpu.ds.getDoubleWord((this.cpu.ecx << 2) + this.cpu.ecx);
            }
            case 439: {
                return this.cpu.ds.getDoubleWord((this.cpu.ecx << 2) + this.cpu.edx);
            }
            case 440: {
                return this.cpu.ds.getDoubleWord((this.cpu.ecx << 2) + this.cpu.ebx);
            }
            case 441: {
                return this.cpu.ds.getDoubleWord((this.cpu.ecx << 2) + this.cpu.esp);
            }
            case 442: {
                return this.cpu.ds.getDoubleWord((this.cpu.ecx << 2) + this.getMicrocode());
            }
            case 443: {
                return this.cpu.ds.getDoubleWord((this.cpu.ecx << 2) + this.cpu.esi);
            }
            case 444: {
                return this.cpu.ds.getDoubleWord((this.cpu.ecx << 2) + this.cpu.edi);
            }
            case 445: {
                return this.cpu.ds.getDoubleWord((this.cpu.edx << 2) + this.cpu.eax);
            }
            case 446: {
                return this.cpu.ds.getDoubleWord((this.cpu.edx << 2) + this.cpu.ecx);
            }
            case 447: {
                return this.cpu.ds.getDoubleWord((this.cpu.edx << 2) + this.cpu.edx);
            }
            case 448: {
                return this.cpu.ds.getDoubleWord((this.cpu.edx << 2) + this.cpu.ebx);
            }
            case 449: {
                return this.cpu.ds.getDoubleWord((this.cpu.edx << 2) + this.cpu.esp);
            }
            case 450: {
                return this.cpu.ds.getDoubleWord((this.cpu.edx << 2) + this.getMicrocode());
            }
            case 451: {
                return this.cpu.ds.getDoubleWord((this.cpu.edx << 2) + this.cpu.esi);
            }
            case 452: {
                return this.cpu.ds.getDoubleWord((this.cpu.edx << 2) + this.cpu.edi);
            }
            case 453: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebx << 2) + this.cpu.eax);
            }
            case 454: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebx << 2) + this.cpu.ecx);
            }
            case 455: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebx << 2) + this.cpu.edx);
            }
            case 456: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebx << 2) + this.cpu.ebx);
            }
            case 457: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebx << 2) + this.cpu.esp);
            }
            case 458: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebx << 2) + this.getMicrocode());
            }
            case 459: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebx << 2) + this.cpu.esi);
            }
            case 460: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebx << 2) + this.cpu.edi);
            }
            case 461: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebp << 2) + this.cpu.eax);
            }
            case 462: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebp << 2) + this.cpu.ecx);
            }
            case 463: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebp << 2) + this.cpu.edx);
            }
            case 464: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebp << 2) + this.cpu.ebx);
            }
            case 465: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebp << 2) + this.cpu.esp);
            }
            case 466: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebp << 2) + this.getMicrocode());
            }
            case 467: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebp << 2) + this.cpu.esi);
            }
            case 468: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebp << 2) + this.cpu.edi);
            }
            case 469: {
                return this.cpu.ds.getDoubleWord((this.cpu.esi << 2) + this.cpu.eax);
            }
            case 470: {
                return this.cpu.ds.getDoubleWord((this.cpu.esi << 2) + this.cpu.ecx);
            }
            case 471: {
                return this.cpu.ds.getDoubleWord((this.cpu.esi << 2) + this.cpu.edx);
            }
            case 472: {
                return this.cpu.ds.getDoubleWord((this.cpu.esi << 2) + this.cpu.ebx);
            }
            case 473: {
                return this.cpu.ds.getDoubleWord((this.cpu.esi << 2) + this.cpu.esp);
            }
            case 474: {
                return this.cpu.ds.getDoubleWord((this.cpu.esi << 2) + this.getMicrocode());
            }
            case 475: {
                return this.cpu.ds.getDoubleWord((this.cpu.esi << 2) + this.cpu.esi);
            }
            case 476: {
                return this.cpu.ds.getDoubleWord((this.cpu.esi << 2) + this.cpu.edi);
            }
            case 477: {
                return this.cpu.ds.getDoubleWord((this.cpu.edi << 2) + this.cpu.eax);
            }
            case 478: {
                return this.cpu.ds.getDoubleWord((this.cpu.edi << 2) + this.cpu.ecx);
            }
            case 479: {
                return this.cpu.ds.getDoubleWord((this.cpu.edi << 2) + this.cpu.edx);
            }
            case 480: {
                return this.cpu.ds.getDoubleWord((this.cpu.edi << 2) + this.cpu.ebx);
            }
            case 481: {
                return this.cpu.ds.getDoubleWord((this.cpu.edi << 2) + this.cpu.esp);
            }
            case 482: {
                return this.cpu.ds.getDoubleWord((this.cpu.edi << 2) + this.getMicrocode());
            }
            case 483: {
                return this.cpu.ds.getDoubleWord((this.cpu.edi << 2) + this.cpu.esi);
            }
            case 484: {
                return this.cpu.ds.getDoubleWord((this.cpu.edi << 2) + this.cpu.edi);
            }
            case 485: {
                return this.cpu.ds.getDoubleWord((this.cpu.eax << 3) + this.cpu.eax);
            }
            case 486: {
                return this.cpu.ds.getDoubleWord((this.cpu.eax << 3) + this.cpu.ecx);
            }
            case 487: {
                return this.cpu.ds.getDoubleWord((this.cpu.eax << 3) + this.cpu.edx);
            }
            case 488: {
                return this.cpu.ds.getDoubleWord((this.cpu.eax << 3) + this.cpu.ebx);
            }
            case 489: {
                return this.cpu.ds.getDoubleWord((this.cpu.eax << 3) + this.cpu.esp);
            }
            case 490: {
                return this.cpu.ds.getDoubleWord((this.cpu.eax << 3) + this.getMicrocode());
            }
            case 491: {
                return this.cpu.ds.getDoubleWord((this.cpu.eax << 3) + this.cpu.esi);
            }
            case 492: {
                return this.cpu.ds.getDoubleWord((this.cpu.eax << 3) + this.cpu.edi);
            }
            case 493: {
                return this.cpu.ds.getDoubleWord((this.cpu.ecx << 3) + this.cpu.eax);
            }
            case 494: {
                return this.cpu.ds.getDoubleWord((this.cpu.ecx << 3) + this.cpu.ecx);
            }
            case 495: {
                return this.cpu.ds.getDoubleWord((this.cpu.ecx << 3) + this.cpu.edx);
            }
            case 496: {
                return this.cpu.ds.getDoubleWord((this.cpu.ecx << 3) + this.cpu.ebx);
            }
            case 497: {
                return this.cpu.ds.getDoubleWord((this.cpu.ecx << 3) + this.cpu.esp);
            }
            case 498: {
                return this.cpu.ds.getDoubleWord((this.cpu.ecx << 3) + this.getMicrocode());
            }
            case 499: {
                return this.cpu.ds.getDoubleWord((this.cpu.ecx << 3) + this.cpu.esi);
            }
            case 500: {
                return this.cpu.ds.getDoubleWord((this.cpu.ecx << 3) + this.cpu.edi);
            }
            case 501: {
                return this.cpu.ds.getDoubleWord((this.cpu.edx << 3) + this.cpu.eax);
            }
            case 502: {
                return this.cpu.ds.getDoubleWord((this.cpu.edx << 3) + this.cpu.ecx);
            }
            case 503: {
                return this.cpu.ds.getDoubleWord((this.cpu.edx << 3) + this.cpu.edx);
            }
            case 504: {
                return this.cpu.ds.getDoubleWord((this.cpu.edx << 3) + this.cpu.ebx);
            }
            case 505: {
                return this.cpu.ds.getDoubleWord((this.cpu.edx << 3) + this.cpu.esp);
            }
            case 506: {
                return this.cpu.ds.getDoubleWord((this.cpu.edx << 3) + this.getMicrocode());
            }
            case 507: {
                return this.cpu.ds.getDoubleWord((this.cpu.edx << 3) + this.cpu.esi);
            }
            case 508: {
                return this.cpu.ds.getDoubleWord((this.cpu.edx << 3) + this.cpu.edi);
            }
            case 509: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebx << 3) + this.cpu.eax);
            }
            case 510: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebx << 3) + this.cpu.ecx);
            }
            case 511: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebx << 3) + this.cpu.edx);
            }
            case 512: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebx << 3) + this.cpu.ebx);
            }
            case 513: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebx << 3) + this.cpu.esp);
            }
            case 514: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebx << 3) + this.getMicrocode());
            }
            case 515: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebx << 3) + this.cpu.esi);
            }
            case 516: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebx << 3) + this.cpu.edi);
            }
            case 517: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebp << 3) + this.cpu.eax);
            }
            case 518: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebp << 3) + this.cpu.ecx);
            }
            case 519: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebp << 3) + this.cpu.edx);
            }
            case 520: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebp << 3) + this.cpu.ebx);
            }
            case 521: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebp << 3) + this.cpu.esp);
            }
            case 522: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebp << 3) + this.getMicrocode());
            }
            case 523: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebp << 3) + this.cpu.esi);
            }
            case 524: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebp << 3) + this.cpu.edi);
            }
            case 525: {
                return this.cpu.ds.getDoubleWord((this.cpu.esi << 3) + this.cpu.eax);
            }
            case 526: {
                return this.cpu.ds.getDoubleWord((this.cpu.esi << 3) + this.cpu.ecx);
            }
            case 527: {
                return this.cpu.ds.getDoubleWord((this.cpu.esi << 3) + this.cpu.edx);
            }
            case 528: {
                return this.cpu.ds.getDoubleWord((this.cpu.esi << 3) + this.cpu.ebx);
            }
            case 529: {
                return this.cpu.ds.getDoubleWord((this.cpu.esi << 3) + this.cpu.esp);
            }
            case 530: {
                return this.cpu.ds.getDoubleWord((this.cpu.esi << 3) + this.getMicrocode());
            }
            case 531: {
                return this.cpu.ds.getDoubleWord((this.cpu.esi << 3) + this.cpu.esi);
            }
            case 532: {
                return this.cpu.ds.getDoubleWord((this.cpu.esi << 3) + this.cpu.edi);
            }
            case 533: {
                return this.cpu.ds.getDoubleWord((this.cpu.edi << 3) + this.cpu.eax);
            }
            case 534: {
                return this.cpu.ds.getDoubleWord((this.cpu.edi << 3) + this.cpu.ecx);
            }
            case 535: {
                return this.cpu.ds.getDoubleWord((this.cpu.edi << 3) + this.cpu.edx);
            }
            case 536: {
                return this.cpu.ds.getDoubleWord((this.cpu.edi << 3) + this.cpu.ebx);
            }
            case 537: {
                return this.cpu.ds.getDoubleWord((this.cpu.edi << 3) + this.cpu.esp);
            }
            case 538: {
                return this.cpu.ds.getDoubleWord((this.cpu.edi << 3) + this.getMicrocode());
            }
            case 539: {
                return this.cpu.ds.getDoubleWord((this.cpu.edi << 3) + this.cpu.esi);
            }
            case 540: {
                return this.cpu.ds.getDoubleWord((this.cpu.edi << 3) + this.cpu.edi);
            }
            case 541: {
                return this.cpu.ds.getDoubleWord(this.cpu.eax + this.cpu.eax + this.getMicrocode());
            }
            case 542: {
                return this.cpu.ds.getDoubleWord(this.cpu.eax + this.cpu.ecx + this.getMicrocode());
            }
            case 543: {
                return this.cpu.ds.getDoubleWord(this.cpu.eax + this.cpu.edx + this.getMicrocode());
            }
            case 544: {
                return this.cpu.ds.getDoubleWord(this.cpu.eax + this.cpu.ebx + this.getMicrocode());
            }
            case 545: {
                return this.cpu.ds.getDoubleWord(this.cpu.eax + this.cpu.esp + this.getMicrocode());
            }
            case 546: {
                return this.cpu.ds.getDoubleWord(this.cpu.eax + this.cpu.ebp + this.getMicrocode());
            }
            case 547: {
                return this.cpu.ds.getDoubleWord(this.cpu.eax + this.cpu.esi + this.getMicrocode());
            }
            case 548: {
                return this.cpu.ds.getDoubleWord(this.cpu.eax + this.cpu.edi + this.getMicrocode());
            }
            case 549: {
                return this.cpu.ds.getDoubleWord(this.cpu.ecx + this.cpu.ecx + this.getMicrocode());
            }
            case 550: {
                return this.cpu.ds.getDoubleWord(this.cpu.ecx + this.cpu.edx + this.getMicrocode());
            }
            case 551: {
                return this.cpu.ds.getDoubleWord(this.cpu.ecx + this.cpu.ebx + this.getMicrocode());
            }
            case 552: {
                return this.cpu.ds.getDoubleWord(this.cpu.ecx + this.cpu.esp + this.getMicrocode());
            }
            case 553: {
                return this.cpu.ds.getDoubleWord(this.cpu.ecx + this.cpu.ebp + this.getMicrocode());
            }
            case 554: {
                return this.cpu.ds.getDoubleWord(this.cpu.ecx + this.cpu.esi + this.getMicrocode());
            }
            case 555: {
                return this.cpu.ds.getDoubleWord(this.cpu.ecx + this.cpu.edi + this.getMicrocode());
            }
            case 556: {
                return this.cpu.ds.getDoubleWord(this.cpu.edx + this.cpu.edx + this.getMicrocode());
            }
            case 557: {
                return this.cpu.ds.getDoubleWord(this.cpu.edx + this.cpu.ebx + this.getMicrocode());
            }
            case 558: {
                return this.cpu.ds.getDoubleWord(this.cpu.edx + this.cpu.esp + this.getMicrocode());
            }
            case 559: {
                return this.cpu.ds.getDoubleWord(this.cpu.edx + this.cpu.ebp + this.getMicrocode());
            }
            case 560: {
                return this.cpu.ds.getDoubleWord(this.cpu.edx + this.cpu.esi + this.getMicrocode());
            }
            case 561: {
                return this.cpu.ds.getDoubleWord(this.cpu.edx + this.cpu.edi + this.getMicrocode());
            }
            case 562: {
                return this.cpu.ds.getDoubleWord(this.cpu.ebx + this.cpu.ebx + this.getMicrocode());
            }
            case 563: {
                return this.cpu.ds.getDoubleWord(this.cpu.ebx + this.cpu.esp + this.getMicrocode());
            }
            case 564: {
                return this.cpu.ds.getDoubleWord(this.cpu.ebx + this.cpu.ebp + this.getMicrocode());
            }
            case 565: {
                return this.cpu.ds.getDoubleWord(this.cpu.ebx + this.cpu.esi + this.getMicrocode());
            }
            case 566: {
                return this.cpu.ds.getDoubleWord(this.cpu.ebx + this.cpu.edi + this.getMicrocode());
            }
            case 567: {
                return this.cpu.ds.getDoubleWord(this.cpu.esp + this.getMicrocode());
            }
            case 568: {
                return this.cpu.ds.getDoubleWord(this.cpu.ebp + this.cpu.esp + this.getMicrocode());
            }
            case 569: {
                return this.cpu.ds.getDoubleWord(this.cpu.ebp + this.cpu.ebp + this.getMicrocode());
            }
            case 570: {
                return this.cpu.ds.getDoubleWord(this.cpu.ebp + this.cpu.esi + this.getMicrocode());
            }
            case 571: {
                return this.cpu.ds.getDoubleWord(this.cpu.ebp + this.cpu.edi + this.getMicrocode());
            }
            case 572: {
                return this.cpu.ds.getDoubleWord(this.cpu.esi + this.cpu.esp + this.getMicrocode());
            }
            case 573: {
                return this.cpu.ds.getDoubleWord(this.cpu.esi + this.cpu.esi + this.getMicrocode());
            }
            case 574: {
                return this.cpu.ds.getDoubleWord(this.cpu.esi + this.cpu.edi + this.getMicrocode());
            }
            case 575: {
                return this.cpu.ds.getDoubleWord(this.cpu.edi + this.cpu.esp + this.getMicrocode());
            }
            case 576: {
                return this.cpu.ds.getDoubleWord(this.cpu.edi + this.cpu.edi + this.getMicrocode());
            }
            case 577: {
                return this.cpu.ds.getDoubleWord((this.cpu.eax << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 578: {
                return this.cpu.ds.getDoubleWord((this.cpu.eax << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 579: {
                return this.cpu.ds.getDoubleWord((this.cpu.eax << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 580: {
                return this.cpu.ds.getDoubleWord((this.cpu.eax << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 581: {
                return this.cpu.ds.getDoubleWord((this.cpu.eax << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 582: {
                return this.cpu.ds.getDoubleWord((this.cpu.eax << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 583: {
                return this.cpu.ds.getDoubleWord((this.cpu.eax << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 584: {
                return this.cpu.ds.getDoubleWord((this.cpu.eax << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 585: {
                return this.cpu.ds.getDoubleWord((this.cpu.ecx << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 586: {
                return this.cpu.ds.getDoubleWord((this.cpu.ecx << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 587: {
                return this.cpu.ds.getDoubleWord((this.cpu.ecx << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 588: {
                return this.cpu.ds.getDoubleWord((this.cpu.ecx << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 589: {
                return this.cpu.ds.getDoubleWord((this.cpu.ecx << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 590: {
                return this.cpu.ds.getDoubleWord((this.cpu.ecx << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 591: {
                return this.cpu.ds.getDoubleWord((this.cpu.ecx << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 592: {
                return this.cpu.ds.getDoubleWord((this.cpu.ecx << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 593: {
                return this.cpu.ds.getDoubleWord((this.cpu.edx << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 594: {
                return this.cpu.ds.getDoubleWord((this.cpu.edx << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 595: {
                return this.cpu.ds.getDoubleWord((this.cpu.edx << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 596: {
                return this.cpu.ds.getDoubleWord((this.cpu.edx << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 597: {
                return this.cpu.ds.getDoubleWord((this.cpu.edx << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 598: {
                return this.cpu.ds.getDoubleWord((this.cpu.edx << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 599: {
                return this.cpu.ds.getDoubleWord((this.cpu.edx << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 600: {
                return this.cpu.ds.getDoubleWord((this.cpu.edx << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 601: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebx << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 602: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebx << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 603: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebx << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 604: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebx << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 605: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebx << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 606: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebx << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 607: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebx << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 608: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebx << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 609: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebp << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 610: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebp << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 611: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebp << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 612: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebp << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 613: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebp << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 614: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebp << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 615: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebp << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 616: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebp << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 617: {
                return this.cpu.ds.getDoubleWord((this.cpu.esi << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 618: {
                return this.cpu.ds.getDoubleWord((this.cpu.esi << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 619: {
                return this.cpu.ds.getDoubleWord((this.cpu.esi << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 620: {
                return this.cpu.ds.getDoubleWord((this.cpu.esi << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 621: {
                return this.cpu.ds.getDoubleWord((this.cpu.esi << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 622: {
                return this.cpu.ds.getDoubleWord((this.cpu.esi << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 623: {
                return this.cpu.ds.getDoubleWord((this.cpu.esi << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 624: {
                return this.cpu.ds.getDoubleWord((this.cpu.esi << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 625: {
                return this.cpu.ds.getDoubleWord((this.cpu.edi << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 626: {
                return this.cpu.ds.getDoubleWord((this.cpu.edi << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 627: {
                return this.cpu.ds.getDoubleWord((this.cpu.edi << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 628: {
                return this.cpu.ds.getDoubleWord((this.cpu.edi << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 629: {
                return this.cpu.ds.getDoubleWord((this.cpu.edi << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 630: {
                return this.cpu.ds.getDoubleWord((this.cpu.edi << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 631: {
                return this.cpu.ds.getDoubleWord((this.cpu.edi << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 632: {
                return this.cpu.ds.getDoubleWord((this.cpu.edi << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 633: {
                return this.cpu.ds.getDoubleWord((this.cpu.eax << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 634: {
                return this.cpu.ds.getDoubleWord((this.cpu.eax << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 635: {
                return this.cpu.ds.getDoubleWord((this.cpu.eax << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 636: {
                return this.cpu.ds.getDoubleWord((this.cpu.eax << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 637: {
                return this.cpu.ds.getDoubleWord((this.cpu.eax << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 638: {
                return this.cpu.ds.getDoubleWord((this.cpu.eax << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 639: {
                return this.cpu.ds.getDoubleWord((this.cpu.eax << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 640: {
                return this.cpu.ds.getDoubleWord((this.cpu.eax << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 641: {
                return this.cpu.ds.getDoubleWord((this.cpu.ecx << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 642: {
                return this.cpu.ds.getDoubleWord((this.cpu.ecx << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 643: {
                return this.cpu.ds.getDoubleWord((this.cpu.ecx << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 644: {
                return this.cpu.ds.getDoubleWord((this.cpu.ecx << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 645: {
                return this.cpu.ds.getDoubleWord((this.cpu.ecx << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 646: {
                return this.cpu.ds.getDoubleWord((this.cpu.ecx << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 647: {
                return this.cpu.ds.getDoubleWord((this.cpu.ecx << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 648: {
                return this.cpu.ds.getDoubleWord((this.cpu.ecx << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 649: {
                return this.cpu.ds.getDoubleWord((this.cpu.edx << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 650: {
                return this.cpu.ds.getDoubleWord((this.cpu.edx << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 651: {
                return this.cpu.ds.getDoubleWord((this.cpu.edx << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 652: {
                return this.cpu.ds.getDoubleWord((this.cpu.edx << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 653: {
                return this.cpu.ds.getDoubleWord((this.cpu.edx << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 654: {
                return this.cpu.ds.getDoubleWord((this.cpu.edx << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 655: {
                return this.cpu.ds.getDoubleWord((this.cpu.edx << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 656: {
                return this.cpu.ds.getDoubleWord((this.cpu.edx << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 657: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebx << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 658: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebx << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 659: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebx << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 660: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebx << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 661: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebx << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 662: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebx << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 663: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebx << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 664: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebx << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 665: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebp << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 666: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebp << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 667: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebp << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 668: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebp << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 669: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebp << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 670: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebp << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 671: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebp << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 672: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebp << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 673: {
                return this.cpu.ds.getDoubleWord((this.cpu.esi << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 674: {
                return this.cpu.ds.getDoubleWord((this.cpu.esi << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 675: {
                return this.cpu.ds.getDoubleWord((this.cpu.esi << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 676: {
                return this.cpu.ds.getDoubleWord((this.cpu.esi << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 677: {
                return this.cpu.ds.getDoubleWord((this.cpu.esi << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 678: {
                return this.cpu.ds.getDoubleWord((this.cpu.esi << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 679: {
                return this.cpu.ds.getDoubleWord((this.cpu.esi << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 680: {
                return this.cpu.ds.getDoubleWord((this.cpu.esi << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 681: {
                return this.cpu.ds.getDoubleWord((this.cpu.edi << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 682: {
                return this.cpu.ds.getDoubleWord((this.cpu.edi << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 683: {
                return this.cpu.ds.getDoubleWord((this.cpu.edi << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 684: {
                return this.cpu.ds.getDoubleWord((this.cpu.edi << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 685: {
                return this.cpu.ds.getDoubleWord((this.cpu.edi << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 686: {
                return this.cpu.ds.getDoubleWord((this.cpu.edi << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 687: {
                return this.cpu.ds.getDoubleWord((this.cpu.edi << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 688: {
                return this.cpu.ds.getDoubleWord((this.cpu.edi << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 689: {
                return this.cpu.ds.getDoubleWord((this.cpu.eax << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 690: {
                return this.cpu.ds.getDoubleWord((this.cpu.eax << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 691: {
                return this.cpu.ds.getDoubleWord((this.cpu.eax << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 692: {
                return this.cpu.ds.getDoubleWord((this.cpu.eax << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 693: {
                return this.cpu.ds.getDoubleWord((this.cpu.eax << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 694: {
                return this.cpu.ds.getDoubleWord((this.cpu.eax << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 695: {
                return this.cpu.ds.getDoubleWord((this.cpu.eax << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 696: {
                return this.cpu.ds.getDoubleWord((this.cpu.eax << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 697: {
                return this.cpu.ds.getDoubleWord((this.cpu.ecx << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 698: {
                return this.cpu.ds.getDoubleWord((this.cpu.ecx << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 699: {
                return this.cpu.ds.getDoubleWord((this.cpu.ecx << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 700: {
                return this.cpu.ds.getDoubleWord((this.cpu.ecx << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 701: {
                return this.cpu.ds.getDoubleWord((this.cpu.ecx << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 702: {
                return this.cpu.ds.getDoubleWord((this.cpu.ecx << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 703: {
                return this.cpu.ds.getDoubleWord((this.cpu.ecx << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 704: {
                return this.cpu.ds.getDoubleWord((this.cpu.ecx << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 705: {
                return this.cpu.ds.getDoubleWord((this.cpu.edx << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 706: {
                return this.cpu.ds.getDoubleWord((this.cpu.edx << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 707: {
                return this.cpu.ds.getDoubleWord((this.cpu.edx << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 708: {
                return this.cpu.ds.getDoubleWord((this.cpu.edx << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 709: {
                return this.cpu.ds.getDoubleWord((this.cpu.edx << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 710: {
                return this.cpu.ds.getDoubleWord((this.cpu.edx << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 711: {
                return this.cpu.ds.getDoubleWord((this.cpu.edx << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 712: {
                return this.cpu.ds.getDoubleWord((this.cpu.edx << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 713: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebx << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 714: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebx << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 715: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebx << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 716: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebx << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 717: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebx << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 718: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebx << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 719: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebx << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 720: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebx << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 721: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebp << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 722: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebp << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 723: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebp << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 724: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebp << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 725: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebp << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 726: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebp << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 727: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebp << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 728: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebp << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 729: {
                return this.cpu.ds.getDoubleWord((this.cpu.esi << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 730: {
                return this.cpu.ds.getDoubleWord((this.cpu.esi << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 731: {
                return this.cpu.ds.getDoubleWord((this.cpu.esi << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 732: {
                return this.cpu.ds.getDoubleWord((this.cpu.esi << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 733: {
                return this.cpu.ds.getDoubleWord((this.cpu.esi << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 734: {
                return this.cpu.ds.getDoubleWord((this.cpu.esi << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 735: {
                return this.cpu.ds.getDoubleWord((this.cpu.esi << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 736: {
                return this.cpu.ds.getDoubleWord((this.cpu.esi << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 737: {
                return this.cpu.ds.getDoubleWord((this.cpu.edi << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 738: {
                return this.cpu.ds.getDoubleWord((this.cpu.edi << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 739: {
                return this.cpu.ds.getDoubleWord((this.cpu.edi << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 740: {
                return this.cpu.ds.getDoubleWord((this.cpu.edi << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 741: {
                return this.cpu.ds.getDoubleWord((this.cpu.edi << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 742: {
                return this.cpu.ds.getDoubleWord((this.cpu.edi << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 743: {
                return this.cpu.ds.getDoubleWord((this.cpu.edi << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 744: {
                return this.cpu.ds.getDoubleWord((this.cpu.edi << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 745: {
                return this.cpu.ds.getDoubleWord(this.cpu.eax + this.cpu.ecx + this.getMicrocode());
            }
            case 746: {
                return this.cpu.ds.getDoubleWord(this.cpu.eax + this.cpu.edx + this.getMicrocode());
            }
            case 747: {
                return this.cpu.ds.getDoubleWord(this.cpu.eax + this.cpu.ebx + this.getMicrocode());
            }
            case 748: {
                return this.cpu.ds.getDoubleWord(this.cpu.eax + this.cpu.esp + this.getMicrocode());
            }
            case 749: {
                return this.cpu.ds.getDoubleWord(this.cpu.eax + this.cpu.ebp + this.getMicrocode());
            }
            case 750: {
                return this.cpu.ds.getDoubleWord(this.cpu.eax + this.cpu.esi + this.getMicrocode());
            }
            case 751: {
                return this.cpu.ds.getDoubleWord(this.cpu.eax + this.cpu.edi + this.getMicrocode());
            }
            case 752: {
                return this.cpu.ds.getDoubleWord(this.cpu.ecx + this.cpu.edx + this.getMicrocode());
            }
            case 753: {
                return this.cpu.ds.getDoubleWord(this.cpu.ecx + this.cpu.ebx + this.getMicrocode());
            }
            case 754: {
                return this.cpu.ds.getDoubleWord(this.cpu.ecx + this.cpu.esp + this.getMicrocode());
            }
            case 755: {
                return this.cpu.ds.getDoubleWord(this.cpu.ecx + this.cpu.ebp + this.getMicrocode());
            }
            case 756: {
                return this.cpu.ds.getDoubleWord(this.cpu.ecx + this.cpu.esi + this.getMicrocode());
            }
            case 757: {
                return this.cpu.ds.getDoubleWord(this.cpu.ecx + this.cpu.edi + this.getMicrocode());
            }
            case 758: {
                return this.cpu.ds.getDoubleWord(this.cpu.edx + this.cpu.ebx + this.getMicrocode());
            }
            case 759: {
                return this.cpu.ds.getDoubleWord(this.cpu.edx + this.cpu.esp + this.getMicrocode());
            }
            case 760: {
                return this.cpu.ds.getDoubleWord(this.cpu.edx + this.cpu.ebp + this.getMicrocode());
            }
            case 761: {
                return this.cpu.ds.getDoubleWord(this.cpu.edx + this.cpu.esi + this.getMicrocode());
            }
            case 762: {
                return this.cpu.ds.getDoubleWord(this.cpu.edx + this.cpu.edi + this.getMicrocode());
            }
            case 763: {
                return this.cpu.ds.getDoubleWord(this.cpu.ebx + this.cpu.esp + this.getMicrocode());
            }
            case 764: {
                return this.cpu.ds.getDoubleWord(this.cpu.ebx + this.cpu.ebp + this.getMicrocode());
            }
            case 765: {
                return this.cpu.ds.getDoubleWord(this.cpu.ebx + this.cpu.esi + this.getMicrocode());
            }
            case 766: {
                return this.cpu.ds.getDoubleWord(this.cpu.ebx + this.cpu.edi + this.getMicrocode());
            }
            case 767: {
                return this.cpu.ds.getDoubleWord(this.cpu.esp + this.getMicrocode());
            }
            case 768: {
                return this.cpu.ds.getDoubleWord(this.cpu.ebp + this.cpu.esp + this.getMicrocode());
            }
            case 769: {
                return this.cpu.ds.getDoubleWord(this.cpu.ebp + this.cpu.esi + this.getMicrocode());
            }
            case 770: {
                return this.cpu.ds.getDoubleWord(this.cpu.ebp + this.cpu.edi + this.getMicrocode());
            }
            case 771: {
                return this.cpu.ds.getDoubleWord(this.cpu.esi + this.cpu.esp + this.getMicrocode());
            }
            case 772: {
                return this.cpu.ds.getDoubleWord(this.cpu.esi + this.cpu.edi + this.getMicrocode());
            }
            case 773: {
                return this.cpu.ds.getDoubleWord(this.cpu.edi + this.cpu.esp + this.getMicrocode());
            }
            case 774: {
                return this.cpu.ds.getDoubleWord((this.cpu.eax << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 775: {
                return this.cpu.ds.getDoubleWord((this.cpu.eax << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 776: {
                return this.cpu.ds.getDoubleWord((this.cpu.eax << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 777: {
                return this.cpu.ds.getDoubleWord((this.cpu.eax << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 778: {
                return this.cpu.ds.getDoubleWord((this.cpu.eax << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 779: {
                return this.cpu.ds.getDoubleWord((this.cpu.eax << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 780: {
                return this.cpu.ds.getDoubleWord((this.cpu.eax << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 781: {
                return this.cpu.ds.getDoubleWord((this.cpu.eax << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 782: {
                return this.cpu.ds.getDoubleWord((this.cpu.ecx << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 783: {
                return this.cpu.ds.getDoubleWord((this.cpu.ecx << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 784: {
                return this.cpu.ds.getDoubleWord((this.cpu.ecx << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 785: {
                return this.cpu.ds.getDoubleWord((this.cpu.ecx << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 786: {
                return this.cpu.ds.getDoubleWord((this.cpu.ecx << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 787: {
                return this.cpu.ds.getDoubleWord((this.cpu.ecx << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 788: {
                return this.cpu.ds.getDoubleWord((this.cpu.ecx << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 789: {
                return this.cpu.ds.getDoubleWord((this.cpu.ecx << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 790: {
                return this.cpu.ds.getDoubleWord((this.cpu.edx << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 791: {
                return this.cpu.ds.getDoubleWord((this.cpu.edx << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 792: {
                return this.cpu.ds.getDoubleWord((this.cpu.edx << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 793: {
                return this.cpu.ds.getDoubleWord((this.cpu.edx << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 794: {
                return this.cpu.ds.getDoubleWord((this.cpu.edx << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 795: {
                return this.cpu.ds.getDoubleWord((this.cpu.edx << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 796: {
                return this.cpu.ds.getDoubleWord((this.cpu.edx << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 797: {
                return this.cpu.ds.getDoubleWord((this.cpu.edx << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 798: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebx << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 799: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebx << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 800: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebx << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 801: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebx << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 802: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebx << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 803: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebx << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 804: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebx << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 805: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebx << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 806: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebp << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 807: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebp << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 808: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebp << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 809: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebp << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 810: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebp << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 811: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebp << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 812: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebp << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 813: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebp << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 814: {
                return this.cpu.ds.getDoubleWord((this.cpu.esi << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 815: {
                return this.cpu.ds.getDoubleWord((this.cpu.esi << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 816: {
                return this.cpu.ds.getDoubleWord((this.cpu.esi << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 817: {
                return this.cpu.ds.getDoubleWord((this.cpu.esi << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 818: {
                return this.cpu.ds.getDoubleWord((this.cpu.esi << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 819: {
                return this.cpu.ds.getDoubleWord((this.cpu.esi << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 820: {
                return this.cpu.ds.getDoubleWord((this.cpu.esi << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 821: {
                return this.cpu.ds.getDoubleWord((this.cpu.esi << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 822: {
                return this.cpu.ds.getDoubleWord((this.cpu.edi << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 823: {
                return this.cpu.ds.getDoubleWord((this.cpu.edi << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 824: {
                return this.cpu.ds.getDoubleWord((this.cpu.edi << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 825: {
                return this.cpu.ds.getDoubleWord((this.cpu.edi << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 826: {
                return this.cpu.ds.getDoubleWord((this.cpu.edi << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 827: {
                return this.cpu.ds.getDoubleWord((this.cpu.edi << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 828: {
                return this.cpu.ds.getDoubleWord((this.cpu.edi << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 829: {
                return this.cpu.ds.getDoubleWord((this.cpu.edi << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 830: {
                return this.cpu.ds.getDoubleWord((this.cpu.eax << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 831: {
                return this.cpu.ds.getDoubleWord((this.cpu.eax << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 832: {
                return this.cpu.ds.getDoubleWord((this.cpu.eax << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 833: {
                return this.cpu.ds.getDoubleWord((this.cpu.eax << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 834: {
                return this.cpu.ds.getDoubleWord((this.cpu.eax << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 835: {
                return this.cpu.ds.getDoubleWord((this.cpu.eax << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 836: {
                return this.cpu.ds.getDoubleWord((this.cpu.eax << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 837: {
                return this.cpu.ds.getDoubleWord((this.cpu.eax << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 838: {
                return this.cpu.ds.getDoubleWord((this.cpu.ecx << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 839: {
                return this.cpu.ds.getDoubleWord((this.cpu.ecx << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 840: {
                return this.cpu.ds.getDoubleWord((this.cpu.ecx << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 841: {
                return this.cpu.ds.getDoubleWord((this.cpu.ecx << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 842: {
                return this.cpu.ds.getDoubleWord((this.cpu.ecx << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 843: {
                return this.cpu.ds.getDoubleWord((this.cpu.ecx << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 844: {
                return this.cpu.ds.getDoubleWord((this.cpu.ecx << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 845: {
                return this.cpu.ds.getDoubleWord((this.cpu.ecx << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 846: {
                return this.cpu.ds.getDoubleWord((this.cpu.edx << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 847: {
                return this.cpu.ds.getDoubleWord((this.cpu.edx << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 848: {
                return this.cpu.ds.getDoubleWord((this.cpu.edx << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 849: {
                return this.cpu.ds.getDoubleWord((this.cpu.edx << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 850: {
                return this.cpu.ds.getDoubleWord((this.cpu.edx << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 851: {
                return this.cpu.ds.getDoubleWord((this.cpu.edx << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 852: {
                return this.cpu.ds.getDoubleWord((this.cpu.edx << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 853: {
                return this.cpu.ds.getDoubleWord((this.cpu.edx << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 854: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebx << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 855: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebx << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 856: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebx << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 857: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebx << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 858: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebx << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 859: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebx << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 860: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebx << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 861: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebx << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 862: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebp << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 863: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebp << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 864: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebp << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 865: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebp << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 866: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebp << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 867: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebp << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 868: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebp << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 869: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebp << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 870: {
                return this.cpu.ds.getDoubleWord((this.cpu.esi << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 871: {
                return this.cpu.ds.getDoubleWord((this.cpu.esi << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 872: {
                return this.cpu.ds.getDoubleWord((this.cpu.esi << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 873: {
                return this.cpu.ds.getDoubleWord((this.cpu.esi << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 874: {
                return this.cpu.ds.getDoubleWord((this.cpu.esi << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 875: {
                return this.cpu.ds.getDoubleWord((this.cpu.esi << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 876: {
                return this.cpu.ds.getDoubleWord((this.cpu.esi << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 877: {
                return this.cpu.ds.getDoubleWord((this.cpu.esi << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 878: {
                return this.cpu.ds.getDoubleWord((this.cpu.edi << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 879: {
                return this.cpu.ds.getDoubleWord((this.cpu.edi << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 880: {
                return this.cpu.ds.getDoubleWord((this.cpu.edi << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 881: {
                return this.cpu.ds.getDoubleWord((this.cpu.edi << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 882: {
                return this.cpu.ds.getDoubleWord((this.cpu.edi << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 883: {
                return this.cpu.ds.getDoubleWord((this.cpu.edi << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 884: {
                return this.cpu.ds.getDoubleWord((this.cpu.edi << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 885: {
                return this.cpu.ds.getDoubleWord((this.cpu.edi << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 886: {
                return this.cpu.ds.getDoubleWord((this.cpu.eax << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 887: {
                return this.cpu.ds.getDoubleWord((this.cpu.eax << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 888: {
                return this.cpu.ds.getDoubleWord((this.cpu.eax << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 889: {
                return this.cpu.ds.getDoubleWord((this.cpu.eax << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 890: {
                return this.cpu.ds.getDoubleWord((this.cpu.eax << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 891: {
                return this.cpu.ds.getDoubleWord((this.cpu.eax << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 892: {
                return this.cpu.ds.getDoubleWord((this.cpu.eax << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 893: {
                return this.cpu.ds.getDoubleWord((this.cpu.eax << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 894: {
                return this.cpu.ds.getDoubleWord((this.cpu.ecx << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 895: {
                return this.cpu.ds.getDoubleWord((this.cpu.ecx << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 896: {
                return this.cpu.ds.getDoubleWord((this.cpu.ecx << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 897: {
                return this.cpu.ds.getDoubleWord((this.cpu.ecx << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 898: {
                return this.cpu.ds.getDoubleWord((this.cpu.ecx << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 899: {
                return this.cpu.ds.getDoubleWord((this.cpu.ecx << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 900: {
                return this.cpu.ds.getDoubleWord((this.cpu.ecx << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 901: {
                return this.cpu.ds.getDoubleWord((this.cpu.ecx << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 902: {
                return this.cpu.ds.getDoubleWord((this.cpu.edx << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 903: {
                return this.cpu.ds.getDoubleWord((this.cpu.edx << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 904: {
                return this.cpu.ds.getDoubleWord((this.cpu.edx << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 905: {
                return this.cpu.ds.getDoubleWord((this.cpu.edx << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 906: {
                return this.cpu.ds.getDoubleWord((this.cpu.edx << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 907: {
                return this.cpu.ds.getDoubleWord((this.cpu.edx << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 908: {
                return this.cpu.ds.getDoubleWord((this.cpu.edx << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 909: {
                return this.cpu.ds.getDoubleWord((this.cpu.edx << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 910: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebx << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 911: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebx << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 912: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebx << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 913: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebx << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 914: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebx << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 915: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebx << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 916: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebx << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 917: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebx << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 918: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebp << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 919: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebp << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 920: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebp << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 921: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebp << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 922: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebp << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 923: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebp << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 924: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebp << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 925: {
                return this.cpu.ds.getDoubleWord((this.cpu.ebp << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 926: {
                return this.cpu.ds.getDoubleWord((this.cpu.esi << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 927: {
                return this.cpu.ds.getDoubleWord((this.cpu.esi << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 928: {
                return this.cpu.ds.getDoubleWord((this.cpu.esi << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 929: {
                return this.cpu.ds.getDoubleWord((this.cpu.esi << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 930: {
                return this.cpu.ds.getDoubleWord((this.cpu.esi << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 931: {
                return this.cpu.ds.getDoubleWord((this.cpu.esi << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 932: {
                return this.cpu.ds.getDoubleWord((this.cpu.esi << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 933: {
                return this.cpu.ds.getDoubleWord((this.cpu.esi << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 934: {
                return this.cpu.ds.getDoubleWord((this.cpu.edi << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 935: {
                return this.cpu.ds.getDoubleWord((this.cpu.edi << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 936: {
                return this.cpu.ds.getDoubleWord((this.cpu.edi << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 937: {
                return this.cpu.ds.getDoubleWord((this.cpu.edi << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 938: {
                return this.cpu.ds.getDoubleWord((this.cpu.edi << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 939: {
                return this.cpu.ds.getDoubleWord((this.cpu.edi << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 940: {
                return this.cpu.ds.getDoubleWord((this.cpu.edi << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 941: {
                return this.cpu.ds.getDoubleWord((this.cpu.edi << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 2150: {
                return this.cpu.ss.getDoubleWord(this.cpu.eax + this.cpu.eax);
            }
            case 2151: {
                return this.cpu.ss.getDoubleWord(this.cpu.eax + this.cpu.ecx);
            }
            case 2152: {
                return this.cpu.ss.getDoubleWord(this.cpu.eax + this.cpu.edx);
            }
            case 2153: {
                return this.cpu.ss.getDoubleWord(this.cpu.eax + this.cpu.ebx);
            }
            case 2154: {
                return this.cpu.ss.getDoubleWord(this.cpu.eax + this.cpu.esp);
            }
            case 2155: {
                return this.cpu.ss.getDoubleWord(this.cpu.eax + this.cpu.ebp);
            }
            case 2156: {
                return this.cpu.ss.getDoubleWord(this.cpu.eax + this.cpu.esi);
            }
            case 2157: {
                return this.cpu.ss.getDoubleWord(this.cpu.eax + this.cpu.edi);
            }
            case 2158: {
                return this.cpu.ss.getDoubleWord(this.cpu.ecx + this.cpu.ecx);
            }
            case 2159: {
                return this.cpu.ss.getDoubleWord(this.cpu.ecx + this.cpu.edx);
            }
            case 2160: {
                return this.cpu.ss.getDoubleWord(this.cpu.ecx + this.cpu.ebx);
            }
            case 2161: {
                return this.cpu.ss.getDoubleWord(this.cpu.ecx + this.cpu.esp);
            }
            case 2162: {
                return this.cpu.ss.getDoubleWord(this.cpu.ecx + this.cpu.ebp);
            }
            case 2163: {
                return this.cpu.ss.getDoubleWord(this.cpu.ecx + this.cpu.esi);
            }
            case 2164: {
                return this.cpu.ss.getDoubleWord(this.cpu.ecx + this.cpu.edi);
            }
            case 2165: {
                return this.cpu.ss.getDoubleWord(this.cpu.edx + this.cpu.edx);
            }
            case 2166: {
                return this.cpu.ss.getDoubleWord(this.cpu.edx + this.cpu.ebx);
            }
            case 2167: {
                return this.cpu.ss.getDoubleWord(this.cpu.edx + this.cpu.esp);
            }
            case 2168: {
                return this.cpu.ss.getDoubleWord(this.cpu.edx + this.cpu.ebp);
            }
            case 2169: {
                return this.cpu.ss.getDoubleWord(this.cpu.edx + this.cpu.esi);
            }
            case 2170: {
                return this.cpu.ss.getDoubleWord(this.cpu.edx + this.cpu.edi);
            }
            case 2171: {
                return this.cpu.ss.getDoubleWord(this.cpu.ebx + this.cpu.ebx);
            }
            case 2172: {
                return this.cpu.ss.getDoubleWord(this.cpu.ebx + this.cpu.esp);
            }
            case 2173: {
                return this.cpu.ss.getDoubleWord(this.cpu.ebx + this.cpu.ebp);
            }
            case 2174: {
                return this.cpu.ss.getDoubleWord(this.cpu.ebx + this.cpu.esi);
            }
            case 2175: {
                return this.cpu.ss.getDoubleWord(this.cpu.ebx + this.cpu.edi);
            }
            case 2176: {
                return this.cpu.ss.getDoubleWord(this.cpu.esp);
            }
            case 2177: {
                return this.cpu.ss.getDoubleWord(this.cpu.ebp + this.cpu.esp);
            }
            case 2178: {
                return this.cpu.ss.getDoubleWord(this.cpu.ebp + this.cpu.esi);
            }
            case 2179: {
                return this.cpu.ss.getDoubleWord(this.cpu.ebp + this.cpu.edi);
            }
            case 2180: {
                return this.cpu.ss.getDoubleWord(this.cpu.esi + this.cpu.esp);
            }
            case 2181: {
                return this.cpu.ss.getDoubleWord(this.cpu.esi + this.cpu.esi);
            }
            case 2182: {
                return this.cpu.ss.getDoubleWord(this.cpu.esi + this.cpu.edi);
            }
            case 2183: {
                return this.cpu.ss.getDoubleWord(this.cpu.edi + this.cpu.esp);
            }
            case 2184: {
                return this.cpu.ss.getDoubleWord(this.cpu.edi + this.cpu.edi);
            }
            case 2185: {
                return this.cpu.ss.getDoubleWord((this.cpu.eax << 1) + this.cpu.eax);
            }
            case 2186: {
                return this.cpu.ss.getDoubleWord((this.cpu.eax << 1) + this.cpu.ecx);
            }
            case 2187: {
                return this.cpu.ss.getDoubleWord((this.cpu.eax << 1) + this.cpu.edx);
            }
            case 2188: {
                return this.cpu.ss.getDoubleWord((this.cpu.eax << 1) + this.cpu.ebx);
            }
            case 2189: {
                return this.cpu.ss.getDoubleWord((this.cpu.eax << 1) + this.cpu.esp);
            }
            case 2190: {
                return this.cpu.ss.getDoubleWord((this.cpu.eax << 1) + this.getMicrocode());
            }
            case 2191: {
                return this.cpu.ss.getDoubleWord((this.cpu.eax << 1) + this.cpu.esi);
            }
            case 2192: {
                return this.cpu.ss.getDoubleWord((this.cpu.eax << 1) + this.cpu.edi);
            }
            case 2193: {
                return this.cpu.ss.getDoubleWord((this.cpu.ecx << 1) + this.cpu.eax);
            }
            case 2194: {
                return this.cpu.ss.getDoubleWord((this.cpu.ecx << 1) + this.cpu.ecx);
            }
            case 2195: {
                return this.cpu.ss.getDoubleWord((this.cpu.ecx << 1) + this.cpu.edx);
            }
            case 2196: {
                return this.cpu.ss.getDoubleWord((this.cpu.ecx << 1) + this.cpu.ebx);
            }
            case 2197: {
                return this.cpu.ss.getDoubleWord((this.cpu.ecx << 1) + this.cpu.esp);
            }
            case 2198: {
                return this.cpu.ss.getDoubleWord((this.cpu.ecx << 1) + this.getMicrocode());
            }
            case 2199: {
                return this.cpu.ss.getDoubleWord((this.cpu.ecx << 1) + this.cpu.esi);
            }
            case 2200: {
                return this.cpu.ss.getDoubleWord((this.cpu.ecx << 1) + this.cpu.edi);
            }
            case 2201: {
                return this.cpu.ss.getDoubleWord((this.cpu.edx << 1) + this.cpu.eax);
            }
            case 2202: {
                return this.cpu.ss.getDoubleWord((this.cpu.edx << 1) + this.cpu.ecx);
            }
            case 2203: {
                return this.cpu.ss.getDoubleWord((this.cpu.edx << 1) + this.cpu.edx);
            }
            case 2204: {
                return this.cpu.ss.getDoubleWord((this.cpu.edx << 1) + this.cpu.ebx);
            }
            case 2205: {
                return this.cpu.ss.getDoubleWord((this.cpu.edx << 1) + this.cpu.esp);
            }
            case 2206: {
                return this.cpu.ss.getDoubleWord((this.cpu.edx << 1) + this.getMicrocode());
            }
            case 2207: {
                return this.cpu.ss.getDoubleWord((this.cpu.edx << 1) + this.cpu.esi);
            }
            case 2208: {
                return this.cpu.ss.getDoubleWord((this.cpu.edx << 1) + this.cpu.edi);
            }
            case 2209: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebx << 1) + this.cpu.eax);
            }
            case 2210: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebx << 1) + this.cpu.ecx);
            }
            case 2211: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebx << 1) + this.cpu.edx);
            }
            case 2212: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebx << 1) + this.cpu.ebx);
            }
            case 2213: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebx << 1) + this.cpu.esp);
            }
            case 2214: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebx << 1) + this.getMicrocode());
            }
            case 2215: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebx << 1) + this.cpu.esi);
            }
            case 2216: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebx << 1) + this.cpu.edi);
            }
            case 2217: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebp << 1) + this.cpu.eax);
            }
            case 2218: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebp << 1) + this.cpu.ecx);
            }
            case 2219: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebp << 1) + this.cpu.edx);
            }
            case 2220: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebp << 1) + this.cpu.ebx);
            }
            case 2221: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebp << 1) + this.cpu.esp);
            }
            case 2222: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebp << 1) + this.getMicrocode());
            }
            case 2223: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebp << 1) + this.cpu.esi);
            }
            case 2224: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebp << 1) + this.cpu.edi);
            }
            case 2225: {
                return this.cpu.ss.getDoubleWord((this.cpu.esi << 1) + this.cpu.eax);
            }
            case 2226: {
                return this.cpu.ss.getDoubleWord((this.cpu.esi << 1) + this.cpu.ecx);
            }
            case 2227: {
                return this.cpu.ss.getDoubleWord((this.cpu.esi << 1) + this.cpu.edx);
            }
            case 2228: {
                return this.cpu.ss.getDoubleWord((this.cpu.esi << 1) + this.cpu.ebx);
            }
            case 2229: {
                return this.cpu.ss.getDoubleWord((this.cpu.esi << 1) + this.cpu.esp);
            }
            case 2230: {
                return this.cpu.ss.getDoubleWord((this.cpu.esi << 1) + this.getMicrocode());
            }
            case 2231: {
                return this.cpu.ss.getDoubleWord((this.cpu.esi << 1) + this.cpu.esi);
            }
            case 2232: {
                return this.cpu.ss.getDoubleWord((this.cpu.esi << 1) + this.cpu.edi);
            }
            case 2233: {
                return this.cpu.ss.getDoubleWord((this.cpu.edi << 1) + this.cpu.eax);
            }
            case 2234: {
                return this.cpu.ss.getDoubleWord((this.cpu.edi << 1) + this.cpu.ecx);
            }
            case 2235: {
                return this.cpu.ss.getDoubleWord((this.cpu.edi << 1) + this.cpu.edx);
            }
            case 2236: {
                return this.cpu.ss.getDoubleWord((this.cpu.edi << 1) + this.cpu.ebx);
            }
            case 2237: {
                return this.cpu.ss.getDoubleWord((this.cpu.edi << 1) + this.cpu.esp);
            }
            case 2238: {
                return this.cpu.ss.getDoubleWord((this.cpu.edi << 1) + this.getMicrocode());
            }
            case 2239: {
                return this.cpu.ss.getDoubleWord((this.cpu.edi << 1) + this.cpu.esi);
            }
            case 2240: {
                return this.cpu.ss.getDoubleWord((this.cpu.edi << 1) + this.cpu.edi);
            }
            case 2241: {
                return this.cpu.ss.getDoubleWord((this.cpu.eax << 2) + this.cpu.eax);
            }
            case 2242: {
                return this.cpu.ss.getDoubleWord((this.cpu.eax << 2) + this.cpu.ecx);
            }
            case 2243: {
                return this.cpu.ss.getDoubleWord((this.cpu.eax << 2) + this.cpu.edx);
            }
            case 2244: {
                return this.cpu.ss.getDoubleWord((this.cpu.eax << 2) + this.cpu.ebx);
            }
            case 2245: {
                return this.cpu.ss.getDoubleWord((this.cpu.eax << 2) + this.cpu.esp);
            }
            case 2246: {
                return this.cpu.ss.getDoubleWord((this.cpu.eax << 2) + this.getMicrocode());
            }
            case 2247: {
                return this.cpu.ss.getDoubleWord((this.cpu.eax << 2) + this.cpu.esi);
            }
            case 2248: {
                return this.cpu.ss.getDoubleWord((this.cpu.eax << 2) + this.cpu.edi);
            }
            case 2249: {
                return this.cpu.ss.getDoubleWord((this.cpu.ecx << 2) + this.cpu.eax);
            }
            case 2250: {
                return this.cpu.ss.getDoubleWord((this.cpu.ecx << 2) + this.cpu.ecx);
            }
            case 2251: {
                return this.cpu.ss.getDoubleWord((this.cpu.ecx << 2) + this.cpu.edx);
            }
            case 2252: {
                return this.cpu.ss.getDoubleWord((this.cpu.ecx << 2) + this.cpu.ebx);
            }
            case 2253: {
                return this.cpu.ss.getDoubleWord((this.cpu.ecx << 2) + this.cpu.esp);
            }
            case 2254: {
                return this.cpu.ss.getDoubleWord((this.cpu.ecx << 2) + this.getMicrocode());
            }
            case 2255: {
                return this.cpu.ss.getDoubleWord((this.cpu.ecx << 2) + this.cpu.esi);
            }
            case 2256: {
                return this.cpu.ss.getDoubleWord((this.cpu.ecx << 2) + this.cpu.edi);
            }
            case 2257: {
                return this.cpu.ss.getDoubleWord((this.cpu.edx << 2) + this.cpu.eax);
            }
            case 2258: {
                return this.cpu.ss.getDoubleWord((this.cpu.edx << 2) + this.cpu.ecx);
            }
            case 2259: {
                return this.cpu.ss.getDoubleWord((this.cpu.edx << 2) + this.cpu.edx);
            }
            case 2260: {
                return this.cpu.ss.getDoubleWord((this.cpu.edx << 2) + this.cpu.ebx);
            }
            case 2261: {
                return this.cpu.ss.getDoubleWord((this.cpu.edx << 2) + this.cpu.esp);
            }
            case 2262: {
                return this.cpu.ss.getDoubleWord((this.cpu.edx << 2) + this.getMicrocode());
            }
            case 2263: {
                return this.cpu.ss.getDoubleWord((this.cpu.edx << 2) + this.cpu.esi);
            }
            case 2264: {
                return this.cpu.ss.getDoubleWord((this.cpu.edx << 2) + this.cpu.edi);
            }
            case 2265: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebx << 2) + this.cpu.eax);
            }
            case 2266: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebx << 2) + this.cpu.ecx);
            }
            case 2267: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebx << 2) + this.cpu.edx);
            }
            case 2268: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebx << 2) + this.cpu.ebx);
            }
            case 2269: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebx << 2) + this.cpu.esp);
            }
            case 2270: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebx << 2) + this.getMicrocode());
            }
            case 2271: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebx << 2) + this.cpu.esi);
            }
            case 2272: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebx << 2) + this.cpu.edi);
            }
            case 2273: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebp << 2) + this.cpu.eax);
            }
            case 2274: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebp << 2) + this.cpu.ecx);
            }
            case 2275: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebp << 2) + this.cpu.edx);
            }
            case 2276: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebp << 2) + this.cpu.ebx);
            }
            case 2277: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebp << 2) + this.cpu.esp);
            }
            case 2278: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebp << 2) + this.getMicrocode());
            }
            case 2279: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebp << 2) + this.cpu.esi);
            }
            case 2280: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebp << 2) + this.cpu.edi);
            }
            case 2281: {
                return this.cpu.ss.getDoubleWord((this.cpu.esi << 2) + this.cpu.eax);
            }
            case 2282: {
                return this.cpu.ss.getDoubleWord((this.cpu.esi << 2) + this.cpu.ecx);
            }
            case 2283: {
                return this.cpu.ss.getDoubleWord((this.cpu.esi << 2) + this.cpu.edx);
            }
            case 2284: {
                return this.cpu.ss.getDoubleWord((this.cpu.esi << 2) + this.cpu.ebx);
            }
            case 2285: {
                return this.cpu.ss.getDoubleWord((this.cpu.esi << 2) + this.cpu.esp);
            }
            case 2286: {
                return this.cpu.ss.getDoubleWord((this.cpu.esi << 2) + this.getMicrocode());
            }
            case 2287: {
                return this.cpu.ss.getDoubleWord((this.cpu.esi << 2) + this.cpu.esi);
            }
            case 2288: {
                return this.cpu.ss.getDoubleWord((this.cpu.esi << 2) + this.cpu.edi);
            }
            case 2289: {
                return this.cpu.ss.getDoubleWord((this.cpu.edi << 2) + this.cpu.eax);
            }
            case 2290: {
                return this.cpu.ss.getDoubleWord((this.cpu.edi << 2) + this.cpu.ecx);
            }
            case 2291: {
                return this.cpu.ss.getDoubleWord((this.cpu.edi << 2) + this.cpu.edx);
            }
            case 2292: {
                return this.cpu.ss.getDoubleWord((this.cpu.edi << 2) + this.cpu.ebx);
            }
            case 2293: {
                return this.cpu.ss.getDoubleWord((this.cpu.edi << 2) + this.cpu.esp);
            }
            case 2294: {
                return this.cpu.ss.getDoubleWord((this.cpu.edi << 2) + this.getMicrocode());
            }
            case 2295: {
                return this.cpu.ss.getDoubleWord((this.cpu.edi << 2) + this.cpu.esi);
            }
            case 2296: {
                return this.cpu.ss.getDoubleWord((this.cpu.edi << 2) + this.cpu.edi);
            }
            case 2297: {
                return this.cpu.ss.getDoubleWord((this.cpu.eax << 3) + this.cpu.eax);
            }
            case 2298: {
                return this.cpu.ss.getDoubleWord((this.cpu.eax << 3) + this.cpu.ecx);
            }
            case 2299: {
                return this.cpu.ss.getDoubleWord((this.cpu.eax << 3) + this.cpu.edx);
            }
            case 2300: {
                return this.cpu.ss.getDoubleWord((this.cpu.eax << 3) + this.cpu.ebx);
            }
            case 2301: {
                return this.cpu.ss.getDoubleWord((this.cpu.eax << 3) + this.cpu.esp);
            }
            case 2302: {
                return this.cpu.ss.getDoubleWord((this.cpu.eax << 3) + this.getMicrocode());
            }
            case 2303: {
                return this.cpu.ss.getDoubleWord((this.cpu.eax << 3) + this.cpu.esi);
            }
            case 2304: {
                return this.cpu.ss.getDoubleWord((this.cpu.eax << 3) + this.cpu.edi);
            }
            case 2305: {
                return this.cpu.ss.getDoubleWord((this.cpu.ecx << 3) + this.cpu.eax);
            }
            case 2306: {
                return this.cpu.ss.getDoubleWord((this.cpu.ecx << 3) + this.cpu.ecx);
            }
            case 2307: {
                return this.cpu.ss.getDoubleWord((this.cpu.ecx << 3) + this.cpu.edx);
            }
            case 2308: {
                return this.cpu.ss.getDoubleWord((this.cpu.ecx << 3) + this.cpu.ebx);
            }
            case 2309: {
                return this.cpu.ss.getDoubleWord((this.cpu.ecx << 3) + this.cpu.esp);
            }
            case 2310: {
                return this.cpu.ss.getDoubleWord((this.cpu.ecx << 3) + this.getMicrocode());
            }
            case 2311: {
                return this.cpu.ss.getDoubleWord((this.cpu.ecx << 3) + this.cpu.esi);
            }
            case 2312: {
                return this.cpu.ss.getDoubleWord((this.cpu.ecx << 3) + this.cpu.edi);
            }
            case 2313: {
                return this.cpu.ss.getDoubleWord((this.cpu.edx << 3) + this.cpu.eax);
            }
            case 2314: {
                return this.cpu.ss.getDoubleWord((this.cpu.edx << 3) + this.cpu.ecx);
            }
            case 2315: {
                return this.cpu.ss.getDoubleWord((this.cpu.edx << 3) + this.cpu.edx);
            }
            case 2316: {
                return this.cpu.ss.getDoubleWord((this.cpu.edx << 3) + this.cpu.ebx);
            }
            case 2317: {
                return this.cpu.ss.getDoubleWord((this.cpu.edx << 3) + this.cpu.esp);
            }
            case 2318: {
                return this.cpu.ss.getDoubleWord((this.cpu.edx << 3) + this.getMicrocode());
            }
            case 2319: {
                return this.cpu.ss.getDoubleWord((this.cpu.edx << 3) + this.cpu.esi);
            }
            case 2320: {
                return this.cpu.ss.getDoubleWord((this.cpu.edx << 3) + this.cpu.edi);
            }
            case 2321: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebx << 3) + this.cpu.eax);
            }
            case 2322: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebx << 3) + this.cpu.ecx);
            }
            case 2323: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebx << 3) + this.cpu.edx);
            }
            case 2324: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebx << 3) + this.cpu.ebx);
            }
            case 2325: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebx << 3) + this.cpu.esp);
            }
            case 2326: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebx << 3) + this.getMicrocode());
            }
            case 2327: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebx << 3) + this.cpu.esi);
            }
            case 2328: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebx << 3) + this.cpu.edi);
            }
            case 2329: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebp << 3) + this.cpu.eax);
            }
            case 2330: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebp << 3) + this.cpu.ecx);
            }
            case 2331: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebp << 3) + this.cpu.edx);
            }
            case 2332: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebp << 3) + this.cpu.ebx);
            }
            case 2333: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebp << 3) + this.cpu.esp);
            }
            case 2334: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebp << 3) + this.getMicrocode());
            }
            case 2335: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebp << 3) + this.cpu.esi);
            }
            case 2336: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebp << 3) + this.cpu.edi);
            }
            case 2337: {
                return this.cpu.ss.getDoubleWord((this.cpu.esi << 3) + this.cpu.eax);
            }
            case 2338: {
                return this.cpu.ss.getDoubleWord((this.cpu.esi << 3) + this.cpu.ecx);
            }
            case 2339: {
                return this.cpu.ss.getDoubleWord((this.cpu.esi << 3) + this.cpu.edx);
            }
            case 2340: {
                return this.cpu.ss.getDoubleWord((this.cpu.esi << 3) + this.cpu.ebx);
            }
            case 2341: {
                return this.cpu.ss.getDoubleWord((this.cpu.esi << 3) + this.cpu.esp);
            }
            case 2342: {
                return this.cpu.ss.getDoubleWord((this.cpu.esi << 3) + this.getMicrocode());
            }
            case 2343: {
                return this.cpu.ss.getDoubleWord((this.cpu.esi << 3) + this.cpu.esi);
            }
            case 2344: {
                return this.cpu.ss.getDoubleWord((this.cpu.esi << 3) + this.cpu.edi);
            }
            case 2345: {
                return this.cpu.ss.getDoubleWord((this.cpu.edi << 3) + this.cpu.eax);
            }
            case 2346: {
                return this.cpu.ss.getDoubleWord((this.cpu.edi << 3) + this.cpu.ecx);
            }
            case 2347: {
                return this.cpu.ss.getDoubleWord((this.cpu.edi << 3) + this.cpu.edx);
            }
            case 2348: {
                return this.cpu.ss.getDoubleWord((this.cpu.edi << 3) + this.cpu.ebx);
            }
            case 2349: {
                return this.cpu.ss.getDoubleWord((this.cpu.edi << 3) + this.cpu.esp);
            }
            case 2350: {
                return this.cpu.ss.getDoubleWord((this.cpu.edi << 3) + this.getMicrocode());
            }
            case 2351: {
                return this.cpu.ss.getDoubleWord((this.cpu.edi << 3) + this.cpu.esi);
            }
            case 2352: {
                return this.cpu.ss.getDoubleWord((this.cpu.edi << 3) + this.cpu.edi);
            }
            case 2353: {
                return this.cpu.ss.getDoubleWord(this.cpu.eax + this.cpu.eax + this.getMicrocode());
            }
            case 2354: {
                return this.cpu.ss.getDoubleWord(this.cpu.eax + this.cpu.ecx + this.getMicrocode());
            }
            case 2355: {
                return this.cpu.ss.getDoubleWord(this.cpu.eax + this.cpu.edx + this.getMicrocode());
            }
            case 2356: {
                return this.cpu.ss.getDoubleWord(this.cpu.eax + this.cpu.ebx + this.getMicrocode());
            }
            case 2357: {
                return this.cpu.ss.getDoubleWord(this.cpu.eax + this.cpu.esp + this.getMicrocode());
            }
            case 2358: {
                return this.cpu.ss.getDoubleWord(this.cpu.eax + this.cpu.ebp + this.getMicrocode());
            }
            case 2359: {
                return this.cpu.ss.getDoubleWord(this.cpu.eax + this.cpu.esi + this.getMicrocode());
            }
            case 2360: {
                return this.cpu.ss.getDoubleWord(this.cpu.eax + this.cpu.edi + this.getMicrocode());
            }
            case 2361: {
                return this.cpu.ss.getDoubleWord(this.cpu.ecx + this.cpu.ecx + this.getMicrocode());
            }
            case 2362: {
                return this.cpu.ss.getDoubleWord(this.cpu.ecx + this.cpu.edx + this.getMicrocode());
            }
            case 2363: {
                return this.cpu.ss.getDoubleWord(this.cpu.ecx + this.cpu.ebx + this.getMicrocode());
            }
            case 2364: {
                return this.cpu.ss.getDoubleWord(this.cpu.ecx + this.cpu.esp + this.getMicrocode());
            }
            case 2365: {
                return this.cpu.ss.getDoubleWord(this.cpu.ecx + this.cpu.ebp + this.getMicrocode());
            }
            case 2366: {
                return this.cpu.ss.getDoubleWord(this.cpu.ecx + this.cpu.esi + this.getMicrocode());
            }
            case 2367: {
                return this.cpu.ss.getDoubleWord(this.cpu.ecx + this.cpu.edi + this.getMicrocode());
            }
            case 2368: {
                return this.cpu.ss.getDoubleWord(this.cpu.edx + this.cpu.edx + this.getMicrocode());
            }
            case 2369: {
                return this.cpu.ss.getDoubleWord(this.cpu.edx + this.cpu.ebx + this.getMicrocode());
            }
            case 2370: {
                return this.cpu.ss.getDoubleWord(this.cpu.edx + this.cpu.esp + this.getMicrocode());
            }
            case 2371: {
                return this.cpu.ss.getDoubleWord(this.cpu.edx + this.cpu.ebp + this.getMicrocode());
            }
            case 2372: {
                return this.cpu.ss.getDoubleWord(this.cpu.edx + this.cpu.esi + this.getMicrocode());
            }
            case 2373: {
                return this.cpu.ss.getDoubleWord(this.cpu.edx + this.cpu.edi + this.getMicrocode());
            }
            case 2374: {
                return this.cpu.ss.getDoubleWord(this.cpu.ebx + this.cpu.ebx + this.getMicrocode());
            }
            case 2375: {
                return this.cpu.ss.getDoubleWord(this.cpu.ebx + this.cpu.esp + this.getMicrocode());
            }
            case 2376: {
                return this.cpu.ss.getDoubleWord(this.cpu.ebx + this.cpu.ebp + this.getMicrocode());
            }
            case 2377: {
                return this.cpu.ss.getDoubleWord(this.cpu.ebx + this.cpu.esi + this.getMicrocode());
            }
            case 2378: {
                return this.cpu.ss.getDoubleWord(this.cpu.ebx + this.cpu.edi + this.getMicrocode());
            }
            case 2379: {
                return this.cpu.ss.getDoubleWord(this.cpu.esp + this.getMicrocode());
            }
            case 2380: {
                return this.cpu.ss.getDoubleWord(this.cpu.ebp + this.cpu.esp + this.getMicrocode());
            }
            case 2381: {
                return this.cpu.ss.getDoubleWord(this.cpu.ebp + this.cpu.ebp + this.getMicrocode());
            }
            case 2382: {
                return this.cpu.ss.getDoubleWord(this.cpu.ebp + this.cpu.esi + this.getMicrocode());
            }
            case 2383: {
                return this.cpu.ss.getDoubleWord(this.cpu.ebp + this.cpu.edi + this.getMicrocode());
            }
            case 2384: {
                return this.cpu.ss.getDoubleWord(this.cpu.esi + this.cpu.esp + this.getMicrocode());
            }
            case 2385: {
                return this.cpu.ss.getDoubleWord(this.cpu.esi + this.cpu.esi + this.getMicrocode());
            }
            case 2386: {
                return this.cpu.ss.getDoubleWord(this.cpu.esi + this.cpu.edi + this.getMicrocode());
            }
            case 2387: {
                return this.cpu.ss.getDoubleWord(this.cpu.edi + this.cpu.esp + this.getMicrocode());
            }
            case 2388: {
                return this.cpu.ss.getDoubleWord(this.cpu.edi + this.cpu.edi + this.getMicrocode());
            }
            case 2389: {
                return this.cpu.ss.getDoubleWord((this.cpu.eax << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 2390: {
                return this.cpu.ss.getDoubleWord((this.cpu.eax << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 2391: {
                return this.cpu.ss.getDoubleWord((this.cpu.eax << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 2392: {
                return this.cpu.ss.getDoubleWord((this.cpu.eax << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 2393: {
                return this.cpu.ss.getDoubleWord((this.cpu.eax << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 2394: {
                return this.cpu.ss.getDoubleWord((this.cpu.eax << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 2395: {
                return this.cpu.ss.getDoubleWord((this.cpu.eax << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 2396: {
                return this.cpu.ss.getDoubleWord((this.cpu.eax << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 2397: {
                return this.cpu.ss.getDoubleWord((this.cpu.ecx << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 2398: {
                return this.cpu.ss.getDoubleWord((this.cpu.ecx << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 2399: {
                return this.cpu.ss.getDoubleWord((this.cpu.ecx << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 2400: {
                return this.cpu.ss.getDoubleWord((this.cpu.ecx << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 2401: {
                return this.cpu.ss.getDoubleWord((this.cpu.ecx << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 2402: {
                return this.cpu.ss.getDoubleWord((this.cpu.ecx << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 2403: {
                return this.cpu.ss.getDoubleWord((this.cpu.ecx << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 2404: {
                return this.cpu.ss.getDoubleWord((this.cpu.ecx << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 2405: {
                return this.cpu.ss.getDoubleWord((this.cpu.edx << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 2406: {
                return this.cpu.ss.getDoubleWord((this.cpu.edx << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 2407: {
                return this.cpu.ss.getDoubleWord((this.cpu.edx << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 2408: {
                return this.cpu.ss.getDoubleWord((this.cpu.edx << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 2409: {
                return this.cpu.ss.getDoubleWord((this.cpu.edx << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 2410: {
                return this.cpu.ss.getDoubleWord((this.cpu.edx << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 2411: {
                return this.cpu.ss.getDoubleWord((this.cpu.edx << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 2412: {
                return this.cpu.ss.getDoubleWord((this.cpu.edx << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 2413: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebx << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 2414: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebx << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 2415: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebx << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 2416: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebx << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 2417: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebx << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 2418: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebx << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 2419: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebx << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 2420: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebx << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 2421: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebp << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 2422: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebp << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 2423: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebp << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 2424: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebp << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 2425: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebp << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 2426: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebp << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 2427: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebp << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 2428: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebp << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 2429: {
                return this.cpu.ss.getDoubleWord((this.cpu.esi << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 2430: {
                return this.cpu.ss.getDoubleWord((this.cpu.esi << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 2431: {
                return this.cpu.ss.getDoubleWord((this.cpu.esi << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 2432: {
                return this.cpu.ss.getDoubleWord((this.cpu.esi << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 2433: {
                return this.cpu.ss.getDoubleWord((this.cpu.esi << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 2434: {
                return this.cpu.ss.getDoubleWord((this.cpu.esi << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 2435: {
                return this.cpu.ss.getDoubleWord((this.cpu.esi << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 2436: {
                return this.cpu.ss.getDoubleWord((this.cpu.esi << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 2437: {
                return this.cpu.ss.getDoubleWord((this.cpu.edi << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 2438: {
                return this.cpu.ss.getDoubleWord((this.cpu.edi << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 2439: {
                return this.cpu.ss.getDoubleWord((this.cpu.edi << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 2440: {
                return this.cpu.ss.getDoubleWord((this.cpu.edi << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 2441: {
                return this.cpu.ss.getDoubleWord((this.cpu.edi << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 2442: {
                return this.cpu.ss.getDoubleWord((this.cpu.edi << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 2443: {
                return this.cpu.ss.getDoubleWord((this.cpu.edi << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 2444: {
                return this.cpu.ss.getDoubleWord((this.cpu.edi << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 2445: {
                return this.cpu.ss.getDoubleWord((this.cpu.eax << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 2446: {
                return this.cpu.ss.getDoubleWord((this.cpu.eax << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 2447: {
                return this.cpu.ss.getDoubleWord((this.cpu.eax << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 2448: {
                return this.cpu.ss.getDoubleWord((this.cpu.eax << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 2449: {
                return this.cpu.ss.getDoubleWord((this.cpu.eax << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 2450: {
                return this.cpu.ss.getDoubleWord((this.cpu.eax << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 2451: {
                return this.cpu.ss.getDoubleWord((this.cpu.eax << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 2452: {
                return this.cpu.ss.getDoubleWord((this.cpu.eax << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 2453: {
                return this.cpu.ss.getDoubleWord((this.cpu.ecx << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 2454: {
                return this.cpu.ss.getDoubleWord((this.cpu.ecx << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 2455: {
                return this.cpu.ss.getDoubleWord((this.cpu.ecx << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 2456: {
                return this.cpu.ss.getDoubleWord((this.cpu.ecx << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 2457: {
                return this.cpu.ss.getDoubleWord((this.cpu.ecx << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 2458: {
                return this.cpu.ss.getDoubleWord((this.cpu.ecx << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 2459: {
                return this.cpu.ss.getDoubleWord((this.cpu.ecx << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 2460: {
                return this.cpu.ss.getDoubleWord((this.cpu.ecx << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 2461: {
                return this.cpu.ss.getDoubleWord((this.cpu.edx << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 2462: {
                return this.cpu.ss.getDoubleWord((this.cpu.edx << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 2463: {
                return this.cpu.ss.getDoubleWord((this.cpu.edx << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 2464: {
                return this.cpu.ss.getDoubleWord((this.cpu.edx << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 2465: {
                return this.cpu.ss.getDoubleWord((this.cpu.edx << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 2466: {
                return this.cpu.ss.getDoubleWord((this.cpu.edx << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 2467: {
                return this.cpu.ss.getDoubleWord((this.cpu.edx << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 2468: {
                return this.cpu.ss.getDoubleWord((this.cpu.edx << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 2469: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebx << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 2470: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebx << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 2471: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebx << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 2472: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebx << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 2473: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebx << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 2474: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebx << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 2475: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebx << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 2476: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebx << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 2477: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebp << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 2478: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebp << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 2479: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebp << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 2480: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebp << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 2481: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebp << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 2482: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebp << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 2483: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebp << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 2484: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebp << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 2485: {
                return this.cpu.ss.getDoubleWord((this.cpu.esi << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 2486: {
                return this.cpu.ss.getDoubleWord((this.cpu.esi << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 2487: {
                return this.cpu.ss.getDoubleWord((this.cpu.esi << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 2488: {
                return this.cpu.ss.getDoubleWord((this.cpu.esi << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 2489: {
                return this.cpu.ss.getDoubleWord((this.cpu.esi << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 2490: {
                return this.cpu.ss.getDoubleWord((this.cpu.esi << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 2491: {
                return this.cpu.ss.getDoubleWord((this.cpu.esi << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 2492: {
                return this.cpu.ss.getDoubleWord((this.cpu.esi << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 2493: {
                return this.cpu.ss.getDoubleWord((this.cpu.edi << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 2494: {
                return this.cpu.ss.getDoubleWord((this.cpu.edi << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 2495: {
                return this.cpu.ss.getDoubleWord((this.cpu.edi << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 2496: {
                return this.cpu.ss.getDoubleWord((this.cpu.edi << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 2497: {
                return this.cpu.ss.getDoubleWord((this.cpu.edi << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 2498: {
                return this.cpu.ss.getDoubleWord((this.cpu.edi << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 2499: {
                return this.cpu.ss.getDoubleWord((this.cpu.edi << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 2500: {
                return this.cpu.ss.getDoubleWord((this.cpu.edi << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 2501: {
                return this.cpu.ss.getDoubleWord((this.cpu.eax << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 2502: {
                return this.cpu.ss.getDoubleWord((this.cpu.eax << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 2503: {
                return this.cpu.ss.getDoubleWord((this.cpu.eax << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 2504: {
                return this.cpu.ss.getDoubleWord((this.cpu.eax << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 2505: {
                return this.cpu.ss.getDoubleWord((this.cpu.eax << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 2506: {
                return this.cpu.ss.getDoubleWord((this.cpu.eax << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 2507: {
                return this.cpu.ss.getDoubleWord((this.cpu.eax << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 2508: {
                return this.cpu.ss.getDoubleWord((this.cpu.eax << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 2509: {
                return this.cpu.ss.getDoubleWord((this.cpu.ecx << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 2510: {
                return this.cpu.ss.getDoubleWord((this.cpu.ecx << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 2511: {
                return this.cpu.ss.getDoubleWord((this.cpu.ecx << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 2512: {
                return this.cpu.ss.getDoubleWord((this.cpu.ecx << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 2513: {
                return this.cpu.ss.getDoubleWord((this.cpu.ecx << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 2514: {
                return this.cpu.ss.getDoubleWord((this.cpu.ecx << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 2515: {
                return this.cpu.ss.getDoubleWord((this.cpu.ecx << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 2516: {
                return this.cpu.ss.getDoubleWord((this.cpu.ecx << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 2517: {
                return this.cpu.ss.getDoubleWord((this.cpu.edx << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 2518: {
                return this.cpu.ss.getDoubleWord((this.cpu.edx << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 2519: {
                return this.cpu.ss.getDoubleWord((this.cpu.edx << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 2520: {
                return this.cpu.ss.getDoubleWord((this.cpu.edx << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 2521: {
                return this.cpu.ss.getDoubleWord((this.cpu.edx << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 2522: {
                return this.cpu.ss.getDoubleWord((this.cpu.edx << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 2523: {
                return this.cpu.ss.getDoubleWord((this.cpu.edx << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 2524: {
                return this.cpu.ss.getDoubleWord((this.cpu.edx << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 2525: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebx << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 2526: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebx << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 2527: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebx << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 2528: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebx << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 2529: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebx << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 2530: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebx << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 2531: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebx << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 2532: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebx << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 2533: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebp << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 2534: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebp << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 2535: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebp << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 2536: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebp << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 2537: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebp << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 2538: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebp << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 2539: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebp << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 2540: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebp << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 2541: {
                return this.cpu.ss.getDoubleWord((this.cpu.esi << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 2542: {
                return this.cpu.ss.getDoubleWord((this.cpu.esi << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 2543: {
                return this.cpu.ss.getDoubleWord((this.cpu.esi << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 2544: {
                return this.cpu.ss.getDoubleWord((this.cpu.esi << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 2545: {
                return this.cpu.ss.getDoubleWord((this.cpu.esi << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 2546: {
                return this.cpu.ss.getDoubleWord((this.cpu.esi << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 2547: {
                return this.cpu.ss.getDoubleWord((this.cpu.esi << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 2548: {
                return this.cpu.ss.getDoubleWord((this.cpu.esi << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 2549: {
                return this.cpu.ss.getDoubleWord((this.cpu.edi << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 2550: {
                return this.cpu.ss.getDoubleWord((this.cpu.edi << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 2551: {
                return this.cpu.ss.getDoubleWord((this.cpu.edi << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 2552: {
                return this.cpu.ss.getDoubleWord((this.cpu.edi << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 2553: {
                return this.cpu.ss.getDoubleWord((this.cpu.edi << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 2554: {
                return this.cpu.ss.getDoubleWord((this.cpu.edi << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 2555: {
                return this.cpu.ss.getDoubleWord((this.cpu.edi << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 2556: {
                return this.cpu.ss.getDoubleWord((this.cpu.edi << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 2557: {
                return this.cpu.ss.getDoubleWord(this.cpu.eax + this.cpu.ecx + this.getMicrocode());
            }
            case 2558: {
                return this.cpu.ss.getDoubleWord(this.cpu.eax + this.cpu.edx + this.getMicrocode());
            }
            case 2559: {
                return this.cpu.ss.getDoubleWord(this.cpu.eax + this.cpu.ebx + this.getMicrocode());
            }
            case 2560: {
                return this.cpu.ss.getDoubleWord(this.cpu.eax + this.cpu.esp + this.getMicrocode());
            }
            case 2561: {
                return this.cpu.ss.getDoubleWord(this.cpu.eax + this.cpu.ebp + this.getMicrocode());
            }
            case 2562: {
                return this.cpu.ss.getDoubleWord(this.cpu.eax + this.cpu.esi + this.getMicrocode());
            }
            case 2563: {
                return this.cpu.ss.getDoubleWord(this.cpu.eax + this.cpu.edi + this.getMicrocode());
            }
            case 2564: {
                return this.cpu.ss.getDoubleWord(this.cpu.ecx + this.cpu.edx + this.getMicrocode());
            }
            case 2565: {
                return this.cpu.ss.getDoubleWord(this.cpu.ecx + this.cpu.ebx + this.getMicrocode());
            }
            case 2566: {
                return this.cpu.ss.getDoubleWord(this.cpu.ecx + this.cpu.esp + this.getMicrocode());
            }
            case 2567: {
                return this.cpu.ss.getDoubleWord(this.cpu.ecx + this.cpu.ebp + this.getMicrocode());
            }
            case 2568: {
                return this.cpu.ss.getDoubleWord(this.cpu.ecx + this.cpu.esi + this.getMicrocode());
            }
            case 2569: {
                return this.cpu.ss.getDoubleWord(this.cpu.ecx + this.cpu.edi + this.getMicrocode());
            }
            case 2570: {
                return this.cpu.ss.getDoubleWord(this.cpu.edx + this.cpu.ebx + this.getMicrocode());
            }
            case 2571: {
                return this.cpu.ss.getDoubleWord(this.cpu.edx + this.cpu.esp + this.getMicrocode());
            }
            case 2572: {
                return this.cpu.ss.getDoubleWord(this.cpu.edx + this.cpu.ebp + this.getMicrocode());
            }
            case 2573: {
                return this.cpu.ss.getDoubleWord(this.cpu.edx + this.cpu.esi + this.getMicrocode());
            }
            case 2574: {
                return this.cpu.ss.getDoubleWord(this.cpu.edx + this.cpu.edi + this.getMicrocode());
            }
            case 2575: {
                return this.cpu.ss.getDoubleWord(this.cpu.ebx + this.cpu.esp + this.getMicrocode());
            }
            case 2576: {
                return this.cpu.ss.getDoubleWord(this.cpu.ebx + this.cpu.ebp + this.getMicrocode());
            }
            case 2577: {
                return this.cpu.ss.getDoubleWord(this.cpu.ebx + this.cpu.esi + this.getMicrocode());
            }
            case 2578: {
                return this.cpu.ss.getDoubleWord(this.cpu.ebx + this.cpu.edi + this.getMicrocode());
            }
            case 2579: {
                return this.cpu.ss.getDoubleWord(this.cpu.esp + this.getMicrocode());
            }
            case 2580: {
                return this.cpu.ss.getDoubleWord(this.cpu.ebp + this.cpu.esp + this.getMicrocode());
            }
            case 2581: {
                return this.cpu.ss.getDoubleWord(this.cpu.ebp + this.cpu.esi + this.getMicrocode());
            }
            case 2582: {
                return this.cpu.ss.getDoubleWord(this.cpu.ebp + this.cpu.edi + this.getMicrocode());
            }
            case 2583: {
                return this.cpu.ss.getDoubleWord(this.cpu.esi + this.cpu.esp + this.getMicrocode());
            }
            case 2584: {
                return this.cpu.ss.getDoubleWord(this.cpu.esi + this.cpu.edi + this.getMicrocode());
            }
            case 2585: {
                return this.cpu.ss.getDoubleWord(this.cpu.edi + this.cpu.esp + this.getMicrocode());
            }
            case 2586: {
                return this.cpu.ss.getDoubleWord((this.cpu.eax << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 2587: {
                return this.cpu.ss.getDoubleWord((this.cpu.eax << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 2588: {
                return this.cpu.ss.getDoubleWord((this.cpu.eax << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 2589: {
                return this.cpu.ss.getDoubleWord((this.cpu.eax << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 2590: {
                return this.cpu.ss.getDoubleWord((this.cpu.eax << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 2591: {
                return this.cpu.ss.getDoubleWord((this.cpu.eax << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 2592: {
                return this.cpu.ss.getDoubleWord((this.cpu.eax << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 2593: {
                return this.cpu.ss.getDoubleWord((this.cpu.eax << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 2594: {
                return this.cpu.ss.getDoubleWord((this.cpu.ecx << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 2595: {
                return this.cpu.ss.getDoubleWord((this.cpu.ecx << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 2596: {
                return this.cpu.ss.getDoubleWord((this.cpu.ecx << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 2597: {
                return this.cpu.ss.getDoubleWord((this.cpu.ecx << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 2598: {
                return this.cpu.ss.getDoubleWord((this.cpu.ecx << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 2599: {
                return this.cpu.ss.getDoubleWord((this.cpu.ecx << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 2600: {
                return this.cpu.ss.getDoubleWord((this.cpu.ecx << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 2601: {
                return this.cpu.ss.getDoubleWord((this.cpu.ecx << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 2602: {
                return this.cpu.ss.getDoubleWord((this.cpu.edx << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 2603: {
                return this.cpu.ss.getDoubleWord((this.cpu.edx << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 2604: {
                return this.cpu.ss.getDoubleWord((this.cpu.edx << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 2605: {
                return this.cpu.ss.getDoubleWord((this.cpu.edx << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 2606: {
                return this.cpu.ss.getDoubleWord((this.cpu.edx << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 2607: {
                return this.cpu.ss.getDoubleWord((this.cpu.edx << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 2608: {
                return this.cpu.ss.getDoubleWord((this.cpu.edx << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 2609: {
                return this.cpu.ss.getDoubleWord((this.cpu.edx << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 2610: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebx << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 2611: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebx << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 2612: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebx << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 2613: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebx << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 2614: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebx << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 2615: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebx << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 2616: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebx << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 2617: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebx << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 2618: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebp << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 2619: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebp << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 2620: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebp << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 2621: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebp << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 2622: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebp << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 2623: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebp << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 2624: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebp << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 2625: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebp << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 2626: {
                return this.cpu.ss.getDoubleWord((this.cpu.esi << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 2627: {
                return this.cpu.ss.getDoubleWord((this.cpu.esi << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 2628: {
                return this.cpu.ss.getDoubleWord((this.cpu.esi << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 2629: {
                return this.cpu.ss.getDoubleWord((this.cpu.esi << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 2630: {
                return this.cpu.ss.getDoubleWord((this.cpu.esi << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 2631: {
                return this.cpu.ss.getDoubleWord((this.cpu.esi << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 2632: {
                return this.cpu.ss.getDoubleWord((this.cpu.esi << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 2633: {
                return this.cpu.ss.getDoubleWord((this.cpu.esi << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 2634: {
                return this.cpu.ss.getDoubleWord((this.cpu.edi << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 2635: {
                return this.cpu.ss.getDoubleWord((this.cpu.edi << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 2636: {
                return this.cpu.ss.getDoubleWord((this.cpu.edi << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 2637: {
                return this.cpu.ss.getDoubleWord((this.cpu.edi << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 2638: {
                return this.cpu.ss.getDoubleWord((this.cpu.edi << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 2639: {
                return this.cpu.ss.getDoubleWord((this.cpu.edi << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 2640: {
                return this.cpu.ss.getDoubleWord((this.cpu.edi << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 2641: {
                return this.cpu.ss.getDoubleWord((this.cpu.edi << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 2642: {
                return this.cpu.ss.getDoubleWord((this.cpu.eax << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 2643: {
                return this.cpu.ss.getDoubleWord((this.cpu.eax << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 2644: {
                return this.cpu.ss.getDoubleWord((this.cpu.eax << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 2645: {
                return this.cpu.ss.getDoubleWord((this.cpu.eax << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 2646: {
                return this.cpu.ss.getDoubleWord((this.cpu.eax << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 2647: {
                return this.cpu.ss.getDoubleWord((this.cpu.eax << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 2648: {
                return this.cpu.ss.getDoubleWord((this.cpu.eax << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 2649: {
                return this.cpu.ss.getDoubleWord((this.cpu.eax << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 2650: {
                return this.cpu.ss.getDoubleWord((this.cpu.ecx << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 2651: {
                return this.cpu.ss.getDoubleWord((this.cpu.ecx << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 2652: {
                return this.cpu.ss.getDoubleWord((this.cpu.ecx << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 2653: {
                return this.cpu.ss.getDoubleWord((this.cpu.ecx << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 2654: {
                return this.cpu.ss.getDoubleWord((this.cpu.ecx << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 2655: {
                return this.cpu.ss.getDoubleWord((this.cpu.ecx << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 2656: {
                return this.cpu.ss.getDoubleWord((this.cpu.ecx << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 2657: {
                return this.cpu.ss.getDoubleWord((this.cpu.ecx << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 2658: {
                return this.cpu.ss.getDoubleWord((this.cpu.edx << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 2659: {
                return this.cpu.ss.getDoubleWord((this.cpu.edx << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 2660: {
                return this.cpu.ss.getDoubleWord((this.cpu.edx << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 2661: {
                return this.cpu.ss.getDoubleWord((this.cpu.edx << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 2662: {
                return this.cpu.ss.getDoubleWord((this.cpu.edx << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 2663: {
                return this.cpu.ss.getDoubleWord((this.cpu.edx << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 2664: {
                return this.cpu.ss.getDoubleWord((this.cpu.edx << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 2665: {
                return this.cpu.ss.getDoubleWord((this.cpu.edx << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 2666: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebx << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 2667: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebx << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 2668: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebx << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 2669: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebx << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 2670: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebx << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 2671: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebx << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 2672: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebx << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 2673: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebx << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 2674: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebp << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 2675: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebp << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 2676: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebp << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 2677: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebp << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 2678: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebp << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 2679: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebp << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 2680: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebp << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 2681: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebp << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 2682: {
                return this.cpu.ss.getDoubleWord((this.cpu.esi << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 2683: {
                return this.cpu.ss.getDoubleWord((this.cpu.esi << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 2684: {
                return this.cpu.ss.getDoubleWord((this.cpu.esi << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 2685: {
                return this.cpu.ss.getDoubleWord((this.cpu.esi << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 2686: {
                return this.cpu.ss.getDoubleWord((this.cpu.esi << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 2687: {
                return this.cpu.ss.getDoubleWord((this.cpu.esi << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 2688: {
                return this.cpu.ss.getDoubleWord((this.cpu.esi << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 2689: {
                return this.cpu.ss.getDoubleWord((this.cpu.esi << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 2690: {
                return this.cpu.ss.getDoubleWord((this.cpu.edi << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 2691: {
                return this.cpu.ss.getDoubleWord((this.cpu.edi << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 2692: {
                return this.cpu.ss.getDoubleWord((this.cpu.edi << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 2693: {
                return this.cpu.ss.getDoubleWord((this.cpu.edi << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 2694: {
                return this.cpu.ss.getDoubleWord((this.cpu.edi << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 2695: {
                return this.cpu.ss.getDoubleWord((this.cpu.edi << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 2696: {
                return this.cpu.ss.getDoubleWord((this.cpu.edi << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 2697: {
                return this.cpu.ss.getDoubleWord((this.cpu.edi << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 2698: {
                return this.cpu.ss.getDoubleWord((this.cpu.eax << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 2699: {
                return this.cpu.ss.getDoubleWord((this.cpu.eax << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 2700: {
                return this.cpu.ss.getDoubleWord((this.cpu.eax << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 2701: {
                return this.cpu.ss.getDoubleWord((this.cpu.eax << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 2702: {
                return this.cpu.ss.getDoubleWord((this.cpu.eax << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 2703: {
                return this.cpu.ss.getDoubleWord((this.cpu.eax << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 2704: {
                return this.cpu.ss.getDoubleWord((this.cpu.eax << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 2705: {
                return this.cpu.ss.getDoubleWord((this.cpu.eax << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 2706: {
                return this.cpu.ss.getDoubleWord((this.cpu.ecx << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 2707: {
                return this.cpu.ss.getDoubleWord((this.cpu.ecx << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 2708: {
                return this.cpu.ss.getDoubleWord((this.cpu.ecx << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 2709: {
                return this.cpu.ss.getDoubleWord((this.cpu.ecx << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 2710: {
                return this.cpu.ss.getDoubleWord((this.cpu.ecx << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 2711: {
                return this.cpu.ss.getDoubleWord((this.cpu.ecx << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 2712: {
                return this.cpu.ss.getDoubleWord((this.cpu.ecx << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 2713: {
                return this.cpu.ss.getDoubleWord((this.cpu.ecx << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 2714: {
                return this.cpu.ss.getDoubleWord((this.cpu.edx << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 2715: {
                return this.cpu.ss.getDoubleWord((this.cpu.edx << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 2716: {
                return this.cpu.ss.getDoubleWord((this.cpu.edx << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 2717: {
                return this.cpu.ss.getDoubleWord((this.cpu.edx << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 2718: {
                return this.cpu.ss.getDoubleWord((this.cpu.edx << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 2719: {
                return this.cpu.ss.getDoubleWord((this.cpu.edx << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 2720: {
                return this.cpu.ss.getDoubleWord((this.cpu.edx << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 2721: {
                return this.cpu.ss.getDoubleWord((this.cpu.edx << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 2722: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebx << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 2723: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebx << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 2724: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebx << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 2725: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebx << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 2726: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebx << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 2727: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebx << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 2728: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebx << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 2729: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebx << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 2730: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebp << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 2731: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebp << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 2732: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebp << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 2733: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebp << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 2734: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebp << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 2735: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebp << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 2736: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebp << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 2737: {
                return this.cpu.ss.getDoubleWord((this.cpu.ebp << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 2738: {
                return this.cpu.ss.getDoubleWord((this.cpu.esi << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 2739: {
                return this.cpu.ss.getDoubleWord((this.cpu.esi << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 2740: {
                return this.cpu.ss.getDoubleWord((this.cpu.esi << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 2741: {
                return this.cpu.ss.getDoubleWord((this.cpu.esi << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 2742: {
                return this.cpu.ss.getDoubleWord((this.cpu.esi << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 2743: {
                return this.cpu.ss.getDoubleWord((this.cpu.esi << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 2744: {
                return this.cpu.ss.getDoubleWord((this.cpu.esi << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 2745: {
                return this.cpu.ss.getDoubleWord((this.cpu.esi << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 2746: {
                return this.cpu.ss.getDoubleWord((this.cpu.edi << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 2747: {
                return this.cpu.ss.getDoubleWord((this.cpu.edi << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 2748: {
                return this.cpu.ss.getDoubleWord((this.cpu.edi << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 2749: {
                return this.cpu.ss.getDoubleWord((this.cpu.edi << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 2750: {
                return this.cpu.ss.getDoubleWord((this.cpu.edi << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 2751: {
                return this.cpu.ss.getDoubleWord((this.cpu.edi << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 2752: {
                return this.cpu.ss.getDoubleWord((this.cpu.edi << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 2753: {
                return this.cpu.ss.getDoubleWord((this.cpu.edi << 3) + this.cpu.edi + this.getMicrocode());
            }
        }
        System.err.println("Unimplemented GetInt Operand: " + n);
        throw unimplemented;
    }

    protected final long getLongOperand() {
        int n = this.getMicrocode();
        switch (n) {
            case 45: {
                return (long)this.getMicrocode() & 0xFFFFFFFFL | ((long)this.getMicrocode() & 0xFFFFFFFFL) << 32;
            }
        }
        return this.getLongMemoryOperand(n);
    }

    /*
     * Opcode count of 21247 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    private final long getLongMemoryOperand(int n) {
        switch (n) {
            case 182: {
                return this.cpu.es.getQuadWord(this.cpu.ebx + this.cpu.esi & 0xFFFF);
            }
            case 183: {
                return this.cpu.es.getQuadWord(this.cpu.ebx + this.cpu.edi & 0xFFFF);
            }
            case 184: {
                return this.cpu.es.getQuadWord(this.cpu.ebp + this.cpu.esi & 0xFFFF);
            }
            case 185: {
                return this.cpu.es.getQuadWord(this.cpu.ebp + this.cpu.edi & 0xFFFF);
            }
            case 186: {
                return this.cpu.es.getQuadWord(this.cpu.esi & 0xFFFF);
            }
            case 187: {
                return this.cpu.es.getQuadWord(this.cpu.edi & 0xFFFF);
            }
            case 188: {
                return this.cpu.es.getQuadWord(this.getMicrocode() & 0xFFFF);
            }
            case 189: {
                return this.cpu.es.getQuadWord(this.cpu.ebx & 0xFFFF);
            }
            case 190: {
                return this.cpu.es.getQuadWord(this.cpu.ebx + this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 191: {
                return this.cpu.es.getQuadWord(this.cpu.ebx + this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 192: {
                return this.cpu.es.getQuadWord(this.cpu.ebp + this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 193: {
                return this.cpu.es.getQuadWord(this.cpu.ebp + this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 194: {
                return this.cpu.es.getQuadWord(this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 195: {
                return this.cpu.es.getQuadWord(this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 196: {
                return this.cpu.es.getQuadWord(this.cpu.ebp + this.getMicrocode() & 0xFFFF);
            }
            case 197: {
                return this.cpu.es.getQuadWord(this.cpu.ebx + this.getMicrocode() & 0xFFFF);
            }
            case 198: {
                return this.cpu.es.getQuadWord(this.cpu.ebx + this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 199: {
                return this.cpu.es.getQuadWord(this.cpu.ebx + this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 200: {
                return this.cpu.es.getQuadWord(this.cpu.ebp + this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 201: {
                return this.cpu.es.getQuadWord(this.cpu.ebp + this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 202: {
                return this.cpu.es.getQuadWord(this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 203: {
                return this.cpu.es.getQuadWord(this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 204: {
                return this.cpu.es.getQuadWord(this.cpu.ebp + this.getMicrocode() & 0xFFFF);
            }
            case 205: {
                return this.cpu.es.getQuadWord(this.cpu.ebx + this.getMicrocode() & 0xFFFF);
            }
            case 206: {
                return this.cpu.cs.getQuadWord(this.cpu.ebx + this.cpu.esi & 0xFFFF);
            }
            case 207: {
                return this.cpu.cs.getQuadWord(this.cpu.ebx + this.cpu.edi & 0xFFFF);
            }
            case 208: {
                return this.cpu.cs.getQuadWord(this.cpu.ebp + this.cpu.esi & 0xFFFF);
            }
            case 209: {
                return this.cpu.cs.getQuadWord(this.cpu.ebp + this.cpu.edi & 0xFFFF);
            }
            case 210: {
                return this.cpu.cs.getQuadWord(this.cpu.esi & 0xFFFF);
            }
            case 211: {
                return this.cpu.cs.getQuadWord(this.cpu.edi & 0xFFFF);
            }
            case 212: {
                return this.cpu.cs.getQuadWord(this.getMicrocode() & 0xFFFF);
            }
            case 213: {
                return this.cpu.cs.getQuadWord(this.cpu.ebx & 0xFFFF);
            }
            case 214: {
                return this.cpu.cs.getQuadWord(this.cpu.ebx + this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 215: {
                return this.cpu.cs.getQuadWord(this.cpu.ebx + this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 216: {
                return this.cpu.cs.getQuadWord(this.cpu.ebp + this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 217: {
                return this.cpu.cs.getQuadWord(this.cpu.ebp + this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 218: {
                return this.cpu.cs.getQuadWord(this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 219: {
                return this.cpu.cs.getQuadWord(this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 220: {
                return this.cpu.cs.getQuadWord(this.cpu.ebp + this.getMicrocode() & 0xFFFF);
            }
            case 221: {
                return this.cpu.cs.getQuadWord(this.cpu.ebx + this.getMicrocode() & 0xFFFF);
            }
            case 222: {
                return this.cpu.cs.getQuadWord(this.cpu.ebx + this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 223: {
                return this.cpu.cs.getQuadWord(this.cpu.ebx + this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 224: {
                return this.cpu.cs.getQuadWord(this.cpu.ebp + this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 225: {
                return this.cpu.cs.getQuadWord(this.cpu.ebp + this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 226: {
                return this.cpu.cs.getQuadWord(this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 227: {
                return this.cpu.cs.getQuadWord(this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 228: {
                return this.cpu.cs.getQuadWord(this.cpu.ebp + this.getMicrocode() & 0xFFFF);
            }
            case 229: {
                return this.cpu.cs.getQuadWord(this.cpu.ebx + this.getMicrocode() & 0xFFFF);
            }
            case 230: {
                return this.cpu.ss.getQuadWord(this.cpu.ebx + this.cpu.esi & 0xFFFF);
            }
            case 231: {
                return this.cpu.ss.getQuadWord(this.cpu.ebx + this.cpu.edi & 0xFFFF);
            }
            case 232: {
                return this.cpu.ss.getQuadWord(this.cpu.ebp + this.cpu.esi & 0xFFFF);
            }
            case 233: {
                return this.cpu.ss.getQuadWord(this.cpu.ebp + this.cpu.edi & 0xFFFF);
            }
            case 234: {
                return this.cpu.ss.getQuadWord(this.cpu.esi & 0xFFFF);
            }
            case 235: {
                return this.cpu.ss.getQuadWord(this.cpu.edi & 0xFFFF);
            }
            case 236: {
                return this.cpu.ss.getQuadWord(this.getMicrocode() & 0xFFFF);
            }
            case 237: {
                return this.cpu.ss.getQuadWord(this.cpu.ebx & 0xFFFF);
            }
            case 238: {
                return this.cpu.ss.getQuadWord(this.cpu.ebx + this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 239: {
                return this.cpu.ss.getQuadWord(this.cpu.ebx + this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 240: {
                return this.cpu.ss.getQuadWord(this.cpu.ebp + this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 241: {
                return this.cpu.ss.getQuadWord(this.cpu.ebp + this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 242: {
                return this.cpu.ss.getQuadWord(this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 243: {
                return this.cpu.ss.getQuadWord(this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 244: {
                return this.cpu.ss.getQuadWord(this.cpu.ebp + this.getMicrocode() & 0xFFFF);
            }
            case 245: {
                return this.cpu.ss.getQuadWord(this.cpu.ebx + this.getMicrocode() & 0xFFFF);
            }
            case 246: {
                return this.cpu.ss.getQuadWord(this.cpu.ebx + this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 247: {
                return this.cpu.ss.getQuadWord(this.cpu.ebx + this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 248: {
                return this.cpu.ss.getQuadWord(this.cpu.ebp + this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 249: {
                return this.cpu.ss.getQuadWord(this.cpu.ebp + this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 250: {
                return this.cpu.ss.getQuadWord(this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 251: {
                return this.cpu.ss.getQuadWord(this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 252: {
                return this.cpu.ss.getQuadWord(this.cpu.ebp + this.getMicrocode() & 0xFFFF);
            }
            case 253: {
                return this.cpu.ss.getQuadWord(this.cpu.ebx + this.getMicrocode() & 0xFFFF);
            }
            case 254: {
                return this.cpu.ds.getQuadWord(this.cpu.ebx + this.cpu.esi & 0xFFFF);
            }
            case 255: {
                return this.cpu.ds.getQuadWord(this.cpu.ebx + this.cpu.edi & 0xFFFF);
            }
            case 256: {
                return this.cpu.ds.getQuadWord(this.cpu.ebp + this.cpu.esi & 0xFFFF);
            }
            case 257: {
                return this.cpu.ds.getQuadWord(this.cpu.ebp + this.cpu.edi & 0xFFFF);
            }
            case 258: {
                return this.cpu.ds.getQuadWord(this.cpu.esi & 0xFFFF);
            }
            case 259: {
                return this.cpu.ds.getQuadWord(this.cpu.edi & 0xFFFF);
            }
            case 260: {
                return this.cpu.ds.getQuadWord(this.getMicrocode() & 0xFFFF);
            }
            case 261: {
                return this.cpu.ds.getQuadWord(this.cpu.ebx & 0xFFFF);
            }
            case 262: {
                return this.cpu.ds.getQuadWord(this.cpu.ebx + this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 263: {
                return this.cpu.ds.getQuadWord(this.cpu.ebx + this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 264: {
                return this.cpu.ds.getQuadWord(this.cpu.ebp + this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 265: {
                return this.cpu.ds.getQuadWord(this.cpu.ebp + this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 266: {
                return this.cpu.ds.getQuadWord(this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 267: {
                return this.cpu.ds.getQuadWord(this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 268: {
                return this.cpu.ds.getQuadWord(this.cpu.ebp + this.getMicrocode() & 0xFFFF);
            }
            case 269: {
                return this.cpu.ds.getQuadWord(this.cpu.ebx + this.getMicrocode() & 0xFFFF);
            }
            case 270: {
                return this.cpu.ds.getQuadWord(this.cpu.ebx + this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 271: {
                return this.cpu.ds.getQuadWord(this.cpu.ebx + this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 272: {
                return this.cpu.ds.getQuadWord(this.cpu.ebp + this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 273: {
                return this.cpu.ds.getQuadWord(this.cpu.ebp + this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 274: {
                return this.cpu.ds.getQuadWord(this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 275: {
                return this.cpu.ds.getQuadWord(this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 276: {
                return this.cpu.ds.getQuadWord(this.cpu.ebp + this.getMicrocode() & 0xFFFF);
            }
            case 277: {
                return this.cpu.ds.getQuadWord(this.cpu.ebx + this.getMicrocode() & 0xFFFF);
            }
            case 278: {
                return this.cpu.fs.getQuadWord(this.cpu.ebx + this.cpu.esi & 0xFFFF);
            }
            case 279: {
                return this.cpu.fs.getQuadWord(this.cpu.ebx + this.cpu.edi & 0xFFFF);
            }
            case 280: {
                return this.cpu.fs.getQuadWord(this.cpu.ebp + this.cpu.esi & 0xFFFF);
            }
            case 281: {
                return this.cpu.fs.getQuadWord(this.cpu.ebp + this.cpu.edi & 0xFFFF);
            }
            case 282: {
                return this.cpu.fs.getQuadWord(this.cpu.esi & 0xFFFF);
            }
            case 283: {
                return this.cpu.fs.getQuadWord(this.cpu.edi & 0xFFFF);
            }
            case 284: {
                return this.cpu.fs.getQuadWord(this.getMicrocode() & 0xFFFF);
            }
            case 285: {
                return this.cpu.fs.getQuadWord(this.cpu.ebx & 0xFFFF);
            }
            case 286: {
                return this.cpu.fs.getQuadWord(this.cpu.ebx + this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 287: {
                return this.cpu.fs.getQuadWord(this.cpu.ebx + this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 288: {
                return this.cpu.fs.getQuadWord(this.cpu.ebp + this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 289: {
                return this.cpu.fs.getQuadWord(this.cpu.ebp + this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 290: {
                return this.cpu.fs.getQuadWord(this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 291: {
                return this.cpu.fs.getQuadWord(this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 292: {
                return this.cpu.fs.getQuadWord(this.cpu.ebp + this.getMicrocode() & 0xFFFF);
            }
            case 293: {
                return this.cpu.fs.getQuadWord(this.cpu.ebx + this.getMicrocode() & 0xFFFF);
            }
            case 294: {
                return this.cpu.fs.getQuadWord(this.cpu.ebx + this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 295: {
                return this.cpu.fs.getQuadWord(this.cpu.ebx + this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 296: {
                return this.cpu.fs.getQuadWord(this.cpu.ebp + this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 297: {
                return this.cpu.fs.getQuadWord(this.cpu.ebp + this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 298: {
                return this.cpu.fs.getQuadWord(this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 299: {
                return this.cpu.fs.getQuadWord(this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 300: {
                return this.cpu.fs.getQuadWord(this.cpu.ebp + this.getMicrocode() & 0xFFFF);
            }
            case 301: {
                return this.cpu.fs.getQuadWord(this.cpu.ebx + this.getMicrocode() & 0xFFFF);
            }
            case 302: {
                return this.cpu.gs.getQuadWord(this.cpu.ebx + this.cpu.esi & 0xFFFF);
            }
            case 303: {
                return this.cpu.gs.getQuadWord(this.cpu.ebx + this.cpu.edi & 0xFFFF);
            }
            case 304: {
                return this.cpu.gs.getQuadWord(this.cpu.ebp + this.cpu.esi & 0xFFFF);
            }
            case 305: {
                return this.cpu.gs.getQuadWord(this.cpu.ebp + this.cpu.edi & 0xFFFF);
            }
            case 306: {
                return this.cpu.gs.getQuadWord(this.cpu.esi & 0xFFFF);
            }
            case 307: {
                return this.cpu.gs.getQuadWord(this.cpu.edi & 0xFFFF);
            }
            case 308: {
                return this.cpu.gs.getQuadWord(this.getMicrocode() & 0xFFFF);
            }
            case 309: {
                return this.cpu.gs.getQuadWord(this.cpu.ebx & 0xFFFF);
            }
            case 310: {
                return this.cpu.gs.getQuadWord(this.cpu.ebx + this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 311: {
                return this.cpu.gs.getQuadWord(this.cpu.ebx + this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 312: {
                return this.cpu.gs.getQuadWord(this.cpu.ebp + this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 313: {
                return this.cpu.gs.getQuadWord(this.cpu.ebp + this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 314: {
                return this.cpu.gs.getQuadWord(this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 315: {
                return this.cpu.gs.getQuadWord(this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 316: {
                return this.cpu.gs.getQuadWord(this.cpu.ebp + this.getMicrocode() & 0xFFFF);
            }
            case 317: {
                return this.cpu.gs.getQuadWord(this.cpu.ebx + this.getMicrocode() & 0xFFFF);
            }
            case 318: {
                return this.cpu.gs.getQuadWord(this.cpu.ebx + this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 319: {
                return this.cpu.gs.getQuadWord(this.cpu.ebx + this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 320: {
                return this.cpu.gs.getQuadWord(this.cpu.ebp + this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 321: {
                return this.cpu.gs.getQuadWord(this.cpu.ebp + this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 322: {
                return this.cpu.gs.getQuadWord(this.cpu.esi + this.getMicrocode() & 0xFFFF);
            }
            case 323: {
                return this.cpu.gs.getQuadWord(this.cpu.edi + this.getMicrocode() & 0xFFFF);
            }
            case 324: {
                return this.cpu.gs.getQuadWord(this.cpu.ebp + this.getMicrocode() & 0xFFFF);
            }
            case 325: {
                return this.cpu.gs.getQuadWord(this.cpu.ebx + this.getMicrocode() & 0xFFFF);
            }
            case 81: {
                return this.cpu.cs.getQuadWord(this.getMicrocode());
            }
            case 105: {
                return this.cpu.ss.getQuadWord(this.cpu.eax + this.getMicrocode());
            }
            case 106: {
                return this.cpu.ss.getQuadWord(this.cpu.ecx + this.getMicrocode());
            }
            case 107: {
                return this.cpu.ss.getQuadWord(this.cpu.edx + this.getMicrocode());
            }
            case 108: {
                return this.cpu.ss.getQuadWord(this.cpu.ebx + this.getMicrocode());
            }
            case 109: {
                return this.cpu.ss.getQuadWord(this.cpu.ebp + this.getMicrocode());
            }
            case 110: {
                return this.cpu.ss.getQuadWord(this.cpu.esi + this.getMicrocode());
            }
            case 111: {
                return this.cpu.ss.getQuadWord(this.cpu.edi + this.getMicrocode());
            }
            case 112: {
                return this.cpu.ss.getQuadWord(this.cpu.eax + this.getMicrocode());
            }
            case 113: {
                return this.cpu.ss.getQuadWord(this.cpu.ecx + this.getMicrocode());
            }
            case 114: {
                return this.cpu.ss.getQuadWord(this.cpu.edx + this.getMicrocode());
            }
            case 115: {
                return this.cpu.ss.getQuadWord(this.cpu.ebx + this.getMicrocode());
            }
            case 116: {
                return this.cpu.ss.getQuadWord(this.cpu.ebp + this.getMicrocode());
            }
            case 117: {
                return this.cpu.ss.getQuadWord(this.cpu.esi + this.getMicrocode());
            }
            case 118: {
                return this.cpu.ss.getQuadWord(this.cpu.edi + this.getMicrocode());
            }
            case 119: {
                return this.cpu.ds.getQuadWord(this.cpu.eax);
            }
            case 120: {
                return this.cpu.ds.getQuadWord(this.cpu.ecx);
            }
            case 121: {
                return this.cpu.ds.getQuadWord(this.cpu.edx);
            }
            case 122: {
                return this.cpu.ds.getQuadWord(this.cpu.ebx);
            }
            case 123: {
                return this.cpu.ds.getQuadWord(this.getMicrocode());
            }
            case 124: {
                return this.cpu.ds.getQuadWord(this.cpu.esi);
            }
            case 125: {
                return this.cpu.ds.getQuadWord(this.cpu.edi);
            }
            case 126: {
                return this.cpu.ds.getQuadWord(this.cpu.eax + this.getMicrocode());
            }
            case 127: {
                return this.cpu.ds.getQuadWord(this.cpu.ecx + this.getMicrocode());
            }
            case 128: {
                return this.cpu.ds.getQuadWord(this.cpu.edx + this.getMicrocode());
            }
            case 129: {
                return this.cpu.ds.getQuadWord(this.cpu.ebx + this.getMicrocode());
            }
            case 130: {
                return this.cpu.ds.getQuadWord(this.cpu.ebp + this.getMicrocode());
            }
            case 131: {
                return this.cpu.ds.getQuadWord(this.cpu.esi + this.getMicrocode());
            }
            case 132: {
                return this.cpu.ds.getQuadWord(this.cpu.edi + this.getMicrocode());
            }
            case 133: {
                return this.cpu.ds.getQuadWord(this.cpu.eax + this.getMicrocode());
            }
            case 134: {
                return this.cpu.ds.getQuadWord(this.cpu.ecx + this.getMicrocode());
            }
            case 135: {
                return this.cpu.ds.getQuadWord(this.cpu.edx + this.getMicrocode());
            }
            case 136: {
                return this.cpu.ds.getQuadWord(this.cpu.ebx + this.getMicrocode());
            }
            case 137: {
                return this.cpu.ds.getQuadWord(this.cpu.ebp + this.getMicrocode());
            }
            case 138: {
                return this.cpu.ds.getQuadWord(this.cpu.esi + this.getMicrocode());
            }
            case 139: {
                return this.cpu.ds.getQuadWord(this.cpu.edi + this.getMicrocode());
            }
            case 338: {
                return this.cpu.ds.getQuadWord(this.cpu.eax + this.cpu.eax);
            }
            case 339: {
                return this.cpu.ds.getQuadWord(this.cpu.eax + this.cpu.ecx);
            }
            case 340: {
                return this.cpu.ds.getQuadWord(this.cpu.eax + this.cpu.edx);
            }
            case 341: {
                return this.cpu.ds.getQuadWord(this.cpu.eax + this.cpu.ebx);
            }
            case 342: {
                return this.cpu.ds.getQuadWord(this.cpu.eax + this.cpu.esp);
            }
            case 343: {
                return this.cpu.ds.getQuadWord(this.cpu.eax + this.cpu.ebp);
            }
            case 344: {
                return this.cpu.ds.getQuadWord(this.cpu.eax + this.cpu.esi);
            }
            case 345: {
                return this.cpu.ds.getQuadWord(this.cpu.eax + this.cpu.edi);
            }
            case 346: {
                return this.cpu.ds.getQuadWord(this.cpu.ecx + this.cpu.ecx);
            }
            case 347: {
                return this.cpu.ds.getQuadWord(this.cpu.ecx + this.cpu.edx);
            }
            case 348: {
                return this.cpu.ds.getQuadWord(this.cpu.ecx + this.cpu.ebx);
            }
            case 349: {
                return this.cpu.ds.getQuadWord(this.cpu.ecx + this.cpu.esp);
            }
            case 350: {
                return this.cpu.ds.getQuadWord(this.cpu.ecx + this.cpu.ebp);
            }
            case 351: {
                return this.cpu.ds.getQuadWord(this.cpu.ecx + this.cpu.esi);
            }
            case 352: {
                return this.cpu.ds.getQuadWord(this.cpu.ecx + this.cpu.edi);
            }
            case 353: {
                return this.cpu.ds.getQuadWord(this.cpu.edx + this.cpu.edx);
            }
            case 354: {
                return this.cpu.ds.getQuadWord(this.cpu.edx + this.cpu.ebx);
            }
            case 355: {
                return this.cpu.ds.getQuadWord(this.cpu.edx + this.cpu.esp);
            }
            case 356: {
                return this.cpu.ds.getQuadWord(this.cpu.edx + this.cpu.ebp);
            }
            case 357: {
                return this.cpu.ds.getQuadWord(this.cpu.edx + this.cpu.esi);
            }
            case 358: {
                return this.cpu.ds.getQuadWord(this.cpu.edx + this.cpu.edi);
            }
            case 359: {
                return this.cpu.ds.getQuadWord(this.cpu.ebx + this.cpu.ebx);
            }
            case 360: {
                return this.cpu.ds.getQuadWord(this.cpu.ebx + this.cpu.esp);
            }
            case 361: {
                return this.cpu.ds.getQuadWord(this.cpu.ebx + this.cpu.ebp);
            }
            case 362: {
                return this.cpu.ds.getQuadWord(this.cpu.ebx + this.cpu.esi);
            }
            case 363: {
                return this.cpu.ds.getQuadWord(this.cpu.ebx + this.cpu.edi);
            }
            case 364: {
                return this.cpu.ds.getQuadWord(this.cpu.esp);
            }
            case 365: {
                return this.cpu.ds.getQuadWord(this.cpu.ebp + this.cpu.esp);
            }
            case 366: {
                return this.cpu.ds.getQuadWord(this.cpu.ebp + this.cpu.esi);
            }
            case 367: {
                return this.cpu.ds.getQuadWord(this.cpu.ebp + this.cpu.edi);
            }
            case 368: {
                return this.cpu.ds.getQuadWord(this.cpu.esi + this.cpu.esp);
            }
            case 369: {
                return this.cpu.ds.getQuadWord(this.cpu.esi + this.cpu.esi);
            }
            case 370: {
                return this.cpu.ds.getQuadWord(this.cpu.esi + this.cpu.edi);
            }
            case 371: {
                return this.cpu.ds.getQuadWord(this.cpu.edi + this.cpu.esp);
            }
            case 372: {
                return this.cpu.ds.getQuadWord(this.cpu.edi + this.cpu.edi);
            }
            case 373: {
                return this.cpu.ds.getQuadWord((this.cpu.eax << 1) + this.cpu.eax);
            }
            case 374: {
                return this.cpu.ds.getQuadWord((this.cpu.eax << 1) + this.cpu.ecx);
            }
            case 375: {
                return this.cpu.ds.getQuadWord((this.cpu.eax << 1) + this.cpu.edx);
            }
            case 376: {
                return this.cpu.ds.getQuadWord((this.cpu.eax << 1) + this.cpu.ebx);
            }
            case 377: {
                return this.cpu.ds.getQuadWord((this.cpu.eax << 1) + this.cpu.esp);
            }
            case 378: {
                return this.cpu.ds.getQuadWord((this.cpu.eax << 1) + this.getMicrocode());
            }
            case 379: {
                return this.cpu.ds.getQuadWord((this.cpu.eax << 1) + this.cpu.esi);
            }
            case 380: {
                return this.cpu.ds.getQuadWord((this.cpu.eax << 1) + this.cpu.edi);
            }
            case 381: {
                return this.cpu.ds.getQuadWord((this.cpu.ecx << 1) + this.cpu.eax);
            }
            case 382: {
                return this.cpu.ds.getQuadWord((this.cpu.ecx << 1) + this.cpu.ecx);
            }
            case 383: {
                return this.cpu.ds.getQuadWord((this.cpu.ecx << 1) + this.cpu.edx);
            }
            case 384: {
                return this.cpu.ds.getQuadWord((this.cpu.ecx << 1) + this.cpu.ebx);
            }
            case 385: {
                return this.cpu.ds.getQuadWord((this.cpu.ecx << 1) + this.cpu.esp);
            }
            case 386: {
                return this.cpu.ds.getQuadWord((this.cpu.ecx << 1) + this.getMicrocode());
            }
            case 387: {
                return this.cpu.ds.getQuadWord((this.cpu.ecx << 1) + this.cpu.esi);
            }
            case 388: {
                return this.cpu.ds.getQuadWord((this.cpu.ecx << 1) + this.cpu.edi);
            }
            case 389: {
                return this.cpu.ds.getQuadWord((this.cpu.edx << 1) + this.cpu.eax);
            }
            case 390: {
                return this.cpu.ds.getQuadWord((this.cpu.edx << 1) + this.cpu.ecx);
            }
            case 391: {
                return this.cpu.ds.getQuadWord((this.cpu.edx << 1) + this.cpu.edx);
            }
            case 392: {
                return this.cpu.ds.getQuadWord((this.cpu.edx << 1) + this.cpu.ebx);
            }
            case 393: {
                return this.cpu.ds.getQuadWord((this.cpu.edx << 1) + this.cpu.esp);
            }
            case 394: {
                return this.cpu.ds.getQuadWord((this.cpu.edx << 1) + this.getMicrocode());
            }
            case 395: {
                return this.cpu.ds.getQuadWord((this.cpu.edx << 1) + this.cpu.esi);
            }
            case 396: {
                return this.cpu.ds.getQuadWord((this.cpu.edx << 1) + this.cpu.edi);
            }
            case 397: {
                return this.cpu.ds.getQuadWord((this.cpu.ebx << 1) + this.cpu.eax);
            }
            case 398: {
                return this.cpu.ds.getQuadWord((this.cpu.ebx << 1) + this.cpu.ecx);
            }
            case 399: {
                return this.cpu.ds.getQuadWord((this.cpu.ebx << 1) + this.cpu.edx);
            }
            case 400: {
                return this.cpu.ds.getQuadWord((this.cpu.ebx << 1) + this.cpu.ebx);
            }
            case 401: {
                return this.cpu.ds.getQuadWord((this.cpu.ebx << 1) + this.cpu.esp);
            }
            case 402: {
                return this.cpu.ds.getQuadWord((this.cpu.ebx << 1) + this.getMicrocode());
            }
            case 403: {
                return this.cpu.ds.getQuadWord((this.cpu.ebx << 1) + this.cpu.esi);
            }
            case 404: {
                return this.cpu.ds.getQuadWord((this.cpu.ebx << 1) + this.cpu.edi);
            }
            case 405: {
                return this.cpu.ds.getQuadWord((this.cpu.ebp << 1) + this.cpu.eax);
            }
            case 406: {
                return this.cpu.ds.getQuadWord((this.cpu.ebp << 1) + this.cpu.ecx);
            }
            case 407: {
                return this.cpu.ds.getQuadWord((this.cpu.ebp << 1) + this.cpu.edx);
            }
            case 408: {
                return this.cpu.ds.getQuadWord((this.cpu.ebp << 1) + this.cpu.ebx);
            }
            case 409: {
                return this.cpu.ds.getQuadWord((this.cpu.ebp << 1) + this.cpu.esp);
            }
            case 410: {
                return this.cpu.ds.getQuadWord((this.cpu.ebp << 1) + this.getMicrocode());
            }
            case 411: {
                return this.cpu.ds.getQuadWord((this.cpu.ebp << 1) + this.cpu.esi);
            }
            case 412: {
                return this.cpu.ds.getQuadWord((this.cpu.ebp << 1) + this.cpu.edi);
            }
            case 413: {
                return this.cpu.ds.getQuadWord((this.cpu.esi << 1) + this.cpu.eax);
            }
            case 414: {
                return this.cpu.ds.getQuadWord((this.cpu.esi << 1) + this.cpu.ecx);
            }
            case 415: {
                return this.cpu.ds.getQuadWord((this.cpu.esi << 1) + this.cpu.edx);
            }
            case 416: {
                return this.cpu.ds.getQuadWord((this.cpu.esi << 1) + this.cpu.ebx);
            }
            case 417: {
                return this.cpu.ds.getQuadWord((this.cpu.esi << 1) + this.cpu.esp);
            }
            case 418: {
                return this.cpu.ds.getQuadWord((this.cpu.esi << 1) + this.getMicrocode());
            }
            case 419: {
                return this.cpu.ds.getQuadWord((this.cpu.esi << 1) + this.cpu.esi);
            }
            case 420: {
                return this.cpu.ds.getQuadWord((this.cpu.esi << 1) + this.cpu.edi);
            }
            case 421: {
                return this.cpu.ds.getQuadWord((this.cpu.edi << 1) + this.cpu.eax);
            }
            case 422: {
                return this.cpu.ds.getQuadWord((this.cpu.edi << 1) + this.cpu.ecx);
            }
            case 423: {
                return this.cpu.ds.getQuadWord((this.cpu.edi << 1) + this.cpu.edx);
            }
            case 424: {
                return this.cpu.ds.getQuadWord((this.cpu.edi << 1) + this.cpu.ebx);
            }
            case 425: {
                return this.cpu.ds.getQuadWord((this.cpu.edi << 1) + this.cpu.esp);
            }
            case 426: {
                return this.cpu.ds.getQuadWord((this.cpu.edi << 1) + this.getMicrocode());
            }
            case 427: {
                return this.cpu.ds.getQuadWord((this.cpu.edi << 1) + this.cpu.esi);
            }
            case 428: {
                return this.cpu.ds.getQuadWord((this.cpu.edi << 1) + this.cpu.edi);
            }
            case 429: {
                return this.cpu.ds.getQuadWord((this.cpu.eax << 2) + this.cpu.eax);
            }
            case 430: {
                return this.cpu.ds.getQuadWord((this.cpu.eax << 2) + this.cpu.ecx);
            }
            case 431: {
                return this.cpu.ds.getQuadWord((this.cpu.eax << 2) + this.cpu.edx);
            }
            case 432: {
                return this.cpu.ds.getQuadWord((this.cpu.eax << 2) + this.cpu.ebx);
            }
            case 433: {
                return this.cpu.ds.getQuadWord((this.cpu.eax << 2) + this.cpu.esp);
            }
            case 434: {
                return this.cpu.ds.getQuadWord((this.cpu.eax << 2) + this.getMicrocode());
            }
            case 435: {
                return this.cpu.ds.getQuadWord((this.cpu.eax << 2) + this.cpu.esi);
            }
            case 436: {
                return this.cpu.ds.getQuadWord((this.cpu.eax << 2) + this.cpu.edi);
            }
            case 437: {
                return this.cpu.ds.getQuadWord((this.cpu.ecx << 2) + this.cpu.eax);
            }
            case 438: {
                return this.cpu.ds.getQuadWord((this.cpu.ecx << 2) + this.cpu.ecx);
            }
            case 439: {
                return this.cpu.ds.getQuadWord((this.cpu.ecx << 2) + this.cpu.edx);
            }
            case 440: {
                return this.cpu.ds.getQuadWord((this.cpu.ecx << 2) + this.cpu.ebx);
            }
            case 441: {
                return this.cpu.ds.getQuadWord((this.cpu.ecx << 2) + this.cpu.esp);
            }
            case 442: {
                return this.cpu.ds.getQuadWord((this.cpu.ecx << 2) + this.getMicrocode());
            }
            case 443: {
                return this.cpu.ds.getQuadWord((this.cpu.ecx << 2) + this.cpu.esi);
            }
            case 444: {
                return this.cpu.ds.getQuadWord((this.cpu.ecx << 2) + this.cpu.edi);
            }
            case 445: {
                return this.cpu.ds.getQuadWord((this.cpu.edx << 2) + this.cpu.eax);
            }
            case 446: {
                return this.cpu.ds.getQuadWord((this.cpu.edx << 2) + this.cpu.ecx);
            }
            case 447: {
                return this.cpu.ds.getQuadWord((this.cpu.edx << 2) + this.cpu.edx);
            }
            case 448: {
                return this.cpu.ds.getQuadWord((this.cpu.edx << 2) + this.cpu.ebx);
            }
            case 449: {
                return this.cpu.ds.getQuadWord((this.cpu.edx << 2) + this.cpu.esp);
            }
            case 450: {
                return this.cpu.ds.getQuadWord((this.cpu.edx << 2) + this.getMicrocode());
            }
            case 451: {
                return this.cpu.ds.getQuadWord((this.cpu.edx << 2) + this.cpu.esi);
            }
            case 452: {
                return this.cpu.ds.getQuadWord((this.cpu.edx << 2) + this.cpu.edi);
            }
            case 453: {
                return this.cpu.ds.getQuadWord((this.cpu.ebx << 2) + this.cpu.eax);
            }
            case 454: {
                return this.cpu.ds.getQuadWord((this.cpu.ebx << 2) + this.cpu.ecx);
            }
            case 455: {
                return this.cpu.ds.getQuadWord((this.cpu.ebx << 2) + this.cpu.edx);
            }
            case 456: {
                return this.cpu.ds.getQuadWord((this.cpu.ebx << 2) + this.cpu.ebx);
            }
            case 457: {
                return this.cpu.ds.getQuadWord((this.cpu.ebx << 2) + this.cpu.esp);
            }
            case 458: {
                return this.cpu.ds.getQuadWord((this.cpu.ebx << 2) + this.getMicrocode());
            }
            case 459: {
                return this.cpu.ds.getQuadWord((this.cpu.ebx << 2) + this.cpu.esi);
            }
            case 460: {
                return this.cpu.ds.getQuadWord((this.cpu.ebx << 2) + this.cpu.edi);
            }
            case 461: {
                return this.cpu.ds.getQuadWord((this.cpu.ebp << 2) + this.cpu.eax);
            }
            case 462: {
                return this.cpu.ds.getQuadWord((this.cpu.ebp << 2) + this.cpu.ecx);
            }
            case 463: {
                return this.cpu.ds.getQuadWord((this.cpu.ebp << 2) + this.cpu.edx);
            }
            case 464: {
                return this.cpu.ds.getQuadWord((this.cpu.ebp << 2) + this.cpu.ebx);
            }
            case 465: {
                return this.cpu.ds.getQuadWord((this.cpu.ebp << 2) + this.cpu.esp);
            }
            case 466: {
                return this.cpu.ds.getQuadWord((this.cpu.ebp << 2) + this.getMicrocode());
            }
            case 467: {
                return this.cpu.ds.getQuadWord((this.cpu.ebp << 2) + this.cpu.esi);
            }
            case 468: {
                return this.cpu.ds.getQuadWord((this.cpu.ebp << 2) + this.cpu.edi);
            }
            case 469: {
                return this.cpu.ds.getQuadWord((this.cpu.esi << 2) + this.cpu.eax);
            }
            case 470: {
                return this.cpu.ds.getQuadWord((this.cpu.esi << 2) + this.cpu.ecx);
            }
            case 471: {
                return this.cpu.ds.getQuadWord((this.cpu.esi << 2) + this.cpu.edx);
            }
            case 472: {
                return this.cpu.ds.getQuadWord((this.cpu.esi << 2) + this.cpu.ebx);
            }
            case 473: {
                return this.cpu.ds.getQuadWord((this.cpu.esi << 2) + this.cpu.esp);
            }
            case 474: {
                return this.cpu.ds.getQuadWord((this.cpu.esi << 2) + this.getMicrocode());
            }
            case 475: {
                return this.cpu.ds.getQuadWord((this.cpu.esi << 2) + this.cpu.esi);
            }
            case 476: {
                return this.cpu.ds.getQuadWord((this.cpu.esi << 2) + this.cpu.edi);
            }
            case 477: {
                return this.cpu.ds.getQuadWord((this.cpu.edi << 2) + this.cpu.eax);
            }
            case 478: {
                return this.cpu.ds.getQuadWord((this.cpu.edi << 2) + this.cpu.ecx);
            }
            case 479: {
                return this.cpu.ds.getQuadWord((this.cpu.edi << 2) + this.cpu.edx);
            }
            case 480: {
                return this.cpu.ds.getQuadWord((this.cpu.edi << 2) + this.cpu.ebx);
            }
            case 481: {
                return this.cpu.ds.getQuadWord((this.cpu.edi << 2) + this.cpu.esp);
            }
            case 482: {
                return this.cpu.ds.getQuadWord((this.cpu.edi << 2) + this.getMicrocode());
            }
            case 483: {
                return this.cpu.ds.getQuadWord((this.cpu.edi << 2) + this.cpu.esi);
            }
            case 484: {
                return this.cpu.ds.getQuadWord((this.cpu.edi << 2) + this.cpu.edi);
            }
            case 485: {
                return this.cpu.ds.getQuadWord((this.cpu.eax << 3) + this.cpu.eax);
            }
            case 486: {
                return this.cpu.ds.getQuadWord((this.cpu.eax << 3) + this.cpu.ecx);
            }
            case 487: {
                return this.cpu.ds.getQuadWord((this.cpu.eax << 3) + this.cpu.edx);
            }
            case 488: {
                return this.cpu.ds.getQuadWord((this.cpu.eax << 3) + this.cpu.ebx);
            }
            case 489: {
                return this.cpu.ds.getQuadWord((this.cpu.eax << 3) + this.cpu.esp);
            }
            case 490: {
                return this.cpu.ds.getQuadWord((this.cpu.eax << 3) + this.getMicrocode());
            }
            case 491: {
                return this.cpu.ds.getQuadWord((this.cpu.eax << 3) + this.cpu.esi);
            }
            case 492: {
                return this.cpu.ds.getQuadWord((this.cpu.eax << 3) + this.cpu.edi);
            }
            case 493: {
                return this.cpu.ds.getQuadWord((this.cpu.ecx << 3) + this.cpu.eax);
            }
            case 494: {
                return this.cpu.ds.getQuadWord((this.cpu.ecx << 3) + this.cpu.ecx);
            }
            case 495: {
                return this.cpu.ds.getQuadWord((this.cpu.ecx << 3) + this.cpu.edx);
            }
            case 496: {
                return this.cpu.ds.getQuadWord((this.cpu.ecx << 3) + this.cpu.ebx);
            }
            case 497: {
                return this.cpu.ds.getQuadWord((this.cpu.ecx << 3) + this.cpu.esp);
            }
            case 498: {
                return this.cpu.ds.getQuadWord((this.cpu.ecx << 3) + this.getMicrocode());
            }
            case 499: {
                return this.cpu.ds.getQuadWord((this.cpu.ecx << 3) + this.cpu.esi);
            }
            case 500: {
                return this.cpu.ds.getQuadWord((this.cpu.ecx << 3) + this.cpu.edi);
            }
            case 501: {
                return this.cpu.ds.getQuadWord((this.cpu.edx << 3) + this.cpu.eax);
            }
            case 502: {
                return this.cpu.ds.getQuadWord((this.cpu.edx << 3) + this.cpu.ecx);
            }
            case 503: {
                return this.cpu.ds.getQuadWord((this.cpu.edx << 3) + this.cpu.edx);
            }
            case 504: {
                return this.cpu.ds.getQuadWord((this.cpu.edx << 3) + this.cpu.ebx);
            }
            case 505: {
                return this.cpu.ds.getQuadWord((this.cpu.edx << 3) + this.cpu.esp);
            }
            case 506: {
                return this.cpu.ds.getQuadWord((this.cpu.edx << 3) + this.getMicrocode());
            }
            case 507: {
                return this.cpu.ds.getQuadWord((this.cpu.edx << 3) + this.cpu.esi);
            }
            case 508: {
                return this.cpu.ds.getQuadWord((this.cpu.edx << 3) + this.cpu.edi);
            }
            case 509: {
                return this.cpu.ds.getQuadWord((this.cpu.ebx << 3) + this.cpu.eax);
            }
            case 510: {
                return this.cpu.ds.getQuadWord((this.cpu.ebx << 3) + this.cpu.ecx);
            }
            case 511: {
                return this.cpu.ds.getQuadWord((this.cpu.ebx << 3) + this.cpu.edx);
            }
            case 512: {
                return this.cpu.ds.getQuadWord((this.cpu.ebx << 3) + this.cpu.ebx);
            }
            case 513: {
                return this.cpu.ds.getQuadWord((this.cpu.ebx << 3) + this.cpu.esp);
            }
            case 514: {
                return this.cpu.ds.getQuadWord((this.cpu.ebx << 3) + this.getMicrocode());
            }
            case 515: {
                return this.cpu.ds.getQuadWord((this.cpu.ebx << 3) + this.cpu.esi);
            }
            case 516: {
                return this.cpu.ds.getQuadWord((this.cpu.ebx << 3) + this.cpu.edi);
            }
            case 517: {
                return this.cpu.ds.getQuadWord((this.cpu.ebp << 3) + this.cpu.eax);
            }
            case 518: {
                return this.cpu.ds.getQuadWord((this.cpu.ebp << 3) + this.cpu.ecx);
            }
            case 519: {
                return this.cpu.ds.getQuadWord((this.cpu.ebp << 3) + this.cpu.edx);
            }
            case 520: {
                return this.cpu.ds.getQuadWord((this.cpu.ebp << 3) + this.cpu.ebx);
            }
            case 521: {
                return this.cpu.ds.getQuadWord((this.cpu.ebp << 3) + this.cpu.esp);
            }
            case 522: {
                return this.cpu.ds.getQuadWord((this.cpu.ebp << 3) + this.getMicrocode());
            }
            case 523: {
                return this.cpu.ds.getQuadWord((this.cpu.ebp << 3) + this.cpu.esi);
            }
            case 524: {
                return this.cpu.ds.getQuadWord((this.cpu.ebp << 3) + this.cpu.edi);
            }
            case 525: {
                return this.cpu.ds.getQuadWord((this.cpu.esi << 3) + this.cpu.eax);
            }
            case 526: {
                return this.cpu.ds.getQuadWord((this.cpu.esi << 3) + this.cpu.ecx);
            }
            case 527: {
                return this.cpu.ds.getQuadWord((this.cpu.esi << 3) + this.cpu.edx);
            }
            case 528: {
                return this.cpu.ds.getQuadWord((this.cpu.esi << 3) + this.cpu.ebx);
            }
            case 529: {
                return this.cpu.ds.getQuadWord((this.cpu.esi << 3) + this.cpu.esp);
            }
            case 530: {
                return this.cpu.ds.getQuadWord((this.cpu.esi << 3) + this.getMicrocode());
            }
            case 531: {
                return this.cpu.ds.getQuadWord((this.cpu.esi << 3) + this.cpu.esi);
            }
            case 532: {
                return this.cpu.ds.getQuadWord((this.cpu.esi << 3) + this.cpu.edi);
            }
            case 533: {
                return this.cpu.ds.getQuadWord((this.cpu.edi << 3) + this.cpu.eax);
            }
            case 534: {
                return this.cpu.ds.getQuadWord((this.cpu.edi << 3) + this.cpu.ecx);
            }
            case 535: {
                return this.cpu.ds.getQuadWord((this.cpu.edi << 3) + this.cpu.edx);
            }
            case 536: {
                return this.cpu.ds.getQuadWord((this.cpu.edi << 3) + this.cpu.ebx);
            }
            case 537: {
                return this.cpu.ds.getQuadWord((this.cpu.edi << 3) + this.cpu.esp);
            }
            case 538: {
                return this.cpu.ds.getQuadWord((this.cpu.edi << 3) + this.getMicrocode());
            }
            case 539: {
                return this.cpu.ds.getQuadWord((this.cpu.edi << 3) + this.cpu.esi);
            }
            case 540: {
                return this.cpu.ds.getQuadWord((this.cpu.edi << 3) + this.cpu.edi);
            }
            case 541: {
                return this.cpu.ds.getQuadWord(this.cpu.eax + this.cpu.eax + this.getMicrocode());
            }
            case 542: {
                return this.cpu.ds.getQuadWord(this.cpu.eax + this.cpu.ecx + this.getMicrocode());
            }
            case 543: {
                return this.cpu.ds.getQuadWord(this.cpu.eax + this.cpu.edx + this.getMicrocode());
            }
            case 544: {
                return this.cpu.ds.getQuadWord(this.cpu.eax + this.cpu.ebx + this.getMicrocode());
            }
            case 545: {
                return this.cpu.ds.getQuadWord(this.cpu.eax + this.cpu.esp + this.getMicrocode());
            }
            case 546: {
                return this.cpu.ds.getQuadWord(this.cpu.eax + this.cpu.ebp + this.getMicrocode());
            }
            case 547: {
                return this.cpu.ds.getQuadWord(this.cpu.eax + this.cpu.esi + this.getMicrocode());
            }
            case 548: {
                return this.cpu.ds.getQuadWord(this.cpu.eax + this.cpu.edi + this.getMicrocode());
            }
            case 549: {
                return this.cpu.ds.getQuadWord(this.cpu.ecx + this.cpu.ecx + this.getMicrocode());
            }
            case 550: {
                return this.cpu.ds.getQuadWord(this.cpu.ecx + this.cpu.edx + this.getMicrocode());
            }
            case 551: {
                return this.cpu.ds.getQuadWord(this.cpu.ecx + this.cpu.ebx + this.getMicrocode());
            }
            case 552: {
                return this.cpu.ds.getQuadWord(this.cpu.ecx + this.cpu.esp + this.getMicrocode());
            }
            case 553: {
                return this.cpu.ds.getQuadWord(this.cpu.ecx + this.cpu.ebp + this.getMicrocode());
            }
            case 554: {
                return this.cpu.ds.getQuadWord(this.cpu.ecx + this.cpu.esi + this.getMicrocode());
            }
            case 555: {
                return this.cpu.ds.getQuadWord(this.cpu.ecx + this.cpu.edi + this.getMicrocode());
            }
            case 556: {
                return this.cpu.ds.getQuadWord(this.cpu.edx + this.cpu.edx + this.getMicrocode());
            }
            case 557: {
                return this.cpu.ds.getQuadWord(this.cpu.edx + this.cpu.ebx + this.getMicrocode());
            }
            case 558: {
                return this.cpu.ds.getQuadWord(this.cpu.edx + this.cpu.esp + this.getMicrocode());
            }
            case 559: {
                return this.cpu.ds.getQuadWord(this.cpu.edx + this.cpu.ebp + this.getMicrocode());
            }
            case 560: {
                return this.cpu.ds.getQuadWord(this.cpu.edx + this.cpu.esi + this.getMicrocode());
            }
            case 561: {
                return this.cpu.ds.getQuadWord(this.cpu.edx + this.cpu.edi + this.getMicrocode());
            }
            case 562: {
                return this.cpu.ds.getQuadWord(this.cpu.ebx + this.cpu.ebx + this.getMicrocode());
            }
            case 563: {
                return this.cpu.ds.getQuadWord(this.cpu.ebx + this.cpu.esp + this.getMicrocode());
            }
            case 564: {
                return this.cpu.ds.getQuadWord(this.cpu.ebx + this.cpu.ebp + this.getMicrocode());
            }
            case 565: {
                return this.cpu.ds.getQuadWord(this.cpu.ebx + this.cpu.esi + this.getMicrocode());
            }
            case 566: {
                return this.cpu.ds.getQuadWord(this.cpu.ebx + this.cpu.edi + this.getMicrocode());
            }
            case 567: {
                return this.cpu.ds.getQuadWord(this.cpu.esp + this.getMicrocode());
            }
            case 568: {
                return this.cpu.ds.getQuadWord(this.cpu.ebp + this.cpu.esp + this.getMicrocode());
            }
            case 569: {
                return this.cpu.ds.getQuadWord(this.cpu.ebp + this.cpu.ebp + this.getMicrocode());
            }
            case 570: {
                return this.cpu.ds.getQuadWord(this.cpu.ebp + this.cpu.esi + this.getMicrocode());
            }
            case 571: {
                return this.cpu.ds.getQuadWord(this.cpu.ebp + this.cpu.edi + this.getMicrocode());
            }
            case 572: {
                return this.cpu.ds.getQuadWord(this.cpu.esi + this.cpu.esp + this.getMicrocode());
            }
            case 573: {
                return this.cpu.ds.getQuadWord(this.cpu.esi + this.cpu.esi + this.getMicrocode());
            }
            case 574: {
                return this.cpu.ds.getQuadWord(this.cpu.esi + this.cpu.edi + this.getMicrocode());
            }
            case 575: {
                return this.cpu.ds.getQuadWord(this.cpu.edi + this.cpu.esp + this.getMicrocode());
            }
            case 576: {
                return this.cpu.ds.getQuadWord(this.cpu.edi + this.cpu.edi + this.getMicrocode());
            }
            case 577: {
                return this.cpu.ds.getQuadWord((this.cpu.eax << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 578: {
                return this.cpu.ds.getQuadWord((this.cpu.eax << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 579: {
                return this.cpu.ds.getQuadWord((this.cpu.eax << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 580: {
                return this.cpu.ds.getQuadWord((this.cpu.eax << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 581: {
                return this.cpu.ds.getQuadWord((this.cpu.eax << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 582: {
                return this.cpu.ds.getQuadWord((this.cpu.eax << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 583: {
                return this.cpu.ds.getQuadWord((this.cpu.eax << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 584: {
                return this.cpu.ds.getQuadWord((this.cpu.eax << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 585: {
                return this.cpu.ds.getQuadWord((this.cpu.ecx << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 586: {
                return this.cpu.ds.getQuadWord((this.cpu.ecx << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 587: {
                return this.cpu.ds.getQuadWord((this.cpu.ecx << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 588: {
                return this.cpu.ds.getQuadWord((this.cpu.ecx << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 589: {
                return this.cpu.ds.getQuadWord((this.cpu.ecx << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 590: {
                return this.cpu.ds.getQuadWord((this.cpu.ecx << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 591: {
                return this.cpu.ds.getQuadWord((this.cpu.ecx << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 592: {
                return this.cpu.ds.getQuadWord((this.cpu.ecx << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 593: {
                return this.cpu.ds.getQuadWord((this.cpu.edx << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 594: {
                return this.cpu.ds.getQuadWord((this.cpu.edx << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 595: {
                return this.cpu.ds.getQuadWord((this.cpu.edx << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 596: {
                return this.cpu.ds.getQuadWord((this.cpu.edx << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 597: {
                return this.cpu.ds.getQuadWord((this.cpu.edx << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 598: {
                return this.cpu.ds.getQuadWord((this.cpu.edx << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 599: {
                return this.cpu.ds.getQuadWord((this.cpu.edx << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 600: {
                return this.cpu.ds.getQuadWord((this.cpu.edx << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 601: {
                return this.cpu.ds.getQuadWord((this.cpu.ebx << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 602: {
                return this.cpu.ds.getQuadWord((this.cpu.ebx << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 603: {
                return this.cpu.ds.getQuadWord((this.cpu.ebx << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 604: {
                return this.cpu.ds.getQuadWord((this.cpu.ebx << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 605: {
                return this.cpu.ds.getQuadWord((this.cpu.ebx << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 606: {
                return this.cpu.ds.getQuadWord((this.cpu.ebx << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 607: {
                return this.cpu.ds.getQuadWord((this.cpu.ebx << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 608: {
                return this.cpu.ds.getQuadWord((this.cpu.ebx << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 609: {
                return this.cpu.ds.getQuadWord((this.cpu.ebp << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 610: {
                return this.cpu.ds.getQuadWord((this.cpu.ebp << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 611: {
                return this.cpu.ds.getQuadWord((this.cpu.ebp << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 612: {
                return this.cpu.ds.getQuadWord((this.cpu.ebp << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 613: {
                return this.cpu.ds.getQuadWord((this.cpu.ebp << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 614: {
                return this.cpu.ds.getQuadWord((this.cpu.ebp << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 615: {
                return this.cpu.ds.getQuadWord((this.cpu.ebp << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 616: {
                return this.cpu.ds.getQuadWord((this.cpu.ebp << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 617: {
                return this.cpu.ds.getQuadWord((this.cpu.esi << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 618: {
                return this.cpu.ds.getQuadWord((this.cpu.esi << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 619: {
                return this.cpu.ds.getQuadWord((this.cpu.esi << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 620: {
                return this.cpu.ds.getQuadWord((this.cpu.esi << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 621: {
                return this.cpu.ds.getQuadWord((this.cpu.esi << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 622: {
                return this.cpu.ds.getQuadWord((this.cpu.esi << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 623: {
                return this.cpu.ds.getQuadWord((this.cpu.esi << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 624: {
                return this.cpu.ds.getQuadWord((this.cpu.esi << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 625: {
                return this.cpu.ds.getQuadWord((this.cpu.edi << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 626: {
                return this.cpu.ds.getQuadWord((this.cpu.edi << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 627: {
                return this.cpu.ds.getQuadWord((this.cpu.edi << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 628: {
                return this.cpu.ds.getQuadWord((this.cpu.edi << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 629: {
                return this.cpu.ds.getQuadWord((this.cpu.edi << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 630: {
                return this.cpu.ds.getQuadWord((this.cpu.edi << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 631: {
                return this.cpu.ds.getQuadWord((this.cpu.edi << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 632: {
                return this.cpu.ds.getQuadWord((this.cpu.edi << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 633: {
                return this.cpu.ds.getQuadWord((this.cpu.eax << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 634: {
                return this.cpu.ds.getQuadWord((this.cpu.eax << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 635: {
                return this.cpu.ds.getQuadWord((this.cpu.eax << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 636: {
                return this.cpu.ds.getQuadWord((this.cpu.eax << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 637: {
                return this.cpu.ds.getQuadWord((this.cpu.eax << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 638: {
                return this.cpu.ds.getQuadWord((this.cpu.eax << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 639: {
                return this.cpu.ds.getQuadWord((this.cpu.eax << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 640: {
                return this.cpu.ds.getQuadWord((this.cpu.eax << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 641: {
                return this.cpu.ds.getQuadWord((this.cpu.ecx << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 642: {
                return this.cpu.ds.getQuadWord((this.cpu.ecx << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 643: {
                return this.cpu.ds.getQuadWord((this.cpu.ecx << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 644: {
                return this.cpu.ds.getQuadWord((this.cpu.ecx << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 645: {
                return this.cpu.ds.getQuadWord((this.cpu.ecx << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 646: {
                return this.cpu.ds.getQuadWord((this.cpu.ecx << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 647: {
                return this.cpu.ds.getQuadWord((this.cpu.ecx << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 648: {
                return this.cpu.ds.getQuadWord((this.cpu.ecx << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 649: {
                return this.cpu.ds.getQuadWord((this.cpu.edx << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 650: {
                return this.cpu.ds.getQuadWord((this.cpu.edx << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 651: {
                return this.cpu.ds.getQuadWord((this.cpu.edx << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 652: {
                return this.cpu.ds.getQuadWord((this.cpu.edx << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 653: {
                return this.cpu.ds.getQuadWord((this.cpu.edx << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 654: {
                return this.cpu.ds.getQuadWord((this.cpu.edx << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 655: {
                return this.cpu.ds.getQuadWord((this.cpu.edx << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 656: {
                return this.cpu.ds.getQuadWord((this.cpu.edx << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 657: {
                return this.cpu.ds.getQuadWord((this.cpu.ebx << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 658: {
                return this.cpu.ds.getQuadWord((this.cpu.ebx << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 659: {
                return this.cpu.ds.getQuadWord((this.cpu.ebx << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 660: {
                return this.cpu.ds.getQuadWord((this.cpu.ebx << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 661: {
                return this.cpu.ds.getQuadWord((this.cpu.ebx << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 662: {
                return this.cpu.ds.getQuadWord((this.cpu.ebx << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 663: {
                return this.cpu.ds.getQuadWord((this.cpu.ebx << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 664: {
                return this.cpu.ds.getQuadWord((this.cpu.ebx << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 665: {
                return this.cpu.ds.getQuadWord((this.cpu.ebp << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 666: {
                return this.cpu.ds.getQuadWord((this.cpu.ebp << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 667: {
                return this.cpu.ds.getQuadWord((this.cpu.ebp << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 668: {
                return this.cpu.ds.getQuadWord((this.cpu.ebp << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 669: {
                return this.cpu.ds.getQuadWord((this.cpu.ebp << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 670: {
                return this.cpu.ds.getQuadWord((this.cpu.ebp << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 671: {
                return this.cpu.ds.getQuadWord((this.cpu.ebp << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 672: {
                return this.cpu.ds.getQuadWord((this.cpu.ebp << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 673: {
                return this.cpu.ds.getQuadWord((this.cpu.esi << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 674: {
                return this.cpu.ds.getQuadWord((this.cpu.esi << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 675: {
                return this.cpu.ds.getQuadWord((this.cpu.esi << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 676: {
                return this.cpu.ds.getQuadWord((this.cpu.esi << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 677: {
                return this.cpu.ds.getQuadWord((this.cpu.esi << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 678: {
                return this.cpu.ds.getQuadWord((this.cpu.esi << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 679: {
                return this.cpu.ds.getQuadWord((this.cpu.esi << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 680: {
                return this.cpu.ds.getQuadWord((this.cpu.esi << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 681: {
                return this.cpu.ds.getQuadWord((this.cpu.edi << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 682: {
                return this.cpu.ds.getQuadWord((this.cpu.edi << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 683: {
                return this.cpu.ds.getQuadWord((this.cpu.edi << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 684: {
                return this.cpu.ds.getQuadWord((this.cpu.edi << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 685: {
                return this.cpu.ds.getQuadWord((this.cpu.edi << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 686: {
                return this.cpu.ds.getQuadWord((this.cpu.edi << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 687: {
                return this.cpu.ds.getQuadWord((this.cpu.edi << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 688: {
                return this.cpu.ds.getQuadWord((this.cpu.edi << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 689: {
                return this.cpu.ds.getQuadWord((this.cpu.eax << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 690: {
                return this.cpu.ds.getQuadWord((this.cpu.eax << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 691: {
                return this.cpu.ds.getQuadWord((this.cpu.eax << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 692: {
                return this.cpu.ds.getQuadWord((this.cpu.eax << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 693: {
                return this.cpu.ds.getQuadWord((this.cpu.eax << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 694: {
                return this.cpu.ds.getQuadWord((this.cpu.eax << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 695: {
                return this.cpu.ds.getQuadWord((this.cpu.eax << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 696: {
                return this.cpu.ds.getQuadWord((this.cpu.eax << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 697: {
                return this.cpu.ds.getQuadWord((this.cpu.ecx << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 698: {
                return this.cpu.ds.getQuadWord((this.cpu.ecx << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 699: {
                return this.cpu.ds.getQuadWord((this.cpu.ecx << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 700: {
                return this.cpu.ds.getQuadWord((this.cpu.ecx << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 701: {
                return this.cpu.ds.getQuadWord((this.cpu.ecx << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 702: {
                return this.cpu.ds.getQuadWord((this.cpu.ecx << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 703: {
                return this.cpu.ds.getQuadWord((this.cpu.ecx << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 704: {
                return this.cpu.ds.getQuadWord((this.cpu.ecx << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 705: {
                return this.cpu.ds.getQuadWord((this.cpu.edx << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 706: {
                return this.cpu.ds.getQuadWord((this.cpu.edx << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 707: {
                return this.cpu.ds.getQuadWord((this.cpu.edx << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 708: {
                return this.cpu.ds.getQuadWord((this.cpu.edx << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 709: {
                return this.cpu.ds.getQuadWord((this.cpu.edx << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 710: {
                return this.cpu.ds.getQuadWord((this.cpu.edx << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 711: {
                return this.cpu.ds.getQuadWord((this.cpu.edx << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 712: {
                return this.cpu.ds.getQuadWord((this.cpu.edx << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 713: {
                return this.cpu.ds.getQuadWord((this.cpu.ebx << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 714: {
                return this.cpu.ds.getQuadWord((this.cpu.ebx << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 715: {
                return this.cpu.ds.getQuadWord((this.cpu.ebx << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 716: {
                return this.cpu.ds.getQuadWord((this.cpu.ebx << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 717: {
                return this.cpu.ds.getQuadWord((this.cpu.ebx << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 718: {
                return this.cpu.ds.getQuadWord((this.cpu.ebx << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 719: {
                return this.cpu.ds.getQuadWord((this.cpu.ebx << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 720: {
                return this.cpu.ds.getQuadWord((this.cpu.ebx << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 721: {
                return this.cpu.ds.getQuadWord((this.cpu.ebp << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 722: {
                return this.cpu.ds.getQuadWord((this.cpu.ebp << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 723: {
                return this.cpu.ds.getQuadWord((this.cpu.ebp << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 724: {
                return this.cpu.ds.getQuadWord((this.cpu.ebp << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 725: {
                return this.cpu.ds.getQuadWord((this.cpu.ebp << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 726: {
                return this.cpu.ds.getQuadWord((this.cpu.ebp << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 727: {
                return this.cpu.ds.getQuadWord((this.cpu.ebp << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 728: {
                return this.cpu.ds.getQuadWord((this.cpu.ebp << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 729: {
                return this.cpu.ds.getQuadWord((this.cpu.esi << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 730: {
                return this.cpu.ds.getQuadWord((this.cpu.esi << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 731: {
                return this.cpu.ds.getQuadWord((this.cpu.esi << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 732: {
                return this.cpu.ds.getQuadWord((this.cpu.esi << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 733: {
                return this.cpu.ds.getQuadWord((this.cpu.esi << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 734: {
                return this.cpu.ds.getQuadWord((this.cpu.esi << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 735: {
                return this.cpu.ds.getQuadWord((this.cpu.esi << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 736: {
                return this.cpu.ds.getQuadWord((this.cpu.esi << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 737: {
                return this.cpu.ds.getQuadWord((this.cpu.edi << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 738: {
                return this.cpu.ds.getQuadWord((this.cpu.edi << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 739: {
                return this.cpu.ds.getQuadWord((this.cpu.edi << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 740: {
                return this.cpu.ds.getQuadWord((this.cpu.edi << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 741: {
                return this.cpu.ds.getQuadWord((this.cpu.edi << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 742: {
                return this.cpu.ds.getQuadWord((this.cpu.edi << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 743: {
                return this.cpu.ds.getQuadWord((this.cpu.edi << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 744: {
                return this.cpu.ds.getQuadWord((this.cpu.edi << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 745: {
                return this.cpu.ds.getQuadWord(this.cpu.eax + this.cpu.ecx + this.getMicrocode());
            }
            case 746: {
                return this.cpu.ds.getQuadWord(this.cpu.eax + this.cpu.edx + this.getMicrocode());
            }
            case 747: {
                return this.cpu.ds.getQuadWord(this.cpu.eax + this.cpu.ebx + this.getMicrocode());
            }
            case 748: {
                return this.cpu.ds.getQuadWord(this.cpu.eax + this.cpu.esp + this.getMicrocode());
            }
            case 749: {
                return this.cpu.ds.getQuadWord(this.cpu.eax + this.cpu.ebp + this.getMicrocode());
            }
            case 750: {
                return this.cpu.ds.getQuadWord(this.cpu.eax + this.cpu.esi + this.getMicrocode());
            }
            case 751: {
                return this.cpu.ds.getQuadWord(this.cpu.eax + this.cpu.edi + this.getMicrocode());
            }
            case 752: {
                return this.cpu.ds.getQuadWord(this.cpu.ecx + this.cpu.edx + this.getMicrocode());
            }
            case 753: {
                return this.cpu.ds.getQuadWord(this.cpu.ecx + this.cpu.ebx + this.getMicrocode());
            }
            case 754: {
                return this.cpu.ds.getQuadWord(this.cpu.ecx + this.cpu.esp + this.getMicrocode());
            }
            case 755: {
                return this.cpu.ds.getQuadWord(this.cpu.ecx + this.cpu.ebp + this.getMicrocode());
            }
            case 756: {
                return this.cpu.ds.getQuadWord(this.cpu.ecx + this.cpu.esi + this.getMicrocode());
            }
            case 757: {
                return this.cpu.ds.getQuadWord(this.cpu.ecx + this.cpu.edi + this.getMicrocode());
            }
            case 758: {
                return this.cpu.ds.getQuadWord(this.cpu.edx + this.cpu.ebx + this.getMicrocode());
            }
            case 759: {
                return this.cpu.ds.getQuadWord(this.cpu.edx + this.cpu.esp + this.getMicrocode());
            }
            case 760: {
                return this.cpu.ds.getQuadWord(this.cpu.edx + this.cpu.ebp + this.getMicrocode());
            }
            case 761: {
                return this.cpu.ds.getQuadWord(this.cpu.edx + this.cpu.esi + this.getMicrocode());
            }
            case 762: {
                return this.cpu.ds.getQuadWord(this.cpu.edx + this.cpu.edi + this.getMicrocode());
            }
            case 763: {
                return this.cpu.ds.getQuadWord(this.cpu.ebx + this.cpu.esp + this.getMicrocode());
            }
            case 764: {
                return this.cpu.ds.getQuadWord(this.cpu.ebx + this.cpu.ebp + this.getMicrocode());
            }
            case 765: {
                return this.cpu.ds.getQuadWord(this.cpu.ebx + this.cpu.esi + this.getMicrocode());
            }
            case 766: {
                return this.cpu.ds.getQuadWord(this.cpu.ebx + this.cpu.edi + this.getMicrocode());
            }
            case 767: {
                return this.cpu.ds.getQuadWord(this.cpu.esp + this.getMicrocode());
            }
            case 768: {
                return this.cpu.ds.getQuadWord(this.cpu.ebp + this.cpu.esp + this.getMicrocode());
            }
            case 769: {
                return this.cpu.ds.getQuadWord(this.cpu.ebp + this.cpu.esi + this.getMicrocode());
            }
            case 770: {
                return this.cpu.ds.getQuadWord(this.cpu.ebp + this.cpu.edi + this.getMicrocode());
            }
            case 771: {
                return this.cpu.ds.getQuadWord(this.cpu.esi + this.cpu.esp + this.getMicrocode());
            }
            case 772: {
                return this.cpu.ds.getQuadWord(this.cpu.esi + this.cpu.edi + this.getMicrocode());
            }
            case 773: {
                return this.cpu.ds.getQuadWord(this.cpu.edi + this.cpu.esp + this.getMicrocode());
            }
            case 774: {
                return this.cpu.ds.getQuadWord((this.cpu.eax << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 775: {
                return this.cpu.ds.getQuadWord((this.cpu.eax << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 776: {
                return this.cpu.ds.getQuadWord((this.cpu.eax << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 777: {
                return this.cpu.ds.getQuadWord((this.cpu.eax << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 778: {
                return this.cpu.ds.getQuadWord((this.cpu.eax << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 779: {
                return this.cpu.ds.getQuadWord((this.cpu.eax << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 780: {
                return this.cpu.ds.getQuadWord((this.cpu.eax << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 781: {
                return this.cpu.ds.getQuadWord((this.cpu.eax << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 782: {
                return this.cpu.ds.getQuadWord((this.cpu.ecx << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 783: {
                return this.cpu.ds.getQuadWord((this.cpu.ecx << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 784: {
                return this.cpu.ds.getQuadWord((this.cpu.ecx << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 785: {
                return this.cpu.ds.getQuadWord((this.cpu.ecx << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 786: {
                return this.cpu.ds.getQuadWord((this.cpu.ecx << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 787: {
                return this.cpu.ds.getQuadWord((this.cpu.ecx << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 788: {
                return this.cpu.ds.getQuadWord((this.cpu.ecx << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 789: {
                return this.cpu.ds.getQuadWord((this.cpu.ecx << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 790: {
                return this.cpu.ds.getQuadWord((this.cpu.edx << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 791: {
                return this.cpu.ds.getQuadWord((this.cpu.edx << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 792: {
                return this.cpu.ds.getQuadWord((this.cpu.edx << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 793: {
                return this.cpu.ds.getQuadWord((this.cpu.edx << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 794: {
                return this.cpu.ds.getQuadWord((this.cpu.edx << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 795: {
                return this.cpu.ds.getQuadWord((this.cpu.edx << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 796: {
                return this.cpu.ds.getQuadWord((this.cpu.edx << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 797: {
                return this.cpu.ds.getQuadWord((this.cpu.edx << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 798: {
                return this.cpu.ds.getQuadWord((this.cpu.ebx << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 799: {
                return this.cpu.ds.getQuadWord((this.cpu.ebx << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 800: {
                return this.cpu.ds.getQuadWord((this.cpu.ebx << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 801: {
                return this.cpu.ds.getQuadWord((this.cpu.ebx << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 802: {
                return this.cpu.ds.getQuadWord((this.cpu.ebx << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 803: {
                return this.cpu.ds.getQuadWord((this.cpu.ebx << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 804: {
                return this.cpu.ds.getQuadWord((this.cpu.ebx << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 805: {
                return this.cpu.ds.getQuadWord((this.cpu.ebx << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 806: {
                return this.cpu.ds.getQuadWord((this.cpu.ebp << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 807: {
                return this.cpu.ds.getQuadWord((this.cpu.ebp << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 808: {
                return this.cpu.ds.getQuadWord((this.cpu.ebp << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 809: {
                return this.cpu.ds.getQuadWord((this.cpu.ebp << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 810: {
                return this.cpu.ds.getQuadWord((this.cpu.ebp << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 811: {
                return this.cpu.ds.getQuadWord((this.cpu.ebp << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 812: {
                return this.cpu.ds.getQuadWord((this.cpu.ebp << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 813: {
                return this.cpu.ds.getQuadWord((this.cpu.ebp << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 814: {
                return this.cpu.ds.getQuadWord((this.cpu.esi << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 815: {
                return this.cpu.ds.getQuadWord((this.cpu.esi << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 816: {
                return this.cpu.ds.getQuadWord((this.cpu.esi << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 817: {
                return this.cpu.ds.getQuadWord((this.cpu.esi << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 818: {
                return this.cpu.ds.getQuadWord((this.cpu.esi << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 819: {
                return this.cpu.ds.getQuadWord((this.cpu.esi << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 820: {
                return this.cpu.ds.getQuadWord((this.cpu.esi << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 821: {
                return this.cpu.ds.getQuadWord((this.cpu.esi << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 822: {
                return this.cpu.ds.getQuadWord((this.cpu.edi << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 823: {
                return this.cpu.ds.getQuadWord((this.cpu.edi << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 824: {
                return this.cpu.ds.getQuadWord((this.cpu.edi << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 825: {
                return this.cpu.ds.getQuadWord((this.cpu.edi << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 826: {
                return this.cpu.ds.getQuadWord((this.cpu.edi << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 827: {
                return this.cpu.ds.getQuadWord((this.cpu.edi << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 828: {
                return this.cpu.ds.getQuadWord((this.cpu.edi << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 829: {
                return this.cpu.ds.getQuadWord((this.cpu.edi << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 830: {
                return this.cpu.ds.getQuadWord((this.cpu.eax << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 831: {
                return this.cpu.ds.getQuadWord((this.cpu.eax << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 832: {
                return this.cpu.ds.getQuadWord((this.cpu.eax << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 833: {
                return this.cpu.ds.getQuadWord((this.cpu.eax << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 834: {
                return this.cpu.ds.getQuadWord((this.cpu.eax << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 835: {
                return this.cpu.ds.getQuadWord((this.cpu.eax << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 836: {
                return this.cpu.ds.getQuadWord((this.cpu.eax << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 837: {
                return this.cpu.ds.getQuadWord((this.cpu.eax << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 838: {
                return this.cpu.ds.getQuadWord((this.cpu.ecx << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 839: {
                return this.cpu.ds.getQuadWord((this.cpu.ecx << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 840: {
                return this.cpu.ds.getQuadWord((this.cpu.ecx << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 841: {
                return this.cpu.ds.getQuadWord((this.cpu.ecx << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 842: {
                return this.cpu.ds.getQuadWord((this.cpu.ecx << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 843: {
                return this.cpu.ds.getQuadWord((this.cpu.ecx << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 844: {
                return this.cpu.ds.getQuadWord((this.cpu.ecx << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 845: {
                return this.cpu.ds.getQuadWord((this.cpu.ecx << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 846: {
                return this.cpu.ds.getQuadWord((this.cpu.edx << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 847: {
                return this.cpu.ds.getQuadWord((this.cpu.edx << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 848: {
                return this.cpu.ds.getQuadWord((this.cpu.edx << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 849: {
                return this.cpu.ds.getQuadWord((this.cpu.edx << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 850: {
                return this.cpu.ds.getQuadWord((this.cpu.edx << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 851: {
                return this.cpu.ds.getQuadWord((this.cpu.edx << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 852: {
                return this.cpu.ds.getQuadWord((this.cpu.edx << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 853: {
                return this.cpu.ds.getQuadWord((this.cpu.edx << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 854: {
                return this.cpu.ds.getQuadWord((this.cpu.ebx << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 855: {
                return this.cpu.ds.getQuadWord((this.cpu.ebx << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 856: {
                return this.cpu.ds.getQuadWord((this.cpu.ebx << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 857: {
                return this.cpu.ds.getQuadWord((this.cpu.ebx << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 858: {
                return this.cpu.ds.getQuadWord((this.cpu.ebx << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 859: {
                return this.cpu.ds.getQuadWord((this.cpu.ebx << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 860: {
                return this.cpu.ds.getQuadWord((this.cpu.ebx << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 861: {
                return this.cpu.ds.getQuadWord((this.cpu.ebx << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 862: {
                return this.cpu.ds.getQuadWord((this.cpu.ebp << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 863: {
                return this.cpu.ds.getQuadWord((this.cpu.ebp << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 864: {
                return this.cpu.ds.getQuadWord((this.cpu.ebp << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 865: {
                return this.cpu.ds.getQuadWord((this.cpu.ebp << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 866: {
                return this.cpu.ds.getQuadWord((this.cpu.ebp << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 867: {
                return this.cpu.ds.getQuadWord((this.cpu.ebp << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 868: {
                return this.cpu.ds.getQuadWord((this.cpu.ebp << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 869: {
                return this.cpu.ds.getQuadWord((this.cpu.ebp << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 870: {
                return this.cpu.ds.getQuadWord((this.cpu.esi << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 871: {
                return this.cpu.ds.getQuadWord((this.cpu.esi << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 872: {
                return this.cpu.ds.getQuadWord((this.cpu.esi << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 873: {
                return this.cpu.ds.getQuadWord((this.cpu.esi << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 874: {
                return this.cpu.ds.getQuadWord((this.cpu.esi << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 875: {
                return this.cpu.ds.getQuadWord((this.cpu.esi << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 876: {
                return this.cpu.ds.getQuadWord((this.cpu.esi << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 877: {
                return this.cpu.ds.getQuadWord((this.cpu.esi << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 878: {
                return this.cpu.ds.getQuadWord((this.cpu.edi << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 879: {
                return this.cpu.ds.getQuadWord((this.cpu.edi << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 880: {
                return this.cpu.ds.getQuadWord((this.cpu.edi << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 881: {
                return this.cpu.ds.getQuadWord((this.cpu.edi << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 882: {
                return this.cpu.ds.getQuadWord((this.cpu.edi << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 883: {
                return this.cpu.ds.getQuadWord((this.cpu.edi << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 884: {
                return this.cpu.ds.getQuadWord((this.cpu.edi << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 885: {
                return this.cpu.ds.getQuadWord((this.cpu.edi << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 886: {
                return this.cpu.ds.getQuadWord((this.cpu.eax << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 887: {
                return this.cpu.ds.getQuadWord((this.cpu.eax << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 888: {
                return this.cpu.ds.getQuadWord((this.cpu.eax << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 889: {
                return this.cpu.ds.getQuadWord((this.cpu.eax << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 890: {
                return this.cpu.ds.getQuadWord((this.cpu.eax << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 891: {
                return this.cpu.ds.getQuadWord((this.cpu.eax << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 892: {
                return this.cpu.ds.getQuadWord((this.cpu.eax << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 893: {
                return this.cpu.ds.getQuadWord((this.cpu.eax << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 894: {
                return this.cpu.ds.getQuadWord((this.cpu.ecx << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 895: {
                return this.cpu.ds.getQuadWord((this.cpu.ecx << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 896: {
                return this.cpu.ds.getQuadWord((this.cpu.ecx << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 897: {
                return this.cpu.ds.getQuadWord((this.cpu.ecx << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 898: {
                return this.cpu.ds.getQuadWord((this.cpu.ecx << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 899: {
                return this.cpu.ds.getQuadWord((this.cpu.ecx << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 900: {
                return this.cpu.ds.getQuadWord((this.cpu.ecx << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 901: {
                return this.cpu.ds.getQuadWord((this.cpu.ecx << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 902: {
                return this.cpu.ds.getQuadWord((this.cpu.edx << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 903: {
                return this.cpu.ds.getQuadWord((this.cpu.edx << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 904: {
                return this.cpu.ds.getQuadWord((this.cpu.edx << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 905: {
                return this.cpu.ds.getQuadWord((this.cpu.edx << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 906: {
                return this.cpu.ds.getQuadWord((this.cpu.edx << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 907: {
                return this.cpu.ds.getQuadWord((this.cpu.edx << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 908: {
                return this.cpu.ds.getQuadWord((this.cpu.edx << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 909: {
                return this.cpu.ds.getQuadWord((this.cpu.edx << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 910: {
                return this.cpu.ds.getQuadWord((this.cpu.ebx << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 911: {
                return this.cpu.ds.getQuadWord((this.cpu.ebx << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 912: {
                return this.cpu.ds.getQuadWord((this.cpu.ebx << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 913: {
                return this.cpu.ds.getQuadWord((this.cpu.ebx << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 914: {
                return this.cpu.ds.getQuadWord((this.cpu.ebx << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 915: {
                return this.cpu.ds.getQuadWord((this.cpu.ebx << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 916: {
                return this.cpu.ds.getQuadWord((this.cpu.ebx << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 917: {
                return this.cpu.ds.getQuadWord((this.cpu.ebx << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 918: {
                return this.cpu.ds.getQuadWord((this.cpu.ebp << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 919: {
                return this.cpu.ds.getQuadWord((this.cpu.ebp << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 920: {
                return this.cpu.ds.getQuadWord((this.cpu.ebp << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 921: {
                return this.cpu.ds.getQuadWord((this.cpu.ebp << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 922: {
                return this.cpu.ds.getQuadWord((this.cpu.ebp << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 923: {
                return this.cpu.ds.getQuadWord((this.cpu.ebp << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 924: {
                return this.cpu.ds.getQuadWord((this.cpu.ebp << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 925: {
                return this.cpu.ds.getQuadWord((this.cpu.ebp << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 926: {
                return this.cpu.ds.getQuadWord((this.cpu.esi << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 927: {
                return this.cpu.ds.getQuadWord((this.cpu.esi << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 928: {
                return this.cpu.ds.getQuadWord((this.cpu.esi << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 929: {
                return this.cpu.ds.getQuadWord((this.cpu.esi << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 930: {
                return this.cpu.ds.getQuadWord((this.cpu.esi << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 931: {
                return this.cpu.ds.getQuadWord((this.cpu.esi << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 932: {
                return this.cpu.ds.getQuadWord((this.cpu.esi << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 933: {
                return this.cpu.ds.getQuadWord((this.cpu.esi << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 934: {
                return this.cpu.ds.getQuadWord((this.cpu.edi << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 935: {
                return this.cpu.ds.getQuadWord((this.cpu.edi << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 936: {
                return this.cpu.ds.getQuadWord((this.cpu.edi << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 937: {
                return this.cpu.ds.getQuadWord((this.cpu.edi << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 938: {
                return this.cpu.ds.getQuadWord((this.cpu.edi << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 939: {
                return this.cpu.ds.getQuadWord((this.cpu.edi << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 940: {
                return this.cpu.ds.getQuadWord((this.cpu.edi << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 941: {
                return this.cpu.ds.getQuadWord((this.cpu.edi << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 2150: {
                return this.cpu.ss.getQuadWord(this.cpu.eax + this.cpu.eax);
            }
            case 2151: {
                return this.cpu.ss.getQuadWord(this.cpu.eax + this.cpu.ecx);
            }
            case 2152: {
                return this.cpu.ss.getQuadWord(this.cpu.eax + this.cpu.edx);
            }
            case 2153: {
                return this.cpu.ss.getQuadWord(this.cpu.eax + this.cpu.ebx);
            }
            case 2154: {
                return this.cpu.ss.getQuadWord(this.cpu.eax + this.cpu.esp);
            }
            case 2155: {
                return this.cpu.ss.getQuadWord(this.cpu.eax + this.cpu.ebp);
            }
            case 2156: {
                return this.cpu.ss.getQuadWord(this.cpu.eax + this.cpu.esi);
            }
            case 2157: {
                return this.cpu.ss.getQuadWord(this.cpu.eax + this.cpu.edi);
            }
            case 2158: {
                return this.cpu.ss.getQuadWord(this.cpu.ecx + this.cpu.ecx);
            }
            case 2159: {
                return this.cpu.ss.getQuadWord(this.cpu.ecx + this.cpu.edx);
            }
            case 2160: {
                return this.cpu.ss.getQuadWord(this.cpu.ecx + this.cpu.ebx);
            }
            case 2161: {
                return this.cpu.ss.getQuadWord(this.cpu.ecx + this.cpu.esp);
            }
            case 2162: {
                return this.cpu.ss.getQuadWord(this.cpu.ecx + this.cpu.ebp);
            }
            case 2163: {
                return this.cpu.ss.getQuadWord(this.cpu.ecx + this.cpu.esi);
            }
            case 2164: {
                return this.cpu.ss.getQuadWord(this.cpu.ecx + this.cpu.edi);
            }
            case 2165: {
                return this.cpu.ss.getQuadWord(this.cpu.edx + this.cpu.edx);
            }
            case 2166: {
                return this.cpu.ss.getQuadWord(this.cpu.edx + this.cpu.ebx);
            }
            case 2167: {
                return this.cpu.ss.getQuadWord(this.cpu.edx + this.cpu.esp);
            }
            case 2168: {
                return this.cpu.ss.getQuadWord(this.cpu.edx + this.cpu.ebp);
            }
            case 2169: {
                return this.cpu.ss.getQuadWord(this.cpu.edx + this.cpu.esi);
            }
            case 2170: {
                return this.cpu.ss.getQuadWord(this.cpu.edx + this.cpu.edi);
            }
            case 2171: {
                return this.cpu.ss.getQuadWord(this.cpu.ebx + this.cpu.ebx);
            }
            case 2172: {
                return this.cpu.ss.getQuadWord(this.cpu.ebx + this.cpu.esp);
            }
            case 2173: {
                return this.cpu.ss.getQuadWord(this.cpu.ebx + this.cpu.ebp);
            }
            case 2174: {
                return this.cpu.ss.getQuadWord(this.cpu.ebx + this.cpu.esi);
            }
            case 2175: {
                return this.cpu.ss.getQuadWord(this.cpu.ebx + this.cpu.edi);
            }
            case 2176: {
                return this.cpu.ss.getQuadWord(this.cpu.esp);
            }
            case 2177: {
                return this.cpu.ss.getQuadWord(this.cpu.ebp + this.cpu.esp);
            }
            case 2178: {
                return this.cpu.ss.getQuadWord(this.cpu.ebp + this.cpu.esi);
            }
            case 2179: {
                return this.cpu.ss.getQuadWord(this.cpu.ebp + this.cpu.edi);
            }
            case 2180: {
                return this.cpu.ss.getQuadWord(this.cpu.esi + this.cpu.esp);
            }
            case 2181: {
                return this.cpu.ss.getQuadWord(this.cpu.esi + this.cpu.esi);
            }
            case 2182: {
                return this.cpu.ss.getQuadWord(this.cpu.esi + this.cpu.edi);
            }
            case 2183: {
                return this.cpu.ss.getQuadWord(this.cpu.edi + this.cpu.esp);
            }
            case 2184: {
                return this.cpu.ss.getQuadWord(this.cpu.edi + this.cpu.edi);
            }
            case 2185: {
                return this.cpu.ss.getQuadWord((this.cpu.eax << 1) + this.cpu.eax);
            }
            case 2186: {
                return this.cpu.ss.getQuadWord((this.cpu.eax << 1) + this.cpu.ecx);
            }
            case 2187: {
                return this.cpu.ss.getQuadWord((this.cpu.eax << 1) + this.cpu.edx);
            }
            case 2188: {
                return this.cpu.ss.getQuadWord((this.cpu.eax << 1) + this.cpu.ebx);
            }
            case 2189: {
                return this.cpu.ss.getQuadWord((this.cpu.eax << 1) + this.cpu.esp);
            }
            case 2190: {
                return this.cpu.ss.getQuadWord((this.cpu.eax << 1) + this.getMicrocode());
            }
            case 2191: {
                return this.cpu.ss.getQuadWord((this.cpu.eax << 1) + this.cpu.esi);
            }
            case 2192: {
                return this.cpu.ss.getQuadWord((this.cpu.eax << 1) + this.cpu.edi);
            }
            case 2193: {
                return this.cpu.ss.getQuadWord((this.cpu.ecx << 1) + this.cpu.eax);
            }
            case 2194: {
                return this.cpu.ss.getQuadWord((this.cpu.ecx << 1) + this.cpu.ecx);
            }
            case 2195: {
                return this.cpu.ss.getQuadWord((this.cpu.ecx << 1) + this.cpu.edx);
            }
            case 2196: {
                return this.cpu.ss.getQuadWord((this.cpu.ecx << 1) + this.cpu.ebx);
            }
            case 2197: {
                return this.cpu.ss.getQuadWord((this.cpu.ecx << 1) + this.cpu.esp);
            }
            case 2198: {
                return this.cpu.ss.getQuadWord((this.cpu.ecx << 1) + this.getMicrocode());
            }
            case 2199: {
                return this.cpu.ss.getQuadWord((this.cpu.ecx << 1) + this.cpu.esi);
            }
            case 2200: {
                return this.cpu.ss.getQuadWord((this.cpu.ecx << 1) + this.cpu.edi);
            }
            case 2201: {
                return this.cpu.ss.getQuadWord((this.cpu.edx << 1) + this.cpu.eax);
            }
            case 2202: {
                return this.cpu.ss.getQuadWord((this.cpu.edx << 1) + this.cpu.ecx);
            }
            case 2203: {
                return this.cpu.ss.getQuadWord((this.cpu.edx << 1) + this.cpu.edx);
            }
            case 2204: {
                return this.cpu.ss.getQuadWord((this.cpu.edx << 1) + this.cpu.ebx);
            }
            case 2205: {
                return this.cpu.ss.getQuadWord((this.cpu.edx << 1) + this.cpu.esp);
            }
            case 2206: {
                return this.cpu.ss.getQuadWord((this.cpu.edx << 1) + this.getMicrocode());
            }
            case 2207: {
                return this.cpu.ss.getQuadWord((this.cpu.edx << 1) + this.cpu.esi);
            }
            case 2208: {
                return this.cpu.ss.getQuadWord((this.cpu.edx << 1) + this.cpu.edi);
            }
            case 2209: {
                return this.cpu.ss.getQuadWord((this.cpu.ebx << 1) + this.cpu.eax);
            }
            case 2210: {
                return this.cpu.ss.getQuadWord((this.cpu.ebx << 1) + this.cpu.ecx);
            }
            case 2211: {
                return this.cpu.ss.getQuadWord((this.cpu.ebx << 1) + this.cpu.edx);
            }
            case 2212: {
                return this.cpu.ss.getQuadWord((this.cpu.ebx << 1) + this.cpu.ebx);
            }
            case 2213: {
                return this.cpu.ss.getQuadWord((this.cpu.ebx << 1) + this.cpu.esp);
            }
            case 2214: {
                return this.cpu.ss.getQuadWord((this.cpu.ebx << 1) + this.getMicrocode());
            }
            case 2215: {
                return this.cpu.ss.getQuadWord((this.cpu.ebx << 1) + this.cpu.esi);
            }
            case 2216: {
                return this.cpu.ss.getQuadWord((this.cpu.ebx << 1) + this.cpu.edi);
            }
            case 2217: {
                return this.cpu.ss.getQuadWord((this.cpu.ebp << 1) + this.cpu.eax);
            }
            case 2218: {
                return this.cpu.ss.getQuadWord((this.cpu.ebp << 1) + this.cpu.ecx);
            }
            case 2219: {
                return this.cpu.ss.getQuadWord((this.cpu.ebp << 1) + this.cpu.edx);
            }
            case 2220: {
                return this.cpu.ss.getQuadWord((this.cpu.ebp << 1) + this.cpu.ebx);
            }
            case 2221: {
                return this.cpu.ss.getQuadWord((this.cpu.ebp << 1) + this.cpu.esp);
            }
            case 2222: {
                return this.cpu.ss.getQuadWord((this.cpu.ebp << 1) + this.getMicrocode());
            }
            case 2223: {
                return this.cpu.ss.getQuadWord((this.cpu.ebp << 1) + this.cpu.esi);
            }
            case 2224: {
                return this.cpu.ss.getQuadWord((this.cpu.ebp << 1) + this.cpu.edi);
            }
            case 2225: {
                return this.cpu.ss.getQuadWord((this.cpu.esi << 1) + this.cpu.eax);
            }
            case 2226: {
                return this.cpu.ss.getQuadWord((this.cpu.esi << 1) + this.cpu.ecx);
            }
            case 2227: {
                return this.cpu.ss.getQuadWord((this.cpu.esi << 1) + this.cpu.edx);
            }
            case 2228: {
                return this.cpu.ss.getQuadWord((this.cpu.esi << 1) + this.cpu.ebx);
            }
            case 2229: {
                return this.cpu.ss.getQuadWord((this.cpu.esi << 1) + this.cpu.esp);
            }
            case 2230: {
                return this.cpu.ss.getQuadWord((this.cpu.esi << 1) + this.getMicrocode());
            }
            case 2231: {
                return this.cpu.ss.getQuadWord((this.cpu.esi << 1) + this.cpu.esi);
            }
            case 2232: {
                return this.cpu.ss.getQuadWord((this.cpu.esi << 1) + this.cpu.edi);
            }
            case 2233: {
                return this.cpu.ss.getQuadWord((this.cpu.edi << 1) + this.cpu.eax);
            }
            case 2234: {
                return this.cpu.ss.getQuadWord((this.cpu.edi << 1) + this.cpu.ecx);
            }
            case 2235: {
                return this.cpu.ss.getQuadWord((this.cpu.edi << 1) + this.cpu.edx);
            }
            case 2236: {
                return this.cpu.ss.getQuadWord((this.cpu.edi << 1) + this.cpu.ebx);
            }
            case 2237: {
                return this.cpu.ss.getQuadWord((this.cpu.edi << 1) + this.cpu.esp);
            }
            case 2238: {
                return this.cpu.ss.getQuadWord((this.cpu.edi << 1) + this.getMicrocode());
            }
            case 2239: {
                return this.cpu.ss.getQuadWord((this.cpu.edi << 1) + this.cpu.esi);
            }
            case 2240: {
                return this.cpu.ss.getQuadWord((this.cpu.edi << 1) + this.cpu.edi);
            }
            case 2241: {
                return this.cpu.ss.getQuadWord((this.cpu.eax << 2) + this.cpu.eax);
            }
            case 2242: {
                return this.cpu.ss.getQuadWord((this.cpu.eax << 2) + this.cpu.ecx);
            }
            case 2243: {
                return this.cpu.ss.getQuadWord((this.cpu.eax << 2) + this.cpu.edx);
            }
            case 2244: {
                return this.cpu.ss.getQuadWord((this.cpu.eax << 2) + this.cpu.ebx);
            }
            case 2245: {
                return this.cpu.ss.getQuadWord((this.cpu.eax << 2) + this.cpu.esp);
            }
            case 2246: {
                return this.cpu.ss.getQuadWord((this.cpu.eax << 2) + this.getMicrocode());
            }
            case 2247: {
                return this.cpu.ss.getQuadWord((this.cpu.eax << 2) + this.cpu.esi);
            }
            case 2248: {
                return this.cpu.ss.getQuadWord((this.cpu.eax << 2) + this.cpu.edi);
            }
            case 2249: {
                return this.cpu.ss.getQuadWord((this.cpu.ecx << 2) + this.cpu.eax);
            }
            case 2250: {
                return this.cpu.ss.getQuadWord((this.cpu.ecx << 2) + this.cpu.ecx);
            }
            case 2251: {
                return this.cpu.ss.getQuadWord((this.cpu.ecx << 2) + this.cpu.edx);
            }
            case 2252: {
                return this.cpu.ss.getQuadWord((this.cpu.ecx << 2) + this.cpu.ebx);
            }
            case 2253: {
                return this.cpu.ss.getQuadWord((this.cpu.ecx << 2) + this.cpu.esp);
            }
            case 2254: {
                return this.cpu.ss.getQuadWord((this.cpu.ecx << 2) + this.getMicrocode());
            }
            case 2255: {
                return this.cpu.ss.getQuadWord((this.cpu.ecx << 2) + this.cpu.esi);
            }
            case 2256: {
                return this.cpu.ss.getQuadWord((this.cpu.ecx << 2) + this.cpu.edi);
            }
            case 2257: {
                return this.cpu.ss.getQuadWord((this.cpu.edx << 2) + this.cpu.eax);
            }
            case 2258: {
                return this.cpu.ss.getQuadWord((this.cpu.edx << 2) + this.cpu.ecx);
            }
            case 2259: {
                return this.cpu.ss.getQuadWord((this.cpu.edx << 2) + this.cpu.edx);
            }
            case 2260: {
                return this.cpu.ss.getQuadWord((this.cpu.edx << 2) + this.cpu.ebx);
            }
            case 2261: {
                return this.cpu.ss.getQuadWord((this.cpu.edx << 2) + this.cpu.esp);
            }
            case 2262: {
                return this.cpu.ss.getQuadWord((this.cpu.edx << 2) + this.getMicrocode());
            }
            case 2263: {
                return this.cpu.ss.getQuadWord((this.cpu.edx << 2) + this.cpu.esi);
            }
            case 2264: {
                return this.cpu.ss.getQuadWord((this.cpu.edx << 2) + this.cpu.edi);
            }
            case 2265: {
                return this.cpu.ss.getQuadWord((this.cpu.ebx << 2) + this.cpu.eax);
            }
            case 2266: {
                return this.cpu.ss.getQuadWord((this.cpu.ebx << 2) + this.cpu.ecx);
            }
            case 2267: {
                return this.cpu.ss.getQuadWord((this.cpu.ebx << 2) + this.cpu.edx);
            }
            case 2268: {
                return this.cpu.ss.getQuadWord((this.cpu.ebx << 2) + this.cpu.ebx);
            }
            case 2269: {
                return this.cpu.ss.getQuadWord((this.cpu.ebx << 2) + this.cpu.esp);
            }
            case 2270: {
                return this.cpu.ss.getQuadWord((this.cpu.ebx << 2) + this.getMicrocode());
            }
            case 2271: {
                return this.cpu.ss.getQuadWord((this.cpu.ebx << 2) + this.cpu.esi);
            }
            case 2272: {
                return this.cpu.ss.getQuadWord((this.cpu.ebx << 2) + this.cpu.edi);
            }
            case 2273: {
                return this.cpu.ss.getQuadWord((this.cpu.ebp << 2) + this.cpu.eax);
            }
            case 2274: {
                return this.cpu.ss.getQuadWord((this.cpu.ebp << 2) + this.cpu.ecx);
            }
            case 2275: {
                return this.cpu.ss.getQuadWord((this.cpu.ebp << 2) + this.cpu.edx);
            }
            case 2276: {
                return this.cpu.ss.getQuadWord((this.cpu.ebp << 2) + this.cpu.ebx);
            }
            case 2277: {
                return this.cpu.ss.getQuadWord((this.cpu.ebp << 2) + this.cpu.esp);
            }
            case 2278: {
                return this.cpu.ss.getQuadWord((this.cpu.ebp << 2) + this.getMicrocode());
            }
            case 2279: {
                return this.cpu.ss.getQuadWord((this.cpu.ebp << 2) + this.cpu.esi);
            }
            case 2280: {
                return this.cpu.ss.getQuadWord((this.cpu.ebp << 2) + this.cpu.edi);
            }
            case 2281: {
                return this.cpu.ss.getQuadWord((this.cpu.esi << 2) + this.cpu.eax);
            }
            case 2282: {
                return this.cpu.ss.getQuadWord((this.cpu.esi << 2) + this.cpu.ecx);
            }
            case 2283: {
                return this.cpu.ss.getQuadWord((this.cpu.esi << 2) + this.cpu.edx);
            }
            case 2284: {
                return this.cpu.ss.getQuadWord((this.cpu.esi << 2) + this.cpu.ebx);
            }
            case 2285: {
                return this.cpu.ss.getQuadWord((this.cpu.esi << 2) + this.cpu.esp);
            }
            case 2286: {
                return this.cpu.ss.getQuadWord((this.cpu.esi << 2) + this.getMicrocode());
            }
            case 2287: {
                return this.cpu.ss.getQuadWord((this.cpu.esi << 2) + this.cpu.esi);
            }
            case 2288: {
                return this.cpu.ss.getQuadWord((this.cpu.esi << 2) + this.cpu.edi);
            }
            case 2289: {
                return this.cpu.ss.getQuadWord((this.cpu.edi << 2) + this.cpu.eax);
            }
            case 2290: {
                return this.cpu.ss.getQuadWord((this.cpu.edi << 2) + this.cpu.ecx);
            }
            case 2291: {
                return this.cpu.ss.getQuadWord((this.cpu.edi << 2) + this.cpu.edx);
            }
            case 2292: {
                return this.cpu.ss.getQuadWord((this.cpu.edi << 2) + this.cpu.ebx);
            }
            case 2293: {
                return this.cpu.ss.getQuadWord((this.cpu.edi << 2) + this.cpu.esp);
            }
            case 2294: {
                return this.cpu.ss.getQuadWord((this.cpu.edi << 2) + this.getMicrocode());
            }
            case 2295: {
                return this.cpu.ss.getQuadWord((this.cpu.edi << 2) + this.cpu.esi);
            }
            case 2296: {
                return this.cpu.ss.getQuadWord((this.cpu.edi << 2) + this.cpu.edi);
            }
            case 2297: {
                return this.cpu.ss.getQuadWord((this.cpu.eax << 3) + this.cpu.eax);
            }
            case 2298: {
                return this.cpu.ss.getQuadWord((this.cpu.eax << 3) + this.cpu.ecx);
            }
            case 2299: {
                return this.cpu.ss.getQuadWord((this.cpu.eax << 3) + this.cpu.edx);
            }
            case 2300: {
                return this.cpu.ss.getQuadWord((this.cpu.eax << 3) + this.cpu.ebx);
            }
            case 2301: {
                return this.cpu.ss.getQuadWord((this.cpu.eax << 3) + this.cpu.esp);
            }
            case 2302: {
                return this.cpu.ss.getQuadWord((this.cpu.eax << 3) + this.getMicrocode());
            }
            case 2303: {
                return this.cpu.ss.getQuadWord((this.cpu.eax << 3) + this.cpu.esi);
            }
            case 2304: {
                return this.cpu.ss.getQuadWord((this.cpu.eax << 3) + this.cpu.edi);
            }
            case 2305: {
                return this.cpu.ss.getQuadWord((this.cpu.ecx << 3) + this.cpu.eax);
            }
            case 2306: {
                return this.cpu.ss.getQuadWord((this.cpu.ecx << 3) + this.cpu.ecx);
            }
            case 2307: {
                return this.cpu.ss.getQuadWord((this.cpu.ecx << 3) + this.cpu.edx);
            }
            case 2308: {
                return this.cpu.ss.getQuadWord((this.cpu.ecx << 3) + this.cpu.ebx);
            }
            case 2309: {
                return this.cpu.ss.getQuadWord((this.cpu.ecx << 3) + this.cpu.esp);
            }
            case 2310: {
                return this.cpu.ss.getQuadWord((this.cpu.ecx << 3) + this.getMicrocode());
            }
            case 2311: {
                return this.cpu.ss.getQuadWord((this.cpu.ecx << 3) + this.cpu.esi);
            }
            case 2312: {
                return this.cpu.ss.getQuadWord((this.cpu.ecx << 3) + this.cpu.edi);
            }
            case 2313: {
                return this.cpu.ss.getQuadWord((this.cpu.edx << 3) + this.cpu.eax);
            }
            case 2314: {
                return this.cpu.ss.getQuadWord((this.cpu.edx << 3) + this.cpu.ecx);
            }
            case 2315: {
                return this.cpu.ss.getQuadWord((this.cpu.edx << 3) + this.cpu.edx);
            }
            case 2316: {
                return this.cpu.ss.getQuadWord((this.cpu.edx << 3) + this.cpu.ebx);
            }
            case 2317: {
                return this.cpu.ss.getQuadWord((this.cpu.edx << 3) + this.cpu.esp);
            }
            case 2318: {
                return this.cpu.ss.getQuadWord((this.cpu.edx << 3) + this.getMicrocode());
            }
            case 2319: {
                return this.cpu.ss.getQuadWord((this.cpu.edx << 3) + this.cpu.esi);
            }
            case 2320: {
                return this.cpu.ss.getQuadWord((this.cpu.edx << 3) + this.cpu.edi);
            }
            case 2321: {
                return this.cpu.ss.getQuadWord((this.cpu.ebx << 3) + this.cpu.eax);
            }
            case 2322: {
                return this.cpu.ss.getQuadWord((this.cpu.ebx << 3) + this.cpu.ecx);
            }
            case 2323: {
                return this.cpu.ss.getQuadWord((this.cpu.ebx << 3) + this.cpu.edx);
            }
            case 2324: {
                return this.cpu.ss.getQuadWord((this.cpu.ebx << 3) + this.cpu.ebx);
            }
            case 2325: {
                return this.cpu.ss.getQuadWord((this.cpu.ebx << 3) + this.cpu.esp);
            }
            case 2326: {
                return this.cpu.ss.getQuadWord((this.cpu.ebx << 3) + this.getMicrocode());
            }
            case 2327: {
                return this.cpu.ss.getQuadWord((this.cpu.ebx << 3) + this.cpu.esi);
            }
            case 2328: {
                return this.cpu.ss.getQuadWord((this.cpu.ebx << 3) + this.cpu.edi);
            }
            case 2329: {
                return this.cpu.ss.getQuadWord((this.cpu.ebp << 3) + this.cpu.eax);
            }
            case 2330: {
                return this.cpu.ss.getQuadWord((this.cpu.ebp << 3) + this.cpu.ecx);
            }
            case 2331: {
                return this.cpu.ss.getQuadWord((this.cpu.ebp << 3) + this.cpu.edx);
            }
            case 2332: {
                return this.cpu.ss.getQuadWord((this.cpu.ebp << 3) + this.cpu.ebx);
            }
            case 2333: {
                return this.cpu.ss.getQuadWord((this.cpu.ebp << 3) + this.cpu.esp);
            }
            case 2334: {
                return this.cpu.ss.getQuadWord((this.cpu.ebp << 3) + this.getMicrocode());
            }
            case 2335: {
                return this.cpu.ss.getQuadWord((this.cpu.ebp << 3) + this.cpu.esi);
            }
            case 2336: {
                return this.cpu.ss.getQuadWord((this.cpu.ebp << 3) + this.cpu.edi);
            }
            case 2337: {
                return this.cpu.ss.getQuadWord((this.cpu.esi << 3) + this.cpu.eax);
            }
            case 2338: {
                return this.cpu.ss.getQuadWord((this.cpu.esi << 3) + this.cpu.ecx);
            }
            case 2339: {
                return this.cpu.ss.getQuadWord((this.cpu.esi << 3) + this.cpu.edx);
            }
            case 2340: {
                return this.cpu.ss.getQuadWord((this.cpu.esi << 3) + this.cpu.ebx);
            }
            case 2341: {
                return this.cpu.ss.getQuadWord((this.cpu.esi << 3) + this.cpu.esp);
            }
            case 2342: {
                return this.cpu.ss.getQuadWord((this.cpu.esi << 3) + this.getMicrocode());
            }
            case 2343: {
                return this.cpu.ss.getQuadWord((this.cpu.esi << 3) + this.cpu.esi);
            }
            case 2344: {
                return this.cpu.ss.getQuadWord((this.cpu.esi << 3) + this.cpu.edi);
            }
            case 2345: {
                return this.cpu.ss.getQuadWord((this.cpu.edi << 3) + this.cpu.eax);
            }
            case 2346: {
                return this.cpu.ss.getQuadWord((this.cpu.edi << 3) + this.cpu.ecx);
            }
            case 2347: {
                return this.cpu.ss.getQuadWord((this.cpu.edi << 3) + this.cpu.edx);
            }
            case 2348: {
                return this.cpu.ss.getQuadWord((this.cpu.edi << 3) + this.cpu.ebx);
            }
            case 2349: {
                return this.cpu.ss.getQuadWord((this.cpu.edi << 3) + this.cpu.esp);
            }
            case 2350: {
                return this.cpu.ss.getQuadWord((this.cpu.edi << 3) + this.getMicrocode());
            }
            case 2351: {
                return this.cpu.ss.getQuadWord((this.cpu.edi << 3) + this.cpu.esi);
            }
            case 2352: {
                return this.cpu.ss.getQuadWord((this.cpu.edi << 3) + this.cpu.edi);
            }
            case 2353: {
                return this.cpu.ss.getQuadWord(this.cpu.eax + this.cpu.eax + this.getMicrocode());
            }
            case 2354: {
                return this.cpu.ss.getQuadWord(this.cpu.eax + this.cpu.ecx + this.getMicrocode());
            }
            case 2355: {
                return this.cpu.ss.getQuadWord(this.cpu.eax + this.cpu.edx + this.getMicrocode());
            }
            case 2356: {
                return this.cpu.ss.getQuadWord(this.cpu.eax + this.cpu.ebx + this.getMicrocode());
            }
            case 2357: {
                return this.cpu.ss.getQuadWord(this.cpu.eax + this.cpu.esp + this.getMicrocode());
            }
            case 2358: {
                return this.cpu.ss.getQuadWord(this.cpu.eax + this.cpu.ebp + this.getMicrocode());
            }
            case 2359: {
                return this.cpu.ss.getQuadWord(this.cpu.eax + this.cpu.esi + this.getMicrocode());
            }
            case 2360: {
                return this.cpu.ss.getQuadWord(this.cpu.eax + this.cpu.edi + this.getMicrocode());
            }
            case 2361: {
                return this.cpu.ss.getQuadWord(this.cpu.ecx + this.cpu.ecx + this.getMicrocode());
            }
            case 2362: {
                return this.cpu.ss.getQuadWord(this.cpu.ecx + this.cpu.edx + this.getMicrocode());
            }
            case 2363: {
                return this.cpu.ss.getQuadWord(this.cpu.ecx + this.cpu.ebx + this.getMicrocode());
            }
            case 2364: {
                return this.cpu.ss.getQuadWord(this.cpu.ecx + this.cpu.esp + this.getMicrocode());
            }
            case 2365: {
                return this.cpu.ss.getQuadWord(this.cpu.ecx + this.cpu.ebp + this.getMicrocode());
            }
            case 2366: {
                return this.cpu.ss.getQuadWord(this.cpu.ecx + this.cpu.esi + this.getMicrocode());
            }
            case 2367: {
                return this.cpu.ss.getQuadWord(this.cpu.ecx + this.cpu.edi + this.getMicrocode());
            }
            case 2368: {
                return this.cpu.ss.getQuadWord(this.cpu.edx + this.cpu.edx + this.getMicrocode());
            }
            case 2369: {
                return this.cpu.ss.getQuadWord(this.cpu.edx + this.cpu.ebx + this.getMicrocode());
            }
            case 2370: {
                return this.cpu.ss.getQuadWord(this.cpu.edx + this.cpu.esp + this.getMicrocode());
            }
            case 2371: {
                return this.cpu.ss.getQuadWord(this.cpu.edx + this.cpu.ebp + this.getMicrocode());
            }
            case 2372: {
                return this.cpu.ss.getQuadWord(this.cpu.edx + this.cpu.esi + this.getMicrocode());
            }
            case 2373: {
                return this.cpu.ss.getQuadWord(this.cpu.edx + this.cpu.edi + this.getMicrocode());
            }
            case 2374: {
                return this.cpu.ss.getQuadWord(this.cpu.ebx + this.cpu.ebx + this.getMicrocode());
            }
            case 2375: {
                return this.cpu.ss.getQuadWord(this.cpu.ebx + this.cpu.esp + this.getMicrocode());
            }
            case 2376: {
                return this.cpu.ss.getQuadWord(this.cpu.ebx + this.cpu.ebp + this.getMicrocode());
            }
            case 2377: {
                return this.cpu.ss.getQuadWord(this.cpu.ebx + this.cpu.esi + this.getMicrocode());
            }
            case 2378: {
                return this.cpu.ss.getQuadWord(this.cpu.ebx + this.cpu.edi + this.getMicrocode());
            }
            case 2379: {
                return this.cpu.ss.getQuadWord(this.cpu.esp + this.getMicrocode());
            }
            case 2380: {
                return this.cpu.ss.getQuadWord(this.cpu.ebp + this.cpu.esp + this.getMicrocode());
            }
            case 2381: {
                return this.cpu.ss.getQuadWord(this.cpu.ebp + this.cpu.ebp + this.getMicrocode());
            }
            case 2382: {
                return this.cpu.ss.getQuadWord(this.cpu.ebp + this.cpu.esi + this.getMicrocode());
            }
            case 2383: {
                return this.cpu.ss.getQuadWord(this.cpu.ebp + this.cpu.edi + this.getMicrocode());
            }
            case 2384: {
                return this.cpu.ss.getQuadWord(this.cpu.esi + this.cpu.esp + this.getMicrocode());
            }
            case 2385: {
                return this.cpu.ss.getQuadWord(this.cpu.esi + this.cpu.esi + this.getMicrocode());
            }
            case 2386: {
                return this.cpu.ss.getQuadWord(this.cpu.esi + this.cpu.edi + this.getMicrocode());
            }
            case 2387: {
                return this.cpu.ss.getQuadWord(this.cpu.edi + this.cpu.esp + this.getMicrocode());
            }
            case 2388: {
                return this.cpu.ss.getQuadWord(this.cpu.edi + this.cpu.edi + this.getMicrocode());
            }
            case 2389: {
                return this.cpu.ss.getQuadWord((this.cpu.eax << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 2390: {
                return this.cpu.ss.getQuadWord((this.cpu.eax << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 2391: {
                return this.cpu.ss.getQuadWord((this.cpu.eax << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 2392: {
                return this.cpu.ss.getQuadWord((this.cpu.eax << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 2393: {
                return this.cpu.ss.getQuadWord((this.cpu.eax << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 2394: {
                return this.cpu.ss.getQuadWord((this.cpu.eax << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 2395: {
                return this.cpu.ss.getQuadWord((this.cpu.eax << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 2396: {
                return this.cpu.ss.getQuadWord((this.cpu.eax << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 2397: {
                return this.cpu.ss.getQuadWord((this.cpu.ecx << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 2398: {
                return this.cpu.ss.getQuadWord((this.cpu.ecx << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 2399: {
                return this.cpu.ss.getQuadWord((this.cpu.ecx << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 2400: {
                return this.cpu.ss.getQuadWord((this.cpu.ecx << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 2401: {
                return this.cpu.ss.getQuadWord((this.cpu.ecx << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 2402: {
                return this.cpu.ss.getQuadWord((this.cpu.ecx << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 2403: {
                return this.cpu.ss.getQuadWord((this.cpu.ecx << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 2404: {
                return this.cpu.ss.getQuadWord((this.cpu.ecx << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 2405: {
                return this.cpu.ss.getQuadWord((this.cpu.edx << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 2406: {
                return this.cpu.ss.getQuadWord((this.cpu.edx << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 2407: {
                return this.cpu.ss.getQuadWord((this.cpu.edx << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 2408: {
                return this.cpu.ss.getQuadWord((this.cpu.edx << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 2409: {
                return this.cpu.ss.getQuadWord((this.cpu.edx << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 2410: {
                return this.cpu.ss.getQuadWord((this.cpu.edx << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 2411: {
                return this.cpu.ss.getQuadWord((this.cpu.edx << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 2412: {
                return this.cpu.ss.getQuadWord((this.cpu.edx << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 2413: {
                return this.cpu.ss.getQuadWord((this.cpu.ebx << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 2414: {
                return this.cpu.ss.getQuadWord((this.cpu.ebx << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 2415: {
                return this.cpu.ss.getQuadWord((this.cpu.ebx << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 2416: {
                return this.cpu.ss.getQuadWord((this.cpu.ebx << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 2417: {
                return this.cpu.ss.getQuadWord((this.cpu.ebx << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 2418: {
                return this.cpu.ss.getQuadWord((this.cpu.ebx << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 2419: {
                return this.cpu.ss.getQuadWord((this.cpu.ebx << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 2420: {
                return this.cpu.ss.getQuadWord((this.cpu.ebx << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 2421: {
                return this.cpu.ss.getQuadWord((this.cpu.ebp << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 2422: {
                return this.cpu.ss.getQuadWord((this.cpu.ebp << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 2423: {
                return this.cpu.ss.getQuadWord((this.cpu.ebp << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 2424: {
                return this.cpu.ss.getQuadWord((this.cpu.ebp << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 2425: {
                return this.cpu.ss.getQuadWord((this.cpu.ebp << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 2426: {
                return this.cpu.ss.getQuadWord((this.cpu.ebp << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 2427: {
                return this.cpu.ss.getQuadWord((this.cpu.ebp << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 2428: {
                return this.cpu.ss.getQuadWord((this.cpu.ebp << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 2429: {
                return this.cpu.ss.getQuadWord((this.cpu.esi << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 2430: {
                return this.cpu.ss.getQuadWord((this.cpu.esi << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 2431: {
                return this.cpu.ss.getQuadWord((this.cpu.esi << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 2432: {
                return this.cpu.ss.getQuadWord((this.cpu.esi << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 2433: {
                return this.cpu.ss.getQuadWord((this.cpu.esi << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 2434: {
                return this.cpu.ss.getQuadWord((this.cpu.esi << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 2435: {
                return this.cpu.ss.getQuadWord((this.cpu.esi << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 2436: {
                return this.cpu.ss.getQuadWord((this.cpu.esi << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 2437: {
                return this.cpu.ss.getQuadWord((this.cpu.edi << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 2438: {
                return this.cpu.ss.getQuadWord((this.cpu.edi << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 2439: {
                return this.cpu.ss.getQuadWord((this.cpu.edi << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 2440: {
                return this.cpu.ss.getQuadWord((this.cpu.edi << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 2441: {
                return this.cpu.ss.getQuadWord((this.cpu.edi << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 2442: {
                return this.cpu.ss.getQuadWord((this.cpu.edi << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 2443: {
                return this.cpu.ss.getQuadWord((this.cpu.edi << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 2444: {
                return this.cpu.ss.getQuadWord((this.cpu.edi << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 2445: {
                return this.cpu.ss.getQuadWord((this.cpu.eax << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 2446: {
                return this.cpu.ss.getQuadWord((this.cpu.eax << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 2447: {
                return this.cpu.ss.getQuadWord((this.cpu.eax << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 2448: {
                return this.cpu.ss.getQuadWord((this.cpu.eax << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 2449: {
                return this.cpu.ss.getQuadWord((this.cpu.eax << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 2450: {
                return this.cpu.ss.getQuadWord((this.cpu.eax << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 2451: {
                return this.cpu.ss.getQuadWord((this.cpu.eax << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 2452: {
                return this.cpu.ss.getQuadWord((this.cpu.eax << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 2453: {
                return this.cpu.ss.getQuadWord((this.cpu.ecx << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 2454: {
                return this.cpu.ss.getQuadWord((this.cpu.ecx << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 2455: {
                return this.cpu.ss.getQuadWord((this.cpu.ecx << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 2456: {
                return this.cpu.ss.getQuadWord((this.cpu.ecx << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 2457: {
                return this.cpu.ss.getQuadWord((this.cpu.ecx << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 2458: {
                return this.cpu.ss.getQuadWord((this.cpu.ecx << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 2459: {
                return this.cpu.ss.getQuadWord((this.cpu.ecx << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 2460: {
                return this.cpu.ss.getQuadWord((this.cpu.ecx << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 2461: {
                return this.cpu.ss.getQuadWord((this.cpu.edx << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 2462: {
                return this.cpu.ss.getQuadWord((this.cpu.edx << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 2463: {
                return this.cpu.ss.getQuadWord((this.cpu.edx << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 2464: {
                return this.cpu.ss.getQuadWord((this.cpu.edx << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 2465: {
                return this.cpu.ss.getQuadWord((this.cpu.edx << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 2466: {
                return this.cpu.ss.getQuadWord((this.cpu.edx << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 2467: {
                return this.cpu.ss.getQuadWord((this.cpu.edx << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 2468: {
                return this.cpu.ss.getQuadWord((this.cpu.edx << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 2469: {
                return this.cpu.ss.getQuadWord((this.cpu.ebx << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 2470: {
                return this.cpu.ss.getQuadWord((this.cpu.ebx << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 2471: {
                return this.cpu.ss.getQuadWord((this.cpu.ebx << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 2472: {
                return this.cpu.ss.getQuadWord((this.cpu.ebx << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 2473: {
                return this.cpu.ss.getQuadWord((this.cpu.ebx << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 2474: {
                return this.cpu.ss.getQuadWord((this.cpu.ebx << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 2475: {
                return this.cpu.ss.getQuadWord((this.cpu.ebx << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 2476: {
                return this.cpu.ss.getQuadWord((this.cpu.ebx << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 2477: {
                return this.cpu.ss.getQuadWord((this.cpu.ebp << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 2478: {
                return this.cpu.ss.getQuadWord((this.cpu.ebp << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 2479: {
                return this.cpu.ss.getQuadWord((this.cpu.ebp << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 2480: {
                return this.cpu.ss.getQuadWord((this.cpu.ebp << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 2481: {
                return this.cpu.ss.getQuadWord((this.cpu.ebp << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 2482: {
                return this.cpu.ss.getQuadWord((this.cpu.ebp << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 2483: {
                return this.cpu.ss.getQuadWord((this.cpu.ebp << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 2484: {
                return this.cpu.ss.getQuadWord((this.cpu.ebp << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 2485: {
                return this.cpu.ss.getQuadWord((this.cpu.esi << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 2486: {
                return this.cpu.ss.getQuadWord((this.cpu.esi << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 2487: {
                return this.cpu.ss.getQuadWord((this.cpu.esi << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 2488: {
                return this.cpu.ss.getQuadWord((this.cpu.esi << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 2489: {
                return this.cpu.ss.getQuadWord((this.cpu.esi << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 2490: {
                return this.cpu.ss.getQuadWord((this.cpu.esi << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 2491: {
                return this.cpu.ss.getQuadWord((this.cpu.esi << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 2492: {
                return this.cpu.ss.getQuadWord((this.cpu.esi << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 2493: {
                return this.cpu.ss.getQuadWord((this.cpu.edi << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 2494: {
                return this.cpu.ss.getQuadWord((this.cpu.edi << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 2495: {
                return this.cpu.ss.getQuadWord((this.cpu.edi << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 2496: {
                return this.cpu.ss.getQuadWord((this.cpu.edi << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 2497: {
                return this.cpu.ss.getQuadWord((this.cpu.edi << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 2498: {
                return this.cpu.ss.getQuadWord((this.cpu.edi << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 2499: {
                return this.cpu.ss.getQuadWord((this.cpu.edi << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 2500: {
                return this.cpu.ss.getQuadWord((this.cpu.edi << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 2501: {
                return this.cpu.ss.getQuadWord((this.cpu.eax << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 2502: {
                return this.cpu.ss.getQuadWord((this.cpu.eax << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 2503: {
                return this.cpu.ss.getQuadWord((this.cpu.eax << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 2504: {
                return this.cpu.ss.getQuadWord((this.cpu.eax << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 2505: {
                return this.cpu.ss.getQuadWord((this.cpu.eax << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 2506: {
                return this.cpu.ss.getQuadWord((this.cpu.eax << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 2507: {
                return this.cpu.ss.getQuadWord((this.cpu.eax << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 2508: {
                return this.cpu.ss.getQuadWord((this.cpu.eax << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 2509: {
                return this.cpu.ss.getQuadWord((this.cpu.ecx << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 2510: {
                return this.cpu.ss.getQuadWord((this.cpu.ecx << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 2511: {
                return this.cpu.ss.getQuadWord((this.cpu.ecx << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 2512: {
                return this.cpu.ss.getQuadWord((this.cpu.ecx << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 2513: {
                return this.cpu.ss.getQuadWord((this.cpu.ecx << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 2514: {
                return this.cpu.ss.getQuadWord((this.cpu.ecx << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 2515: {
                return this.cpu.ss.getQuadWord((this.cpu.ecx << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 2516: {
                return this.cpu.ss.getQuadWord((this.cpu.ecx << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 2517: {
                return this.cpu.ss.getQuadWord((this.cpu.edx << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 2518: {
                return this.cpu.ss.getQuadWord((this.cpu.edx << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 2519: {
                return this.cpu.ss.getQuadWord((this.cpu.edx << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 2520: {
                return this.cpu.ss.getQuadWord((this.cpu.edx << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 2521: {
                return this.cpu.ss.getQuadWord((this.cpu.edx << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 2522: {
                return this.cpu.ss.getQuadWord((this.cpu.edx << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 2523: {
                return this.cpu.ss.getQuadWord((this.cpu.edx << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 2524: {
                return this.cpu.ss.getQuadWord((this.cpu.edx << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 2525: {
                return this.cpu.ss.getQuadWord((this.cpu.ebx << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 2526: {
                return this.cpu.ss.getQuadWord((this.cpu.ebx << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 2527: {
                return this.cpu.ss.getQuadWord((this.cpu.ebx << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 2528: {
                return this.cpu.ss.getQuadWord((this.cpu.ebx << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 2529: {
                return this.cpu.ss.getQuadWord((this.cpu.ebx << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 2530: {
                return this.cpu.ss.getQuadWord((this.cpu.ebx << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 2531: {
                return this.cpu.ss.getQuadWord((this.cpu.ebx << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 2532: {
                return this.cpu.ss.getQuadWord((this.cpu.ebx << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 2533: {
                return this.cpu.ss.getQuadWord((this.cpu.ebp << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 2534: {
                return this.cpu.ss.getQuadWord((this.cpu.ebp << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 2535: {
                return this.cpu.ss.getQuadWord((this.cpu.ebp << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 2536: {
                return this.cpu.ss.getQuadWord((this.cpu.ebp << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 2537: {
                return this.cpu.ss.getQuadWord((this.cpu.ebp << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 2538: {
                return this.cpu.ss.getQuadWord((this.cpu.ebp << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 2539: {
                return this.cpu.ss.getQuadWord((this.cpu.ebp << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 2540: {
                return this.cpu.ss.getQuadWord((this.cpu.ebp << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 2541: {
                return this.cpu.ss.getQuadWord((this.cpu.esi << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 2542: {
                return this.cpu.ss.getQuadWord((this.cpu.esi << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 2543: {
                return this.cpu.ss.getQuadWord((this.cpu.esi << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 2544: {
                return this.cpu.ss.getQuadWord((this.cpu.esi << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 2545: {
                return this.cpu.ss.getQuadWord((this.cpu.esi << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 2546: {
                return this.cpu.ss.getQuadWord((this.cpu.esi << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 2547: {
                return this.cpu.ss.getQuadWord((this.cpu.esi << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 2548: {
                return this.cpu.ss.getQuadWord((this.cpu.esi << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 2549: {
                return this.cpu.ss.getQuadWord((this.cpu.edi << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 2550: {
                return this.cpu.ss.getQuadWord((this.cpu.edi << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 2551: {
                return this.cpu.ss.getQuadWord((this.cpu.edi << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 2552: {
                return this.cpu.ss.getQuadWord((this.cpu.edi << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 2553: {
                return this.cpu.ss.getQuadWord((this.cpu.edi << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 2554: {
                return this.cpu.ss.getQuadWord((this.cpu.edi << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 2555: {
                return this.cpu.ss.getQuadWord((this.cpu.edi << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 2556: {
                return this.cpu.ss.getQuadWord((this.cpu.edi << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 2557: {
                return this.cpu.ss.getQuadWord(this.cpu.eax + this.cpu.ecx + this.getMicrocode());
            }
            case 2558: {
                return this.cpu.ss.getQuadWord(this.cpu.eax + this.cpu.edx + this.getMicrocode());
            }
            case 2559: {
                return this.cpu.ss.getQuadWord(this.cpu.eax + this.cpu.ebx + this.getMicrocode());
            }
            case 2560: {
                return this.cpu.ss.getQuadWord(this.cpu.eax + this.cpu.esp + this.getMicrocode());
            }
            case 2561: {
                return this.cpu.ss.getQuadWord(this.cpu.eax + this.cpu.ebp + this.getMicrocode());
            }
            case 2562: {
                return this.cpu.ss.getQuadWord(this.cpu.eax + this.cpu.esi + this.getMicrocode());
            }
            case 2563: {
                return this.cpu.ss.getQuadWord(this.cpu.eax + this.cpu.edi + this.getMicrocode());
            }
            case 2564: {
                return this.cpu.ss.getQuadWord(this.cpu.ecx + this.cpu.edx + this.getMicrocode());
            }
            case 2565: {
                return this.cpu.ss.getQuadWord(this.cpu.ecx + this.cpu.ebx + this.getMicrocode());
            }
            case 2566: {
                return this.cpu.ss.getQuadWord(this.cpu.ecx + this.cpu.esp + this.getMicrocode());
            }
            case 2567: {
                return this.cpu.ss.getQuadWord(this.cpu.ecx + this.cpu.ebp + this.getMicrocode());
            }
            case 2568: {
                return this.cpu.ss.getQuadWord(this.cpu.ecx + this.cpu.esi + this.getMicrocode());
            }
            case 2569: {
                return this.cpu.ss.getQuadWord(this.cpu.ecx + this.cpu.edi + this.getMicrocode());
            }
            case 2570: {
                return this.cpu.ss.getQuadWord(this.cpu.edx + this.cpu.ebx + this.getMicrocode());
            }
            case 2571: {
                return this.cpu.ss.getQuadWord(this.cpu.edx + this.cpu.esp + this.getMicrocode());
            }
            case 2572: {
                return this.cpu.ss.getQuadWord(this.cpu.edx + this.cpu.ebp + this.getMicrocode());
            }
            case 2573: {
                return this.cpu.ss.getQuadWord(this.cpu.edx + this.cpu.esi + this.getMicrocode());
            }
            case 2574: {
                return this.cpu.ss.getQuadWord(this.cpu.edx + this.cpu.edi + this.getMicrocode());
            }
            case 2575: {
                return this.cpu.ss.getQuadWord(this.cpu.ebx + this.cpu.esp + this.getMicrocode());
            }
            case 2576: {
                return this.cpu.ss.getQuadWord(this.cpu.ebx + this.cpu.ebp + this.getMicrocode());
            }
            case 2577: {
                return this.cpu.ss.getQuadWord(this.cpu.ebx + this.cpu.esi + this.getMicrocode());
            }
            case 2578: {
                return this.cpu.ss.getQuadWord(this.cpu.ebx + this.cpu.edi + this.getMicrocode());
            }
            case 2579: {
                return this.cpu.ss.getQuadWord(this.cpu.esp + this.getMicrocode());
            }
            case 2580: {
                return this.cpu.ss.getQuadWord(this.cpu.ebp + this.cpu.esp + this.getMicrocode());
            }
            case 2581: {
                return this.cpu.ss.getQuadWord(this.cpu.ebp + this.cpu.esi + this.getMicrocode());
            }
            case 2582: {
                return this.cpu.ss.getQuadWord(this.cpu.ebp + this.cpu.edi + this.getMicrocode());
            }
            case 2583: {
                return this.cpu.ss.getQuadWord(this.cpu.esi + this.cpu.esp + this.getMicrocode());
            }
            case 2584: {
                return this.cpu.ss.getQuadWord(this.cpu.esi + this.cpu.edi + this.getMicrocode());
            }
            case 2585: {
                return this.cpu.ss.getQuadWord(this.cpu.edi + this.cpu.esp + this.getMicrocode());
            }
            case 2586: {
                return this.cpu.ss.getQuadWord((this.cpu.eax << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 2587: {
                return this.cpu.ss.getQuadWord((this.cpu.eax << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 2588: {
                return this.cpu.ss.getQuadWord((this.cpu.eax << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 2589: {
                return this.cpu.ss.getQuadWord((this.cpu.eax << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 2590: {
                return this.cpu.ss.getQuadWord((this.cpu.eax << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 2591: {
                return this.cpu.ss.getQuadWord((this.cpu.eax << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 2592: {
                return this.cpu.ss.getQuadWord((this.cpu.eax << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 2593: {
                return this.cpu.ss.getQuadWord((this.cpu.eax << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 2594: {
                return this.cpu.ss.getQuadWord((this.cpu.ecx << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 2595: {
                return this.cpu.ss.getQuadWord((this.cpu.ecx << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 2596: {
                return this.cpu.ss.getQuadWord((this.cpu.ecx << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 2597: {
                return this.cpu.ss.getQuadWord((this.cpu.ecx << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 2598: {
                return this.cpu.ss.getQuadWord((this.cpu.ecx << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 2599: {
                return this.cpu.ss.getQuadWord((this.cpu.ecx << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 2600: {
                return this.cpu.ss.getQuadWord((this.cpu.ecx << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 2601: {
                return this.cpu.ss.getQuadWord((this.cpu.ecx << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 2602: {
                return this.cpu.ss.getQuadWord((this.cpu.edx << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 2603: {
                return this.cpu.ss.getQuadWord((this.cpu.edx << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 2604: {
                return this.cpu.ss.getQuadWord((this.cpu.edx << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 2605: {
                return this.cpu.ss.getQuadWord((this.cpu.edx << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 2606: {
                return this.cpu.ss.getQuadWord((this.cpu.edx << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 2607: {
                return this.cpu.ss.getQuadWord((this.cpu.edx << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 2608: {
                return this.cpu.ss.getQuadWord((this.cpu.edx << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 2609: {
                return this.cpu.ss.getQuadWord((this.cpu.edx << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 2610: {
                return this.cpu.ss.getQuadWord((this.cpu.ebx << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 2611: {
                return this.cpu.ss.getQuadWord((this.cpu.ebx << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 2612: {
                return this.cpu.ss.getQuadWord((this.cpu.ebx << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 2613: {
                return this.cpu.ss.getQuadWord((this.cpu.ebx << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 2614: {
                return this.cpu.ss.getQuadWord((this.cpu.ebx << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 2615: {
                return this.cpu.ss.getQuadWord((this.cpu.ebx << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 2616: {
                return this.cpu.ss.getQuadWord((this.cpu.ebx << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 2617: {
                return this.cpu.ss.getQuadWord((this.cpu.ebx << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 2618: {
                return this.cpu.ss.getQuadWord((this.cpu.ebp << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 2619: {
                return this.cpu.ss.getQuadWord((this.cpu.ebp << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 2620: {
                return this.cpu.ss.getQuadWord((this.cpu.ebp << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 2621: {
                return this.cpu.ss.getQuadWord((this.cpu.ebp << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 2622: {
                return this.cpu.ss.getQuadWord((this.cpu.ebp << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 2623: {
                return this.cpu.ss.getQuadWord((this.cpu.ebp << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 2624: {
                return this.cpu.ss.getQuadWord((this.cpu.ebp << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 2625: {
                return this.cpu.ss.getQuadWord((this.cpu.ebp << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 2626: {
                return this.cpu.ss.getQuadWord((this.cpu.esi << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 2627: {
                return this.cpu.ss.getQuadWord((this.cpu.esi << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 2628: {
                return this.cpu.ss.getQuadWord((this.cpu.esi << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 2629: {
                return this.cpu.ss.getQuadWord((this.cpu.esi << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 2630: {
                return this.cpu.ss.getQuadWord((this.cpu.esi << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 2631: {
                return this.cpu.ss.getQuadWord((this.cpu.esi << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 2632: {
                return this.cpu.ss.getQuadWord((this.cpu.esi << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 2633: {
                return this.cpu.ss.getQuadWord((this.cpu.esi << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 2634: {
                return this.cpu.ss.getQuadWord((this.cpu.edi << 1) + this.cpu.eax + this.getMicrocode());
            }
            case 2635: {
                return this.cpu.ss.getQuadWord((this.cpu.edi << 1) + this.cpu.ecx + this.getMicrocode());
            }
            case 2636: {
                return this.cpu.ss.getQuadWord((this.cpu.edi << 1) + this.cpu.edx + this.getMicrocode());
            }
            case 2637: {
                return this.cpu.ss.getQuadWord((this.cpu.edi << 1) + this.cpu.ebx + this.getMicrocode());
            }
            case 2638: {
                return this.cpu.ss.getQuadWord((this.cpu.edi << 1) + this.cpu.esp + this.getMicrocode());
            }
            case 2639: {
                return this.cpu.ss.getQuadWord((this.cpu.edi << 1) + this.cpu.ebp + this.getMicrocode());
            }
            case 2640: {
                return this.cpu.ss.getQuadWord((this.cpu.edi << 1) + this.cpu.esi + this.getMicrocode());
            }
            case 2641: {
                return this.cpu.ss.getQuadWord((this.cpu.edi << 1) + this.cpu.edi + this.getMicrocode());
            }
            case 2642: {
                return this.cpu.ss.getQuadWord((this.cpu.eax << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 2643: {
                return this.cpu.ss.getQuadWord((this.cpu.eax << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 2644: {
                return this.cpu.ss.getQuadWord((this.cpu.eax << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 2645: {
                return this.cpu.ss.getQuadWord((this.cpu.eax << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 2646: {
                return this.cpu.ss.getQuadWord((this.cpu.eax << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 2647: {
                return this.cpu.ss.getQuadWord((this.cpu.eax << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 2648: {
                return this.cpu.ss.getQuadWord((this.cpu.eax << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 2649: {
                return this.cpu.ss.getQuadWord((this.cpu.eax << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 2650: {
                return this.cpu.ss.getQuadWord((this.cpu.ecx << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 2651: {
                return this.cpu.ss.getQuadWord((this.cpu.ecx << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 2652: {
                return this.cpu.ss.getQuadWord((this.cpu.ecx << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 2653: {
                return this.cpu.ss.getQuadWord((this.cpu.ecx << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 2654: {
                return this.cpu.ss.getQuadWord((this.cpu.ecx << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 2655: {
                return this.cpu.ss.getQuadWord((this.cpu.ecx << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 2656: {
                return this.cpu.ss.getQuadWord((this.cpu.ecx << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 2657: {
                return this.cpu.ss.getQuadWord((this.cpu.ecx << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 2658: {
                return this.cpu.ss.getQuadWord((this.cpu.edx << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 2659: {
                return this.cpu.ss.getQuadWord((this.cpu.edx << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 2660: {
                return this.cpu.ss.getQuadWord((this.cpu.edx << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 2661: {
                return this.cpu.ss.getQuadWord((this.cpu.edx << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 2662: {
                return this.cpu.ss.getQuadWord((this.cpu.edx << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 2663: {
                return this.cpu.ss.getQuadWord((this.cpu.edx << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 2664: {
                return this.cpu.ss.getQuadWord((this.cpu.edx << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 2665: {
                return this.cpu.ss.getQuadWord((this.cpu.edx << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 2666: {
                return this.cpu.ss.getQuadWord((this.cpu.ebx << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 2667: {
                return this.cpu.ss.getQuadWord((this.cpu.ebx << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 2668: {
                return this.cpu.ss.getQuadWord((this.cpu.ebx << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 2669: {
                return this.cpu.ss.getQuadWord((this.cpu.ebx << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 2670: {
                return this.cpu.ss.getQuadWord((this.cpu.ebx << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 2671: {
                return this.cpu.ss.getQuadWord((this.cpu.ebx << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 2672: {
                return this.cpu.ss.getQuadWord((this.cpu.ebx << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 2673: {
                return this.cpu.ss.getQuadWord((this.cpu.ebx << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 2674: {
                return this.cpu.ss.getQuadWord((this.cpu.ebp << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 2675: {
                return this.cpu.ss.getQuadWord((this.cpu.ebp << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 2676: {
                return this.cpu.ss.getQuadWord((this.cpu.ebp << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 2677: {
                return this.cpu.ss.getQuadWord((this.cpu.ebp << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 2678: {
                return this.cpu.ss.getQuadWord((this.cpu.ebp << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 2679: {
                return this.cpu.ss.getQuadWord((this.cpu.ebp << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 2680: {
                return this.cpu.ss.getQuadWord((this.cpu.ebp << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 2681: {
                return this.cpu.ss.getQuadWord((this.cpu.ebp << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 2682: {
                return this.cpu.ss.getQuadWord((this.cpu.esi << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 2683: {
                return this.cpu.ss.getQuadWord((this.cpu.esi << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 2684: {
                return this.cpu.ss.getQuadWord((this.cpu.esi << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 2685: {
                return this.cpu.ss.getQuadWord((this.cpu.esi << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 2686: {
                return this.cpu.ss.getQuadWord((this.cpu.esi << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 2687: {
                return this.cpu.ss.getQuadWord((this.cpu.esi << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 2688: {
                return this.cpu.ss.getQuadWord((this.cpu.esi << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 2689: {
                return this.cpu.ss.getQuadWord((this.cpu.esi << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 2690: {
                return this.cpu.ss.getQuadWord((this.cpu.edi << 2) + this.cpu.eax + this.getMicrocode());
            }
            case 2691: {
                return this.cpu.ss.getQuadWord((this.cpu.edi << 2) + this.cpu.ecx + this.getMicrocode());
            }
            case 2692: {
                return this.cpu.ss.getQuadWord((this.cpu.edi << 2) + this.cpu.edx + this.getMicrocode());
            }
            case 2693: {
                return this.cpu.ss.getQuadWord((this.cpu.edi << 2) + this.cpu.ebx + this.getMicrocode());
            }
            case 2694: {
                return this.cpu.ss.getQuadWord((this.cpu.edi << 2) + this.cpu.esp + this.getMicrocode());
            }
            case 2695: {
                return this.cpu.ss.getQuadWord((this.cpu.edi << 2) + this.cpu.ebp + this.getMicrocode());
            }
            case 2696: {
                return this.cpu.ss.getQuadWord((this.cpu.edi << 2) + this.cpu.esi + this.getMicrocode());
            }
            case 2697: {
                return this.cpu.ss.getQuadWord((this.cpu.edi << 2) + this.cpu.edi + this.getMicrocode());
            }
            case 2698: {
                return this.cpu.ss.getQuadWord((this.cpu.eax << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 2699: {
                return this.cpu.ss.getQuadWord((this.cpu.eax << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 2700: {
                return this.cpu.ss.getQuadWord((this.cpu.eax << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 2701: {
                return this.cpu.ss.getQuadWord((this.cpu.eax << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 2702: {
                return this.cpu.ss.getQuadWord((this.cpu.eax << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 2703: {
                return this.cpu.ss.getQuadWord((this.cpu.eax << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 2704: {
                return this.cpu.ss.getQuadWord((this.cpu.eax << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 2705: {
                return this.cpu.ss.getQuadWord((this.cpu.eax << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 2706: {
                return this.cpu.ss.getQuadWord((this.cpu.ecx << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 2707: {
                return this.cpu.ss.getQuadWord((this.cpu.ecx << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 2708: {
                return this.cpu.ss.getQuadWord((this.cpu.ecx << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 2709: {
                return this.cpu.ss.getQuadWord((this.cpu.ecx << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 2710: {
                return this.cpu.ss.getQuadWord((this.cpu.ecx << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 2711: {
                return this.cpu.ss.getQuadWord((this.cpu.ecx << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 2712: {
                return this.cpu.ss.getQuadWord((this.cpu.ecx << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 2713: {
                return this.cpu.ss.getQuadWord((this.cpu.ecx << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 2714: {
                return this.cpu.ss.getQuadWord((this.cpu.edx << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 2715: {
                return this.cpu.ss.getQuadWord((this.cpu.edx << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 2716: {
                return this.cpu.ss.getQuadWord((this.cpu.edx << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 2717: {
                return this.cpu.ss.getQuadWord((this.cpu.edx << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 2718: {
                return this.cpu.ss.getQuadWord((this.cpu.edx << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 2719: {
                return this.cpu.ss.getQuadWord((this.cpu.edx << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 2720: {
                return this.cpu.ss.getQuadWord((this.cpu.edx << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 2721: {
                return this.cpu.ss.getQuadWord((this.cpu.edx << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 2722: {
                return this.cpu.ss.getQuadWord((this.cpu.ebx << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 2723: {
                return this.cpu.ss.getQuadWord((this.cpu.ebx << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 2724: {
                return this.cpu.ss.getQuadWord((this.cpu.ebx << 3) + this.cpu.edx + this.getMicrocode());
            }
            case 2725: {
                return this.cpu.ss.getQuadWord((this.cpu.ebx << 3) + this.cpu.ebx + this.getMicrocode());
            }
            case 2726: {
                return this.cpu.ss.getQuadWord((this.cpu.ebx << 3) + this.cpu.esp + this.getMicrocode());
            }
            case 2727: {
                return this.cpu.ss.getQuadWord((this.cpu.ebx << 3) + this.cpu.ebp + this.getMicrocode());
            }
            case 2728: {
                return this.cpu.ss.getQuadWord((this.cpu.ebx << 3) + this.cpu.esi + this.getMicrocode());
            }
            case 2729: {
                return this.cpu.ss.getQuadWord((this.cpu.ebx << 3) + this.cpu.edi + this.getMicrocode());
            }
            case 2730: {
                return this.cpu.ss.getQuadWord((this.cpu.ebp << 3) + this.cpu.eax + this.getMicrocode());
            }
            case 2731: {
                return this.cpu.ss.getQuadWord((this.cpu.ebp << 3) + this.cpu.ecx + this.getMicrocode());
            }
            case 2732: {
                return this