/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator.memory.codeblock.basic;

import org.jpc.emulator.memory.codeblock.ByteSource;
import org.jpc.emulator.memory.codeblock.Decoder;
import org.jpc.emulator.memory.codeblock.InstructionSource;
import org.jpc.emulator.memory.codeblock.basic.FirstStageCodeSet;

public final class RealModeDecoder
implements FirstStageCodeSet,
Decoder,
InstructionSource {
    private static final boolean[] modrmArray = new boolean[]{true, true, true, true, false, false, false, false, true, true, true, true, false, false, false, false, true, true, true, true, false, false, false, false, true, true, true, true, false, false, false, false, true, true, true, true, false, false, false, false, true, true, true, true, false, false, false, false, true, true, true, true, false, false, false, false, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, true, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, true, true, true, true, false, false, false, false, false, false, false, false, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, true, true};
    private static final boolean[] sibArray = new boolean[]{false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false};
    private static final boolean[] twoByte_0f_modrmArray = new boolean[]{true, true, true, true, false, false, false, false, false, false, false, true, false, false, false, false, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, true, true, true, true, true, false, true, false, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, true, true, true, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true};
    private static final boolean[] twoByte_0f_sibArray = new boolean[]{false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false};
    private static final int PREFICES_SG = 7;
    private static final int PREFICES_ES = 1;
    private static final int PREFICES_CS = 2;
    private static final int PREFICES_SS = 3;
    private static final int PREFICES_DS = 4;
    private static final int PREFICES_FS = 5;
    private static final int PREFICES_GS = 6;
    private static final int PREFICES_OPERAND = 8;
    private static final int PREFICES_ADDRESS = 16;
    private static final int PREFICES_REPNE = 32;
    private static final int PREFICES_REPE = 64;
    private static final int PREFICES_REP = 96;
    private static final int PREFICES_LOCK = 128;
    private ByteSource source;
    private Operation current = new Operation();
    private Operation waiting = new Operation();
    private Operation working = new Operation();
    private boolean blockComplete;

    public InstructionSource decodeReal(ByteSource byteSource) {
        this.reset();
        this.source = byteSource;
        return this;
    }

    public InstructionSource decodeProtected(ByteSource byteSource, boolean bl) {
        return null;
    }

    private void blockFinished() {
        this.blockComplete = true;
    }

    private void rotate() {
        Operation operation = this.current;
        this.current = this.waiting;
        this.waiting = this.working;
        this.working = operation;
    }

    public boolean getNext() {
        this.decode();
        this.rotate();
        if (this.current.decoded()) {
            return true;
        }
        if (this.current.terminal()) {
            this.reset();
            return false;
        }
        return this.getNext();
    }

    private void reset() {
        this.working.reset();
        this.waiting.reset();
        this.current.reset();
        this.blockComplete = false;
    }

    public int getMicrocode() {
        return this.current.getMicrocode();
    }

    public int getLength() {
        return this.current.getLength();
    }

    public int getX86Length() {
        return this.current.getX86Length();
    }

    private void decodeComplete(int n) {
        this.working.finish(n);
    }

    private void decode() {
        this.working.reset();
        if (this.blockComplete) {
            this.working.makeTerminal();
            return;
        }
        int n = 0;
        try {
            n = this.decodeOpcode();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            if (!this.waiting.decoded()) {
                throw arrayIndexOutOfBoundsException;
            }
            this.waiting.write(262);
            this.working.makeTerminal();
            this.blockFinished();
            return;
        }
        if (n < 0) {
            this.decodeComplete(-n);
            this.blockFinished();
        } else {
            this.decodeComplete(n);
        }
    }

    private int decodeOpcode() {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = -1;
        int n7 = -1;
        block33: while (true) {
            ++n5;
            n2 = 0xFF & this.source.getByte();
            switch (n2) {
                case 15: 
                case 216: 
                case 217: 
                case 218: 
                case 219: 
                case 220: 
                case 221: 
                case 222: 
                case 223: {
                    n3 = n3 << 8 | n2;
                    n2 = 0xFF & this.source.getByte();
                    ++n5;
                    n6 = n2;
                    break block33;
                }
                default: {
                    break block33;
                }
                case 46: {
                    n4 &= 0xFFFFFFF8;
                    n4 |= 2;
                    continue block33;
                }
                case 62: {
                    n4 &= 0xFFFFFFF8;
                    n4 |= 4;
                    continue block33;
                }
                case 38: {
                    n4 &= 0xFFFFFFF8;
                    n4 |= 1;
                    continue block33;
                }
                case 54: {
                    n4 &= 0xFFFFFFF8;
                    n4 |= 3;
                    continue block33;
                }
                case 100: {
                    n4 &= 0xFFFFFFF8;
                    n4 |= 5;
                    continue block33;
                }
                case 101: {
                    n4 &= 0xFFFFFFF8;
                    n4 |= 6;
                    continue block33;
                }
                case 102: {
                    n4 ^= 8;
                    continue block33;
                }
                case 103: {
                    n4 ^= 0x10;
                    continue block33;
                }
                case 242: {
                    n4 |= 0x20;
                    continue block33;
                }
                case 243: {
                    n4 |= 0x40;
                    continue block33;
                }
                case 240: {
                    n4 |= 0x80;
                    continue block33;
                }
            }
            break;
        }
        n2 = n3 << 8 | n2;
        switch (n3) {
            case 0: {
                if (modrmArray[n2]) {
                    n6 = 0xFF & this.source.getByte();
                    ++n5;
                } else {
                    n6 = -1;
                }
                if (n6 == -1 || (n4 & 0x10) == 0) {
                    n7 = -1;
                    break;
                }
                if (sibArray[n6]) {
                    n7 = 0xFF & this.source.getByte();
                    ++n5;
                    break;
                }
                n7 = -1;
                break;
            }
            case 15: {
                if (twoByte_0f_modrmArray[0xFF & n2]) {
                    n6 = 0xFF & this.source.getByte();
                    ++n5;
                } else {
                    n6 = -1;
                }
                if (n6 == -1 || (n4 & 0x10) == 0) {
                    n7 = -1;
                    break;
                }
                if (twoByte_0f_sibArray[n6]) {
                    n7 = 0xFF & this.source.getByte();
                    ++n5;
                    break;
                }
                n7 = -1;
                break;
            }
            case 216: 
            case 217: 
            case 218: 
            case 219: 
            case 220: 
            case 221: 
            case 222: 
            case 223: {
                if (sibArray[n6]) {
                    n7 = 0xFF & this.source.getByte();
                    ++n5;
                    break;
                }
                n7 = -1;
                break;
            }
            default: {
                n6 = -1;
                n7 = -1;
            }
        }
        int n8 = RealModeDecoder.decodeOperation(n4, n2, n6);
        if (RealModeDecoder.isJump(n8)) {
            this.working.write(262);
        }
        this.working.write(n8);
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = RealModeDecoder.operandCount(n8);
        block34: for (n = 0; n < n12; ++n) {
            switch (RealModeDecoder.operandHasDisplacement(RealModeDecoder.decodeOperand(n, n4, n2, n6, n7))) {
                case 0: {
                    continue block34;
                }
                case 1: {
                    n9 = this.source.getByte();
                    ++n5;
                    n = n12;
                    continue block34;
                }
                case 2: {
                    n9 = this.source.getByte() & 0xFF | this.source.getByte() << 8 & 0xFF00;
                    n5 += 2;
                    n = n12;
                    continue block34;
                }
                case 4: {
                    n9 = this.source.getByte() & 0xFF | this.source.getByte() << 8 & 0xFF00 | this.source.getByte() << 16 & 0xFF0000 | this.source.getByte() << 24 & 0xFF000000;
                    n5 += 4;
                    n = n12;
                    continue block34;
                }
                default: {
                    System.err.println("Displacement Longer Than 4-bytes");
                }
            }
        }
        block35: for (n = 0; n < n12; ++n) {
            switch (RealModeDecoder.operandHasImmediate(RealModeDecoder.decodeOperand(n, n4, n2, n6, n7))) {
                case 0: {
                    continue block35;
                }
                case 1: {
                    n10 = this.source.getByte();
                    ++n5;
                    n = n12;
                    continue block35;
                }
                case 2: {
                    n10 = this.source.getByte() & 0xFF | this.source.getByte() << 8 & 0xFF00;
                    n5 += 2;
                    n = n12;
                    continue block35;
                }
                case 3: {
                    n10 = this.source.getByte() << 16 & 0xFF0000 | this.source.getByte() << 24 & 0xFF000000 | this.source.getByte() & 0xFF;
                    n5 += 3;
                    n = n12;
                    continue block35;
                }
                case 4: {
                    n10 = this.source.getByte() & 0xFF | this.source.getByte() << 8 & 0xFF00 | this.source.getByte() << 16 & 0xFF0000 | this.source.getByte() << 24 & 0xFF000000;
                    n5 += 4;
                    n = n12;
                    continue block35;
                }
                case 6: {
                    n10 = this.source.getByte() & 0xFF | this.source.getByte() << 8 & 0xFF00 | this.source.getByte() << 16 & 0xFF0000 | this.source.getByte() << 24 & 0xFF000000;
                    n5 += 4;
                    n11 = this.source.getByte() & 0xFF | this.source.getByte() << 8 & 0xFF00;
                    n5 += 2;
                    n = n12;
                    continue block35;
                }
                default: {
                    System.err.println("Immediate Longer Than 6-bytes");
                }
            }
        }
        for (n = 0; n < n12; ++n) {
            int n13 = RealModeDecoder.decodeOperand(n, n4, n2, n6, n7);
            this.working.write(n13);
            if (RealModeDecoder.operandHasDisplacement(n13) > 0) {
                this.working.write(n9);
            }
            if (RealModeDecoder.operandHasImmediate(n13) > 0) {
                this.working.write(n10);
            }
            if (RealModeDecoder.operandHasImmediate(n13) <= 4) continue;
            this.working.write(n11);
        }
        if (RealModeDecoder.isJump(n8)) {
            return -n5;
        }
        return n5;
    }

    private static int decodeOperation(int n, int n2, int n3) {
        if ((n2 & 0xFF00) == 3840) {
            return RealModeDecoder.decodeTwoByteOperation(n, n2, n3);
        }
        if ((n2 & 0xF800) == 55296) {
            return RealModeDecoder.decodeFPUOperation(n, n2, n3);
        }
        switch (n2) {
            case 0: 
            case 2: 
            case 4: {
                return 0;
            }
            case 1: 
            case 3: 
            case 5: {
                if ((n & 8) != 0) {
                    return 1;
                }
                return 2;
            }
            case 8: 
            case 10: 
            case 12: {
                return 3;
            }
            case 9: 
            case 11: 
            case 13: {
                if ((n & 8) != 0) {
                    return 4;
                }
                return 5;
            }
            case 16: 
            case 18: 
            case 20: {
                return 6;
            }
            case 17: 
            case 19: 
            case 21: {
                if ((n & 8) != 0) {
                    return 7;
                }
                return 8;
            }
            case 24: 
            case 26: 
            case 28: {
                return 9;
            }
            case 25: 
            case 27: 
            case 29: {
                if ((n & 8) != 0) {
                    return 10;
                }
                return 11;
            }
            case 32: 
            case 34: 
            case 36: {
                return 12;
            }
            case 33: 
            case 35: 
            case 37: {
                if ((n & 8) != 0) {
                    return 13;
                }
                return 14;
            }
            case 39: {
                return 15;
            }
            case 40: 
            case 42: 
            case 44: {
                return 16;
            }
            case 41: 
            case 43: 
            case 45: {
                if ((n & 8) != 0) {
                    return 17;
                }
                return 18;
            }
            case 47: {
                return 19;
            }
            case 48: 
            case 50: 
            case 52: {
                return 20;
            }
            case 49: 
            case 51: 
            case 53: {
                if ((n & 8) != 0) {
                    return 21;
                }
                return 22;
            }
            case 55: {
                return 23;
            }
            case 56: 
            case 58: 
            case 60: {
                return 24;
            }
            case 57: 
            case 59: 
            case 61: {
                if ((n & 8) != 0) {
                    return 25;
                }
                return 26;
            }
            case 63: {
                return 27;
            }
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: {
                if ((n & 8) != 0) {
                    return 28;
                }
                return 29;
            }
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: {
                if ((n & 8) != 0) {
                    return 30;
                }
                return 31;
            }
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 104: 
            case 106: {
                switch (n & 0x18) {
                    case 0: {
                        return 32;
                    }
                    case 8: {
                        return 33;
                    }
                    case 16: {
                        return 34;
                    }
                    case 24: {
                        return 35;
                    }
                }
                break;
            }
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 143: {
                switch (n & 0x18) {
                    case 0: {
                        return 36;
                    }
                    case 8: {
                        return 37;
                    }
                    case 16: {
                        return 38;
                    }
                    case 24: {
                        return 39;
                    }
                }
                break;
            }
            case 96: {
                switch (n & 0x18) {
                    case 0: {
                        return 40;
                    }
                    case 8: {
                        return 41;
                    }
                    case 16: {
                        return 42;
                    }
                    case 24: {
                        return 43;
                    }
                }
                break;
            }
            case 97: {
                switch (n & 0x18) {
                    case 0: {
                        return 44;
                    }
                    case 8: {
                        return 45;
                    }
                    case 16: {
                        return 46;
                    }
                    case 24: {
                        return 47;
                    }
                }
                break;
            }
            case 98: {
                switch (n & 0x18) {
                    case 0: {
                        return 48;
                    }
                    case 8: {
                        return 49;
                    }
                    case 16: {
                        return 50;
                    }
                    case 24: {
                        return 51;
                    }
                }
                break;
            }
            case 99: {
                break;
            }
            case 105: 
            case 107: {
                if ((n & 8) != 0) {
                    return 52;
                }
                return 53;
            }
            case 108: {
                if ((n & 0x60) != 0) {
                    if ((n & 0x10) != 0) {
                        return 290;
                    }
                    return 263;
                }
                if ((n & 0x10) != 0) {
                    return 353;
                }
                return 185;
            }
            case 109: {
                if ((n & 8) != 0) {
                    if ((n & 0x60) != 0) {
                        if ((n & 0x10) != 0) {
                            return 292;
                        }
                        return 265;
                    }
                    if ((n & 0x10) != 0) {
                        return 355;
                    }
                    return 187;
                }
                if ((n & 0x60) != 0) {
                    if ((n & 0x10) != 0) {
                        return 291;
                    }
                    return 264;
                }
                if ((n & 0x10) != 0) {
                    return 354;
                }
                return 186;
            }
            case 110: {
                if ((n & 0x60) != 0) {
                    if ((n & 0x10) != 0) {
                        return 311;
                    }
                    return 284;
                }
                if ((n & 0x10) != 0) {
                    return 368;
                }
                return 255;
            }
            case 111: {
                if ((n & 8) != 0) {
                    if ((n & 0x60) != 0) {
                        if ((n & 0x10) != 0) {
                            return 313;
                        }
                        return 286;
                    }
                    if ((n & 0x10) != 0) {
                        return 370;
                    }
                    return 257;
                }
                if ((n & 0x60) != 0) {
                    if ((n & 0x10) != 0) {
                        return 312;
                    }
                    return 285;
                }
                if ((n & 0x10) != 0) {
                    return 369;
                }
                return 256;
            }
            case 112: {
                return 54;
            }
            case 113: {
                return 55;
            }
            case 114: {
                return 56;
            }
            case 115: {
                return 57;
            }
            case 116: {
                return 58;
            }
            case 117: {
                return 59;
            }
            case 118: {
                return 60;
            }
            case 119: {
                return 61;
            }
            case 120: {
                return 62;
            }
            case 121: {
                return 63;
            }
            case 122: {
                return 64;
            }
            case 123: {
                return 65;
            }
            case 124: {
                return 66;
            }
            case 125: {
                return 67;
            }
            case 126: {
                return 68;
            }
            case 127: {
                return 69;
            }
            case 132: {
                return 70;
            }
            case 133: {
                if ((n & 8) != 0) {
                    return 71;
                }
                return 72;
            }
            case 134: {
                return 73;
            }
            case 136: 
            case 138: 
            case 160: 
            case 162: 
            case 176: 
            case 177: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 198: {
                return 74;
            }
            case 137: 
            case 139: 
            case 161: 
            case 163: 
            case 184: 
            case 185: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 199: {
                if ((n & 8) != 0) {
                    return 75;
                }
                return 76;
            }
            case 140: 
            case 142: {
                return 76;
            }
            case 141: {
                switch (n & 0x18) {
                    case 0: {
                        return 77;
                    }
                    case 8: {
                        return 78;
                    }
                    case 16: {
                        return 79;
                    }
                    case 24: {
                        return 80;
                    }
                }
                break;
            }
            case 144: {
                return 81;
            }
            case 135: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: {
                if ((n & 8) != 0) {
                    return 82;
                }
                return 83;
            }
            case 152: {
                if ((n & 8) != 0) {
                    return 84;
                }
                return 85;
            }
            case 153: {
                if ((n & 8) != 0) {
                    return 86;
                }
                return 87;
            }
            case 154: {
                switch (n & 0x18) {
                    case 0: {
                        return 88;
                    }
                    case 8: {
                        return 89;
                    }
                    case 16: {
                        return 90;
                    }
                    case 24: {
                        return 91;
                    }
                }
                break;
            }
            case 155: {
                return 92;
            }
            case 156: {
                switch (n & 0x18) {
                    case 0: {
                        return 93;
                    }
                    case 8: {
                        return 94;
                    }
                    case 16: {
                        return 95;
                    }
                    case 24: {
                        return 96;
                    }
                }
                break;
            }
            case 157: {
                switch (n & 0x18) {
                    case 0: {
                        return 97;
                    }
                    case 8: {
                        return 98;
                    }
                    case 16: {
                        return 99;
                    }
                    case 24: {
                        return 100;
                    }
                }
                break;
            }
            case 158: {
                return 101;
            }
            case 159: {
                return 102;
            }
            case 164: {
                if ((n & 0x60) != 0) {
                    if ((n & 0x10) != 0) {
                        return 293;
                    }
                    return 266;
                }
                if ((n & 0x10) != 0) {
                    return 356;
                }
                return 188;
            }
            case 165: {
                if ((n & 8) != 0) {
                    if ((n & 0x60) != 0) {
                        if ((n & 0x10) != 0) {
                            return 295;
                        }
                        return 268;
                    }
                    if ((n & 0x10) != 0) {
                        return 358;
                    }
                    return 190;
                }
                if ((n & 0x60) != 0) {
                    if ((n & 0x10) != 0) {
                        return 294;
                    }
                    return 267;
                }
                if ((n & 0x10) != 0) {
                    return 357;
                }
                return 189;
            }
            case 166: {
                if ((n & 0x40) != 0) {
                    if ((n & 0x10) != 0) {
                        return 296;
                    }
                    return 269;
                }
                if ((n & 0x20) != 0) {
                    if ((n & 0x10) != 0) {
                        return 299;
                    }
                    return 272;
                }
                if ((n & 0x10) != 0) {
                    return 359;
                }
                return 191;
            }
            case 167: {
                if ((n & 8) != 0) {
                    if ((n & 0x40) != 0) {
                        if ((n & 0x10) != 0) {
                            return 298;
                        }
                        return 271;
                    }
                    if ((n & 0x20) != 0) {
                        if ((n & 0x10) != 0) {
                            return 301;
                        }
                        return 274;
                    }
                    if ((n & 0x10) != 0) {
                        return 361;
                    }
                    return 193;
                }
                if ((n & 0x40) != 0) {
                    if ((n & 0x10) != 0) {
                        return 297;
                    }
                    return 270;
                }
                if ((n & 0x20) != 0) {
                    if ((n & 0x10) != 0) {
                        return 300;
                    }
                    return 273;
                }
                if ((n & 0x10) != 0) {
                    return 360;
                }
                return 192;
            }
            case 168: {
                return 70;
            }
            case 169: {
                if ((n & 8) != 0) {
                    return 71;
                }
                return 72;
            }
            case 170: {
                if ((n & 0x60) != 0) {
                    if ((n & 0x10) != 0) {
                        return 302;
                    }
                    return 275;
                }
                if ((n & 0x10) != 0) {
                    return 362;
                }
                return 194;
            }
            case 171: {
                if ((n & 8) != 0) {
                    if ((n & 0x60) != 0) {
                        if ((n & 0x10) != 0) {
                            return 304;
                        }
                        return 277;
                    }
                    if ((n & 0x10) != 0) {
                        return 364;
                    }
                    return 196;
                }
                if ((n & 0x60) != 0) {
                    if ((n & 0x10) != 0) {
                        return 303;
                    }
                    return 276;
                }
                if ((n & 0x10) != 0) {
                    return 363;
                }
                return 195;
            }
            case 172: {
                if ((n & 0x60) != 0) {
                    if ((n & 0x10) != 0) {
                        return 314;
                    }
                    return 287;
                }
                if ((n & 0x10) != 0) {
                    return 371;
                }
                return 258;
            }
            case 173: {
                if ((n & 8) != 0) {
                    if ((n & 0x60) != 0) {
                        if ((n & 0x10) != 0) {
                            return 316;
                        }
                        return 289;
                    }
                    if ((n & 0x10) != 0) {
                        return 373;
                    }
                    return 260;
                }
                if ((n & 0x60) != 0) {
                    if ((n & 0x10) != 0) {
                        return 315;
                    }
                    return 288;
                }
                if ((n & 0x10) != 0) {
                    return 372;
                }
                return 259;
            }
            case 174: {
                if ((n & 0x40) != 0) {
                    if ((n & 0x10) != 0) {
                        return 305;
                    }
                    return 278;
                }
                if ((n & 0x20) != 0) {
                    if ((n & 0x10) != 0) {
                        return 308;
                    }
                    return 281;
                }
                if ((n & 0x10) != 0) {
                    return 365;
                }
                return 197;
            }
            case 175: {
                if ((n & 8) != 0) {
                    if ((n & 0x40) != 0) {
                        if ((n & 0x10) != 0) {
                            return 307;
                        }
                        return 280;
                    }
                    if ((n & 0x20) != 0) {
                        if ((n & 0x10) != 0) {
                            return 310;
                        }
                        return 283;
                    }
                    if ((n & 0x10) != 0) {
                        return 367;
                    }
                    return 199;
                }
                if ((n & 0x40) != 0) {
                    if ((n & 0x10) != 0) {
                        return 306;
                    }
                    return 279;
                }
                if ((n & 0x20) != 0) {
                    if ((n & 0x10) != 0) {
                        return 309;
                    }
                    return 282;
                }
                if ((n & 0x10) != 0) {
                    return 366;
                }
                return 198;
            }
            case 192: 
            case 208: 
            case 210: {
                switch (n3 & 0x38) {
                    case 0: {
                        return 208;
                    }
                    case 8: {
                        return 209;
                    }
                    case 16: {
                        return 210;
                    }
                    case 24: {
                        return 211;
                    }
                    case 32: {
                        return 212;
                    }
                    case 40: {
                        return 213;
                    }
                    case 48: {
                        return 212;
                    }
                    case 56: {
                        return 214;
                    }
                }
                break;
            }
            case 193: 
            case 209: 
            case 211: {
                if ((n & 8) != 0) {
                    switch (n3 & 0x38) {
                        case 0: {
                            return 222;
                        }
                        case 8: {
                            return 223;
                        }
                        case 16: {
                            return 224;
                        }
                        case 24: {
                            return 225;
                        }
                        case 32: {
                            return 226;
                        }
                        case 40: {
                            return 227;
                        }
                        case 48: {
                            return 226;
                        }
                        case 56: {
                            return 228;
                        }
                    }
                    break;
                }
                switch (n3 & 0x38) {
                    case 0: {
                        return 215;
                    }
                    case 8: {
                        return 216;
                    }
                    case 16: {
                        return 217;
                    }
                    case 24: {
                        return 218;
                    }
                    case 32: {
                        return 219;
                    }
                    case 40: {
                        return 220;
                    }
                    case 48: {
                        return 219;
                    }
                    case 56: {
                        return 221;
                    }
                }
                break;
            }
            case 194: {
                switch (n & 0x18) {
                    case 0: {
                        return 103;
                    }
                    case 8: {
                        return 104;
                    }
                    case 16: {
                        return 105;
                    }
                    case 24: {
                        return 106;
                    }
                }
                break;
            }
            case 195: {
                switch (n & 0x18) {
                    case 0: {
                        return 107;
                    }
                    case 8: {
                        return 108;
                    }
                    case 16: {
                        return 109;
                    }
                    case 24: {
                        return 110;
                    }
                }
                break;
            }
            case 200: {
                switch (n & 0x18) {
                    case 0: {
                        return 111;
                    }
                    case 8: {
                        return 112;
                    }
                    case 16: {
                        return 113;
                    }
                    case 24: {
                        return 114;
                    }
                }
                break;
            }
            case 201: {
                switch (n & 0x18) {
                    case 0: {
                        return 115;
                    }
                    case 8: {
                        return 116;
                    }
                    case 16: {
                        return 117;
                    }
                    case 24: {
                        return 118;
                    }
                }
                break;
            }
            case 202: {
                switch (n & 0x18) {
                    case 0: {
                        return 119;
                    }
                    case 8: {
                        return 120;
                    }
                    case 16: {
                        return 121;
                    }
                    case 24: {
                        return 122;
                    }
                }
                break;
            }
            case 203: {
                switch (n & 0x18) {
                    case 0: {
                        return 123;
                    }
                    case 8: {
                        return 124;
                    }
                    case 16: {
                        return 125;
                    }
                    case 24: {
                        return 126;
                    }
                }
                break;
            }
            case 204: {
                switch (n & 0x18) {
                    case 0: {
                        return 127;
                    }
                    case 8: {
                        return 128;
                    }
                    case 16: {
                        return 129;
                    }
                    case 24: {
                        return 130;
                    }
                }
                break;
            }
            case 205: {
                switch (n & 0x18) {
                    case 0: {
                        return 131;
                    }
                    case 8: {
                        return 132;
                    }
                    case 16: {
                        return 133;
                    }
                    case 24: {
                        return 134;
                    }
                }
                break;
            }
            case 206: {
                switch (n & 0x18) {
                    case 0: {
                        return 135;
                    }
                    case 8: {
                        return 136;
                    }
                    case 16: {
                        return 137;
                    }
                    case 24: {
                        return 138;
                    }
                }
                break;
            }
            case 207: {
                switch (n & 0x18) {
                    case 0: {
                        return 139;
                    }
                    case 8: {
                        return 140;
                    }
                    case 16: {
                        return 141;
                    }
                    case 24: {
                        return 142;
                    }
                }
                break;
            }
            case 212: {
                return 143;
            }
            case 213: {
                return 144;
            }
            case 214: {
                return 145;
            }
            case 224: {
                switch (n & 0x18) {
                    case 0: {
                        return 146;
                    }
                    case 8: {
                        return 147;
                    }
                    case 16: {
                        return 148;
                    }
                    case 24: {
                        return 149;
                    }
                }
                break;
            }
            case 225: {
                switch (n & 0x18) {
                    case 0: {
                        return 150;
                    }
                    case 8: {
                        return 151;
                    }
                    case 16: {
                        return 152;
                    }
                    case 24: {
                        return 153;
                    }
                }
                break;
            }
            case 226: {
                switch (n & 0x18) {
                    case 0: {
                        return 154;
                    }
                    case 8: {
                        return 155;
                    }
                    case 16: {
                        return 156;
                    }
                    case 24: {
                        return 157;
                    }
                }
                break;
            }
            case 227: {
                if ((n & 0x10) != 0) {
                    return 159;
                }
                return 158;
            }
            case 228: {
                return 160;
            }
            case 236: {
                return 163;
            }
            case 229: {
                if ((n & 8) != 0) {
                    return 161;
                }
                return 162;
            }
            case 237: {
                if ((n & 8) != 0) {
                    return 164;
                }
                return 165;
            }
            case 230: {
                return 166;
            }
            case 238: {
                return 169;
            }
            case 231: {
                if ((n & 8) != 0) {
                    return 167;
                }
                return 168;
            }
            case 239: {
                if ((n & 8) != 0) {
                    return 170;
                }
                return 171;
            }
            case 232: {
                switch (n & 0x18) {
                    case 0: {
                        return 200;
                    }
                    case 8: {
                        return 201;
                    }
                    case 16: {
                        return 202;
                    }
                    case 24: {
                        return 203;
                    }
                }
                break;
            }
            case 233: {
                if ((n & 8) != 0) {
                    return 204;
                }
                return 205;
            }
            case 234: {
                if ((n & 8) != 0) {
                    return 206;
                }
                return 207;
            }
            case 235: {
                return 172;
            }
            case 241: {
                switch (n & 0x18) {
                    case 0: {
                        return 173;
                    }
                    case 8: {
                        return 174;
                    }
                    case 16: {
                        return 175;
                    }
                    case 24: {
                        return 176;
                    }
                }
                break;
            }
            case 244: {
                return 177;
            }
            case 245: {
                return 178;
            }
            case 246: {
                switch (n3 & 0x38) {
                    case 0: {
                        return 70;
                    }
                    case 16: {
                        return 246;
                    }
                    case 24: {
                        return 245;
                    }
                    case 32: {
                        return 244;
                    }
                    case 40: {
                        return 376;
                    }
                    case 48: {
                        return 243;
                    }
                    case 56: {
                        return 261;
                    }
                }
                return -1;
            }
            case 247: {
                if ((n & 8) != 0) {
                    switch (n3 & 0x38) {
                        case 0: {
                            return 71;
                        }
                        case 16: {
                            return 241;
                        }
                        case 24: {
                            return 240;
                        }
                        case 32: {
                            return 239;
                        }
                        case 40: {
                            return 378;
                        }
                        case 48: {
                            return 238;
                        }
                        case 56: {
                            return 237;
                        }
                    }
                    return -1;
                }
                switch (n3 & 0x38) {
                    case 0: {
                        return 72;
                    }
                    case 16: {
                        return 236;
                    }
                    case 24: {
                        return 235;
                    }
                    case 32: {
                        return 234;
                    }
                    case 40: {
                        return 377;
                    }
                    case 48: {
                        return 233;
                    }
                    case 56: {
                        return 232;
                    }
                }
                return -1;
            }
            case 248: {
                return 179;
            }
            case 249: {
                return 180;
            }
            case 250: {
                return 181;
            }
            case 251: {
                return 182;
            }
            case 252: {
                return 183;
            }
            case 253: {
                return 184;
            }
            case 254: {
                switch (n3 & 0x38) {
                    case 0: {
                        return 230;
                    }
                    case 8: {
                        return 231;
                    }
                }
                return -1;
            }
            case 215: {
                return 229;
            }
            case 6: 
            case 14: 
            case 22: 
            case 30: {
                switch (n & 0x18) {
                    case 0: {
                        return 32;
                    }
                    case 8: {
                        return 33;
                    }
                    case 16: {
                        return 34;
                    }
                    case 24: {
                        return 35;
                    }
                }
                break;
            }
            case 7: 
            case 23: 
            case 31: {
                switch (n & 0x18) {
                    case 0: {
                        return 36;
                    }
                    case 8: {
                        return 37;
                    }
                    case 16: {
                        return 38;
                    }
                    case 24: {
                        return 39;
                    }
                }
                break;
            }
            case 128: 
            case 130: {
                switch (n3 & 0x38) {
                    case 0: {
                        return 0;
                    }
                    case 8: {
                        return 3;
                    }
                    case 16: {
                        return 6;
                    }
                    case 24: {
                        return 9;
                    }
                    case 32: {
                        return 12;
                    }
                    case 40: {
                        return 16;
                    }
                    case 48: {
                        return 20;
                    }
                    case 56: {
                        return 24;
                    }
                }
                break;
            }
            case 129: 
            case 131: {
                if ((n & 8) != 0) {
                    switch (n3 & 0x38) {
                        case 0: {
                            return 1;
                        }
                        case 8: {
                            return 4;
                        }
                        case 16: {
                            return 7;
                        }
                        case 24: {
                            return 10;
                        }
                        case 32: {
                            return 13;
                        }
                        case 40: {
                            return 17;
                        }
                        case 48: {
                            return 21;
                        }
                        case 56: {
                            return 25;
                        }
                    }
                    break;
                }
                switch (n3 & 0x38) {
                    case 0: {
                        return 2;
                    }
                    case 8: {
                        return 5;
                    }
                    case 16: {
                        return 8;
                    }
                    case 24: {
                        return 11;
                    }
                    case 32: {
                        return 14;
                    }
                    case 40: {
                        return 18;
                    }
                    case 48: {
                        return 22;
                    }
                    case 56: {
                        return 26;
                    }
                }
                break;
            }
            case 255: {
                if ((n & 8) != 0) {
                    switch (n3 & 0x38) {
                        case 0: {
                            return 28;
                        }
                        case 8: {
                            return 30;
                        }
                        case 16: {
                            if ((n & 0x10) != 0) {
                                return 320;
                            }
                            return 318;
                        }
                        case 24: {
                            if ((n & 0x10) != 0) {
                                return 91;
                            }
                            return 89;
                        }
                        case 32: {
                            return 374;
                        }
                        case 40: {
                            return 206;
                        }
                        case 48: {
                            if ((n & 0x10) != 0) {
                                return 35;
                            }
                            return 33;
                        }
                    }
                    break;
                }
                switch (n3 & 0x38) {
                    case 0: {
                        return 29;
                    }
                    case 8: {
                        return 31;
                    }
                    case 16: {
                        if ((n & 0x10) != 0) {
                            return 319;
                        }
                        return 317;
                    }
                    case 24: {
                        if ((n & 0x10) != 0) {
                            return 90;
                        }
                        return 88;
                    }
                    case 32: {
                        return 375;
                    }
                    case 40: {
                        return 207;
                    }
                    case 48: {
                        if ((n & 0x10) != 0) {
                            return 34;
                        }
                        return 32;
                    }
                }
                break;
            }
            case 196: {
                switch (n & 0x18) {
                    case 0: {
                        return 247;
                    }
                    case 8: {
                        return 248;
                    }
                    case 16: {
                        return 249;
                    }
                    case 24: {
                        return 250;
                    }
                }
                break;
            }
            case 197: {
                switch (n & 0x18) {
                    case 0: {
                        return 251;
                    }
                    case 8: {
                        return 252;
                    }
                    case 16: {
                        return 253;
                    }
                    case 24: {
                        return 254;
                    }
                }
                break;
            }
            default: {
                return -1;
            }
        }
        return -1;
    }

    private static int decodeTwoByteOperation(int n, int n2, int n3) {
        switch (n2 & 0xFF) {
            case 1: {
                switch (n3 & 0x38) {
                    case 0: {
                        if ((n & 8) != 0) {
                            return 380;
                        }
                        return 379;
                    }
                    case 8: {
                        if ((n & 8) != 0) {
                            return 384;
                        }
                        return 383;
                    }
                    case 16: {
                        if ((n & 8) != 0) {
                            return 382;
                        }
                        return 381;
                    }
                    case 24: {
                        if ((n & 8) != 0) {
                            return 386;
                        }
                        return 385;
                    }
                    case 32: {
                        return 387;
                    }
                    case 48: {
                        return 388;
                    }
                    case 56: {
                        return 389;
                    }
                }
                return -1;
            }
            case 6: {
                return 449;
            }
            case 32: {
                return 75;
            }
            case 34: {
                return 390;
            }
            case 64: {
                if ((n & 8) != 0) {
                    return 416;
                }
                return 400;
            }
            case 65: {
                if ((n & 8) != 0) {
                    return 417;
                }
                return 401;
            }
            case 66: {
                if ((n & 8) != 0) {
                    return 418;
                }
                return 402;
            }
            case 67: {
                if ((n & 8) != 0) {
                    return 419;
                }
                return 403;
            }
            case 68: {
                if ((n & 8) != 0) {
                    return 420;
                }
                return 404;
            }
            case 69: {
                if ((n & 8) != 0) {
                    return 421;
                }
                return 405;
            }
            case 70: {
                if ((n & 8) != 0) {
                    return 422;
                }
                return 406;
            }
            case 71: {
                if ((n & 8) != 0) {
                    return 423;
                }
                return 407;
            }
            case 72: {
                if ((n & 8) != 0) {
                    return 424;
                }
                return 408;
            }
            case 73: {
                if ((n & 8) != 0) {
                    return 425;
                }
                return 409;
            }
            case 74: {
                if ((n & 8) != 0) {
                    return 426;
                }
                return 410;
            }
            case 75: {
                if ((n & 8) != 0) {
                    return 427;
                }
                return 411;
            }
            case 76: {
                if ((n & 8) != 0) {
                    return 428;
                }
                return 412;
            }
            case 77: {
                if ((n & 8) != 0) {
                    return 429;
                }
                return 413;
            }
            case 78: {
                if ((n & 8) != 0) {
                    return 430;
                }
                return 414;
            }
            case 79: {
                if ((n & 8) != 0) {
                    return 431;
                }
                return 415;
            }
            case 128: {
                if ((n & 8) != 0) {
                    return 337;
                }
                return 321;
            }
            case 129: {
                if ((n & 8) != 0) {
                    return 338;
                }
                return 322;
            }
            case 130: {
                if ((n & 8) != 0) {
                    return 339;
                }
                return 323;
            }
            case 131: {
                if ((n & 8) != 0) {
                    return 340;
                }
                return 324;
            }
            case 132: {
                if ((n & 8) != 0) {
                    return 341;
                }
                return 325;
            }
            case 133: {
                if ((n & 8) != 0) {
                    return 342;
                }
                return 326;
            }
            case 134: {
                if ((n & 8) != 0) {
                    return 343;
                }
                return 327;
            }
            case 135: {
                if ((n & 8) != 0) {
                    return 344;
                }
                return 328;
            }
            case 136: {
                if ((n & 8) != 0) {
                    return 345;
                }
                return 329;
            }
            case 137: {
                if ((n & 8) != 0) {
                    return 346;
                }
                return 330;
            }
            case 138: {
                if ((n & 8) != 0) {
                    return 347;
                }
                return 331;
            }
            case 139: {
                if ((n & 8) != 0) {
                    return 348;
                }
                return 332;
            }
            case 140: {
                if ((n & 8) != 0) {
                    return 349;
                }
                return 333;
            }
            case 141: {
                if ((n & 8) != 0) {
                    return 350;
                }
                return 334;
            }
            case 142: {
                if ((n & 8) != 0) {
                    return 351;
                }
                return 335;
            }
            case 143: {
                if ((n & 8) != 0) {
                    return 352;
                }
                return 336;
            }
            case 144: {
                return 432;
            }
            case 145: {
                return 433;
            }
            case 146: {
                return 434;
            }
            case 147: {
                return 435;
            }
            case 148: {
                return 436;
            }
            case 149: {
                return 437;
            }
            case 150: {
                return 438;
            }
            case 151: {
                return 439;
            }
            case 152: {
                return 440;
            }
            case 153: {
                return 441;
            }
            case 154: {
                return 442;
            }
            case 155: {
                return 443;
            }
            case 156: {
                return 444;
            }
            case 157: {
                return 445;
            }
            case 158: {
                return 446;
            }
            case 159: {
                return 447;
            }
            case 160: 
            case 168: {
                if ((n & 0x10) != 0) {
                    return 34;
                }
                return 32;
            }
            case 161: 
            case 169: {
                if ((n & 0x10) != 0) {
                    return 38;
                }
                return 36;
            }
            case 162: {
                return 448;
            }
            case 163: {
                if ((n & 8) != 0) {
                    return 470;
                }
                return 469;
            }
            case 164: 
            case 165: {
                if ((n & 8) != 0) {
                    return 464;
                }
                return 463;
            }
            case 171: {
                if ((n & 8) != 0) {
                    return 468;
                }
                return 467;
            }
            case 172: 
            case 173: {
                if ((n & 8) != 0) {
                    return 462;
                }
                return 461;
            }
            case 175: {
                if ((n & 8) != 0) {
                    return 52;
                }
                return 53;
            }
            case 176: {
                return 492;
            }
            case 177: {
                if ((n & 8) != 0) {
                    return 494;
                }
                return 493;
            }
            case 178: {
                switch (n & 0x18) {
                    case 0: {
                        return 396;
                    }
                    case 8: {
                        return 397;
                    }
                    case 16: {
                        return 398;
                    }
                    case 24: {
                        return 399;
                    }
                }
                break;
            }
            case 179: {
                if ((n & 8) != 0) {
                    return 466;
                }
                return 465;
            }
            case 180: {
                switch (n & 0x18) {
                    case 0: {
                        return 622;
                    }
                    case 8: {
                        return 623;
                    }
                    case 16: {
                        return 624;
                    }
                    case 24: {
                        return 625;
                    }
                }
                break;
            }
            case 181: {
                switch (n & 0x18) {
                    case 0: {
                        return 626;
                    }
                    case 8: {
                        return 627;
                    }
                    case 16: {
                        return 628;
                    }
                    case 24: {
                        return 629;
                    }
                }
                break;
            }
            case 182: {
                if ((n & 8) != 0) {
                    return 393;
                }
                return 392;
            }
            case 183: {
                if ((n & 8) != 0) {
                    return 395;
                }
                return 394;
            }
            case 186: {
                if ((n & 8) != 0) {
                    switch (n3 & 0x38) {
                        default: {
                            return -1;
                        }
                        case 32: {
                            return 478;
                        }
                        case 40: {
                            return 476;
                        }
                        case 48: {
                            return 474;
                        }
                        case 56: 
                    }
                    return 480;
                }
                switch (n3 & 0x38) {
                    default: {
                        return -1;
                    }
                    case 32: {
                        return 477;
                    }
                    case 40: {
                        return 475;
                    }
                    case 48: {
                        return 473;
                    }
                    case 56: 
                }
                return 479;
            }
            case 187: {
                if ((n & 8) != 0) {
                    return 472;
                }
                return 471;
            }
            case 188: {
                if ((n & 8) != 0) {
                    return 483;
                }
                return 482;
            }
            case 189: {
                if ((n & 8) != 0) {
                    return 485;
                }
                return 484;
            }
            case 190: {
                if ((n & 8) != 0) {
                    return 458;
                }
                return 457;
            }
            case 191: {
                if ((n & 8) != 0) {
                    return 460;
                }
                return 459;
            }
        }
        return -1;
    }

    private static int decodeFPUOperation(int n, int n2, int n3) {
        if ((n3 & 0xC0) != 192) {
            switch (n2 & 0xFF38) {
                case 55296: {
                    return 497;
                }
                case 55304: {
                    return 498;
                }
                case 55312: {
                    return 499;
                }
                case 55320: {
                    return 500;
                }
                case 55328: {
                    return 501;
                }
                case 55336: {
                    return 502;
                }
                case 55344: {
                    return 503;
                }
                case 55352: {
                    return 504;
                }
                case 55552: {
                    return 505;
                }
                case 55568: {
                    return 506;
                }
                case 55576: {
                    return 507;
                }
                case 55584: {
                    if ((n & 8) == 0) {
                        return 508;
                    }
                    return 634;
                }
                case 55592: {
                    return 509;
                }
                case 55600: {
                    if ((n & 8) == 0) {
                        return 510;
                    }
                    return 635;
                }
                case 55608: {
                    return 511;
                }
                case 55808: {
                    return 512;
                }
                case 55816: {
                    return 513;
                }
                case 55824: {
                    return 514;
                }
                case 55832: {
                    return 515;
                }
                case 55840: {
                    return 516;
                }
                case 55848: {
                    return 517;
                }
                case 55856: {
                    return 518;
                }
                case 55864: {
                    return 519;
                }
                case 56064: {
                    return 520;
                }
                case 56072: {
                    return 521;
                }
                case 56080: {
                    return 522;
                }
                case 56088: {
                    return 523;
                }
                case 56104: {
                    return 524;
                }
                case 56120: {
                    return 525;
                }
                case 56320: {
                    return 526;
                }
                case 56328: {
                    return 527;
                }
                case 56336: {
                    return 528;
                }
                case 56344: {
                    return 529;
                }
                case 56352: {
                    return 530;
                }
                case 56360: {
                    return 531;
                }
                case 56368: {
                    return 532;
                }
                case 56376: {
                    return 533;
                }
                case 56576: {
                    return 534;
                }
                case 56584: {
                    return 535;
                }
                case 56592: {
                    return 536;
                }
                case 56600: {
                    return 537;
                }
                case 56608: {
                    return 538;
                }
                case 56624: {
                    return 539;
                }
                case 56632: {
                    return 540;
                }
                case 56832: {
                    return 541;
                }
                case 56840: {
                    return 542;
                }
                case 56848: {
                    return 543;
                }
                case 56856: {
                    return 544;
                }
                case 56864: {
                    return 545;
                }
                case 56872: {
                    return 546;
                }
                case 56880: {
                    return 547;
                }
                case 56888: {
                    return 548;
                }
                case 57088: {
                    return 549;
                }
                case 57096: {
                    return 550;
                }
                case 57104: {
                    return 551;
                }
                case 57112: {
                    return 552;
                }
                case 57120: {
                    return 553;
                }
                case 57128: {
                    return 554;
                }
                case 57136: {
                    return 555;
                }
                case 57144: {
                    return 556;
                }
            }
        } else {
            switch (n2 & 0xFFF8) {
                case 55488: {
                    return 557;
                }
                case 55496: {
                    return 558;
                }
                case 55504: {
                    return 559;
                }
                case 55512: {
                    return 560;
                }
                case 55520: {
                    return 561;
                }
                case 55528: {
                    return 562;
                }
                case 55536: {
                    return 563;
                }
                case 55544: {
                    return 564;
                }
                case 55744: {
                    return 565;
                }
                case 55752: {
                    return 566;
                }
                case 56000: {
                    return 567;
                }
                case 56008: {
                    return 568;
                }
                case 56016: {
                    return 569;
                }
                case 56024: {
                    return 570;
                }
                case 56256: {
                    return 571;
                }
                case 56264: {
                    return 572;
                }
                case 56272: {
                    return 573;
                }
                case 56280: {
                    return 574;
                }
                case 56296: {
                    return 575;
                }
                case 56304: {
                    return 576;
                }
                case 56512: {
                    return 557;
                }
                case 56520: {
                    return 558;
                }
                case 56544: {
                    return 562;
                }
                case 56552: {
                    return 561;
                }
                case 56560: {
                    return 564;
                }
                case 56568: {
                    return 563;
                }
                case 56768: {
                    return 577;
                }
                case 56784: {
                    return 578;
                }
                case 56792: {
                    return 579;
                }
                case 56800: {
                    return 580;
                }
                case 56808: {
                    return 581;
                }
                case 57024: {
                    return 582;
                }
                case 57032: {
                    return 583;
                }
                case 57056: {
                    return 584;
                }
                case 57064: {
                    return 585;
                }
                case 57072: {
                    return 586;
                }
                case 57080: {
                    return 587;
                }
                case 57320: {
                    return 588;
                }
                case 57328: {
                    return 589;
                }
            }
            switch (n2) {
                case 55760: {
                    return 590;
                }
                case 55776: {
                    return 591;
                }
                case 55777: {
                    return 592;
                }
                case 55780: {
                    return 593;
                }
                case 55781: {
                    return 594;
                }
                case 55784: {
                    return 595;
                }
                case 55785: {
                    return 596;
                }
                case 55786: {
                    return 597;
                }
                case 55787: {
                    return 598;
                }
                case 55788: {
                    return 599;
                }
                case 55789: {
                    return 600;
                }
                case 55790: {
                    return 601;
                }
                case 55792: {
                    return 602;
                }
                case 55793: {
                    return 603;
                }
                case 55794: {
                    return 604;
                }
                case 55795: {
                    return 605;
                }
                case 55796: {
                    return 606;
                }
                case 55797: {
                    return 607;
                }
                case 55798: {
                    return 608;
                }
                case 55799: {
                    return 609;
                }
                case 55800: {
                    return 610;
                }
                case 55801: {
                    return 611;
                }
                case 55802: {
                    return 612;
                }
                case 55803: {
                    return 613;
                }
                case 55804: {
                    return 614;
                }
                case 55805: {
                    return 615;
                }
                case 55806: {
                    return 616;
                }
                case 55807: {
                    return 617;
                }
                case 56041: {
                    return 618;
                }
                case 56290: {
                    return 619;
                }
                case 56291: {
                    return 620;
                }
                case 56292: {
                    return 81;
                }
                case 57049: {
                    return 621;
                }
                case 57312: {
                    return 540;
                }
            }
        }
        System.err.println("Unknown FPU Operation 0x" + Integer.toHexString(0xFFFF & n2) + " [modrm:0x" + Integer.toHexString(n3) + "]");
        return -1;
    }

    private static int decodeOperand(int n, int n2, int n3, int n4, int n5) {
        if ((n3 & 0xFF00) == 3840) {
            return RealModeDecoder.decodeTwoByteOperand(n, n2, n3, n4, n5);
        }
        if ((n3 & 0xF800) == 55296) {
            return RealModeDecoder.decodeFPUOperand(n, n2, n3, n4, n5);
        }
        switch (n3) {
            case 0: 
            case 8: 
            case 16: 
            case 24: 
            case 32: 
            case 40: 
            case 48: 
            case 56: 
            case 132: 
            case 136: {
                switch (n) {
                    case 0: {
                        return RealModeDecoder.decodeGb(n4);
                    }
                    case 1: {
                        return RealModeDecoder.decodeEb(n2, n4, n5);
                    }
                    case 2: {
                        return RealModeDecoder.decodeEb(n2, n4, n5);
                    }
                }
                return -1;
            }
            case 134: {
                switch (n) {
                    case 0: {
                        return RealModeDecoder.decodeGb(n4);
                    }
                    case 1: {
                        return RealModeDecoder.decodeEb(n2, n4, n5);
                    }
                    case 2: {
                        return RealModeDecoder.decodeGb(n4);
                    }
                    case 3: {
                        return RealModeDecoder.decodeEb(n2, n4, n5);
                    }
                }
                return -1;
            }
            case 2: 
            case 10: 
            case 18: 
            case 26: 
            case 34: 
            case 42: 
            case 50: 
            case 58: 
            case 138: {
                switch (n) {
                    case 0: {
                        return RealModeDecoder.decodeEb(n2, n4, n5);
                    }
                    case 1: {
                        return RealModeDecoder.decodeGb(n4);
                    }
                    case 2: {
                        return RealModeDecoder.decodeGb(n4);
                    }
                }
                return -1;
            }
            case 1: 
            case 9: 
            case 17: 
            case 25: 
            case 33: 
            case 41: 
            case 49: 
            case 57: 
            case 133: 
            case 137: {
                if ((n2 & 8) != 0) {
                    switch (n) {
                        case 0: {
                            return RealModeDecoder.decodeGd(n4);
                        }
                        case 1: {
                            return RealModeDecoder.decodeEd(n2, n4, n5);
                        }
                        case 2: {
                            return RealModeDecoder.decodeEd(n2, n4, n5);
                        }
                    }
                    return -1;
                }
                switch (n) {
                    case 0: {
                        return RealModeDecoder.decodeGw(n4);
                    }
                    case 1: {
                        return RealModeDecoder.decodeEw(n2, n4, n5);
                    }
                    case 2: {
                        return RealModeDecoder.decodeEw(n2, n4, n5);
                    }
                }
                return -1;
            }
            case 135: {
                if ((n2 & 8) != 0) {
                    switch (n) {
                        case 0: {
                            return RealModeDecoder.decodeGd(n4);
                        }
                        case 1: {
                            return RealModeDecoder.decodeEd(n2, n4, n5);
                        }
                        case 2: {
                            return RealModeDecoder.decodeGd(n4);
                        }
                        case 3: {
                            return RealModeDecoder.decodeEd(n2, n4, n5);
                        }
                    }
                    return -1;
                }
                switch (n) {
                    case 0: {
                        return RealModeDecoder.decodeGw(n4);
                    }
                    case 1: {
                        return RealModeDecoder.decodeEw(n2, n4, n5);
                    }
                    case 2: {
                        return RealModeDecoder.decodeGw(n4);
                    }
                    case 3: {
                        return RealModeDecoder.decodeEw(n2, n4, n5);
                    }
                }
                return -1;
            }
            case 3: 
            case 11: 
            case 19: 
            case 27: 
            case 35: 
            case 43: 
            case 51: 
            case 59: 
            case 139: {
                if ((n2 & 8) != 0) {
                    switch (n) {
                        case 0: {
                            return RealModeDecoder.decodeEd(n2, n4, n5);
                        }
                        case 1: {
                            return RealModeDecoder.decodeGd(n4);
                        }
                        case 2: {
                            return RealModeDecoder.decodeGd(n4);
                        }
                    }
                    return -1;
                }
                switch (n) {
                    case 0: {
                        return RealModeDecoder.decodeEw(n2, n4, n5);
                    }
                    case 1: {
                        return RealModeDecoder.decodeGw(n4);
                    }
                    case 2: {
                        return RealModeDecoder.decodeGw(n4);
                    }
                }
                return -1;
            }
            case 141: {
                if ((n2 & 8) != 0) {
                    switch (n) {
                        case 0: {
                            return RealModeDecoder.decodeM(n2, n4, n5);
                        }
                        case 1: {
                            return RealModeDecoder.decodeGd(n4);
                        }
                    }
                    return -1;
                }
                switch (n) {
                    case 0: {
                        return RealModeDecoder.decodeM(n2, n4, n5);
                    }
                    case 1: {
                        return RealModeDecoder.decodeGw(n4);
                    }
                }
                return -1;
            }
            case 128: 
            case 130: 
            case 192: 
            case 198: {
                switch (n) {
                    case 0: {
                        return 41;
                    }
                    case 1: {
                        return RealModeDecoder.decodeEb(n2, n4, n5);
                    }
                    case 2: {
                        return RealModeDecoder.decodeEb(n2, n4, n5);
                    }
                }
                return -1;
            }
            case 129: 
            case 199: {
                if ((n2 & 8) != 0) {
                    switch (n) {
                        case 0: {
                            return 43;
                        }
                        case 1: {
                            return RealModeDecoder.decodeEd(n2, n4, n5);
                        }
                        case 2: {
                            return RealModeDecoder.decodeEd(n2, n4, n5);
                        }
                    }
                    return -1;
                }
                switch (n) {
                    case 0: {
                        return 42;
                    }
                    case 1: {
                        return RealModeDecoder.decodeEw(n2, n4, n5);
                    }
                    case 2: {
                        return RealModeDecoder.decodeEw(n2, n4, n5);
                    }
                }
                return -1;
            }
            case 131: 
            case 193: {
                if ((n2 & 8) != 0) {
                    switch (n) {
                        case 0: {
                            return 41;
                        }
                        case 1: {
                            return RealModeDecoder.decodeEd(n2, n4, n5);
                        }
                        case 2: {
                            return RealModeDecoder.decodeEd(n2, n4, n5);
                        }
                    }
                    return -1;
                }
                switch (n) {
                    case 0: {
                        return 41;
                    }
                    case 1: {
                        return RealModeDecoder.decodeEw(n2, n4, n5);
                    }
                    case 2: {
                        return RealModeDecoder.decodeEw(n2, n4, n5);
                    }
                }
                return -1;
            }
            case 143: {
                if ((n2 & 8) != 0) {
                    return RealModeDecoder.decodeEd(n2, n4, n5);
                }
                return RealModeDecoder.decodeEw(n2, n4, n5);
            }
            case 194: 
            case 202: {
                return 42;
            }
            case 104: 
            case 232: 
            case 233: {
                if ((n2 & 8) != 0) {
                    return 43;
                }
                return 42;
            }
            case 154: 
            case 234: {
                if ((n2 & 8) != 0) {
                    return 45;
                }
                return 44;
            }
            case 236: {
                switch (n) {
                    case 0: {
                        return 10;
                    }
                    case 1: {
                        return 0;
                    }
                }
                return -1;
            }
            case 238: {
                switch (n) {
                    case 0: {
                        return 0;
                    }
                    case 1: {
                        return 10;
                    }
                }
                return -1;
            }
            case 237: {
                if ((n2 & 8) != 0) {
                    switch (n) {
                        case 0: {
                            return 10;
                        }
                        case 1: {
                            return 16;
                        }
                    }
                    return -1;
                }
                switch (n) {
                    case 0: {
                        return 10;
                    }
                    case 1: {
                        return 8;
                    }
                }
                return -1;
            }
            case 239: {
                if ((n2 & 8) != 0) {
                    switch (n) {
                        case 0: {
                            return 16;
                        }
                        case 1: {
                            return 10;
                        }
                    }
                    return -1;
                }
                switch (n) {
                    case 0: {
                        return 8;
                    }
                    case 1: {
                        return 10;
                    }
                }
                return -1;
            }
            case 4: 
            case 12: 
            case 20: 
            case 28: 
            case 36: 
            case 44: 
            case 52: 
            case 60: 
            case 168: 
            case 176: 
            case 228: {
                switch (n) {
                    case 0: {
                        return 41;
                    }
                    case 1: {
                        return 0;
                    }
                    case 2: {
                        return 0;
                    }
                }
                return -1;
            }
            case 177: {
                switch (n) {
                    case 0: {
                        return 41;
                    }
                    case 1: {
                        return 1;
                    }
                }
                return -1;
            }
            case 178: {
                switch (n) {
                    case 0: {
                        return 41;
                    }
                    case 1: {
                        return 2;
                    }
                }
                return -1;
            }
            case 179: {
                switch (n) {
                    case 0: {
                        return 41;
                    }
                    case 1: {
                        return 3;
                    }
                }
                return -1;
            }
            case 180: {
                switch (n) {
                    case 0: {
                        return 41;
                    }
                    case 1: {
                        return 4;
                    }
                }
                return -1;
            }
            case 181: {
                switch (n) {
                    case 0: {
                        return 41;
                    }
                    case 1: {
                        return 5;
                    }
                }
                return -1;
            }
            case 182: {
                switch (n) {
                    case 0: {
                        return 41;
                    }
                    case 1: {
                        return 6;
                    }
                }
                return -1;
            }
            case 183: {
                switch (n) {
                    case 0: {
                        return 41;
                    }
                    case 1: {
                        return 7;
                    }
                }
                return -1;
            }
            case 200: {
                return 46;
            }
            case 105: {
                if ((n2 & 8) != 0) {
                    switch (n) {
                        case 0: {
                            return RealModeDecoder.decodeEd(n2, n4, n5);
                        }
                        case 1: {
                            return 43;
                        }
                        case 2: {
                            return RealModeDecoder.decodeGd(n4);
                        }
                    }
                    return -1;
                }
                switch (n) {
                    case 0: {
                        return RealModeDecoder.decodeEw(n2, n4, n5);
                    }
                    case 1: {
                        return 42;
                    }
                    case 2: {
                        return RealModeDecoder.decodeGw(n4);
                    }
                }
                return -1;
            }
            case 107: {
                if ((n2 & 8) != 0) {
                    switch (n) {
                        case 0: {
                            return RealModeDecoder.decodeEd(n2, n4, n5);
                        }
                        case 1: {
                            return 41;
                        }
                        case 2: {
                            return RealModeDecoder.decodeGd(n4);
                        }
                    }
                    return -1;
                }
                switch (n) {
                    case 0: {
                        return RealModeDecoder.decodeEw(n2, n4, n5);
                    }
                    case 1: {
                        return 41;
                    }
                    case 2: {
                        return RealModeDecoder.decodeGw(n4);
                    }
                }
                return -1;
            }
            case 106: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 205: 
            case 212: 
            case 213: 
            case 224: 
            case 225: 
            case 226: 
            case 227: 
            case 235: {
                return 41;
            }
            case 230: {
                switch (n) {
                    case 0: {
                        return 0;
                    }
                    case 1: {
                        return 41;
                    }
                }
                return -1;
            }
            case 5: 
            case 13: 
            case 21: 
            case 29: 
            case 37: 
            case 45: 
            case 53: 
            case 61: 
            case 169: 
            case 184: {
                if ((n2 & 8) != 0) {
                    switch (n) {
                        case 0: {
                            return 43;
                        }
                        case 1: {
                            return 16;
                        }
                        case 2: {
                            return 16;
                        }
                    }
                    return -1;
                }
                switch (n) {
                    case 0: {
                        return 42;
                    }
                    case 1: {
                        return 8;
                    }
                    case 2: {
                        return 8;
                    }
                }
                return -1;
            }
            case 185: {
                if ((n2 & 8) != 0) {
                    switch (n) {
                        case 0: {
                            return 43;
                        }
                        case 1: {
                            return 17;
                        }
                    }
                    return -1;
                }
                switch (n) {
                    case 0: {
                        return 42;
                    }
                    case 1: {
                        return 9;
                    }
                }
                return -1;
            }
            case 186: {
                if ((n2 & 8) != 0) {
                    switch (n) {
                        case 0: {
                            return 43;
                        }
                        case 1: {
                            return 18;
                        }
                    }
                    return -1;
                }
                switch (n) {
                    case 0: {
                        return 42;
                    }
                    case 1: {
                        return 10;
                    }
                }
                return -1;
            }
            case 187: {
                if ((n2 & 8) != 0) {
                    switch (n) {
                        case 0: {
                            return 43;
                        }
                        case 1: {
                            return 19;
                        }
                    }
                    return -1;
                }
                switch (n) {
                    case 0: {
                        return 42;
                    }
                    case 1: {
                        return 11;
                    }
                }
                return -1;
            }
            case 188: {
                if ((n2 & 8) != 0) {
                    switch (n) {
                        case 0: {
                            return 43;
                        }
                        case 1: {
                            return 20;
                        }
                    }
                    return -1;
                }
                switch (n) {
                    case 0: {
                        return 42;
                    }
                    case 1: {
                        return 12;
                    }
                }
                return -1;
            }
            case 189: {
                if ((n2 & 8) != 0) {
                    switch (n) {
                        case 0: {
                            return 43;
                        }
                        case 1: {
                            return 21;
                        }
                    }
                    return -1;
                }
                switch (n) {
                    case 0: {
                        return 42;
                    }
                    case 1: {
                        return 13;
                    }
                }
                return -1;
            }
            case 190: {
                if ((n2 & 8) != 0) {
                    switch (n) {
                        case 0: {
                            return 43;
                        }
                        case 1: {
                            return 22;
                        }
                    }
                    return -1;
                }
                switch (n) {
                    case 0: {
                        return 42;
                    }
                    case 1: {
                        return 14;
                    }
                }
                return -1;
            }
            case 191: {
                if ((n2 & 8) != 0) {
                    switch (n) {
                        case 0: {
                            return 43;
                        }
                        case 1: {
                            return 23;
                        }
                    }
                    return -1;
                }
                switch (n) {
                    case 0: {
                        return 42;
                    }
                    case 1: {
                        return 15;
                    }
                }
                return -1;
            }
            case 229: {
                if ((n2 & 8) != 0) {
                    switch (n) {
                        case 0: {
                            return 41;
                        }
                        case 1: {
                            return 16;
                        }
                    }
                    return -1;
                }
                switch (n) {
                    case 0: {
                        return 41;
                    }
                    case 1: {
                        return 8;
                    }
                }
                return -1;
            }
            case 231: {
                if ((n2 & 8) != 0) {
                    switch (n) {
                        case 0: {
                            return 16;
                        }
                        case 1: {
                            return 41;
                        }
                    }
                    return -1;
                }
                switch (n) {
                    case 0: {
                        return 8;
                    }
                    case 1: {
                        return 41;
                    }
                }
                return -1;
            }
            case 64: 
            case 72: 
            case 80: 
            case 88: {
                if ((n2 & 8) != 0) {
                    return 16;
                }
                return 8;
            }
            case 65: 
            case 73: 
            case 81: 
            case 89: {
                if ((n2 & 8) != 0) {
                    return 17;
                }
                return 9;
            }
            case 66: 
            case 74: 
            case 82: 
            case 90: {
                if ((n2 & 8) != 0) {
                    return 18;
                }
                return 10;
            }
            case 67: 
            case 75: 
            case 83: 
            case 91: {
                if ((n2 & 8) != 0) {
                    return 19;
                }
                return 11;
            }
            case 68: 
            case 76: 
            case 84: 
            case 92: {
                if ((n2 & 8) != 0) {
                    return 20;
                }
                return 12;
            }
            case 69: 
            case 77: 
            case 85: 
            case 93: {
                if ((n2 & 8) != 0) {
                    return 21;
                }
                return 13;
            }
            case 70: 
            case 78: 
            case 86: 
            case 94: {
                if ((n2 & 8) != 0) {
                    return 22;
                }
                return 14;
            }
            case 71: 
            case 79: 
            case 87: 
            case 95: {
                if ((n2 & 8) != 0) {
                    return 23;
                }
                return 15;
            }
            case 145: {
                if ((n2 & 8) != 0) {
                    switch (n) {
                        case 0: {
                            return 17;
                        }
                        case 1: {
                            return 16;
                        }
                        case 2: {
                            return 17;
                        }
                        case 3: {
                            return 16;
                        }
                    }
                    return -1;
                }
                switch (n) {
                    case 0: {
                        return 9;
                    }
                    case 1: {
                        return 8;
                    }
                    case 2: {
                        return 9;
                    }
                    case 3: {
                        return 8;
                    }
                }
                return -1;
            }
            case 146: {
                if ((n2 & 8) != 0) {
                    switch (n) {
                        case 0: {
                            return 18;
                        }
                        case 1: {
                            return 16;
                        }
                        case 2: {
                            return 18;
                        }
                        case 3: {
                            return 16;
                        }
                    }
                    return -1;
                }
                switch (n) {
                    case 0: {
                        return 8;
                    }
                    case 1: {
                        return 10;
                    }
                    case 2: {
                        return 8;
                    }
                    case 3: {
                        return 10;
                    }
                }
                return -1;
            }
            case 147: {
                if ((n2 & 8) != 0) {
                    switch (n) {
                        case 0: {
                            return 19;
                        }
                        case 1: {
                            return 16;
                        }
                        case 2: {
                            return 19;
                        }
                        case 3: {
                            return 16;
                        }
                    }
                    return -1;
                }
                switch (n) {
                    case 0: {
                        return 11;
                    }
                    case 1: {
                        return 8;
                    }
                    case 2: {
                        return 11;
                    }
                    case 3: {
                        return 8;
                    }
                }
                return -1;
            }
            case 148: {
                if ((n2 & 8) != 0) {
                    switch (n) {
                        case 0: {
                            return 20;
                        }
                        case 1: {
                            return 16;
                        }
                        case 2: {
                            return 20;
                        }
                        case 3: {
                            return 16;
                        }
                    }
                    return -1;
                }
                switch (n) {
                    case 0: {
                        return 12;
                    }
                    case 1: {
                        return 8;
                    }
                    case 2: {
                        return 12;
                    }
                    case 3: {
                        return 8;
                    }
                }
                return -1;
            }
            case 149: {
                if ((n2 & 8) != 0) {
                    switch (n) {
                        case 0: {
                            return 21;
                        }
                        case 1: {
                            return 16;
                        }
                        case 2: {
                            return 21;
                        }
                        case 3: {
                            return 16;
                        }
                    }
                    return -1;
                }
                switch (n) {
                    case 0: {
                        return 13;
                    }
                    case 1: {
                        return 8;
                    }
                    case 2: {
                        return 13;
                    }
                    case 3: {
                        return 8;
                    }
                }
                return -1;
            }
            case 150: {
                if ((n2 & 8) != 0) {
                    switch (n) {
                        case 0: {
                            return 22;
                        }
                        case 1: {
                            return 16;
                        }
                        case 2: {
                            return 22;
                        }
                        case 3: {
                            return 16;
                        }
                    }
                    return -1;
                }
                switch (n) {
                    case 0: {
                        return 14;
                    }
                    case 1: {
                        return 8;
                    }
                    case 2: {
                        return 14;
                    }
                    case 3: {
                        return 8;
                    }
                }
                return -1;
            }
            case 151: {
                if ((n2 & 8) != 0) {
                    switch (n) {
                        case 0: {
                            return 23;
                        }
                        case 1: {
                            return 16;
                        }
                        case 2: {
                            return 23;
                        }
                        case 3: {
                            return 16;
                        }
                    }
                    return -1;
                }
                switch (n) {
                    case 0: {
                        return 15;
                    }
                    case 1: {
                        return 8;
                    }
                    case 2: {
                        return 15;
                    }
                    case 3: {
                        return 8;
                    }
                }
                return -1;
            }
            case 208: {
                switch (n) {
                    case 0: {
                        return 47;
                    }
                    case 1: {
                        return RealModeDecoder.decodeEb(n2, n4, n5);
                    }
                    case 2: {
                        return RealModeDecoder.decodeEb(n2, n4, n5);
                    }
                }
                return -1;
            }
            case 210: {
                switch (n) {
                    case 0: {
                        return 1;
                    }
                    case 1: {
                        return RealModeDecoder.decodeEb(n2, n4, n5);
                    }
                    case 2: {
                        return RealModeDecoder.decodeEb(n2, n4, n5);
                    }
                }
                return -1;
            }
            case 209: {
                if ((n2 & 8) != 0) {
                    switch (n) {
                        case 0: {
                            return 47;
                        }
                        case 1: {
                            return RealModeDecoder.decodeEd(n2, n4, n5);
                        }
                        case 2: {
                            return RealModeDecoder.decodeEd(n2, n4, n5);
                        }
                    }
                    return -1;
                }
                switch (n) {
                    case 0: {
                        return 47;
                    }
                    case 1: {
                        return RealModeDecoder.decodeEw(n2, n4, n5);
                    }
                    case 2: {
                        return RealModeDecoder.decodeEw(n2, n4, n5);
                    }
                }
                return -1;
            }
            case 211: {
                if ((n2 & 8) != 0) {
                    switch (n) {
                        case 0: {
                            return 1;
                        }
                        case 1: {
                            return RealModeDecoder.decodeEd(n2, n4, n5);
                        }
                        case 2: {
                            return RealModeDecoder.decodeEd(n2, n4, n5);
                        }
                    }
                    return -1;
                }
                switch (n) {
                    case 0: {
                        return 1;
                    }
                    case 1: {
                        return RealModeDecoder.decodeEw(n2, n4, n5);
                    }
                    case 2: {
                        return RealModeDecoder.decodeEw(n2, n4, n5);
                    }
                }
                return -1;
            }
            case 246: {
                switch (n4 & 0x38) {
                    case 0: {
                        switch (n) {
                            case 0: {
                                return 41;
                            }
                            case 1: {
                                return RealModeDecoder.decodeEb(n2, n4, n5);
                            }
                        }
                        return -1;
                    }
                }
                return RealModeDecoder.decodeEb(n2, n4, n5);
            }
            case 247: {
                if ((n2 & 8) != 0) {
                    switch (n4 & 0x38) {
                        case 0: {
                            switch (n) {
                                case 0: {
                                    return 43;
                                }
                                case 1: {
                                    return RealModeDecoder.decodeEd(n2, n4, n5);
                                }
                            }
                            return -1;
                        }
                    }
                    return RealModeDecoder.decodeEd(n2, n4, n5);
                }
                switch (n4 & 0x38) {
                    case 0: {
                        switch (n) {
                            case 0: {
                                return 42;
                            }
                            case 1: {
                                return RealModeDecoder.decodeEw(n2, n4, n5);
                            }
                        }
                        return -1;
                    }
                }
                return RealModeDecoder.decodeEw(n2, n4, n5);
            }
            case 254: {
                return RealModeDecoder.decodeEb(n2, n4, n5);
            }
            case 6: 
            case 7: {
                return 24;
            }
            case 14: {
                return 25;
            }
            case 22: 
            case 23: {
                return 26;
            }
            case 30: 
            case 31: {
                return 27;
            }
            case 98: {
                if ((n2 & 8) != 0) {
                    switch (n) {
                        case 0: {
                            return RealModeDecoder.decodeM(n2, n4, n5);
                        }
                        case 1: {
                            return RealModeDecoder.decodeGd(n4);
                        }
                    }
                    return -1;
                }
                switch (n) {
                    case 0: {
                        return RealModeDecoder.decodeM(n2, n4, n5);
                    }
                    case 1: {
                        return RealModeDecoder.decodeGw(n4);
                    }
                }
                return -1;
            }
            case 140: {
                switch (n) {
                    case 0: {
                        return RealModeDecoder.decodeSw(n4);
                    }
                    case 1: {
                        return RealModeDecoder.decodeEw(n2, n4, n5);
                    }
                }
                return -1;
            }
            case 142: {
                switch (n) {
                    case 0: {
                        return RealModeDecoder.decodeEw(n2, n4, n5);
                    }
                    case 1: {
                        return RealModeDecoder.decodeSw(n4);
                    }
                }
                return -1;
            }
            case 160: {
                switch (n) {
                    case 0: {
                        return RealModeDecoder.decodeOb(n2);
                    }
                    case 1: {
                        return 0;
                    }
                }
                return -1;
            }
            case 162: {
                switch (n) {
                    case 0: {
                        return 0;
                    }
                    case 1: {
                        return RealModeDecoder.decodeOb(n2);
                    }
                }
                return -1;
            }
            case 161: {
                if ((n2 & 8) != 0) {
                    switch (n) {
                        case 0: {
                            return RealModeDecoder.decodeOd(n2);
                        }
                        case 1: {
                            return 16;
                        }
                    }
                    return -1;
                }
                switch (n) {
                    case 0: {
                        return RealModeDecoder.decodeOw(n2);
                    }
                    case 1: {
                        return 8;
                    }
                }
                return -1;
            }
            case 163: {
                if ((n2 & 8) != 0) {
                    switch (n) {
                        case 0: {
                            return 16;
                        }
                        case 1: {
                            return RealModeDecoder.decodeOd(n2);
                        }
                    }
                    return -1;
                }
                switch (n) {
                    case 0: {
                        return 8;
                    }
                    case 1: {
                        return RealModeDecoder.decodeOw(n2);
                    }
                }
                return -1;
            }
            case 108: {
                switch (n) {
                    case 0: {
                        return 10;
                    }
                    case 1: {
                        return RealModeDecoder.decodeYb(n2);
                    }
                }
                return -1;
            }
            case 109: {
                if ((n2 & 8) != 0) {
                    switch (n) {
                        case 0: {
                            return 10;
                        }
                        case 1: {
                            return RealModeDecoder.decodeYd(n2);
                        }
                    }
                    return -1;
                }
                switch (n) {
                    case 0: {
                        return 10;
                    }
                    case 1: {
                        return RealModeDecoder.decodeYw(n2);
                    }
                }
                return -1;
            }
            case 110: {
                switch (n) {
                    case 0: {
                        return 10;
                    }
                    case 1: {
                        return RealModeDecoder.decodeXb(n2);
                    }
                }
                return -1;
            }
            case 111: {
                if ((n2 & 8) != 0) {
                    switch (n) {
                        case 0: {
                            return 10;
                        }
                        case 1: {
                            return RealModeDecoder.decodeXd(n2);
                        }
                    }
                    return -1;
                }
                switch (n) {
                    case 0: {
                        return 10;
                    }
                    case 1: {
                        return RealModeDecoder.decodeXw(n2);
                    }
                }
                return -1;
            }
            case 164: 
            case 166: {
                switch (n) {
                    case 0: {
                        return RealModeDecoder.decodeXb(n2);
                    }
                    case 1: {
                        return RealModeDecoder.decodeYb(n2);
                    }
                }
                return -1;
            }
            case 165: {
                if ((n2 & 8) != 0) {
                    switch (n) {
                        case 0: {
                            return RealModeDecoder.decodeXd(n2);
                        }
                        case 1: {
                            return RealModeDecoder.decodeYd(n2);
                        }
                    }
                    return -1;
                }
                switch (n) {
                    case 0: {
                        return RealModeDecoder.decodeXw(n2);
                    }
                    case 1: {
                        return RealModeDecoder.decodeYw(n2);
                    }
                }
                return -1;
            }
            case 167: {
                if ((n2 & 8) != 0) {
                    switch (n) {
                        case 0: {
                            return RealModeDecoder.decodeYd(n2);
                        }
                        case 1: {
                            return RealModeDecoder.decodeXd(n2);
                        }
                    }
                    return -1;
                }
                switch (n) {
                    case 0: {
                        return RealModeDecoder.decodeYw(n2);
                    }
                    case 1: {
                        return RealModeDecoder.decodeXw(n2);
                    }
                }
                return -1;
            }
            case 170: {
                switch (n) {
                    case 0: {
                        return 0;
                    }
                    case 1: {
                        return RealModeDecoder.decodeYb(n2);
                    }
                }
                return -1;
            }
            case 171: {
                if ((n2 & 8) != 0) {
                    switch (n) {
                        case 0: {
                            return 16;
                        }
                        case 1: {
                            return RealModeDecoder.decodeYd(n2);
                        }
                    }
                    return -1;
                }
                switch (n) {
                    case 0: {
                        return 8;
                    }
                    case 1: {
                        return RealModeDecoder.decodeYw(n2);
                    }
                }
                return -1;
            }
            case 172: {
                switch (n) {
                    case 0: {
                        return RealModeDecoder.decodeXb(n2);
                    }
                    case 1: {
                        return 0;
                    }
                }
                return -1;
            }
            case 173: {
                if ((n2 & 8) != 0) {
                    switch (n) {
                        case 0: {
                            return RealModeDecoder.decodeXd(n2);
                        }
                        case 1: {
                            return 16;
                        }
                    }
                    return -1;
                }
                switch (n) {
                    case 0: {
                        return RealModeDecoder.decodeXw(n2);
                    }
                    case 1: {
                        return 8;
                    }
                }
                return -1;
            }
            case 174: {
                switch (n) {
                    case 0: {
                        return 0;
                    }
                    case 1: {
                        return RealModeDecoder.decodeYb(n2);
                    }
                }
                return -1;
            }
            case 175: {
                if ((n2 & 8) != 0) {
                    switch (n) {
                        case 0: {
                            return 16;
                        }
                        case 1: {
                            return RealModeDecoder.decodeYd(n2);
                        }
                    }
                    return -1;
                }
                switch (n) {
                    case 0: {
                        return 8;
                    }
                    case 1: {
                        return RealModeDecoder.decodeYw(n2);
                    }
                }
                return -1;
            }
            case 255: {
                if ((n2 & 8) != 0) {
                    switch (n4 & 0x38) {
                        case 0: 
                        case 8: 
                        case 16: 
                        case 32: 
                        case 48: {
                            return RealModeDecoder.decodeEd(n2, n4, n5);
                        }
                        case 24: 
                        case 40: {
                            return RealModeDecoder.decodeM(n2, n4, n5);
                        }
                    }
                    break;
                }
                switch (n4 & 0x38) {
                    case 0: 
                    case 8: 
                    case 16: 
                    case 32: 
                    case 48: {
                        return RealModeDecoder.decodeEw(n2, n4, n5);
                    }
                    case 24: 
                    case 40: {
                        return RealModeDecoder.decodeM(n2, n4, n5);
                    }
                }
                break;
            }
            case 196: 
            case 197: {
                if ((n2 & 8) != 0) {
                    switch (n) {
                        case 0: {
                            return RealModeDecoder.decodeM(n2, n4, n5);
                        }
                        case 1: {
                            return RealModeDecoder.decodeGd(n4);
                        }
                    }
                    return -1;
                }
                switch (n) {
                    case 0: {
                        return RealModeDecoder.decodeM(n2, n4, n5);
                    }
                    case 1: {
                        return RealModeDecoder.decodeGw(n4);
                    }
                }
                return -1;
            }
            case 215: {
                switch (n) {
                    case 0: {
                        if ((n2 & 0x10) != 0) {
                            switch (n2 & 7) {
                                case 1: {
                                    return 332;
                                }
                                case 2: {
                                    return 333;
                                }
                                case 3: {
                                    return 334;
                                }
                                default: {
                                    return 335;
                                }
                                case 5: {
                                    return 336;
                                }
                                case 6: 
                            }
                            return 337;
                        }
                        switch (n2 & 7) {
                            case 1: {
                                return 326;
                            }
                            case 2: {
                                return 327;
                            }
                            case 3: {
                                return 328;
                            }
                            default: {
                                return 329;
                            }
                            case 5: {
                                return 330;
                            }
                            case 6: 
                        }
                        return 331;
                    }
                    case 1: {
                        return 0;
                    }
                }
                return -1;
            }
            default: {
                return -1;
            }
        }
        return -1;
    }

    private static int decodeTwoByteOperand(int n, int n2, int n3, int n4, int n5) {
        switch (n3 & 0xFF) {
            case 1: {
                switch (n4 & 0x38) {
                    case 0: 
                    case 8: 
                    case 16: 
                    case 24: {
                        return RealModeDecoder.decodeM(n2, n4, n5);
                    }
                    case 32: 
                    case 48: {
                        return RealModeDecoder.decodeEw(n2, n4, n5);
                    }
                    case 56: {
                        return RealModeDecoder.decodeEb(n2, n4, n5);
                    }
                }
                return -1;
            }
            case 32: {
                switch (n) {
                    case 0: {
                        return RealModeDecoder.decodeCd(n4);
                    }
                    case 1: {
                        return RealModeDecoder.decodeEd(n2, n4, n5);
                    }
                }
                return -1;
            }
            case 34: {
                switch (n) {
                    case 0: {
                        return RealModeDecoder.decodeEd(n2, n4, n5);
                    }
                    case 1: {
                        return RealModeDecoder.decodeCd(n4);
                    }
                }
                return -1;
            }
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: {
                if ((n2 & 8) != 0) {
                    switch (n) {
                        case 0: {
                            return RealModeDecoder.decodeEd(n2, n4, n5);
                        }
                        case 1: {
                            return RealModeDecoder.decodeGd(n4);
                        }
                        case 2: {
                            return RealModeDecoder.decodeGd(n4);
                        }
                    }
                    return -1;
                }
                switch (n) {
                    case 0: {
                        return RealModeDecoder.decodeEw(n2, n4, n5);
                    }
                    case 1: {
                        return RealModeDecoder.decodeGw(n4);
                    }
                    case 2: {
                        return RealModeDecoder.decodeGw(n4);
                    }
                }
                return -1;
            }
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: {
                if ((n2 & 8) != 0) {
                    return 43;
                }
                return 42;
            }
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: {
                return RealModeDecoder.decodeEb(n2, n4, n5);
            }
            case 160: 
            case 161: {
                return 28;
            }
            case 163: {
                if ((n2 & 8) != 0) {
                    switch (n) {
                        case 0: {
                            return RealModeDecoder.decodeGd(n4);
                        }
                        case 1: {
                            return RealModeDecoder.decodeEd(n2, n4, n5);
                        }
                        case 2: {
                            return RealModeDecoder.decodeEd(n2, n4, n5);
                        }
                    }
                    return -1;
                }
                switch (n) {
                    case 0: {
                        return RealModeDecoder.decodeGw(n4);
                    }
                    case 1: {
                        return RealModeDecoder.decodeEw(n2, n4, n5);
                    }
                    case 2: {
                        return RealModeDecoder.decodeEw(n2, n4, n5);
                    }
                }
                return -1;
            }
            case 164: {
                if ((n2 & 8) != 0) {
                    switch (n) {
                        case 0: {
                            return RealModeDecoder.decodeGd(n4);
                        }
                        case 1: {
                            return 41;
                        }
                        case 2: {
                            return RealModeDecoder.decodeEd(n2, n4, n5);
                        }
                        case 3: {
                            return RealModeDecoder.decodeEd(n2, n4, n5);
                        }
                    }
                    return -1;
                }
                switch (n) {
                    case 0: {
                        return RealModeDecoder.decodeGw(n4);
                    }
                    case 1: {
                        return 41;
                    }
                    case 2: {
                        return RealModeDecoder.decodeEw(n2, n4, n5);
                    }
                    case 3: {
                        return RealModeDecoder.decodeEw(n2, n4, n5);
                    }
                }
                return -1;
            }
            case 165: {
                if ((n2 & 8) != 0) {
                    switch (n) {
                        case 0: {
                            return RealModeDecoder.decodeGd(n4);
                        }
                        case 1: {
                            return 1;
                        }
                        case 2: {
                            return RealModeDecoder.decodeEd(n2, n4, n5);
                        }
                        case 3: {
                            return RealModeDecoder.decodeEd(n2, n4, n5);
                        }
                    }
                    return -1;
                }
                switch (n) {
                    case 0: {
                        return RealModeDecoder.decodeGw(n4);
                    }
                    case 1: {
                        return 1;
                    }
                    case 2: {
                        return RealModeDecoder.decodeEw(n2, n4, n5);
                    }
                    case 3: {
                        return RealModeDecoder.decodeEw(n2, n4, n5);
                    }
                }
                return -1;
            }
            case 168: 
            case 169: {
                return 29;
            }
            case 171: {
                if ((n2 & 8) != 0) {
                    switch (n) {
                        case 0: {
                            return RealModeDecoder.decodeGd(n4);
                        }
                        case 1: {
                            return RealModeDecoder.decodeEd(n2, n4, n5);
                        }
                        case 2: {
                            return RealModeDecoder.decodeEd(n2, n4, n5);
                        }
                    }
                    return -1;
                }
                switch (n) {
                    case 0: {
                        return RealModeDecoder.decodeGw(n4);
                    }
                    case 1: {
                        return RealModeDecoder.decodeEw(n2, n4, n5);
                    }
                    case 2: {
                        return RealModeDecoder.decodeEw(n2, n4, n5);
                    }
                }
                return -1;
            }
            case 172: {
                if ((n2 & 8) != 0) {
                    switch (n) {
                        case 0: {
                            return RealModeDecoder.decodeGd(n4);
                        }
                        case 1: {
                            return 41;
                        }
                        case 2: {
                            return RealModeDecoder.decodeEd(n2, n4, n5);
                        }
                        case 3: {
                            return RealModeDecoder.decodeEd(n2, n4, n5);
                        }
                    }
                    return -1;
                }
                switch (n) {
                    case 0: {
                        return RealModeDecoder.decodeGw(n4);
                    }
                    case 1: {
                        return 41;
                    }
                    case 2: {
                        return RealModeDecoder.decodeEw(n2, n4, n5);
                    }
                    case 3: {
                        return RealModeDecoder.decodeEw(n2, n4, n5);
                    }
                }
                return -1;
            }
            case 173: {
                if ((n2 & 8) != 0) {
                    switch (n) {
                        case 0: {
                            return RealModeDecoder.decodeGd(n4);
                        }
                        case 1: {
                            return 1;
                        }
                        case 2: {
                            return RealModeDecoder.decodeEd(n2, n4, n5);
                        }
                        case 3: {
                            return RealModeDecoder.decodeEd(n2, n4, n5);
                        }
                    }
                    return -1;
                }
                switch (n) {
                    case 0: {
                        return RealModeDecoder.decodeGw(n4);
                    }
                    case 1: {
                        return 1;
                    }
                    case 2: {
                        return RealModeDecoder.decodeEw(n2, n4, n5);
                    }
                    case 3: {
                        return RealModeDecoder.decodeEw(n2, n4, n5);
                    }
                }
                return -1;
            }
            case 175: {
                if ((n2 & 8) != 0) {
                    switch (n) {
                        case 0: {
                            return RealModeDecoder.decodeEd(n2, n4, n5);
                        }
                        case 1: {
                            return RealModeDecoder.decodeGd(n4);
                        }
                        case 2: {
                            return RealModeDecoder.decodeGd(n4);
                        }
                    }
                    return -1;
                }
                switch (n) {
                    case 0: {
                        return RealModeDecoder.decodeEw(n2, n4, n5);
                    }
                    case 1: {
                        return RealModeDecoder.decodeGw(n4);
                    }
                    case 2: {
                        return RealModeDecoder.decodeGw(n4);
                    }
                }
                return -1;
            }
            case 176: {
                switch (n) {
                    case 0: {
                        return RealModeDecoder.decodeEd(n2, n4, n5);
                    }
                    case 1: {
                        return RealModeDecoder.decodeGd(n4);
                    }
                    case 2: {
                        return RealModeDecoder.decodeEd(n2, n4, n5);
                    }
                }
                return -1;
            }
            case 177: {
                if ((n2 & 8) != 0) {
                    switch (n) {
                        case 0: {
                            return RealModeDecoder.decodeEd(n2, n4, n5);
                        }
                        case 1: {
                            return RealModeDecoder.decodeGd(n4);
                        }
                        case 2: {
                            return RealModeDecoder.decodeEd(n2, n4, n5);
                        }
                    }
                    return -1;
                }
                switch (n) {
                    case 0: {
                        return RealModeDecoder.decodeEw(n2, n4, n5);
                    }
                    case 1: {
                        return RealModeDecoder.decodeGw(n4);
                    }
                    case 2: {
                        return RealModeDecoder.decodeEw(n2, n4, n5);
                    }
                }
                return -1;
            }
            case 178: {
                if ((n2 & 8) != 0) {
                    switch (n) {
                        case 0: {
                            return RealModeDecoder.decodeM(n2, n4, n5);
                        }
                        case 1: {
                            return RealModeDecoder.decodeGd(n4);
                        }
                    }
                    return -1;
                }
                switch (n) {
                    case 0: {
                        return RealModeDecoder.decodeM(n2, n4, n5);
                    }
                    case 1: {
                        return RealModeDecoder.decodeGw(n4);
                    }
                }
                return -1;
            }
            case 179: {
                if ((n2 & 8) != 0) {
                    switch (n) {
                        case 0: {
                            return RealModeDecoder.decodeGd(n4);
                        }
                        case 1: {
                            return RealModeDecoder.decodeEd(n2, n4, n5);
                        }
                        case 2: {
                            return RealModeDecoder.decodeEd(n2, n4, n5);
                        }
                    }
                    return -1;
                }
                switch (n) {
                    case 0: {
                        return RealModeDecoder.decodeGw(n4);
                    }
                    case 1: {
                        return RealModeDecoder.decodeEw(n2, n4, n5);
                    }
                    case 2: {
                        return RealModeDecoder.decodeEw(n2, n4, n5);
                    }
                }
                return -1;
            }
            case 180: 
            case 181: {
                if ((n2 & 8) != 0) {
                    switch (n) {
                        case 0: {
                            return RealModeDecoder.decodeM(n2, n4, n5);
                        }
                        case 1: {
                            return RealModeDecoder.decodeGd(n4);
                        }
                    }
                    return -1;
                }
                switch (n) {
                    case 0: {
                        return RealModeDecoder.decodeM(n2, n4, n5);
                    }
                    case 1: {
                        return RealModeDecoder.decodeGw(n4);
                    }
                }
                return -1;
            }
            case 182: {
                if ((n2 & 8) != 0) {
                    switch (n) {
                        case 0: {
                            return RealModeDecoder.decodeEb(n2, n4, n5);
                        }
                        case 1: {
                            return RealModeDecoder.decodeGd(n4);
                        }
                    }
                    return -1;
                }
                switch (n) {
                    case 0: {
                        return RealModeDecoder.decodeEb(n2, n4, n5);
                    }
                    case 1: {
                        return RealModeDecoder.decodeGw(n4);
                    }
                }
                return -1;
            }
            case 183: {
                if ((n2 & 8) != 0) {
                    switch (n) {
                        case 0: {
                            return RealModeDecoder.decodeEw(n2, n4, n5);
                        }
                        case 1: {
                            return RealModeDecoder.decodeGd(n4);
                        }
                    }
                    return -1;
                }
                switch (n) {
                    case 0: {
                        return RealModeDecoder.decodeEw(n2, n4, n5);
                    }
                    case 1: {
                        return RealModeDecoder.decodeGw(n4);
                    }
                }
                return -1;
            }
            case 186: {
                if ((n2 & 8) != 0) {
                    switch (n) {
                        case 0: {
                            return 41;
                        }
                        case 1: {
                            return RealModeDecoder.decodeEd(n2, n4, n5);
                        }
                        case 2: {
                            return RealModeDecoder.decodeEd(n2, n4, n5);
                        }
                    }
                    return -1;
                }
                switch (n) {
                    case 0: {
                        return 41;
                    }
                    case 1: {
                        return RealModeDecoder.decodeEw(n2, n4, n5);
                    }
                    case 2: {
                        return RealModeDecoder.decodeEw(n2, n4, n5);
                    }
                }
                return -1;
            }
            case 187: {
                if ((n2 & 8) != 0) {
                    switch (n) {
                        case 0: {
                            return RealModeDecoder.decodeGd(n4);
                        }
                        case 1: {
                            return RealModeDecoder.decodeEd(n2, n4, n5);
                        }
                        case 2: {
                            return RealModeDecoder.decodeEd(n2, n4, n5);
                        }
                    }
                    return -1;
                }
                switch (n) {
                    case 0: {
                        return RealModeDecoder.decodeGw(n4);
                    }
                    case 1: {
                        return RealModeDecoder.decodeEw(n2, n4, n5);
                    }
                    case 2: {
                        return RealModeDecoder.decodeEw(n2, n4, n5);
                    }
                }
                return -1;
            }
            case 188: 
            case 189: {
                if ((n2 & 8) != 0) {
                    switch (n) {
                        case 0: {
                            return RealModeDecoder.decodeEd(n2, n4, n5);
                        }
                        case 1: {
                            return RealModeDecoder.decodeGd(n4);
                        }
                    }
                    return -1;
                }
                switch (n) {
                    case 0: {
                        return RealModeDecoder.decodeEw(n2, n4, n5);
                    }
                    case 1: {
                        return RealModeDecoder.decodeGw(n4);
                    }
                }
                return -1;
            }
            case 190: {
                if ((n2 & 8) != 0) {
                    switch (n) {
                        case 0: {
                            return RealModeDecoder.decodeEb(n2, n4, n5);
                        }
                        case 1: {
                            return RealModeDecoder.decodeGd(n4);
                        }
                    }
                    return -1;
                }
                switch (n) {
                    case 0: {
                        return RealModeDecoder.decodeEb(n2, n4, n5);
                    }
                    case 1: {
                        return RealModeDecoder.decodeGw(n4);
                    }
                }
                return -1;
            }
            case 191: {
                if ((n2 & 8) != 0) {
                    switch (n) {
                        case 0: {
                            return RealModeDecoder.decodeEw(n2, n4, n5);
                        }
                        case 1: {
                            return RealModeDecoder.decodeGd(n4);
                        }
                    }
                    return -1;
                }
                switch (n) {
                    case 0: {
                        return RealModeDecoder.decodeEw(n2, n4, n5);
                    }
                    case 1: {
                        return RealModeDecoder.decodeGw(n4);
                    }
                }
                return -1;
            }
        }
        return -1;
    }

    private static int decodeFPUOperand(int n, int n2, int n3, int n4, int n5) {
        if ((n4 & 0xC0) != 192) {
            switch (n3 & 0xFF38) {
                case 55296: 
                case 55304: 
                case 55312: 
                case 55320: 
                case 55328: 
                case 55336: 
                case 55344: 
                case 55352: 
                case 55552: 
                case 55568: 
                case 55576: 
                case 55584: 
                case 55592: 
                case 55600: 
                case 55608: 
                case 55808: 
                case 55816: 
                case 55824: 
                case 55832: 
                case 55840: 
                case 55848: 
                case 55856: 
                case 55864: 
                case 56064: 
                case 56072: 
                case 56080: 
                case 56088: 
                case 56104: 
                case 56120: 
                case 56320: 
                case 56328: 
                case 56336: 
                case 56344: 
                case 56352: 
                case 56360: 
                case 56368: 
                case 56376: 
                case 56576: 
                case 56584: 
                case 56592: 
                case 56600: 
                case 56632: 
                case 56832: 
                case 56840: 
                case 56848: 
                case 56856: 
                case 56864: 
                case 56872: 
                case 56880: 
                case 56888: 
                case 57088: 
                case 57096: 
                case 57104: 
                case 57112: 
                case 57120: 
                case 57128: 
                case 57136: 
                case 57144: {
                    return RealModeDecoder.decodeM(n2, n4, n5);
                }
                case 56608: {
                    return -1;
                }
                case 56624: {
                    return -1;
                }
            }
        } else {
            switch (n3 & 0xFFF8) {
                case 55488: 
                case 55496: 
                case 55520: 
                case 55528: 
                case 55536: 
                case 55544: {
                    switch (n) {
                        case 0: {
                            return RealModeDecoder.decodeST(n4);
                        }
                        case 1: {
                            return 48;
                        }
                        case 2: {
                            return 48;
                        }
                    }
                    return -1;
                }
                case 56512: 
                case 56520: 
                case 56544: 
                case 56552: 
                case 56560: 
                case 56568: 
                case 57024: 
                case 57032: 
                case 57056: 
                case 57064: 
                case 57072: 
                case 57080: {
                    switch (n) {
                        case 0: {
                            return 48;
                        }
                        case 1: {
                            return RealModeDecoder.decodeST(n4);
                        }
                        case 2: {
                            return RealModeDecoder.decodeST(n4);
                        }
                    }
                    return -1;
                }
                case 55504: 
                case 55512: 
                case 55744: 
                case 55752: 
                case 56000: 
                case 56008: 
                case 56016: 
                case 56024: 
                case 56256: 
                case 56264: 
                case 56272: 
                case 56280: 
                case 56296: 
                case 56304: 
                case 56768: 
                case 56784: 
                case 56792: 
                case 56800: 
                case 56808: 
                case 57320: 
                case 57328: {
                    return RealModeDecoder.decodeST(n4);
                }
            }
            switch (n3) {
                case 56041: 
                case 57049: {
                    return 49;
                }
                case 57312: {
                    return 8;
                }
            }
        }
        return -1;
    }

    public static int operandCount(int n) {
        switch (n) {
            default: {
                return -1;
            }
            case 15: 
            case 19: 
            case 23: 
            case 27: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 81: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 145: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 262: 
            case 448: 
            case 590: 
            case 591: 
            case 592: 
            case 593: 
            case 594: 
            case 595: 
            case 596: 
            case 597: 
            case 598: 
            case 599: 
            case 600: 
            case 601: 
            case 602: 
            case 603: 
            case 604: 
            case 605: 
            case 606: 
            case 607: 
            case 608: 
            case 609: 
            case 610: 
            case 611: 
            case 612: 
            case 613: 
            case 614: 
            case 615: 
            case 616: 
            case 617: 
            case 619: 
            case 620: {
                return 0;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 143: 
            case 144: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 172: 
            case 200: 
            case 201: 
            case 202: 
            case 203: 
            case 204: 
            case 205: 
            case 206: 
            case 207: 
            case 232: 
            case 233: 
            case 234: 
            case 237: 
            case 238: 
            case 239: 
            case 243: 
            case 244: 
            case 261: 
            case 317: 
            case 318: 
            case 319: 
            case 320: 
            case 321: 
            case 322: 
            case 323: 
            case 324: 
            case 325: 
            case 326: 
            case 327: 
            case 328: 
            case 329: 
            case 330: 
            case 331: 
            case 332: 
            case 333: 
            case 334: 
            case 335: 
            case 336: 
            case 337: 
            case 338: 
            case 339: 
            case 340: 
            case 341: 
            case 342: 
            case 343: 
            case 344: 
            case 345: 
            case 346: 
            case 347: 
            case 348: 
            case 349: 
            case 350: 
            case 351: 
            case 352: 
            case 374: 
            case 375: 
            case 376: 
            case 377: 
            case 378: 
            case 379: 
            case 380: 
            case 381: 
            case 382: 
            case 383: 
            case 384: 
            case 385: 
            case 386: 
            case 387: 
            case 388: 
            case 389: 
            case 432: 
            case 433: 
            case 434: 
            case 435: 
            case 436: 
            case 437: 
            case 438: 
            case 439: 
            case 440: 
            case 441: 
            case 442: 
            case 443: 
            case 444: 
            case 445: 
            case 446: 
            case 447: 
            case 497: 
            case 498: 
            case 499: 
            case 500: 
            case 501: 
            case 502: 
            case 503: 
            case 504: 
            case 505: 
            case 506: 
            case 507: 
            case 509: 
            case 511: 
            case 512: 
            case 513: 
            case 514: 
            case 515: 
            case 516: 
            case 517: 
            case 518: 
            case 519: 
            case 520: 
            case 521: 
            case 522: 
            case 523: 
            case 524: 
            case 525: 
            case 526: 
            case 527: 
            case 528: 
            case 529: 
            case 530: 
            case 531: 
            case 532: 
            case 533: 
            case 534: 
            case 535: 
            case 536: 
            case 537: 
            case 538: 
            case 539: 
            case 540: 
            case 541: 
            case 542: 
            case 543: 
            case 544: 
            case 545: 
            case 546: 
            case 547: 
            case 548: 
            case 549: 
            case 550: 
            case 551: 
            case 552: 
            case 553: 
            case 554: 
            case 555: 
            case 556: 
            case 559: 
            case 560: 
            case 565: 
            case 567: 
            case 568: 
            case 569: 
            case 570: 
            case 571: 
            case 572: 
            case 573: 
            case 574: 
            case 575: 
            case 576: 
            case 577: 
            case 578: 
            case 579: 
            case 580: 
            case 581: 
            case 588: 
            case 589: 
            case 618: 
            case 621: {
                return 1;
            }
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 70: 
            case 71: 
            case 72: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 171: 
            case 185: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 198: 
            case 199: 
            case 229: 
            case 230: 
            case 231: 
            case 235: 
            case 236: 
            case 240: 
            case 241: 
            case 245: 
            case 246: 
            case 247: 
            case 248: 
            case 249: 
            case 250: 
            case 251: 
            case 252: 
            case 253: 
            case 254: 
            case 255: 
            case 256: 
            case 257: 
            case 258: 
            case 259: 
            case 260: 
            case 263: 
            case 264: 
            case 265: 
            case 266: 
            case 267: 
            case 268: 
            case 269: 
            case 270: 
            case 271: 
            case 272: 
            case 273: 
            case 274: 
            case 275: 
            case 276: 
            case 277: 
            case 278: 
            case 279: 
            case 280: 
            case 281: 
            case 282: 
            case 283: 
            case 284: 
            case 285: 
            case 286: 
            case 287: 
            case 288: 
            case 289: 
            case 290: 
            case 291: 
            case 292: 
            case 293: 
            case 294: 
            case 295: 
            case 296: 
            case 297: 
            case 298: 
            case 299: 
            case 300: 
            case 301: 
            case 302: 
            case 303: 
            case 304: 
            case 305: 
            case 306: 
            case 307: 
            case 308: 
            case 309: 
            case 310: 
            case 311: 
            case 312: 
            case 313: 
            case 314: 
            case 315: 
            case 316: 
            case 353: 
            case 354: 
            case 355: 
            case 356: 
            case 357: 
            case 358: 
            case 359: 
            case 360: 
            case 361: 
            case 362: 
            case 363: 
            case 364: 
            case 365: 
            case 366: 
            case 367: 
            case 368: 
            case 369: 
            case 370: 
            case 371: 
            case 372: 
            case 373: 
            case 390: 
            case 391: 
            case 392: 
            case 393: 
            case 394: 
            case 395: 
            case 396: 
            case 397: 
            case 398: 
            case 399: 
            case 400: 
            case 401: 
            case 402: 
            case 403: 
            case 404: 
            case 405: 
            case 406: 
            case 407: 
            case 408: 
            case 409: 
            case 410: 
            case 411: 
            case 412: 
            case 413: 
            case 414: 
            case 415: 
            case 416: 
            case 417: 
            case 418: 
            case 419: 
            case 420: 
            case 421: 
            case 422: 
            case 423: 
            case 424: 
            case 425: 
            case 426: 
            case 427: 
            case 428: 
            case 429: 
            case 430: 
            case 431: 
            case 457: 
            case 458: 
            case 459: 
            case 460: 
            case 482: 
            case 483: 
            case 508: 
            case 510: 
            case 566: 
            case 622: 
            case 623: 
            case 624: 
            case 625: 
            case 626: 
            case 627: 
            case 628: 
            case 629: 
            case 634: 
            case 635: {
                return 2;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 52: 
            case 53: 
            case 208: 
            case 209: 
            case 210: 
            case 211: 
            case 212: 
            case 213: 
            case 214: 
            case 215: 
            case 216: 
            case 217: 
            case 218: 
            case 219: 
            case 220: 
            case 221: 
            case 222: 
            case 223: 
            case 224: 
            case 225: 
            case 226: 
            case 227: 
            case 228: 
            case 465: 
            case 466: 
            case 467: 
            case 468: 
            case 469: 
            case 470: 
            case 471: 
            case 472: 
            case 473: 
            case 474: 
            case 475: 
            case 476: 
            case 477: 
            case 478: 
            case 479: 
            case 480: 
            case 492: 
            case 493: 
            case 494: 
            case 557: 
            case 558: 
            case 561: 
            case 562: 
            case 563: 
            case 564: 
            case 582: 
            case 583: 
            case 584: 
            case 585: 
            case 586: 
            case 587: {
                return 3;
            }
            case 73: 
            case 82: 
            case 83: 
            case 461: 
            case 462: 
            case 463: 
            case 464: 
        }
        return 4;
    }

    public static int immediateCount(int n) {
        switch (RealModeDecoder.operandHasImmediate(n)) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return 1;
            }
            case 6: {
                return 2;
            }
        }
        switch (RealModeDecoder.operandHasDisplacement(n)) {
            default: {
                return 0;
            }
            case 1: 
            case 2: 
            case 4: {
                return 1;
            }
            case 6: 
        }
        return 2;
    }

    private static int operandHasImmediate(int n) {
        switch (n) {
            case 41: {
                return 1;
            }
            case 42: {
                return 2;
            }
            case 46: {
                return 3;
            }
            case 43: 
            case 44: {
                return 4;
            }
            case 45: {
                return 6;
            }
        }
        return 0;
    }

    private static int operandHasDisplacement(int n) {
        switch (n) {
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 168: 
            case 169: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 174: 
            case 190: 
            case 191: 
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 214: 
            case 215: 
            case 216: 
            case 217: 
            case 218: 
            case 219: 
            case 220: 
            case 221: 
            case 238: 
            case 239: 
            case 240: 
            case 241: 
            case 242: 
            case 243: 
            case 244: 
            case 245: 
            case 262: 
            case 263: 
            case 264: 
            case 265: 
            case 266: 
            case 267: 
            case 268: 
            case 269: 
            case 286: 
            case 287: 
            case 288: 
            case 289: 
            case 290: 
            case 291: 
            case 292: 
            case 293: 
            case 310: 
            case 311: 
            case 312: 
            case 313: 
            case 314: 
            case 315: 
            case 316: 
            case 317: 
            case 541: 
            case 542: 
            case 543: 
            case 544: 
            case 545: 
            case 546: 
            case 547: 
            case 548: 
            case 549: 
            case 550: 
            case 551: 
            case 552: 
            case 553: 
            case 554: 
            case 555: 
            case 556: 
            case 557: 
            case 558: 
            case 559: 
            case 560: 
            case 561: 
            case 562: 
            case 563: 
            case 564: 
            case 565: 
            case 566: 
            case 567: 
            case 568: 
            case 569: 
            case 570: 
            case 571: 
            case 572: 
            case 573: 
            case 574: 
            case 575: 
            case 576: 
            case 577: 
            case 578: 
            case 579: 
            case 580: 
            case 581: 
            case 582: 
            case 583: 
            case 584: 
            case 585: 
            case 586: 
            case 587: 
            case 588: 
            case 589: 
            case 590: 
            case 591: 
            case 592: 
            case 593: 
            case 594: 
            case 595: 
            case 596: 
            case 597: 
            case 598: 
            case 599: 
            case 600: 
            case 601: 
            case 602: 
            case 603: 
            case 604: 
            case 605: 
            case 606: 
            case 607: 
            case 608: 
            case 609: 
            case 610: 
            case 611: 
            case 612: 
            case 613: 
            case 614: 
            case 615: 
            case 616: 
            case 617: 
            case 618: 
            case 619: 
            case 620: 
            case 621: 
            case 622: 
            case 623: 
            case 624: 
            case 625: 
            case 626: 
            case 627: 
            case 628: 
            case 629: 
            case 630: 
            case 631: 
            case 632: 
            case 633: 
            case 634: 
            case 635: 
            case 636: 
            case 637: 
            case 638: 
            case 639: 
            case 640: 
            case 641: 
            case 642: 
            case 643: 
            case 644: 
            case 645: 
            case 646: 
            case 647: 
            case 648: 
            case 649: 
            case 650: 
            case 651: 
            case 652: 
            case 653: 
            case 654: 
            case 655: 
            case 656: 
            case 657: 
            case 658: 
            case 659: 
            case 660: 
            case 661: 
            case 662: 
            case 663: 
            case 664: 
            case 665: 
            case 666: 
            case 667: 
            case 668: 
            case 669: 
            case 670: 
            case 671: 
            case 672: 
            case 673: 
            case 674: 
            case 675: 
            case 676: 
            case 677: 
            case 678: 
            case 679: 
            case 680: 
            case 681: 
            case 682: 
            case 683: 
            case 684: 
            case 685: 
            case 686: 
            case 687: 
            case 688: 
            case 689: 
            case 690: 
            case 691: 
            case 692: 
            case 693: 
            case 694: 
            case 695: 
            case 696: 
            case 697: 
            case 698: 
            case 699: 
            case 700: 
            case 701: 
            case 702: 
            case 703: 
            case 704: 
            case 705: 
            case 706: 
            case 707: 
            case 708: 
            case 709: 
            case 710: 
            case 711: 
            case 712: 
            case 713: 
            case 714: 
            case 715: 
            case 716: 
            case 717: 
            case 718: 
            case 719: 
            case 720: 
            case 721: 
            case 722: 
            case 723: 
            case 724: 
            case 725: 
            case 726: 
            case 727: 
            case 728: 
            case 729: 
            case 730: 
            case 731: 
            case 732: 
            case 733: 
            case 734: 
            case 735: 
            case 736: 
            case 737: 
            case 738: 
            case 739: 
            case 740: 
            case 741: 
            case 742: 
            case 743: 
            case 744: 
            case 1145: 
            case 1146: 
            case 1147: 
            case 1148: 
            case 1149: 
            case 1150: 
            case 1151: 
            case 1152: 
            case 1153: 
            case 1154: 
            case 1155: 
            case 1156: 
            case 1157: 
            case 1158: 
            case 1159: 
            case 1160: 
            case 1161: 
            case 1162: 
            case 1163: 
            case 1164: 
            case 1165: 
            case 1166: 
            case 1167: 
            case 1168: 
            case 1169: 
            case 1170: 
            case 1171: 
            case 1172: 
            case 1173: 
            case 1174: 
            case 1175: 
            case 1176: 
            case 1177: 
            case 1178: 
            case 1179: 
            case 1180: 
            case 1181: 
            case 1182: 
            case 1183: 
            case 1184: 
            case 1185: 
            case 1186: 
            case 1187: 
            case 1188: 
            case 1189: 
            case 1190: 
            case 1191: 
            case 1192: 
            case 1193: 
            case 1194: 
            case 1195: 
            case 1196: 
            case 1197: 
            case 1198: 
            case 1199: 
            case 1200: 
            case 1201: 
            case 1202: 
            case 1203: 
            case 1204: 
            case 1205: 
            case 1206: 
            case 1207: 
            case 1208: 
            case 1209: 
            case 1210: 
            case 1211: 
            case 1212: 
            case 1213: 
            case 1214: 
            case 1215: 
            case 1216: 
            case 1217: 
            case 1218: 
            case 1219: 
            case 1220: 
            case 1221: 
            case 1222: 
            case 1223: 
            case 1224: 
            case 1225: 
            case 1226: 
            case 1227: 
            case 1228: 
            case 1229: 
            case 1230: 
            case 1231: 
            case 1232: 
            case 1233: 
            case 1234: 
            case 1235: 
            case 1236: 
            case 1237: 
            case 1238: 
            case 1239: 
            case 1240: 
            case 1241: 
            case 1242: 
            case 1243: 
            case 1244: 
            case 1245: 
            case 1246: 
            case 1247: 
            case 1248: 
            case 1249: 
            case 1250: 
            case 1251: 
            case 1252: 
            case 1253: 
            case 1254: 
            case 1255: 
            case 1256: 
            case 1257: 
            case 1258: 
            case 1259: 
            case 1260: 
            case 1261: 
            case 1262: 
            case 1263: 
            case 1264: 
            case 1265: 
            case 1266: 
            case 1267: 
            case 1268: 
            case 1269: 
            case 1270: 
            case 1271: 
            case 1272: 
            case 1273: 
            case 1274: 
            case 1275: 
            case 1276: 
            case 1277: 
            case 1278: 
            case 1279: 
            case 1280: 
            case 1281: 
            case 1282: 
            case 1283: 
            case 1284: 
            case 1285: 
            case 1286: 
            case 1287: 
            case 1288: 
            case 1289: 
            case 1290: 
            case 1291: 
            case 1292: 
            case 1293: 
            case 1294: 
            case 1295: 
            case 1296: 
            case 1297: 
            case 1298: 
            case 1299: 
            case 1300: 
            case 1301: 
            case 1302: 
            case 1303: 
            case 1304: 
            case 1305: 
            case 1306: 
            case 1307: 
            case 1308: 
            case 1309: 
            case 1310: 
            case 1311: 
            case 1312: 
            case 1313: 
            case 1314: 
            case 1315: 
            case 1316: 
            case 1317: 
            case 1318: 
            case 1319: 
            case 1320: 
            case 1321: 
            case 1322: 
            case 1323: 
            case 1324: 
            case 1325: 
            case 1326: 
            case 1327: 
            case 1328: 
            case 1329: 
            case 1330: 
            case 1331: 
            case 1332: 
            case 1333: 
            case 1334: 
            case 1335: 
            case 1336: 
            case 1337: 
            case 1338: 
            case 1339: 
            case 1340: 
            case 1341: 
            case 1342: 
            case 1343: 
            case 1344: 
            case 1345: 
            case 1346: 
            case 1347: 
            case 1348: 
            case 1749: 
            case 1750: 
            case 1751: 
            case 1752: 
            case 1753: 
            case 1754: 
            case 1755: 
            case 1756: 
            case 1757: 
            case 1758: 
            case 1759: 
            case 1760: 
            case 1761: 
            case 1762: 
            case 1763: 
            case 1764: 
            case 1765: 
            case 1766: 
            case 1767: 
            case 1768: 
            case 1769: 
            case 1770: 
            case 1771: 
            case 1772: 
            case 1773: 
            case 1774: 
            case 1775: 
            case 1776: 
            case 1777: 
            case 1778: 
            case 1779: 
            case 1780: 
            case 1781: 
            case 1782: 
            case 1783: 
            case 1784: 
            case 1785: 
            case 1786: 
            case 1787: 
            case 1788: 
            case 1789: 
            case 1790: 
            case 1791: 
            case 1792: 
            case 1793: 
            case 1794: 
            case 1795: 
            case 1796: 
            case 1797: 
            case 1798: 
            case 1799: 
            case 1800: 
            case 1801: 
            case 1802: 
            case 1803: 
            case 1804: 
            case 1805: 
            case 1806: 
            case 1807: 
            case 1808: 
            case 1809: 
            case 1810: 
            case 1811: 
            case 1812: 
            case 1813: 
            case 1814: 
            case 1815: 
            case 1816: 
            case 1817: 
            case 1818: 
            case 1819: 
            case 1820: 
            case 1821: 
            case 1822: 
            case 1823: 
            case 1824: 
            case 1825: 
            case 1826: 
            case 1827: 
            case 1828: 
            case 1829: 
            case 1830: 
            case 1831: 
            case 1832: 
            case 1833: 
            case 1834: 
            case 1835: 
            case 1836: 
            case 1837: 
            case 1838: 
            case 1839: 
            case 1840: 
            case 1841: 
            case 1842: 
            case 1843: 
            case 1844: 
            case 1845: 
            case 1846: 
            case 1847: 
            case 1848: 
            case 1849: 
            case 1850: 
            case 1851: 
            case 1852: 
            case 1853: 
            case 1854: 
            case 1855: 
            case 1856: 
            case 1857: 
            case 1858: 
            case 1859: 
            case 1860: 
            case 1861: 
            case 1862: 
            case 1863: 
            case 1864: 
            case 1865: 
            case 1866: 
            case 1867: 
            case 1868: 
            case 1869: 
            case 1870: 
            case 1871: 
            case 1872: 
            case 1873: 
            case 1874: 
            case 1875: 
            case 1876: 
            case 1877: 
            case 1878: 
            case 1879: 
            case 1880: 
            case 1881: 
            case 1882: 
            case 1883: 
            case 1884: 
            case 1885: 
            case 1886: 
            case 1887: 
            case 1888: 
            case 1889: 
            case 1890: 
            case 1891: 
            case 1892: 
            case 1893: 
            case 1894: 
            case 1895: 
            case 1896: 
            case 1897: 
            case 1898: 
            case 1899: 
            case 1900: 
            case 1901: 
            case 1902: 
            case 1903: 
            case 1904: 
            case 1905: 
            case 1906: 
            case 1907: 
            case 1908: 
            case 1909: 
            case 1910: 
            case 1911: 
            case 1912: 
            case 1913: 
            case 1914: 
            case 1915: 
            case 1916: 
            case 1917: 
            case 1918: 
            case 1919: 
            case 1920: 
            case 1921: 
            case 1922: 
            case 1923: 
            case 1924: 
            case 1925: 
            case 1926: 
            case 1927: 
            case 1928: 
            case 1929: 
            case 1930: 
            case 1931: 
            case 1932: 
            case 1933: 
            case 1934: 
            case 1935: 
            case 1936: 
            case 1937: 
            case 1938: 
            case 1939: 
            case 1940: 
            case 1941: 
            case 1942: 
            case 1943: 
            case 1944: 
            case 1945: 
            case 1946: 
            case 1947: 
            case 1948: 
            case 1949: 
            case 1950: 
            case 1951: 
            case 1952: 
            case 2353: 
            case 2354: 
            case 2355: 
            case 2356: 
            case 2357: 
            case 2358: 
            case 2359: 
            case 2360: 
            case 2361: 
            case 2362: 
            case 2363: 
            case 2364: 
            case 2365: 
            case 2366: 
            case 2367: 
            case 2368: 
            case 2369: 
            case 2370: 
            case 2371: 
            case 2372: 
            case 2373: 
            case 2374: 
            case 2375: 
            case 2376: 
            case 2377: 
            case 2378: 
            case 2379: 
            case 2380: 
            case 2381: 
            case 2382: 
            case 2383: 
            case 2384: 
            case 2385: 
            case 2386: 
            case 2387: 
            case 2388: 
            case 2389: 
            case 2390: 
            case 2391: 
            case 2392: 
            case 2393: 
            case 2394: 
            case 2395: 
            case 2396: 
            case 2397: 
            case 2398: 
            case 2399: 
            case 2400: 
            case 2401: 
            case 2402: 
            case 2403: 
            case 2404: 
            case 2405: 
            case 2406: 
            case 2407: 
            case 2408: 
            case 2409: 
            case 2410: 
            case 2411: 
            case 2412: 
            case 2413: 
            case 2414: 
            case 2415: 
            case 2416: 
            case 2417: 
            case 2418: 
            case 2419: 
            case 2420: 
            case 2421: 
            case 2422: 
            case 2423: 
            case 2424: 
            case 2425: 
            case 2426: 
            case 2427: 
            case 2428: 
            case 2429: 
            case 2430: 
            case 2431: 
            case 2432: 
            case 2433: 
            case 2434: 
            case 2435: 
            case 2436: 
            case 2437: 
            case 2438: 
            case 2439: 
            case 2440: 
            case 2441: 
            case 2442: 
            case 2443: 
            case 2444: 
            case 2445: 
            case 2446: 
            case 2447: 
            case 2448: 
            case 2449: 
            case 2450: 
            case 2451: 
            case 2452: 
            case 2453: 
            case 2454: 
            case 2455: 
            case 2456: 
            case 2457: 
            case 2458: 
            case 2459: 
            case 2460: 
            case 2461: 
            case 2462: 
            case 2463: 
            case 2464: 
            case 2465: 
            case 2466: 
            case 2467: 
            case 2468: 
            case 2469: 
            case 2470: 
            case 2471: 
            case 2472: 
            case 2473: 
            case 2474: 
            case 2475: 
            case 2476: 
            case 2477: 
            case 2478: 
            case 2479: 
            case 2480: 
            case 2481: 
            case 2482: 
            case 2483: 
            case 2484: 
            case 2485: 
            case 2486: 
            case 2487: 
            case 2488: 
            case 2489: 
            case 2490: 
            case 2491: 
            case 2492: 
            case 2493: 
            case 2494: 
            case 2495: 
            case 2496: 
            case 2497: 
            case 2498: 
            case 2499: 
            case 2500: 
            case 2501: 
            case 2502: 
            case 2503: 
            case 2504: 
            case 2505: 
            case 2506: 
            case 2507: 
            case 2508: 
            case 2509: 
            case 2510: 
            case 2511: 
            case 2512: 
            case 2513: 
            case 2514: 
            case 2515: 
            case 2516: 
            case 2517: 
            case 2518: 
            case 2519: 
            case 2520: 
            case 2521: 
            case 2522: 
            case 2523: 
            case 2524: 
            case 2525: 
            case 2526: 
            case 2527: 
            case 2528: 
            case 2529: 
            case 2530: 
            case 2531: 
            case 2532: 
            case 2533: 
            case 2534: 
            case 2535: 
            case 2536: 
            case 2537: 
            case 2538: 
            case 2539: 
            case 2540: 
            case 2541: 
            case 2542: 
            case 2543: 
            case 2544: 
            case 2545: 
            case 2546: 
            case 2547: 
            case 2548: 
            case 2549: 
            case 2550: 
            case 2551: 
            case 2552: 
            case 2553: 
            case 2554: 
            case 2555: 
            case 2556: 
            case 2957: 
            case 2958: 
            case 2959: 
            case 2960: 
            case 2961: 
            case 2962: 
            case 2963: 
            case 2964: 
            case 2965: 
            case 2966: 
            case 2967: 
            case 2968: 
            case 2969: 
            case 2970: 
            case 2971: 
            case 2972: 
            case 2973: 
            case 2974: 
            case 2975: 
            case 2976: 
            case 2977: 
            case 2978: 
            case 2979: 
            case 2980: 
            case 2981: 
            case 2982: 
            case 2983: 
            case 2984: 
            case 2985: 
            case 2986: 
            case 2987: 
            case 2988: 
            case 2989: 
            case 2990: 
            case 2991: 
            case 2992: 
            case 2993: 
            case 2994: 
            case 2995: 
            case 2996: 
            case 2997: 
            case 2998: 
            case 2999: 
            case 3000: 
            case 3001: 
            case 3002: 
            case 3003: 
            case 3004: 
            case 3005: 
            case 3006: 
            case 3007: 
            case 3008: 
            case 3009: 
            case 3010: 
            case 3011: 
            case 3012: 
            case 3013: 
            case 3014: 
            case 3015: 
            case 3016: 
            case 3017: 
            case 3018: 
            case 3019: 
            case 3020: 
            case 3021: 
            case 3022: 
            case 3023: 
            case 3024: 
            case 3025: 
            case 3026: 
            case 3027: 
            case 3028: 
            case 3029: 
            case 3030: 
            case 3031: 
            case 3032: 
            case 3033: 
            case 3034: 
            case 3035: 
            case 3036: 
            case 3037: 
            case 3038: 
            case 3039: 
            case 3040: 
            case 3041: 
            case 3042: 
            case 3043: 
            case 3044: 
            case 3045: 
            case 3046: 
            case 3047: 
            case 3048: 
            case 3049: 
            case 3050: 
            case 3051: 
            case 3052: 
            case 3053: 
            case 3054: 
            case 3055: 
            case 3056: 
            case 3057: 
            case 3058: 
            case 3059: 
            case 3060: 
            case 3061: 
            case 3062: 
            case 3063: 
            case 3064: 
            case 3065: 
            case 3066: 
            case 3067: 
            case 3068: 
            case 3069: 
            case 3070: 
            case 3071: 
            case 3072: 
            case 3073: 
            case 3074: 
            case 3075: 
            case 3076: 
            case 3077: 
            case 3078: 
            case 3079: 
            case 3080: 
            case 3081: 
            case 3082: 
            case 3083: 
            case 3084: 
            case 3085: 
            case 3086: 
            case 3087: 
            case 3088: 
            case 3089: 
            case 3090: 
            case 3091: 
            case 3092: 
            case 3093: 
            case 3094: 
            case 3095: 
            case 3096: 
            case 3097: 
            case 3098: 
            case 3099: 
            case 3100: 
            case 3101: 
            case 3102: 
            case 3103: 
            case 3104: 
            case 3105: 
            case 3106: 
            case 3107: 
            case 3108: 
            case 3109: 
            case 3110: 
            case 3111: 
            case 3112: 
            case 3113: 
            case 3114: 
            case 3115: 
            case 3116: 
            case 3117: 
            case 3118: 
            case 3119: 
            case 3120: 
            case 3121: 
            case 3122: 
            case 3123: 
            case 3124: 
            case 3125: 
            case 3126: 
            case 3127: 
            case 3128: 
            case 3129: 
            case 3130: 
            case 3131: 
            case 3132: 
            case 3133: 
            case 3134: 
            case 3135: 
            case 3136: 
            case 3137: 
            case 3138: 
            case 3139: 
            case 3140: 
            case 3141: 
            case 3142: 
            case 3143: 
            case 3144: 
            case 3145: 
            case 3146: 
            case 3147: 
            case 3148: 
            case 3149: 
            case 3150: 
            case 3151: 
            case 3152: 
            case 3153: 
            case 3154: 
            case 3155: 
            case 3156: 
            case 3157: 
            case 3158: 
            case 3159: 
            case 3160: 
            case 3561: 
            case 3562: 
            case 3563: 
            case 3564: 
            case 3565: 
            case 3566: 
            case 3567: 
            case 3568: 
            case 3569: 
            case 3570: 
            case 3571: 
            case 3572: 
            case 3573: 
            case 3574: 
            case 3575: 
            case 3576: 
            case 3577: 
            case 3578: 
            case 3579: 
            case 3580: 
            case 3581: 
            case 3582: 
            case 3583: 
            case 3584: 
            case 3585: 
            case 3586: 
            case 3587: 
            case 3588: 
            case 3589: 
            case 3590: 
            case 3591: 
            case 3592: 
            case 3593: 
            case 3594: 
            case 3595: 
            case 3596: 
            case 3597: 
            case 3598: 
            case 3599: 
            case 3600: 
            case 3601: 
            case 3602: 
            case 3603: 
            case 3604: 
            case 3605: 
            case 3606: 
            case 3607: 
            case 3608: 
            case 3609: 
            case 3610: 
            case 3611: 
            case 3612: 
            case 3613: 
            case 3614: 
            case 3615: 
            case 3616: 
            case 3617: 
            case 3618: 
            case 3619: 
            case 3620: 
            case 3621: 
            case 3622: 
            case 3623: 
            case 3624: 
            case 3625: 
            case 3626: 
            case 3627: 
            case 3628: 
            case 3629: 
            case 3630: 
            case 3631: 
            case 3632: 
            case 3633: 
            case 3634: 
            case 3635: 
            case 3636: 
            case 3637: 
            case 3638: 
            case 3639: 
            case 3640: 
            case 3641: 
            case 3642: 
            case 3643: 
            case 3644: 
            case 3645: 
            case 3646: 
            case 3647: 
            case 3648: 
            case 3649: 
            case 3650: 
            case 3651: 
            case 3652: 
            case 3653: 
            case 3654: 
            case 3655: 
            case 3656: 
            case 3657: 
            case 3658: 
            case 3659: 
            case 3660: 
            case 3661: 
            case 3662: 
            case 3663: 
            case 3664: 
            case 3665: 
            case 3666: 
            case 3667: 
            case 3668: 
            case 3669: 
            case 3670: 
            case 3671: 
            case 3672: 
            case 3673: 
            case 3674: 
            case 3675: 
            case 3676: 
            case 3677: 
            case 3678: 
            case 3679: 
            case 3680: 
            case 3681: 
            case 3682: 
            case 3683: 
            case 3684: 
            case 3685: 
            case 3686: 
            case 3687: 
            case 3688: 
            case 3689: 
            case 3690: 
            case 3691: 
            case 3692: 
            case 3693: 
            case 3694: 
            case 3695: 
            case 3696: 
            case 3697: 
            case 3698: 
            case 3699: 
            case 3700: 
            case 3701: 
            case 3702: 
            case 3703: 
            case 3704: 
            case 3705: 
            case 3706: 
            case 3707: 
            case 3708: 
            case 3709: 
            case 3710: 
            case 3711: 
            case 3712: 
            case 3713: 
            case 3714: 
            case 3715: 
            case 3716: 
            case 3717: 
            case 3718: 
            case 3719: 
            case 3720: 
            case 3721: 
            case 3722: 
            case 3723: 
            case 3724: 
            case 3725: 
            case 3726: 
            case 3727: 
            case 3728: 
            case 3729: 
            case 3730: 
            case 3731: 
            case 3732: 
            case 3733: 
            case 3734: 
            case 3735: 
            case 3736: 
            case 3737: 
            case 3738: 
            case 3739: 
            case 3740: 
            case 3741: 
            case 3742: 
            case 3743: 
            case 3744: 
            case 3745: 
            case 3746: 
            case 3747: 
            case 3748: 
            case 3749: 
            case 3750: 
            case 3751: 
            case 3752: 
            case 3753: 
            case 3754: 
            case 3755: 
            case 3756: 
            case 3757: 
            case 3758: 
            case 3759: 
            case 3760: 
            case 3761: 
            case 3762: 
            case 3763: 
            case 3764: {
                return 1;
            }
            case 188: 
            case 198: 
            case 199: 
            case 200: 
            case 201: 
            case 202: 
            case 203: 
            case 204: 
            case 205: 
            case 212: 
            case 222: 
            case 223: 
            case 224: 
            case 225: 
            case 226: 
            case 227: 
            case 228: 
            case 229: 
            case 236: 
            case 246: 
            case 247: 
            case 248: 
            case 249: 
            case 250: 
            case 251: 
            case 252: 
            case 253: 
            case 260: 
            case 270: 
            case 271: 
            case 272: 
            case 273: 
            case 274: 
            case 275: 
            case 276: 
            case 277: 
            case 284: 
            case 294: 
            case 295: 
            case 296: 
            case 297: 
            case 298: 
            case 299: 
            case 300: 
            case 301: 
            case 308: 
            case 318: 
            case 319: 
            case 320: 
            case 321: 
            case 322: 
            case 323: 
            case 324: 
            case 325: {
                return 2;
            }
            case 60: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 81: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 102: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 123: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 144: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 165: 
            case 175: 
            case 176: 
            case 177: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 378: 
            case 386: 
            case 394: 
            case 402: 
            case 410: 
            case 418: 
            case 426: 
            case 434: 
            case 442: 
            case 450: 
            case 458: 
            case 466: 
            case 474: 
            case 482: 
            case 490: 
            case 498: 
            case 506: 
            case 514: 
            case 522: 
            case 530: 
            case 538: 
            case 745: 
            case 746: 
            case 747: 
            case 748: 
            case 749: 
            case 750: 
            case 751: 
            case 752: 
            case 753: 
            case 754: 
            case 755: 
            case 756: 
            case 757: 
            case 758: 
            case 759: 
            case 760: 
            case 761: 
            case 762: 
            case 763: 
            case 764: 
            case 765: 
            case 766: 
            case 767: 
            case 768: 
            case 769: 
            case 770: 
            case 771: 
            case 772: 
            case 773: 
            case 774: 
            case 775: 
            case 776: 
            case 777: 
            case 778: 
            case 779: 
            case 780: 
            case 781: 
            case 782: 
            case 783: 
            case 784: 
            case 785: 
            case 786: 
            case 787: 
            case 788: 
            case 789: 
            case 790: 
            case 791: 
            case 792: 
            case 793: 
            case 794: 
            case 795: 
            case 796: 
            case 797: 
            case 798: 
            case 799: 
            case 800: 
            case 801: 
            case 802: 
            case 803: 
            case 804: 
            case 805: 
            case 806: 
            case 807: 
            case 808: 
            case 809: 
            case 810: 
            case 811: 
            case 812: 
            case 813: 
            case 814: 
            case 815: 
            case 816: 
            case 817: 
            case 818: 
            case 819: 
            case 820: 
            case 821: 
            case 822: 
            case 823: 
            case 824: 
            case 825: 
            case 826: 
            case 827: 
            case 828: 
            case 829: 
            case 830: 
            case 831: 
            case 832: 
            case 833: 
            case 834: 
            case 835: 
            case 836: 
            case 837: 
            case 838: 
            case 839: 
            case 840: 
            case 841: 
            case 842: 
            case 843: 
            case 844: 
            case 845: 
            case 846: 
            case 847: 
            case 848: 
            case 849: 
            case 850: 
            case 851: 
            case 852: 
            case 853: 
            case 854: 
            case 855: 
            case 856: 
            case 857: 
            case 858: 
            case 859: 
            case 860: 
            case 861: 
            case 862: 
            case 863: 
            case 864: 
            case 865: 
            case 866: 
            case 867: 
            case 868: 
            case 869: 
            case 870: 
            case 871: 
            case 872: 
            case 873: 
            case 874: 
            case 875: 
            case 876: 
            case 877: 
            case 878: 
            case 879: 
            case 880: 
            case 881: 
            case 882: 
            case 883: 
            case 884: 
            case 885: 
            case 886: 
            case 887: 
            case 888: 
            case 889: 
            case 890: 
            case 891: 
            case 892: 
            case 893: 
            case 894: 
            case 895: 
            case 896: 
            case 897: 
            case 898: 
            case 899: 
            case 900: 
            case 901: 
            case 902: 
            case 903: 
            case 904: 
            case 905: 
            case 906: 
            case 907: 
            case 908: 
            case 909: 
            case 910: 
            case 911: 
            case 912: 
            case 913: 
            case 914: 
            case 915: 
            case 916: 
            case 917: 
            case 918: 
            case 919: 
            case 920: 
            case 921: 
            case 922: 
            case 923: 
            case 924: 
            case 925: 
            case 926: 
            case 927: 
            case 928: 
            case 929: 
            case 930: 
            case 931: 
            case 932: 
            case 933: 
            case 934: 
            case 935: 
            case 936: 
            case 937: 
            case 938: 
            case 939: 
            case 940: 
            case 941: 
            case 982: 
            case 990: 
            case 998: 
            case 1006: 
            case 1014: 
            case 1022: 
            case 1030: 
            case 1038: 
            case 1046: 
            case 1054: 
            case 1062: 
            case 1070: 
            case 1078: 
            case 1086: 
            case 1094: 
            case 1102: 
            case 1110: 
            case 1118: 
            case 1126: 
            case 1134: 
            case 1142: 
            case 1349: 
            case 1350: 
            case 1351: 
            case 1352: 
            case 1353: 
            case 1354: 
            case 1355: 
            case 1356: 
            case 1357: 
            case 1358: 
            case 1359: 
            case 1360: 
            case 1361: 
            case 1362: 
            case 1363: 
            case 1364: 
            case 1365: 
            case 1366: 
            case 1367: 
            case 1368: 
            case 1369: 
            case 1370: 
            case 1371: 
            case 1372: 
            case 1373: 
            case 1374: 
            case 1375: 
            case 1376: 
            case 1377: 
            case 1378: 
            case 1379: 
            case 1380: 
            case 1381: 
            case 1382: 
            case 1383: 
            case 1384: 
            case 1385: 
            case 1386: 
            case 1387: 
            case 1388: 
            case 1389: 
            case 1390: 
            case 1391: 
            case 1392: 
            case 1393: 
            case 1394: 
            case 1395: 
            case 1396: 
            case 1397: 
            case 1398: 
            case 1399: 
            case 1400: 
            case 1401: 
            case 1402: 
            case 1403: 
            case 1404: 
            case 1405: 
            case 1406: 
            case 1407: 
            case 1408: 
            case 1409: 
            case 1410: 
            case 1411: 
            case 1412: 
            case 1413: 
            case 1414: 
            case 1415: 
            case 1416: 
            case 1417: 
            case 1418: 
            case 1419: 
            case 1420: 
            case 1421: 
            case 1422: 
            case 1423: 
            case 1424: 
            case 1425: 
            case 1426: 
            case 1427: 
            case 1428: 
            case 1429: 
            case 1430: 
            case 1431: 
            case 1432: 
            case 1433: 
            case 1434: 
            case 1435: 
            case 1436: 
            case 1437: 
            case 1438: 
            case 1439: 
            case 1440: 
            case 1441: 
            case 1442: 
            case 1443: 
            case 1444: 
            case 1445: 
            case 1446: 
            case 1447: 
            case 1448: 
            case 1449: 
            case 1450: 
            case 1451: 
            case 1452: 
            case 1453: 
            case 1454: 
            case 1455: 
            case 1456: 
            case 1457: 
            case 1458: 
            case 1459: 
            case 1460: 
            case 1461: 
            case 1462: 
            case 1463: 
            case 1464: 
            case 1465: 
            case 1466: 
            case 1467: 
            case 1468: 
            case 1469: 
            case 1470: 
            case 1471: 
            case 1472: 
            case 1473: 
            case 1474: 
            case 1475: 
            case 1476: 
            case 1477: 
            case 1478: 
            case 1479: 
            case 1480: 
            case 1481: 
            case 1482: 
            case 1483: 
            case 1484: 
            case 1485: 
            case 1486: 
            case 1487: 
            case 1488: 
            case 1489: 
            case 1490: 
            case 1491: 
            case 1492: 
            case 1493: 
            case 1494: 
            case 1495: 
            case 1496: 
            case 1497: 
            case 1498: 
            case 1499: 
            case 1500: 
            case 1501: 
            case 1502: 
            case 1503: 
            case 1504: 
            case 1505: 
            case 1506: 
            case 1507: 
            case 1508: 
            case 1509: 
            case 1510: 
            case 1511: 
            case 1512: 
            case 1513: 
            case 1514: 
            case 1515: 
            case 1516: 
            case 1517: 
            case 1518: 
            case 1519: 
            case 1520: 
            case 1521: 
            case 1522: 
            case 1523: 
            case 1524: 
            case 1525: 
            case 1526: 
            case 1527: 
            case 1528: 
            case 1529: 
            case 1530: 
            case 1531: 
            case 1532: 
            case 1533: 
            case 1534: 
            case 1535: 
            case 1536: 
            case 1537: 
            case 1538: 
            case 1539: 
            case 1540: 
            case 1541: 
            case 1542: 
            case 1543: 
            case 1544: 
            case 1545: 
            case 1586: 
            case 1594: 
            case 1602: 
            case 1610: 
            case 1618: 
            case 1626: 
            case 1634: 
            case 1642: 
            case 1650: 
            case 1658: 
            case 1666: 
            case 1674: 
            case 1682: 
            case 1690: 
            case 1698: 
            case 1706: 
            case 1714: 
            case 1722: 
            case 1730: 
            case 1738: 
            case 1746: 
            case 1953: 
            case 1954: 
            case 1955: 
            case 1956: 
            case 1957: 
            case 1958: 
            case 1959: 
            case 1960: 
            case 1961: 
            case 1962: 
            case 1963: 
            case 1964: 
            case 1965: 
            case 1966: 
            case 1967: 
            case 1968: 
            case 1969: 
            case 1970: 
            case 1971: 
            case 1972: 
            case 1973: 
            case 1974: 
            case 1975: 
            case 1976: 
            case 1977: 
            case 1978: 
            case 1979: 
            case 1980: 
            case 1981: 
            case 1982: 
            case 1983: 
            case 1984: 
            case 1985: 
            case 1986: 
            case 1987: 
            case 1988: 
            case 1989: 
            case 1990: 
            case 1991: 
            case 1992: 
            case 1993: 
            case 1994: 
            case 1995: 
            case 1996: 
            case 1997: 
            case 1998: 
            case 1999: 
            case 2000: 
            case 2001: 
            case 2002: 
            case 2003: 
            case 2004: 
            case 2005: 
            case 2006: 
            case 2007: 
            case 2008: 
            case 2009: 
            case 2010: 
            case 2011: 
            case 2012: 
            case 2013: 
            case 2014: 
            case 2015: 
            case 2016: 
            case 2017: 
            case 2018: 
            case 2019: 
            case 2020: 
            case 2021: 
            case 2022: 
            case 2023: 
            case 2024: 
            case 2025: 
            case 2026: 
            case 2027: 
            case 2028: 
            case 2029: 
            case 2030: 
            case 2031: 
            case 2032: 
            case 2033: 
            case 2034: 
            case 2035: 
            case 2036: 
            case 2037: 
            case 2038: 
            case 2039: 
            case 2040: 
            case 2041: 
            case 2042: 
            case 2043: 
            case 2044: 
            case 2045: 
            case 2046: 
            case 2047: 
            case 2048: 
            case 2049: 
            case 2050: 
            case 2051: 
            case 2052: 
            case 2053: 
            case 2054: 
            case 2055: 
            case 2056: 
            case 2057: 
            case 2058: 
            case 2059: 
            case 2060: 
            case 2061: 
            case 2062: 
            case 2063: 
            case 2064: 
            case 2065: 
            case 2066: 
            case 2067: 
            case 2068: 
            case 2069: 
            case 2070: 
            case 2071: 
            case 2072: 
            case 2073: 
            case 2074: 
            case 2075: 
            case 2076: 
            case 2077: 
            case 2078: 
            case 2079: 
            case 2080: 
            case 2081: 
            case 2082: 
            case 2083: 
            case 2084: 
            case 2085: 
            case 2086: 
            case 2087: 
            case 2088: 
            case 2089: 
            case 2090: 
            case 2091: 
            case 2092: 
            case 2093: 
            case 2094: 
            case 2095: 
            case 2096: 
            case 2097: 
            case 2098: 
            case 2099: 
            case 2100: 
            case 2101: 
            case 2102: 
            case 2103: 
            case 2104: 
            case 2105: 
            case 2106: 
            case 2107: 
            case 2108: 
            case 2109: 
            case 2110: 
            case 2111: 
            case 2112: 
            case 2113: 
            case 2114: 
            case 2115: 
            case 2116: 
            case 2117: 
            case 2118: 
            case 2119: 
            case 2120: 
            case 2121: 
            case 2122: 
            case 2123: 
            case 2124: 
            case 2125: 
            case 2126: 
            case 2127: 
            case 2128: 
            case 2129: 
            case 2130: 
            case 2131: 
            case 2132: 
            case 2133: 
            case 2134: 
            case 2135: 
            case 2136: 
            case 2137: 
            case 2138: 
            case 2139: 
            case 2140: 
            case 2141: 
            case 2142: 
            case 2143: 
            case 2144: 
            case 2145: 
            case 2146: 
            case 2147: 
            case 2148: 
            case 2149: 
            case 2190: 
            case 2198: 
            case 2206: 
            case 2214: 
            case 2222: 
            case 2230: 
            case 2238: 
            case 2246: 
            case 2254: 
            case 2262: 
            case 2270: 
            case 2278: 
            case 2286: 
            case 2294: 
            case 2302: 
            case 2310: 
            case 2318: 
            case 2326: 
            case 2334: 
            case 2342: 
            case 2350: 
            case 2557: 
            case 2558: 
            case 2559: 
            case 2560: 
            case 2561: 
            case 2562: 
            case 2563: 
            case 2564: 
            case 2565: 
            case 2566: 
            case 2567: 
            case 2568: 
            case 2569: 
            case 2570: 
            case 2571: 
            case 2572: 
            case 2573: 
            case 2574: 
            case 2575: 
            case 2576: 
            case 2577: 
            case 2578: 
            case 2579: 
            case 2580: 
            case 2581: 
            case 2582: 
            case 2583: 
            case 2584: 
            case 2585: 
            case 2586: 
            case 2587: 
            case 2588: 
            case 2589: 
            case 2590: 
            case 2591: 
            case 2592: 
            case 2593: 
            case 2594: 
            case 2595: 
            case 2596: 
            case 2597: 
            case 2598: 
            case 2599: 
            case 2600: 
            case 2601: 
            case 2602: 
            case 2603: 
            case 2604: 
            case 2605: 
            case 2606: 
            case 2607: 
            case 2608: 
            case 2609: 
            case 2610: 
            case 2611: 
            case 2612: 
            case 2613: 
            case 2614: 
            case 2615: 
            case 2616: 
            case 2617: 
            case 2618: 
            case 2619: 
            case 2620: 
            case 2621: 
            case 2622: 
            case 2623: 
            case 2624: 
            case 2625: 
            case 2626: 
            case 2627: 
            case 2628: 
            case 2629: 
            case 2630: 
            case 2631: 
            case 2632: 
            case 2633: 
            case 2634: 
            case 2635: 
            case 2636: 
            case 2637: 
            case 2638: 
            case 2639: 
            case 2640: 
            case 2641: 
            case 2642: 
            case 2643: 
            case 2644: 
            case 2645: 
            case 2646: 
            case 2647: 
            case 2648: 
            case 2649: 
            case 2650: 
            case 2651: 
            case 2652: 
            case 2653: 
            case 2654: 
            case 2655: 
            case 2656: 
            case 2657: 
            case 2658: 
            case 2659: 
            case 2660: 
            case 2661: 
            case 2662: 
            case 2663: 
            case 2664: 
            case 2665: 
            case 2666: 
            case 2667: 
            case 2668: 
            case 2669: 
            case 2670: 
            case 2671: 
            case 2672: 
            case 2673: 
            case 2674: 
            case 2675: 
            case 2676: 
            case 2677: 
            case 2678: 
            case 2679: 
            case 2680: 
            case 2681: 
            case 2682: 
            case 2683: 
            case 2684: 
            case 2685: 
            case 2686: 
            case 2687: 
            case 2688: 
            case 2689: 
            case 2690: 
            case 2691: 
            case 2692: 
            case 2693: 
            case 2694: 
            case 2695: 
            case 2696: 
            case 2697: 
            case 2698: 
            case 2699: 
            case 2700: 
            case 2701: 
            case 2702: 
            case 2703: 
            case 2704: 
            case 2705: 
            case 2706: 
            case 2707: 
            case 2708: 
            case 2709: 
            case 2710: 
            case 2711: 
            case 2712: 
            case 2713: 
            case 2714: 
            case 2715: 
            case 2716: 
            case 2717: 
            case 2718: 
            case 2719: 
            case 2720: 
            case 2721: 
            case 2722: 
            case 2723: 
            case 2724: 
            case 2725: 
            case 2726: 
            case 2727: 
            case 2728: 
            case 2729: 
            case 2730: 
            case 2731: 
            case 2732: 
            case 2733: 
            case 2734: 
            case 2735: 
            case 2736: 
            case 2737: 
            case 2738: 
            case 2739: 
            case 2740: 
            case 2741: 
            case 2742: 
            case 2743: 
            case 2744: 
            case 2745: 
            case 2746: 
            case 2747: 
            case 2748: 
            case 2749: 
            case 2750: 
            case 2751: 
            case 2752: 
            case 2753: 
            case 2794: 
            case 2802: 
            case 2810: 
            case 2818: 
            case 2826: 
            case 2834: 
            case 2842: 
            case 2850: 
            case 2858: 
            case 2866: 
            case 2874: 
            case 2882: 
            case 2890: 
            case 2898: 
            case 2906: 
            case 2914: 
            case 2922: 
            case 2930: 
            case 2938: 
            case 2946: 
            case 2954: 
            case 3161: 
            case 3162: 
            case 3163: 
            case 3164: 
            case 3165: 
            case 3166: 
            case 3167: 
            case 3168: 
            case 3169: 
            case 3170: 
            case 3171: 
            case 3172: 
            case 3173: 
            case 3174: 
            case 3175: 
            case 3176: 
            case 3177: 
            case 3178: 
            case 3179: 
            case 3180: 
            case 3181: 
            case 3182: 
            case 3183: 
            case 3184: 
            case 3185: 
            case 3186: 
            case 3187: 
            case 3188: 
            case 3189: 
            case 3190: 
            case 3191: 
            case 3192: 
            case 3193: 
            case 3194: 
            case 3195: 
            case 3196: 
            case 3197: 
            case 3198: 
            case 3199: 
            case 3200: 
            case 3201: 
            case 3202: 
            case 3203: 
            case 3204: 
            case 3205: 
            case 3206: 
            case 3207: 
            case 3208: 
            case 3209: 
            case 3210: 
            case 3211: 
            case 3212: 
            case 3213: 
            case 3214: 
            case 3215: 
            case 3216: 
            case 3217: 
            case 3218: 
            case 3219: 
            case 3220: 
            case 3221: 
            case 3222: 
            case 3223: 
            case 3224: 
            case 3225: 
            case 3226: 
            case 3227: 
            case 3228: 
            case 3229: 
            case 3230: 
            case 3231: 
            case 3232: 
            case 3233: 
            case 3234: 
            case 3235: 
            case 3236: 
            case 3237: 
            case 3238: 
            case 3239: 
            case 3240: 
            case 3241: 
            case 3242: 
            case 3243: 
            case 3244: 
            case 3245: 
            case 3246: 
            case 3247: 
            case 3248: 
            case 3249: 
            case 3250: 
            case 3251: 
            case 3252: 
            case 3253: 
            case 3254: 
            case 3255: 
            case 3256: 
            case 3257: 
            case 3258: 
            case 3259: 
            case 3260: 
            case 3261: 
            case 3262: 
            case 3263: 
            case 3264: 
            case 3265: 
            case 3266: 
            case 3267: 
            case 3268: 
            case 3269: 
            case 3270: 
            case 3271: 
            case 3272: 
            case 3273: 
            case 3274: 
            case 3275: 
            case 3276: 
            case 3277: 
            case 3278: 
            case 3279: 
            case 3280: 
            case 3281: 
            case 3282: 
            case 3283: 
            case 3284: 
            case 3285: 
            case 3286: 
            case 3287: 
            case 3288: 
            case 3289: 
            case 3290: 
            case 3291: 
            case 3292: 
            case 3293: 
            case 3294: 
            case 3295: 
            case 3296: 
            case 3297: 
            case 3298: 
            case 3299: 
            case 3300: 
            case 3301: 
            case 3302: 
            case 3303: 
            case 3304: 
            case 3305: 
            case 3306: 
            case 3307: 
            case 3308: 
            case 3309: 
            case 3310: 
            case 3311: 
            case 3312: 
            case 3313: 
            case 3314: 
            case 3315: 
            case 3316: 
            case 3317: 
            case 3318: 
            case 3319: 
            case 3320: 
            case 3321: 
            case 3322: 
            case 3323: 
            case 3324: 
            case 3325: 
            case 3326: 
            case 3327: 
            case 3328: 
            case 3329: 
            case 3330: 
            case 3331: 
            case 3332: 
            case 3333: 
            case 3334: 
            case 3335: 
            case 3336: 
            case 3337: 
            case 3338: 
            case 3339: 
            case 3340: 
            case 3341: 
            case 3342: 
            case 3343: 
            case 3344: 
            case 3345: 
            case 3346: 
            case 3347: 
            case 3348: 
            case 3349: 
            case 3350: 
            case 3351: 
            case 3352: 
            case 3353: 
            case 3354: 
            case 3355: 
            case 3356: 
            case 3357: 
            case 3398: 
            case 3406: 
            case 3414: 
            case 3422: 
            case 3430: 
            case 3438: 
            case 3446: 
            case 3454: 
            case 3462: 
            case 3470: 
            case 3478: 
            case 3486: 
            case 3494: 
            case 3502: 
            case 3510: 
            case 3518: 
            case 3526: 
            case 3534: 
            case 3542: 
            case 3550: 
            case 3558: 
            case 3765: 
            case 3766: 
            case 3767: 
            case 3768: 
            case 3769: 
            case 3770: 
            case 3771: 
            case 3772: 
            case 3773: 
            case 3774: 
            case 3775: 
            case 3776: 
            case 3777: 
            case 3778: 
            case 3779: 
            case 3780: 
            case 3781: 
            case 3782: 
            case 3783: 
            case 3784: 
            case 3785: 
            case 3786: 
            case 3787: 
            case 3788: 
            case 3789: 
            case 3790: 
            case 3791: 
            case 3792: 
            case 3793: 
            case 3794: 
            case 3795: 
            case 3796: 
            case 3797: 
            case 3798: 
            case 3799: 
            case 3800: 
            case 3801: 
            case 3802: 
            case 3803: 
            case 3804: 
            case 3805: 
            case 3806: 
            case 3807: 
            case 3808: 
            case 3809: 
            case 3810: 
            case 3811: 
            case 3812: 
            case 3813: 
            case 3814: 
            case 3815: 
            case 3816: 
            case 3817: 
            case 3818: 
            case 3819: 
            case 3820: 
            case 3821: 
            case 3822: 
            case 3823: 
            case 3824: 
            case 3825: 
            case 3826: 
            case 3827: 
            case 3828: 
            case 3829: 
            case 3830: 
            case 3831: 
            case 3832: 
            case 3833: 
            case 3834: 
            case 3835: 
            case 3836: 
            case 3837: 
            case 3838: 
            case 3839: 
            case 3840: 
            case 3841: 
            case 3842: 
            case 3843: 
            case 3844: 
            case 3845: 
            case 3846: 
            case 3847: 
            case 3848: 
            case 3849: 
            case 3850: 
            case 3851: 
            case 3852: 
            case 3853: 
            case 3854: 
            case 3855: 
            case 3856: 
            case 3857: 
            case 3858: 
            case 3859: 
            case 3860: 
            case 3861: 
            case 3862: 
            case 3863: 
            case 3864: 
            case 3865: 
            case 3866: 
            case 3867: 
            case 3868: 
            case 3869: 
            case 3870: 
            case 3871: 
            case 3872: 
            case 3873: 
            case 3874: 
            case 3875: 
            case 3876: 
            case 3877: 
            case 3878: 
            case 3879: 
            case 3880: 
            case 3881: 
            case 3882: 
            case 3883: 
            case 3884: 
            case 3885: 
            case 3886: 
            case 3887: 
            case 3888: 
            case 3889: 
            case 3890: 
            case 3891: 
            case 3892: 
            case 3893: 
            case 3894: 
            case 3895: 
            case 3896: 
            case 3897: 
            case 3898: 
            case 3899: 
            case 3900: 
            case 3901: 
            case 3902: 
            case 3903: 
            case 3904: 
            case 3905: 
            case 3906: 
            case 3907: 
            case 3908: 
            case 3909: 
            case 3910: 
            case 3911: 
            case 3912: 
            case 3913: 
            case 3914: 
            case 3915: 
            case 3916: 
            case 3917: 
            case 3918: 
            case 3919: 
            case 3920: 
            case 3921: 
            case 3922: 
            case 3923: 
            case 3924: 
            case 3925: 
            case 3926: 
            case 3927: 
            case 3928: 
            case 3929: 
            case 3930: 
            case 3931: 
            case 3932: 
            case 3933: 
            case 3934: 
            case 3935: 
            case 3936: 
            case 3937: 
            case 3938: 
            case 3939: 
            case 3940: 
            case 3941: 
            case 3942: 
            case 3943: 
            case 3944: 
            case 3945: 
            case 3946: 
            case 3947: 
            case 3948: 
            case 3949: 
            case 3950: 
            case 3951: 
            case 3952: 
            case 3953: 
            case 3954: 
            case 3955: 
            case 3956: 
            case 3957: 
            case 3958: 
            case 3959: 
            case 3960: 
            case 3961: {
                return 4;
            }
        }
        return 0;
    }

    public static boolean isFarJump(int n) {
        switch (n) {
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 206: 
            case 207: {
                return true;
            }
        }
        return false;
    }

    public static boolean isNearJump(int n) {
        switch (n) {
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 172: 
            case 200: 
            case 201: 
            case 202: 
            case 203: 
            case 204: 
            case 205: 
            case 317: 
            case 318: 
            case 319: 
            case 320: 
            case 321: 
            case 322: 
            case 323: 
            case 324: 
            case 325: 
            case 326: 
            case 327: 
            case 328: 
            case 329: 
            case 330: 
            case 331: 
            case 332: 
            case 333: 
            case 334: 
            case 335: 
            case 336: 
            case 337: 
            case 338: 
            case 339: 
            case 340: 
            case 341: 
            case 342: 
            case 343: 
            case 344: 
            case 345: 
            case 346: 
            case 347: 
            case 348: 
            case 349: 
            case 350: 
            case 351: 
            case 352: 
            case 374: 
            case 375: {
                return true;
            }
        }
        return false;
    }

    public static boolean isModeSwitch(int n) {
        switch (n) {
            case 388: 
            case 390: {
                return true;
            }
        }
        return false;
    }

    public static boolean isBlockTerminating(int n) {
        switch (n) {
            case 177: {
                return true;
            }
        }
        return false;
    }

    public static boolean isJump(int n) {
        return RealModeDecoder.isNearJump(n) || RealModeDecoder.isFarJump(n) || RealModeDecoder.isModeSwitch(n) || RealModeDecoder.isBlockTerminating(n);
    }

    private static int decodeEb(int n, int n2, int n3) {
        switch (n2 & 0xC7) {
            case 192: {
                return 0;
            }
            case 193: {
                return 1;
            }
            case 194: {
                return 2;
            }
            case 195: {
                return 3;
            }
            case 196: {
                return 4;
            }
            case 197: {
                return 5;
            }
            case 198: {
                return 6;
            }
            case 199: {
                return 7;
            }
        }
        return RealModeDecoder.decodeM(n, n2, n3);
    }

    private static int decodeEw(int n, int n2, int n3) {
        switch (n2 & 0xC7) {
            case 192: {
                return 8;
            }
            case 193: {
                return 9;
            }
            case 194: {
                return 10;
            }
            case 195: {
                return 11;
            }
            case 196: {
                return 12;
            }
            case 197: {
                return 13;
            }
            case 198: {
                return 14;
            }
            case 199: {
                return 15;
            }
        }
        return RealModeDecoder.decodeM(n, n2, n3);
    }

    private static int decodeEd(int n, int n2, int n3) {
        switch (n2 & 0xC7) {
            case 192: {
                return 16;
            }
            case 193: {
                return 17;
            }
            case 194: {
                return 18;
            }
            case 195: {
                return 19;
            }
            case 196: {
                return 20;
            }
            case 197: {
                return 21;
            }
            case 198: {
                return 22;
            }
            case 199: {
                return 23;
            }
        }
        return RealModeDecoder.decodeM(n, n2, n3);
    }

    private static int decodeGb(int n) {
        switch (n & 0x38) {
            case 0: {
                return 0;
            }
            case 8: {
                return 1;
            }
            case 16: {
                return 2;
            }
            case 24: {
                return 3;
            }
            case 32: {
                return 4;
            }
            case 40: {
                return 5;
            }
            case 48: {
                return 6;
            }
            case 56: {
                return 7;
            }
        }
        return -1;
    }

    private static int decodeGw(int n) {
        switch (n & 0x38) {
            case 0: {
                return 8;
            }
            case 8: {
                return 9;
            }
            case 16: {
                return 10;
            }
            case 24: {
                return 11;
            }
            case 32: {
                return 12;
            }
            case 40: {
                return 13;
            }
            case 48: {
                return 14;
            }
            case 56: {
                return 15;
            }
        }
        return -1;
    }

    private static int decodeGd(int n) {
        switch (n & 0x38) {
            case 0: {
                return 16;
            }
            case 8: {
                return 17;
            }
            case 16: {
                return 18;
            }
            case 24: {
                return 19;
            }
            case 32: {
                return 20;
            }
            case 40: {
                return 21;
            }
            case 48: {
                return 22;
            }
            case 56: {
                return 23;
            }
        }
        return -1;
    }

    private static int decodeSw(int n) {
        switch (n & 0x38) {
            case 0: {
                return 24;
            }
            case 8: {
                return 25;
            }
            case 16: {
                return 26;
            }
            case 24: {
                return 27;
            }
            case 32: {
                return 28;
            }
            case 40: {
                return 29;
            }
        }
        return -1;
    }

    private static int decodeOb(int n) {
        switch (n & 7) {
            default: {
                if ((n & 0x10) != 0) {
                    return 123;
                }
                return 260;
            }
            case 1: {
                if ((n & 0x10) != 0) {
                    return 60;
                }
                return 188;
            }
            case 2: {
                if ((n & 0x10) != 0) {
                    return 81;
                }
                return 212;
            }
            case 3: {
                if ((n & 0x10) != 0) {
                    return 102;
                }
                return 236;
            }
            case 4: {
                if ((n & 0x10) != 0) {
                    return 123;
                }
                return 260;
            }
            case 5: {
                if ((n & 0x10) != 0) {
                    return 144;
                }
                return 284;
            }
            case 6: 
        }
        if ((n & 0x10) != 0) {
            return 165;
        }
        return 308;
    }

    private static int decodeOw(int n) {
        switch (n & 7) {
            default: {
                if ((n & 0x10) != 0) {
                    return 123;
                }
                return 260;
            }
            case 1: {
                if ((n & 0x10) != 0) {
                    return 60;
                }
                return 188;
            }
            case 2: {
                if ((n & 0x10) != 0) {
                    return 81;
                }
                return 212;
            }
            case 3: {
                if ((n & 0x10) != 0) {
                    return 102;
                }
                return 236;
            }
            case 4: {
                if ((n & 0x10) != 0) {
                    return 123;
                }
                return 260;
            }
            case 5: {
                if ((n & 0x10) != 0) {
                    return 144;
                }
                return 284;
            }
            case 6: 
        }
        if ((n & 0x10) != 0) {
            return 165;
        }
        return 308;
    }

    private static int decodeOd(int n) {
        switch (n & 7) {
            default: {
                if ((n & 0x10) != 0) {
                    return 123;
                }
                return 260;
            }
            case 1: {
                if ((n & 0x10) != 0) {
                    return 60;
                }
                return 188;
            }
            case 2: {
                if ((n & 0x10) != 0) {
                    return 81;
                }
                return 212;
            }
            case 3: {
                if ((n & 0x10) != 0) {
                    return 102;
                }
                return 236;
            }
            case 4: {
                if ((n & 0x10) != 0) {
                    return 123;
                }
                return 260;
            }
            case 5: {
                if ((n & 0x10) != 0) {
                    return 144;
                }
                return 284;
            }
            case 6: 
        }
        if ((n & 0x10) != 0) {
            return 165;
        }
        return 308;
    }

    private static int decodeYb(int n) {
        if ((n & 0x10) != 0) {
            return 62;
        }
        return 187;
    }

    private static int decodeYw(int n) {
        if ((n & 0x10) != 0) {
            return 62;
        }
        return 187;
    }

    private static int decodeYd(int n) {
        if ((n & 0x10) != 0) {
            return 62;
        }
        return 187;
    }

    private static int decodeXb(int n) {
        switch (n & 7) {
            default: {
                if ((n & 0x10) != 0) {
                    return 124;
                }
                return 258;
            }
            case 1: {
                if ((n & 0x10) != 0) {
                    return 61;
                }
                return 186;
            }
            case 2: {
                if ((n & 0x10) != 0) {
                    return 82;
                }
                return 210;
            }
            case 3: {
                if ((n & 0x10) != 0) {
                    return 103;
                }
                return 234;
            }
            case 4: {
                if ((n & 0x10) != 0) {
                    return 124;
                }
                return 258;
            }
            case 5: {
                if ((n & 0x10) != 0) {
                    return 145;
                }
                return 282;
            }
            case 6: 
        }
        if ((n & 0x10) != 0) {
            return 166;
        }
        return 306;
    }

    private static int decodeXw(int n) {
        switch (n & 7) {
            default: {
                if ((n & 0x10) != 0) {
                    return 124;
                }
                return 258;
            }
            case 1: {
                if ((n & 0x10) != 0) {
                    return 61;
                }
                return 186;
            }
            case 2: {
                if ((n & 0x10) != 0) {
                    return 82;
                }
                return 210;
            }
            case 3: {
                if ((n & 0x10) != 0) {
                    return 103;
                }
                return 234;
            }
            case 4: {
                if ((n & 0x10) != 0) {
                    return 124;
                }
                return 258;
            }
            case 5: {
                if ((n & 0x10) != 0) {
                    return 145;
                }
                return 282;
            }
            case 6: 
        }
        if ((n & 0x10) != 0) {
            return 166;
        }
        return 306;
    }

    private static int decodeXd(int n) {
        switch (n & 7) {
            default: {
                if ((n & 0x10) != 0) {
                    return 124;
                }
                return 258;
            }
            case 1: {
                if ((n & 0x10) != 0) {
                    return 61;
                }
                return 186;
            }
            case 2: {
                if ((n & 0x10) != 0) {
                    return 82;
                }
                return 210;
            }
            case 3: {
                if ((n & 0x10) != 0) {
                    return 103;
                }
                return 234;
            }
            case 4: {
                if ((n & 0x10) != 0) {
                    return 124;
                }
                return 258;
            }
            case 5: {
                if ((n & 0x10) != 0) {
                    return 145;
                }
                return 282;
            }
            case 6: 
        }
        if ((n & 0x10) != 0) {
            return 166;
        }
        return 306;
    }

    private static int decodeM(int n, int n2, int n3) {
        if ((n & 0x10) != 0) {
            switch (n & 7) {
                default: {
                    switch (n2 & 0xC7) {
                        case 0: {
                            return 119;
                        }
                        case 1: {
                            return 120;
                        }
                        case 2: {
                            return 121;
                        }
                        case 3: {
                            return 122;
                        }
                        case 4: {
                            return RealModeDecoder.decodeSIB(n, n2, n3);
                        }
                        case 5: {
                            return 123;
                        }
                        case 6: {
                            return 124;
                        }
                        case 7: {
                            return 125;
                        }
                        case 64: {
                            return 126;
                        }
                        case 65: {
                            return 127;
                        }
                        case 66: {
                            return 128;
                        }
                        case 67: {
                            return 129;
                        }
                        case 68: {
                            return RealModeDecoder.decodeSIB(n, n2, n3);
                        }
                        case 69: {
                            return 109;
                        }
                        case 70: {
                            return 131;
                        }
                        case 71: {
                            return 132;
                        }
                        case 128: {
                            return 133;
                        }
                        case 129: {
                            return 134;
                        }
                        case 130: {
                            return 135;
                        }
                        case 131: {
                            return 136;
                        }
                        case 132: {
                            return RealModeDecoder.decodeSIB(n, n2, n3);
                        }
                        case 133: {
                            return 116;
                        }
                        case 134: {
                            return 138;
                        }
                        case 135: {
                            return 139;
                        }
                    }
                }
                case 1: {
                    switch (n2 & 0xC7) {
                        case 0: {
                            return 56;
                        }
                        case 1: {
                            return 57;
                        }
                        case 2: {
                            return 58;
                        }
                        case 3: {
                            return 59;
                        }
                        case 4: {
                            return RealModeDecoder.decodeSIB(n, n2, n3);
                        }
                        case 5: {
                            return 60;
                        }
                        case 6: {
                            return 61;
                        }
                        case 7: {
                            return 62;
                        }
                        case 64: {
                            return 63;
                        }
                        case 65: {
                            return 64;
                        }
                        case 66: {
                            return 65;
                        }
                        case 67: {
                            return 66;
                        }
                        case 68: {
                            return RealModeDecoder.decodeSIB(n, n2, n3);
                        }
                        case 69: {
                            return 67;
                        }
                        case 70: {
                            return 68;
                        }
                        case 71: {
                            return 69;
                        }
                        case 128: {
                            return 70;
                        }
                        case 129: {
                            return 71;
                        }
                        case 130: {
                            return 72;
                        }
                        case 131: {
                            return 73;
                        }
                        case 132: {
                            return RealModeDecoder.decodeSIB(n, n2, n3);
                        }
                        case 133: {
                            return 74;
                        }
                        case 134: {
                            return 75;
                        }
                        case 135: {
                            return 76;
                        }
                    }
                }
                case 2: {
                    switch (n2 & 0xC7) {
                        case 0: {
                            return 77;
                        }
                        case 1: {
                            return 78;
                        }
                        case 2: {
                            return 79;
                        }
                        case 3: {
                            return 80;
                        }
                        case 4: {
                            return RealModeDecoder.decodeSIB(n, n2, n3);
                        }
                        case 5: {
                            return 81;
                        }
                        case 6: {
                            return 82;
                        }
                        case 7: {
                            return 83;
                        }
                        case 64: {
                            return 84;
                        }
                        case 65: {
                            return 85;
                        }
                        case 66: {
                            return 86;
                        }
                        case 67: {
                            return 87;
                        }
                        case 68: {
                            return RealModeDecoder.decodeSIB(n, n2, n3);
                        }
                        case 69: {
                            return 88;
                        }
                        case 70: {
                            return 89;
                        }
                        case 71: {
                            return 90;
                        }
                        case 128: {
                            return 91;
                        }
                        case 129: {
                            return 92;
                        }
                        case 130: {
                            return 93;
                        }
                        case 131: {
                            return 94;
                        }
                        case 132: {
                            return RealModeDecoder.decodeSIB(n, n2, n3);
                        }
                        case 133: {
                            return 95;
                        }
                        case 134: {
                            return 96;
                        }
                        case 135: {
                            return 97;
                        }
                    }
                }
                case 3: {
                    switch (n2 & 0xC7) {
                        case 0: {
                            return 98;
                        }
                        case 1: {
                            return 99;
                        }
                        case 2: {
                            return 100;
                        }
                        case 3: {
                            return 101;
                        }
                        case 4: {
                            return RealModeDecoder.decodeSIB(n, n2, n3);
                        }
                        case 5: {
                            return 102;
                        }
                        case 6: {
                            return 103;
                        }
                        case 7: {
                            return 104;
                        }
                        case 64: {
                            return 105;
                        }
                        case 65: {
                            return 106;
                        }
                        case 66: {
                            return 107;
                        }
                        case 67: {
                            return 108;
                        }
                        case 68: {
                            return RealModeDecoder.decodeSIB(n, n2, n3);
                        }
                        case 69: {
                            return 109;
                        }
                        case 70: {
                            return 110;
                        }
                        case 71: {
                            return 111;
                        }
                        case 128: {
                            return 112;
                        }
                        case 129: {
                            return 113;
                        }
                        case 130: {
                            return 114;
                        }
                        case 131: {
                            return 115;
                        }
                        case 132: {
                            return RealModeDecoder.decodeSIB(n, n2, n3);
                        }
                        case 133: {
                            return 116;
                        }
                        case 134: {
                            return 117;
                        }
                        case 135: {
                            return 118;
                        }
                    }
                }
                case 4: {
                    switch (n2 & 0xC7) {
                        case 0: {
                            return 119;
                        }
                        case 1: {
                            return 120;
                        }
                        case 2: {
                            return 121;
                        }
                        case 3: {
                            return 122;
                        }
                        case 4: {
                            return RealModeDecoder.decodeSIB(n, n2, n3);
                        }
                        case 5: {
                            return 123;
                        }
                        case 6: {
                            return 124;
                        }
                        case 7: {
                            return 125;
                        }
                        case 64: {
                            return 126;
                        }
                        case 65: {
                            return 127;
                        }
                        case 66: {
                            return 128;
                        }
                        case 67: {
                            return 129;
                        }
                        case 68: {
                            return RealModeDecoder.decodeSIB(n, n2, n3);
                        }
                        case 69: {
                            return 130;
                        }
                        case 70: {
                            return 131;
                        }
                        case 71: {
                            return 132;
                        }
                        case 128: {
                            return 133;
                        }
                        case 129: {
                            return 134;
                        }
                        case 130: {
                            return 135;
                        }
                        case 131: {
                            return 136;
                        }
                        case 132: {
                            return RealModeDecoder.decodeSIB(n, n2, n3);
                        }
                        case 133: {
                            return 137;
                        }
                        case 134: {
                            return 138;
                        }
                        case 135: {
                            return 139;
                        }
                    }
                }
                case 5: {
                    switch (n2 & 0xC7) {
                        case 0: {
                            return 140;
                        }
                        case 1: {
                            return 141;
                        }
                        case 2: {
                            return 142;
                        }
                        case 3: {
                            return 143;
                        }
                        case 4: {
                            return RealModeDecoder.decodeSIB(n, n2, n3);
                        }
                        case 5: {
                            return 144;
                        }
                        case 6: {
                            return 145;
                        }
                        case 7: {
                            return 146;
                        }
                        case 64: {
                            return 147;
                        }
                        case 65: {
                            return 148;
                        }
                        case 66: {
                            return 149;
                        }
                        case 67: {
                            return 150;
                        }
                        case 68: {
                            return RealModeDecoder.decodeSIB(n, n2, n3);
                        }
                        case 69: {
                            return 151;
                        }
                        case 70: {
                            return 152;
                        }
                        case 71: {
                            return 153;
                        }
                        case 128: {
                            return 154;
                        }
                        case 129: {
                            return 155;
                        }
                        case 130: {
                            return 156;
                        }
                        case 131: {
                            return 157;
                        }
                        case 132: {
                            return RealModeDecoder.decodeSIB(n, n2, n3);
                        }
                        case 133: {
                            return 158;
                        }
                        case 134: {
                            return 159;
                        }
                        case 135: {
                            return 160;
                        }
                    }
                }
                case 6: 
            }
            switch (n2 & 0xC7) {
                case 0: {
                    return 161;
                }
                case 1: {
                    return 162;
                }
                case 2: {
                    return 163;
                }
                case 3: {
                    return 164;
                }
                case 4: {
                    return RealModeDecoder.decodeSIB(n, n2, n3);
                }
                case 5: {
                    return 165;
                }
                case 6: {
                    return 166;
                }
                case 7: {
                    return 167;
                }
                case 64: {
                    return 168;
                }
                case 65: {
                    return 169;
                }
                case 66: {
                    return 170;
                }
                case 67: {
                    return 171;
                }
                case 68: {
                    return RealModeDecoder.decodeSIB(n, n2, n3);
                }
                case 69: {
                    return 172;
                }
                case 70: {
                    return 173;
                }
                case 71: {
                    return 174;
                }
                case 128: {
                    return 175;
                }
                case 129: {
                    return 176;
                }
                case 130: {
                    return 177;
                }
                case 131: {
                    return 178;
                }
                case 132: {
                    return RealModeDecoder.decodeSIB(n, n2, n3);
                }
                case 133: {
                    return 179;
                }
                case 134: {
                    return 180;
                }
                case 135: {
                    return 181;
                }
            }
        } else {
            switch (n & 7) {
                default: {
                    switch (n2 & 0xC7) {
                        case 0: {
                            return 254;
                        }
                        case 1: {
                            return 255;
                        }
                        case 2: {
                            return 232;
                        }
                        case 3: {
                            return 233;
                        }
                        case 4: {
                            return 258;
                        }
                        case 5: {
                            return 259;
                        }
                        case 6: {
                            return 260;
                        }
                        case 7: {
                            return 261;
                        }
                        case 64: {
                            return 262;
                        }
                        case 65: {
                            return 263;
                        }
                        case 66: {
                            return 240;
                        }
                        case 67: {
                            return 241;
                        }
                        case 68: {
                            return 266;
                        }
                        case 69: {
                            return 267;
                        }
                        case 70: {
                            return 244;
                        }
                        case 71: {
                            return 269;
                        }
                        case 128: {
                            return 270;
                        }
                        case 129: {
                            return 271;
                        }
                        case 130: {
                            return 248;
                        }
                        case 131: {
                            return 249;
                        }
                        case 132: {
                            return 274;
                        }
                        case 133: {
                            return 275;
                        }
                        case 134: {
                            return 252;
                        }
                        case 135: {
                            return 277;
                        }
                    }
                }
                case 1: {
                    switch (n2 & 0xC7) {
                        case 0: {
                            return 182;
                        }
                        case 1: {
                            return 183;
                        }
                        case 2: {
                            return 184;
                        }
                        case 3: {
                            return 185;
                        }
                        case 4: {
                            return 186;
                        }
                        case 5: {
                            return 187;
                        }
                        case 6: {
                            return 188;
                        }
                        case 7: {
                            return 189;
                        }
                        case 64: {
                            return 190;
                        }
                        case 65: {
                            return 191;
                        }
                        case 66: {
                            return 192;
                        }
                        case 67: {
                            return 193;
                        }
                        case 68: {
                            return 194;
                        }
                        case 69: {
                            return 195;
                        }
                        case 70: {
                            return 196;
                        }
                        case 71: {
                            return 197;
                        }
                        case 128: {
                            return 198;
                        }
                        case 129: {
                            return 199;
                        }
                        case 130: {
                            return 200;
                        }
                        case 131: {
                            return 201;
                        }
                        case 132: {
                            return 202;
                        }
                        case 133: {
                            return 203;
                        }
                        case 134: {
                            return 204;
                        }
                        case 135: {
                            return 205;
                        }
                    }
                }
                case 2: {
                    switch (n2 & 0xC7) {
                        case 0: {
                            return 206;
                        }
                        case 1: {
                            return 207;
                        }
                        case 2: {
                            return 208;
                        }
                        case 3: {
                            return 209;
                        }
                        case 4: {
                            return 210;
                        }
                        case 5: {
                            return 211;
                        }
                        case 6: {
                            return 212;
                        }
                        case 7: {
                            return 213;
                        }
                        case 64: {
                            return 214;
                        }
                        case 65: {
                            return 215;
                        }
                        case 66: {
                            return 216;
                        }
                        case 67: {
                            return 217;
                        }
                        case 68: {
                            return 218;
                        }
                        case 69: {
                            return 219;
                        }
                        case 70: {
                            return 220;
                        }
                        case 71: {
                            return 221;
                        }
                        case 128: {
                            return 222;
                        }
                        case 129: {
                            return 223;
                        }
                        case 130: {
                            return 224;
                        }
                        case 131: {
                            return 225;
                        }
                        case 132: {
                            return 226;
                        }
                        case 133: {
                            return 227;
                        }
                        case 134: {
                            return 228;
                        }
                        case 135: {
                            return 229;
                        }
                    }
                }
                case 3: {
                    switch (n2 & 0xC7) {
                        case 0: {
                            return 230;
                        }
                        case 1: {
                            return 231;
                        }
                        case 2: {
                            return 232;
                        }
                        case 3: {
                            return 233;
                        }
                        case 4: {
                            return 234;
                        }
                        case 5: {
                            return 235;
                        }
                        case 6: {
                            return 236;
                        }
                        case 7: {
                            return 237;
                        }
                        case 64: {
                            return 238;
                        }
                        case 65: {
                            return 239;
                        }
                        case 66: {
                            return 240;
                        }
                        case 67: {
                            return 241;
                        }
                        case 68: {
                            return 242;
                        }
                        case 69: {
                            return 243;
                        }
                        case 70: {
                            return 244;
                        }
                        case 71: {
                            return 245;
                        }
                        case 128: {
                            return 246;
                        }
                        case 129: {
                            return 247;
                        }
                        case 130: {
                            return 248;
                        }
                        case 131: {
                            return 249;
                        }
                        case 132: {
                            return 250;
                        }
                        case 133: {
                            return 251;
                        }
                        case 134: {
                            return 252;
                        }
                        case 135: {
                            return 253;
                        }
                    }
                }
                case 4: {
                    switch (n2 & 0xC7) {
                        case 0: {
                            return 254;
                        }
                        case 1: {
                            return 255;
                        }
                        case 2: {
                            return 256;
                        }
                        case 3: {
                            return 257;
                        }
                        case 4: {
                            return 258;
                        }
                        case 5: {
                            return 259;
                        }
                        case 6: {
                            return 260;
                        }
                        case 7: {
                            return 261;
                        }
                        case 64: {
                            return 262;
                        }
                        case 65: {
                            return 263;
                        }
                        case 66: {
                            return 264;
                        }
                        case 67: {
                            return 265;
                        }
                        case 68: {
                            return 266;
                        }
                        case 69: {
                            return 267;
                        }
                        case 70: {
                            return 268;
                        }
                        case 71: {
                            return 269;
                        }
                        case 128: {
                            return 270;
                        }
                        case 129: {
                            return 271;
                        }
                        case 130: {
                            return 272;
                        }
                        case 131: {
                            return 273;
                        }
                        case 132: {
                            return 274;
                        }
                        case 133: {
                            return 275;
                        }
                        case 134: {
                            return 276;
                        }
                        case 135: {
                            return 277;
                        }
                    }
                }
                case 5: {
                    switch (n2 & 0xC7) {
                        case 0: {
                            return 278;
                        }
                        case 1: {
                            return 279;
                        }
                        case 2: {
                            return 280;
                        }
                        case 3: {
                            return 281;
                        }
                        case 4: {
                            return 282;
                        }
                        case 5: {
                            return 283;
                        }
                        case 6: {
                            return 284;
                        }
                        case 7: {
                            return 285;
                        }
                        case 64: {
                            return 286;
                        }
                        case 65: {
                            return 287;
                        }
                        case 66: {
                            return 288;
                        }
                        case 67: {
                            return 289;
                        }
                        case 68: {
                            return 290;
                        }
                        case 69: {
                            return 291;
                        }
                        case 70: {
                            return 292;
                        }
                        case 71: {
                            return 293;
                        }
                        case 128: {
                            return 294;
                        }
                        case 129: {
                            return 295;
                        }
                        case 130: {
                            return 296;
                        }
                        case 131: {
                            return 297;
                        }
                        case 132: {
                            return 298;
                        }
                        case 133: {
                            return 299;
                        }
                        case 134: {
                            return 300;
                        }
                        case 135: {
                            return 301;
                        }
                    }
                }
                case 6: 
            }
            switch (n2 & 0xC7) {
                case 0: {
                    return 302;
                }
                case 1: {
                    return 303;
                }
                case 2: {
                    return 304;
                }
                case 3: {
                    return 305;
                }
                case 4: {
                    return 306;
                }
                case 5: {
                    return 307;
                }
                case 6: {
                    return 308;
                }
                case 7: {
                    return 309;
                }
                case 64: {
                    return 310;
                }
                case 65: {
                    return 311;
                }
                case 66: {
                    return 312;
                }
                case 67: {
                    return 313;
                }
                case 68: {
                    return 314;
                }
                case 69: {
                    return 315;
                }
                case 70: {
                    return 316;
                }
                case 71: {
                    return 317;
                }
                case 128: {
                    return 318;
                }
                case 129: {
                    return 319;
                }
                case 130: {
                    return 320;
                }
                case 131: {
                    return 321;
                }
                case 132: {
                    return 322;
                }
                case 133: {
                    return 323;
                }
                case 134: {
                    return 324;
                }
                case 135: {
                    return 325;
                }
            }
        }
        return -1;
    }

    private static int decodeCd(int n) {
        switch (n & 0x38) {
            case 0: {
                return 30;
            }
            case 16: {
                return 32;
            }
            case 24: {
                return 33;
            }
            case 32: {
                return 34;
            }
        }
        return -1;
    }

    private static int decodeSIB(int n, int n2, int n3) {
        switch (n & 7) {
            case 0: {
                switch (n2 & 0xC0) {
                    default: {
                        return -1;
                    }
                    case 0: {
                        switch (n3) {
                            default: {
                                return -1;
                            }
                            case 0: {
                                return 338;
                            }
                            case 1: {
                                return 339;
                            }
                            case 2: {
                                return 340;
                            }
                            case 3: {
                                return 341;
                            }
                            case 4: {
                                return 2154;
                            }
                            case 5: {
                                return 133;
                            }
                            case 6: {
                                return 344;
                            }
                            case 7: {
                                return 345;
                            }
                            case 8: {
                                return 339;
                            }
                            case 9: {
                                return 346;
                            }
                            case 10: {
                                return 347;
                            }
                            case 11: {
                                return 348;
                            }
                            case 12: {
                                return 2161;
                            }
                            case 13: {
                                return 134;
                            }
                            case 14: {
                                return 351;
                            }
                            case 15: {
                                return 352;
                            }
                            case 16: {
                                return 340;
                            }
                            case 17: {
                                return 347;
                            }
                            case 18: {
                                return 353;
                            }
                            case 19: {
                                return 354;
                            }
                            case 20: {
                                return 2167;
                            }
                            case 21: {
                                return 135;
                            }
                            case 22: {
                                return 357;
                            }
                            case 23: {
                                return 358;
                            }
                            case 24: {
                                return 341;
                            }
                            case 25: {
                                return 348;
                            }
                            case 26: {
                                return 354;
                            }
                            case 27: {
                                return 359;
                            }
                            case 28: {
                                return 2172;
                            }
                            case 29: {
                                return 136;
                            }
                            case 30: {
                                return 362;
                            }
                            case 31: {
                                return 363;
                            }
                            case 32: {
                                return 119;
                            }
                            case 33: {
                                return 120;
                            }
                            case 34: {
                                return 121;
                            }
                            case 35: {
                                return 122;
                            }
                            case 36: {
                                return 2176;
                            }
                            case 37: {
                                return 123;
                            }
                            case 38: {
                                return 124;
                            }
                            case 39: {
                                return 125;
                            }
                            case 40: {
                                return 343;
                            }
                            case 41: {
                                return 350;
                            }
                            case 42: {
                                return 356;
                            }
                            case 43: {
                                return 361;
                            }
                            case 44: {
                                return 2177;
                            }
                            case 45: {
                                return 137;
                            }
                            case 46: {
                                return 366;
                            }
                            case 47: {
                                return 367;
                            }
                            case 48: {
                                return 344;
                            }
                            case 49: {
                                return 351;
                            }
                            case 50: {
                                return 357;
                            }
                            case 51: {
                                return 362;
                            }
                            case 52: {
                                return 2180;
                            }
                            case 53: {
                                return 138;
                            }
                            case 54: {
                                return 369;
                            }
                            case 55: {
                                return 370;
                            }
                            case 56: {
                                return 345;
                            }
                            case 57: {
                                return 352;
                            }
                            case 58: {
                                return 358;
                            }
                            case 59: {
                                return 363;
                            }
                            case 60: {
                                return 2183;
                            }
                            case 61: {
                                return 139;
                            }
                            case 62: {
                                return 370;
                            }
                            case 63: {
                                return 372;
                            }
                            case 64: {
                                return 373;
                            }
                            case 65: {
                                return 374;
                            }
                            case 66: {
                                return 375;
                            }
                            case 67: {
                                return 376;
                            }
                            case 68: {
                                return 2189;
                            }
                            case 69: {
                                return 378;
                            }
                            case 70: {
                                return 379;
                            }
                            case 71: {
                                return 380;
                            }
                            case 72: {
                                return 381;
                            }
                            case 73: {
                                return 382;
                            }
                            case 74: {
                                return 383;
                            }
                            case 75: {
                                return 384;
                            }
                            case 76: {
                                return 2197;
                            }
                            case 77: {
                                return 386;
                            }
                            case 78: {
                                return 387;
                            }
                            case 79: {
                                return 388;
                            }
                            case 80: {
                                return 389;
                            }
                            case 81: {
                                return 390;
                            }
                            case 82: {
                                return 391;
                            }
                            case 83: {
                                return 392;
                            }
                            case 84: {
                                return 2205;
                            }
                            case 85: {
                                return 394;
                            }
                            case 86: {
                                return 395;
                            }
                            case 87: {
                                return 396;
                            }
                            case 88: {
                                return 397;
                            }
                            case 89: {
                                return 398;
                            }
                            case 90: {
                                return 399;
                            }
                            case 91: {
                                return 400;
                            }
                            case 92: {
                                return 2213;
                            }
                            case 93: {
                                return 402;
                            }
                            case 94: {
                                return 403;
                            }
                            case 95: {
                                return 404;
                            }
                            case 96: {
                                return 119;
                            }
                            case 97: {
                                return 120;
                            }
                            case 98: {
                                return 121;
                            }
                            case 99: {
                                return 122;
                            }
                            case 100: {
                                return 2176;
                            }
                            case 101: {
                                return 123;
                            }
                            case 102: {
                                return 124;
                            }
                            case 103: {
                                return 125;
                            }
                            case 104: {
                                return 405;
                            }
                            case 105: {
                                return 406;
                            }
                            case 106: {
                                return 407;
                            }
                            case 107: {
                                return 408;
                            }
                            case 108: {
                                return 2221;
                            }
                            case 109: {
                                return 410;
                            }
                            case 110: {
                                return 411;
                            }
                            case 111: {
                                return 412;
                            }
                            case 112: {
                                return 413;
                            }
                            case 113: {
                                return 414;
                            }
                            case 114: {
                                return 415;
                            }
                            case 115: {
                                return 416;
                            }
                            case 116: {
                                return 2229;
                            }
                            case 117: {
                                return 418;
                            }
                            case 118: {
                                return 419;
                            }
                            case 119: {
                                return 420;
                            }
                            case 120: {
                                return 421;
                            }
                            case 121: {
                                return 422;
                            }
                            case 122: {
                                return 423;
                            }
                            case 123: {
                                return 424;
                            }
                            case 124: {
                                return 2237;
                            }
                            case 125: {
                                return 426;
                            }
                            case 126: {
                                return 427;
                            }
                            case 127: {
                                return 428;
                            }
                            case 128: {
                                return 429;
                            }
                            case 129: {
                                return 430;
                            }
                            case 130: {
                                return 431;
                            }
                            case 131: {
                                return 432;
                            }
                            case 132: {
                                return 2245;
                            }
                            case 133: {
                                return 434;
                            }
                            case 134: {
                                return 435;
                            }
                            case 135: {
                                return 436;
                            }
                            case 136: {
                                return 437;
                            }
                            case 137: {
                                return 438;
                            }
                            case 138: {
                                return 439;
                            }
                            case 139: {
                                return 440;
                            }
                            case 140: {
                                return 2253;
                            }
                            case 141: {
                                return 442;
                            }
                            case 142: {
                                return 443;
                            }
                            case 143: {
                                return 444;
                            }
                            case 144: {
                                return 445;
                            }
                            case 145: {
                                return 446;
                            }
                            case 146: {
                                return 447;
                            }
                            case 147: {
                                return 448;
                            }
                            case 148: {
                                return 2261;
                            }
                            case 149: {
                                return 450;
                            }
                            case 150: {
                                return 451;
                            }
                            case 151: {
                                return 452;
                            }
                            case 152: {
                                return 453;
                            }
                            case 153: {
                                return 454;
                            }
                            case 154: {
                                return 455;
                            }
                            case 155: {
                                return 456;
                            }
                            case 156: {
                                return 2269;
                            }
                            case 157: {
                                return 458;
                            }
                            case 158: {
                                return 459;
                            }
                            case 159: {
                                return 460;
                            }
                            case 160: {
                                return 119;
                            }
                            case 161: {
                                return 120;
                            }
                            case 162: {
                                return 121;
                            }
                            case 163: {
                                return 122;
                            }
                            case 164: {
                                return 2176;
                            }
                            case 165: {
                                return 123;
                            }
                            case 166: {
                                return 124;
                            }
                            case 167: {
                                return 125;
                            }
                            case 168: {
                                return 461;
                            }
                            case 169: {
                                return 462;
                            }
                            case 170: {
                                return 463;
                            }
                            case 171: {
                                return 464;
                            }
                            case 172: {
                                return 2277;
                            }
                            case 173: {
                                return 466;
                            }
                            case 174: {
                                return 467;
                            }
                            case 175: {
                                return 468;
                            }
                            case 176: {
                                return 469;
                            }
                            case 177: {
                                return 470;
                            }
                            case 178: {
                                return 471;
                            }
                            case 179: {
                                return 472;
                            }
                            case 180: {
                                return 2285;
                            }
                            case 181: {
                                return 474;
                            }
                            case 182: {
                                return 475;
                            }
                            case 183: {
                                return 476;
                            }
                            case 184: {
                                return 477;
                            }
                            case 185: {
                                return 478;
                            }
                            case 186: {
                                return 479;
                            }
                            case 187: {
                                return 480;
                            }
                            case 188: {
                                return 2293;
                            }
                            case 189: {
                                return 482;
                            }
                            case 190: {
                                return 483;
                            }
                            case 191: {
                                return 484;
                            }
                            case 192: {
                                return 485;
                            }
                            case 193: {
                                return 486;
                            }
                            case 194: {
                                return 487;
                            }
                            case 195: {
                                return 488;
                            }
                            case 196: {
                                return 2301;
                            }
                            case 197: {
                                return 490;
                            }
                            case 198: {
                                return 491;
                            }
                            case 199: {
                                return 492;
                            }
                            case 200: {
                                return 493;
                            }
                            case 201: {
                                return 494;
                            }
                            case 202: {
                                return 495;
                            }
                            case 203: {
                                return 496;
                            }
                            case 204: {
                                return 2309;
                            }
                            case 205: {
                                return 498;
                            }
                            case 206: {
                                return 499;
                            }
                            case 207: {
                                return 500;
                            }
                            case 208: {
                                return 501;
                            }
                            case 209: {
                                return 502;
                            }
                            case 210: {
                                return 503;
                            }
                            case 211: {
                                return 504;
                            }
                            case 212: {
                                return 2317;
                            }
                            case 213: {
                                return 506;
                            }
                            case 214: {
                                return 507;
                            }
                            case 215: {
                                return 508;
                            }
                            case 216: {
                                return 509;
                            }
                            case 217: {
                                return 510;
                            }
                            case 218: {
                                return 511;
                            }
                            case 219: {
                                return 512;
                            }
                            case 220: {
                                return 2325;
                            }
                            case 221: {
                                return 514;
                            }
                            case 222: {
                                return 515;
                            }
                            case 223: {
                                return 516;
                            }
                            case 224: {
                                return 119;
                            }
                            case 225: {
                                return 120;
                            }
                            case 226: {
                                return 121;
                            }
                            case 227: {
                                return 122;
                            }
                            case 228: {
                                return 2176;
                            }
                            case 229: {
                                return 123;
                            }
                            case 230: {
                                return 124;
                            }
                            case 231: {
                                return 125;
                            }
                            case 232: {
                                return 517;
                            }
                            case 233: {
                                return 518;
                            }
                            case 234: {
                                return 519;
                            }
                            case 235: {
                                return 520;
                            }
                            case 236: {
                                return 2333;
                            }
                            case 237: {
                                return 522;
                            }
                            case 238: {
                                return 523;
                            }
                            case 239: {
                                return 524;
                            }
                            case 240: {
                                return 525;
                            }
                            case 241: {
                                return 526;
                            }
                            case 242: {
                                return 527;
                            }
                            case 243: {
                                return 528;
                            }
                            case 244: {
                                return 2341;
                            }
                            case 245: {
                                return 530;
                            }
                            case 246: {
                                return 531;
                            }
                            case 247: {
                                return 532;
                            }
                            case 248: {
                                return 533;
                            }
                            case 249: {
                                return 534;
                            }
                            case 250: {
                                return 535;
                            }
                            case 251: {
                                return 536;
                            }
                            case 252: {
                                return 2349;
                            }
                            case 253: {
                                return 538;
                            }
                            case 254: {
                                return 539;
                            }
                            case 255: 
                        }
                        return 540;
                    }
                    case 64: {
                        switch (n3) {
                            default: {
                                return -1;
                            }
                            case 0: {
                                return 541;
                            }
                            case 1: {
                                return 542;
                            }
                            case 2: {
                                return 543;
                            }
                            case 3: {
                                return 544;
                            }
                            case 4: {
                                return 2357;
                            }
                            case 5: {
                                return 2358;
                            }
                            case 6: {
                                return 547;
                            }
                            case 7: {
                                return 548;
                            }
                            case 8: {
                                return 542;
                            }
                            case 9: {
                                return 549;
                            }
                            case 10: {
                                return 550;
                            }
                            case 11: {
                                return 551;
                            }
                            case 12: {
                                return 2364;
                            }
                            case 13: {
                                return 2365;
                            }
                            case 14: {
                                return 554;
                            }
                            case 15: {
                                return 555;
                            }
                            case 16: {
                                return 543;
                            }
                            case 17: {
                                return 550;
                            }
                            case 18: {
                                return 556;
                            }
                            case 19: {
                                return 557;
                            }
                            case 20: {
                                return 2370;
                            }
                            case 21: {
                                return 2371;
                            }
                            case 22: {
                                return 560;
                            }
                            case 23: {
                                return 561;
                            }
                            case 24: {
                                return 544;
                            }
                            case 25: {
                                return 551;
                            }
                            case 26: {
                                return 557;
                            }
                            case 27: {
                                return 562;
                            }
                            case 28: {
                                return 2375;
                            }
                            case 29: {
                                return 2376;
                            }
                            case 30: {
                                return 565;
                            }
                            case 31: {
                                return 566;
                            }
                            case 32: {
                                return 126;
                            }
                            case 33: {
                                return 127;
                            }
                            case 34: {
                                return 128;
                            }
                            case 35: {
                                return 129;
                            }
                            case 36: {
                                return 2379;
                            }
                            case 37: {
                                return 109;
                            }
                            case 38: {
                                return 131;
                            }
                            case 39: {
                                return 132;
                            }
                            case 40: {
                                return 546;
                            }
                            case 41: {
                                return 553;
                            }
                            case 42: {
                                return 559;
                            }
                            case 43: {
                                return 564;
                            }
                            case 44: {
                                return 2380;
                            }
                            case 45: {
                                return 2381;
                            }
                            case 46: {
                                return 570;
                            }
                            case 47: {
                                return 571;
                            }
                            case 48: {
                                return 547;
                            }
                            case 49: {
                                return 554;
                            }
                            case 50: {
                                return 560;
                            }
                            case 51: {
                                return 565;
                            }
                            case 52: {
                                return 2384;
                            }
                            case 53: {
                                return 2382;
                            }
                            case 54: {
                                return 573;
                            }
                            case 55: {
                                return 574;
                            }
                            case 56: {
                                return 548;
                            }
                            case 57: {
                                return 555;
                            }
                            case 58: {
                                return 561;
                            }
                            case 59: {
                                return 566;
                            }
                            case 60: {
                                return 2387;
                            }
                            case 61: {
                                return 2383;
                            }
                            case 62: {
                                return 574;
                            }
                            case 63: {
                                return 576;
                            }
                            case 64: {
                                return 577;
                            }
                            case 65: {
                                return 578;
                            }
                            case 66: {
                                return 579;
                            }
                            case 67: {
                                return 580;
                            }
                            case 68: {
                                return 2393;
                            }
                            case 69: {
                                return 2394;
                            }
                            case 70: {
                                return 583;
                            }
                            case 71: {
                                return 584;
                            }
                            case 72: {
                                return 585;
                            }
                            case 73: {
                                return 586;
                            }
                            case 74: {
                                return 587;
                            }
                            case 75: {
                                return 588;
                            }
                            case 76: {
                                return 2401;
                            }
                            case 77: {
                                return 2402;
                            }
                            case 78: {
                                return 591;
                            }
                            case 79: {
                                return 592;
                            }
                            case 80: {
                                return 593;
                            }
                            case 81: {
                                return 594;
                            }
                            case 82: {
                                return 595;
                            }
                            case 83: {
                                return 596;
                            }
                            case 84: {
                                return 2409;
                            }
                            case 85: {
                                return 2410;
                            }
                            case 86: {
                                return 599;
                            }
                            case 87: {
                                return 600;
                            }
                            case 88: {
                                return 601;
                            }
                            case 89: {
                                return 602;
                            }
                            case 90: {
                                return 603;
                            }
                            case 91: {
                                return 604;
                            }
                            case 92: {
                                return 2417;
                            }
                            case 93: {
                                return 2418;
                            }
                            case 94: {
                                return 607;
                            }
                            case 95: {
                                return 608;
                            }
                            case 96: {
                                return 126;
                            }
                            case 97: {
                                return 127;
                            }
                            case 98: {
                                return 128;
                            }
                            case 99: {
                                return 129;
                            }
                            case 100: {
                                return 2379;
                            }
                            case 101: {
                                return 109;
                            }
                            case 102: {
                                return 131;
                            }
                            case 103: {
                                return 132;
                            }
                            case 104: {
                                return 609;
                            }
                            case 105: {
                                return 610;
                            }
                            case 106: {
                                return 611;
                            }
                            case 107: {
                                return 612;
                            }
                            case 108: {
                                return 2425;
                            }
                            case 109: {
                                return 2426;
                            }
                            case 110: {
                                return 615;
                            }
                            case 111: {
                                return 616;
                            }
                            case 112: {
                                return 617;
                            }
                            case 113: {
                                return 618;
                            }
                            case 114: {
                                return 619;
                            }
                            case 115: {
                                return 620;
                            }
                            case 116: {
                                return 2433;
                            }
                            case 117: {
                                return 2434;
                            }
                            case 118: {
                                return 623;
                            }
                            case 119: {
                                return 624;
                            }
                            case 120: {
                                return 625;
                            }
                            case 121: {
                                return 626;
                            }
                            case 122: {
                                return 627;
                            }
                            case 123: {
                                return 628;
                            }
                            case 124: {
                                return 2441;
                            }
                            case 125: {
                                return 2442;
                            }
                            case 126: {
                                return 631;
                            }
                            case 127: {
                                return 632;
                            }
                            case 128: {
                                return 633;
                            }
                            case 129: {
                                return 634;
                            }
                            case 130: {
                                return 635;
                            }
                            case 131: {
                                return 636;
                            }
                            case 132: {
                                return 2449;
                            }
                            case 133: {
                                return 2450;
                            }
                            case 134: {
                                return 639;
                            }
                            case 135: {
                                return 640;
                            }
                            case 136: {
                                return 641;
                            }
                            case 137: {
                                return 642;
                            }
                            case 138: {
                                return 643;
                            }
                            case 139: {
                                return 644;
                            }
                            case 140: {
                                return 2457;
                            }
                            case 141: {
                                return 2458;
                            }
                            case 142: {
                                return 647;
                            }
                            case 143: {
                                return 648;
                            }
                            case 144: {
                                return 649;
                            }
                            case 145: {
                                return 650;
                            }
                            case 146: {
                                return 651;
                            }
                            case 147: {
                                return 652;
                            }
                            case 148: {
                                return 2465;
                            }
                            case 149: {
                                return 2466;
                            }
                            case 150: {
                                return 655;
                            }
                            case 151: {
                                return 656;
                            }
                            case 152: {
                                return 657;
                            }
                            case 153: {
                                return 658;
                            }
                            case 154: {
                                return 659;
                            }
                            case 155: {
                                return 660;
                            }
                            case 156: {
                                return 2473;
                            }
                            case 157: {
                                return 2474;
                            }
                            case 158: {
                                return 663;
                            }
                            case 159: {
                                return 664;
                            }
                            case 160: {
                                return 126;
                            }
                            case 161: {
                                return 127;
                            }
                            case 162: {
                                return 128;
                            }
                            case 163: {
                                return 129;
                            }
                            case 164: {
                                return 2379;
                            }
                            case 165: {
                                return 109;
                            }
                            case 166: {
                                return 131;
                            }
                            case 167: {
                                return 132;
                            }
                            case 168: {
                                return 665;
                            }
                            case 169: {
                                return 666;
                            }
                            case 170: {
                                return 667;
                            }
                            case 171: {
                                return 668;
                            }
                            case 172: {
                                return 2481;
                            }
                            case 173: {
                                return 2482;
                            }
                            case 174: {
                                return 671;
                            }
                            case 175: {
                                return 672;
                            }
                            case 176: {
                                return 673;
                            }
                            case 177: {
                                return 674;
                            }
                            case 178: {
                                return 675;
                            }
                            case 179: {
                                return 676;
                            }
                            case 180: {
                                return 2489;
                            }
                            case 181: {
                                return 2490;
                            }
                            case 182: {
                                return 679;
                            }
                            case 183: {
                                return 680;
                            }
                            case 184: {
                                return 681;
                            }
                            case 185: {
                                return 682;
                            }
                            case 186: {
                                return 683;
                            }
                            case 187: {
                                return 684;
                            }
                            case 188: {
                                return 2497;
                            }
                            case 189: {
                                return 2498;
                            }
                            case 190: {
                                return 687;
                            }
                            case 191: {
                                return 688;
                            }
                            case 192: {
                                return 689;
                            }
                            case 193: {
                                return 690;
                            }
                            case 194: {
                                return 691;
                            }
                            case 195: {
                                return 692;
                            }
                            case 196: {
                                return 2505;
                            }
                            case 197: {
                                return 2506;
                            }
                            case 198: {
                                return 695;
                            }
                            case 199: {
                                return 696;
                            }
                            case 200: {
                                return 697;
                            }
                            case 201: {
                                return 698;
                            }
                            case 202: {
                                return 699;
                            }
                            case 203: {
                                return 700;
                            }
                            case 204: {
                                return 2513;
                            }
                            case 205: {
                                return 2514;
                            }
                            case 206: {
                                return 703;
                            }
                            case 207: {
                                return 704;
                            }
                            case 208: {
                                return 705;
                            }
                            case 209: {
                                return 706;
                            }
                            case 210: {
                                return 707;
                            }
                            case 211: {
                                return 708;
                            }
                            case 212: {
                                return 2521;
                            }
                            case 213: {
                                return 2522;
                            }
                            case 214: {
                                return 711;
                            }
                            case 215: {
                                return 712;
                            }
                            case 216: {
                                return 713;
                            }
                            case 217: {
                                return 714;
                            }
                            case 218: {
                                return 715;
                            }
                            case 219: {
                                return 716;
                            }
                            case 220: {
                                return 2529;
                            }
                            case 221: {
                                return 2530;
                            }
                            case 222: {
                                return 719;
                            }
                            case 223: {
                                return 720;
                            }
                            case 224: {
                                return 126;
                            }
                            case 225: {
                                return 127;
                            }
                            case 226: {
                                return 128;
                            }
                            case 227: {
                                return 129;
                            }
                            case 228: {
                                return 2379;
                            }
                            case 229: {
                                return 109;
                            }
                            case 230: {
                                return 131;
                            }
                            case 231: {
                                return 132;
                            }
                            case 232: {
                                return 721;
                            }
                            case 233: {
                                return 722;
                            }
                            case 234: {
                                return 723;
                            }
                            case 235: {
                                return 724;
                            }
                            case 236: {
                                return 2537;
                            }
                            case 237: {
                                return 2538;
                            }
                            case 238: {
                                return 727;
                            }
                            case 239: {
                                return 728;
                            }
                            case 240: {
                                return 729;
                            }
                            case 241: {
                                return 730;
                            }
                            case 242: {
                                return 731;
                            }
                            case 243: {
                                return 732;
                            }
                            case 244: {
                                return 2545;
                            }
                            case 245: {
                                return 2546;
                            }
                            case 246: {
                                return 735;
                            }
                            case 247: {
                                return 736;
                            }
                            case 248: {
                                return 737;
                            }
                            case 249: {
                                return 738;
                            }
                            case 250: {
                                return 739;
                            }
                            case 251: {
                                return 740;
                            }
                            case 252: {
                                return 2553;
                            }
                            case 253: {
                                return 2554;
                            }
                            case 254: {
                                return 743;
                            }
                            case 255: 
                        }
                        return 744;
                    }
                    case 128: 
                }
                switch (n3) {
                    default: {
                        return -1;
                    }
                    case 0: {
                        return 378;
                    }
                    case 1: {
                        return 745;
                    }
                    case 2: {
                        return 746;
                    }
                    case 3: {
                        return 747;
                    }
                    case 4: {
                        return 2560;
                    }
                    case 5: {
                        return 2561;
                    }
                    case 6: {
                        return 750;
                    }
                    case 7: {
                        return 751;
                    }
                    case 8: {
                        return 745;
                    }
                    case 9: {
                        return 386;
                    }
                    case 10: {
                        return 752;
                    }
                    case 11: {
                        return 753;
                    }
                    case 12: {
                        return 2566;
                    }
                    case 13: {
                        return 2567;
                    }
                    case 14: {
                        return 756;
                    }
                    case 15: {
                        return 757;
                    }
                    case 16: {
                        return 746;
                    }
                    case 17: {
                        return 752;
                    }
                    case 18: {
                        return 394;
                    }
                    case 19: {
                        return 758;
                    }
                    case 20: {
                        return 2571;
                    }
                    case 21: {
                        return 2572;
                    }
                    case 22: {
                        return 761;
                    }
                    case 23: {
                        return 762;
                    }
                    case 24: {
                        return 747;
                    }
                    case 25: {
                        return 753;
                    }
                    case 26: {
                        return 758;
                    }
                    case 27: {
                        return 402;
                    }
                    case 28: {
                        return 2575;
                    }
                    case 29: {
                        return 2576;
                    }
                    case 30: {
                        return 765;
                    }
                    case 31: {
                        return 766;
                    }
                    case 32: {
                        return 133;
                    }
                    case 33: {
                        return 134;
                    }
                    case 34: {
                        return 135;
                    }
                    case 35: {
                        return 136;
                    }
                    case 36: {
                        return 2579;
                    }
                    case 37: {
                        return 116;
                    }
                    case 38: {
                        return 138;
                    }
                    case 39: {
                        return 139;
                    }
                    case 40: {
                        return 749;
                    }
                    case 41: {
                        return 755;
                    }
                    case 42: {
                        return 760;
                    }
                    case 43: {
                        return 764;
                    }
                    case 44: {
                        return 2580;
                    }
                    case 45: {
                        return 2222;
                    }
                    case 46: {
                        return 769;
                    }
                    case 47: {
                        return 770;
                    }
                    case 48: {
                        return 750;
                    }
                    case 49: {
                        return 756;
                    }
                    case 50: {
                        return 761;
                    }
                    case 51: {
                        return 765;
                    }
                    case 52: {
                        return 2583;
                    }
                    case 53: {
                        return 2581;
                    }
                    case 54: {
                        return 418;
                    }
                    case 55: {
                        return 772;
                    }
                    case 56: {
                        return 751;
                    }
                    case 57: {
                        return 757;
                    }
                    case 58: {
                        return 762;
                    }
                    case 59: {
                        return 766;
                    }
                    case 60: {
                        return 2585;
                    }
                    case 61: {
                        return 2582;
                    }
                    case 62: {
                        return 772;
                    }
                    case 63: {
                        return 426;
                    }
                    case 64: {
                        return 774;
                    }
                    case 65: {
                        return 775;
                    }
                    case 66: {
                        return 776;
                    }
                    case 67: {
                        return 777;
                    }
                    case 68: {
                        return 2590;
                    }
                    case 69: {
                        return 2591;
                    }
                    case 70: {
                        return 780;
                    }
                    case 71: {
                        return 781;
                    }
                    case 72: {
                        return 782;
                    }
                    case 73: {
                        return 783;
                    }
                    case 74: {
                        return 784;
                    }
                    case 75: {
                        return 785;
                    }
                    case 76: {
                        return 2598;
                    }
                    case 77: {
                        return 2599;
                    }
                    case 78: {
                        return 788;
                    }
                    case 79: {
                        return 789;
                    }
                    case 80: {
                        return 790;
                    }
                    case 81: {
                        return 791;
                    }
                    case 82: {
                        return 792;
                    }
                    case 83: {
                        return 793;
                    }
                    case 84: {
                        return 2606;
                    }
                    case 85: {
                        return 2607;
                    }
                    case 86: {
                        return 796;
                    }
                    case 87: {
                        return 797;
                    }
                    case 88: {
                        return 798;
                    }
                    case 89: {
                        return 799;
                    }
                    case 90: {
                        return 800;
                    }
                    case 91: {
                        return 801;
                    }
                    case 92: {
                        return 2614;
                    }
                    case 93: {
                        return 2615;
                    }
                    case 94: {
                        return 804;
                    }
                    case 95: {
                        return 805;
                    }
                    case 96: {
                        return 133;
                    }
                    case 97: {
                        return 134;
                    }
                    case 98: {
                        return 135;
                    }
                    case 99: {
                        return 136;
                    }
                    case 100: {
                        return 2579;
                    }
                    case 101: {
                        return 116;
                    }
                    case 102: {
                        return 138;
                    }
                    case 103: {
                        return 139;
                    }
                    case 104: {
                        return 806;
                    }
                    case 105: {
                        return 807;
                    }
                    case 106: {
                        return 808;
                    }
                    case 107: {
                        return 809;
                    }
                    case 108: {
                        return 2622;
                    }
                    case 109: {
                        return 2623;
                    }
                    case 110: {
                        return 812;
                    }
                    case 111: {
                        return 813;
                    }
                    case 112: {
                        return 814;
                    }
                    case 113: {
                        return 815;
                    }
                    case 114: {
                        return 816;
                    }
                    case 115: {
                        return 817;
                    }
                    case 116: {
                        return 2630;
                    }
                    case 117: {
                        return 2631;
                    }
                    case 118: {
                        return 820;
                    }
                    case 119: {
                        return 821;
                    }
                    case 120: {
                        return 822;
                    }
                    case 121: {
                        return 823;
                    }
                    case 122: {
                        return 824;
                    }
                    case 123: {
                        return 825;
                    }
                    case 124: {
                        return 2638;
                    }
                    case 125: {
                        return 2639;
                    }
                    case 126: {
                        return 828;
                    }
                    case 127: {
                        return 829;
                    }
                    case 128: {
                        return 830;
                    }
                    case 129: {
                        return 831;
                    }
                    case 130: {
                        return 832;
                    }
                    case 131: {
                        return 833;
                    }
                    case 132: {
                        return 2646;
                    }
                    case 133: {
                        return 2647;
                    }
                    case 134: {
                        return 836;
                    }
                    case 135: {
                        return 837;
                    }
                    case 136: {
                        return 838;
                    }
                    case 137: {
                        return 839;
                    }
                    case 138: {
                        return 840;
                    }
                    case 139: {
                        return 841;
                    }
                    case 140: {
                        return 2654;
                    }
                    case 141: {
                        return 2655;
                    }
                    case 142: {
                        return 844;
                    }
                    case 143: {
                        return 845;
                    }
                    case 144: {
                        return 846;
                    }
                    case 145: {
                        return 847;
                    }
                    case 146: {
                        return 848;
                    }
                    case 147: {
                        return 849;
                    }
                    case 148: {
                        return 2662;
                    }
                    case 149: {
                        return 2663;
                    }
                    case 150: {
                        return 852;
                    }
                    case 151: {
                        return 853;
                    }
                    case 152: {
                        return 854;
                    }
                    case 153: {
                        return 855;
                    }
                    case 154: {
                        return 856;
                    }
                    case 155: {
                        return 857;
                    }
                    case 156: {
                        return 2670;
                    }
                    case 157: {
                        return 2671;
                    }
                    case 158: {
                        return 860;
                    }
                    case 159: {
                        return 861;
                    }
                    case 160: {
                        return 133;
                    }
                    case 161: {
                        return 134;
                    }
                    case 162: {
                        return 135;
                    }
                    case 163: {
                        return 136;
                    }
                    case 164: {
                        return 2579;
                    }
                    case 165: {
                        return 116;
                    }
                    case 166: {
                        return 138;
                    }
                    case 167: {
                        return 139;
                    }
                    case 168: {
                        return 862;
                    }
                    case 169: {
                        return 863;
                    }
                    case 170: {
                        return 864;
                    }
                    case 171: {
                        return 865;
                    }
                    case 172: {
                        return 2678;
                    }
                    case 173: {
                        return 2679;
                    }
                    case 174: {
                        return 868;
                    }
                    case 175: {
                        return 869;
                    }
                    case 176: {
                        return 870;
                    }
                    case 177: {
                        return 871;
                    }
                    case 178: {
                        return 872;
                    }
                    case 179: {
                        return 873;
                    }
                    case 180: {
                        return 2686;
                    }
                    case 181: {
                        return 2687;
                    }
                    case 182: {
                        return 876;
                    }
                    case 183: {
                        return 877;
                    }
                    case 184: {
                        return 878;
                    }
                    case 185: {
                        return 879;
                    }
                    case 186: {
                        return 880;
                    }
                    case 187: {
                        return 881;
                    }
                    case 188: {
                        return 2694;
                    }
                    case 189: {
                        return 2695;
                    }
                    case 190: {
                        return 884;
                    }
                    case 191: {
                        return 885;
                    }
                    case 192: {
                        return 886;
                    }
                    case 193: {
                        return 887;
                    }
                    case 194: {
                        return 888;
                    }
                    case 195: {
                        return 889;
                    }
                    case 196: {
                        return 2702;
                    }
                    case 197: {
                        return 2703;
                    }
                    case 198: {
                        return 892;
                    }
                    case 199: {
                        return 893;
                    }
                    case 200: {
                        return 894;
                    }
                    case 201: {
                        return 895;
                    }
                    case 202: {
                        return 896;
                    }
                    case 203: {
                        return 897;
                    }
                    case 204: {
                        return 2710;
                    }
                    case 205: {
                        return 2711;
                    }
                    case 206: {
                        return 900;
                    }
                    case 207: {
                        return 901;
                    }
                    case 208: {
                        return 902;
                    }
                    case 209: {
                        return 903;
                    }
                    case 210: {
                        return 904;
                    }
                    case 211: {
                        return 905;
                    }
                    case 212: {
                        return 2718;
                    }
                    case 213: {
                        return 2719;
                    }
                    case 214: {
                        return 908;
                    }
                    case 215: {
                        return 909;
                    }
                    case 216: {
                        return 910;
                    }
                    case 217: {
                        return 911;
                    }
                    case 218: {
                        return 912;
                    }
                    case 219: {
                        return 913;
                    }
                    case 220: {
                        return 2726;
                    }
                    case 221: {
                        return 2727;
                    }
                    case 222: {
                        return 916;
                    }
                    case 223: {
                        return 917;
                    }
                    case 224: {
                        return 133;
                    }
                    case 225: {
                        return 134;
                    }
                    case 226: {
                        return 135;
                    }
                    case 227: {
                        return 136;
                    }
                    case 228: {
                        return 2579;
                    }
                    case 229: {
                        return 116;
                    }
                    case 230: {
                        return 138;
                    }
                    case 231: {
                        return 139;
                    }
                    case 232: {
                        return 918;
                    }
                    case 233: {
                        return 919;
                    }
                    case 234: {
                        return 920;
                    }
                    case 235: {
                        return 921;
                    }
                    case 236: {
                        return 2734;
                    }
                    case 237: {
                        return 2735;
                    }
                    case 238: {
                        return 924;
                    }
                    case 239: {
                        return 925;
                    }
                    case 240: {
                        return 926;
                    }
                    case 241: {
                        return 927;
                    }
                    case 242: {
                        return 928;
                    }
                    case 243: {
                        return 929;
                    }
                    case 244: {
                        return 2742;
                    }
                    case 245: {
                        return 2743;
                    }
                    case 246: {
                        return 932;
                    }
                    case 247: {
                        return 933;
                    }
                    case 248: {
                        return 934;
                    }
                    case 249: {
                        return 935;
                    }
                    case 250: {
                        return 936;
                    }
                    case 251: {
                        return 937;
                    }
                    case 252: {
                        return 2750;
                    }
                    case 253: {
                        return 2751;
                    }
                    case 254: {
                        return 940;
                    }
                    case 255: 
                }
                return 941;
            }
            case 4: {
                switch (n2 & 0xC0) {
                    default: {
                        return -1;
                    }
                    case 0: {
                        switch (n3) {
                            default: {
                                return -1;
                            }
                            case 0: {
                                return 338;
                            }
                            case 1: {
                                return 339;
                            }
                            case 2: {
                                return 340;
                            }
                            case 3: {
                                return 341;
                            }
                            case 4: {
                                return 342;
                            }
                            case 5: {
                                return 133;
                            }
                            case 6: {
                                return 344;
                            }
                            case 7: {
                                return 345;
                            }
                            case 8: {
                                return 339;
                            }
                            case 9: {
                                return 346;
                            }
                            case 10: {
                                return 347;
                            }
                            case 11: {
                                return 348;
                            }
                            case 12: {
                                return 349;
                            }
                            case 13: {
                                return 134;
                            }
                            case 14: {
                                return 351;
                            }
                            case 15: {
                                return 352;
                            }
                            case 16: {
                                return 340;
                            }
                            case 17: {
                                return 347;
                            }
                            case 18: {
                                return 353;
                            }
                            case 19: {
                                return 354;
                            }
                            case 20: {
                                return 355;
                            }
                            case 21: {
                                return 135;
                            }
                            case 22: {
                                return 357;
                            }
                            case 23: {
                                return 358;
                            }
                            case 24: {
                                return 341;
                            }
                            case 25: {
                                return 348;
                            }
                            case 26: {
                                return 354;
                            }
                            case 27: {
                                return 359;
                            }
                            case 28: {
                                return 360;
                            }
                            case 29: {
                                return 136;
                            }
                            case 30: {
                                return 362;
                            }
                            case 31: {
                                return 363;
                            }
                            case 32: {
                                return 119;
                            }
                            case 33: {
                                return 120;
                            }
                            case 34: {
                                return 121;
                            }
                            case 35: {
                                return 122;
                            }
                            case 36: {
                                return 364;
                            }
                            case 37: {
                                return 123;
                            }
                            case 38: {
                                return 124;
                            }
                            case 39: {
                                return 125;
                            }
                            case 40: {
                                return 343;
                            }
                            case 41: {
                                return 350;
                            }
                            case 42: {
                                return 356;
                            }
                            case 43: {
                                return 361;
                            }
                            case 44: {
                                return 365;
                            }
                            case 45: {
                                return 137;
                            }
                            case 46: {
                                return 366;
                            }
                            case 47: {
                                return 367;
                            }
                            case 48: {
                                return 344;
                            }
                            case 49: {
                                return 351;
                            }
                            case 50: {
                                return 357;
                            }
                            case 51: {
                                return 362;
                            }
                            case 52: {
                                return 368;
                            }
                            case 53: {
                                return 138;
                            }
                            case 54: {
                                return 369;
                            }
                            case 55: {
                                return 370;
                            }
                            case 56: {
                                return 345;
                            }
                            case 57: {
                                return 352;
                            }
                            case 58: {
                                return 358;
                            }
                            case 59: {
                                return 363;
                            }
                            case 60: {
                                return 371;
                            }
                            case 61: {
                                return 139;
                            }
                            case 62: {
                                return 370;
                            }
                            case 63: {
                                return 372;
                            }
                            case 64: {
                                return 373;
                            }
                            case 65: {
                                return 374;
                            }
                            case 66: {
                                return 375;
                            }
                            case 67: {
                                return 376;
                            }
                            case 68: {
                                return 377;
                            }
                            case 69: {
                                return 378;
                            }
                            case 70: {
                                return 379;
                            }
                            case 71: {
                                return 380;
                            }
                            case 72: {
                                return 381;
                            }
                            case 73: {
                                return 382;
                            }
                            case 74: {
                                return 383;
                            }
                            case 75: {
                                return 384;
                            }
                            case 76: {
                                return 385;
                            }
                            case 77: {
                                return 386;
                            }
                            case 78: {
                                return 387;
                            }
                            case 79: {
                                return 388;
                            }
                            case 80: {
                                return 389;
                            }
                            case 81: {
                                return 390;
                            }
                            case 82: {
                                return 391;
                            }
                            case 83: {
                                return 392;
                            }
                            case 84: {
                                return 393;
                            }
                            case 85: {
                                return 394;
                            }
                            case 86: {
                                return 395;
                            }
                            case 87: {
                                return 396;
                            }
                            case 88: {
                                return 397;
                            }
                            case 89: {
                                return 398;
                            }
                            case 90: {
                                return 399;
                            }
                            case 91: {
                                return 400;
                            }
                            case 92: {
                                return 401;
                            }
                            case 93: {
                                return 402;
                            }
                            case 94: {
                                return 403;
                            }
                            case 95: {
                                return 404;
                            }
                            case 96: {
                                return 119;
                            }
                            case 97: {
                                return 120;
                            }
                            case 98: {
                                return 121;
                            }
                            case 99: {
                                return 122;
                            }
                            case 100: {
                                return 364;
                            }
                            case 101: {
                                return 123;
                            }
                            case 102: {
                                return 124;
                            }
                            case 103: {
                                return 125;
                            }
                            case 104: {
                                return 405;
                            }
                            case 105: {
                                return 406;
                            }
                            case 106: {
                                return 407;
                            }
                            case 107: {
                                return 408;
                            }
                            case 108: {
                                return 409;
                            }
                            case 109: {
                                return 410;
                            }
                            case 110: {
                                return 411;
                            }
                            case 111: {
                                return 412;
                            }
                            case 112: {
                                return 413;
                            }
                            case 113: {
                                return 414;
                            }
                            case 114: {
                                return 415;
                            }
                            case 115: {
                                return 416;
                            }
                            case 116: {
                                return 417;
                            }
                            case 117: {
                                return 418;
                            }
                            case 118: {
                                return 419;
                            }
                            case 119: {
                                return 420;
                            }
                            case 120: {
                                return 421;
                            }
                            case 121: {
                                return 422;
                            }
                            case 122: {
                                return 423;
                            }
                            case 123: {
                                return 424;
                            }
                            case 124: {
                                return 425;
                            }
                            case 125: {
                                return 426;
                            }
                            case 126: {
                                return 427;
                            }
                            case 127: {
                                return 428;
                            }
                            case 128: {
                                return 429;
                            }
                            case 129: {
                                return 430;
                            }
                            case 130: {
                                return 431;
                            }
                            case 131: {
                                return 432;
                            }
                            case 132: {
                                return 433;
                            }
                            case 133: {
                                return 434;
                            }
                            case 134: {
                                return 435;
                            }
                            case 135: {
                                return 436;
                            }
                            case 136: {
                                return 437;
                            }
                            case 137: {
                                return 438;
                            }
                            case 138: {
                                return 439;
                            }
                            case 139: {
                                return 440;
                            }
                            case 140: {
                                return 441;
                            }
                            case 141: {
                                return 442;
                            }
                            case 142: {
                                return 443;
                            }
                            case 143: {
                                return 444;
                            }
                            case 144: {
                                return 445;
                            }
                            case 145: {
                                return 446;
                            }
                            case 146: {
                                return 447;
                            }
                            case 147: {
                                return 448;
                            }
                            case 148: {
                                return 449;
                            }
                            case 149: {
                                return 450;
                            }
                            case 150: {
                                return 451;
                            }
                            case 151: {
                                return 452;
                            }
                            case 152: {
                                return 453;
                            }
                            case 153: {
                                return 454;
                            }
                            case 154: {
                                return 455;
                            }
                            case 155: {
                                return 456;
                            }
                            case 156: {
                                return 457;
                            }
                            case 157: {
                                return 458;
                            }
                            case 158: {
                                return 459;
                            }
                            case 159: {
                                return 460;
                            }
                            case 160: {
                                return 119;
                            }
                            case 161: {
                                return 120;
                            }
                            case 162: {
                                return 121;
                            }
                            case 163: {
                                return 122;
                            }
                            case 164: {
                                return 364;
                            }
                            case 165: {
                                return 123;
                            }
                            case 166: {
                                return 124;
                            }
                            case 167: {
                                return 125;
                            }
                            case 168: {
                                return 461;
                            }
                            case 169: {
                                return 462;
                            }
                            case 170: {
                                return 463;
                            }
                            case 171: {
                                return 464;
                            }
                            case 172: {
                                return 465;
                            }
                            case 173: {
                                return 466;
                            }
                            case 174: {
                                return 467;
                            }
                            case 175: {
                                return 468;
                            }
                            case 176: {
                                return 469;
                            }
                            case 177: {
                                return 470;
                            }
                            case 178: {
                                return 471;
                            }
                            case 179: {
                                return 472;
                            }
                            case 180: {
                                return 473;
                            }
                            case 181: {
                                return 474;
                            }
                            case 182: {
                                return 475;
                            }
                            case 183: {
                                return 476;
                            }
                            case 184: {
                                return 477;
                            }
                            case 185: {
                                return 478;
                            }
                            case 186: {
                                return 479;
                            }
                            case 187: {
                                return 480;
                            }
                            case 188: {
                                return 481;
                            }
                            case 189: {
                                return 482;
                            }
                            case 190: {
                                return 483;
                            }
                            case 191: {
                                return 484;
                            }
                            case 192: {
                                return 485;
                            }
                            case 193: {
                                return 486;
                            }
                            case 194: {
                                return 487;
                            }
                            case 195: {
                                return 488;
                            }
                            case 196: {
                                return 489;
                            }
                            case 197: {
                                return 490;
                            }
                            case 198: {
                                return 491;
                            }
                            case 199: {
                                return 492;
                            }
                            case 200: {
                                return 493;
                            }
                            case 201: {
                                return 494;
                            }
                            case 202: {
                                return 495;
                            }
                            case 203: {
                                return 496;
                            }
                            case 204: {
                                return 497;
                            }
                            case 205: {
                                return 498;
                            }
                            case 206: {
                                return 499;
                            }
                            case 207: {
                                return 500;
                            }
                            case 208: {
                                return 501;
                            }
                            case 209: {
                                return 502;
                            }
                            case 210: {
                                return 503;
                            }
                            case 211: {
                                return 504;
                            }
                            case 212: {
                                return 505;
                            }
                            case 213: {
                                return 506;
                            }
                            case 214: {
                                return 507;
                            }
                            case 215: {
                                return 508;
                            }
                            case 216: {
                                return 509;
                            }
                            case 217: {
                                return 510;
                            }
                            case 218: {
                                return 511;
                            }
                            case 219: {
                                return 512;
                            }
                            case 220: {
                                return 513;
                            }
                            case 221: {
                                return 514;
                            }
                            case 222: {
                                return 515;
                            }
                            case 223: {
                                return 516;
                            }
                            case 224: {
                                return 119;
                            }
                            case 225: {
                                return 120;
                            }
                            case 226: {
                                return 121;
                            }
                            case 227: {
                                return 122;
                            }
                            case 228: {
                                return 364;
                            }
                            case 229: {
                                return 123;
                            }
                            case 230: {
                                return 124;
                            }
                            case 231: {
                                return 125;
                            }
                            case 232: {
                                return 517;
                            }
                            case 233: {
                                return 518;
                            }
                            case 234: {
                                return 519;
                            }
                            case 235: {
                                return 520;
                            }
                            case 236: {
                                return 521;
                            }
                            case 237: {
                                return 522;
                            }
                            case 238: {
                                return 523;
                            }
                            case 239: {
                                return 524;
                            }
                            case 240: {
                                return 525;
                            }
                            case 241: {
                                return 526;
                            }
                            case 242: {
                                return 527;
                            }
                            case 243: {
                                return 528;
                            }
                            case 244: {
                                return 529;
                            }
                            case 245: {
                                return 530;
                            }
                            case 246: {
                                return 531;
                            }
                            case 247: {
                                return 532;
                            }
                            case 248: {
                                return 533;
                            }
                            case 249: {
                                return 534;
                            }
                            case 250: {
                                return 535;
                            }
                            case 251: {
                                return 536;
                            }
                            case 252: {
                                return 537;
                            }
                            case 253: {
                                return 538;
                            }
                            case 254: {
                                return 539;
                            }
                            case 255: 
                        }
                        return 540;
                    }
                    case 64: {
                        switch (n3) {
                            default: {
                                return -1;
                            }
                            case 0: {
                                return 541;
                            }
                            case 1: {
                                return 542;
                            }
                            case 2: {
                                return 543;
                            }
                            case 3: {
                                return 544;
                            }
                            case 4: {
                                return 545;
                            }
                            case 5: {
                                return 546;
                            }
                            case 6: {
                                return 547;
                            }
                            case 7: {
                                return 548;
                            }
                            case 8: {
                                return 542;
                            }
                            case 9: {
                                return 549;
                            }
                            case 10: {
                                return 550;
                            }
                            case 11: {
                                return 551;
                            }
                            case 12: {
                                return 552;
                            }
                            case 13: {
                                return 553;
                            }
                            case 14: {
                                return 554;
                            }
                            case 15: {
                                return 555;
                            }
                            case 16: {
                                return 543;
                            }
                            case 17: {
                                return 550;
                            }
                            case 18: {
                                return 556;
                            }
                            case 19: {
                                return 557;
                            }
                            case 20: {
                                return 558;
                            }
                            case 21: {
                                return 559;
                            }
                            case 22: {
                                return 560;
                            }
                            case 23: {
                                return 561;
                            }
                            case 24: {
                                return 544;
                            }
                            case 25: {
                                return 551;
                            }
                            case 26: {
                                return 557;
                            }
                            case 27: {
                                return 562;
                            }
                            case 28: {
                                return 563;
                            }
                            case 29: {
                                return 564;
                            }
                            case 30: {
                                return 565;
                            }
                            case 31: {
                                return 566;
                            }
                            case 32: {
                                return 126;
                            }
                            case 33: {
                                return 127;
                            }
                            case 34: {
                                return 128;
                            }
                            case 35: {
                                return 129;
                            }
                            case 36: {
                                return 567;
                            }
                            case 37: {
                                return 130;
                            }
                            case 38: {
                                return 131;
                            }
                            case 39: {
                                return 132;
                            }
                            case 40: {
                                return 546;
                            }
                            case 41: {
                                return 553;
                            }
                            case 42: {
                                return 559;
                            }
                            case 43: {
                                return 564;
                            }
                            case 44: {
                                return 568;
                            }
                            case 45: {
                                return 569;
                            }
                            case 46: {
                                return 570;
                            }
                            case 47: {
                                return 571;
                            }
                            case 48: {
                                return 547;
                            }
                            case 49: {
                                return 554;
                            }
                            case 50: {
                                return 560;
                            }
                            case 51: {
                                return 565;
                            }
                            case 52: {
                                return 572;
                            }
                            case 53: {
                                return 570;
                            }
                            case 54: {
                                return 573;
                            }
                            case 55: {
                                return 574;
                            }
                            case 56: {
                                return 548;
                            }
                            case 57: {
                                return 555;
                            }
                            case 58: {
                                return 561;
                            }
                            case 59: {
                                return 566;
                            }
                            case 60: {
                                return 575;
                            }
                            case 61: {
                                return 571;
                            }
                            case 62: {
                                return 574;
                            }
                            case 63: {
                                return 576;
                            }
                            case 64: {
                                return 577;
                            }
                            case 65: {
                                return 578;
                            }
                            case 66: {
                                return 579;
                            }
                            case 67: {
                                return 580;
                            }
                            case 68: {
                                return 581;
                            }
                            case 69: {
                                return 582;
                            }
                            case 70: {
                                return 583;
                            }
                            case 71: {
                                return 584;
                            }
                            case 72: {
                                return 585;
                            }
                            case 73: {
                                return 586;
                            }
                            case 74: {
                                return 587;
                            }
                            case 75: {
                                return 588;
                            }
                            case 76: {
                                return 589;
                            }
                            case 77: {
                                return 590;
                            }
                            case 78: {
                                return 591;
                            }
                            case 79: {
                                return 592;
                            }
                            case 80: {
                                return 593;
                            }
                            case 81: {
                                return 594;
                            }
                            case 82: {
                                return 595;
                            }
                            case 83: {
                                return 596;
                            }
                            case 84: {
                                return 597;
                            }
                            case 85: {
                                return 598;
                            }
                            case 86: {
                                return 599;
                            }
                            case 87: {
                                return 600;
                            }
                            case 88: {
                                return 601;
                            }
                            case 89: {
                                return 602;
                            }
                            case 90: {
                                return 603;
                            }
                            case 91: {
                                return 604;
                            }
                            case 92: {
                                return 605;
                            }
                            case 93: {
                                return 606;
                            }
                            case 94: {
                                return 607;
                            }
                            case 95: {
                                return 608;
                            }
                            case 96: {
                                return 126;
                            }
                            case 97: {
                                return 127;
                            }
                            case 98: {
                                return 128;
                            }
                            case 99: {
                                return 129;
                            }
                            case 100: {
                                return 567;
                            }
                            case 101: {
                                return 130;
                            }
                            case 102: {
                                return 131;
                            }
                            case 103: {
                                return 132;
                            }
                            case 104: {
                                return 609;
                            }
                            case 105: {
                                return 610;
                            }
                            case 106: {
                                return 611;
                            }
                            case 107: {
                                return 612;
                            }
                            case 108: {
                                return 613;
                            }
                            case 109: {
                                return 614;
                            }
                            case 110: {
                                return 615;
                            }
                            case 111: {
                                return 616;
                            }
                            case 112: {
                                return 617;
                            }
                            case 113: {
                                return 618;
                            }
                            case 114: {
                                return 619;
                            }
                            case 115: {
                                return 620;
                            }
                            case 116: {
                                return 621;
                            }
                            case 117: {
                                return 622;
                            }
                            case 118: {
                                return 623;
                            }
                            case 119: {
                                return 624;
                            }
                            case 120: {
                                return 625;
                            }
                            case 121: {
                                return 626;
                            }
                            case 122: {
                                return 627;
                            }
                            case 123: {
                                return 628;
                            }
                            case 124: {
                                return 629;
                            }
                            case 125: {
                                return 630;
                            }
                            case 126: {
                                return 631;
                            }
                            case 127: {
                                return 632;
                            }
                            case 128: {
                                return 633;
                            }
                            case 129: {
                                return 634;
                            }
                            case 130: {
                                return 635;
                            }
                            case 131: {
                                return 636;
                            }
                            case 132: {
                                return 637;
                            }
                            case 133: {
                                return 638;
                            }
                            case 134: {
                                return 639;
                            }
                            case 135: {
                                return 640;
                            }
                            case 136: {
                                return 641;
                            }
                            case 137: {
                                return 642;
                            }
                            case 138: {
                                return 643;
                            }
                            case 139: {
                                return 644;
                            }
                            case 140: {
                                return 645;
                            }
                            case 141: {
                                return 646;
                            }
                            case 142: {
                                return 647;
                            }
                            case 143: {
                                return 648;
                            }
                            case 144: {
                                return 649;
                            }
                            case 145: {
                                return 650;
                            }
                            case 146: {
                                return 651;
                            }
                            case 147: {
                                return 652;
                            }
                            case 148: {
                                return 653;
                            }
                            case 149: {
                                return 654;
                            }
                            case 150: {
                                return 655;
                            }
                            case 151: {
                                return 656;
                            }
                            case 152: {
                                return 657;
                            }
                            case 153: {
                                return 658;
                            }
                            case 154: {
                                return 659;
                            }
                            case 155: {
                                return 660;
                            }
                            case 156: {
                                return 661;
                            }
                            case 157: {
                                return 662;
                            }
                            case 158: {
                                return 663;
                            }
                            case 159: {
                                return 664;
                            }
                            case 160: {
                                return 126;
                            }
                            case 161: {
                                return 127;
                            }
                            case 162: {
                                return 128;
                            }
                            case 163: {
                                return 129;
                            }
                            case 164: {
                                return 567;
                            }
                            case 165: {
                                return 130;
                            }
                            case 166: {
                                return 131;
                            }
                            case 167: {
                                return 132;
                            }
                            case 168: {
                                return 665;
                            }
                            case 169: {
                                return 666;
                            }
                            case 170: {
                                return 667;
                            }
                            case 171: {
                                return 668;
                            }
                            case 172: {
                                return 669;
                            }
                            case 173: {
                                return 670;
                            }
                            case 174: {
                                return 671;
                            }
                            case 175: {
                                return 672;
                            }
                            case 176: {
                                return 673;
                            }
                            case 177: {
                                return 674;
                            }
                            case 178: {
                                return 675;
                            }
                            case 179: {
                                return 676;
                            }
                            case 180: {
                                return 677;
                            }
                            case 181: {
                                return 678;
                            }
                            case 182: {
                                return 679;
                            }
                            case 183: {
                                return 680;
                            }
                            case 184: {
                                return 681;
                            }
                            case 185: {
                                return 682;
                            }
                            case 186: {
                                return 683;
                            }
                            case 187: {
                                return 684;
                            }
                            case 188: {
                                return 685;
                            }
                            case 189: {
                                return 686;
                            }
                            case 190: {
                                return 687;
                            }
                            case 191: {
                                return 688;
                            }
                            case 192: {
                                return 689;
                            }
                            case 193: {
                                return 690;
                            }
                            case 194: {
                                return 691;
                            }
                            case 195: {
                                return 692;
                            }
                            case 196: {
                                return 693;
                            }
                            case 197: {
                                return 694;
                            }
                            case 198: {
                                return 695;
                            }
                            case 199: {
                                return 696;
                            }
                            case 200: {
                                return 697;
                            }
                            case 201: {
                                return 698;
                            }
                            case 202: {
                                return 699;
                            }
                            case 203: {
                                return 700;
                            }
                            case 204: {
                                return 701;
                            }
                            case 205: {
                                return 702;
                            }
                            case 206: {
                                return 703;
                            }
                            case 207: {
                                return 704;
                            }
                            case 208: {
                                return 705;
                            }
                            case 209: {
                                return 706;
                            }
                            case 210: {
                                return 707;
                            }
                            case 211: {
                                return 708;
                            }
                            case 212: {
                                return 709;
                            }
                            case 213: {
                                return 710;
                            }
                            case 214: {
                                return 711;
                            }
                            case 215: {
                                return 712;
                            }
                            case 216: {
                                return 713;
                            }
                            case 217: {
                                return 714;
                            }
                            case 218: {
                                return 715;
                            }
                            case 219: {
                                return 716;
                            }
                            case 220: {
                                return 717;
                            }
                            case 221: {
                                return 718;
                            }
                            case 222: {
                                return 719;
                            }
                            case 223: {
                                return 720;
                            }
                            case 224: {
                                return 126;
                            }
                            case 225: {
                                return 127;
                            }
                            case 226: {
                                return 128;
                            }
                            case 227: {
                                return 129;
                            }
                            case 228: {
                                return 567;
                            }
                            case 229: {
                                return 130;
                            }
                            case 230: {
                                return 131;
                            }
                            case 231: {
                                return 132;
                            }
                            case 232: {
                                return 721;
                            }
                            case 233: {
                                return 722;
                            }
                            case 234: {
                                return 723;
                            }
                            case 235: {
                                return 724;
                            }
                            case 236: {
                                return 725;
                            }
                            case 237: {
                                return 726;
                            }
                            case 238: {
                                return 727;
                            }
                            case 239: {
                                return 728;
                            }
                            case 240: {
                                return 729;
                            }
                            case 241: {
                                return 730;
                            }
                            case 242: {
                                return 731;
                            }
                            case 243: {
                                return 732;
                            }
                            case 244: {
                                return 733;
                            }
                            case 245: {
                                return 734;
                            }
                            case 246: {
                                return 735;
                            }
                            case 247: {
                                return 736;
                            }
                            case 248: {
                                return 737;
                            }
                            case 249: {
                                return 738;
                            }
                            case 250: {
                                return 739;
                            }
                            case 251: {
                                return 740;
                            }
                            case 252: {
                                return 741;
                            }
                            case 253: {
                                return 742;
                            }
                            case 254: {
                                return 743;
                            }
                            case 255: 
                        }
                        return 744;
                    }
                    case 128: 
                }
                switch (n3) {
                    default: {
                        return -1;
                    }
                    case 0: {
                        return 378;
                    }
                    case 1: {
                        return 745;
                    }
                    case 2: {
                        return 746;
                    }
                    case 3: {
                        return 747;
                    }
                    case 4: {
                        return 748;
                    }
                    case 5: {
                        return 749;
                    }
                    case 6: {
                        return 750;
                    }
                    case 7: {
                        return 751;
                    }
                    case 8: {
                        return 745;
                    }
                    case 9: {
                        return 386;
                    }
                    case 10: {
                        return 752;
                    }
                    case 11: {
                        return 753;
                    }
                    case 12: {
                        return 754;
                    }
                    case 13: {
                        return 755;
                    }
                    case 14: {
                        return 756;
                    }
                    case 15: {
                        return 757;
                    }
                    case 16: {
                        return 746;
                    }
                    case 17: {
                        return 752;
                    }
                    case 18: {
                        return 394;
                    }
                    case 19: {
                        return 758;
                    }
                    case 20: {
                        return 759;
                    }
                    case 21: {
                        return 760;
                    }
                    case 22: {
                        return 761;
                    }
                    case 23: {
                        return 762;
                    }
                    case 24: {
                        return 747;
                    }
                    case 25: {
                        return 753;
                    }
                    case 26: {
                        return 758;
                    }
                    case 27: {
                        return 402;
                    }
                    case 28: {
                        return 763;
                    }
                    case 29: {
                        return 764;
                    }
                    case 30: {
                        return 765;
                    }
                    case 31: {
                        return 766;
                    }
                    case 32: {
                        return 133;
                    }
                    case 33: {
                        return 134;
                    }
                    case 34: {
                        return 135;
                    }
                    case 35: {
                        return 136;
                    }
                    case 36: {
                        return 767;
                    }
                    case 37: {
                        return 137;
                    }
                    case 38: {
                        return 138;
                    }
                    case 39: {
                        return 139;
                    }
                    case 40: {
                        return 749;
                    }
                    case 41: {
                        return 755;
                    }
                    case 42: {
                        return 760;
                    }
                    case 43: {
                        return 764;
                    }
                    case 44: {
                        return 768;
                    }
                    case 45: {
                        return 410;
                    }
                    case 46: {
                        return 769;
                    }
                    case 47: {
                        return 770;
                    }
                    case 48: {
                        return 750;
                    }
                    case 49: {
                        return 756;
                    }
                    case 50: {
                        return 761;
                    }
                    case 51: {
                        return 765;
                    }
                    case 52: {
                        return 771;
                    }
                    case 53: {
                        return 769;
                    }
                    case 54: {
                        return 418;
                    }
                    case 55: {
                        return 772;
                    }
                    case 56: {
                        return 751;
                    }
                    case 57: {
                        return 757;
                    }
                    case 58: {
                        return 762;
                    }
                    case 59: {
                        return 766;
                    }
                    case 60: {
                        return 773;
                    }
                    case 61: {
                        return 770;
                    }
                    case 62: {
                        return 772;
                    }
                    case 63: {
                        return 426;
                    }
                    case 64: {
                        return 774;
                    }
                    case 65: {
                        return 775;
                    }
                    case 66: {
                        return 776;
                    }
                    case 67: {
                        return 777;
                    }
                    case 68: {
                        return 778;
                    }
                    case 69: {
                        return 779;
                    }
                    case 70: {
                        return 780;
                    }
                    case 71: {
                        return 781;
                    }
                    case 72: {
                        return 782;
                    }
                    case 73: {
                        return 783;
                    }
                    case 74: {
                        return 784;
                    }
                    case 75: {
                        return 785;
                    }
                    case 76: {
                        return 786;
                    }
                    case 77: {
                        return 787;
                    }
                    case 78: {
                        return 788;
                    }
                    case 79: {
                        return 789;
                    }
                    case 80: {
                        return 790;
                    }
                    case 81: {
                        return 791;
                    }
                    case 82: {
                        return 792;
                    }
                    case 83: {
                        return 793;
                    }
                    case 84: {
                        return 794;
                    }
                    case 85: {
                        return 795;
                    }
                    case 86: {
                        return 796;
                    }
                    case 87: {
                        return 797;
                    }
                    case 88: {
                        return 798;
                    }
                    case 89: {
                        return 799;
                    }
                    case 90: {
                        return 800;
                    }
                    case 91: {
                        return 801;
                    }
                    case 92: {
                        return 802;
                    }
                    case 93: {
                        return 803;
                    }
                    case 94: {
                        return 804;
                    }
                    case 95: {
                        return 805;
                    }
                    case 96: {
                        return 133;
                    }
                    case 97: {
                        return 134;
                    }
                    case 98: {
                        return 135;
                    }
                    case 99: {
                        return 136;
                    }
                    case 100: {
                        return 767;
                    }
                    case 101: {
                        return 137;
                    }
                    case 102: {
                        return 138;
                    }
                    case 103: {
                        return 139;
                    }
                    case 104: {
                        return 806;
                    }
                    case 105: {
                        return 807;
                    }
                    case 106: {
                        return 808;
                    }
                    case 107: {
                        return 809;
                    }
                    case 108: {
                        return 810;
                    }
                    case 109: {
                        return 811;
                    }
                    case 110: {
                        return 812;
                    }
                    case 111: {
                        return 813;
                    }
                    case 112: {
                        return 814;
                    }
                    case 113: {
                        return 815;
                    }
                    case 114: {
                        return 816;
                    }
                    case 115: {
                        return 817;
                    }
                    case 116: {
                        return 818;
                    }
                    case 117: {
                        return 819;
                    }
                    case 118: {
                        return 820;
                    }
                    case 119: {
                        return 821;
                    }
                    case 120: {
                        return 822;
                    }
                    case 121: {
                        return 823;
                    }
                    case 122: {
                        return 824;
                    }
                    case 123: {
                        return 825;
                    }
                    case 124: {
                        return 826;
                    }
                    case 125: {
                        return 827;
                    }
                    case 126: {
                        return 828;
                    }
                    case 127: {
                        return 829;
                    }
                    case 128: {
                        return 830;
                    }
                    case 129: {
                        return 831;
                    }
                    case 130: {
                        return 832;
                    }
                    case 131: {
                        return 833;
                    }
                    case 132: {
                        return 834;
                    }
                    case 133: {
                        return 835;
                    }
                    case 134: {
                        return 836;
                    }
                    case 135: {
                        return 837;
                    }
                    case 136: {
                        return 838;
                    }
                    case 137: {
                        return 839;
                    }
                    case 138: {
                        return 840;
                    }
                    case 139: {
                        return 841;
                    }
                    case 140: {
                        return 842;
                    }
                    case 141: {
                        return 843;
                    }
                    case 142: {
                        return 844;
                    }
                    case 143: {
                        return 845;
                    }
                    case 144: {
                        return 846;
                    }
                    case 145: {
                        return 847;
                    }
                    case 146: {
                        return 848;
                    }
                    case 147: {
                        return 849;
                    }
                    case 148: {
                        return 850;
                    }
                    case 149: {
                        return 851;
                    }
                    case 150: {
                        return 852;
                    }
                    case 151: {
                        return 853;
                    }
                    case 152: {
                        return 854;
                    }
                    case 153: {
                        return 855;
                    }
                    case 154: {
                        return 856;
                    }
                    case 155: {
                        return 857;
                    }
                    case 156: {
                        return 858;
                    }
                    case 157: {
                        return 859;
                    }
                    case 158: {
                        return 860;
                    }
                    case 159: {
                        return 861;
                    }
                    case 160: {
                        return 133;
                    }
                    case 161: {
                        return 134;
                    }
                    case 162: {
                        return 135;
                    }
                    case 163: {
                        return 136;
                    }
                    case 164: {
                        return 767;
                    }
                    case 165: {
                        return 137;
                    }
                    case 166: {
                        return 138;
                    }
                    case 167: {
                        return 139;
                    }
                    case 168: {
                        return 862;
                    }
                    case 169: {
                        return 863;
                    }
                    case 170: {
                        return 864;
                    }
                    case 171: {
                        return 865;
                    }
                    case 172: {
                        return 866;
                    }
                    case 173: {
                        return 867;
                    }
                    case 174: {
                        return 868;
                    }
                    case 175: {
                        return 869;
                    }
                    case 176: {
                        return 870;
                    }
                    case 177: {
                        return 871;
                    }
                    case 178: {
                        return 872;
                    }
                    case 179: {
                        return 873;
                    }
                    case 180: {
                        return 874;
                    }
                    case 181: {
                        return 875;
                    }
                    case 182: {
                        return 876;
                    }
                    case 183: {
                        return 877;
                    }
                    case 184: {
                        return 878;
                    }
                    case 185: {
                        return 879;
                    }
                    case 186: {
                        return 880;
                    }
                    case 187: {
                        return 881;
                    }
                    case 188: {
                        return 882;
                    }
                    case 189: {
                        return 883;
                    }
                    case 190: {
                        return 884;
                    }
                    case 191: {
                        return 885;
                    }
                    case 192: {
                        return 886;
                    }
                    case 193: {
                        return 887;
                    }
                    case 194: {
                        return 888;
                    }
                    case 195: {
                        return 889;
                    }
                    case 196: {
                        return 890;
                    }
                    case 197: {
                        return 891;
                    }
                    case 198: {
                        return 892;
                    }
                    case 199: {
                        return 893;
                    }
                    case 200: {
                        return 894;
                    }
                    case 201: {
                        return 895;
                    }
                    case 202: {
                        return 896;
                    }
                    case 203: {
                        return 897;
                    }
                    case 204: {
                        return 898;
                    }
                    case 205: {
                        return 899;
                    }
                    case 206: {
                        return 900;
                    }
                    case 207: {
                        return 901;
                    }
                    case 208: {
                        return 902;
                    }
                    case 209: {
                        return 903;
                    }
                    case 210: {
                        return 904;
                    }
                    case 211: {
                        return 905;
                    }
                    case 212: {
                        return 906;
                    }
                    case 213: {
                        return 907;
                    }
                    case 214: {
                        return 908;
                    }
                    case 215: {
                        return 909;
                    }
                    case 216: {
                        return 910;
                    }
                    case 217: {
                        return 911;
                    }
                    case 218: {
                        return 912;
                    }
                    case 219: {
                        return 913;
                    }
                    case 220: {
                        return 914;
                    }
                    case 221: {
                        return 915;
                    }
                    case 222: {
                        return 916;
                    }
                    case 223: {
                        return 917;
                    }
                    case 224: {
                        return 133;
                    }
                    case 225: {
                        return 134;
                    }
                    case 226: {
                        return 135;
                    }
                    case 227: {
                        return 136;
                    }
                    case 228: {
                        return 767;
                    }
                    case 229: {
                        return 137;
                    }
                    case 230: {
                        return 138;
                    }
                    case 231: {
                        return 139;
                    }
                    case 232: {
                        return 918;
                    }
                    case 233: {
                        return 919;
                    }
                    case 234: {
                        return 920;
                    }
                    case 235: {
                        return 921;
                    }
                    case 236: {
                        return 922;
                    }
                    case 237: {
                        return 923;
                    }
                    case 238: {
                        return 924;
                    }
                    case 239: {
                        return 925;
                    }
                    case 240: {
                        return 926;
                    }
                    case 241: {
                        return 927;
                    }
                    case 242: {
                        return 928;
                    }
                    case 243: {
                        return 929;
                    }
                    case 244: {
                        return 930;
                    }
                    case 245: {
                        return 931;
                    }
                    case 246: {
                        return 932;
                    }
                    case 247: {
                        return 933;
                    }
                    case 248: {
                        return 934;
                    }
                    case 249: {
                        return 935;
                    }
                    case 250: {
                        return 936;
                    }
                    case 251: {
                        return 937;
                    }
                    case 252: {
                        return 938;
                    }
                    case 253: {
                        return 939;
                    }
                    case 254: {
                        return 940;
                    }
                    case 255: 
                }
                return 941;
            }
            case 1: {
                switch (n2 & 0xC0) {
                    default: {
                        return -1;
                    }
                    case 0: {
                        switch (n3) {
                            default: {
                                return -1;
                            }
                            case 0: {
                                return 942;
                            }
                            case 1: {
                                return 943;
                            }
                            case 2: {
                                return 944;
                            }
                            case 3: {
                                return 945;
                            }
                            case 4: {
                                return 946;
                            }
                            case 5: {
                                return 70;
                            }
                            case 6: {
                                return 948;
                            }
                            case 7: {
                                return 949;
                            }
                            case 8: {
                                return 943;
                            }
                            case 9: {
                                return 950;
                            }
                            case 10: {
                                return 951;
                            }
                            case 11: {
                                return 952;
                            }
                            case 12: {
                                return 953;
                            }
                            case 13: {
                                return 71;
                            }
                            case 14: {
                                return 955;
                            }
                            case 15: {
                                return 956;
                            }
                            case 16: {
                                return 944;
                            }
                            case 17: {
                                return 951;
                            }
                            case 18: {
                                return 957;
                            }
                            case 19: {
                                return 958;
                            }
                            case 20: {
                                return 959;
                            }
                            case 21: {
                                return 72;
                            }
                            case 22: {
                                return 961;
                            }
                            case 23: {
                                return 962;
                            }
                            case 24: {
                                return 945;
                            }
                            case 25: {
                                return 952;
                            }
                            case 26: {
                                return 958;
                            }
                            case 27: {
                                return 963;
                            }
                            case 28: {
                                return 964;
                            }
                            case 29: {
                                return 73;
                            }
                            case 30: {
                                return 966;
                            }
                            case 31: {
                                return 967;
                            }
                            case 32: {
                                return 56;
                            }
                            case 33: {
                                return 57;
                            }
                            case 34: {
                                return 58;
                            }
                            case 35: {
                                return 59;
                            }
                            case 36: {
                                return 968;
                            }
                            case 37: {
                                return 60;
                            }
                            case 38: {
                                return 61;
                            }
                            case 39: {
                                return 62;
                            }
                            case 40: {
                                return 947;
                            }
                            case 41: {
                                return 954;
                            }
                            case 42: {
                                return 960;
                            }
                            case 43: {
                                return 965;
                            }
                            case 44: {
                                return 969;
                            }
                            case 45: {
                                return 74;
                            }
                            case 46: {
                                return 970;
                            }
                            case 47: {
                                return 971;
                            }
                            case 48: {
                                return 948;
                            }
                            case 49: {
                                return 955;
                            }
                            case 50: {
                                return 961;
                            }
                            case 51: {
                                return 966;
                            }
                            case 52: {
                                return 972;
                            }
                            case 53: {
                                return 75;
                            }
                            case 54: {
                                return 973;
                            }
                            case 55: {
                                return 974;
                            }
                            case 56: {
                                return 949;
                            }
                            case 57: {
                                return 956;
                            }
                            case 58: {
                                return 962;
                            }
                            case 59: {
                                return 967;
                            }
                            case 60: {
                                return 975;
                            }
                            case 61: {
                                return 76;
                            }
                            case 62: {
                                return 974;
                            }
                            case 63: {
                                return 976;
                            }
                            case 64: {
                                return 977;
                            }
                            case 65: {
                                return 978;
                            }
                            case 66: {
                                return 979;
                            }
                            case 67: {
                                return 980;
                            }
                            case 68: {
                                return 981;
                            }
                            case 69: {
                                return 982;
                            }
                            case 70: {
                                return 983;
                            }
                            case 71: {
                                return 984;
                            }
                            case 72: {
                                return 985;
                            }
                            case 73: {
                                return 986;
                            }
                            case 74: {
                                return 987;
                            }
                            case 75: {
                                return 988;
                            }
                            case 76: {
                                return 989;
                            }
                            case 77: {
                                return 990;
                            }
                            case 78: {
                                return 991;
                            }
                            case 79: {
                                return 992;
                            }
                            case 80: {
                                return 993;
                            }
                            case 81: {
                                return 994;
                            }
                            case 82: {
                                return 995;
                            }
                            case 83: {
                                return 996;
                            }
                            case 84: {
                                return 997;
                            }
                            case 85: {
                                return 998;
                            }
                            case 86: {
                                return 999;
                            }
                            case 87: {
                                return 1000;
                            }
                            case 88: {
                                return 1001;
                            }
                            case 89: {
                                return 1002;
                            }
                            case 90: {
                                return 1003;
                            }
                            case 91: {
                                return 1004;
                            }
                            case 92: {
                                return 1005;
                            }
                            case 93: {
                                return 1006;
                            }
                            case 94: {
                                return 1007;
                            }
                            case 95: {
                                return 1008;
                            }
                            case 96: {
                                return 56;
                            }
                            case 97: {
                                return 57;
                            }
                            case 98: {
                                return 58;
                            }
                            case 99: {
                                return 59;
                            }
                            case 100: {
                                return 968;
                            }
                            case 101: {
                                return 60;
                            }
                            case 102: {
                                return 61;
                            }
                            case 103: {
                                return 62;
                            }
                            case 104: {
                                return 1009;
                            }
                            case 105: {
                                return 1010;
                            }
                            case 106: {
                                return 1011;
                            }
                            case 107: {
                                return 1012;
                            }
                            case 108: {
                                return 1013;
                            }
                            case 109: {
                                return 1014;
                            }
                            case 110: {
                                return 1015;
                            }
                            case 111: {
                                return 1016;
                            }
                            case 112: {
                                return 1017;
                            }
                            case 113: {
                                return 1018;
                            }
                            case 114: {
                                return 1019;
                            }
                            case 115: {
                                return 1020;
                            }
                            case 116: {
                                return 1021;
                            }
                            case 117: {
                                return 1022;
                            }
                            case 118: {
                                return 1023;
                            }
                            case 119: {
                                return 1024;
                            }
                            case 120: {
                                return 1025;
                            }
                            case 121: {
                                return 1026;
                            }
                            case 122: {
                                return 1027;
                            }
                            case 123: {
                                return 1028;
                            }
                            case 124: {
                                return 1029;
                            }
                            case 125: {
                                return 1030;
                            }
                            case 126: {
                                return 1031;
                            }
                            case 127: {
                                return 1032;
                            }
                            case 128: {
                                return 1033;
                            }
                            case 129: {
                                return 1034;
                            }
                            case 130: {
                                return 1035;
                            }
                            case 131: {
                                return 1036;
                            }
                            case 132: {
                                return 1037;
                            }
                            case 133: {
                                return 1038;
                            }
                            case 134: {
                                return 1039;
                            }
                            case 135: {
                                return 1040;
                            }
                            case 136: {
                                return 1041;
                            }
                            case 137: {
                                return 1042;
                            }
                            case 138: {
                                return 1043;
                            }
                            case 139: {
                                return 1044;
                            }
                            case 140: {
                                return 1045;
                            }
                            case 141: {
                                return 1046;
                            }
                            case 142: {
                                return 1047;
                            }
                            case 143: {
                                return 1048;
                            }
                            case 144: {
                                return 1049;
                            }
                            case 145: {
                                return 1050;
                            }
                            case 146: {
                                return 1051;
                            }
                            case 147: {
                                return 1052;
                            }
                            case 148: {
                                return 1053;
                            }
                            case 149: {
                                return 1054;
                            }
                            case 150: {
                                return 1055;
                            }
                            case 151: {
                                return 1056;
                            }
                            case 152: {
                                return 1057;
                            }
                            case 153: {
                                return 1058;
                            }
                            case 154: {
                                return 1059;
                            }
                            case 155: {
                                return 1060;
                            }
                            case 156: {
                                return 1061;
                            }
                            case 157: {
                                return 1062;
                            }
                            case 158: {
                                return 1063;
                            }
                            case 159: {
                                return 1064;
                            }
                            case 160: {
                                return 56;
                            }
                            case 161: {
                                return 57;
                            }
                            case 162: {
                                return 58;
                            }
                            case 163: {
                                return 59;
                            }
                            case 164: {
                                return 968;
                            }
                            case 165: {
                                return 60;
                            }
                            case 166: {
                                return 61;
                            }
                            case 167: {
                                return 62;
                            }
                            case 168: {
                                return 1065;
                            }
                            case 169: {
                                return 1066;
                            }
                            case 170: {
                                return 1067;
                            }
                            case 171: {
                                return 1068;
                            }
                            case 172: {
                                return 1069;
                            }
                            case 173: {
                                return 1070;
                            }
                            case 174: {
                                return 1071;
                            }
                            case 175: {
                                return 1072;
                            }
                            case 176: {
                                return 1073;
                            }
                            case 177: {
                                return 1074;
                            }
                            case 178: {
                                return 1075;
                            }
                            case 179: {
                                return 1076;
                            }
                            case 180: {
                                return 1077;
                            }
                            case 181: {
                                return 1078;
                            }
                            case 182: {
                                return 1079;
                            }
                            case 183: {
                                return 1080;
                            }
                            case 184: {
                                return 1081;
                            }
                            case 185: {
                                return 1082;
                            }
                            case 186: {
                                return 1083;
                            }
                            case 187: {
                                return 1084;
                            }
                            case 188: {
                                return 1085;
                            }
                            case 189: {
                                return 1086;
                            }
                            case 190: {
                                return 1087;
                            }
                            case 191: {
                                return 1088;
                            }
                            case 192: {
                                return 1089;
                            }
                            case 193: {
                                return 1090;
                            }
                            case 194: {
                                return 1091;
                            }
                            case 195: {
                                return 1092;
                            }
                            case 196: {
                                return 1093;
                            }
                            case 197: {
                                return 1094;
                            }
                            case 198: {
                                return 1095;
                            }
                            case 199: {
                                return 1096;
                            }
                            case 200: {
                                return 1097;
                            }
                            case 201: {
                                return 1098;
                            }
                            case 202: {
                                return 1099;
                            }
                            case 203: {
                                return 1100;
                            }
                            case 204: {
                                return 1101;
                            }
                            case 205: {
                                return 1102;
                            }
                            case 206: {
                                return 1103;
                            }
                            case 207: {
                                return 1104;
                            }
                            case 208: {
                                return 1105;
                            }
                            case 209: {
                                return 1106;
                            }
                            case 210: {
                                return 1107;
                            }
                            case 211: {
                                return 1108;
                            }
                            case 212: {
                                return 1109;
                            }
                            case 213: {
                                return 1110;
                            }
                            case 214: {
                                return 1111;
                            }
                            case 215: {
                                return 1112;
                            }
                            case 216: {
                                return 1113;
                            }
                            case 217: {
                                return 1114;
                            }
                            case 218: {
                                return 1115;
                            }
                            case 219: {
                                return 1116;
                            }
                            case 220: {
                                return 1117;
                            }
                            case 221: {
                                return 1118;
                            }
                            case 222: {
                                return 1119;
                            }
                            case 223: {
                                return 1120;
                            }
                            case 224: {
                                return 56;
                            }
                            case 225: {
                                return 57;
                            }
                            case 226: {
                                return 58;
                            }
                            case 227: {
                                return 59;
                            }
                            case 228: {
                                return 968;
                            }
                            case 229: {
                                return 60;
                            }
                            case 230: {
                                return 61;
                            }
                            case 231: {
                                return 62;
                            }
                            case 232: {
                                return 1121;
                            }
                            case 233: {
                                return 1122;
                            }
                            case 234: {
                                return 1123;
                            }
                            case 235: {
                                return 1124;
                            }
                            case 236: {
                                return 1125;
                            }
                            case 237: {
                                return 1126;
                            }
                            case 238: {
                                return 1127;
                            }
                            case 239: {
                                return 1128;
                            }
                            case 240: {
                                return 1129;
                            }
                            case 241: {
                                return 1130;
                            }
                            case 242: {
                                return 1131;
                            }
                            case 243: {
                                return 1132;
                            }
                            case 244: {
                                return 1133;
                            }
                            case 245: {
                                return 1134;
                            }
                            case 246: {
                                return 1135;
                            }
                            case 247: {
                                return 1136;
                            }
                            case 248: {
                                return 1137;
                            }
                            case 249: {
                                return 1138;
                            }
                            case 250: {
                                return 1139;
                            }
                            case 251: {
                                return 1140;
                            }
                            case 252: {
                                return 1141;
                            }
                            case 253: {
                                return 1142;
                            }
                            case 254: {
                                return 1143;
                            }
                            case 255: 
                        }
                        return 1144;
                    }
                    case 64: {
                        switch (n3) {
                            default: {
                                return -1;
                            }
                            case 0: {
                                return 1145;
                            }
                            case 1: {
                                return 1146;
                            }
                            case 2: {
                                return 1147;
                            }
                            case 3: {
                                return 1148;
                            }
                            case 4: {
                                return 1149;
                            }
                            case 5: {
                                return 1150;
                            }
                            case 6: {
                                return 1151;
                            }
                            case 7: {
                                return 1152;
                            }
                            case 8: {
                                return 1146;
                            }
                            case 9: {
                                return 1153;
                            }
                            case 10: {
                                return 1154;
                            }
                            case 11: {
                                return 1155;
                            }
                            case 12: {
                                return 1156;
                            }
                            case 13: {
                                return 1157;
                            }
                            case 14: {
                                return 1158;
                            }
                            case 15: {
                                return 1159;
                            }
                            case 16: {
                                return 1147;
                            }
                            case 17: {
                                return 1154;
                            }
                            case 18: {
                                return 1160;
                            }
                            case 19: {
                                return 1161;
                            }
                            case 20: {
                                return 1162;
                            }
                            case 21: {
                                return 1163;
                            }
                            case 22: {
                                return 1164;
                            }
                            case 23: {
                                return 1165;
                            }
                            case 24: {
                                return 1148;
                            }
                            case 25: {
                                return 1155;
                            }
                            case 26: {
                                return 1161;
                            }
                            case 27: {
                                return 1166;
                            }
                            case 28: {
                                return 1167;
                            }
                            case 29: {
                                return 1168;
                            }
                            case 30: {
                                return 1169;
                            }
                            case 31: {
                                return 1170;
                            }
                            case 32: {
                                return 63;
                            }
                            case 33: {
                                return 64;
                            }
                            case 34: {
                                return 65;
                            }
                            case 35: {
                                return 66;
                            }
                            case 36: {
                                return 1171;
                            }
                            case 37: {
                                return 67;
                            }
                            case 38: {
                                return 68;
                            }
                            case 39: {
                                return 69;
                            }
                            case 40: {
                                return 1150;
                            }
                            case 41: {
                                return 1157;
                            }
                            case 42: {
                                return 1163;
                            }
                            case 43: {
                                return 1168;
                            }
                            case 44: {
                                return 1172;
                            }
                            case 45: {
                                return 1173;
                            }
                            case 46: {
                                return 1174;
                            }
                            case 47: {
                                return 1175;
                            }
                            case 48: {
                                return 1151;
                            }
                            case 49: {
                                return 1158;
                            }
                            case 50: {
                                return 1164;
                            }
                            case 51: {
                                return 1169;
                            }
                            case 52: {
                                return 1176;
                            }
                            case 53: {
                                return 1174;
                            }
                            case 54: {
                                return 1177;
                            }
                            case 55: {
                                return 1178;
                            }
                            case 56: {
                                return 1152;
                            }
                            case 57: {
                                return 1159;
                            }
                            case 58: {
                                return 1165;
                            }
                            case 59: {
                                return 1170;
                            }
                            case 60: {
                                return 1179;
                            }
                            case 61: {
                                return 1175;
                            }
                            case 62: {
                                return 1178;
                            }
                            case 63: {
                                return 1180;
                            }
                            case 64: {
                                return 1181;
                            }
                            case 65: {
                                return 1182;
                            }
                            case 66: {
                                return 1183;
                            }
                            case 67: {
                                return 1184;
                            }
                            case 68: {
                                return 1185;
                            }
                            case 69: {
                                return 1186;
                            }
                            case 70: {
                                return 1187;
                            }
                            case 71: {
                                return 1188;
                            }
                            case 72: {
                                return 1189;
                            }
                            case 73: {
                                return 1190;
                            }
                            case 74: {
                                return 1191;
                            }
                            case 75: {
                                return 1192;
                            }
                            case 76: {
                                return 1193;
                            }
                            case 77: {
                                return 1194;
                            }
                            case 78: {
                                return 1195;
                            }
                            case 79: {
                                return 1196;
                            }
                            case 80: {
                                return 1197;
                            }
                            case 81: {
                                return 1198;
                            }
                            case 82: {
                                return 1199;
                            }
                            case 83: {
                                return 1200;
                            }
                            case 84: {
                                return 1201;
                            }
                            case 85: {
                                return 1202;
                            }
                            case 86: {
                                return 1203;
                            }
                            case 87: {
                                return 1204;
                            }
                            case 88: {
                                return 1205;
                            }
                            case 89: {
                                return 1206;
                            }
                            case 90: {
                                return 1207;
                            }
                            case 91: {
                                return 1208;
                            }
                            case 92: {
                                return 1209;
                            }
                            case 93: {
                                return 1210;
                            }
                            case 94: {
                                return 1211;
                            }
                            case 95: {
                                return 1212;
                            }
                            case 96: {
                                return 63;
                            }
                            case 97: {
                                return 64;
                            }
                            case 98: {
                                return 65;
                            }
                            case 99: {
                                return 66;
                            }
                            case 100: {
                                return 1171;
                            }
                            case 101: {
                                return 67;
                            }
                            case 102: {
                                return 68;
                            }
                            case 103: {
                                return 69;
                            }
                            case 104: {
                                return 1213;
                            }
                            case 105: {
                                return 1214;
                            }
                            case 106: {
                                return 1215;
                            }
                            case 107: {
                                return 1216;
                            }
                            case 108: {
                                return 1217;
                            }
                            case 109: {
                                return 1218;
                            }
                            case 110: {
                                return 1219;
                            }
                            case 111: {
                                return 1220;
                            }
                            case 112: {
                                return 1221;
                            }
                            case 113: {
                                return 1222;
                            }
                            case 114: {
                                return 1223;
                            }
                            case 115: {
                                return 1224;
                            }
                            case 116: {
                                return 1225;
                            }
                            case 117: {
                                return 1226;
                            }
                            case 118: {
                                return 1227;
                            }
                            case 119: {
                                return 1228;
                            }
                            case 120: {
                                return 1229;
                            }
                            case 121: {
                                return 1230;
                            }
                            case 122: {
                                return 1231;
                            }
                            case 123: {
                                return 1232;
                            }
                            case 124: {
                                return 1233;
                            }
                            case 125: {
                                return 1234;
                            }
                            case 126: {
                                return 1235;
                            }
                            case 127: {
                                return 1236;
                            }
                            case 128: {
                                return 1237;
                            }
                            case 129: {
                                return 1238;
                            }
                            case 130: {
                                return 1239;
                            }
                            case 131: {
                                return 1240;
                            }
                            case 132: {
                                return 1241;
                            }
                            case 133: {
                                return 1242;
                            }
                            case 134: {
                                return 1243;
                            }
                            case 135: {
                                return 1244;
                            }
                            case 136: {
                                return 1245;
                            }
                            case 137: {
                                return 1246;
                            }
                            case 138: {
                                return 1247;
                            }
                            case 139: {
                                return 1248;
                            }
                            case 140: {
                                return 1249;
                            }
                            case 141: {
                                return 1250;
                            }
                            case 142: {
                                return 1251;
                            }
                            case 143: {
                                return 1252;
                            }
                            case 144: {
                                return 1253;
                            }
                            case 145: {
                                return 1254;
                            }
                            case 146: {
                                return 1255;
                            }
                            case 147: {
                                return 1256;
                            }
                            case 148: {
                                return 1257;
                            }
                            case 149: {
                                return 1258;
                            }
                            case 150: {
                                return 1259;
                            }
                            case 151: {
                                return 1260;
                            }
                            case 152: {
                                return 1261;
                            }
                            case 153: {
                                return 1262;
                            }
                            case 154: {
                                return 1263;
                            }
                            case 155: {
                                return 1264;
                            }
                            case 156: {
                                return 1265;
                            }
                            case 157: {
                                return 1266;
                            }
                            case 158: {
                                return 1267;
                            }
                            case 159: {
                                return 1268;
                            }
                            case 160: {
                                return 63;
                            }
                            case 161: {
                                return 64;
                            }
                            case 162: {
                                return 65;
                            }
                            case 163: {
                                return 66;
                            }
                            case 164: {
                                return 1171;
                            }
                            case 165: {
                                return 67;
                            }
                            case 166: {
                                return 68;
                            }
                            case 167: {
                                return 69;
                            }
                            case 168: {
                                return 1269;
                            }
                            case 169: {
                                return 1270;
                            }
                            case 170: {
                                return 1271;
                            }
                            case 171: {
                                return 1272;
                            }
                            case 172: {
                                return 1273;
                            }
                            case 173: {
                                return 1274;
                            }
                            case 174: {
                                return 1275;
                            }
                            case 175: {
                                return 1276;
                            }
                            case 176: {
                                return 1277;
                            }
                            case 177: {
                                return 1278;
                            }
                            case 178: {
                                return 1279;
                            }
                            case 179: {
                                return 1280;
                            }
                            case 180: {
                                return 1281;
                            }
                            case 181: {
                                return 1282;
                            }
                            case 182: {
                                return 1283;
                            }
                            case 183: {
                                return 1284;
                            }
                            case 184: {
                                return 1285;
                            }
                            case 185: {
                                return 1286;
                            }
                            case 186: {
                                return 1287;
                            }
                            case 187: {
                                return 1288;
                            }
                            case 188: {
                                return 1289;
                            }
                            case 189: {
                                return 1290;
                            }
                            case 190: {
                                return 1291;
                            }
                            case 191: {
                                return 1292;
                            }
                            case 192: {
                                return 1293;
                            }
                            case 193: {
                                return 1294;
                            }
                            case 194: {
                                return 1295;
                            }
                            case 195: {
                                return 1296;
                            }
                            case 196: {
                                return 1297;
                            }
                            case 197: {
                                return 1298;
                            }
                            case 198: {
                                return 1299;
                            }
                            case 199: {
                                return 1300;
                            }
                            case 200: {
                                return 1301;
                            }
                            case 201: {
                                return 1302;
                            }
                            case 202: {
                                return 1303;
                            }
                            case 203: {
                                return 1304;
                            }
                            case 204: {
                                return 1305;
                            }
                            case 205: {
                                return 1306;
                            }
                            case 206: {
                                return 1307;
                            }
                            case 207: {
                                return 1308;
                            }
                            case 208: {
                                return 1309;
                            }
                            case 209: {
                                return 1310;
                            }
                            case 210: {
                                return 1311;
                            }
                            case 211: {
                                return 1312;
                            }
                            case 212: {
                                return 1313;
                            }
                            case 213: {
                                return 1314;
                            }
                            case 214: {
                                return 1315;
                            }
                            case 215: {
                                return 1316;
                            }
                            case 216: {
                                return 1317;
                            }
                            case 217: {
                                return 1318;
                            }
                            case 218: {
                                return 1319;
                            }
                            case 219: {
                                return 1320;
                            }
                            case 220: {
                                return 1321;
                            }
                            case 221: {
                                return 1322;
                            }
                            case 222: {
                                return 1323;
                            }
                            case 223: {
                                return 1324;
                            }
                            case 224: {
                                return 63;
                            }
                            case 225: {
                                return 64;
                            }
                            case 226: {
                                return 65;
                            }
                            case 227: {
                                return 66;
                            }
                            case 228: {
                                return 1171;
                            }
                            case 229: {
                                return 67;
                            }
                            case 230: {
                                return 68;
                            }
                            case 231: {
                                return 69;
                            }
                            case 232: {
                                return 1325;
                            }
                            case 233: {
                                return 1326;
                            }
                            case 234: {
                                return 1327;
                            }
                            case 235: {
                                return 1328;
                            }
                            case 236: {
                                return 1329;
                            }
                            case 237: {
                                return 1330;
                            }
                            case 238: {
                                return 1331;
                            }
                            case 239: {
                                return 1332;
                            }
                            case 240: {
                                return 1333;
                            }
                            case 241: {
                                return 1334;
                            }
                            case 242: {
                                return 1335;
                            }
                            case 243: {
                                return 1336;
                            }
                            case 244: {
                                return 1337;
                            }
                            case 245: {
                                return 1338;
                            }
                            case 246: {
                                return 1339;
                            }
                            case 247: {
                                return 1340;
                            }
                            case 248: {
                                return 1341;
                            }
                            case 249: {
                                return 1342;
                            }
                            case 250: {
                                return 1343;
                            }
                            case 251: {
                                return 1344;
                            }
                            case 252: {
                                return 1345;
                            }
                            case 253: {
                                return 1346;
                            }
                            case 254: {
                                return 1347;
                            }
                            case 255: 
                        }
                        return 1348;
                    }
                    case 128: 
                }
                switch (n3) {
                    default: {
                        return -1;
                    }
                    case 0: {
                        return 982;
                    }
                    case 1: {
                        return 1349;
                    }
                    case 2: {
                        return 1350;
                    }
                    case 3: {
                        return 1351;
                    }
                    case 4: {
                        return 1352;
                    }
                    case 5: {
                        return 1353;
                    }
                    case 6: {
                        return 1354;
                    }
                    case 7: {
                        return 1355;
                    }
                    case 8: {
                        return 1349;
                    }
                    case 9: {
                        return 990;
                    }
                    case 10: {
                        return 1356;
                    }
                    case 11: {
                        return 1357;
                    }
                    case 12: {
                        return 1358;
                    }
                    case 13: {
                        return 1359;
                    }
                    case 14: {
                        return 1360;
                    }
                    case 15: {
                        return 1361;
                    }
                    case 16: {
                        return 1350;
                    }
                    case 17: {
                        return 1356;
                    }
                    case 18: {
                        return 998;
                    }
                    case 19: {
                        return 1362;
                    }
                    case 20: {
                        return 1363;
                    }
                    case 21: {
                        return 1364;
                    }
                    case 22: {
                        return 1365;
                    }
                    case 23: {
                        return 1366;
                    }
                    case 24: {
                        return 1351;
                    }
                    case 25: {
                        return 1357;
                    }
                    case 26: {
                        return 1362;
                    }
                    case 27: {
                        return 1006;
                    }
                    case 28: {
                        return 1367;
                    }
                    case 29: {
                        return 1368;
                    }
                    case 30: {
                        return 1369;
                    }
                    case 31: {
                        return 1370;
                    }
                    case 32: {
                        return 70;
                    }
                    case 33: {
                        return 71;
                    }
                    case 34: {
                        return 72;
                    }
                    case 35: {
                        return 73;
                    }
                    case 36: {
                        return 1371;
                    }
                    case 37: {
                        return 74;
                    }
                    case 38: {
                        return 75;
                    }
                    case 39: {
                        return 76;
                    }
                    case 40: {
                        return 1353;
                    }
                    case 41: {
                        return 1359;
                    }
                    case 42: {
                        return 1364;
                    }
                    case 43: {
                        return 1368;
                    }
                    case 44: {
                        return 1372;
                    }
                    case 45: {
                        return 1014;
                    }
                    case 46: {
                        return 1373;
                    }
                    case 47: {
                        return 1374;
                    }
                    case 48: {
                        return 1354;
                    }
                    case 49: {
                        return 1360;
                    }
                    case 50: {
                        return 1365;
                    }
                    case 51: {
                        return 1369;
                    }
                    case 52: {
                        return 1375;
                    }
                    case 53: {
                        return 1373;
                    }
                    case 54: {
                        return 1022;
                    }
                    case 55: {
                        return 1376;
                    }
                    case 56: {
                        return 1355;
                    }
                    case 57: {
                        return 1361;
                    }
                    case 58: {
                        return 1366;
                    }
                    case 59: {
                        return 1370;
                    }
                    case 60: {
                        return 1377;
                    }
                    case 61: {
                        return 1374;
                    }
                    case 62: {
                        return 1376;
                    }
                    case 63: {
                        return 1030;
                    }
                    case 64: {
                        return 1378;
                    }
                    case 65: {
                        return 1379;
                    }
                    case 66: {
                        return 1380;
                    }
                    case 67: {
                        return 1381;
                    }
                    case 68: {
                        return 1382;
                    }
                    case 69: {
                        return 1383;
                    }
                    case 70: {
                        return 1384;
                    }
                    case 71: {
                        return 1385;
                    }
                    case 72: {
                        return 1386;
                    }
                    case 73: {
                        return 1387;
                    }
                    case 74: {
                        return 1388;
                    }
                    case 75: {
                        return 1389;
                    }
                    case 76: {
                        return 1390;
                    }
                    case 77: {
                        return 1391;
                    }
                    case 78: {
                        return 1392;
                    }
                    case 79: {
                        return 1393;
                    }
                    case 80: {
                        return 1394;
                    }
                    case 81: {
                        return 1395;
                    }
                    case 82: {
                        return 1396;
                    }
                    case 83: {
                        return 1397;
                    }
                    case 84: {
                        return 1398;
                    }
                    case 85: {
                        return 1399;
                    }
                    case 86: {
                        return 1400;
                    }
                    case 87: {
                        return 1401;
                    }
                    case 88: {
                        return 1402;
                    }
                    case 89: {
                        return 1403;
                    }
                    case 90: {
                        return 1404;
                    }
                    case 91: {
                        return 1405;
                    }
                    case 92: {
                        return 1406;
                    }
                    case 93: {
                        return 1407;
                    }
                    case 94: {
                        return 1408;
                    }
                    case 95: {
                        return 1409;
                    }
                    case 96: {
                        return 70;
                    }
                    case 97: {
                        return 71;
                    }
                    case 98: {
                        return 72;
                    }
                    case 99: {
                        return 73;
                    }
                    case 100: {
                        return 1371;
                    }
                    case 101: {
                        return 74;
                    }
                    case 102: {
                        return 75;
                    }
                    case 103: {
                        return 76;
                    }
                    case 104: {
                        return 1410;
                    }
                    case 105: {
                        return 1411;
                    }
                    case 106: {
                        return 1412;
                    }
                    case 107: {
                        return 1413;
                    }
                    case 108: {
                        return 1414;
                    }
                    case 109: {
                        return 1415;
                    }
                    case 110: {
                        return 1416;
                    }
                    case 111: {
                        return 1417;
                    }
                    case 112: {
                        return 1418;
                    }
                    case 113: {
                        return 1419;
                    }
                    case 114: {
                        return 1420;
                    }
                    case 115: {
                        return 1421;
                    }
                    case 116: {
                        return 1422;
                    }
                    case 117: {
                        return 1423;
                    }
                    case 118: {
                        return 1424;
                    }
                    case 119: {
                        return 1425;
                    }
                    case 120: {
                        return 1426;
                    }
                    case 121: {
                        return 1427;
                    }
                    case 122: {
                        return 1428;
                    }
                    case 123: {
                        return 1429;
                    }
                    case 124: {
                        return 1430;
                    }
                    case 125: {
                        return 1431;
                    }
                    case 126: {
                        return 1432;
                    }
                    case 127: {
                        return 1433;
                    }
                    case 128: {
                        return 1434;
                    }
                    case 129: {
                        return 1435;
                    }
                    case 130: {
                        return 1436;
                    }
                    case 131: {
                        return 1437;
                    }
                    case 132: {
                        return 1438;
                    }
                    case 133: {
                        return 1439;
                    }
                    case 134: {
                        return 1440;
                    }
                    case 135: {
                        return 1441;
                    }
                    case 136: {
                        return 1442;
                    }
                    case 137: {
                        return 1443;
                    }
                    case 138: {
                        return 1444;
                    }
                    case 139: {
                        return 1445;
                    }
                    case 140: {
                        return 1446;
                    }
                    case 141: {
                        return 1447;
                    }
                    case 142: {
                        return 1448;
                    }
                    case 143: {
                        return 1449;
                    }
                    case 144: {
                        return 1450;
                    }
                    case 145: {
                        return 1451;
                    }
                    case 146: {
                        return 1452;
                    }
                    case 147: {
                        return 1453;
                    }
                    case 148: {
                        return 1454;
                    }
                    case 149: {
                        return 1455;
                    }
                    case 150: {
                        return 1456;
                    }
                    case 151: {
                        return 1457;
                    }
                    case 152: {
                        return 1458;
                    }
                    case 153: {
                        return 1459;
                    }
                    case 154: {
                        return 1460;
                    }
                    case 155: {
                        return 1461;
                    }
                    case 156: {
                        return 1462;
                    }
                    case 157: {
                        return 1463;
                    }
                    case 158: {
                        return 1464;
                    }
                    case 159: {
                        return 1465;
                    }
                    case 160: {
                        return 70;
                    }
                    case 161: {
                        return 71;
                    }
                    case 162: {
                        return 72;
                    }
                    case 163: {
                        return 73;
                    }
                    case 164: {
                        return 1371;
                    }
                    case 165: {
                        return 74;
                    }
                    case 166: {
                        return 75;
                    }
                    case 167: {
                        return 76;
                    }
                    case 168: {
                        return 1466;
                    }
                    case 169: {
                        return 1467;
                    }
                    case 170: {
                        return 1468;
                    }
                    case 171: {
                        return 1469;
                    }
                    case 172: {
                        return 1470;
                    }
                    case 173: {
                        return 1471;
                    }
                    case 174: {
                        return 1472;
                    }
                    case 175: {
                        return 1473;
                    }
                    case 176: {
                        return 1474;
                    }
                    case 177: {
                        return 1475;
                    }
                    case 178: {
                        return 1476;
                    }
                    case 179: {
                        return 1477;
                    }
                    case 180: {
                        return 1478;
                    }
                    case 181: {
                        return 1479;
                    }
                    case 182: {
                        return 1480;
                    }
                    case 183: {
                        return 1481;
                    }
                    case 184: {
                        return 1482;
                    }
                    case 185: {
                        return 1483;
                    }
                    case 186: {
                        return 1484;
                    }
                    case 187: {
                        return 1485;
                    }
                    case 188: {
                        return 1486;
                    }
                    case 189: {
                        return 1487;
                    }
                    case 190: {
                        return 1488;
                    }
                    case 191: {
                        return 1489;
                    }
                    case 192: {
                        return 1490;
                    }
                    case 193: {
                        return 1491;
                    }
                    case 194: {
                        return 1492;
                    }
                    case 195: {
                        return 1493;
                    }
                    case 196: {
                        return 1494;
                    }
                    case 197: {
                        return 1495;
                    }
                    case 198: {
                        return 1496;
                    }
                    case 199: {
                        return 1497;
                    }
                    case 200: {
                        return 1498;
                    }
                    case 201: {
                        return 1499;
                    }
                    case 202: {
                        return 1500;
                    }
                    case 203: {
                        return 1501;
                    }
                    case 204: {
                        return 1502;
                    }
                    case 205: {
                        return 1503;
                    }
                    case 206: {
                        return 1504;
                    }
                    case 207: {
                        return 1505;
                    }
                    case 208: {
                        return 1506;
                    }
                    case 209: {
                        return 1507;
                    }
                    case 210: {
                        return 1508;
                    }
                    case 211: {
                        return 1509;
                    }
                    case 212: {
                        return 1510;
                    }
                    case 213: {
                        return 1511;
                    }
                    case 214: {
                        return 1512;
                    }
                    case 215: {
                        return 1513;
                    }
                    case 216: {
                        return 1514;
                    }
                    case 217: {
                        return 1515;
                    }
                    case 218: {
                        return 1516;
                    }
                    case 219: {
                        return 1517;
                    }
                    case 220: {
                        return 1518;
                    }
                    case 221: {
                        return 1519;
                    }
                    case 222: {
                        return 1520;
                    }
                    case 223: {
                        return 1521;
                    }
                    case 224: {
                        return 70;
                    }
                    case 225: {
                        return 71;
                    }
                    case 226: {
                        return 72;
                    }
                    case 227: {
                        return 73;
                    }
                    case 228: {
                        return 1371;
                    }
                    case 229: {
                        return 74;
                    }
                    case 230: {
                        return 75;
                    }
                    case 231: {
                        return 76;
                    }
                    case 232: {
                        return 1522;
                    }
                    case 233: {
                        return 1523;
                    }
                    case 234: {
                        return 1524;
                    }
                    case 235: {
                        return 1525;
                    }
                    case 236: {
                        return 1526;
                    }
                    case 237: {
                        return 1527;
                    }
                    case 238: {
                        return 1528;
                    }
                    case 239: {
                        return 1529;
                    }
                    case 240: {
                        return 1530;
                    }
                    case 241: {
                        return 1531;
                    }
                    case 242: {
                        return 1532;
                    }
                    case 243: {
                        return 1533;
                    }
                    case 244: {
                        return 1534;
                    }
                    case 245: {
                        return 1535;
                    }
                    case 246: {
                        return 1536;
                    }
                    case 247: {
                        return 1537;
                    }
                    case 248: {
                        return 1538;
                    }
                    case 249: {
                        return 1539;
                    }
                    case 250: {
                        return 1540;
                    }
                    case 251: {
                        return 1541;
                    }
                    case 252: {
                        return 1542;
                    }
                    case 253: {
                        return 1543;
                    }
                    case 254: {
                        return 1544;
                    }
                    case 255: 
                }
                return 1545;
            }
            case 2: {
                switch (n2 & 0xC0) {
                    default: {
                        return -1;
                    }
                    case 0: {
                        switch (n3) {
                            default: {
                                return -1;
                            }
                            case 0: {
                                return 1546;
                            }
                            case 1: {
                                return 1547;
                            }
                            case 2: {
                                return 1548;
                            }
                            case 3: {
                                return 1549;
                            }
                            case 4: {
                                return 1550;
                            }
                            case 5: {
                                return 91;
                            }
                            case 6: {
                                return 1552;
                            }
                            case 7: {
                                return 1553;
                            }
                            case 8: {
                                return 1547;
                            }
                            case 9: {
                                return 1554;
                            }
                            case 10: {
                                return 1555;
                            }
                            case 11: {
                                return 1556;
                            }
                            case 12: {
                                return 1557;
                            }
                            case 13: {
                                return 92;
                            }
                            case 14: {
                                return 1559;
                            }
                            case 15: {
                                return 1560;
                            }
                            case 16: {
                                return 1548;
                            }
                            case 17: {
                                return 1555;
                            }
                            case 18: {
                                return 1561;
                            }
                            case 19: {
                                return 1562;
                            }
                            case 20: {
                                return 1563;
                            }
                            case 21: {
                                return 93;
                            }
                            case 22: {
                                return 1565;
                            }
                            case 23: {
                                return 1566;
                            }
                            case 24: {
                                return 1549;
                            }
                            case 25: {
                                return 1556;
                            }
                            case 26: {
                                return 1562;
                            }
                            case 27: {
                                return 1567;
                            }
                            case 28: {
                                return 1568;
                            }
                            case 29: {
                                return 94;
                            }
                            case 30: {
                                return 1570;
                            }
                            case 31: {
                                return 1571;
                            }
                            case 32: {
                                return 77;
                            }
                            case 33: {
                                return 78;
                            }
                            case 34: {
                                return 79;
                            }
                            case 35: {
                                return 80;
                            }
                            case 36: {
                                return 1572;
                            }
                            case 37: {
                                return 81;
                            }
                            case 38: {
                                return 82;
                            }
                            case 39: {
                                return 83;
                            }
                            case 40: {
                                return 1551;
                            }
                            case 41: {
                                return 1558;
                            }
                            case 42: {
                                return 1564;
                            }
                            case 43: {
                                return 1569;
                            }
                            case 44: {
                                return 1573;
                            }
                            case 45: {
                                return 95;
                            }
                            case 46: {
                                return 1574;
                            }
                            case 47: {
                                return 1575;
                            }
                            case 48: {
                                return 1552;
                            }
                            case 49: {
                                return 1559;
                            }
                            case 50: {
                                return 1565;
                            }
                            case 51: {
                                return 1570;
                            }
                            case 52: {
                                return 1576;
                            }
                            case 53: {
                                return 96;
                            }
                            case 54: {
                                return 1577;
                            }
                            case 55: {
                                return 1578;
                            }
                            case 56: {
                                return 1553;
                            }
                            case 57: {
                                return 1560;
                            }
                            case 58: {
                                return 1566;
                            }
                            case 59: {
                                return 1571;
                            }
                            case 60: {
                                return 1579;
                            }
                            case 61: {
                                return 97;
                            }
                            case 62: {
                                return 1578;
                            }
                            case 63: {
                                return 1580;
                            }
                            case 64: {
                                return 1581;
                            }
                            case 65: {
                                return 1582;
                            }
                            case 66: {
                                return 1583;
                            }
                            case 67: {
                                return 1584;
                            }
                            case 68: {
                                return 1585;
                            }
                            case 69: {
                                return 1586;
                            }
                            case 70: {
                                return 1587;
                            }
                            case 71: {
                                return 1588;
                            }
                            case 72: {
                                return 1589;
                            }
                            case 73: {
                                return 1590;
                            }
                            case 74: {
                                return 1591;
                            }
                            case 75: {
                                return 1592;
                            }
                            case 76: {
                                return 1593;
                            }
                            case 77: {
                                return 1594;
                            }
                            case 78: {
                                return 1595;
                            }
                            case 79: {
                                return 1596;
                            }
                            case 80: {
                                return 1597;
                            }
                            case 81: {
                                return 1598;
                            }
                            case 82: {
                                return 1599;
                            }
                            case 83: {
                                return 1600;
                            }
                            case 84: {
                                return 1601;
                            }
                            case 85: {
                                return 1602;
                            }
                            case 86: {
                                return 1603;
                            }
                            case 87: {
                                return 1604;
                            }
                            case 88: {
                                return 1605;
                            }
                            case 89: {
                                return 1606;
                            }
                            case 90: {
                                return 1607;
                            }
                            case 91: {
                                return 1608;
                            }
                            case 92: {
                                return 1609;
                            }
                            case 93: {
                                return 1610;
                            }
                            case 94: {
                                return 1611;
                            }
                            case 95: {
                                return 1612;
                            }
                            case 96: {
                                return 77;
                            }
                            case 97: {
                                return 78;
                            }
                            case 98: {
                                return 79;
                            }
                            case 99: {
                                return 80;
                            }
                            case 100: {
                                return 1572;
                            }
                            case 101: {
                                return 81;
                            }
                            case 102: {
                                return 82;
                            }
                            case 103: {
                                return 83;
                            }
                            case 104: {
                                return 1613;
                            }
                            case 105: {
                                return 1614;
                            }
                            case 106: {
                                return 1615;
                            }
                            case 107: {
                                return 1616;
                            }
                            case 108: {
                                return 1617;
                            }
                            case 109: {
                                return 1618;
                            }
                            case 110: {
                                return 1619;
                            }
                            case 111: {
                                return 1620;
                            }
                            case 112: {
                                return 1621;
                            }
                            case 113: {
                                return 1622;
                            }
                            case 114: {
                                return 1623;
                            }
                            case 115: {
                                return 1624;
                            }
                            case 116: {
                                return 1625;
                            }
                            case 117: {
                                return 1626;
                            }
                            case 118: {
                                return 1627;
                            }
                            case 119: {
                                return 1628;
                            }
                            case 120: {
                                return 1629;
                            }
                            case 121: {
                                return 1630;
                            }
                            case 122: {
                                return 1631;
                            }
                            case 123: {
                                return 1632;
                            }
                            case 124: {
                                return 1633;
                            }
                            case 125: {
                                return 1634;
                            }
                            case 126: {
                                return 1635;
                            }
                            case 127: {
                                return 1636;
                            }
                            case 128: {
                                return 1637;
                            }
                            case 129: {
                                return 1638;
                            }
                            case 130: {
                                return 1639;
                            }
                            case 131: {
                                return 1640;
                            }
                            case 132: {
                                return 1641;
                            }
                            case 133: {
                                return 1642;
                            }
                            case 134: {
                                return 1643;
                            }
                            case 135: {
                                return 1644;
                            }
                            case 136: {
                                return 1645;
                            }
                            case 137: {
                                return 1646;
                            }
                            case 138: {
                                return 1647;
                            }
                            case 139: {
                                return 1648;
                            }
                            case 140: {
                                return 1649;
                            }
                            case 141: {
                                return 1650;
                            }
                            case 142: {
                                return 1651;
                            }
                            case 143: {
                                return 1652;
                            }
                            case 144: {
                                return 1653;
                            }
                            case 145: {
                                return 1654;
                            }
                            case 146: {
                                return 1655;
                            }
                            case 147: {
                                return 1656;
                            }
                            case 148: {
                                return 1657;
                            }
                            case 149: {
                                return 1658;
                            }
                            case 150: {
                                return 1659;
                            }
                            case 151: {
                                return 1660;
                            }
                            case 152: {
                                return 1661;
                            }
                            case 153: {
                                return 1662;
                            }
                            case 154: {
                                return 1663;
                            }
                            case 155: {
                                return 1664;
                            }
                            case 156: {
                                return 1665;
                            }
                            case 157: {
                                return 1666;
                            }
                            case 158: {
                                return 1667;
                            }
                            case 159: {
                                return 1668;
                            }
                            case 160: {
                                return 77;
                            }
                            case 161: {
                                return 78;
                            }
                            case 162: {
                                return 79;
                            }
                            case 163: {
                                return 80;
                            }
                            case 164: {
                                return 1572;
                            }
                            case 165: {
                                return 81;
                            }
                            case 166: {
                                return 82;
                            }
                            case 167: {
                                return 83;
                            }
                            case 168: {
                                return 1669;
                            }
                            case 169: {
                                return 1670;
                            }
                            case 170: {
                                return 1671;
                            }
                            case 171: {
                                return 1672;
                            }
                            case 172: {
                                return 1673;
                            }
                            case 173: {
                                return 1674;
                            }
                            case 174: {
                                return 1675;
                            }
                            case 175: {
                                return 1676;
                            }
                            case 176: {
                                return 1677;
                            }
                            case 177: {
                                return 1678;
                            }
                            case 178: {
                                return 1679;
                            }
                            case 179: {
                                return 1680;
                            }
                            case 180: {
                                return 1681;
                            }
                            case 181: {
                                return 1682;
                            }
                            case 182: {
                                return 1683;
                            }
                            case 183: {
                                return 1684;
                            }
                            case 184: {
                                return 1685;
                            }
                            case 185: {
                                return 1686;
                            }
                            case 186: {
                                return 1687;
                            }
                            case 187: {
                                return 1688;
                            }
                            case 188: {
                                return 1689;
                            }
                            case 189: {
                                return 1690;
                            }
                            case 190: {
                                return 1691;
                            }
                            case 191: {
                                return 1692;
                            }
                            case 192: {
                                return 1693;
                            }
                            case 193: {
                                return 1694;
                            }
                            case 194: {
                                return 1695;
                            }
                            case 195: {
                                return 1696;
                            }
                            case 196: {
                                return 1697;
                            }
                            case 197: {
                                return 1698;
                            }
                            case 198: {
                                return 1699;
                            }
                            case 199: {
                                return 1700;
                            }
                            case 200: {
                                return 1701;
                            }
                            case 201: {
                                return 1702;
                            }
                            case 202: {
                                return 1703;
                            }
                            case 203: {
                                return 1704;
                            }
                            case 204: {
                                return 1705;
                            }
                            case 205: {
                                return 1706;
                            }
                            case 206: {
                                return 1707;
                            }
                            case 207: {
                                return 1708;
                            }
                            case 208: {
                                return 1709;
                            }
                            case 209: {
                                return 1710;
                            }
                            case 210: {
                                return 1711;
                            }
                            case 211: {
                                return 1712;
                            }
                            case 212: {
                                return 1713;
                            }
                            case 213: {
                                return 1714;
                            }
                            case 214: {
                                return 1715;
                            }
                            case 215: {
                                return 1716;
                            }
                            case 216: {
                                return 1717;
                            }
                            case 217: {
                                return 1718;
                            }
                            case 218: {
                                return 1719;
                            }
                            case 219: {
                                return 1720;
                            }
                            case 220: {
                                return 1721;
                            }
                            case 221: {
                                return 1722;
                            }
                            case 222: {
                                return 1723;
                            }
                            case 223: {
                                return 1724;
                            }
                            case 224: {
                                return 77;
                            }
                            case 225: {
                                return 78;
                            }
                            case 226: {
                                return 79;
                            }
                            case 227: {
                                return 80;
                            }
                            case 228: {
                                return 1572;
                            }
                            case 229: {
                                return 81;
                            }
                            case 230: {
                                return 82;
                            }
                            case 231: {
                                return 83;
                            }
                            case 232: {
                                return 1725;
                            }
                            case 233: {
                                return 1726;
                            }
                            case 234: {
                                return 1727;
                            }
                            case 235: {
                                return 1728;
                            }
                            case 236: {
                                return 1729;
                            }
                            case 237: {
                                return 1730;
                            }
                            case 238: {
                                return 1731;
                            }
                            case 239: {
                                return 1732;
                            }
                            case 240: {
                                return 1733;
                            }
                            case 241: {
                                return 1734;
                            }
                            case 242: {
                                return 1735;
                            }
                            case 243: {
                                return 1736;
                            }
                            case 244: {
                                return 1737;
                            }
                            case 245: {
                                return 1738;
                            }
                            case 246: {
                                return 1739;
                            }
                            case 247: {
                                return 1740;
                            }
                            case 248: {
                                return 1741;
                            }
                            case 249: {
                                return 1742;
                            }
                            case 250: {
                                return 1743;
                            }
                            case 251: {
                                return 1744;
                            }
                            case 252: {
                                return 1745;
                            }
                            case 253: {
                                return 1746;
                            }
                            case 254: {
                                return 1747;
                            }
                            case 255: 
                        }
                        return 1748;
                    }
                    case 64: {
                        switch (n3) {
                            default: {
                                return -1;
                            }
                            case 0: {
                                return 1749;
                            }
                            case 1: {
                                return 1750;
                            }
                            case 2: {
                                return 1751;
                            }
                            case 3: {
                                return 1752;
                            }
                            case 4: {
                                return 1753;
                            }
                            case 5: {
                                return 1754;
                            }
                            case 6: {
                                return 1755;
                            }
                            case 7: {
                                return 1756;
                            }
                            case 8: {
                                return 1750;
                            }
                            case 9: {
                                return 1757;
                            }
                            case 10: {
                                return 1758;
                            }
                            case 11: {
                                return 1759;
                            }
                            case 12: {
                                return 1760;
                            }
                            case 13: {
                                return 1761;
                            }
                            case 14: {
                                return 1762;
                            }
                            case 15: {
                                return 1763;
                            }
                            case 16: {
                                return 1751;
                            }
                            case 17: {
                                return 1758;
                            }
                            case 18: {
                                return 1764;
                            }
                            case 19: {
                                return 1765;
                            }
                            case 20: {
                                return 1766;
                            }
                            case 21: {
                                return 1767;
                            }
                            case 22: {
                                return 1768;
                            }
                            case 23: {
                                return 1769;
                            }
                            case 24: {
                                return 1752;
                            }
                            case 25: {
                                return 1759;
                            }
                            case 26: {
                                return 1765;
                            }
                            case 27: {
                                return 1770;
                            }
                            case 28: {
                                return 1771;
                            }
                            case 29: {
                                return 1772;
                            }
                            case 30: {
                                return 1773;
                            }
                            case 31: {
                                return 1774;
                            }
                            case 32: {
                                return 84;
                            }
                            case 33: {
                                return 85;
                            }
                            case 34: {
                                return 86;
                            }
                            case 35: {
                                return 87;
                            }
                            case 36: {
                                return 1775;
                            }
                            case 37: {
                                return 88;
                            }
                            case 38: {
                                return 89;
                            }
                            case 39: {
                                return 90;
                            }
                            case 40: {
                                return 1754;
                            }
                            case 41: {
                                return 1761;
                            }
                            case 42: {
                                return 1767;
                            }
                            case 43: {
                                return 1772;
                            }
                            case 44: {
                                return 1776;
                            }
                            case 45: {
                                return 1777;
                            }
                            case 46: {
                                return 1778;
                            }
                            case 47: {
                                return 1779;
                            }
                            case 48: {
                                return 1755;
                            }
                            case 49: {
                                return 1762;
                            }
                            case 50: {
                                return 1768;
                            }
                            case 51: {
                                return 1773;
                            }
                            case 52: {
                                return 1780;
                            }
                            case 53: {
                                return 1778;
                            }
                            case 54: {
                                return 1781;
                            }
                            case 55: {
                                return 1782;
                            }
                            case 56: {
                                return 1756;
                            }
                            case 57: {
                                return 1763;
                            }
                            case 58: {
                                return 1769;
                            }
                            case 59: {
                                return 1774;
                            }
                            case 60: {
                                return 1783;
                            }
                            case 61: {
                                return 1779;
                            }
                            case 62: {
                                return 1782;
                            }
                            case 63: {
                                return 1784;
                            }
                            case 64: {
                                return 1785;
                            }
                            case 65: {
                                return 1786;
                            }
                            case 66: {
                                return 1787;
                            }
                            case 67: {
                                return 1788;
                            }
                            case 68: {
                                return 1789;
                            }
                            case 69: {
                                return 1790;
                            }
                            case 70: {
                                return 1791;
                            }
                            case 71: {
                                return 1792;
                            }
                            case 72: {
                                return 1793;
                            }
                            case 73: {
                                return 1794;
                            }
                            case 74: {
                                return 1795;
                            }
                            case 75: {
                                return 1796;
                            }
                            case 76: {
                                return 1797;
                            }
                            case 77: {
                                return 1798;
                            }
                            case 78: {
                                return 1799;
                            }
                            case 79: {
                                return 1800;
                            }
                            case 80: {
                                return 1801;
                            }
                            case 81: {
                                return 1802;
                            }
                            case 82: {
                                return 1803;
                            }
                            case 83: {
                                return 1804;
                            }
                            case 84: {
                                return 1805;
                            }
                            case 85: {
                                return 1806;
                            }
                            case 86: {
                                return 1807;
                            }
                            case 87: {
                                return 1808;
                            }
                            case 88: {
                                return 1809;
                            }
                            case 89: {
                                return 1810;
                            }
                            case 90: {
                                return 1811;
                            }
                            case 91: {
                                return 1812;
                            }
                            case 92: {
                                return 1813;
                            }
                            case 93: {
                                return 1814;
                            }
                            case 94: {
                                return 1815;
                            }
                            case 95: {
                                return 1816;
                            }
                            case 96: {
                                return 84;
                            }
                            case 97: {
                                return 85;
                            }
                            case 98: {
                                return 86;
                            }
                            case 99: {
                                return 87;
                            }
                            case 100: {
                                return 1775;
                            }
                            case 101: {
                                return 88;
                            }
                            case 102: {
                                return 89;
                            }
                            case 103: {
                                return 90;
                            }
                            case 104: {
                                return 1817;
                            }
                            case 105: {
                                return 1818;
                            }
                            case 106: {
                                return 1819;
                            }
                            case 107: {
                                return 1820;
                            }
                            case 108: {
                                return 1821;
                            }
                            case 109: {
                                return 1822;
                            }
                            case 110: {
                                return 1823;
                            }
                            case 111: {
                                return 1824;
                            }
                            case 112: {
                                return 1825;
                            }
                            case 113: {
                                return 1826;
                            }
                            case 114: {
                                return 1827;
                            }
                            case 115: {
                                return 1828;
                            }
                            case 116: {
                                return 1829;
                            }
                            case 117: {
                                return 1830;
                            }
                            case 118: {
                                return 1831;
                            }
                            case 119: {
                                return 1832;
                            }
                            case 120: {
                                return 1833;
                            }
                            case 121: {
                                return 1834;
                            }
                            case 122: {
                                return 1835;
                            }
                            case 123: {
                                return 1836;
                            }
                            case 124: {
                                return 1837;
                            }
                            case 125: {
                                return 1838;
                            }
                            case 126: {
                                return 1839;
                            }
                            case 127: {
                                return 1840;
                            }
                            case 128: {
                                return 1841;
                            }
                            case 129: {
                                return 1842;
                            }
                            case 130: {
                                return 1843;
                            }
                            case 131: {
                                return 1844;
                            }
                            case 132: {
                                return 1845;
                            }
                            case 133: {
                                return 1846;
                            }
                            case 134: {
                                return 1847;
                            }
                            case 135: {
                                return 1848;
                            }
                            case 136: {
                                return 1849;
                            }
                            case 137: {
                                return 1850;
                            }
                            case 138: {
                                return 1851;
                            }
                            case 139: {
                                return 1852;
                            }
                            case 140: {
                                return 1853;
                            }
                            case 141: {
                                return 1854;
                            }
                            case 142: {
                                return 1855;
                            }
                            case 143: {
                                return 1856;
                            }
                            case 144: {
                                return 1857;
                            }
                            case 145: {
                                return 1858;
                            }
                            case 146: {
                                return 1859;
                            }
                            case 147: {
                                return 1860;
                            }
                            case 148: {
                                return 1861;
                            }
                            case 149: {
                                return 1862;
                            }
                            case 150: {
                                return 1863;
                            }
                            case 151: {
                                return 1864;
                            }
                            case 152: {
                                return 1865;
                            }
                            case 153: {
                                return 1866;
                            }
                            case 154: {
                                return 1867;
                            }
                            case 155: {
                                return 1868;
                            }
                            case 156: {
                                return 1869;
                            }
                            case 157: {
                                return 1870;
                            }
                            case 158: {
                                return 1871;
                            }
                            case 159: {
                                return 1872;
                            }
                            case 160: {
                                return 84;
                            }
                            case 161: {
                                return 85;
                            }
                            case 162: {
                                return 86;
                            }
                            case 163: {
                                return 87;
                            }
                            case 164: {
                                return 1775;
                            }
                            case 165: {
                                return 88;
                            }
                            case 166: {
                                return 89;
                            }
                            case 167: {
                                return 90;
                            }
                            case 168: {
                                return 1873;
                            }
                            case 169: {
                                return 1874;
                            }
                            case 170: {
                                return 1875;
                            }
                            case 171: {
                                return 1876;
                            }
                            case 172: {
                                return 1877;
                            }
                            case 173: {
                                return 1878;
                            }
                            case 174: {
                                return 1879;
                            }
                            case 175: {
                                return 1880;
                            }
                            case 176: {
                                return 1881;
                            }
                            case 177: {
                                return 1882;
                            }
                            case 178: {
                                return 1883;
                            }
                            case 179: {
                                return 1884;
                            }
                            case 180: {
                                return 1885;
                            }
                            case 181: {
                                return 1886;
                            }
                            case 182: {
                                return 1887;
                            }
                            case 183: {
                                return 1888;
                            }
                            case 184: {
                                return 1889;
                            }
                            case 185: {
                                return 1890;
                            }
                            case 186: {
                                return 1891;
                            }
                            case 187: {
                                return 1892;
                            }
                            case 188: {
                                return 1893;
                            }
                            case 189: {
                                return 1894;
                            }
                            case 190: {
                                return 1895;
                            }
                            case 191: {
                                return 1896;
                            }
                            case 192: {
                                return 1897;
                            }
                            case 193: {
                                return 1898;
                            }
                            case 194: {
                                return 1899;
                            }
                            case 195: {
                                return 1900;
                            }
                            case 196: {
                                return 1901;
                            }
                            case 197: {
                                return 1902;
                            }
                            case 198: {
                                return 1903;
                            }
                            case 199: {
                                return 1904;
                            }
                            case 200: {
                                return 1905;
                            }
                            case 201: {
                                return 1906;
                            }
                            case 202: {
                                return 1907;
                            }
                            case 203: {
                                return 1908;
                            }
                            case 204: {
                                return 1909;
                            }
                            case 205: {
                                return 1910;
                            }
                            case 206: {
                                return 1911;
                            }
                            case 207: {
                                return 1912;
                            }
                            case 208: {
                                return 1913;
                            }
                            case 209: {
                                return 1914;
                            }
                            case 210: {
                                return 1915;
                            }
                            case 211: {
                                return 1916;
                            }
                            case 212: {
                                return 1917;
                            }
                            case 213: {
                                return 1918;
                            }
                            case 214: {
                                return 1919;
                            }
                            case 215: {
                                return 1920;
                            }
                            case 216: {
                                return 1921;
                            }
                            case 217: {
                                return 1922;
                            }
                            case 218: {
                                return 1923;
                            }
                            case 219: {
                                return 1924;
                            }
                            case 220: {
                                return 1925;
                            }
                            case 221: {
                                return 1926;
                            }
                            case 222: {
                                return 1927;
                            }
                            case 223: {
                                return 1928;
                            }
                            case 224: {
                                return 84;
                            }
                            case 225: {
                                return 85;
                            }
                            case 226: {
                                return 86;
                            }
                            case 227: {
                                return 87;
                            }
                            case 228: {
                                return 1775;
                            }
                            case 229: {
                                return 88;
                            }
                            case 230: {
                                return 89;
                            }
                            case 231: {
                                return 90;
                            }
                            case 232: {
                                return 1929;
                            }
                            case 233: {
                                return 1930;
                            }
                            case 234: {
                                return 1931;
                            }
                            case 235: {
                                return 1932;
                            }
                            case 236: {
                                return 1933;
                            }
                            case 237: {
                                return 1934;
                            }
                            case 238: {
                                return 1935;
                            }
                            case 239: {
                                return 1936;
                            }
                            case 240: {
                                return 1937;
                            }
                            case 241: {
                                return 1938;
                            }
                            case 242: {
                                return 1939;
                            }
                            case 243: {
                                return 1940;
                            }
                            case 244: {
                                return 1941;
                            }
                            case 245: {
                                return 1942;
                            }
                            case 246: {
                                return 1943;
                            }
                            case 247: {
                                return 1944;
                            }
                            case 248: {
                                return 1945;
                            }
                            case 249: {
                                return 1946;
                            }
                            case 250: {
                                return 1947;
                            }
                            case 251: {
                                return 1948;
                            }
                            case 252: {
                                return 1949;
                            }
                            case 253: {
                                return 1950;
                            }
                            case 254: {
                                return 1951;
                            }
                            case 255: 
                        }
                        return 1952;
                    }
                    case 128: 
                }
                switch (n3) {
                    default: {
                        return -1;
                    }
                    case 0: {
                        return 1586;
                    }
                    case 1: {
                        return 1953;
                    }
                    case 2: {
                        return 1954;
                    }
                    case 3: {
                        return 1955;
                    }
                    case 4: {
                        return 1956;
                    }
                    case 5: {
                        return 1957;
                    }
                    case 6: {
                        return 1958;
                    }
                    case 7: {
                        return 1959;
                    }
                    case 8: {
                        return 1953;
                    }
                    case 9: {
                        return 1594;
                    }
                    case 10: {
                        return 1960;
                    }
                    case 11: {
                        return 1961;
                    }
                    case 12: {
                        return 1962;
                    }
                    case 13: {
                        return 1963;
                    }
                    case 14: {
                        return 1964;
                    }
                    case 15: {
                        return 1965;
                    }
                    case 16: {
                        return 1954;
                    }
                    case 17: {
                        return 1960;
                    }
                    case 18: {
                        return 1602;
                    }
                    case 19: {
                        return 1966;
                    }
                    case 20: {
                        return 1967;
                    }
                    case 21: {
                        return 1968;
                    }
                    case 22: {
                        return 1969;
                    }
                    case 23: {
                        return 1970;
                    }
                    case 24: {
                        return 1955;
                    }
                    case 25: {
                        return 1961;
                    }
                    case 26: {
                        return 1966;
                    }
                    case 27: {
                        return 1610;
                    }
                    case 28: {
                        return 1971;
                    }
                    case 29: {
                        return 1972;
                    }
                    case 30: {
                        return 1973;
                    }
                    case 31: {
                        return 1974;
                    }
                    case 32: {
                        return 91;
                    }
                    case 33: {
                        return 92;
                    }
                    case 34: {
                        return 93;
                    }
                    case 35: {
                        return 94;
                    }
                    case 36: {
                        return 1975;
                    }
                    case 37: {
                        return 95;
                    }
                    case 38: {
                        return 96;
                    }
                    case 39: {
                        return 97;
                    }
                    case 40: {
                        return 1957;
                    }
                    case 41: {
                        return 1963;
                    }
                    case 42: {
                        return 1968;
                    }
                    case 43: {
                        return 1972;
                    }
                    case 44: {
                        return 1976;
                    }
                    case 45: {
                        return 1618;
                    }
                    case 46: {
                        return 1977;
                    }
                    case 47: {
                        return 1978;
                    }
                    case 48: {
                        return 1958;
                    }
                    case 49: {
                        return 1964;
                    }
                    case 50: {
                        return 1969;
                    }
                    case 51: {
                        return 1973;
                    }
                    case 52: {
                        return 1979;
                    }
                    case 53: {
                        return 1977;
                    }
                    case 54: {
                        return 1626;
                    }
                    case 55: {
                        return 1980;
                    }
                    case 56: {
                        return 1959;
                    }
                    case 57: {
                        return 1965;
                    }
                    case 58: {
                        return 1970;
                    }
                    case 59: {
                        return 1974;
                    }
                    case 60: {
                        return 1981;
                    }
                    case 61: {
                        return 1978;
                    }
                    case 62: {
                        return 1980;
                    }
                    case 63: {
                        return 1634;
                    }
                    case 64: {
                        return 1982;
                    }
                    case 65: {
                        return 1983;
                    }
                    case 66: {
                        return 1984;
                    }
                    case 67: {
                        return 1985;
                    }
                    case 68: {
                        return 1986;
                    }
                    case 69: {
                        return 1987;
                    }
                    case 70: {
                        return 1988;
                    }
                    case 71: {
                        return 1989;
                    }
                    case 72: {
                        return 1990;
                    }
                    case 73: {
                        return 1991;
                    }
                    case 74: {
                        return 1992;
                    }
                    case 75: {
                        return 1993;
                    }
                    case 76: {
                        return 1994;
                    }
                    case 77: {
                        return 1995;
                    }
                    case 78: {
                        return 1996;
                    }
                    case 79: {
                        return 1997;
                    }
                    case 80: {
                        return 1998;
                    }
                    case 81: {
                        return 1999;
                    }
                    case 82: {
                        return 2000;
                    }
                    case 83: {
                        return 2001;
                    }
                    case 84: {
                        return 2002;
                    }
                    case 85: {
                        return 2003;
                    }
                    case 86: {
                        return 2004;
                    }
                    case 87: {
                        return 2005;
                    }
                    case 88: {
                        return 2006;
                    }
                    case 89: {
                        return 2007;
                    }
                    case 90: {
                        return 2008;
                    }
                    case 91: {
                        return 2009;
                    }
                    case 92: {
                        return 2010;
                    }
                    case 93: {
                        return 2011;
                    }
                    case 94: {
                        return 2012;
                    }
                    case 95: {
                        return 2013;
                    }
                    case 96: {
                        return 91;
                    }
                    case 97: {
                        return 92;
                    }
                    case 98: {
                        return 93;
                    }
                    case 99: {
                        return 94;
                    }
                    case 100: {
                        return 1975;
                    }
                    case 101: {
                        return 95;
                    }
                    case 102: {
                        return 96;
                    }
                    case 103: {
                        return 97;
                    }
                    case 104: {
                        return 2014;
                    }
                    case 105: {
                        return 2015;
                    }
                    case 106: {
                        return 2016;
                    }
                    case 107: {
                        return 2017;
                    }
                    case 108: {
                        return 2018;
                    }
                    case 109: {
                        return 2019;
                    }
                    case 110: {
                        return 2020;
                    }
                    case 111: {
                        return 2021;
                    }
                    case 112: {
                        return 2022;
                    }
                    case 113: {
                        return 2023;
                    }
                    case 114: {
                        return 2024;
                    }
                    case 115: {
                        return 2025;
                    }
                    case 116: {
                        return 2026;
                    }
                    case 117: {
                        return 2027;
                    }
                    case 118: {
                        return 2028;
                    }
                    case 119: {
                        return 2029;
                    }
                    case 120: {
                        return 2030;
                    }
                    case 121: {
                        return 2031;
                    }
                    case 122: {
                        return 2032;
                    }
                    case 123: {
                        return 2033;
                    }
                    case 124: {
                        return 2034;
                    }
                    case 125: {
                        return 2035;
                    }
                    case 126: {
                        return 2036;
                    }
                    case 127: {
                        return 2037;
                    }
                    case 128: {
                        return 2038;
                    }
                    case 129: {
                        return 2039;
                    }
                    case 130: {
                        return 2040;
                    }
                    case 131: {
                        return 2041;
                    }
                    case 132: {
                        return 2042;
                    }
                    case 133: {
                        return 2043;
                    }
                    case 134: {
                        return 2044;
                    }
                    case 135: {
                        return 2045;
                    }
                    case 136: {
                        return 2046;
                    }
                    case 137: {
                        return 2047;
                    }
                    case 138: {
                        return 2048;
                    }
                    case 139: {
                        return 2049;
                    }
                    case 140: {
                        return 2050;
                    }
                    case 141: {
                        return 2051;
                    }
                    case 142: {
                        return 2052;
                    }
                    case 143: {
                        return 2053;
                    }
                    case 144: {
                        return 2054;
                    }
                    case 145: {
                        return 2055;
                    }
                    case 146: {
                        return 2056;
                    }
                    case 147: {
                        return 2057;
                    }
                    case 148: {
                        return 2058;
                    }
                    case 149: {
                        return 2059;
                    }
                    case 150: {
                        return 2060;
                    }
                    case 151: {
                        return 2061;
                    }
                    case 152: {
                        return 2062;
                    }
                    case 153: {
                        return 2063;
                    }
                    case 154: {
                        return 2064;
                    }
                    case 155: {
                        return 2065;
                    }
                    case 156: {
                        return 2066;
                    }
                    case 157: {
                        return 2067;
                    }
                    case 158: {
                        return 2068;
                    }
                    case 159: {
                        return 2069;
                    }
                    case 160: {
                        return 91;
                    }
                    case 161: {
                        return 92;
                    }
                    case 162: {
                        return 93;
                    }
                    case 163: {
                        return 94;
                    }
                    case 164: {
                        return 1975;
                    }
                    case 165: {
                        return 95;
                    }
                    case 166: {
                        return 96;
                    }
                    case 167: {
                        return 97;
                    }
                    case 168: {
                        return 2070;
                    }
                    case 169: {
                        return 2071;
                    }
                    case 170: {
                        return 2072;
                    }
                    case 171: {
                        return 2073;
                    }
                    case 172: {
                        return 2074;
                    }
                    case 173: {
                        return 2075;
                    }
                    case 174: {
                        return 2076;
                    }
                    case 175: {
                        return 2077;
                    }
                    case 176: {
                        return 2078;
                    }
                    case 177: {
                        return 2079;
                    }
                    case 178: {
                        return 2080;
                    }
                    case 179: {
                        return 2081;
                    }
                    case 180: {
                        return 2082;
                    }
                    case 181: {
                        return 2083;
                    }
                    case 182: {
                        return 2084;
                    }
                    case 183: {
                        return 2085;
                    }
                    case 184: {
                        return 2086;
                    }
                    case 185: {
                        return 2087;
                    }
                    case 186: {
                        return 2088;
                    }
                    case 187: {
                        return 2089;
                    }
                    case 188: {
                        return 2090;
                    }
                    case 189: {
                        return 2091;
                    }
                    case 190: {
                        return 2092;
                    }
                    case 191: {
                        return 2093;
                    }
                    case 192: {
                        return 2094;
                    }
                    case 193: {
                        return 2095;
                    }
                    case 194: {
                        return 2096;
                    }
                    case 195: {
                        return 2097;
                    }
                    case 196: {
                        return 2098;
                    }
                    case 197: {
                        return 2099;
                    }
                    case 198: {
                        return 2100;
                    }
                    case 199: {
                        return 2101;
                    }
                    case 200: {
                        return 2102;
                    }
                    case 201: {
                        return 2103;
                    }
                    case 202: {
                        return 2104;
                    }
                    case 203: {
                        return 2105;
                    }
                    case 204: {
                        return 2106;
                    }
                    case 205: {
                        return 2107;
                    }
                    case 206: {
                        return 2108;
                    }
                    case 207: {
                        return 2109;
                    }
                    case 208: {
                        return 2110;
                    }
                    case 209: {
                        return 2111;
                    }
                    case 210: {
                        return 2112;
                    }
                    case 211: {
                        return 2113;
                    }
                    case 212: {
                        return 2114;
                    }
                    case 213: {
                        return 2115;
                    }
                    case 214: {
                        return 2116;
                    }
                    case 215: {
                        return 2117;
                    }
                    case 216: {
                        return 2118;
                    }
                    case 217: {
                        return 2119;
                    }
                    case 218: {
                        return 2120;
                    }
                    case 219: {
                        return 2121;
                    }
                    case 220: {
                        return 2122;
                    }
                    case 221: {
                        return 2123;
                    }
                    case 222: {
                        return 2124;
                    }
                    case 223: {
                        return 2125;
                    }
                    case 224: {
                        return 91;
                    }
                    case 225: {
                        return 92;
                    }
                    case 226: {
                        return 93;
                    }
                    case 227: {
                        return 94;
                    }
                    case 228: {
                        return 1975;
                    }
                    case 229: {
                        return 95;
                    }
                    case 230: {
                        return 96;
                    }
                    case 231: {
                        return 97;
                    }
                    case 232: {
                        return 2126;
                    }
                    case 233: {
                        return 2127;
                    }
                    case 234: {
                        return 2128;
                    }
                    case 235: {
                        return 2129;
                    }
                    case 236: {
                        return 2130;
                    }
                    case 237: {
                        return 2131;
                    }
                    case 238: {
                        return 2132;
                    }
                    case 239: {
                        return 2133;
                    }
                    case 240: {
                        return 2134;
                    }
                    case 241: {
                        return 2135;
                    }
                    case 242: {
                        return 2136;
                    }
                    case 243: {
                        return 2137;
                    }
                    case 244: {
                        return 2138;
                    }
                    case 245: {
                        return 2139;
                    }
                    case 246: {
                        return 2140;
                    }
                    case 247: {
                        return 2141;
                    }
                    case 248: {
                        return 2142;
                    }
                    case 249: {
                        return 2143;
                    }
                    case 250: {
                        return 2144;
                    }
                    case 251: {
                        return 2145;
                    }
                    case 252: {
                        return 2146;
                    }
                    case 253: {
                        return 2147;
                    }
                    case 254: {
                        return 2148;
                    }
                    case 255: 
                }
                return 2149;
            }
            case 3: {
                switch (n2 & 0xC0) {
                    default: {
                        return -1;
                    }
                    case 0: {
                        switch (n3) {
                            default: {
                                return -1;
                            }
                            case 0: {
                                return 2150;
                            }
                            case 1: {
                                return 2151;
                            }
                            case 2: {
                                return 2152;
                            }
                            case 3: {
                                return 2153;
                            }
                            case 4: {
                                return 2154;
                            }
                            case 5: {
                                return 112;
                            }
                            case 6: {
                                return 2156;
                            }
                            case 7: {
                                return 2157;
                            }
                            case 8: {
                                return 2151;
                            }
                            case 9: {
                                return 2158;
                            }
                            case 10: {
                                return 2159;
                            }
                            case 11: {
                                return 2160;
                            }
                            case 12: {
                                return 2161;
                            }
                            case 13: {
                                return 113;
                            }
                            case 14: {
                                return 2163;
                            }
                            case 15: {
                                return 2164;
                            }
                            case 16: {
                                return 2152;
                            }
                            case 17: {
                                return 2159;
                            }
                            case 18: {
                                return 2165;
                            }
                            case 19: {
                                return 2166;
                            }
                            case 20: {
                                return 2167;
                            }
                            case 21: {
                                return 114;
                            }
                            case 22: {
                                return 2169;
                            }
                            case 23: {
                                return 2170;
                            }
                            case 24: {
                                return 2153;
                            }
                            case 25: {
                                return 2160;
                            }
                            case 26: {
                                return 2166;
                            }
                            case 27: {
                                return 2171;
                            }
                            case 28: {
                                return 2172;
                            }
                            case 29: {
                                return 115;
                            }
                            case 30: {
                                return 2174;
                            }
                            case 31: {
                                return 2175;
                            }
                            case 32: {
                                return 98;
                            }
                            case 33: {
                                return 99;
                            }
                            case 34: {
                                return 100;
                            }
                            case 35: {
                                return 101;
                            }
                            case 36: {
                                return 2176;
                            }
                            case 37: {
                                return 102;
                            }
                            case 38: {
                                return 103;
                            }
                            case 39: {
                                return 104;
                            }
                            case 40: {
                                return 2155;
                            }
                            case 41: {
                                return 2162;
                            }
                            case 42: {
                                return 2168;
                            }
                            case 43: {
                                return 2173;
                            }
                            case 44: {
                                return 2177;
                            }
                            case 45: {
                                return 116;
                            }
                            case 46: {
                                return 2178;
                            }
                            case 47: {
                                return 2179;
                            }
                            case 48: {
                                return 2156;
                            }
                            case 49: {
                                return 2163;
                            }
                            case 50: {
                                return 2169;
                            }
                            case 51: {
                                return 2174;
                            }
                            case 52: {
                                return 2180;
                            }
                            case 53: {
                                return 117;
                            }
                            case 54: {
                                return 2181;
                            }
                            case 55: {
                                return 2182;
                            }
                            case 56: {
                                return 2157;
                            }
                            case 57: {
                                return 2164;
                            }
                            case 58: {
                                return 2170;
                            }
                            case 59: {
                                return 2175;
                            }
                            case 60: {
                                return 2183;
                            }
                            case 61: {
                                return 118;
                            }
                            case 62: {
                                return 2182;
                            }
                            case 63: {
                                return 2184;
                            }
                            case 64: {
                                return 2185;
                            }
                            case 65: {
                                return 2186;
                            }
                            case 66: {
                                return 2187;
                            }
                            case 67: {
                                return 2188;
                            }
                            case 68: {
                                return 2189;
                            }
                            case 69: {
                                return 2190;
                            }
                            case 70: {
                                return 2191;
                            }
                            case 71: {
                                return 2192;
                            }
                            case 72: {
                                return 2193;
                            }
                            case 73: {
                                return 2194;
                            }
                            case 74: {
                                return 2195;
                            }
                            case 75: {
                                return 2196;
                            }
                            case 76: {
                                return 2197;
                            }
                            case 77: {
                                return 2198;
                            }
                            case 78: {
                                return 2199;
                            }
                            case 79: {
                                return 2200;
                            }
                            case 80: {
                                return 2201;
                            }
                            case 81: {
                                return 2202;
                            }
                            case 82: {
                                return 2203;
                            }
                            case 83: {
                                return 2204;
                            }
                            case 84: {
                                return 2205;
                            }
                            case 85: {
                                return 2206;
                            }
                            case 86: {
                                return 2207;
                            }
                            case 87: {
                                return 2208;
                            }
                            case 88: {
                                return 2209;
                            }
                            case 89: {
                                return 2210;
                            }
                            case 90: {
                                return 2211;
                            }
                            case 91: {
                                return 2212;
                            }
                            case 92: {
                                return 2213;
                            }
                            case 93: {
                                return 2214;
                            }
                            case 94: {
                                return 2215;
                            }
                            case 95: {
                                return 2216;
                            }
                            case 96: {
                                return 98;
                            }
                            case 97: {
                                return 99;
                            }
                            case 98: {
                                return 100;
                            }
                            case 99: {
                                return 101;
                            }
                            case 100: {
                                return 2176;
                            }
                            case 101: {
                                return 102;
                            }
                            case 102: {
                                return 103;
                            }
                            case 103: {
                                return 104;
                            }
                            case 104: {
                                return 2217;
                            }
                            case 105: {
                                return 2218;
                            }
                            case 106: {
                                return 2219;
                            }
                            case 107: {
                                return 2220;
                            }
                            case 108: {
                                return 2221;
                            }
                            case 109: {
                                return 2222;
                            }
                            case 110: {
                                return 2223;
                            }
                            case 111: {
                                return 2224;
                            }
                            case 112: {
                                return 2225;
                            }
                            case 113: {
                                return 2226;
                            }
                            case 114: {
                                return 2227;
                            }
                            case 115: {
                                return 2228;
                            }
                            case 116: {
                                return 2229;
                            }
                            case 117: {
                                return 2230;
                            }
                            case 118: {
                                return 2231;
                            }
                            case 119: {
                                return 2232;
                            }
                            case 120: {
                                return 2233;
                            }
                            case 121: {
                                return 2234;
                            }
                            case 122: {
                                return 2235;
                            }
                            case 123: {
                                return 2236;
                            }
                            case 124: {
                                return 2237;
                            }
                            case 125: {
                                return 2238;
                            }
                            case 126: {
                                return 2239;
                            }
                            case 127: {
                                return 2240;
                            }
                            case 128: {
                                return 2241;
                            }
                            case 129: {
                                return 2242;
                            }
                            case 130: {
                                return 2243;
                            }
                            case 131: {
                                return 2244;
                            }
                            case 132: {
                                return 2245;
                            }
                            case 133: {
                                return 2246;
                            }
                            case 134: {
                                return 2247;
                            }
                            case 135: {
                                return 2248;
                            }
                            case 136: {
                                return 2249;
                            }
                            case 137: {
                                return 2250;
                            }
                            case 138: {
                                return 2251;
                            }
                            case 139: {
                                return 2252;
                            }
                            case 140: {
                                return 2253;
                            }
                            case 141: {
                                return 2254;
                            }
                            case 142: {
                                return 2255;
                            }
                            case 143: {
                                return 2256;
                            }
                            case 144: {
                                return 2257;
                            }
                            case 145: {
                                return 2258;
                            }
                            case 146: {
                                return 2259;
                            }
                            case 147: {
                                return 2260;
                            }
                            case 148: {
                                return 2261;
                            }
                            case 149: {
                                return 2262;
                            }
                            case 150: {
                                return 2263;
                            }
                            case 151: {
                                return 2264;
                            }
                            case 152: {
                                return 2265;
                            }
                            case 153: {
                                return 2266;
                            }
                            case 154: {
                                return 2267;
                            }
                            case 155: {
                                return 2268;
                            }
                            case 156: {
                                return 2269;
                            }
                            case 157: {
                                return 2270;
                            }
                            case 158: {
                                return 2271;
                            }
                            case 159: {
                                return 2272;
                            }
                            case 160: {
                                return 98;
                            }
                            case 161: {
                                return 99;
                            }
                            case 162: {
                                return 100;
                            }
                            case 163: {
                                return 101;
                            }
                            case 164: {
                                return 2176;
                            }
                            case 165: {
                                return 102;
                            }
                            case 166: {
                                return 103;
                            }
                            case 167: {
                                return 104;
                            }
                            case 168: {
                                return 2273;
                            }
                            case 169: {
                                return 2274;
                            }
                            case 170: {
                                return 2275;
                            }
                            case 171: {
                                return 2276;
                            }
                            case 172: {
                                return 2277;
                            }
                            case 173: {
                                return 2278;
                            }
                            case 174: {
                                return 2279;
                            }
                            case 175: {
                                return 2280;
                            }
                            case 176: {
                                return 2281;
                            }
                            case 177: {
                                return 2282;
                            }
                            case 178: {
                                return 2283;
                            }
                            case 179: {
                                return 2284;
                            }
                            case 180: {
                                return 2285;
                            }
                            case 181: {
                                return 2286;
                            }
                            case 182: {
                                return 2287;
                            }
                            case 183: {
                                return 2288;
                            }
                            case 184: {
                                return 2289;
                            }
                            case 185: {
                                return 2290;
                            }
                            case 186: {
                                return 2291;
                            }
                            case 187: {
                                return 2292;
                            }
                            case 188: {
                                return 2293;
                            }
                            case 189: {
                                return 2294;
                            }
                            case 190: {
                                return 2295;
                            }
                            case 191: {
                                return 2296;
                            }
                            case 192: {
                                return 2297;
                            }
                            case 193: {
                                return 2298;
                            }
                            case 194: {
                                return 2299;
                            }
                            case 195: {
                                return 2300;
                            }
                            case 196: {
                                return 2301;
                            }
                            case 197: {
                                return 2302;
                            }
                            case 198: {
                                return 2303;
                            }
                            case 199: {
                                return 2304;
                            }
                            case 200: {
                                return 2305;
                            }
                            case 201: {
                                return 2306;
                            }
                            case 202: {
                                return 2307;
                            }
                            case 203: {
                                return 2308;
                            }
                            case 204: {
                                return 2309;
                            }
                            case 205: {
                                return 2310;
                            }
                            case 206: {
                                return 2311;
                            }
                            case 207: {
                                return 2312;
                            }
                            case 208: {
                                return 2313;
                            }
                            case 209: {
                                return 2314;
                            }
                            case 210: {
                                return 2315;
                            }
                            case 211: {
                                return 2316;
                            }
                            case 212: {
                                return 2317;
                            }
                            case 213: {
                                return 2318;
                            }
                            case 214: {
                                return 2319;
                            }
                            case 215: {
                                return 2320;
                            }
                            case 216: {
                                return 2321;
                            }
                            case 217: {
                                return 2322;
                            }
                            case 218: {
                                return 2323;
                            }
                            case 219: {
                                return 2324;
                            }
                            case 220: {
                                return 2325;
                            }
                            case 221: {
                                return 2326;
                            }
                            case 222: {
                                return 2327;
                            }
                            case 223: {
                                return 2328;
                            }
                            case 224: {
                                return 98;
                            }
                            case 225: {
                                return 99;
                            }
                            case 226: {
                                return 100;
                            }
                            case 227: {
                                return 101;
                            }
                            case 228: {
                                return 2176;
                            }
                            case 229: {
                                return 102;
                            }
                            case 230: {
                                return 103;
                            }
                            case 231: {
                                return 104;
                            }
                            case 232: {
                                return 2329;
                            }
                            case 233: {
                                return 2330;
                            }
                            case 234: {
                                return 2331;
                            }
                            case 235: {
                                return 2332;
                            }
                            case 236: {
                                return 2333;
                            }
                            case 237: {
                                return 2334;
                            }
                            case 238: {
                                return 2335;
                            }
                            case 239: {
                                return 2336;
                            }
                            case 240: {
                                return 2337;
                            }
                            case 241: {
                                return 2338;
                            }
                            case 242: {
                                return 2339;
                            }
                            case 243: {
                                return 2340;
                            }
                            case 244: {
                                return 2341;
                            }
                            case 245: {
                                return 2342;
                            }
                            case 246: {
                                return 2343;
                            }
                            case 247: {
                                return 2344;
                            }
                            case 248: {
                                return 2345;
                            }
                            case 249: {
                                return 2346;
                            }
                            case 250: {
                                return 2347;
                            }
                            case 251: {
                                return 2348;
                            }
                            case 252: {
                                return 2349;
                            }
                            case 253: {
                                return 2350;
                            }
                            case 254: {
                                return 2351;
                            }
                            case 255: 
                        }
                        return 2352;
                    }
                    case 64: {
                        switch (n3) {
                            default: {
                                return -1;
                            }
                            case 0: {
                                return 2353;
                            }
                            case 1: {
                                return 2354;
                            }
                            case 2: {
                                return 2355;
                            }
                            case 3: {
                                return 2356;
                            }
                            case 4: {
                                return 2357;
                            }
                            case 5: {
                                return 2358;
                            }
                            case 6: {
                                return 2359;
                            }
                            case 7: {
                                return 2360;
                            }
                            case 8: {
                                return 2354;
                            }
                            case 9: {
                                return 2361;
                            }
                            case 10: {
                                return 2362;
                            }
                            case 11: {
                                return 2363;
                            }
                            case 12: {
                                return 2364;
                            }
                            case 13: {
                                return 2365;
                            }
                            case 14: {
                                return 2366;
                            }
                            case 15: {
                                return 2367;
                            }
                            case 16: {
                                return 2355;
                            }
                            case 17: {
                                return 2362;
                            }
                            case 18: {
                                return 2368;
                            }
                            case 19: {
                                return 2369;
                            }
                            case 20: {
                                return 2370;
                            }
                            case 21: {
                                return 2371;
                            }
                            case 22: {
                                return 2372;
                            }
                            case 23: {
                                return 2373;
                            }
                            case 24: {
                                return 2356;
                            }
                            case 25: {
                                return 2363;
                            }
                            case 26: {
                                return 2369;
                            }
                            case 27: {
                                return 2374;
                            }
                            case 28: {
                                return 2375;
                            }
                            case 29: {
                                return 2376;
                            }
                            case 30: {
                                return 2377;
                            }
                            case 31: {
                                return 2378;
                            }
                            case 32: {
                                return 105;
                            }
                            case 33: {
                                return 106;
                            }
                            case 34: {
                                return 107;
                            }
                            case 35: {
                                return 108;
                            }
                            case 36: {
                                return 2379;
                            }
                            case 37: {
                                return 109;
                            }
                            case 38: {
                                return 110;
                            }
                            case 39: {
                                return 111;
                            }
                            case 40: {
                                return 2358;
                            }
                            case 41: {
                                return 2365;
                            }
                            case 42: {
                                return 2371;
                            }
                            case 43: {
                                return 2376;
                            }
                            case 44: {
                                return 2380;
                            }
                            case 45: {
                                return 2381;
                            }
                            case 46: {
                                return 2382;
                            }
                            case 47: {
                                return 2383;
                            }
                            case 48: {
                                return 2359;
                            }
                            case 49: {
                                return 2366;
                            }
                            case 50: {
                                return 2372;
                            }
                            case 51: {
                                return 2377;
                            }
                            case 52: {
                                return 2384;
                            }
                            case 53: {
                                return 2382;
                            }
                            case 54: {
                                return 2385;
                            }
                            case 55: {
                                return 2386;
                            }
                            case 56: {
                                return 2360;
                            }
                            case 57: {
                                return 2367;
                            }
                            case 58: {
                                return 2373;
                            }
                            case 59: {
                                return 2378;
                            }
                            case 60: {
                                return 2387;
                            }
                            case 61: {
                                return 2383;
                            }
                            case 62: {
                                return 2386;
                            }
                            case 63: {
                                return 2388;
                            }
                            case 64: {
                                return 2389;
                            }
                            case 65: {
                                return 2390;
                            }
                            case 66: {
                                return 2391;
                            }
                            case 67: {
                                return 2392;
                            }
                            case 68: {
                                return 2393;
                            }
                            case 69: {
                                return 2394;
                            }
                            case 70: {
                                return 2395;
                            }
                            case 71: {
                                return 2396;
                            }
                            case 72: {
                                return 2397;
                            }
                            case 73: {
                                return 2398;
                            }
                            case 74: {
                                return 2399;
                            }
                            case 75: {
                                return 2400;
                            }
                            case 76: {
                                return 2401;
                            }
                            case 77: {
                                return 2402;
                            }
                            case 78: {
                                return 2403;
                            }
                            case 79: {
                                return 2404;
                            }
                            case 80: {
                                return 2405;
                            }
                            case 81: {
                                return 2406;
                            }
                            case 82: {
                                return 2407;
                            }
                            case 83: {
                                return 2408;
                            }
                            case 84: {
                                return 2409;
                            }
                            case 85: {
                                return 2410;
                            }
                            case 86: {
                                return 2411;
                            }
                            case 87: {
                                return 2412;
                            }
                            case 88: {
                                return 2413;
                            }
                            case 89: {
                                return 2414;
                            }
                            case 90: {
                                return 2415;
                            }
                            case 91: {
                                return 2416;
                            }
                            case 92: {
                                return 2417;
                            }
                            case 93: {
                                return 2418;
                            }
                            case 94: {
                                return 2419;
                            }
                            case 95: {
                                return 2420;
                            }
                            case 96: {
                                return 105;
                            }
                            case 97: {
                                return 106;
                            }
                            case 98: {
                                return 107;
                            }
                            case 99: {
                                return 108;
                            }
                            case 100: {
                                return 2379;
                            }
                            case 101: {
                                return 109;
                            }
                            case 102: {
                                return 110;
                            }
                            case 103: {
                                return 111;
                            }
                            case 104: {
                                return 2421;
                            }
                            case 105: {
                                return 2422;
                            }
                            case 106: {
                                return 2423;
                            }
                            case 107: {
                                return 2424;
                            }
                            case 108: {
                                return 2425;
                            }
                            case 109: {
                                return 2426;
                            }
                            case 110: {
                                return 2427;
                            }
                            case 111: {
                                return 2428;
                            }
                            case 112: {
                                return 2429;
                            }
                            case 113: {
                                return 2430;
                            }
                            case 114: {
                                return 2431;
                            }
                            case 115: {
                                return 2432;
                            }
                            case 116: {
                                return 2433;
                            }
                            case 117: {
                                return 2434;
                            }
                            case 118: {
                                return 2435;
                            }
                            case 119: {
                                return 2436;
                            }
                            case 120: {
                                return 2437;
                            }
                            case 121: {
                                return 2438;
                            }
                            case 122: {
                                return 2439;
                            }
                            case 123: {
                                return 2440;
                            }
                            case 124: {
                                return 2441;
                            }
                            case 125: {
                                return 2442;
                            }
                            case 126: {
                                return 2443;
                            }
                            case 127: {
                                return 2444;
                            }
                            case 128: {
                                return 2445;
                            }
                            case 129: {
                                return 2446;
                            }
                            case 130: {
                                return 2447;
                            }
                            case 131: {
                                return 2448;
                            }
                            case 132: {
                                return 2449;
                            }
                            case 133: {
                                return 2450;
                            }
                            case 134: {
                                return 2451;
                            }
                            case 135: {
                                return 2452;
                            }
                            case 136: {
                                return 2453;
                            }
                            case 137: {
                                return 2454;
                            }
                            case 138: {
                                return 2455;
                            }
                            case 139: {
                                return 2456;
                            }
                            case 140: {
                                return 2457;
                            }
                            case 141: {
                                return 2458;
                            }
                            case 142: {
                                return 2459;
                            }
                            case 143: {
                                return 2460;
                            }
                            case 144: {
                                return 2461;
                            }
                            case 145: {
                                return 2462;
                            }
                            case 146: {
                                return 2463;
                            }
                            case 147: {
                                return 2464;
                            }
                            case 148: {
                                return 2465;
                            }
                            case 149: {
                                return 2466;
                            }
                            case 150: {
                                return 2467;
                            }
                            case 151: {
                                return 2468;
                            }
                            case 152: {
                                return 2469;
                            }
                            case 153: {
                                return 2470;
                            }
                            case 154: {
                                return 2471;
                            }
                            case 155: {
                                return 2472;
                            }
                            case 156: {
                                return 2473;
                            }
                            case 157: {
                                return 2474;
                            }
                            case 158: {
                                return 2475;
                            }
                            case 159: {
                                return 2476;
                            }
                            case 160: {
                                return 105;
                            }
                            case 161: {
                                return 106;
                            }
                            case 162: {
                                return 107;
                            }
                            case 163: {
                                return 108;
                            }
                            case 164: {
                                return 2379;
                            }
                            case 165: {
                                return 109;
                            }
                            case 166: {
                                return 110;
                            }
                            case 167: {
                                return 111;
                            }
                            case 168: {
                                return 2477;
                            }
                            case 169: {
                                return 2478;
                            }
                            case 170: {
                                return 2479;
                            }
                            case 171: {
                                return 2480;
                            }
                            case 172: {
                                return 2481;
                            }
                            case 173: {
                                return 2482;
                            }
                            case 174: {
                                return 2483;
                            }
                            case 175: {
                                return 2484;
                            }
                            case 176: {
                                return 2485;
                            }
                            case 177: {
                                return 2486;
                            }
                            case 178: {
                                return 2487;
                            }
                            case 179: {
                                return 2488;
                            }
                            case 180: {
                                return 2489;
                            }
                            case 181: {
                                return 2490;
                            }
                            case 182: {
                                return 2491;
                            }
                            case 183: {
                                return 2492;
                            }
                            case 184: {
                                return 2493;
                            }
                            case 185: {
                                return 2494;
                            }
                            case 186: {
                                return 2495;
                            }
                            case 187: {
                                return 2496;
                            }
                            case 188: {
                                return 2497;
                            }
                            case 189: {
                                return 2498;
                            }
                            case 190: {
                                return 2499;
                            }
                            case 191: {
                                return 2500;
                            }
                            case 192: {
                                return 2501;
                            }
                            case 193: {
                                return 2502;
                            }
                            case 194: {
                                return 2503;
                            }
                            case 195: {
                                return 2504;
                            }
                            case 196: {
                                return 2505;
                            }
                            case 197: {
                                return 2506;
                            }
                            case 198: {
                                return 2507;
                            }
                            case 199: {
                                return 2508;
                            }
                            case 200: {
                                return 2509;
                            }
                            case 201: {
                                return 2510;
                            }
                            case 202: {
                                return 2511;
                            }
                            case 203: {
                                return 2512;
                            }
                            case 204: {
                                return 2513;
                            }
                            case 205: {
                                return 2514;
                            }
                            case 206: {
                                return 2515;
                            }
                            case 207: {
                                return 2516;
                            }
                            case 208: {
                                return 2517;
                            }
                            case 209: {
                                return 2518;
                            }
                            case 210: {
                                return 2519;
                            }
                            case 211: {
                                return 2520;
                            }
                            case 212: {
                                return 2521;
                            }
                            case 213: {
                                return 2522;
                            }
                            case 214: {
                                return 2523;
                            }
                            case 215: {
                                return 2524;
                            }
                            case 216: {
                                return 2525;
                            }
                            case 217: {
                                return 2526;
                            }
                            case 218: {
                                return 2527;
                            }
                            case 219: {
                                return 2528;
                            }
                            case 220: {
                                return 2529;
                            }
                            case 221: {
                                return 2530;
                            }
                            case 222: {
                                return 2531;
                            }
                            case 223: {
                                return 2532;
                            }
                            case 224: {
                                return 105;
                            }
                            case 225: {
                                return 106;
                            }
                            case 226: {
                                return 107;
                            }
                            case 227: {
                                return 108;
                            }
                            case 228: {
                                return 2379;
                            }
                            case 229: {
                                return 109;
                            }
                            case 230: {
                                return 110;
                            }
                            case 231: {
                                return 111;
                            }
                            case 232: {
                                return 2533;
                            }
                            case 233: {
                                return 2534;
                            }
                            case 234: {
                                return 2535;
                            }
                            case 235: {
                                return 2536;
                            }
                            case 236: {
                                return 2537;
                            }
                            case 237: {
                                return 2538;
                            }
                            case 238: {
                                return 2539;
                            }
                            case 239: {
                                return 2540;
                            }
                            case 240: {
                                return 2541;
                            }
                            case 241: {
                                return 2542;
                            }
                            case 242: {
                                return 2543;
                            }
                            case 243: {
                                return 2544;
                            }
                            case 244: {
                                return 2545;
                            }
                            case 245: {
                                return 2546;
                            }
                            case 246: {
                                return 2547;
                            }
                            case 247: {
                                return 2548;
                            }
                            case 248: {
                                return 2549;
                            }
                            case 249: {
                                return 2550;
                            }
                            case 250: {
                                return 2551;
                            }
                            case 251: {
                                return 2552;
                            }
                            case 252: {
                                return 2553;
                            }
                            case 253: {
                                return 2554;
                            }
                            case 254: {
                                return 2555;
                            }
                            case 255: 
                        }
                        return 2556;
                    }
                    case 128: 
                }
                switch (n3) {
                    default: {
                        return -1;
                    }
                    case 0: {
                        return 2190;
                    }
                    case 1: {
                        return 2557;
                    }
                    case 2: {
                        return 2558;
                    }
                    case 3: {
                        return 2559;
                    }
                    case 4: {
                        return 2560;
                    }
                    case 5: {
                        return 2561;
                    }
                    case 6: {
                        return 2562;
                    }
                    case 7: {
                        return 2563;
                    }
                    case 8: {
                        return 2557;
                    }
                    case 9: {
                        return 2198;
                    }
                    case 10: {
                        return 2564;
                    }
                    case 11: {
                        return 2565;
                    }
                    case 12: {
                        return 2566;
                    }
                    case 13: {
                        return 2567;
                    }
                    case 14: {
                        return 2568;
                    }
                    case 15: {
                        return 2569;
                    }
                    case 16: {
                        return 2558;
                    }
                    case 17: {
                        return 2564;
                    }
                    case 18: {
                        return 2206;
                    }
                    case 19: {
                        return 2570;
                    }
                    case 20: {
                        return 2571;
                    }
                    case 21: {
                        return 2572;
                    }
                    case 22: {
                        return 2573;
                    }
                    case 23: {
                        return 2574;
                    }
                    case 24: {
                        return 2559;
                    }
                    case 25: {
                        return 2565;
                    }
                    case 26: {
                        return 2570;
                    }
                    case 27: {
                        return 2214;
                    }
                    case 28: {
                        return 2575;
                    }
                    case 29: {
                        return 2576;
                    }
                    case 30: {
                        return 2577;
                    }
                    case 31: {
                        return 2578;
                    }
                    case 32: {
                        return 112;
                    }
                    case 33: {
                        return 113;
                    }
                    case 34: {
                        return 114;
                    }
                    case 35: {
                        return 115;
                    }
                    case 36: {
                        return 2579;
                    }
                    case 37: {
                        return 116;
                    }
                    case 38: {
                        return 117;
                    }
                    case 39: {
                        return 118;
                    }
                    case 40: {
                        return 2561;
                    }
                    case 41: {
                        return 2567;
                    }
                    case 42: {
                        return 2572;
                    }
                    case 43: {
                        return 2576;
                    }
                    case 44: {
                        return 2580;
                    }
                    case 45: {
                        return 2222;
                    }
                    case 46: {
                        return 2581;
                    }
                    case 47: {
                        return 2582;
                    }
                    case 48: {
                        return 2562;
                    }
                    case 49: {
                        return 2568;
                    }
                    case 50: {
                        return 2573;
                    }
                    case 51: {
                        return 2577;
                    }
                    case 52: {
                        return 2583;
                    }
                    case 53: {
                        return 2581;
                    }
                    case 54: {
                        return 2230;
                    }
                    case 55: {
                        return 2584;
                    }
                    case 56: {
                        return 2563;
                    }
                    case 57: {
                        return 2569;
                    }
                    case 58: {
                        return 2574;
                    }
                    case 59: {
                        return 2578;
                    }
                    case 60: {
                        return 2585;
                    }
                    case 61: {
                        return 2582;
                    }
                    case 62: {
                        return 2584;
                    }
                    case 63: {
                        return 2238;
                    }
                    case 64: {
                        return 2586;
                    }
                    case 65: {
                        return 2587;
                    }
                    case 66: {
                        return 2588;
                    }
                    case 67: {
                        return 2589;
                    }
                    case 68: {
                        return 2590;
                    }
                    case 69: {
                        return 2591;
                    }
                    case 70: {
                        return 2592;
                    }
                    case 71: {
                        return 2593;
                    }
                    case 72: {
                        return 2594;
                    }
                    case 73: {
                        return 2595;
                    }
                    case 74: {
                        return 2596;
                    }
                    case 75: {
                        return 2597;
                    }
                    case 76: {
                        return 2598;
                    }
                    case 77: {
                        return 2599;
                    }
                    case 78: {
                        return 2600;
                    }
                    case 79: {
                        return 2601;
                    }
                    case 80: {
                        return 2602;
                    }
                    case 81: {
                        return 2603;
                    }
                    case 82: {
                        return 2604;
                    }
                    case 83: {
                        return 2605;
                    }
                    case 84: {
                        return 2606;
                    }
                    case 85: {
                        return 2607;
                    }
                    case 86: {
                        return 2608;
                    }
                    case 87: {
                        return 2609;
                    }
                    case 88: {
                        return 2610;
                    }
                    case 89: {
                        return 2611;
                    }
                    case 90: {
                        return 2612;
                    }
                    case 91: {
                        return 2613;
                    }
                    case 92: {
                        return 2614;
                    }
                    case 93: {
                        return 2615;
                    }
                    case 94: {
                        return 2616;
                    }
                    case 95: {
                        return 2617;
                    }
                    case 96: {
                        return 112;
                    }
                    case 97: {
                        return 113;
                    }
                    case 98: {
                        return 114;
                    }
                    case 99: {
                        return 115;
                    }
                    case 100: {
                        return 2579;
                    }
                    case 101: {
                        return 116;
                    }
                    case 102: {
                        return 117;
                    }
                    case 103: {
                        return 118;
                    }
                    case 104: {
                        return 2618;
                    }
                    case 105: {
                        return 2619;
                    }
                    case 106: {
                        return 2620;
                    }
                    case 107: {
                        return 2621;
                    }
                    case 108: {
                        return 2622;
                    }
                    case 109: {
                        return 2623;
                    }
                    case 110: {
                        return 2624;
                    }
                    case 111: {
                        return 2625;
                    }
                    case 112: {
                        return 2626;
                    }
                    case 113: {
                        return 2627;
                    }
                    case 114: {
                        return 2628;
                    }
                    case 115: {
                        return 2629;
                    }
                    case 116: {
                        return 2630;
                    }
                    case 117: {
                        return 2631;
                    }
                    case 118: {
                        return 2632;
                    }
                    case 119: {
                        return 2633;
                    }
                    case 120: {
                        return 2634;
                    }
                    case 121: {
                        return 2635;
                    }
                    case 122: {
                        return 2636;
                    }
                    case 123: {
                        return 2637;
                    }
                    case 124: {
                        return 2638;
                    }
                    case 125: {
                        return 2639;
                    }
                    case 126: {
                        return 2640;
                    }
                    case 127: {
                        return 2641;
                    }
                    case 128: {
                        return 2642;
                    }
                    case 129: {
                        return 2643;
                    }
                    case 130: {
                        return 2644;
                    }
                    case 131: {
                        return 2645;
                    }
                    case 132: {
                        return 2646;
                    }
                    case 133: {
                        return 2647;
                    }
                    case 134: {
                        return 2648;
                    }
                    case 135: {
                        return 2649;
                    }
                    case 136: {
                        return 2650;
                    }
                    case 137: {
                        return 2651;
                    }
                    case 138: {
                        return 2652;
                    }
                    case 139: {
                        return 2653;
                    }
                    case 140: {
                        return 2654;
                    }
                    case 141: {
                        return 2655;
                    }
                    case 142: {
                        return 2656;
                    }
                    case 143: {
                        return 2657;
                    }
                    case 144: {
                        return 2658;
                    }
                    case 145: {
                        return 2659;
                    }
                    case 146: {
                        return 2660;
                    }
                    case 147: {
                        return 2661;
                    }
                    case 148: {
                        return 2662;
                    }
                    case 149: {
                        return 2663;
                    }
                    case 150: {
                        return 2664;
                    }
                    case 151: {
                        return 2665;
                    }
                    case 152: {
                        return 2666;
                    }
                    case 153: {
                        return 2667;
                    }
                    case 154: {
                        return 2668;
                    }
                    case 155: {
                        return 2669;
                    }
                    case 156: {
                        return 2670;
                    }
                    case 157: {
                        return 2671;
                    }
                    case 158: {
                        return 2672;
                    }
                    case 159: {
                        return 2673;
                    }
                    case 160: {
                        return 112;
                    }
                    case 161: {
                        return 113;
                    }
                    case 162: {
                        return 114;
                    }
                    case 163: {
                        return 115;
                    }
                    case 164: {
                        return 2579;
                    }
                    case 165: {
                        return 116;
                    }
                    case 166: {
                        return 117;
                    }
                    case 167: {
                        return 118;
                    }
                    case 168: {
                        return 2674;
                    }
                    case 169: {
                        return 2675;
                    }
                    case 170: {
                        return 2676;
                    }
                    case 171: {
                        return 2677;
                    }
                    case 172: {
                        return 2678;
                    }
                    case 173: {
                        return 2679;
                    }
                    case 174: {
                        return 2680;
                    }
                    case 175: {
                        return 2681;
                    }
                    case 176: {
                        return 2682;
                    }
                    case 177: {
                        return 2683;
                    }
                    case 178: {
                        return 2684;
                    }
                    case 179: {
                        return 2685;
                    }
                    case 180: {
                        return 2686;
                    }
                    case 181: {
                        return 2687;
                    }
                    case 182: {
                        return 2688;
                    }
                    case 183: {
                        return 2689;
                    }
                    case 184: {
                        return 2690;
                    }
                    case 185: {
                        return 2691;
                    }
                    case 186: {
                        return 2692;
                    }
                    case 187: {
                        return 2693;
                    }
                    case 188: {
                        return 2694;
                    }
                    case 189: {
                        return 2695;
                    }
                    case 190: {
                        return 2696;
                    }
                    case 191: {
                        return 2697;
                    }
                    case 192: {
                        return 2698;
                    }
                    case 193: {
                        return 2699;
                    }
                    case 194: {
                        return 2700;
                    }
                    case 195: {
                        return 2701;
                    }
                    case 196: {
                        return 2702;
                    }
                    case 197: {
                        return 2703;
                    }
                    case 198: {
                        return 2704;
                    }
                    case 199: {
                        return 2705;
                    }
                    case 200: {
                        return 2706;
                    }
                    case 201: {
                        return 2707;
                    }
                    case 202: {
                        return 2708;
                    }
                    case 203: {
                        return 2709;
                    }
                    case 204: {
                        return 2710;
                    }
                    case 205: {
                        return 2711;
                    }
                    case 206: {
                        return 2712;
                    }
                    case 207: {
                        return 2713;
                    }
                    case 208: {
                        return 2714;
                    }
                    case 209: {
                        return 2715;
                    }
                    case 210: {
                        return 2716;
                    }
                    case 211: {
                        return 2717;
                    }
                    case 212: {
                        return 2718;
                    }
                    case 213: {
                        return 2719;
                    }
                    case 214: {
                        return 2720;
                    }
                    case 215: {
                        return 2721;
                    }
                    case 216: {
                        return 2722;
                    }
                    case 217: {
                        return 2723;
                    }
                    case 218: {
                        return 2724;
                    }
                    case 219: {
                        return 2725;
                    }
                    case 220: {
                        return 2726;
                    }
                    case 221: {
                        return 2727;
                    }
                    case 222: {
                        return 2728;
                    }
                    case 223: {
                        return 2729;
                    }
                    case 224: {
                        return 112;
                    }
                    case 225: {
                        return 113;
                    }
                    case 226: {
                        return 114;
                    }
                    case 227: {
                        return 115;
                    }
                    case 228: {
                        return 2579;
                    }
                    case 229: {
                        return 116;
                    }
                    case 230: {
                        return 117;
                    }
                    case 231: {
                        return 118;
                    }
                    case 232: {
                        return 2730;
                    }
                    case 233: {
                        return 2731;
                    }
                    case 234: {
                        return 2732;
                    }
                    case 235: {
                        return 2733;
                    }
                    case 236: {
                        return 2734;
                    }
                    case 237: {
                        return 2735;
                    }
                    case 238: {
                        return 2736;
                    }
                    case 239: {
                        return 2737;
                    }
                    case 240: {
                        return 2738;
                    }
                    case 241: {
                        return 2739;
                    }
                    case 242: {
                        return 2740;
                    }
                    case 243: {
                        return 2741;
                    }
                    case 244: {
                        return 2742;
                    }
                    case 245: {
                        return 2743;
                    }
                    case 246: {
                        return 2744;
                    }
                    case 247: {
                        return 2745;
                    }
                    case 248: {
                        return 2746;
                    }
                    case 249: {
                        return 2747;
                    }
                    case 250: {
                        return 2748;
                    }
                    case 251: {
                        return 2749;
                    }
                    case 252: {
                        return 2750;
                    }
                    case 253: {
                        return 2751;
                    }
                    case 254: {
                        return 2752;
                    }
                    case 255: 
                }
                return 2753;
            }
        }
        return RealModeDecoder.decodeSIBUnusualSegments(n, n2, n3);
    }

    private static int decodeSIBUnusualSegments(int n, int n2, int n3) {
        switch (n & 7) {
            case 5: {
                switch (n2 & 0xC0) {
                    default: {
                        return -1;
                    }
                    case 0: {
                        switch (n3) {
                            default: {
                                return -1;
                            }
                            case 0: {
                                return 2754;
                            }
                            case 1: {
                                return 2755;
                            }
                            case 2: {
                                return 2756;
                            }
                            case 3: {
                                return 2757;
                            }
                            case 4: {
                                return 2758;
                            }
                            case 5: {
                                return 154;
                            }
                            case 6: {
                                return 2760;
                            }
                            case 7: {
                                return 2761;
                            }
                            case 8: {
                                return 2755;
                            }
                            case 9: {
                                return 2762;
                            }
                            case 10: {
                                return 2763;
                            }
                            case 11: {
                                return 2764;
                            }
                            case 12: {
                                return 2765;
                            }
                            case 13: {
                                return 155;
                            }
                            case 14: {
                                return 2767;
                            }
                            case 15: {
                                return 2768;
                            }
                            case 16: {
                                return 2756;
                            }
                            case 17: {
                                return 2763;
                            }
                            case 18: {
                                return 2769;
                            }
                            case 19: {
                                return 2770;
                            }
                            case 20: {
                                return 2771;
                            }
                            case 21: {
                                return 156;
                            }
                            case 22: {
                                return 2773;
                            }
                            case 23: {
                                return 2774;
                            }
                            case 24: {
                                return 2757;
                            }
                            case 25: {
                                return 2764;
                            }
                            case 26: {
                                return 2770;
                            }
                            case 27: {
                                return 2775;
                            }
                            case 28: {
                                return 2776;
                            }
                            case 29: {
                                return 157;
                            }
                            case 30: {
                                return 2778;
                            }
                            case 31: {
                                return 2779;
                            }
                            case 32: {
                                return 140;
                            }
                            case 33: {
                                return 141;
                            }
                            case 34: {
                                return 142;
                            }
                            case 35: {
                                return 143;
                            }
                            case 36: {
                                return 2780;
                            }
                            case 37: {
                                return 144;
                            }
                            case 38: {
                                return 145;
                            }
                            case 39: {
                                return 146;
                            }
                            case 40: {
                                return 2759;
                            }
                            case 41: {
                                return 2766;
                            }
                            case 42: {
                                return 2772;
                            }
                            case 43: {
                                return 2777;
                            }
                            case 44: {
                                return 2781;
                            }
                            case 45: {
                                return 158;
                            }
                            case 46: {
                                return 2782;
                            }
                            case 47: {
                                return 2783;
                            }
                            case 48: {
                                return 2760;
                            }
                            case 49: {
                                return 2767;
                            }
                            case 50: {
                                return 2773;
                            }
                            case 51: {
                                return 2778;
                            }
                            case 52: {
                                return 2784;
                            }
                            case 53: {
                                return 159;
                            }
                            case 54: {
                                return 2785;
                            }
                            case 55: {
                                return 2786;
                            }
                            case 56: {
                                return 2761;
                            }
                            case 57: {
                                return 2768;
                            }
                            case 58: {
                                return 2774;
                            }
                            case 59: {
                                return 2779;
                            }
                            case 60: {
                                return 2787;
                            }
                            case 61: {
                                return 160;
                            }
                            case 62: {
                                return 2786;
                            }
                            case 63: {
                                return 2788;
                            }
                            case 64: {
                                return 2789;
                            }
                            case 65: {
                                return 2790;
                            }
                            case 66: {
                                return 2791;
                            }
                            case 67: {
                                return 2792;
                            }
                            case 68: {
                                return 2793;
                            }
                            case 69: {
                                return 2794;
                            }
                            case 70: {
                                return 2795;
                            }
                            case 71: {
                                return 2796;
                            }
                            case 72: {
                                return 2797;
                            }
                            case 73: {
                                return 2798;
                            }
                            case 74: {
                                return 2799;
                            }
                            case 75: {
                                return 2800;
                            }
                            case 76: {
                                return 2801;
                            }
                            case 77: {
                                return 2802;
                            }
                            case 78: {
                                return 2803;
                            }
                            case 79: {
                                return 2804;
                            }
                            case 80: {
                                return 2805;
                            }
                            case 81: {
                                return 2806;
                            }
                            case 82: {
                                return 2807;
                            }
                            case 83: {
                                return 2808;
                            }
                            case 84: {
                                return 2809;
                            }
                            case 85: {
                                return 2810;
                            }
                            case 86: {
                                return 2811;
                            }
                            case 87: {
                                return 2812;
                            }
                            case 88: {
                                return 2813;
                            }
                            case 89: {
                                return 2814;
                            }
                            case 90: {
                                return 2815;
                            }
                            case 91: {
                                return 2816;
                            }
                            case 92: {
                                return 2817;
                            }
                            case 93: {
                                return 2818;
                            }
                            case 94: {
                                return 2819;
                            }
                            case 95: {
                                return 2820;
                            }
                            case 96: {
                                return 140;
                            }
                            case 97: {
                                return 141;
                            }
                            case 98: {
                                return 142;
                            }
                            case 99: {
                                return 143;
                            }
                            case 100: {
                                return 2780;
                            }
                            case 101: {
                                return 144;
                            }
                            case 102: {
                                return 145;
                            }
                            case 103: {
                                return 146;
                            }
                            case 104: {
                                return 2821;
                            }
                            case 105: {
                                return 2822;
                            }
                            case 106: {
                                return 2823;
                            }
                            case 107: {
                                return 2824;
                            }
                            case 108: {
                                return 2825;
                            }
                            case 109: {
                                return 2826;
                            }
                            case 110: {
                                return 2827;
                            }
                            case 111: {
                                return 2828;
                            }
                            case 112: {
                                return 2829;
                            }
                            case 113: {
                                return 2830;
                            }
                            case 114: {
                                return 2831;
                            }
                            case 115: {
                                return 2832;
                            }
                            case 116: {
                                return 2833;
                            }
                            case 117: {
                                return 2834;
                            }
                            case 118: {
                                return 2835;
                            }
                            case 119: {
                                return 2836;
                            }
                            case 120: {
                                return 2837;
                            }
                            case 121: {
                                return 2838;
                            }
                            case 122: {
                                return 2839;
                            }
                            case 123: {
                                return 2840;
                            }
                            case 124: {
                                return 2841;
                            }
                            case 125: {
                                return 2842;
                            }
                            case 126: {
                                return 2843;
                            }
                            case 127: {
                                return 2844;
                            }
                            case 128: {
                                return 2845;
                            }
                            case 129: {
                                return 2846;
                            }
                            case 130: {
                                return 2847;
                            }
                            case 131: {
                                return 2848;
                            }
                            case 132: {
                                return 2849;
                            }
                            case 133: {
                                return 2850;
                            }
                            case 134: {
                                return 2851;
                            }
                            case 135: {
                                return 2852;
                            }
                            case 136: {
                                return 2853;
                            }
                            case 137: {
                                return 2854;
                            }
                            case 138: {
                                return 2855;
                            }
                            case 139: {
                                return 2856;
                            }
                            case 140: {
                                return 2857;
                            }
                            case 141: {
                                return 2858;
                            }
                            case 142: {
                                return 2859;
                            }
                            case 143: {
                                return 2860;
                            }
                            case 144: {
                                return 2861;
                            }
                            case 145: {
                                return 2862;
                            }
                            case 146: {
                                return 2863;
                            }
                            case 147: {
                                return 2864;
                            }
                            case 148: {
                                return 2865;
                            }
                            case 149: {
                                return 2866;
                            }
                            case 150: {
                                return 2867;
                            }
                            case 151: {
                                return 2868;
                            }
                            case 152: {
                                return 2869;
                            }
                            case 153: {
                                return 2870;
                            }
                            case 154: {
                                return 2871;
                            }
                            case 155: {
                                return 2872;
                            }
                            case 156: {
                                return 2873;
                            }
                            case 157: {
                                return 2874;
                            }
                            case 158: {
                                return 2875;
                            }
                            case 159: {
                                return 2876;
                            }
                            case 160: {
                                return 140;
                            }
                            case 161: {
                                return 141;
                            }
                            case 162: {
                                return 142;
                            }
                            case 163: {
                                return 143;
                            }
                            case 164: {
                                return 2780;
                            }
                            case 165: {
                                return 144;
                            }
                            case 166: {
                                return 145;
                            }
                            case 167: {
                                return 146;
                            }
                            case 168: {
                                return 2877;
                            }
                            case 169: {
                                return 2878;
                            }
                            case 170: {
                                return 2879;
                            }
                            case 171: {
                                return 2880;
                            }
                            case 172: {
                                return 2881;
                            }
                            case 173: {
                                return 2882;
                            }
                            case 174: {
                                return 2883;
                            }
                            case 175: {
                                return 2884;
                            }
                            case 176: {
                                return 2885;
                            }
                            case 177: {
                                return 2886;
                            }
                            case 178: {
                                return 2887;
                            }
                            case 179: {
                                return 2888;
                            }
                            case 180: {
                                return 2889;
                            }
                            case 181: {
                                return 2890;
                            }
                            case 182: {
                                return 2891;
                            }
                            case 183: {
                                return 2892;
                            }
                            case 184: {
                                return 2893;
                            }
                            case 185: {
                                return 2894;
                            }
                            case 186: {
                                return 2895;
                            }
                            case 187: {
                                return 2896;
                            }
                            case 188: {
                                return 2897;
                            }
                            case 189: {
                                return 2898;
                            }
                            case 190: {
                                return 2899;
                            }
                            case 191: {
                                return 2900;
                            }
                            case 192: {
                                return 2901;
                            }
                            case 193: {
                                return 2902;
                            }
                            case 194: {
                                return 2903;
                            }
                            case 195: {
                                return 2904;
                            }
                            case 196: {
                                return 2905;
                            }
                            case 197: {
                                return 2906;
                            }
                            case 198: {
                                return 2907;
                            }
                            case 199: {
                                return 2908;
                            }
                            case 200: {
                                return 2909;
                            }
                            case 201: {
                                return 2910;
                            }
                            case 202: {
                                return 2911;
                            }
                            case 203: {
                                return 2912;
                            }
                            case 204: {
                                return 2913;
                            }
                            case 205: {
                                return 2914;
                            }
                            case 206: {
                                return 2915;
                            }
                            case 207: {
                                return 2916;
                            }
                            case 208: {
                                return 2917;
                            }
                            case 209: {
                                return 2918;
                            }
                            case 210: {
                                return 2919;
                            }
                            case 211: {
                                return 2920;
                            }
                            case 212: {
                                return 2921;
                            }
                            case 213: {
                                return 2922;
                            }
                            case 214: {
                                return 2923;
                            }
                            case 215: {
                                return 2924;
                            }
                            case 216: {
                                return 2925;
                            }
                            case 217: {
                                return 2926;
                            }
                            case 218: {
                                return 2927;
                            }
                            case 219: {
                                return 2928;
                            }
                            case 220: {
                                return 2929;
                            }
                            case 221: {
                                return 2930;
                            }
                            case 222: {
                                return 2931;
                            }
                            case 223: {
                                return 2932;
                            }
                            case 224: {
                                return 140;
                            }
                            case 225: {
                                return 141;
                            }
                            case 226: {
                                return 142;
                            }
                            case 227: {
                                return 143;
                            }
                            case 228: {
                                return 2780;
                            }
                            case 229: {
                                return 144;
                            }
                            case 230: {
                                return 145;
                            }
                            case 231: {
                                return 146;
                            }
                            case 232: {
                                return 2933;
                            }
                            case 233: {
                                return 2934;
                            }
                            case 234: {
                                return 2935;
                            }
                            case 235: {
                                return 2936;
                            }
                            case 236: {
                                return 2937;
                            }
                            case 237: {
                                return 2938;
                            }
                            case 238: {
                                return 2939;
                            }
                            case 239: {
                                return 2940;
                            }
                            case 240: {
                                return 2941;
                            }
                            case 241: {
                                return 2942;
                            }
                            case 242: {
                                return 2943;
                            }
                            case 243: {
                                return 2944;
                            }
                            case 244: {
                                return 2945;
                            }
                            case 245: {
                                return 2946;
                            }
                            case 246: {
                                return 2947;
                            }
                            case 247: {
                                return 2948;
                            }
                            case 248: {
                                return 2949;
                            }
                            case 249: {
                                return 2950;
                            }
                            case 250: {
                                return 2951;
                            }
                            case 251: {
                                return 2952;
                            }
                            case 252: {
                                return 2953;
                            }
                            case 253: {
                                return 2954;
                            }
                            case 254: {
                                return 2955;
                            }
                            case 255: 
                        }
                        return 2956;
                    }
                    case 64: {
                        switch (n3) {
                            default: {
                                return -1;
                            }
                            case 0: {
                                return 2957;
                            }
                            case 1: {
                                return 2958;
                            }
                            case 2: {
                                return 2959;
                            }
                            case 3: {
                                return 2960;
                            }
                            case 4: {
                                return 2961;
                            }
                            case 5: {
                                return 2962;
                            }
                            case 6: {
                                return 2963;
                            }
                            case 7: {
                                return 2964;
                            }
                            case 8: {
                                return 2958;
                            }
                            case 9: {
                                return 2965;
                            }
                            case 10: {
                                return 2966;
                            }
                            case 11: {
                                return 2967;
                            }
                            case 12: {
                                return 2968;
                            }
                            case 13: {
                                return 2969;
                            }
                            case 14: {
                                return 2970;
                            }
                            case 15: {
                                return 2971;
                            }
                            case 16: {
                                return 2959;
                            }
                            case 17: {
                                return 2966;
                            }
                            case 18: {
                                return 2972;
                            }
                            case 19: {
                                return 2973;
                            }
                            case 20: {
                                return 2974;
                            }
                            case 21: {
                                return 2975;
                            }
                            case 22: {
                                return 2976;
                            }
                            case 23: {
                                return 2977;
                            }
                            case 24: {
                                return 2960;
                            }
                            case 25: {
                                return 2967;
                            }
                            case 26: {
                                return 2973;
                            }
                            case 27: {
                                return 2978;
                            }
                            case 28: {
                                return 2979;
                            }
                            case 29: {
                                return 2980;
                            }
                            case 30: {
                                return 2981;
                            }
                            case 31: {
                                return 2982;
                            }
                            case 32: {
                                return 147;
                            }
                            case 33: {
                                return 148;
                            }
                            case 34: {
                                return 149;
                            }
                            case 35: {
                                return 150;
                            }
                            case 36: {
                                return 2983;
                            }
                            case 37: {
                                return 151;
                            }
                            case 38: {
                                return 152;
                            }
                            case 39: {
                                return 153;
                            }
                            case 40: {
                                return 2962;
                            }
                            case 41: {
                                return 2969;
                            }
                            case 42: {
                                return 2975;
                            }
                            case 43: {
                                return 2980;
                            }
                            case 44: {
                                return 2984;
                            }
                            case 45: {
                                return 2985;
                            }
                            case 46: {
                                return 2986;
                            }
                            case 47: {
                                return 2987;
                            }
                            case 48: {
                                return 2963;
                            }
                            case 49: {
                                return 2970;
                            }
                            case 50: {
                                return 2976;
                            }
                            case 51: {
                                return 2981;
                            }
                            case 52: {
                                return 2988;
                            }
                            case 53: {
                                return 2986;
                            }
                            case 54: {
                                return 2989;
                            }
                            case 55: {
                                return 2990;
                            }
                            case 56: {
                                return 2964;
                            }
                            case 57: {
                                return 2971;
                            }
                            case 58: {
                                return 2977;
                            }
                            case 59: {
                                return 2982;
                            }
                            case 60: {
                                return 2991;
                            }
                            case 61: {
                                return 2987;
                            }
                            case 62: {
                                return 2990;
                            }
                            case 63: {
                                return 2992;
                            }
                            case 64: {
                                return 2993;
                            }
                            case 65: {
                                return 2994;
                            }
                            case 66: {
                                return 2995;
                            }
                            case 67: {
                                return 2996;
                            }
                            case 68: {
                                return 2997;
                            }
                            case 69: {
                                return 2998;
                            }
                            case 70: {
                                return 2999;
                            }
                            case 71: {
                                return 3000;
                            }
                            case 72: {
                                return 3001;
                            }
                            case 73: {
                                return 3002;
                            }
                            case 74: {
                                return 3003;
                            }
                            case 75: {
                                return 3004;
                            }
                            case 76: {
                                return 3005;
                            }
                            case 77: {
                                return 3006;
                            }
                            case 78: {
                                return 3007;
                            }
                            case 79: {
                                return 3008;
                            }
                            case 80: {
                                return 3009;
                            }
                            case 81: {
                                return 3010;
                            }
                            case 82: {
                                return 3011;
                            }
                            case 83: {
                                return 3012;
                            }
                            case 84: {
                                return 3013;
                            }
                            case 85: {
                                return 3014;
                            }
                            case 86: {
                                return 3015;
                            }
                            case 87: {
                                return 3016;
                            }
                            case 88: {
                                return 3017;
                            }
                            case 89: {
                                return 3018;
                            }
                            case 90: {
                                return 3019;
                            }
                            case 91: {
                                return 3020;
                            }
                            case 92: {
                                return 3021;
                            }
                            case 93: {
                                return 3022;
                            }
                            case 94: {
                                return 3023;
                            }
                            case 95: {
                                return 3024;
                            }
                            case 96: {
                                return 147;
                            }
                            case 97: {
                                return 148;
                            }
                            case 98: {
                                return 149;
                            }
                            case 99: {
                                return 150;
                            }
                            case 100: {
                                return 2983;
                            }
                            case 101: {
                                return 151;
                            }
                            case 102: {
                                return 152;
                            }
                            case 103: {
                                return 153;
                            }
                            case 104: {
                                return 3025;
                            }
                            case 105: {
                                return 3026;
                            }
                            case 106: {
                                return 3027;
                            }
                            case 107: {
                                return 3028;
                            }
                            case 108: {
                                return 3029;
                            }
                            case 109: {
                                return 3030;
                            }
                            case 110: {
                                return 3031;
                            }
                            case 111: {
                                return 3032;
                            }
                            case 112: {
                                return 3033;
                            }
                            case 113: {
                                return 3034;
                            }
                            case 114: {
                                return 3035;
                            }
                            case 115: {
                                return 3036;
                            }
                            case 116: {
                                return 3037;
                            }
                            case 117: {
                                return 3038;
                            }
                            case 118: {
                                return 3039;
                            }
                            case 119: {
                                return 3040;
                            }
                            case 120: {
                                return 3041;
                            }
                            case 121: {
                                return 3042;
                            }
                            case 122: {
                                return 3043;
                            }
                            case 123: {
                                return 3044;
                            }
                            case 124: {
                                return 3045;
                            }
                            case 125: {
                                return 3046;
                            }
                            case 126: {
                                return 3047;
                            }
                            case 127: {
                                return 3048;
                            }
                            case 128: {
                                return 3049;
                            }
                            case 129: {
                                return 3050;
                            }
                            case 130: {
                                return 3051;
                            }
                            case 131: {
                                return 3052;
                            }
                            case 132: {
                                return 3053;
                            }
                            case 133: {
                                return 3054;
                            }
                            case 134: {
                                return 3055;
                            }
                            case 135: {
                                return 3056;
                            }
                            case 136: {
                                return 3057;
                            }
                            case 137: {
                                return 3058;
                            }
                            case 138: {
                                return 3059;
                            }
                            case 139: {
                                return 3060;
                            }
                            case 140: {
                                return 3061;
                            }
                            case 141: {
                                return 3062;
                            }
                            case 142: {
                                return 3063;
                            }
                            case 143: {
                                return 3064;
                            }
                            case 144: {
                                return 3065;
                            }
                            case 145: {
                                return 3066;
                            }
                            case 146: {
                                return 3067;
                            }
                            case 147: {
                                return 3068;
                            }
                            case 148: {
                                return 3069;
                            }
                            case 149: {
                                return 3070;
                            }
                            case 150: {
                                return 3071;
                            }
                            case 151: {
                                return 3072;
                            }
                            case 152: {
                                return 3073;
                            }
                            case 153: {
                                return 3074;
                            }
                            case 154: {
                                return 3075;
                            }
                            case 155: {
                                return 3076;
                            }
                            case 156: {
                                return 3077;
                            }
                            case 157: {
                                return 3078;
                            }
                            case 158: {
                                return 3079;
                            }
                            case 159: {
                                return 3080;
                            }
                            case 160: {
                                return 147;
                            }
                            case 161: {
                                return 148;
                            }
                            case 162: {
                                return 149;
                            }
                            case 163: {
                                return 150;
                            }
                            case 164: {
                                return 2983;
                            }
                            case 165: {
                                return 151;
                            }
                            case 166: {
                                return 152;
                            }
                            case 167: {
                                return 153;
                            }
                            case 168: {
                                return 3081;
                            }
                            case 169: {
                                return 3082;
                            }
                            case 170: {
                                return 3083;
                            }
                            case 171: {
                                return 3084;
                            }
                            case 172: {
                                return 3085;
                            }
                            case 173: {
                                return 3086;
                            }
                            case 174: {
                                return 3087;
                            }
                            case 175: {
                                return 3088;
                            }
                            case 176: {
                                return 3089;
                            }
                            case 177: {
                                return 3090;
                            }
                            case 178: {
                                return 3091;
                            }
                            case 179: {
                                return 3092;
                            }
                            case 180: {
                                return 3093;
                            }
                            case 181: {
                                return 3094;
                            }
                            case 182: {
                                return 3095;
                            }
                            case 183: {
                                return 3096;
                            }
                            case 184: {
                                return 3097;
                            }
                            case 185: {
                                return 3098;
                            }
                            case 186: {
                                return 3099;
                            }
                            case 187: {
                                return 3100;
                            }
                            case 188: {
                                return 3101;
                            }
                            case 189: {
                                return 3102;
                            }
                            case 190: {
                                return 3103;
                            }
                            case 191: {
                                return 3104;
                            }
                            case 192: {
                                return 3105;
                            }
                            case 193: {
                                return 3106;
                            }
                            case 194: {
                                return 3107;
                            }
                            case 195: {
                                return 3108;
                            }
                            case 196: {
                                return 3109;
                            }
                            case 197: {
                                return 3110;
                            }
                            case 198: {
                                return 3111;
                            }
                            case 199: {
                                return 3112;
                            }
                            case 200: {
                                return 3113;
                            }
                            case 201: {
                                return 3114;
                            }
                            case 202: {
                                return 3115;
                            }
                            case 203: {
                                return 3116;
                            }
                            case 204: {
                                return 3117;
                            }
                            case 205: {
                                return 3118;
                            }
                            case 206: {
                                return 3119;
                            }
                            case 207: {
                                return 3120;
                            }
                            case 208: {
                                return 3121;
                            }
                            case 209: {
                                return 3122;
                            }
                            case 210: {
                                return 3123;
                            }
                            case 211: {
                                return 3124;
                            }
                            case 212: {
                                return 3125;
                            }
                            case 213: {
                                return 3126;
                            }
                            case 214: {
                                return 3127;
                            }
                            case 215: {
                                return 3128;
                            }
                            case 216: {
                                return 3129;
                            }
                            case 217: {
                                return 3130;
                            }
                            case 218: {
                                return 3131;
                            }
                            case 219: {
                                return 3132;
                            }
                            case 220: {
                                return 3133;
                            }
                            case 221: {
                                return 3134;
                            }
                            case 222: {
                                return 3135;
                            }
                            case 223: {
                                return 3136;
                            }
                            case 224: {
                                return 147;
                            }
                            case 225: {
                                return 148;
                            }
                            case 226: {
                                return 149;
                            }
                            case 227: {
                                return 150;
                            }
                            case 228: {
                                return 2983;
                            }
                            case 229: {
                                return 151;
                            }
                            case 230: {
                                return 152;
                            }
                            case 231: {
                                return 153;
                            }
                            case 232: {
                                return 3137;
                            }
                            case 233: {
                                return 3138;
                            }
                            case 234: {
                                return 3139;
                            }
                            case 235: {
                                return 3140;
                            }
                            case 236: {
                                return 3141;
                            }
                            case 237: {
                                return 3142;
                            }
                            case 238: {
                                return 3143;
                            }
                            case 239: {
                                return 3144;
                            }
                            case 240: {
                                return 3145;
                            }
                            case 241: {
                                return 3146;
                            }
                            case 242: {
                                return 3147;
                            }
                            case 243: {
                                return 3148;
                            }
                            case 244: {
                                return 3149;
                            }
                            case 245: {
                                return 3150;
                            }
                            case 246: {
                                return 3151;
                            }
                            case 247: {
                                return 3152;
                            }
                            case 248: {
                                return 3153;
                            }
                            case 249: {
                                return 3154;
                            }
                            case 250: {
                                return 3155;
                            }
                            case 251: {
                                return 3156;
                            }
                            case 252: {
                                return 3157;
                            }
                            case 253: {
                                return 3158;
                            }
                            case 254: {
                                return 3159;
                            }
                            case 255: 
                        }
                        return 3160;
                    }
                    case 128: 
                }
                switch (n3) {
                    default: {
                        return -1;
                    }
                    case 0: {
                        return 2794;
                    }
                    case 1: {
                        return 3161;
                    }
                    case 2: {
                        return 3162;
                    }
                    case 3: {
                        return 3163;
                    }
                    case 4: {
                        return 3164;
                    }
                    case 5: {
                        return 3165;
                    }
                    case 6: {
                        return 3166;
                    }
                    case 7: {
                        return 3167;
                    }
                    case 8: {
                        return 3161;
                    }
                    case 9: {
                        return 2802;
                    }
                    case 10: {
                        return 3168;
                    }
                    case 11: {
                        return 3169;
                    }
                    case 12: {
                        return 3170;
                    }
                    case 13: {
                        return 3171;
                    }
                    case 14: {
                        return 3172;
                    }
                    case 15: {
                        return 3173;
                    }
                    case 16: {
                        return 3162;
                    }
                    case 17: {
                        return 3168;
                    }
                    case 18: {
                        return 2810;
                    }
                    case 19: {
                        return 3174;
                    }
                    case 20: {
                        return 3175;
                    }
                    case 21: {
                        return 3176;
                    }
                    case 22: {
                        return 3177;
                    }
                    case 23: {
                        return 3178;
                    }
                    case 24: {
                        return 3163;
                    }
                    case 25: {
                        return 3169;
                    }
                    case 26: {
                        return 3174;
                    }
                    case 27: {
                        return 2818;
                    }
                    case 28: {
                        return 3179;
                    }
                    case 29: {
                        return 3180;
                    }
                    case 30: {
                        return 3181;
                    }
                    case 31: {
                        return 3182;
                    }
                    case 32: {
                        return 154;
                    }
                    case 33: {
                        return 155;
                    }
                    case 34: {
                        return 156;
                    }
                    case 35: {
                        return 157;
                    }
                    case 36: {
                        return 3183;
                    }
                    case 37: {
                        return 158;
                    }
                    case 38: {
                        return 159;
                    }
                    case 39: {
                        return 160;
                    }
                    case 40: {
                        return 3165;
                    }
                    case 41: {
                        return 3171;
                    }
                    case 42: {
                        return 3176;
                    }
                    case 43: {
                        return 3180;
                    }
                    case 44: {
                        return 3184;
                    }
                    case 45: {
                        return 2826;
                    }
                    case 46: {
                        return 3185;
                    }
                    case 47: {
                        return 3186;
                    }
                    case 48: {
                        return 3166;
                    }
                    case 49: {
                        return 3172;
                    }
                    case 50: {
                        return 3177;
                    }
                    case 51: {
                        return 3181;
                    }
                    case 52: {
                        return 3187;
                    }
                    case 53: {
                        return 3185;
                    }
                    case 54: {
                        return 2834;
                    }
                    case 55: {
                        return 3188;
                    }
                    case 56: {
                        return 3167;
                    }
                    case 57: {
                        return 3173;
                    }
                    case 58: {
                        return 3178;
                    }
                    case 59: {
                        return 3182;
                    }
                    case 60: {
                        return 3189;
                    }
                    case 61: {
                        return 3186;
                    }
                    case 62: {
                        return 3188;
                    }
                    case 63: {
                        return 2842;
                    }
                    case 64: {
                        return 3190;
                    }
                    case 65: {
                        return 3191;
                    }
                    case 66: {
                        return 3192;
                    }
                    case 67: {
                        return 3193;
                    }
                    case 68: {
                        return 3194;
                    }
                    case 69: {
                        return 3195;
                    }
                    case 70: {
                        return 3196;
                    }
                    case 71: {
                        return 3197;
                    }
                    case 72: {
                        return 3198;
                    }
                    case 73: {
                        return 3199;
                    }
                    case 74: {
                        return 3200;
                    }
                    case 75: {
                        return 3201;
                    }
                    case 76: {
                        return 3202;
                    }
                    case 77: {
                        return 3203;
                    }
                    case 78: {
                        return 3204;
                    }
                    case 79: {
                        return 3205;
                    }
                    case 80: {
                        return 3206;
                    }
                    case 81: {
                        return 3207;
                    }
                    case 82: {
                        return 3208;
                    }
                    case 83: {
                        return 3209;
                    }
                    case 84: {
                        return 3210;
                    }
                    case 85: {
                        return 3211;
                    }
                    case 86: {
                        return 3212;
                    }
                    case 87: {
                        return 3213;
                    }
                    case 88: {
                        return 3214;
                    }
                    case 89: {
                        return 3215;
                    }
                    case 90: {
                        return 3216;
                    }
                    case 91: {
                        return 3217;
                    }
                    case 92: {
                        return 3218;
                    }
                    case 93: {
                        return 3219;
                    }
                    case 94: {
                        return 3220;
                    }
                    case 95: {
                        return 3221;
                    }
                    case 96: {
                        return 154;
                    }
                    case 97: {
                        return 155;
                    }
                    case 98: {
                        return 156;
                    }
                    case 99: {
                        return 157;
                    }
                    case 100: {
                        return 3183;
                    }
                    case 101: {
                        return 158;
                    }
                    case 102: {
                        return 159;
                    }
                    case 103: {
                        return 160;
                    }
                    case 104: {
                        return 3222;
                    }
                    case 105: {
                        return 3223;
                    }
                    case 106: {
                        return 3224;
                    }
                    case 107: {
                        return 3225;
                    }
                    case 108: {
                        return 3226;
                    }
                    case 109: {
                        return 3227;
                    }
                    case 110: {
                        return 3228;
                    }
                    case 111: {
                        return 3229;
                    }
                    case 112: {
                        return 3230;
                    }
                    case 113: {
                        return 3231;
                    }
                    case 114: {
                        return 3232;
                    }
                    case 115: {
                        return 3233;
                    }
                    case 116: {
                        return 3234;
                    }
                    case 117: {
                        return 3235;
                    }
                    case 118: {
                        return 3236;
                    }
                    case 119: {
                        return 3237;
                    }
                    case 120: {
                        return 3238;
                    }
                    case 121: {
                        return 3239;
                    }
                    case 122: {
                        return 3240;
                    }
                    case 123: {
                        return 3241;
                    }
                    case 124: {
                        return 3242;
                    }
                    case 125: {
                        return 3243;
                    }
                    case 126: {
                        return 3244;
                    }
                    case 127: {
                        return 3245;
                    }
                    case 128: {
                        return 3246;
                    }
                    case 129: {
                        return 3247;
                    }
                    case 130: {
                        return 3248;
                    }
                    case 131: {
                        return 3249;
                    }
                    case 132: {
                        return 3250;
                    }
                    case 133: {
                        return 3251;
                    }
                    case 134: {
                        return 3252;
                    }
                    case 135: {
                        return 3253;
                    }
                    case 136: {
                        return 3254;
                    }
                    case 137: {
                        return 3255;
                    }
                    case 138: {
                        return 3256;
                    }
                    case 139: {
                        return 3257;
                    }
                    case 140: {
                        return 3258;
                    }
                    case 141: {
                        return 3259;
                    }
                    case 142: {
                        return 3260;
                    }
                    case 143: {
                        return 3261;
                    }
                    case 144: {
                        return 3262;
                    }
                    case 145: {
                        return 3263;
                    }
                    case 146: {
                        return 3264;
                    }
                    case 147: {
                        return 3265;
                    }
                    case 148: {
                        return 3266;
                    }
                    case 149: {
                        return 3267;
                    }
                    case 150: {
                        return 3268;
                    }
                    case 151: {
                        return 3269;
                    }
                    case 152: {
                        return 3270;
                    }
                    case 153: {
                        return 3271;
                    }
                    case 154: {
                        return 3272;
                    }
                    case 155: {
                        return 3273;
                    }
                    case 156: {
                        return 3274;
                    }
                    case 157: {
                        return 3275;
                    }
                    case 158: {
                        return 3276;
                    }
                    case 159: {
                        return 3277;
                    }
                    case 160: {
                        return 154;
                    }
                    case 161: {
                        return 155;
                    }
                    case 162: {
                        return 156;
                    }
                    case 163: {
                        return 157;
                    }
                    case 164: {
                        return 3183;
                    }
                    case 165: {
                        return 158;
                    }
                    case 166: {
                        return 159;
                    }
                    case 167: {
                        return 160;
                    }
                    case 168: {
                        return 3278;
                    }
                    case 169: {
                        return 3279;
                    }
                    case 170: {
                        return 3280;
                    }
                    case 171: {
                        return 3281;
                    }
                    case 172: {
                        return 3282;
                    }
                    case 173: {
                        return 3283;
                    }
                    case 174: {
                        return 3284;
                    }
                    case 175: {
                        return 3285;
                    }
                    case 176: {
                        return 3286;
                    }
                    case 177: {
                        return 3287;
                    }
                    case 178: {
                        return 3288;
                    }
                    case 179: {
                        return 3289;
                    }
                    case 180: {
                        return 3290;
                    }
                    case 181: {
                        return 3291;
                    }
                    case 182: {
                        return 3292;
                    }
                    case 183: {
                        return 3293;
                    }
                    case 184: {
                        return 3294;
                    }
                    case 185: {
                        return 3295;
                    }
                    case 186: {
                        return 3296;
                    }
                    case 187: {
                        return 3297;
                    }
                    case 188: {
                        return 3298;
                    }
                    case 189: {
                        return 3299;
                    }
                    case 190: {
                        return 3300;
                    }
                    case 191: {
                        return 3301;
                    }
                    case 192: {
                        return 3302;
                    }
                    case 193: {
                        return 3303;
                    }
                    case 194: {
                        return 3304;
                    }
                    case 195: {
                        return 3305;
                    }
                    case 196: {
                        return 3306;
                    }
                    case 197: {
                        return 3307;
                    }
                    case 198: {
                        return 3308;
                    }
                    case 199: {
                        return 3309;
                    }
                    case 200: {
                        return 3310;
                    }
                    case 201: {
                        return 3311;
                    }
                    case 202: {
                        return 3312;
                    }
                    case 203: {
                        return 3313;
                    }
                    case 204: {
                        return 3314;
                    }
                    case 205: {
                        return 3315;
                    }
                    case 206: {
                        return 3316;
                    }
                    case 207: {
                        return 3317;
                    }
                    case 208: {
                        return 3318;
                    }
                    case 209: {
                        return 3319;
                    }
                    case 210: {
                        return 3320;
                    }
                    case 211: {
                        return 3321;
                    }
                    case 212: {
                        return 3322;
                    }
                    case 213: {
                        return 3323;
                    }
                    case 214: {
                        return 3324;
                    }
                    case 215: {
                        return 3325;
                    }
                    case 216: {
                        return 3326;
                    }
                    case 217: {
                        return 3327;
                    }
                    case 218: {
                        return 3328;
                    }
                    case 219: {
                        return 3329;
                    }
                    case 220: {
                        return 3330;
                    }
                    case 221: {
                        return 3331;
                    }
                    case 222: {
                        return 3332;
                    }
                    case 223: {
                        return 3333;
                    }
                    case 224: {
                        return 154;
                    }
                    case 225: {
                        return 155;
                    }
                    case 226: {
                        return 156;
                    }
                    case 227: {
                        return 157;
                    }
                    case 228: {
                        return 3183;
                    }
                    case 229: {
                        return 158;
                    }
                    case 230: {
                        return 159;
                    }
                    case 231: {
                        return 160;
                    }
                    case 232: {
                        return 3334;
                    }
                    case 233: {
                        return 3335;
                    }
                    case 234: {
                        return 3336;
                    }
                    case 235: {
                        return 3337;
                    }
                    case 236: {
                        return 3338;
                    }
                    case 237: {
                        return 3339;
                    }
                    case 238: {
                        return 3340;
                    }
                    case 239: {
                        return 3341;
                    }
                    case 240: {
                        return 3342;
                    }
                    case 241: {
                        return 3343;
                    }
                    case 242: {
                        return 3344;
                    }
                    case 243: {
                        return 3345;
                    }
                    case 244: {
                        return 3346;
                    }
                    case 245: {
                        return 3347;
                    }
                    case 246: {
                        return 3348;
                    }
                    case 247: {
                        return 3349;
                    }
                    case 248: {
                        return 3350;
                    }
                    case 249: {
                        return 3351;
                    }
                    case 250: {
                        return 3352;
                    }
                    case 251: {
                        return 3353;
                    }
                    case 252: {
                        return 3354;
                    }
                    case 253: {
                        return 3355;
                    }
                    case 254: {
                        return 3356;
                    }
                    case 255: 
                }
                return 3357;
            }
            case 6: {
                switch (n2 & 0xC0) {
                    default: {
                        return -1;
                    }
                    case 0: {
                        switch (n3) {
                            default: {
                                return -1;
                            }
                            case 0: {
                                return 3358;
                            }
                            case 1: {
                                return 3359;
                            }
                            case 2: {
                                return 3360;
                            }
                            case 3: {
                                return 3361;
                            }
                            case 4: {
                                return 3362;
                            }
                            case 5: {
                                return 175;
                            }
                            case 6: {
                                return 3364;
                            }
                            case 7: {
                                return 3365;
                            }
                            case 8: {
                                return 3359;
                            }
                            case 9: {
                                return 3366;
                            }
                            case 10: {
                                return 3367;
                            }
                            case 11: {
                                return 3368;
                            }
                            case 12: {
                                return 3369;
                            }
                            case 13: {
                                return 176;
                            }
                            case 14: {
                                return 3371;
                            }
                            case 15: {
                                return 3372;
                            }
                            case 16: {
                                return 3360;
                            }
                            case 17: {
                                return 3367;
                            }
                            case 18: {
                                return 3373;
                            }
                            case 19: {
                                return 3374;
                            }
                            case 20: {
                                return 3375;
                            }
                            case 21: {
                                return 177;
                            }
                            case 22: {
                                return 3377;
                            }
                            case 23: {
                                return 3378;
                            }
                            case 24: {
                                return 3361;
                            }
                            case 25: {
                                return 3368;
                            }
                            case 26: {
                                return 3374;
                            }
                            case 27: {
                                return 3379;
                            }
                            case 28: {
                                return 3380;
                            }
                            case 29: {
                                return 178;
                            }
                            case 30: {
                                return 3382;
                            }
                            case 31: {
                                return 3383;
                            }
                            case 32: {
                                return 161;
                            }
                            case 33: {
                                return 162;
                            }
                            case 34: {
                                return 163;
                            }
                            case 35: {
                                return 164;
                            }
                            case 36: {
                                return 3384;
                            }
                            case 37: {
                                return 165;
                            }
                            case 38: {
                                return 166;
                            }
                            case 39: {
                                return 167;
                            }
                            case 40: {
                                return 3363;
                            }
                            case 41: {
                                return 3370;
                            }
                            case 42: {
                                return 3376;
                            }
                            case 43: {
                                return 3381;
                            }
                            case 44: {
                                return 3385;
                            }
                            case 45: {
                                return 179;
                            }
                            case 46: {
                                return 3386;
                            }
                            case 47: {
                                return 3387;
                            }
                            case 48: {
                                return 3364;
                            }
                            case 49: {
                                return 3371;
                            }
                            case 50: {
                                return 3377;
                            }
                            case 51: {
                                return 3382;
                            }
                            case 52: {
                                return 3388;
                            }
                            case 53: {
                                return 180;
                            }
                            case 54: {
                                return 3389;
                            }
                            case 55: {
                                return 3390;
                            }
                            case 56: {
                                return 3365;
                            }
                            case 57: {
                                return 3372;
                            }
                            case 58: {
                                return 3378;
                            }
                            case 59: {
                                return 3383;
                            }
                            case 60: {
                                return 3391;
                            }
                            case 61: {
                                return 181;
                            }
                            case 62: {
                                return 3390;
                            }
                            case 63: {
                                return 3392;
                            }
                            case 64: {
                                return 3393;
                            }
                            case 65: {
                                return 3394;
                            }
                            case 66: {
                                return 3395;
                            }
                            case 67: {
                                return 3396;
                            }
                            case 68: {
                                return 3397;
                            }
                            case 69: {
                                return 3398;
                            }
                            case 70: {
                                return 3399;
                            }
                            case 71: {
                                return 3400;
                            }
                            case 72: {
                                return 3401;
                            }
                            case 73: {
                                return 3402;
                            }
                            case 74: {
                                return 3403;
                            }
                            case 75: {
                                return 3404;
                            }
                            case 76: {
                                return 3405;
                            }
                            case 77: {
                                return 3406;
                            }
                            case 78: {
                                return 3407;
                            }
                            case 79: {
                                return 3408;
                            }
                            case 80: {
                                return 3409;
                            }
                            case 81: {
                                return 3410;
                            }
                            case 82: {
                                return 3411;
                            }
                            case 83: {
                                return 3412;
                            }
                            case 84: {
                                return 3413;
                            }
                            case 85: {
                                return 3414;
                            }
                            case 86: {
                                return 3415;
                            }
                            case 87: {
                                return 3416;
                            }
                            case 88: {
                                return 3417;
                            }
                            case 89: {
                                return 3418;
                            }
                            case 90: {
                                return 3419;
                            }
                            case 91: {
                                return 3420;
                            }
                            case 92: {
                                return 3421;
                            }
                            case 93: {
                                return 3422;
                            }
                            case 94: {
                                return 3423;
                            }
                            case 95: {
                                return 3424;
                            }
                            case 96: {
                                return 161;
                            }
                            case 97: {
                                return 162;
                            }
                            case 98: {
                                return 163;
                            }
                            case 99: {
                                return 164;
                            }
                            case 100: {
                                return 3384;
                            }
                            case 101: {
                                return 165;
                            }
                            case 102: {
                                return 166;
                            }
                            case 103: {
                                return 167;
                            }
                            case 104: {
                                return 3425;
                            }
                            case 105: {
                                return 3426;
                            }
                            case 106: {
                                return 3427;
                            }
                            case 107: {
                                return 3428;
                            }
                            case 108: {
                                return 3429;
                            }
                            case 109: {
                                return 3430;
                            }
                            case 110: {
                                return 3431;
                            }
                            case 111: {
                                return 3432;
                            }
                            case 112: {
                                return 3433;
                            }
                            case 113: {
                                return 3434;
                            }
                            case 114: {
                                return 3435;
                            }
                            case 115: {
                                return 3436;
                            }
                            case 116: {
                                return 3437;
                            }
                            case 117: {
                                return 3438;
                            }
                            case 118: {
                                return 3439;
                            }
                            case 119: {
                                return 3440;
                            }
                            case 120: {
                                return 3441;
                            }
                            case 121: {
                                return 3442;
                            }
                            case 122: {
                                return 3443;
                            }
                            case 123: {
                                return 3444;
                            }
                            case 124: {
                                return 3445;
                            }
                            case 125: {
                                return 3446;
                            }
                            case 126: {
                                return 3447;
                            }
                            case 127: {
                                return 3448;
                            }
                            case 128: {
                                return 3449;
                            }
                            case 129: {
                                return 3450;
                            }
                            case 130: {
                                return 3451;
                            }
                            case 131: {
                                return 3452;
                            }
                            case 132: {
                                return 3453;
                            }
                            case 133: {
                                return 3454;
                            }
                            case 134: {
                                return 3455;
                            }
                            case 135: {
                                return 3456;
                            }
                            case 136: {
                                return 3457;
                            }
                            case 137: {
                                return 3458;
                            }
                            case 138: {
                                return 3459;
                            }
                            case 139: {
                                return 3460;
                            }
                            case 140: {
                                return 3461;
                            }
                            case 141: {
                                return 3462;
                            }
                            case 142: {
                                return 3463;
                            }
                            case 143: {
                                return 3464;
                            }
                            case 144: {
                                return 3465;
                            }
                            case 145: {
                                return 3466;
                            }
                            case 146: {
                                return 3467;
                            }
                            case 147: {
                                return 3468;
                            }
                            case 148: {
                                return 3469;
                            }
                            case 149: {
                                return 3470;
                            }
                            case 150: {
                                return 3471;
                            }
                            case 151: {
                                return 3472;
                            }
                            case 152: {
                                return 3473;
                            }
                            case 153: {
                                return 3474;
                            }
                            case 154: {
                                return 3475;
                            }
                            case 155: {
                                return 3476;
                            }
                            case 156: {
                                return 3477;
                            }
                            case 157: {
                                return 3478;
                            }
                            case 158: {
                                return 3479;
                            }
                            case 159: {
                                return 3480;
                            }
                            case 160: {
                                return 161;
                            }
                            case 161: {
                                return 162;
                            }
                            case 162: {
                                return 163;
                            }
                            case 163: {
                                return 164;
                            }
                            case 164: {
                                return 3384;
                            }
                            case 165: {
                                return 165;
                            }
                            case 166: {
                                return 166;
                            }
                            case 167: {
                                return 167;
                            }
                            case 168: {
                                return 3481;
                            }
                            case 169: {
                                return 3482;
                            }
                            case 170: {
                                return 3483;
                            }
                            case 171: {
                                return 3484;
                            }
                            case 172: {
                                return 3485;
                            }
                            case 173: {
                                return 3486;
                            }
                            case 174: {
                                return 3487;
                            }
                            case 175: {
                                return 3488;
                            }
                            case 176: {
                                return 3489;
                            }
                            case 177: {
                                return 3490;
                            }
                            case 178: {
                                return 3491;
                            }
                            case 179: {
                                return 3492;
                            }
                            case 180: {
                                return 3493;
                            }
                            case 181: {
                                return 3494;
                            }
                            case 182: {
                                return 3495;
                            }
                            case 183: {
                                return 3496;
                            }
                            case 184: {
                                return 3497;
                            }
                            case 185: {
                                return 3498;
                            }
                            case 186: {
                                return 3499;
                            }
                            case 187: {
                                return 3500;
                            }
                            case 188: {
                                return 3501;
                            }
                            case 189: {
                                return 3502;
                            }
                            case 190: {
                                return 3503;
                            }
                            case 191: {
                                return 3504;
                            }
                            case 192: {
                                return 3505;
                            }
                            case 193: {
                                return 3506;
                            }
                            case 194: {
                                return 3507;
                            }
                            case 195: {
                                return 3508;
                            }
                            case 196: {
                                return 3509;
                            }
                            case 197: {
                                return 3510;
                            }
                            case 198: {
                                return 3511;
                            }
                            case 199: {
                                return 3512;
                            }
                            case 200: {
                                return 3513;
                            }
                            case 201: {
                                return 3514;
                            }
                            case 202: {
                                return 3515;
                            }
                            case 203: {
                                return 3516;
                            }
                            case 204: {
                                return 3517;
                            }
                            case 205: {
                                return 3518;
                            }
                            case 206: {
                                return 3519;
                            }
                            case 207: {
                                return 3520;
                            }
                            case 208: {
                                return 3521;
                            }
                            case 209: {
                                return 3522;
                            }
                            case 210: {
                                return 3523;
                            }
                            case 211: {
                                return 3524;
                            }
                            case 212: {
                                return 3525;
                            }
                            case 213: {
                                return 3526;
                            }
                            case 214: {
                                return 3527;
                            }
                            case 215: {
                                return 3528;
                            }
                            case 216: {
                                return 3529;
                            }
                            case 217: {
                                return 3530;
                            }
                            case 218: {
                                return 3531;
                            }
                            case 219: {
                                return 3532;
                            }
                            case 220: {
                                return 3533;
                            }
                            case 221: {
                                return 3534;
                            }
                            case 222: {
                                return 3535;
                            }
                            case 223: {
                                return 3536;
                            }
                            case 224: {
                                return 161;
                            }
                            case 225: {
                                return 162;
                            }
                            case 226: {
                                return 163;
                            }
                            case 227: {
                                return 164;
                            }
                            case 228: {
                                return 3384;
                            }
                            case 229: {
                                return 165;
                            }
                            case 230: {
                                return 166;
                            }
                            case 231: {
                                return 167;
                            }
                            case 232: {
                                return 3537;
                            }
                            case 233: {
                                return 3538;
                            }
                            case 234: {
                                return 3539;
                            }
                            case 235: {
                                return 3540;
                            }
                            case 236: {
                                return 3541;
                            }
                            case 237: {
                                return 3542;
                            }
                            case 238: {
                                return 3543;
                            }
                            case 239: {
                                return 3544;
                            }
                            case 240: {
                                return 3545;
                            }
                            case 241: {
                                return 3546;
                            }
                            case 242: {
                                return 3547;
                            }
                            case 243: {
                                return 3548;
                            }
                            case 244: {
                                return 3549;
                            }
                            case 245: {
                                return 3550;
                            }
                            case 246: {
                                return 3551;
                            }
                            case 247: {
                                return 3552;
                            }
                            case 248: {
                                return 3553;
                            }
                            case 249: {
                                return 3554;
                            }
                            case 250: {
                                return 3555;
                            }
                            case 251: {
                                return 3556;
                            }
                            case 252: {
                                return 3557;
                            }
                            case 253: {
                                return 3558;
                            }
                            case 254: {
                                return 3559;
                            }
                            case 255: 
                        }
                        return 3560;
                    }
                    case 64: {
                        switch (n3) {
                            default: {
                                return -1;
                            }
                            case 0: {
                                return 3561;
                            }
                            case 1: {
                                return 3562;
                            }
                            case 2: {
                                return 3563;
                            }
                            case 3: {
                                return 3564;
                            }
                            case 4: {
                                return 3565;
                            }
                            case 5: {
                                return 3566;
                            }
                            case 6: {
                                return 3567;
                            }
                            case 7: {
                                return 3568;
                            }
                            case 8: {
                                return 3562;
                            }
                            case 9: {
                                return 3569;
                            }
                            case 10: {
                                return 3570;
                            }
                            case 11: {
                                return 3571;
                            }
                            case 12: {
                                return 3572;
                            }
                            case 13: {
                                return 3573;
                            }
                            case 14: {
                                return 3574;
                            }
                            case 15: {
                                return 3575;
                            }
                            case 16: {
                                return 3563;
                            }
                            case 17: {
                                return 3570;
                            }
                            case 18: {
                                return 3576;
                            }
                            case 19: {
                                return 3577;
                            }
                            case 20: {
                                return 3578;
                            }
                            case 21: {
                                return 3579;
                            }
                            case 22: {
                                return 3580;
                            }
                            case 23: {
                                return 3581;
                            }
                            case 24: {
                                return 3564;
                            }
                            case 25: {
                                return 3571;
                            }
                            case 26: {
                                return 3577;
                            }
                            case 27: {
                                return 3582;
                            }
                            case 28: {
                                return 3583;
                            }
                            case 29: {
                                return 3584;
                            }
                            case 30: {
                                return 3585;
                            }
                            case 31: {
                                return 3586;
                            }
                            case 32: {
                                return 168;
                            }
                            case 33: {
                                return 169;
                            }
                            case 34: {
                                return 170;
                            }
                            case 35: {
                                return 171;
                            }
                            case 36: {
                                return 3587;
                            }
                            case 37: {
                                return 172;
                            }
                            case 38: {
                                return 173;
                            }
                            case 39: {
                                return 174;
                            }
                            case 40: {
                                return 3566;
                            }
                            case 41: {
                                return 3573;
                            }
                            case 42: {
                                return 3579;
                            }
                            case 43: {
                                return 3584;
                            }
                            case 44: {
                                return 3588;
                            }
                            case 45: {
                                return 3589;
                            }
                            case 46: {
                                return 3590;
                            }
                            case 47: {
                                return 3591;
                            }
                            case 48: {
                                return 3567;
                            }
                            case 49: {
                                return 3574;
                            }
                            case 50: {
                                return 3580;
                            }
                            case 51: {
                                return 3585;
                            }
                            case 52: {
                                return 3592;
                            }
                            case 53: {
                                return 3590;
                            }
                            case 54: {
                                return 3593;
                            }
                            case 55: {
                                return 3594;
                            }
                            case 56: {
                                return 3568;
                            }
                            case 57: {
                                return 3575;
                            }
                            case 58: {
                                return 3581;
                            }
                            case 59: {
                                return 3586;
                            }
                            case 60: {
                                return 3595;
                            }
                            case 61: {
                                return 3591;
                            }
                            case 62: {
                                return 3594;
                            }
                            case 63: {
                                return 3596;
                            }
                            case 64: {
                                return 3597;
                            }
                            case 65: {
                                return 3598;
                            }
                            case 66: {
                                return 3599;
                            }
                            case 67: {
                                return 3600;
                            }
                            case 68: {
                                return 3601;
                            }
                            case 69: {
                                return 3602;
                            }
                            case 70: {
                                return 3603;
                            }
                            case 71: {
                                return 3604;
                            }
                            case 72: {
                                return 3605;
                            }
                            case 73: {
                                return 3606;
                            }
                            case 74: {
                                return 3607;
                            }
                            case 75: {
                                return 3608;
                            }
                            case 76: {
                                return 3609;
                            }
                            case 77: {
                                return 3610;
                            }
                            case 78: {
                                return 3611;
                            }
                            case 79: {
                                return 3612;
                            }
                            case 80: {
                                return 3613;
                            }
                            case 81: {
                                return 3614;
                            }
                            case 82: {
                                return 3615;
                            }
                            case 83: {
                                return 3616;
                            }
                            case 84: {
                                return 3617;
                            }
                            case 85: {
                                return 3618;
                            }
                            case 86: {
                                return 3619;
                            }
                            case 87: {
                                return 3620;
                            }
                            case 88: {
                                return 3621;
                            }
                            case 89: {
                                return 3622;
                            }
                            case 90: {
                                return 3623;
                            }
                            case 91: {
                                return 3624;
                            }
                            case 92: {
                                return 3625;
                            }
                            case 93: {
                                return 3626;
                            }
                            case 94: {
                                return 3627;
                            }
                            case 95: {
                                return 3628;
                            }
                            case 96: {
                                return 168;
                            }
                            case 97: {
                                return 169;
                            }
                            case 98: {
                                return 170;
                            }
                            case 99: {
                                return 171;
                            }
                            case 100: {
                                return 3587;
                            }
                            case 101: {
                                return 172;
                            }
                            case 102: {
                                return 173;
                            }
                            case 103: {
                                return 174;
                            }
                            case 104: {
                                return 3629;
                            }
                            case 105: {
                                return 3630;
                            }
                            case 106: {
                                return 3631;
                            }
                            case 107: {
                                return 3632;
                            }
                            case 108: {
                                return 3633;
                            }
                            case 109: {
                                return 3634;
                            }
                            case 110: {
                                return 3635;
                            }
                            case 111: {
                                return 3636;
                            }
                            case 112: {
                                return 3637;
                            }
                            case 113: {
                                return 3638;
                            }
                            case 114: {
                                return 3639;
                            }
                            case 115: {
                                return 3640;
                            }
                            case 116: {
                                return 3641;
                            }
                            case 117: {
                                return 3642;
                            }
                            case 118: {
                                return 3643;
                            }
                            case 119: {
                                return 3644;
                            }
                            case 120: {
                                return 3645;
                            }
                            case 121: {
                                return 3646;
                            }
                            case 122: {
                                return 3647;
                            }
                            case 123: {
                                return 3648;
                            }
                            case 124: {
                                return 3649;
                            }
                            case 125: {
                                return 3650;
                            }
                            case 126: {
                                return 3651;
                            }
                            case 127: {
                                return 3652;
                            }
                            case 128: {
                                return 3653;
                            }
                            case 129: {
                                return 3654;
                            }
                            case 130: {
                                return 3655;
                            }
                            case 131: {
                                return 3656;
                            }
                            case 132: {
                                return 3657;
                            }
                            case 133: {
                                return 3658;
                            }
                            case 134: {
                                return 3659;
                            }
                            case 135: {
                                return 3660;
                            }
                            case 136: {
                                return 3661;
                            }
                            case 137: {
                                return 3662;
                            }
                            case 138: {
                                return 3663;
                            }
                            case 139: {
                                return 3664;
                            }
                            case 140: {
                                return 3665;
                            }
                            case 141: {
                                return 3666;
                            }
                            case 142: {
                                return 3667;
                            }
                            case 143: {
                                return 3668;
                            }
                            case 144: {
                                return 3669;
                            }
                            case 145: {
                                return 3670;
                            }
                            case 146: {
                                return 3671;
                            }
                            case 147: {
                                return 3672;
                            }
                            case 148: {
                                return 3673;
                            }
                            case 149: {
                                return 3674;
                            }
                            case 150: {
                                return 3675;
                            }
                            case 151: {
                                return 3676;
                            }
                            case 152: {
                                return 3677;
                            }
                            case 153: {
                                return 3678;
                            }
                            case 154: {
                                return 3679;
                            }
                            case 155: {
                                return 3680;
                            }
                            case 156: {
                                return 3681;
                            }
                            case 157: {
                                return 3682;
                            }
                            case 158: {
                                return 3683;
                            }
                            case 159: {
                                return 3684;
                            }
                            case 160: {
                                return 168;
                            }
                            case 161: {
                                return 169;
                            }
                            case 162: {
                                return 170;
                            }
                            case 163: {
                                return 171;
                            }
                            case 164: {
                                return 3587;
                            }
                            case 165: {
                                return 172;
                            }
                            case 166: {
                                return 173;
                            }
                            case 167: {
                                return 174;
                            }
                            case 168: {
                                return 3685;
                            }
                            case 169: {
                                return 3686;
                            }
                            case 170: {
                                return 3687;
                            }
                            case 171: {
                                return 3688;
                            }
                            case 172: {
                                return 3689;
                            }
                            case 173: {
                                return 3690;
                            }
                            case 174: {
                                return 3691;
                            }
                            case 175: {
                                return 3692;
                            }
                            case 176: {
                                return 3693;
                            }
                            case 177: {
                                return 3694;
                            }
                            case 178: {
                                return 3695;
                            }
                            case 179: {
                                return 3696;
                            }
                            case 180: {
                                return 3697;
                            }
                            case 181: {
                                return 3698;
                            }
                            case 182: {
                                return 3699;
                            }
                            case 183: {
                                return 3700;
                            }
                            case 184: {
                                return 3701;
                            }
                            case 185: {
                                return 3702;
                            }
                            case 186: {
                                return 3703;
                            }
                            case 187: {
                                return 3704;
                            }
                            case 188: {
                                return 3705;
                            }
                            case 189: {
                                return 3706;
                            }
                            case 190: {
                                return 3707;
                            }
                            case 191: {
                                return 3708;
                            }
                            case 192: {
                                return 3709;
                            }
                            case 193: {
                                return 3710;
                            }
                            case 194: {
                                return 3711;
                            }
                            case 195: {
                                return 3712;
                            }
                            case 196: {
                                return 3713;
                            }
                            case 197: {
                                return 3714;
                            }
                            case 198: {
                                return 3715;
                            }
                            case 199: {
                                return 3716;
                            }
                            case 200: {
                                return 3717;
                            }
                            case 201: {
                                return 3718;
                            }
                            case 202: {
                                return 3719;
                            }
                            case 203: {
                                return 3720;
                            }
                            case 204: {
                                return 3721;
                            }
                            case 205: {
                                return 3722;
                            }
                            case 206: {
                                return 3723;
                            }
                            case 207: {
                                return 3724;
                            }
                            case 208: {
                                return 3725;
                            }
                            case 209: {
                                return 3726;
                            }
                            case 210: {
                                return 3727;
                            }
                            case 211: {
                                return 3728;
                            }
                            case 212: {
                                return 3729;
                            }
                            case 213: {
                                return 3730;
                            }
                            case 214: {
                                return 3731;
                            }
                            case 215: {
                                return 3732;
                            }
                            case 216: {
                                return 3733;
                            }
                            case 217: {
                                return 3734;
                            }
                            case 218: {
                                return 3735;
                            }
                            case 219: {
                                return 3736;
                            }
                            case 220: {
                                return 3737;
                            }
                            case 221: {
                                return 3738;
                            }
                            case 222: {
                                return 3739;
                            }
                            case 223: {
                                return 3740;
                            }
                            case 224: {
                                return 168;
                            }
                            case 225: {
                                return 169;
                            }
                            case 226: {
                                return 170;
                            }
                            case 227: {
                                return 171;
                            }
                            case 228: {
                                return 3587;
                            }
                            case 229: {
                                return 172;
                            }
                            case 230: {
                                return 173;
                            }
                            case 231: {
                                return 174;
                            }
                            case 232: {
                                return 3741;
                            }
                            case 233: {
                                return 3742;
                            }
                            case 234: {
                                return 3743;
                            }
                            case 235: {
                                return 3744;
                            }
                            case 236: {
                                return 3745;
                            }
                            case 237: {
                                return 3746;
                            }
                            case 238: {
                                return 3747;
                            }
                            case 239: {
                                return 3748;
                            }
                            case 240: {
                                return 3749;
                            }
                            case 241: {
                                return 3750;
                            }
                            case 242: {
                                return 3751;
                            }
                            case 243: {
                                return 3752;
                            }
                            case 244: {
                                return 3753;
                            }
                            case 245: {
                                return 3754;
                            }
                            case 246: {
                                return 3755;
                            }
                            case 247: {
                                return 3756;
                            }
                            case 248: {
                                return 3757;
                            }
                            case 249: {
                                return 3758;
                            }
                            case 250: {
                                return 3759;
                            }
                            case 251: {
                                return 3760;
                            }
                            case 252: {
                                return 3761;
                            }
                            case 253: {
                                return 3762;
                            }
                            case 254: {
                                return 3763;
                            }
                            case 255: 
                        }
                        return 3764;
                    }
                    case 128: 
                }
                switch (n3) {
                    default: {
                        return -1;
                    }
                    case 0: {
                        return 3398;
                    }
                    case 1: {
                        return 3765;
                    }
                    case 2: {
                        return 3766;
                    }
                    case 3: {
                        return 3767;
                    }
                    case 4: {
                        return 3768;
                    }
                    case 5: {
                        return 3769;
                    }
                    case 6: {
                        return 3770;
                    }
                    case 7: {
                        return 3771;
                    }
                    case 8: {
                        return 3765;
                    }
                    case 9: {
                        return 3406;
                    }
                    case 10: {
                        return 3772;
                    }
                    case 11: {
                        return 3773;
                    }
                    case 12: {
                        return 3774;
                    }
                    case 13: {
                        return 3775;
                    }
                    case 14: {
                        return 3776;
                    }
                    case 15: {
                        return 3777;
                    }
                    case 16: {
                        return 3766;
                    }
                    case 17: {
                        return 3772;
                    }
                    case 18: {
                        return 3414;
                    }
                    case 19: {
                        return 3778;
                    }
                    case 20: {
                        return 3779;
                    }
                    case 21: {
                        return 3780;
                    }
                    case 22: {
                        return 3781;
                    }
                    case 23: {
                        return 3782;
                    }
                    case 24: {
                        return 3767;
                    }
                    case 25: {
                        return 3773;
                    }
                    case 26: {
                        return 3778;
                    }
                    case 27: {
                        return 3422;
                    }
                    case 28: {
                        return 3783;
                    }
                    case 29: {
                        return 3784;
                    }
                    case 30: {
                        return 3785;
                    }
                    case 31: {
                        return 3786;
                    }
                    case 32: {
                        return 175;
                    }
                    case 33: {
                        return 176;
                    }
                    case 34: {
                        return 177;
                    }
                    case 35: {
                        return 178;
                    }
                    case 36: {
                        return 3787;
                    }
                    case 37: {
                        return 179;
                    }
                    case 38: {
                        return 180;
                    }
                    case 39: {
                        return 181;
                    }
                    case 40: {
                        return 3769;
                    }
                    case 41: {
                        return 3775;
                    }
                    case 42: {
                        return 3780;
                    }
                    case 43: {
                        return 3784;
                    }
                    case 44: {
                        return 3788;
                    }
                    case 45: {
                        return 3430;
                    }
                    case 46: {
                        return 3789;
                    }
                    case 47: {
                        return 3790;
                    }
                    case 48: {
                        return 3770;
                    }
                    case 49: {
                        return 3776;
                    }
                    case 50: {
                        return 3781;
                    }
                    case 51: {
                        return 3785;
                    }
                    case 52: {
                        return 3791;
                    }
                    case 53: {
                        return 3789;
                    }
                    case 54: {
                        return 3438;
                    }
                    case 55: {
                        return 3792;
                    }
                    case 56: {
                        return 3771;
                    }
                    case 57: {
                        return 3777;
                    }
                    case 58: {
                        return 3782;
                    }
                    case 59: {
                        return 3786;
                    }
                    case 60: {
                        return 3793;
                    }
                    case 61: {
                        return 3790;
                    }
                    case 62: {
                        return 3792;
                    }
                    case 63: {
                        return 3446;
                    }
                    case 64: {
                        return 3794;
                    }
                    case 65: {
                        return 3795;
                    }
                    case 66: {
                        return 3796;
                    }
                    case 67: {
                        return 3797;
                    }
                    case 68: {
                        return 3798;
                    }
                    case 69: {
                        return 3799;
                    }
                    case 70: {
                        return 3800;
                    }
                    case 71: {
                        return 3801;
                    }
                    case 72: {
                        return 3802;
                    }
                    case 73: {
                        return 3803;
                    }
                    case 74: {
                        return 3804;
                    }
                    case 75: {
                        return 3805;
                    }
                    case 76: {
                        return 3806;
                    }
                    case 77: {
                        return 3807;
                    }
                    case 78: {
                        return 3808;
                    }
                    case 79: {
                        return 3809;
                    }
                    case 80: {
                        return 3810;
                    }
                    case 81: {
                        return 3811;
                    }
                    case 82: {
                        return 3812;
                    }
                    case 83: {
                        return 3813;
                    }
                    case 84: {
                        return 3814;
                    }
                    case 85: {
                        return 3815;
                    }
                    case 86: {
                        return 3816;
                    }
                    case 87: {
                        return 3817;
                    }
                    case 88: {
                        return 3818;
                    }
                    case 89: {
                        return 3819;
                    }
                    case 90: {
                        return 3820;
                    }
                    case 91: {
                        return 3821;
                    }
                    case 92: {
                        return 3822;
                    }
                    case 93: {
                        return 3823;
                    }
                    case 94: {
                        return 3824;
                    }
                    case 95: {
                        return 3825;
                    }
                    case 96: {
                        return 175;
                    }
                    case 97: {
                        return 176;
                    }
                    case 98: {
                        return 177;
                    }
                    case 99: {
                        return 178;
                    }
                    case 100: {
                        return 3787;
                    }
                    case 101: {
                        return 179;
                    }
                    case 102: {
                        return 180;
                    }
                    case 103: {
                        return 181;
                    }
                    case 104: {
                        return 3826;
                    }
                    case 105: {
                        return 3827;
                    }
                    case 106: {
                        return 3828;
                    }
                    case 107: {
                        return 3829;
                    }
                    case 108: {
                        return 3830;
                    }
                    case 109: {
                        return 3831;
                    }
                    case 110: {
                        return 3832;
                    }
                    case 111: {
                        return 3833;
                    }
                    case 112: {
                        return 3834;
                    }
                    case 113: {
                        return 3835;
                    }
                    case 114: {
                        return 3836;
                    }
                    case 115: {
                        return 3837;
                    }
                    case 116: {
                        return 3838;
                    }
                    case 117: {
                        return 3839;
                    }
                    case 118: {
                        return 3840;
                    }
                    case 119: {
                        return 3841;
                    }
                    case 120: {
                        return 3842;
                    }
                    case 121: {
                        return 3843;
                    }
                    case 122: {
                        return 3844;
                    }
                    case 123: {
                        return 3845;
                    }
                    case 124: {
                        return 3846;
                    }
                    case 125: {
                        return 3847;
                    }
                    case 126: {
                        return 3848;
                    }
                    case 127: {
                        return 3849;
                    }
                    case 128: {
                        return 3850;
                    }
                    case 129: {
                        return 3851;
                    }
                    case 130: {
                        return 3852;
                    }
                    case 131: {
                        return 3853;
                    }
                    case 132: {
                        return 3854;
                    }
                    case 133: {
                        return 3855;
                    }
                    case 134: {
                        return 3856;
                    }
                    case 135: {
                        return 3857;
                    }
                    case 136: {
                        return 3858;
                    }
                    case 137: {
                        return 3859;
                    }
                    case 138: {
                        return 3860;
                    }
                    case 139: {
                        return 3861;
                    }
                    case 140: {
                        return 3862;
                    }
                    case 141: {
                        return 3863;
                    }
                    case 142: {
                        return 3864;
                    }
                    case 143: {
                        return 3865;
                    }
                    case 144: {
                        return 3866;
                    }
                    case 145: {
                        return 3867;
                    }
                    case 146: {
                        return 3868;
                    }
                    case 147: {
                        return 3869;
                    }
                    case 148: {
                        return 3870;
                    }
                    case 149: {
                        return 3871;
                    }
                    case 150: {
                        return 3872;
                    }
                    case 151: {
                        return 3873;
                    }
                    case 152: {
                        return 3874;
                    }
                    case 153: {
                        return 3875;
                    }
                    case 154: {
                        return 3876;
                    }
                    case 155: {
                        return 3877;
                    }
                    case 156: {
                        return 3878;
                    }
                    case 157: {
                        return 3879;
                    }
                    case 158: {
                        return 3880;
                    }
                    case 159: {
                        return 3881;
                    }
                    case 160: {
                        return 175;
                    }
                    case 161: {
                        return 176;
                    }
                    case 162: {
                        return 177;
                    }
                    case 163: {
                        return 178;
                    }
                    case 164: {
                        return 3787;
                    }
                    case 165: {
                        return 179;
                    }
                    case 166: {
                        return 180;
                    }
                    case 167: {
                        return 181;
                    }
                    case 168: {
                        return 3882;
                    }
                    case 169: {
                        return 3883;
                    }
                    case 170: {
                        return 3884;
                    }
                    case 171: {
                        return 3885;
                    }
                    case 172: {
                        return 3886;
                    }
                    case 173: {
                        return 3887;
                    }
                    case 174: {
                        return 3888;
                    }
                    case 175: {
                        return 3889;
                    }
                    case 176: {
                        return 3890;
                    }
                    case 177: {
                        return 3891;
                    }
                    case 178: {
                        return 3892;
                    }
                    case 179: {
                        return 3893;
                    }
                    case 180: {
                        return 3894;
                    }
                    case 181: {
                        return 3895;
                    }
                    case 182: {
                        return 3896;
                    }
                    case 183: {
                        return 3897;
                    }
                    case 184: {
                        return 3898;
                    }
                    case 185: {
                        return 3899;
                    }
                    case 186: {
                        return 3900;
                    }
                    case 187: {
                        return 3901;
                    }
                    case 188: {
                        return 3902;
                    }
                    case 189: {
                        return 3903;
                    }
                    case 190: {
                        return 3904;
                    }
                    case 191: {
                        return 3905;
                    }
                    case 192: {
                        return 3906;
                    }
                    case 193: {
                        return 3907;
                    }
                    case 194: {
                        return 3908;
                    }
                    case 195: {
                        return 3909;
                    }
                    case 196: {
                        return 3910;
                    }
                    case 197: {
                        return 3911;
                    }
                    case 198: {
                        return 3912;
                    }
                    case 199: {
                        return 3913;
                    }
                    case 200: {
                        return 3914;
                    }
                    case 201: {
                        return 3915;
                    }
                    case 202: {
                        return 3916;
                    }
                    case 203: {
                        return 3917;
                    }
                    case 204: {
                        return 3918;
                    }
                    case 205: {
                        return 3919;
                    }
                    case 206: {
                        return 3920;
                    }
                    case 207: {
                        return 3921;
                    }
                    case 208: {
                        return 3922;
                    }
                    case 209: {
                        return 3923;
                    }
                    case 210: {
                        return 3924;
                    }
                    case 211: {
                        return 3925;
                    }
                    case 212: {
                        return 3926;
                    }
                    case 213: {
                        return 3927;
                    }
                    case 214: {
                        return 3928;
                    }
                    case 215: {
                        return 3929;
                    }
                    case 216: {
                        return 3930;
                    }
                    case 217: {
                        return 3931;
                    }
                    case 218: {
                        return 3932;
                    }
                    case 219: {
                        return 3933;
                    }
                    case 220: {
                        return 3934;
                    }
                    case 221: {
                        return 3935;
                    }
                    case 222: {
                        return 3936;
                    }
                    case 223: {
                        return 3937;
                    }
                    case 224: {
                        return 175;
                    }
                    case 225: {
                        return 176;
                    }
                    case 226: {
                        return 177;
                    }
                    case 227: {
                        return 178;
                    }
                    case 228: {
                        return 3787;
                    }
                    case 229: {
                        return 179;
                    }
                    case 230: {
                        return 180;
                    }
                    case 231: {
                        return 181;
                    }
                    case 232: {
                        return 3938;
                    }
                    case 233: {
                        return 3939;
                    }
                    case 234: {
                        return 3940;
                    }
                    case 235: {
                        return 3941;
                    }
                    case 236: {
                        return 3942;
                    }
                    case 237: {
                        return 3943;
                    }
                    case 238: {
                        return 3944;
                    }
                    case 239: {
                        return 3945;
                    }
                    case 240: {
                        return 3946;
                    }
                    case 241: {
                        return 3947;
                    }
                    case 242: {
                        return 3948;
                    }
                    case 243: {
                        return 3949;
                    }
                    case 244: {
                        return 3950;
                    }
                    case 245: {
                        return 3951;
                    }
                    case 246: {
                        return 3952;
                    }
                    case 247: {
                        return 3953;
                    }
                    case 248: {
                        return 3954;
                    }
                    case 249: {
                        return 3955;
                    }
                    case 250: {
                        return 3956;
                    }
                    case 251: {
                        return 3957;
                    }
                    case 252: {
                        return 3958;
                    }
                    case 253: {
                        return 3959;
                    }
                    case 254: {
                        return 3960;
                    }
                    case 255: 
                }
                return 3961;
            }
        }
        throw new IllegalStateException("Bug In Decoder: Invalid segment prefix value passed");
    }

    private static int decodeST(int n) {
        switch (n & 7) {
            case 0: {
                return 48;
            }
            case 1: {
                return 49;
            }
            case 2: {
                return 50;
            }
            case 3: {
                return 51;
            }
            case 4: {
                return 52;
            }
            case 5: {
                return 53;
            }
            case 6: {
                return 54;
            }
            case 7: {
                return 55;
            }
        }
        return -1;
    }

    private class Operation {
        private int[] microcodes = new int[10];
        private int microcodesLength;
        private int x86Length;
        private int readOffset;
        private boolean decoded;
        private boolean terminal;

        Operation() {
        }

        void write(int n) {
            try {
                this.microcodes[this.microcodesLength++] = n;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                int[] nArray = new int[2 * this.microcodes.length];
                System.arraycopy(this.microcodes, 0, nArray, 0, this.microcodes.length);
                this.microcodes = nArray;
                this.microcodes[this.microcodesLength++] = n;
            }
        }

        void replace(int n, int n2) {
            this.microcodes[n] = n2;
        }

        void finish(int n) {
            this.x86Length = n;
            this.decoded = true;
        }

        void makeTerminal() {
            this.reset();
            this.terminal = true;
        }

        boolean terminal() {
            return this.terminal;
        }

        boolean decoded() {
            return this.decoded;
        }

        void reset() {
            this.microcodesLength = 0;
            this.x86Length = 0;
            this.readOffset = 0;
            this.decoded = false;
            this.terminal = false;
        }

        int getMicrocodeAt(int n) {
            return this.microcodes[n];
        }

        int getMicrocode() {
            if (this.readOffset < this.microcodesLength) {
                return this.microcodes[this.readOffset++];
            }
            throw new IllegalStateException();
        }

        int getLength() {
            return this.microcodesLength;
        }

        int getX86Length() {
            return this.x86Length;
        }
    }
}

