/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator.processor;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import org.jpc.emulator.HardwareComponent;
import org.jpc.emulator.memory.AlignmentCheckedAddressSpace;
import org.jpc.emulator.memory.LinearAddressSpace;
import org.jpc.emulator.memory.PhysicalAddressSpace;
import org.jpc.emulator.motherboard.IOPortHandler;
import org.jpc.emulator.motherboard.InterruptController;
import org.jpc.emulator.processor.ModeSwitchException;
import org.jpc.emulator.processor.ProcessorException;
import org.jpc.emulator.processor.Segment;
import org.jpc.emulator.processor.SegmentFactory;
import org.jpc.emulator.processor.fpu64.FpuState;
import org.jpc.emulator.processor.fpu64.FpuState64;
import org.jpc.support.Clock;

public class Processor
implements HardwareComponent {
    public static final int STATE_VERSION = 1;
    public static final int STATE_MINOR_VERSION = 0;
    public static final int CLOCK_SPEED = 50;
    public static final int IFLAGS_HARDWARE_INTERRUPT = 1;
    public static final int IFLAGS_PROCESSOR_EXCEPTION = 2;
    public static final int IFLAGS_RESET_REQUEST = 4;
    public static final int PROC_EXCEPTION_DE = 0;
    public static final int PROC_EXCEPTION_DB = 1;
    public static final int PROC_EXCEPTION_BP = 3;
    public static final int PROC_EXCEPTION_OF = 4;
    public static final int PROC_EXCEPTION_BR = 5;
    public static final int PROC_EXCEPTION_UD = 6;
    public static final int PROC_EXCEPTION_NM = 7;
    public static final int PROC_EXCEPTION_DF = 8;
    public static final int PROC_EXCEPTION_MF_09 = 9;
    public static final int PROC_EXCEPTION_TS = 10;
    public static final int PROC_EXCEPTION_NP = 11;
    public static final int PROC_EXCEPTION_SS = 12;
    public static final int PROC_EXCEPTION_GP = 13;
    public static final int PROC_EXCEPTION_PF = 14;
    public static final int PROC_EXCEPTION_MF_10 = 16;
    public static final int PROC_EXCEPTION_AC = 17;
    public static final int PROC_EXCEPTION_MC = 18;
    public static final int PROC_EXCEPTION_XF = 19;
    public static final int PROC_EXCEPTION_MAX = 19;
    public static final int CR0_PROTECTION_ENABLE = 1;
    public static final int CR0_MONITOR_COPROCESSOR = 2;
    public static final int CR0_FPU_EMULATION = 4;
    public static final int CR0_TASK_SWITCHED = 8;
    public static final int CR0_NUMERIC_ERROR = 32;
    public static final int CR0_WRITE_PROTECT = 65536;
    public static final int CR0_ALIGNMENT_MASK = 262144;
    public static final int CR0_NOT_WRITETHROUGH = 0x20000000;
    public static final int CR0_CACHE_DISABLE = 0x40000000;
    public static final int CR0_PAGING = Integer.MIN_VALUE;
    public static final int CR3_PAGE_CACHE_DISABLE = 16;
    public static final int CR3_PAGE_WRITES_TRANSPARENT = 8;
    public static final int CR4_VIRTUAL8086_MODE_EXTENSIONS = 1;
    public static final int CR4_PROTECTED_MODE_VIRTUAL_INTERRUPTS = 2;
    public static final int CR4_TIME_STAMP_DISABLE = 4;
    public static final int CR4_DEBUGGING_EXTENSIONS = 8;
    public static final int CR4_PAGE_SIZE_EXTENSIONS = 16;
    public static final int CR4_PHYSICAL_ADDRESS_EXTENSION = 32;
    public static final int CR4_MACHINE_CHECK_ENABLE = 64;
    public static final int CR4_PAGE_GLOBAL_ENABLE = 128;
    public static final int CR4_PERFORMANCE_MONITORING_COUNTER_ENABLE = 256;
    public static final int CR4_OS_SUPPORT_FXSAVE_FXSTORE = 512;
    public static final int CR4_OS_SUPPORT_UNMASKED_SIMD_EXCEPTIONS = 1024;
    public static final int SYSENTER_CS_MSR = 372;
    public static final int SYSENTER_ESP_MSR = 373;
    public static final int SYSENTER_EIP_MSR = 374;
    public int eax;
    public int ebx;
    public int edx;
    public int ecx;
    public int esi;
    public int edi;
    public int esp;
    public int ebp;
    public int eip;
    private int cr0;
    private int cr1;
    private int cr2;
    private int cr3;
    private int cr4;
    public int dr0;
    public int dr1;
    public int dr2;
    public int dr3;
    public int dr4;
    public int dr5;
    public int dr6;
    public int dr7;
    public Segment cs;
    public Segment ds;
    public Segment ss;
    public Segment es;
    public Segment fs;
    public Segment gs;
    public Segment idtr;
    public Segment gdtr;
    public Segment ldtr;
    public Segment tss;
    public boolean eflagsCarry;
    public boolean eflagsParity;
    public boolean eflagsAuxiliaryCarry;
    public boolean eflagsZero;
    public boolean eflagsSign;
    public boolean eflagsTrap;
    public boolean eflagsInterruptEnable;
    public boolean eflagsDirection;
    public boolean eflagsOverflow;
    public int eflagsIOPrivilegeLevel;
    public boolean eflagsNestedTask;
    public boolean eflagsResume;
    public boolean eflagsVirtual8086Mode;
    public boolean eflagsAlignmentCheck;
    public boolean eflagsVirtualInterrupt;
    public boolean eflagsVirtualInterruptPending;
    public boolean eflagsID;
    public boolean eflagsInterruptEnableSoon;
    public LinearAddressSpace linearMemory;
    public PhysicalAddressSpace physicalMemory;
    public AlignmentCheckedAddressSpace alignmentCheckedMemory;
    public IOPortHandler ioports;
    private int interruptFlags;
    private InterruptController interruptController;
    private Clock virtualClock;
    private boolean alignmentChecking;
    private Hashtable modelSpecificRegisters;
    private long resetTime;
    private int currentPrivilegeLevel;
    public FpuState fpu;
    private int auxiliaryCarryOne;
    private int auxiliaryCarryTwo;
    private int auxiliaryCarryThree;
    private boolean auxiliaryCarryCalculated;
    private int auxiliaryCarryMethod;
    public static final int AC_XOR = 1;
    public static final int AC_BIT4_NEQ = 2;
    public static final int AC_LNIBBLE_MAX = 3;
    public static final int AC_LNIBBLE_ZERO = 4;
    public static final int AC_LNIBBLE_NZERO = 5;
    private static final boolean[] parityMap = new boolean[256];
    private int parityOne;
    private boolean parityCalculated;
    private int overflowOne;
    private int overflowTwo;
    private int overflowThree;
    private long overflowLong;
    private boolean overflowCalculated;
    private int overflowMethod;
    public static final int OF_NZ = 1;
    public static final int OF_NOT_BYTE = 2;
    public static final int OF_NOT_SHORT = 3;
    public static final int OF_NOT_INT = 4;
    public static final int OF_LOW_WORD_NZ = 5;
    public static final int OF_HIGH_BYTE_NZ = 6;
    public static final int OF_BIT6_XOR_CARRY = 7;
    public static final int OF_BIT7_XOR_CARRY = 8;
    public static final int OF_BIT14_XOR_CARRY = 9;
    public static final int OF_BIT15_XOR_CARRY = 10;
    public static final int OF_BIT30_XOR_CARRY = 11;
    public static final int OF_BIT31_XOR_CARRY = 12;
    public static final int OF_BIT7_XOR_BIT6 = 13;
    public static final int OF_BIT15_XOR_BIT14 = 14;
    public static final int OF_BIT31_XOR_BIT30 = 15;
    public static final int OF_BIT7_DIFFERENT = 16;
    public static final int OF_BIT15_DIFFERENT = 17;
    public static final int OF_BIT31_DIFFERENT = 18;
    public static final int OF_MAX_BYTE = 19;
    public static final int OF_MAX_SHORT = 20;
    public static final int OF_MAX_INT = 21;
    public static final int OF_MIN_BYTE = 22;
    public static final int OF_MIN_SHORT = 23;
    public static final int OF_MIN_INT = 24;
    public static final int OF_ADDSUB_BYTE = 25;
    public static final int OF_ADDSUB_SHORT = 26;
    public static final int OF_ADDSUB_INT = 27;
    private int carryOne;
    private int carryTwo;
    private int carryThree;
    private long carryLong;
    private boolean carryCalculated;
    private int carryMethod;
    public static final int CY_NZ = 1;
    public static final int CY_NOT_BYTE = 2;
    public static final int CY_NOT_SHORT = 3;
    public static final int CY_NOT_INT = 4;
    public static final int CY_LOW_WORD_NZ = 5;
    public static final int CY_HIGH_BYTE_NZ = 6;
    public static final int CY_NTH_BIT_SET = 7;
    public static final int CY_GREATER_FF = 8;
    public static final int CY_TWIDDLE_FF = 9;
    public static final int CY_TWIDDLE_FFFF = 10;
    public static final int CY_TWIDDLE_FFFFFFFF = 11;
    public static final int CY_SHL_OUTBIT_BYTE = 12;
    public static final int CY_SHL_OUTBIT_SHORT = 13;
    public static final int CY_SHL_OUTBIT_INT = 14;
    public static final int CY_SHR_OUTBIT = 15;
    public static final int CY_LOWBIT = 16;
    public static final int CY_HIGHBIT_BYTE = 17;
    public static final int CY_HIGHBIT_SHORT = 18;
    public static final int CY_HIGHBIT_INT = 19;
    public static final int CY_OFFENDBIT_BYTE = 20;
    public static final int CY_OFFENDBIT_SHORT = 21;
    public static final int CY_OFFENDBIT_INT = 22;
    private int zeroOne;
    private boolean zeroCalculated;
    private int zeroMethod;
    private int signOne;
    private boolean signCalculated;
    private int signMethod;

    public Processor() {
        this.fpu = new FpuState64(this);
        this.linearMemory = null;
        this.physicalMemory = null;
        this.alignmentCheckedMemory = null;
        this.ioports = null;
        this.alignmentChecking = false;
        this.modelSpecificRegisters = new Hashtable();
    }

    public Processor(Processor processor) {
        this.eax = processor.eax;
        this.ebx = processor.ebx;
        this.edx = processor.edx;
        this.ecx = processor.ecx;
        this.esi = processor.esi;
        this.edi = processor.edi;
        this.esp = processor.esp;
        this.ebp = processor.ebp;
        this.eip = processor.eip;
        this.dr0 = processor.dr0;
        this.dr1 = processor.dr1;
        this.dr2 = processor.dr2;
        this.dr3 = processor.dr3;
        this.dr4 = processor.dr3;
        this.dr5 = processor.dr5;
        this.dr6 = processor.dr6;
        this.dr7 = processor.dr7;
        this.cs = processor.cs;
        this.ds = processor.ds;
        this.ss = processor.ss;
        this.es = processor.es;
        this.fs = processor.fs;
        this.gs = processor.gs;
        this.idtr = processor.idtr;
        this.gdtr = processor.gdtr;
        this.ldtr = processor.ldtr;
        this.tss = processor.tss;
        this.eflagsCarry = processor.eflagsCarry;
        this.eflagsParity = processor.eflagsParity;
        this.eflagsAuxiliaryCarry = processor.eflagsAuxiliaryCarry;
        this.eflagsZero = processor.eflagsZero;
        this.eflagsSign = processor.eflagsSign;
        this.eflagsTrap = processor.eflagsTrap;
        this.eflagsInterruptEnable = processor.eflagsInterruptEnable;
        this.eflagsDirection = processor.eflagsDirection;
        this.eflagsOverflow = processor.eflagsOverflow;
        this.eflagsIOPrivilegeLevel = processor.eflagsIOPrivilegeLevel;
        this.eflagsNestedTask = processor.eflagsNestedTask;
        this.eflagsResume = processor.eflagsResume;
        this.eflagsVirtual8086Mode = processor.eflagsVirtual8086Mode;
        this.eflagsAlignmentCheck = processor.eflagsAlignmentCheck;
        this.eflagsVirtualInterrupt = processor.eflagsVirtualInterrupt;
        this.eflagsVirtualInterruptPending = processor.eflagsVirtualInterruptPending;
        this.eflagsID = processor.eflagsID;
        this.eflagsInterruptEnableSoon = processor.eflagsInterruptEnableSoon;
        this.linearMemory = processor.linearMemory;
        this.physicalMemory = processor.physicalMemory;
        this.alignmentCheckedMemory = processor.alignmentCheckedMemory;
        this.ioports = processor.ioports;
        this.fpu = processor.fpu;
    }

    public boolean equals(Processor processor) {
        return this.eax == processor.eax && this.ebx == processor.ebx && this.edx == processor.edx && this.ecx == processor.ecx && this.esi == processor.esi && this.edi == processor.edi && this.esp == processor.esp && this.ebp == processor.ebp && this.eip == processor.eip && this.dr0 == processor.dr0 && this.dr1 == processor.dr1 && this.dr2 == processor.dr2 && this.dr3 == processor.dr3 && this.dr4 == processor.dr3 && this.dr5 == processor.dr5 && this.dr6 == processor.dr6 && this.dr7 == processor.dr7 && this.cs == processor.cs && this.ds == processor.ds && this.ss == processor.ss && this.es == processor.es && this.fs == processor.fs && this.gs == processor.gs && this.idtr == processor.idtr && this.gdtr == processor.gdtr && this.ldtr == processor.ldtr && this.tss == processor.tss && this.eflagsCarry == processor.eflagsCarry && this.eflagsParity == processor.eflagsParity && this.eflagsAuxiliaryCarry == processor.eflagsAuxiliaryCarry && this.eflagsZero == processor.eflagsZero && this.eflagsSign == processor.eflagsSign && this.eflagsTrap == processor.eflagsTrap && this.eflagsInterruptEnable == processor.eflagsInterruptEnable && this.eflagsDirection == processor.eflagsDirection && this.eflagsOverflow == processor.eflagsOverflow && this.eflagsIOPrivilegeLevel == processor.eflagsIOPrivilegeLevel && this.eflagsNestedTask == processor.eflagsNestedTask && this.eflagsResume == processor.eflagsResume && this.eflagsVirtual8086Mode == processor.eflagsVirtual8086Mode && this.eflagsAlignmentCheck == processor.eflagsAlignmentCheck && this.eflagsVirtualInterrupt == processor.eflagsVirtualInterrupt && this.eflagsVirtualInterruptPending == processor.eflagsVirtualInterruptPending && this.eflagsID == processor.eflagsID && this.eflagsInterruptEnableSoon == processor.eflagsInterruptEnableSoon && this.linearMemory == processor.linearMemory && this.physicalMemory == processor.physicalMemory && this.alignmentCheckedMemory == processor.alignmentCheckedMemory && this.ioports == processor.ioports && this.fpu == processor.fpu;
    }

    public int getEFlags() {
        int n = 2;
        if (this.getCarryFlag()) {
            n |= 1;
        }
        if (this.getParityFlag()) {
            n |= 4;
        }
        if (this.getAuxiliaryCarryFlag()) {
            n |= 0x10;
        }
        if (this.getZeroFlag()) {
            n |= 0x40;
        }
        if (this.getSignFlag()) {
            n |= 0x80;
        }
        if (this.eflagsTrap) {
            n |= 0x100;
        }
        if (this.eflagsInterruptEnable) {
            n |= 0x200;
        }
        if (this.eflagsDirection) {
            n |= 0x400;
        }
        if (this.getOverflowFlag()) {
            n |= 0x800;
        }
        n |= this.eflagsIOPrivilegeLevel << 12;
        if (this.eflagsNestedTask) {
            n |= 0x4000;
        }
        if (this.eflagsResume) {
            n |= 0x10000;
        }
        if (this.eflagsVirtual8086Mode) {
            n |= 0x20000;
        }
        if (this.eflagsAlignmentCheck) {
            n |= 0x40000;
        }
        if (this.eflagsVirtualInterrupt) {
            n |= 0x80000;
        }
        if (this.eflagsVirtualInterruptPending) {
            n |= 0x100000;
        }
        if (this.eflagsID) {
            n |= 0x200000;
        }
        return n;
    }

    public void setEFlags(int n) {
        this.setCarryFlag((n & 1) != 0);
        this.setParityFlag((n & 4) != 0);
        this.setAuxiliaryCarryFlag((n & 0x10) != 0);
        this.setZeroFlag((n & 0x40) != 0);
        this.setSignFlag((n & 0x80) != 0);
        this.eflagsTrap = (n & 0x100) != 0;
        this.eflagsInterruptEnable = (n & 0x200) != 0;
        this.eflagsInterruptEnableSoon = this.eflagsInterruptEnable;
        this.eflagsDirection = (n & 0x400) != 0;
        this.setOverflowFlag((n & 0x800) != 0);
        this.eflagsIOPrivilegeLevel = n >> 12 & 3;
        this.eflagsNestedTask = (n & 0x4000) != 0;
        this.eflagsResume = (n & 0x10000) != 0;
        this.eflagsVirtual8086Mode = (n & 0x20000) != 0;
        this.eflagsVirtualInterrupt = (n & 0x80000) != 0;
        this.eflagsVirtualInterruptPending = (n & 0x100000) != 0;
        boolean bl = this.eflagsID = (n & 0x200000) != 0;
        if (this.eflagsVirtual8086Mode) {
            System.err.println("Should be in Virtual-8086 mode");
        }
        if (this.eflagsAlignmentCheck != ((n & 0x40000) != 0)) {
            this.eflagsAlignmentCheck = (n & 0x40000) != 0;
            this.checkAlignmentChecking();
        }
    }

    public void processClock() {
        this.virtualClock.process();
    }

    public void setCPL(int n) {
        this.currentPrivilegeLevel = n;
        this.linearMemory.setSupervisor(this.currentPrivilegeLevel == 0);
        this.checkAlignmentChecking();
    }

    public int getCPL() {
        return this.currentPrivilegeLevel;
    }

    public void reportFPUException() {
        if ((this.cr0 & 0x20) != 0) {
            System.err.println("Reporting FPU Error Via Exception 0x10");
            throw new ProcessorException(16, true);
        }
        System.err.println("Reporting FPU Error Via IRQ#13");
        this.interruptController.setIRQ(13, 1);
    }

    public synchronized void raiseInterrupt() {
        this.interruptFlags |= 1;
        this.notifyAll();
    }

    public synchronized void waitForInterrupt(long l) {
        try {
            this.wait(l);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void clearInterrupt() {
        this.interruptFlags &= 0xFFFFFFFE;
    }

    public void requestReset() {
        this.interruptFlags |= 4;
    }

    public int getInterruptFlags() {
        return this.interruptFlags;
    }

    public boolean isProtectedMode() {
        return (this.cr0 & 1) == 1;
    }

    public void setCR0(int n) {
        boolean bl;
        int n2 = (n |= 0x10) ^ this.cr0;
        if (n2 == 0) {
            return;
        }
        this.cr0 = n;
        boolean bl2 = (n2 & Integer.MIN_VALUE) != 0;
        boolean bl3 = (n2 & 0x40000000) != 0;
        boolean bl4 = (n2 & 1) != 0;
        boolean bl5 = (n2 & 0x10000) != 0;
        boolean bl6 = bl = (n2 & 0x40000) != 0;
        if ((n2 & 0x20000000) != 0) {
            System.err.println("INFO: Unimplemented CR0 flags changed (" + Integer.toHexString(n2) + "). Now is " + Integer.toHexString(n));
        }
        if (bl2 && (n & 1) == 0 && (n & Integer.MIN_VALUE) == 1) {
            throw new ProcessorException(13, 0, true);
        }
        if (bl) {
            this.checkAlignmentChecking();
        }
        if (bl2 || bl3) {
            this.linearMemory.setPagingEnabled((n & Integer.MIN_VALUE) != 0);
            this.linearMemory.setPageCacheEnabled((n & 0x40000000) == 0);
        }
        if (bl4) {
            if ((n & 1) != 0) {
                this.convertSegmentsToProtectedMode();
                throw ModeSwitchException.PROTECTED_MODE_EXCEPTION;
            }
            this.linearMemory.flush();
            this.setCPL(0);
            this.convertSegmentsToRealMode();
            throw ModeSwitchException.REAL_MODE_EXCEPTION;
        }
        if (bl5) {
            this.linearMemory.setWriteProtectUserPages((n & 0x10000) != 0);
        }
    }

    public int getCR0() {
        return this.cr0;
    }

    public void setCR3(int n) {
        this.cr3 = n;
        this.linearMemory.setPageWriteThroughEnabled((n & 8) != 0);
        this.linearMemory.setPageCacheEnabled((n & 0x10) == 0);
        this.linearMemory.setPageDirectoryBaseAddress(n);
    }

    public int getCR3() {
        return this.cr3;
    }

    public int getCR2() {
        return this.cr2;
    }

    public void setCR2(int n) {
        this.cr2 = n;
    }

    public void setCR4(int n) {
        if (this.cr4 == n) {
            return;
        }
        this.cr4 = n;
        if ((this.cr4 & 0x400) != 0) {
            System.err.println("WARNING: SIMD instruction support modified in the processor");
        }
        if ((this.cr4 & 0x200) != 0) {
            System.err.println("WARNING: FXSave and FXRStore flag enabled in the processor");
        }
        if ((this.cr4 & 8) != 0) {
            System.err.println("WARNING: debugging extensions enabled");
        }
        if ((this.cr4 & 4) != 0) {
            System.err.println("WARNING: timestamp restricted to CPL0");
        }
        if ((this.cr4 & 0x20) != 0) {
            throw new IllegalStateException("36 Bit Addressing enabled");
        }
        this.linearMemory.setGlobalPagesEnabled((n & 0x80) != 0);
        this.linearMemory.setPageSizeExtensionsEnabled((this.cr4 & 0x10) != 0);
    }

    public int getCR4() {
        return this.cr4;
    }

    public void setDR0(int n) {
        this.dr0 = n;
    }

    public void setDR1(int n) {
        this.dr1 = n;
    }

    public void setDR2(int n) {
        this.dr2 = n;
    }

    public void setDR3(int n) {
        this.dr3 = n;
    }

    public void setDR6(int n) {
        this.dr6 = n;
    }

    public void setDR7(int n) {
        this.dr7 = n;
    }

    public int getDR0() {
        return this.dr0;
    }

    public int getDR1() {
        return this.dr1;
    }

    public int getDR2() {
        return this.dr2;
    }

    public int getDR3() {
        return this.dr3;
    }

    public int getDR6() {
        return this.dr6;
    }

    public int getDR7() {
        return this.dr7;
    }

    public long getMSR(int n) {
        try {
            return (Long)this.modelSpecificRegisters.get(new Integer(n));
        }
        catch (NullPointerException nullPointerException) {
            System.err.println("Reading unset MSR " + n + " : Returning 0");
            return 0L;
        }
    }

    public void setMSR(int n, long l) {
        this.modelSpecificRegisters.put(new Integer(n), new Long(l));
    }

    private void convertSegmentsToRealMode() {
        this.cs = this.createRealModeSegment(this.cs.translateAddressRead(0) >>> 4);
        this.ds = this.createRealModeSegment(this.ds.translateAddressRead(0) >>> 4);
        this.ss = this.createRealModeSegment(this.ss.translateAddressRead(0) >>> 4);
        this.es = this.createRealModeSegment(this.es.translateAddressRead(0) >>> 4);
        this.fs = this.createRealModeSegment(this.fs.translateAddressRead(0) >>> 4);
        this.gs = this.createRealModeSegment(this.gs.translateAddressRead(0) >>> 4);
    }

    private void convertSegmentsToProtectedMode() {
        this.cs.setAddressSpace(this.linearMemory);
        this.ds.setAddressSpace(this.linearMemory);
        this.ss.setAddressSpace(this.linearMemory);
        this.es.setAddressSpace(this.linearMemory);
        this.fs.setAddressSpace(this.linearMemory);
        this.gs.setAddressSpace(this.linearMemory);
    }

    private void updateAlignmentCheckingInDataSegments() {
        if (this.alignmentChecking) {
            this.ds.setAddressSpace(this.alignmentCheckedMemory);
            this.ss.setAddressSpace(this.alignmentCheckedMemory);
            this.es.setAddressSpace(this.alignmentCheckedMemory);
            this.fs.setAddressSpace(this.alignmentCheckedMemory);
            this.gs.setAddressSpace(this.alignmentCheckedMemory);
        } else {
            this.ds.setAddressSpace(this.linearMemory);
            this.ss.setAddressSpace(this.linearMemory);
            this.es.setAddressSpace(this.linearMemory);
            this.fs.setAddressSpace(this.linearMemory);
            this.gs.setAddressSpace(this.linearMemory);
        }
    }

    public Segment createRealModeSegment(int n) {
        return SegmentFactory.createRealModeSegment(this.physicalMemory, n);
    }

    public Segment createDescriptorTableSegment(int n, int n2) {
        return SegmentFactory.createDescriptorTableSegment(this.linearMemory, n, n2);
    }

    public void correctAlignmentChecking(Segment segment) {
        if (this.alignmentChecking && (segment.getType() & 0x18) == 16) {
            segment.setAddressSpace(this.alignmentCheckedMemory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Segment getSegment(int n) {
        boolean bl = this.linearMemory.isSupervisor();
        try {
            long l = 0L;
            this.linearMemory.setSupervisor(true);
            if ((n & 4) != 0) {
                l = this.ldtr.getQuadWord(n & 0xFFF8);
            } else {
                if (n < 4) {
                    Segment segment = SegmentFactory.NULL_SEGMENT;
                    return segment;
                }
                l = this.gdtr.getQuadWord(n & 0xFFF8);
            }
            Segment segment = SegmentFactory.createProtectedModeSegment(this.linearMemory, n, l);
            if (this.alignmentChecking && (segment.getType() & 0x18) == 16) {
                segment.setAddressSpace(this.alignmentCheckedMemory);
            }
            Segment segment2 = segment;
            return segment2;
        }
        finally {
            this.linearMemory.setSupervisor(bl);
        }
    }

    public void reset() {
        this.resetTime = System.currentTimeMillis();
        this.edx = 0;
        this.ecx = 0;
        this.ebx = 0;
        this.eax = 0;
        this.esp = 0;
        this.ebp = 0;
        this.esi = 0;
        this.edi = 0;
        this.edx = 1587;
        this.interruptFlags = 0;
        this.currentPrivilegeLevel = 0;
        this.linearMemory.reset();
        this.alignmentChecking = false;
        this.eip = 65520;
        this.cr0 = 0x60000010;
        this.cr4 = 0;
        this.cr3 = 0;
        this.cr2 = 0;
        this.dr3 = 0;
        this.dr2 = 0;
        this.dr1 = 0;
        this.dr0 = 0;
        this.dr6 = -61456;
        this.dr7 = 1792;
        this.eflagsInterruptEnable = false;
        this.eflagsTrap = false;
        this.eflagsSign = false;
        this.eflagsZero = false;
        this.eflagsAuxiliaryCarry = false;
        this.eflagsParity = false;
        this.eflagsCarry = false;
        this.signCalculated = true;
        this.zeroCalculated = true;
        this.auxiliaryCarryCalculated = true;
        this.parityCalculated = true;
        this.carryCalculated = true;
        this.eflagsVirtual8086Mode = false;
        this.eflagsResume = false;
        this.eflagsNestedTask = false;
        this.eflagsOverflow = false;
        this.eflagsDirection = false;
        this.overflowCalculated = true;
        this.eflagsID = false;
        this.eflagsVirtualInterruptPending = false;
        this.eflagsVirtualInterrupt = false;
        this.eflagsAlignmentCheck = false;
        this.eflagsIOPrivilegeLevel = 0;
        this.eflagsZero = true;
        this.eflagsInterruptEnableSoon = false;
        this.cs = this.createRealModeSegment(61440);
        this.ds = this.createRealModeSegment(0);
        this.ss = this.createRealModeSegment(0);
        this.es = this.createRealModeSegment(0);
        this.fs = this.createRealModeSegment(0);
        this.gs = this.createRealModeSegment(0);
        this.idtr = SegmentFactory.createDescriptorTableSegment(this.physicalMemory, 0, 65535);
        this.ldtr = SegmentFactory.NULL_SEGMENT;
        this.gdtr = SegmentFactory.createDescriptorTableSegment(this.physicalMemory, 0, 65535);
        this.tss = SegmentFactory.NULL_SEGMENT;
        this.modelSpecificRegisters.clear();
        this.fpu.init();
    }

    public long getClockCount() {
        return (System.currentTimeMillis() - this.resetTime) * 1000L * 50L;
    }

    public final int getInstructionPointer() {
        return this.cs.translateAddressRead(this.eip);
    }

    public final void processRealModeInterrupts() {
        if ((this.interruptFlags & 4) != 0) {
            this.reset();
            return;
        }
        try {
            if (this.eflagsInterruptEnable && (this.interruptFlags & 1) != 0) {
                this.interruptFlags &= 0xFFFFFFFE;
                int n = this.interruptController.cpuGetInterrupt();
                this.handleRealModeInterrupt(n);
            }
        }
        catch (Exception exception) {
            System.err.println("Interrupt Handler Is Throwing An Exception!");
        }
        this.eflagsInterruptEnable = this.eflagsInterruptEnableSoon;
    }

    public final void processProtectedModeInterrupts() {
        if ((this.interruptFlags & 4) != 0) {
            this.reset();
            return;
        }
        try {
            if (this.eflagsInterruptEnable && (this.interruptFlags & 1) != 0) {
                this.interruptFlags &= 0xFFFFFFFE;
                int n = this.interruptController.cpuGetInterrupt();
                this.handleHardProtectedModeInterrupt(n);
            }
        }
        catch (Exception exception) {
            System.err.println("Interrupt Handler Is Throwing An Exception!");
            throw new RuntimeException();
        }
        this.eflagsInterruptEnable = this.eflagsInterruptEnableSoon;
    }

    public final void handleRealModeException(int n) {
        if (n <= 19) {
            this.handleRealModeInterrupt(n);
        }
    }

    private final void handleRealModeInterrupt(int n) {
        if ((this.esp & 0xFFFF) < 6 && (this.esp & 0xFFFF) > 0) {
            throw new IllegalStateException("SS Processor Exception Thrown in \"handleInterrupt(" + n + ")\"");
        }
        int n2 = 0xFFFF & this.idtr.getWord(n *= 4);
        int n3 = 0xFFFF & this.idtr.getWord(n + 2);
        short s = (short)this.esp;
        s = (short)(s - 2);
        int n4 = this.getEFlags() & 0xFFFF;
        this.ss.setWord(s & 0xFFFF, (short)n4);
        this.eflagsInterruptEnable = false;
        this.eflagsInterruptEnableSoon = false;
        this.eflagsTrap = false;
        this.eflagsAlignmentCheck = false;
        s = (short)(s - 2);
        this.ss.setWord(s & 0xFFFF, (short)this.cs.getSelector());
        s = (short)(s - 2);
        this.ss.setWord(s & 0xFFFF, (short)this.eip);
        this.esp = 0xFFFF0000 & this.esp | s & 0xFFFF;
        this.eip = n2;
        if (!this.cs.setSelector(n3)) {
            this.cs = this.createRealModeSegment(n3);
            this.setCPL(0);
        }
    }

    public final void handleProtectedModeException(int n, boolean bl, int n2) {
        int n3 = this.esp;
        int n4 = this.eip;
        Segment segment = this.cs;
        Segment segment2 = this.ss;
        try {
            this.followProtectedModeException(n, bl, n2, false, false);
        }
        catch (ProcessorException processorException) {
            this.esp = n3;
            this.eip = n4;
            this.cs = segment;
            this.ss = segment2;
            if (n == 8) {
                System.err.println("Triple-Fault: Unhandleable, machine will halt!");
                throw new IllegalStateException("Triple Fault " + processorException);
            }
            if (processorException.combinesToDoubleFault(n)) {
                this.handleProtectedModeException(8, true, 0);
            }
            this.handleProtectedModeException(processorException.getVector(), processorException.hasErrorCode(), processorException.getErrorCode());
        }
    }

    public final void handleSoftProtectedModeInterrupt(int n) {
        int n2 = this.esp;
        int n3 = this.eip;
        Segment segment = this.cs;
        Segment segment2 = this.ss;
        try {
            this.followProtectedModeException(n, false, 0, false, true);
        }
        catch (ProcessorException processorException) {
            this.esp = n2;
            this.eip = n3;
            this.cs = segment;
            this.ss = segment2;
            this.handleProtectedModeException(processorException.getVector(), processorException.hasErrorCode(), processorException.getErrorCode());
        }
    }

    public final void handleHardProtectedModeInterrupt(int n) {
        int n2 = this.esp;
        int n3 = this.eip;
        Segment segment = this.cs;
        Segment segment2 = this.ss;
        try {
            this.followProtectedModeException(n, false, 0, true, false);
        }
        catch (ProcessorException processorException) {
            this.esp = n2;
            this.eip = n3;
            this.cs = segment;
            this.ss = segment2;
            this.handleProtectedModeException(processorException.getVector(), processorException.hasErrorCode(), processorException.getErrorCode());
        }
    }

    private final void checkGate(Segment segment, int n, boolean bl) {
        if (bl && segment.getDPL() < this.currentPrivilegeLevel) {
            throw new ProcessorException(13, n + 2, true);
        }
        if (!segment.isPresent()) {
            throw new ProcessorException(11, n, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void followProtectedModeException(int n, boolean bl, int n2, boolean bl2, boolean bl3) {
        Segment segment;
        if (n == 14) {
            this.setCR2(this.linearMemory.getLastWalkedAddress());
        }
        int n3 = n << 3;
        int n4 = bl2 ? 1 : 0;
        boolean bl4 = this.linearMemory.isSupervisor();
        try {
            this.linearMemory.setSupervisor(true);
            long l = this.idtr.getQuadWord(n3);
            segment = SegmentFactory.createProtectedModeSegment(this.linearMemory, n3, l);
        }
        catch (ProcessorException processorException) {
            throw new ProcessorException(13, n3 + 2 + n4, true);
        }
        finally {
            this.linearMemory.setSupervisor(bl4);
        }
        block8 : switch (segment.getType()) {
            default: {
                System.err.println("Invalid Gate Type For Throwing Interrupt: 0x" + Integer.toHexString(segment.getType()));
                throw new ProcessorException(13, n3 + 2 + n4, true);
            }
            case 5: {
                throw new IllegalStateException("Unimplemented Interrupt Handler: Task Gate");
            }
            case 6: {
                throw new IllegalStateException("Unimplemented Interrupt Handler: 16-bit Interrupt Gate");
            }
            case 7: {
                throw new IllegalStateException("Unimplemented Interrupt Handler: 16-bit Trap Gate");
            }
            case 14: {
                Segment segment2;
                SegmentFactory.InterruptGate32Bit interruptGate32Bit = (SegmentFactory.InterruptGate32Bit)segment;
                this.checkGate(segment, n3, bl3);
                int n5 = interruptGate32Bit.getTargetSegment();
                try {
                    segment2 = this.getSegment(n5);
                }
                catch (ProcessorException processorException) {
                    throw new ProcessorException(13, n5 + n4, true);
                }
                if (segment2.getDPL() > this.currentPrivilegeLevel) {
                    throw new ProcessorException(13, n5 + n4, true);
                }
                switch (segment2.getType()) {
                    default: {
                        throw new ProcessorException(13, n5 + n4, true);
                    }
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: {
                        if (!segment2.isPresent()) {
                            throw new ProcessorException(11, n5 + n4, true);
                        }
                        if (segment2.getDPL() < this.currentPrivilegeLevel) {
                            int n6;
                            int n7 = 0;
                            int n8 = 0;
                            if ((this.tss.getType() & 8) != 0) {
                                n6 = segment2.getDPL() * 8 + 4;
                                if (n6 + 7 > this.tss.getLimit()) {
                                    throw new ProcessorException(10, this.tss.getSelector(), true);
                                }
                                bl4 = this.linearMemory.isSupervisor();
                                try {
                                    this.linearMemory.setSupervisor(true);
                                    n7 = 0xFFFF & this.tss.getWord(n6 + 4);
                                    n8 = this.tss.getDoubleWord(n6);
                                }
                                finally {
                                    this.linearMemory.setSupervisor(bl4);
                                }
                            } else {
                                n6 = segment2.getDPL() * 4 + 2;
                                if (n6 + 4 > this.tss.getLimit()) {
                                    throw new ProcessorException(10, this.tss.getSelector(), true);
                                }
                                n7 = 0xFFFF & this.tss.getWord(n6 + 2);
                                n8 = 0xFFFF & this.tss.getWord(n6);
                            }
                            Segment segment3 = null;
                            try {
                                segment3 = this.getSegment(n7);
                            }
                            catch (ProcessorException processorException) {
                                throw new ProcessorException(10, n7, true);
                            }
                            if (segment3.getRPL() != segment2.getDPL()) {
                                throw new ProcessorException(10, n7, true);
                            }
                            if (segment3.getDPL() != segment2.getDPL() || (segment3.getType() & 0x1A) != 18) {
                                throw new ProcessorException(10, n7, true);
                            }
                            if (!segment3.isPresent()) {
                                throw new ProcessorException(12, n7, true);
                            }
                            if (bl ? segment3.getDefaultSizeFlag() && this.esp < 24 && this.esp > 0 || !segment3.getDefaultSizeFlag() && (this.esp & 0xFFFF) < 24 && (this.esp & 0xFFFF) > 0 : segment3.getDefaultSizeFlag() && this.esp < 20 && this.esp > 0 || !segment3.getDefaultSizeFlag() && (this.esp & 0xFFFF) < 20 && (this.esp & 0xFFFF) > 0) {
                                throw new ProcessorException(12, 0, true);
                            }
                            int n9 = interruptGate32Bit.getTargetOffset();
                            segment2.checkAddress(n9);
                            int n10 = this.ss.getSelector();
                            int n11 = this.esp;
                            int n12 = this.cs.getSelector();
                            int n13 = this.eip;
                            this.ss = segment3;
                            this.esp = n8;
                            this.cs = segment2;
                            this.eip = n9;
                            this.setCPL(this.cs.getDPL());
                            if (this.ss.getDefaultSizeFlag()) {
                                this.esp -= 4;
                                this.ss.setDoubleWord(this.esp, n10);
                                this.esp -= 4;
                                this.ss.setDoubleWord(this.esp, n11);
                                this.esp -= 4;
                                this.ss.setDoubleWord(this.esp, this.getEFlags());
                                this.esp -= 4;
                                this.ss.setDoubleWord(this.esp, n12);
                                this.esp -= 4;
                                this.ss.setDoubleWord(this.esp, n13);
                                if (bl) {
                                    this.esp -= 4;
                                    this.ss.setDoubleWord(this.esp, n2);
                                }
                            } else {
                                this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                                this.ss.setDoubleWord(this.esp & 0xFFFF, n10);
                                this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                                this.ss.setDoubleWord(this.esp & 0xFFFF, n11);
                                this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                                this.ss.setDoubleWord(this.esp & 0xFFFF, this.getEFlags());
                                this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                                this.ss.setDoubleWord(this.esp & 0xFFFF, n12);
                                this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                                this.ss.setDoubleWord(this.esp & 0xFFFF, n13);
                                if (bl) {
                                    this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                                    this.ss.setDoubleWord(this.esp & 0xFFFF, n2);
                                }
                            }
                            this.eflagsInterruptEnableSoon = false;
                            this.eflagsInterruptEnable = false;
                            this.eflagsTrap = false;
                            this.eflagsNestedTask = false;
                            this.eflagsVirtual8086Mode = false;
                            this.eflagsResume = false;
                            break block8;
                        }
                        if (segment2.getDPL() == this.currentPrivilegeLevel) {
                            if (bl ? this.ss.getDefaultSizeFlag() && this.esp < 16 && this.esp > 0 || !this.ss.getDefaultSizeFlag() && (this.esp & 0xFFFF) < 16 && (this.esp & 0xFFFF) > 0 : this.ss.getDefaultSizeFlag() && this.esp < 12 && this.esp > 0 || !this.ss.getDefaultSizeFlag() && (this.esp & 0xFFFF) < 12 && (this.esp & 0xFFFF) > 0) {
                                throw new ProcessorException(12, 0, true);
                            }
                            int n14 = interruptGate32Bit.getTargetOffset();
                            segment2.checkAddress(n14);
                            if (this.ss.getDefaultSizeFlag()) {
                                this.esp -= 4;
                                this.ss.setDoubleWord(this.esp, this.getEFlags());
                                this.esp -= 4;
                                this.ss.setDoubleWord(this.esp, this.cs.getSelector());
                                this.esp -= 4;
                                this.ss.setDoubleWord(this.esp, this.eip);
                                if (bl) {
                                    this.esp -= 4;
                                    this.ss.setDoubleWord(this.esp, n2);
                                }
                            } else {
                                this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                                this.ss.setDoubleWord(this.esp & 0xFFFF, this.getEFlags());
                                this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                                this.ss.setDoubleWord(this.esp & 0xFFFF, this.cs.getSelector());
                                this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                                this.ss.setDoubleWord(this.esp & 0xFFFF, this.eip);
                                if (bl) {
                                    this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                                    this.ss.setDoubleWord(this.esp & 0xFFFF, n2);
                                }
                            }
                            this.cs = segment2;
                            this.eip = n14;
                            this.cs.setRPL(this.currentPrivilegeLevel);
                            this.eflagsInterruptEnableSoon = false;
                            this.eflagsInterruptEnable = false;
                            this.eflagsTrap = false;
                            this.eflagsNestedTask = false;
                            this.eflagsVirtual8086Mode = false;
                            this.eflagsResume = false;
                            break block8;
                        }
                        throw new ProcessorException(13, n5 + n4, true);
                    }
                    case 28: 
                    case 29: 
                    case 30: 
                    case 31: 
                }
                if (!segment2.isPresent()) {
                    throw new ProcessorException(11, n3, true);
                }
                if (bl ? this.ss.getDefaultSizeFlag() && this.esp < 16 && this.esp > 0 || !this.ss.getDefaultSizeFlag() && (this.esp & 0xFFFF) < 16 && (this.esp & 0xFFFF) > 0 : this.ss.getDefaultSizeFlag() && this.esp < 12 && this.esp > 0 || !this.ss.getDefaultSizeFlag() && (this.esp & 0xFFFF) < 12 && (this.esp & 0xFFFF) > 0) {
                    throw new ProcessorException(12, 0, true);
                }
                int n15 = interruptGate32Bit.getTargetOffset();
                segment2.checkAddress(n15);
                if (this.ss.getDefaultSizeFlag()) {
                    this.esp -= 4;
                    this.ss.setDoubleWord(this.esp, this.getEFlags());
                    this.esp -= 4;
                    this.ss.setDoubleWord(this.esp, this.cs.getSelector());
                    this.esp -= 4;
                    this.ss.setDoubleWord(this.esp, this.eip);
                    if (bl) {
                        this.esp -= 4;
                        this.ss.setDoubleWord(this.esp, n2);
                    }
                } else {
                    this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                    this.ss.setDoubleWord(this.esp & 0xFFFF, this.getEFlags());
                    this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                    this.ss.setDoubleWord(this.esp & 0xFFFF, this.cs.getSelector());
                    this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                    this.ss.setDoubleWord(this.esp & 0xFFFF, this.eip);
                    if (bl) {
                        this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                        this.ss.setDoubleWord(this.esp & 0xFFFF, n2);
                    }
                }
                this.cs = segment2;
                this.eip = n15;
                this.cs.setRPL(this.currentPrivilegeLevel);
                this.eflagsInterruptEnableSoon = false;
                this.eflagsInterruptEnable = false;
                this.eflagsTrap = false;
                this.eflagsNestedTask = false;
                this.eflagsVirtual8086Mode = false;
                this.eflagsResume = false;
                break;
            }
            case 15: {
                Segment segment4;
                SegmentFactory.TrapGate32Bit trapGate32Bit = (SegmentFactory.TrapGate32Bit)segment;
                this.checkGate(segment, n3, bl3);
                int n16 = trapGate32Bit.getTargetSegment();
                try {
                    segment4 = this.getSegment(n16);
                }
                catch (ProcessorException processorException) {
                    throw new ProcessorException(13, n16 + n4, true);
                }
                if (segment4.getDPL() > this.currentPrivilegeLevel) {
                    throw new ProcessorException(13, n16 + n4, true);
                }
                switch (segment4.getType()) {
                    default: {
                        throw new ProcessorException(13, n16 + n4, true);
                    }
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: {
                        if (!segment4.isPresent()) {
                            throw new ProcessorException(11, n16 + n4, true);
                        }
                        if (segment4.getDPL() < this.currentPrivilegeLevel) {
                            int n17;
                            int n18 = 0;
                            int n19 = 0;
                            if ((this.tss.getType() & 8) != 0) {
                                n17 = segment4.getDPL() * 8 + 4;
                                if (n17 + 7 > this.tss.getLimit()) {
                                    throw new ProcessorException(10, this.tss.getSelector(), true);
                                }
                                bl4 = this.linearMemory.isSupervisor();
                                try {
                                    this.linearMemory.setSupervisor(true);
                                    n18 = 0xFFFF & this.tss.getWord(n17 + 4);
                                    n19 = this.tss.getDoubleWord(n17);
                                }
                                finally {
                                    this.linearMemory.setSupervisor(bl4);
                                }
                            } else {
                                n17 = segment4.getDPL() * 4 + 2;
                                if (n17 + 4 > this.tss.getLimit()) {
                                    throw new ProcessorException(10, this.tss.getSelector(), true);
                                }
                                n18 = 0xFFFF & this.tss.getWord(n17 + 2);
                                n19 = 0xFFFF & this.tss.getWord(n17);
                            }
                            Segment segment5 = null;
                            try {
                                segment5 = this.getSegment(n18);
                            }
                            catch (ProcessorException processorException) {
                                throw new ProcessorException(10, n18, true);
                            }
                            if (segment5.getRPL() != segment4.getDPL()) {
                                throw new ProcessorException(10, n18, true);
                            }
                            if (segment5.getDPL() != segment4.getDPL() || (segment5.getType() & 0x1A) != 18) {
                                throw new ProcessorException(10, n18, true);
                            }
                            if (!segment5.isPresent()) {
                                throw new ProcessorException(12, n18, true);
                            }
                            if (bl ? segment5.getDefaultSizeFlag() && this.esp < 24 && this.esp > 0 || !segment5.getDefaultSizeFlag() && (this.esp & 0xFFFF) < 24 && (this.esp & 0xFFFF) > 0 : segment5.getDefaultSizeFlag() && this.esp < 20 && this.esp > 0 || !segment5.getDefaultSizeFlag() && (this.esp & 0xFFFF) < 20 && (this.esp & 0xFFFF) > 0) {
                                throw new ProcessorException(12, 0, true);
                            }
                            int n20 = trapGate32Bit.getTargetOffset();
                            segment4.checkAddress(n20);
                            int n21 = this.ss.getSelector();
                            int n22 = this.esp;
                            int n23 = this.cs.getSelector();
                            int n24 = this.eip;
                            this.ss = segment5;
                            this.esp = n19;
                            this.cs = segment4;
                            this.eip = n20;
                            this.setCPL(this.cs.getDPL());
                            if (this.ss.getDefaultSizeFlag()) {
                                this.esp -= 4;
                                this.ss.setDoubleWord(this.esp, n21);
                                this.esp -= 4;
                                this.ss.setDoubleWord(this.esp, n22);
                                this.esp -= 4;
                                this.ss.setDoubleWord(this.esp, this.getEFlags());
                                this.esp -= 4;
                                this.ss.setDoubleWord(this.esp, n23);
                                this.esp -= 4;
                                this.ss.setDoubleWord(this.esp, n24);
                                if (bl) {
                                    this.esp -= 4;
                                    this.ss.setDoubleWord(this.esp, n2);
                                }
                            } else {
                                this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                                this.ss.setDoubleWord(this.esp & 0xFFFF, n21);
                                this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                                this.ss.setDoubleWord(this.esp & 0xFFFF, n22);
                                this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                                this.ss.setDoubleWord(this.esp & 0xFFFF, this.getEFlags());
                                this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                                this.ss.setDoubleWord(this.esp & 0xFFFF, n23);
                                this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                                this.ss.setDoubleWord(this.esp & 0xFFFF, n24);
                                if (bl) {
                                    this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                                    this.ss.setDoubleWord(this.esp & 0xFFFF, n2);
                                }
                            }
                            this.eflagsTrap = false;
                            this.eflagsNestedTask = false;
                            this.eflagsVirtual8086Mode = false;
                            this.eflagsResume = false;
                            break block8;
                        }
                        if (segment4.getDPL() == this.currentPrivilegeLevel) {
                            if (bl ? this.ss.getDefaultSizeFlag() && this.esp < 16 && this.esp > 0 || !this.ss.getDefaultSizeFlag() && (this.esp & 0xFFFF) < 16 && (this.esp & 0xFFFF) > 0 : this.ss.getDefaultSizeFlag() && this.esp < 12 && this.esp > 0 || !this.ss.getDefaultSizeFlag() && (this.esp & 0xFFFF) < 12 && (this.esp & 0xFFFF) > 0) {
                                throw new ProcessorException(12, 0, true);
                            }
                            int n25 = trapGate32Bit.getTargetOffset();
                            segment4.checkAddress(n25);
                            if (this.ss.getDefaultSizeFlag()) {
                                this.esp -= 4;
                                this.ss.setDoubleWord(this.esp, this.getEFlags());
                                this.esp -= 4;
                                this.ss.setDoubleWord(this.esp, this.cs.getSelector());
                                this.esp -= 4;
                                this.ss.setDoubleWord(this.esp, this.eip);
                                if (bl) {
                                    this.esp -= 4;
                                    this.ss.setDoubleWord(this.esp, n2);
                                }
                            } else {
                                this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                                this.ss.setDoubleWord(this.esp & 0xFFFF, this.getEFlags());
                                this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                                this.ss.setDoubleWord(this.esp & 0xFFFF, this.cs.getSelector());
                                this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                                this.ss.setDoubleWord(this.esp & 0xFFFF, this.eip);
                                if (bl) {
                                    this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                                    this.ss.setDoubleWord(this.esp & 0xFFFF, n2);
                                }
                            }
                            this.cs = segment4;
                            this.eip = n25;
                            this.cs.setRPL(this.currentPrivilegeLevel);
                            this.eflagsTrap = false;
                            this.eflagsNestedTask = false;
                            this.eflagsVirtual8086Mode = false;
                            this.eflagsResume = false;
                            break block8;
                        }
                        throw new ProcessorException(13, n16 + n4, true);
                    }
                    case 28: 
                    case 29: 
                    case 30: 
                    case 31: 
                }
                if (!segment4.isPresent()) {
                    throw new ProcessorException(11, n3, true);
                }
                if (bl ? this.ss.getDefaultSizeFlag() && this.esp < 16 && this.esp > 0 || !this.ss.getDefaultSizeFlag() && (this.esp & 0xFFFF) < 16 && (this.esp & 0xFFFF) > 0 : this.ss.getDefaultSizeFlag() && this.esp < 12 && this.esp > 0 || !this.ss.getDefaultSizeFlag() && (this.esp & 0xFFFF) < 12 && (this.esp & 0xFFFF) > 0) {
                    throw new ProcessorException(12, 0, true);
                }
                int n26 = trapGate32Bit.getTargetOffset();
                segment4.checkAddress(n26);
                if (this.ss.getDefaultSizeFlag()) {
                    this.esp -= 4;
                    this.ss.setDoubleWord(this.esp, this.getEFlags());
                    this.esp -= 4;
                    this.ss.setDoubleWord(this.esp, this.cs.getSelector());
                    this.esp -= 4;
                    this.ss.setDoubleWord(this.esp, this.eip);
                    if (bl) {
                        this.esp -= 4;
                        this.ss.setDoubleWord(this.esp, n2);
                    }
                } else {
                    this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                    this.ss.setDoubleWord(this.esp & 0xFFFF, this.getEFlags());
                    this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                    this.ss.setDoubleWord(this.esp & 0xFFFF, this.cs.getSelector());
                    this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                    this.ss.setDoubleWord(this.esp & 0xFFFF, this.eip);
                    if (bl) {
                        this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                        this.ss.setDoubleWord(this.esp & 0xFFFF, n2);
                    }
                }
                this.cs = segment4;
                this.eip = n26;
                this.cs.setRPL(this.currentPrivilegeLevel);
                this.eflagsTrap = false;
                this.eflagsNestedTask = false;
                this.eflagsVirtual8086Mode = false;
                this.eflagsResume = false;
            }
        }
    }

    private void checkAlignmentChecking() {
        if (this.getCPL() == 3 && this.eflagsAlignmentCheck && (this.cr0 & 0x40000) != 0) {
            if (!this.alignmentChecking) {
                System.err.println("Alignment Checking Enabled");
                this.alignmentChecking = true;
                this.updateAlignmentCheckingInDataSegments();
            }
        } else if (this.alignmentChecking) {
            System.err.println("Alignment Checking Disabled");
            this.alignmentChecking = false;
            this.updateAlignmentCheckingInDataSegments();
        }
    }

    public boolean initialised() {
        boolean bl;
        boolean bl2 = bl = this.physicalMemory != null && this.linearMemory != null && this.ioports != null && this.interruptController != null && this.virtualClock != null;
        if (bl) {
            this.reset();
        }
        return bl;
    }

    public void acceptComponent(HardwareComponent hardwareComponent) {
        if (hardwareComponent instanceof LinearAddressSpace) {
            this.linearMemory = (LinearAddressSpace)hardwareComponent;
            this.alignmentCheckedMemory = new AlignmentCheckedAddressSpace(this.linearMemory);
        }
        if (hardwareComponent instanceof PhysicalAddressSpace) {
            this.physicalMemory = (PhysicalAddressSpace)hardwareComponent;
        }
        if (hardwareComponent instanceof IOPortHandler) {
            this.ioports = (IOPortHandler)hardwareComponent;
        }
        if (hardwareComponent instanceof InterruptController && hardwareComponent.initialised()) {
            this.interruptController = (InterruptController)hardwareComponent;
        }
        if (hardwareComponent instanceof Clock) {
            this.virtualClock = (Clock)hardwareComponent;
        }
    }

    public void loadState(DataInputStream dataInputStream) throws IOException {
        String string = dataInputStream.readUTF();
        if (!dataInputStream.readUTF().equals(this.getClass().getName())) {
            throw new IOException("Invalid state data for processor");
        }
        if (dataInputStream.readInt() != 1) {
            throw new IOException("Processor state version mismatch");
        }
        if (dataInputStream.readInt() < 0) {
            throw new IOException("Processor state minor version mismatch");
        }
        this.eax = dataInputStream.readInt();
        this.ecx = dataInputStream.readInt();
        this.edx = dataInputStream.readInt();
        this.ebx = dataInputStream.readInt();
        this.esp = dataInputStream.readInt();
        this.ebp = dataInputStream.readInt();
        this.esi = dataInputStream.readInt();
        this.edi = dataInputStream.readInt();
        this.eip = dataInputStream.readInt();
        this.setCR0(dataInputStream.readInt());
        this.setCR2(dataInputStream.readInt());
        this.setCR3(dataInputStream.readInt());
        this.setCR4(dataInputStream.readInt());
        this.dr0 = dataInputStream.readInt();
        this.dr1 = dataInputStream.readInt();
        this.dr2 = dataInputStream.readInt();
        this.dr3 = dataInputStream.readInt();
        this.dr4 = dataInputStream.readInt();
        this.dr5 = dataInputStream.readInt();
        this.dr6 = dataInputStream.readInt();
        this.dr7 = dataInputStream.readInt();
    }

    public void saveState(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeUTF("JPC Processor");
        dataOutputStream.writeUTF(this.getClass().getName());
        dataOutputStream.writeInt(1);
        dataOutputStream.writeInt(0);
        dataOutputStream.writeInt(this.eax);
        dataOutputStream.writeInt(this.ecx);
        dataOutputStream.writeInt(this.edx);
        dataOutputStream.writeInt(this.ebx);
        dataOutputStream.writeInt(this.esp);
        dataOutputStream.writeInt(this.ebp);
        dataOutputStream.writeInt(this.esi);
        dataOutputStream.writeInt(this.edi);
        dataOutputStream.writeInt(this.eip);
        dataOutputStream.writeInt(this.cr0);
        dataOutputStream.writeInt(this.cr1);
        dataOutputStream.writeInt(this.cr2);
        dataOutputStream.writeInt(this.cr3);
        dataOutputStream.writeInt(this.cr4);
        dataOutputStream.writeInt(this.dr0);
        dataOutputStream.writeInt(this.dr1);
        dataOutputStream.writeInt(this.dr2);
        dataOutputStream.writeInt(this.dr3);
        dataOutputStream.writeInt(this.dr4);
        dataOutputStream.writeInt(this.dr5);
        dataOutputStream.writeInt(this.dr6);
        dataOutputStream.writeInt(this.dr7);
        dataOutputStream.writeInt(this.getEFlags());
        dataOutputStream.writeInt(this.interruptFlags);
        dataOutputStream.writeLong(this.resetTime);
        dataOutputStream.writeInt(this.currentPrivilegeLevel);
    }

    public boolean getAuxiliaryCarryFlag() {
        if (this.auxiliaryCarryCalculated) {
            return this.eflagsAuxiliaryCarry;
        }
        this.auxiliaryCarryCalculated = true;
        switch (this.auxiliaryCarryMethod) {
            case 1: {
                this.eflagsAuxiliaryCarry = ((this.auxiliaryCarryOne ^ this.auxiliaryCarryTwo ^ this.auxiliaryCarryThree) & 0x10) != 0;
                return this.eflagsAuxiliaryCarry;
            }
            case 2: {
                this.eflagsAuxiliaryCarry = (this.auxiliaryCarryOne & 8) != (this.auxiliaryCarryTwo & 8);
                return this.eflagsAuxiliaryCarry;
            }
            case 3: {
                this.eflagsAuxiliaryCarry = (this.auxiliaryCarryOne & 0xF) == 15;
                return this.eflagsAuxiliaryCarry;
            }
            case 4: {
                this.eflagsAuxiliaryCarry = (this.auxiliaryCarryOne & 0xF) == 0;
                return this.eflagsAuxiliaryCarry;
            }
            case 5: {
                this.eflagsAuxiliaryCarry = (this.auxiliaryCarryOne & 0xF) != 0;
                return this.eflagsAuxiliaryCarry;
            }
        }
        System.err.println("Missing AC Flag Calculation Method");
        return this.eflagsAuxiliaryCarry;
    }

    public void setAuxiliaryCarryFlag(int n, int n2, int n3, int n4) {
        this.auxiliaryCarryCalculated = false;
        this.auxiliaryCarryOne = n;
        this.auxiliaryCarryTwo = n2;
        this.auxiliaryCarryThree = n3;
        this.auxiliaryCarryMethod = n4;
    }

    public void setAuxiliaryCarryFlag(int n, int n2, int n3) {
        this.auxiliaryCarryCalculated = false;
        this.auxiliaryCarryOne = n;
        this.auxiliaryCarryTwo = n2;
        this.auxiliaryCarryMethod = n3;
    }

    public void setAuxiliaryCarryFlag(int n, int n2) {
        this.auxiliaryCarryCalculated = false;
        this.auxiliaryCarryOne = n;
        this.auxiliaryCarryMethod = n2;
    }

    public void setAuxiliaryCarryFlag(boolean bl) {
        this.auxiliaryCarryCalculated = true;
        this.eflagsAuxiliaryCarry = bl;
    }

    public boolean getParityFlag() {
        if (this.parityCalculated) {
            return this.eflagsParity;
        }
        this.parityCalculated = true;
        this.eflagsParity = parityMap[this.parityOne & 0xFF];
        return this.eflagsParity;
    }

    public void setParityFlag(boolean bl) {
        this.parityCalculated = true;
        this.eflagsParity = bl;
    }

    public void setParityFlag(int n) {
        this.parityCalculated = false;
        this.parityOne = n;
    }

    public boolean getOverflowFlag() {
        if (this.overflowCalculated) {
            return this.eflagsOverflow;
        }
        this.overflowCalculated = true;
        switch (this.overflowMethod) {
            case 1: {
                this.eflagsOverflow = this.overflowOne != 0;
                return this.eflagsOverflow;
            }
            case 2: {
                this.eflagsOverflow = this.overflowOne != (byte)this.overflowOne;
                return this.eflagsOverflow;
            }
            case 3: {
                this.eflagsOverflow = this.overflowOne != (short)this.overflowOne;
                return this.eflagsOverflow;
            }
            case 4: {
                this.eflagsOverflow = this.overflowLong != (long)((int)this.overflowLong);
                return this.eflagsOverflow;
            }
            case 5: {
                this.eflagsOverflow = (this.overflowOne & 0xFFFF) != 0;
                return this.eflagsOverflow;
            }
            case 6: {
                this.eflagsOverflow = (this.overflowOne & 0xFF00) != 0;
                return this.eflagsOverflow;
            }
            case 7: {
                this.eflagsOverflow = (this.overflowOne & 0x40) != 0 ^ this.getCarryFlag();
                return this.eflagsOverflow;
            }
            case 8: {
                this.eflagsOverflow = (this.overflowOne & 0x80) != 0 ^ this.getCarryFlag();
                return this.eflagsOverflow;
            }
            case 9: {
                this.eflagsOverflow = (this.overflowOne & 0x4000) != 0 ^ this.getCarryFlag();
                return this.eflagsOverflow;
            }
            case 10: {
                this.eflagsOverflow = (this.overflowOne & 0x8000) != 0 ^ this.getCarryFlag();
                return this.eflagsOverflow;
            }
            case 11: {
                this.eflagsOverflow = (this.overflowOne & 0x40000000) != 0 ^ this.getCarryFlag();
                return this.eflagsOverflow;
            }
            case 12: {
                this.eflagsOverflow = (this.overflowOne & Integer.MIN_VALUE) != 0 ^ this.getCarryFlag();
                return this.eflagsOverflow;
            }
            case 13: {
                this.eflagsOverflow = (this.overflowOne & 0x80) != 0 ^ (this.overflowOne & 0x40) != 0;
                return this.eflagsOverflow;
            }
            case 14: {
                this.eflagsOverflow = (this.overflowOne & 0x8000) != 0 ^ (this.overflowOne & 0x4000) != 0;
                return this.eflagsOverflow;
            }
            case 15: {
                this.eflagsOverflow = (this.overflowOne & Integer.MIN_VALUE) != 0 ^ (this.overflowOne & 0x40000000) != 0;
                return this.eflagsOverflow;
            }
            case 16: {
                this.eflagsOverflow = (this.overflowOne & 0x80) != (this.overflowTwo & 0x80);
                return this.eflagsOverflow;
            }
            case 17: {
                this.eflagsOverflow = (this.overflowOne & 0x8000) != (this.overflowTwo & 0x8000);
                return this.eflagsOverflow;
            }
            case 18: {
                this.eflagsOverflow = (this.overflowOne & Integer.MIN_VALUE) != (this.overflowTwo & Integer.MIN_VALUE);
                return this.eflagsOverflow;
            }
            case 19: {
                this.eflagsOverflow = this.overflowOne == 127;
                return this.eflagsOverflow;
            }
            case 20: {
                this.eflagsOverflow = this.overflowOne == Short.MAX_VALUE;
                return this.eflagsOverflow;
            }
            case 21: {
                this.eflagsOverflow = this.overflowOne == Integer.MAX_VALUE;
                return this.eflagsOverflow;
            }
            case 22: {
                this.eflagsOverflow = this.overflowOne == -128;
                return this.eflagsOverflow;
            }
            case 23: {
                this.eflagsOverflow = this.overflowOne == Short.MIN_VALUE;
                return this.eflagsOverflow;
            }
            case 24: {
                this.eflagsOverflow = this.overflowOne == Integer.MIN_VALUE;
                return this.eflagsOverflow;
            }
            case 25: {
                if ((byte)this.overflowThree > 0) {
                    this.eflagsOverflow = (byte)this.overflowOne < (byte)this.overflowTwo;
                    return this.eflagsOverflow;
                }
                this.eflagsOverflow = (byte)this.overflowOne > (byte)this.overflowTwo;
                return this.eflagsOverflow;
            }
            case 26: {
                if ((short)this.overflowThree > 0) {
                    this.eflagsOverflow = (short)this.overflowOne < (short)this.overflowTwo;
                    return this.eflagsOverflow;
                }
                this.eflagsOverflow = (short)this.overflowOne > (short)this.overflowTwo;
                return this.eflagsOverflow;
            }
            case 27: {
                if (this.overflowThree > 0) {
                    this.eflagsOverflow = this.overflowOne < this.overflowTwo;
                    return this.eflagsOverflow;
                }
                this.eflagsOverflow = this.overflowOne > this.overflowTwo;
                return this.eflagsOverflow;
            }
        }
        System.err.println("Missing OF Flag Calculation Method");
        return this.eflagsOverflow;
    }

    public void setOverflowFlag(boolean bl) {
        this.overflowCalculated = true;
        this.eflagsOverflow = bl;
    }

    public void setOverflowFlag(long l, int n) {
        this.overflowCalculated = false;
        this.overflowLong = l;
        this.overflowMethod = n;
    }

    public void setOverflowFlag(int n, int n2) {
        this.overflowCalculated = false;
        this.overflowOne = n;
        this.overflowMethod = n2;
    }

    public void setOverflowFlag(int n, int n2, int n3) {
        this.overflowCalculated = false;
        this.overflowOne = n;
        this.overflowTwo = n2;
        this.overflowMethod = n3;
    }

    public void setOverflowFlag(int n, int n2, int n3, int n4) {
        this.overflowCalculated = false;
        this.overflowOne = n;
        this.overflowTwo = n2;
        this.overflowThree = n3;
        this.overflowMethod = n4;
    }

    public boolean getCarryFlag() {
        if (this.carryCalculated) {
            return this.eflagsCarry;
        }
        this.carryCalculated = true;
        switch (this.carryMethod) {
            case 1: {
                this.eflagsCarry = this.carryOne != 0;
                return this.eflagsCarry;
            }
            case 2: {
                this.eflagsCarry = this.carryOne != (byte)this.carryOne;
                return this.eflagsCarry;
            }
            case 3: {
                this.eflagsCarry = this.carryOne != (short)this.carryOne;
                return this.eflagsCarry;
            }
            case 4: {
                this.eflagsCarry = this.carryLong != (long)((int)this.carryLong);
                return this.eflagsCarry;
            }
            case 5: {
                this.eflagsCarry = (this.carryOne & 0xFFFF) != 0;
                return this.eflagsCarry;
            }
            case 6: {
                this.eflagsCarry = (this.carryOne & 0xFF00) != 0;
                return this.eflagsCarry;
            }
            case 7: {
                this.eflagsCarry = (this.carryOne & 1 << this.carryTwo) != 0;
                return this.eflagsCarry;
            }
            case 8: {
                this.eflagsCarry = this.carryOne > 255;
                return this.eflagsCarry;
            }
            case 9: {
                this.eflagsCarry = (this.carryOne & 0xFFFFFF00) != 0;
                return this.eflagsCarry;
            }
            case 10: {
                this.eflagsCarry = (this.carryOne & 0xFFFF0000) != 0;
                return this.eflagsCarry;
            }
            case 11: {
                this.eflagsCarry = (this.carryLong & 0xFFFFFFFF00000000L) != 0L;
                return this.eflagsCarry;
            }
            case 12: {
                this.eflagsCarry = (this.carryOne << this.carryTwo - 1 & 0x80) != 0;
                return this.eflagsCarry;
            }
            case 13: {
                this.eflagsCarry = (this.carryOne << this.carryTwo - 1 & 0x8000) != 0;
                return this.eflagsCarry;
            }
            case 14: {
                this.eflagsCarry = (this.carryOne << this.carryTwo - 1 & Integer.MIN_VALUE) != 0;
                return this.eflagsCarry;
            }
            case 15: {
                this.eflagsCarry = (this.carryOne >>> this.carryTwo - 1 & 1) != 0;
                return this.eflagsCarry;
            }
            case 16: {
                this.eflagsCarry = (this.carryOne & 1) != 0;
                return this.eflagsCarry;
            }
            case 17: {
                this.eflagsCarry = (this.carryOne & 0x80) != 0;
                return this.eflagsCarry;
            }
            case 18: {
                this.eflagsCarry = (this.carryOne & 0x8000) != 0;
                return this.eflagsCarry;
            }
            case 19: {
                this.eflagsCarry = (this.carryOne & Integer.MIN_VALUE) != 0;
                return this.eflagsCarry;
            }
            case 20: {
                this.eflagsCarry = (this.carryOne & 0x100) != 0;
                return this.eflagsCarry;
            }
            case 21: {
                this.eflagsCarry = (this.carryOne & 0x10000) != 0;
                return this.eflagsCarry;
            }
            case 22: {
                this.eflagsCarry = (this.carryLong & 0x100000000L) != 0L;
                return this.eflagsCarry;
            }
        }
        System.err.println("Missing CY Flag Calculation Method");
        return this.eflagsCarry;
    }

    public void setCarryFlag(boolean bl) {
        this.carryCalculated = true;
        this.eflagsCarry = bl;
    }

    public void setCarryFlag(long l, int n) {
        this.carryCalculated = false;
        this.carryLong = l;
        this.carryMethod = n;
    }

    public void setCarryFlag(int n, int n2) {
        this.carryCalculated = false;
        this.carryOne = n;
        this.carryMethod = n2;
    }

    public void setCarryFlag(int n, int n2, int n3) {
        this.carryCalculated = false;
        this.carryOne = n;
        this.carryTwo = n2;
        this.carryMethod = n3;
    }

    public void setCarryFlag(int n, int n2, int n3, int n4) {
        this.carryCalculated = false;
        this.carryOne = n;
        this.carryTwo = n2;
        this.carryThree = n3;
        this.carryMethod = n4;
    }

    public boolean getZeroFlag() {
        if (this.zeroCalculated) {
            return this.eflagsZero;
        }
        this.zeroCalculated = true;
        this.eflagsZero = this.zeroOne == 0;
        return this.eflagsZero;
    }

    public void setZeroFlag(boolean bl) {
        this.zeroCalculated = true;
        this.eflagsZero = bl;
    }

    public void setZeroFlag(int n) {
        this.zeroCalculated = false;
        this.zeroOne = n;
    }

    public boolean getSignFlag() {
        if (this.signCalculated) {
            return this.eflagsSign;
        }
        this.signCalculated = true;
        this.eflagsSign = this.signOne < 0;
        return this.eflagsSign;
    }

    public void setSignFlag(boolean bl) {
        this.signCalculated = true;
        this.eflagsSign = bl;
    }

    public void setSignFlag(int n) {
        this.signCalculated = false;
        this.signOne = n;
    }

    static {
        for (int i = 0; i < 256; ++i) {
            boolean bl = true;
            for (int j = 0; j < 8; ++j) {
                if ((1 & i >> j) != 1) continue;
                bl = !bl;
            }
            Processor.parityMap[i] = bl;
        }
    }
}

