/*
 * Decompiled with CFR 0.152.
 */
package MyGame;

import MyGame.EnemyJeep;
import MyGame.Items;
import MyGame.Jeepney;
import MyGame.MainMidlet;
import MyGame.TrackLayerManager;
import MyGame.Vehicles;
import java.io.IOException;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.midlet.MIDlet;

public class GameMainCanvas
extends GameCanvas
implements CommandListener {
    public static final int upKey = 0;
    public static final int leftKey = 1;
    public static final int downKey = 2;
    public static final int rightKey = 3;
    public static final int fireKey = 4;
    private boolean moveRight = false;
    private boolean moveLeft = false;
    private boolean moveUp = false;
    private boolean moveDown = false;
    private boolean[] isDown = new boolean[]{false, false, false, false, false};
    private boolean go = false;
    private long[] keyTick = new long[]{0L, 0L, 0L, 0L, 0L};
    private int[] keyValue = new int[]{2, 4, 64, 32, 256};
    static int DISP_WIDTH;
    static int DISP_HEIGHT;
    static int xDivision;
    static int yDivision;
    static int FONT_HEIGHT;
    static int HEALTH_WIDTH;
    static int TIME_WIDTH;
    static int dispWidth;
    static int blackGap;
    static Font FONT;
    public static final int BLACK = 0;
    public static final int WHITE = 0xFFFFFF;
    public static final int RED = 0xFF0000;
    public static final int BLUE = 255;
    public static final int GREEN = 65280;
    public static final int GRAY = 0xCCCCCC;
    public static final int YELLOW = 0xFFFF99;
    private Display myDisplay;
    private MainMidlet myJeep;
    private TrackLayerManager myManager;
    private boolean myGameOver;
    private boolean myNewLevel;
    public boolean gamePaused = false;
    private int myInitialGameTicks;
    private int myOldGameTicks;
    private int myGameTicks = this.myOldGameTicks = (this.myInitialGameTicks = 0);
    private static String myInitialString;
    private String myTimeString = myInitialString;
    private Image dashboard;
    private Image arrow;
    private int driverImage = 0;
    private int jeepImage = 0;
    private int maxSpeed;
    private int keyDelay;
    private int Level = 1;
    private int engineUp;
    private int seatUp;
    private int bodyUp;
    private int totalFare;
    private int jeepHealth;
    private int gas;
    private int driverHealth;
    private int oldSoundCounter = 0;
    private boolean vibrateOn = true;

    void setGameOver() {
        this.myGameOver = true;
        this.myJeep.userPauseThreads();
    }

    void setNewLevel() {
        this.myNewLevel = true;
        this.myJeep.userPauseThreads();
    }

    public void setVibration(boolean vibrate) {
        this.vibrateOn = vibrate;
    }

    Vehicles[] getVehicles() {
        return this.myManager.getVehicles();
    }

    EnemyJeep[] getEnemyJeep() {
        return this.myManager.getEnemyJeep();
    }

    Items[] getItems() {
        return this.myManager.getItems();
    }

    public GameMainCanvas(MainMidlet midlet) {
        super(false);
        this.myDisplay = Display.getDisplay((MIDlet)midlet);
        DISP_WIDTH = this.getWidth();
        DISP_HEIGHT = this.getHeight();
        if (DISP_WIDTH >= 320) {
            dispWidth = 56;
            blackGap = 20;
        } else {
            dispWidth = 0;
            blackGap = 0;
        }
    }

    public GameMainCanvas(MainMidlet midlet, int dImage, int jImage, int speed, int accel, int level, int engine, int seat, int body, int fare, int jHealth, int myGas, int dHealth) {
        super(false);
        this.myDisplay = Display.getDisplay((MIDlet)midlet);
        this.myJeep = midlet;
        this.engineUp = engine;
        this.seatUp = seat;
        this.bodyUp = body;
        this.myGameOver = false;
        this.myNewLevel = false;
        this.driverImage = dImage;
        this.jeepImage = jImage;
        this.maxSpeed = speed + this.engineUp;
        this.keyDelay = accel;
        this.Level = level;
        this.totalFare = fare;
        this.jeepHealth = jHealth;
        this.gas = myGas;
        this.driverHealth = dHealth;
        DISP_WIDTH = this.getWidth();
        DISP_HEIGHT = this.getHeight();
        xDivision = DISP_WIDTH / 8;
        yDivision = DISP_HEIGHT / 9;
        try {
            this.dashboard = Image.createImage((String)"/images/dashboard.png");
            this.arrow = Image.createImage((String)"/images/arrow.png");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.myGameTicks = level == 3 ? 9600 : 0;
        FONT = Font.getFont((int)0, (int)2, (int)8);
        FONT_HEIGHT = FONT.getHeight();
        HEALTH_WIDTH = FONT.stringWidth("Health: 000%");
        TIME_WIDTH = FONT.stringWidth("Time: " + myInitialString);
        if (this.myManager == null) {
            try {
                this.myManager = new TrackLayerManager(0, 0, DISP_WIDTH, DISP_HEIGHT, this.maxSpeed, this.Level, this.seatUp, this.bodyUp, this.totalFare, this.jeepHealth, this.gas, this.driverHealth);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        for (int i = 0; i < 4; ++i) {
            this.keyValue[i] = 0;
        }
    }

    void start() {
        this.myGameOver = false;
        this.myNewLevel = false;
        this.myDisplay.setCurrent((Displayable)this);
        this.repaint();
    }

    void reset(int dImage, int jImage, int speed, int accel, int level, int engine, int seat, int body, int fare, int jHealth, int myGas, int dHealth) {
        this.driverImage = dImage;
        this.jeepImage = jImage;
        this.engineUp = engine;
        this.maxSpeed = speed + this.engineUp;
        this.keyDelay = accel;
        this.Level = level;
        this.seatUp = seat;
        this.bodyUp = body;
        this.totalFare = fare;
        this.jeepHealth = jHealth;
        this.gas = myGas;
        this.driverHealth = dHealth;
        this.myManager.reset(this.Level, this.maxSpeed, this.seatUp, this.bodyUp, this.totalFare, this.jeepHealth, this.gas, this.driverHealth);
        this.myGameOver = false;
        this.myNewLevel = false;
        this.gamePaused = false;
        this.myGameTicks = this.myInitialGameTicks;
        this.myOldGameTicks = this.myInitialGameTicks;
        this.moveRight = false;
        this.moveLeft = false;
        this.myGameTicks = level == 3 ? 11520 : 0;
        this.repaint();
    }

    void flushKeys() {
        this.getKeyStates();
    }

    protected void hideNotify() {
        try {
            if (!this.myGameOver && !this.myNewLevel) {
                this.myJeep.systemPauseThreads();
            }
        }
        catch (Exception oe) {
            this.myJeep.errorMsg(oe);
        }
    }

    protected void showNotify() {
        try {
            if (!this.myGameOver && !this.myNewLevel) {
                this.myJeep.setGoCommand();
            }
        }
        catch (Exception oe) {
            this.myJeep.errorMsg(oe);
        }
    }

    public void paint(Graphics g) {
        g.setColor(0);
        g.fillRect(0, 0, DISP_WIDTH, DISP_HEIGHT);
        try {
            this.myManager.paint(g);
        }
        catch (Exception e) {
            this.myJeep.errorMsg(e);
        }
        if (DISP_WIDTH >= 320) {
            g.setColor(0);
            g.fillRect(300, 0, DISP_WIDTH - 300, DISP_HEIGHT);
            if (this.myManager.Level > 1) {
                g.setColor(0xFFFFFF);
                g.drawRect(304, 60, 2, 60);
                g.drawRect(313, 60, 2, 60);
                g.setColor(65280);
                g.fillRect(302, 90, 7, 8);
                g.setColor(0xFF0000);
                g.fillRect(311, 90 + 30 * this.myManager.enemyPosition / 2800, 7, 8);
            }
        } else if (this.myManager.Level > 1) {
            g.setColor(0);
            g.drawRect(70, 60, 2, 60);
            g.drawRect(78, 60, 2, 60);
            g.setColor(65280);
            g.fillRect(68, 90, 6, 8);
            g.setColor(0xFF0000);
            g.fillRect(76, 90 + 30 * this.myManager.enemyPosition / 2800, 6, 8);
        }
        g.setColor(0);
        g.setFont(FONT);
        g.fillRoundRect(0, 0, 62, 182, 4, 4);
        g.drawRegion(this.dashboard, 0, 0, 64, 184, 0, 0, 0, 20);
        if (this.jeepImage == 0) {
            g.drawRegion(this.dashboard, 0, 200, 20, 20, 0, 6, 29, 20);
        } else if (this.jeepImage == 1) {
            g.drawRegion(this.dashboard, 20, 200, 20, 20, 0, 6, 29, 20);
        } else if (this.jeepImage == 2) {
            g.drawRegion(this.dashboard, 40, 200, 20, 20, 0, 6, 29, 20);
        }
        if (this.driverImage == 0) {
            g.drawRegion(this.dashboard, 0, 220, 20, 20, 0, 6, 5, 20);
        } else if (this.driverImage == 1) {
            g.drawRegion(this.dashboard, 20, 220, 20, 20, 0, 6, 5, 20);
        } else if (this.driverImage == 2) {
            g.drawRegion(this.dashboard, 40, 220, 20, 20, 0, 6, 5, 20);
        }
        if (this.myManager.turboCounter > 0) {
            g.drawRegion(this.dashboard, 0, 185, 15, 15, 0, 7, 165, 20);
        }
        if (this.myManager.musicCounter > 0) {
            g.drawRegion(this.dashboard, 15, 185, 15, 15, 0, 24, 165, 20);
        }
        if (this.myManager.scramblerCounter > 0) {
            g.drawRegion(this.dashboard, 30, 185, 15, 15, 0, 41, 165, 20);
        }
        if (Jeepney.itemX > 0) {
            g.setColor(0);
            g.drawString("$" + Jeepney.moneyBag, Jeepney.itemX - 31, DISP_HEIGHT - 54, 20);
        }
        if (this.myManager.Level == 1 && this.myGameTicks < 2880) {
            if ((this.myManager.jeepYPosition > 2172 && this.myManager.jeepYPosition < 2300 || this.myManager.jeepYPosition > 912 && this.myManager.jeepYPosition < 1040) && !this.myManager.loadingFlag && this.myManager.loadingDistance > 400) {
                g.drawImage(this.arrow, 154 + dispWidth, DISP_HEIGHT - 110, 20);
                g.drawString("Passengers!", 84 + dispWidth, DISP_HEIGHT - 120, 20);
            } else if (this.myManager.jeepYPosition > 1752 && this.myManager.jeepYPosition < 1880 && !this.myManager.gasFlag) {
                g.drawImage(this.arrow, 154 + dispWidth, DISP_HEIGHT - 110, 20);
                g.drawString("Gas Station!", 84 + dispWidth, DISP_HEIGHT - 120, 20);
            } else if (this.myManager.jeepYPosition > 1330 && this.myManager.jeepYPosition < 1458 && !this.myManager.driveThruFlag) {
                g.drawImage(this.arrow, 154 + dispWidth, DISP_HEIGHT - 110, 20);
                g.drawString("Food Station!", 84 + dispWidth, DISP_HEIGHT - 120, 20);
            } else if (this.myManager.jeepYPosition > 351 && this.myManager.jeepYPosition < 477 && !this.myManager.repairFlag) {
                g.drawImage(this.arrow, 154 + dispWidth, DISP_HEIGHT - 110, 20);
                g.drawString("Repair Station!", 84 + dispWidth, DISP_HEIGHT - 120, 20);
            }
        }
        g.setColor(0xFF0000);
        g.drawString(this.myManager.jeepHealth + "%", 26, 32, 20);
        g.drawString("" + this.myManager.gas, 26, 56, 20);
        g.drawString(this.myManager.driverHealth + "%", 26, 8, 20);
        g.setColor(65280);
        g.fillRect(5, 50, 54 * this.myManager.jeepHealth / 100, 3);
        g.fillRect(5, 72, 54 * this.myManager.gas / 100, 3);
        g.fillRect(5, 25, 54 * this.myManager.driverHealth / 100, 3);
        g.setColor(0xFF0000);
        g.drawString("       " + this.myManager.newSpeed, 0, 92, 20);
        if (!this.myManager.upDirection) {
            g.drawString("      -", 0, 94, 20);
        }
        if (this.myManager.upDirection) {
            if (this.myManager.newSpeed == 1) {
                g.drawLine(8, 96, 31, 102);
            } else if (this.myManager.newSpeed == 2) {
                g.drawLine(10, 90, 31, 102);
            } else if (this.myManager.newSpeed == 3) {
                g.drawLine(14, 85, 31, 102);
            } else if (this.myManager.newSpeed == 4) {
                g.drawLine(19, 81, 31, 102);
            } else if (this.myManager.newSpeed == 5) {
                g.drawLine(25, 79, 31, 102);
            } else if (this.myManager.newSpeed == 6) {
                g.drawLine(31, 78, 31, 102);
            } else if (this.myManager.newSpeed == 7) {
                g.drawLine(37, 79, 31, 102);
            } else if (this.myManager.newSpeed == 8) {
                g.drawLine(43, 81, 31, 102);
            } else if (this.myManager.newSpeed == 9) {
                g.drawLine(48, 85, 31, 102);
            } else if (this.myManager.newSpeed == 10) {
                g.drawLine(52, 90, 31, 102);
            } else if (this.myManager.newSpeed == 11) {
                g.drawLine(54, 96, 31, 102);
            } else if (this.myManager.newSpeed == 12) {
                g.drawLine(55, 102, 31, 102);
            } else {
                g.drawLine(7, 102, 31, 102);
            }
        } else {
            g.drawLine(7, 102, 31, 102);
        }
        g.setColor(0xFFFFFF);
        g.drawString("" + this.formatTime(), 58, 106, 24);
        g.drawString("" + this.myManager.totalFare, 58, 120, 24);
        g.drawString("" + this.myManager.passengers + "/" + this.myManager.maxPassengers, 58, 134, 24);
        g.drawString("" + this.myManager.trafficViolation, 58, 149, 24);
        g.setColor(0);
        if (this.myManager.loadingFlag) {
            g.drawString(this.myManager.unloadedPassengers + " Passengers unloaded", 63 + dispWidth, DISP_HEIGHT / 4, 20);
            g.drawString("$" + this.myManager.unloadedPassengers * 20 + " Fare Earned!", 63 + dispWidth, DISP_HEIGHT / 4 + (FONT_HEIGHT - 3), 20);
            g.drawString(this.myManager.loadedPassengers + " new Passenger boarded\u2026", 63 + dispWidth, DISP_HEIGHT / 4 + FONT_HEIGHT * 2 - 6, 20);
        }
        if (this.myManager.lowFuelFlag && this.myManager.flagCounter > 0) {
            g.drawString("Fuel is running low\u2026.", 62 + dispWidth, DISP_HEIGHT * 2 / 3, 20);
            g.drawString("Go to Gas station!", 62 + dispWidth, DISP_HEIGHT * 2 / 3 + FONT_HEIGHT - 3, 20);
        }
        if (this.myManager.trafficSpeedFlag && this.myManager.trafficFlagCounter > 0) {
            g.drawString("Overspeeding! = -$" + (this.myManager.trafficViolation + 1) * 40, 62 + dispWidth, 2, 20);
            g.drawString("Speed at intersection", 62 + dispWidth, 2 + FONT_HEIGHT - 3, 20);
            g.drawString("should be 6 or less...", 62 + dispWidth, 2 + (FONT_HEIGHT * 2 - 6), 20);
        }
        if (this.myManager.gasFlag) {
            if (this.myManager.zeroEarnings) {
                g.drawString("Not enough money", 62 + dispWidth, DISP_HEIGHT / 4, 20);
                g.drawString("to buy Gas...", 62 + dispWidth, DISP_HEIGHT / 4 + FONT_HEIGHT - 3, 20);
            } else {
                g.drawString("Refuelling....  " + this.myManager.liters + " liters!", 62 + dispWidth, DISP_HEIGHT / 4, 20);
                g.drawString("Costing you... $" + this.myManager.liters + " Dollars!", 62 + dispWidth, DISP_HEIGHT / 4 + FONT_HEIGHT - 3, 20);
            }
        }
        if (this.myManager.JeepLowHealthFlag && this.myManager.flagCounter > 0) {
            g.drawString("Jeepney is heavily damaged\u2026.", 50 + dispWidth, DISP_HEIGHT - FONT_HEIGHT * 2 + 3, 20);
            g.drawString("Go to Repair station!", 50 + dispWidth, DISP_HEIGHT - FONT_HEIGHT, 20);
        }
        if (this.myManager.DriverLowHealthFlag && this.myManager.flagCounter > 0 && !this.myManager.trafficSpeedFlag && !this.myManager.driveThruFlag && !this.myManager.loadingFlag) {
            g.drawString("Driver is tired & hungry....\u2026.", 62 + dispWidth, 12 + FONT_HEIGHT, 20);
            g.drawString("Drive-thru for food!", 62 + dispWidth, 12 + FONT_HEIGHT * 2 - 3, 20);
        }
        if (this.myManager.repairFlag) {
            if (this.myManager.jeepHealth > 99) {
                g.drawString("Jeepney Health is full", 62 + dispWidth, DISP_HEIGHT / 3 + FONT_HEIGHT - 3, 20);
            } else if (this.myManager.zeroEarnings) {
                g.drawString("Not enough money to", 62 + dispWidth, DISP_HEIGHT / 3, 20);
                g.drawString("continue repair...", 62 + dispWidth, DISP_HEIGHT / 3 + FONT_HEIGHT - 3, 20);
            } else {
                g.drawString("Repairing Jeepney... ", 62 + dispWidth, DISP_HEIGHT / 3, 20);
                g.drawString("Cost = $" + this.myManager.healthAdded * 4 + " Dollars!", 62 + dispWidth, DISP_HEIGHT / 3 + FONT_HEIGHT - 3, 20);
            }
        }
        if (this.myManager.driveThruFlag) {
            if (this.myManager.zeroEarnings) {
                g.drawString("Not enough money", 62 + dispWidth, DISP_HEIGHT / 4, 20);
                g.drawString("to buy Food...", 62 + dispWidth, DISP_HEIGHT / 4 + FONT_HEIGHT - 3, 20);
            } else {
                g.drawString(this.myManager.healthAdded + " Driver Health gained.", 63 + dispWidth, DISP_HEIGHT / 4, 20);
                g.drawString("Costing.. $" + this.myManager.healthAdded + " Dollars!", 63 + dispWidth, DISP_HEIGHT / 4 + FONT_HEIGHT - 3, 20);
            }
        }
        if (this.myGameOver) {
            this.myJeep.setNewCommand();
            String message = "";
            g.setColor(0xFFFFFF);
            g.fillRect(64, FONT_HEIGHT - 4, DISP_WIDTH - (64 + blackGap), FONT_HEIGHT * 2 + 5);
            int goWidth = FONT.stringWidth("Your Jeepney is DEAD!");
            g.setColor(0);
            g.setFont(FONT);
            if (this.myManager.jeepHealth < 1) {
                message = "Your Jeepney is DEAD!";
            } else if (this.myManager.gas < 1) {
                message = "You run out of GAS!";
            } else if (this.myManager.driverHealth < 1) {
                message = "Your Driver QUIT!";
            } else if (this.myGameTicks > 57600 || this.myGameTicks < 1 && this.Level == 3) {
                message = "You run out of TIME!";
            }
            g.drawString("       Game Over!", (DISP_WIDTH - goWidth + (64 - blackGap)) / 2, FONT_HEIGHT, 20);
            g.drawString(message, (DISP_WIDTH - goWidth + (64 - blackGap)) / 2, FONT_HEIGHT * 2, 20);
        }
        if (this.myNewLevel) {
            this.myJeep.setLevelUpCommand();
            g.setColor(0xFFFFFF);
            g.fillRect(64, FONT_HEIGHT - 4, DISP_WIDTH - (64 + blackGap), FONT_HEIGHT * 2 + 5);
            int goWidth = FONT.stringWidth("Option - Save/Continue");
            g.setColor(0);
            g.setFont(FONT);
            if (this.Level > 2) {
                g.drawString("Level-" + this.myManager.Level + " Completed", (DISP_WIDTH - goWidth + (64 - blackGap)) / 2, FONT_HEIGHT, 20);
                g.drawString("Save to upload Score.", (DISP_WIDTH - goWidth + (64 - blackGap)) / 2, FONT_HEIGHT * 2, 20);
            } else {
                g.drawString("Level-" + this.myManager.Level + " Completed", (DISP_WIDTH - goWidth + (64 - blackGap)) / 2, FONT_HEIGHT, 20);
                g.drawString("Option - Save/Continue", (DISP_WIDTH - goWidth + (64 - blackGap)) / 2, FONT_HEIGHT * 2, 20);
            }
        }
        if (this.gamePaused && !this.myNewLevel && !this.myGameOver) {
            g.setColor(0xFFFFFF);
            g.fillRect(64, FONT_HEIGHT - 4, DISP_WIDTH - (64 + blackGap), FONT_HEIGHT + 5);
            int goWidth = FONT.stringWidth("Game is PAUSED");
            g.setColor(0);
            g.drawString("Game is PAUSED", (DISP_WIDTH - goWidth + (64 - blackGap)) / 2, FONT_HEIGHT, 20);
        }
    }

    public String formatTime() {
        if (this.myGameTicks / 16 + 1 != this.myOldGameTicks) {
            this.myTimeString = "";
            this.myOldGameTicks = this.myGameTicks / 16 + 1;
            int smallPart = this.myOldGameTicks % 60;
            int bigPart = this.myOldGameTicks / 60;
            this.myTimeString = this.myTimeString + bigPart + ":";
            if (smallPart / 10 < 1) {
                this.myTimeString = this.myTimeString + "0";
            }
            this.myTimeString = this.myTimeString + smallPart;
        }
        return this.myTimeString;
    }

    void advance() {
        this.myGameTicks = this.Level == 3 ? --this.myGameTicks : ++this.myGameTicks;
        this.myManager.advance(this.myGameTicks);
        if (this.myManager.jeepHealth < 1 || this.myManager.gas < 1 || this.myManager.driverHealth < 1 || this.myGameTicks > 57600 || this.myGameTicks < 1 && this.Level == 3) {
            this.setGameOver();
        }
        if (this.myManager.totalFare > 1999 && this.Level == 1 || this.myManager.totalFare > 4999 && this.Level == 2 || this.myManager.totalFare > 7999 && this.Level == 3) {
            this.myJeep.getData(this.myManager.Level, this.driverImage, this.jeepImage, this.engineUp, this.seatUp, this.bodyUp, this.myManager.totalFare, this.myGameTicks, this.myManager.jeepHealth, this.myManager.gas, this.myManager.driverHealth);
            this.setNewLevel();
        }
        try {
            this.paint(this.getGraphics());
            this.flushGraphics();
        }
        catch (Exception e) {
            this.myJeep.errorMsg(e);
        }
        if (this.oldSoundCounter != this.myManager.soundCounter) {
            this.oldSoundCounter = this.myManager.soundCounter;
            int soundNumber = this.myManager.soundNumber;
            if (soundNumber == 9 && this.vibrateOn) {
                Display.getDisplay((MIDlet)this.myJeep).vibrate(500);
            } else if (soundNumber != 9) {
                this.myJeep.PlaySound(soundNumber);
            }
        }
    }

    private void checkKey(int iKey, long currTick) {
        long elapsedTick = 0L;
        this.go = false;
        if (iKey == 0) {
            for (int i = 0; i < 5; ++i) {
                this.isDown[i] = false;
                if (this.keyValue[i] == 0 || (elapsedTick = currTick - this.keyTick[i]) < (long)this.keyDelay) continue;
                this.keyTick[i] = currTick;
                this.isDown[i] = true;
            }
        } else {
            elapsedTick = currTick - this.keyTick[0];
            if (elapsedTick >= (long)this.keyDelay) {
                this.keyTick[0] = currTick;
                this.go = true;
            }
        }
    }

    protected void pointerPressed(int x, int y) {
        if (x < xDivision * 3) {
            if (y > yDivision * 3 && y < yDivision * 6) {
                this.moveRight = false;
                this.moveUp = false;
                this.moveDown = false;
                this.moveLeft = true;
                this.keyValue[1] = 1;
            } else if (y < yDivision * 2) {
                this.moveRight = false;
                this.moveUp = true;
                this.moveDown = false;
                this.moveLeft = false;
                this.keyValue[0] = 1;
            } else if (y > yDivision * 7) {
                this.moveRight = false;
                this.moveUp = false;
                this.moveDown = true;
                this.moveLeft = false;
                this.keyValue[2] = 1;
            }
        } else if (x > xDivision * 5) {
            if (y > yDivision * 3 && y < yDivision * 6) {
                this.moveLeft = false;
                this.moveUp = false;
                this.moveDown = false;
                this.moveRight = true;
                this.keyValue[3] = 1;
            } else if (y < yDivision * 2) {
                this.moveRight = false;
                this.moveUp = true;
                this.moveDown = false;
                this.moveLeft = false;
                this.keyValue[0] = 1;
            } else if (y > yDivision * 7) {
                this.moveRight = false;
                this.moveUp = false;
                this.moveDown = true;
                this.moveLeft = false;
                this.keyValue[2] = 1;
            }
        }
    }

    protected void pointerDragged(int x, int y) {
    }

    protected void pointerReleased(int x, int y) {
        this.moveRight = false;
        this.moveLeft = false;
        this.moveUp = false;
        this.moveDown = false;
        for (int i = 0; i < 4; ++i) {
            this.keyValue[i] = 0;
        }
    }

    public void checkKeys() {
        int iKey = 0;
        long lCurrTick = 0L;
        if (!this.myGameOver && !this.myNewLevel) {
            lCurrTick = System.currentTimeMillis();
            iKey = this.getKeyStates();
            this.checkKey(iKey, lCurrTick);
            if (this.isDown[2] || (iKey & 0x40) != 0 && this.go) {
                if (!this.myManager.upDirection) {
                    if (this.myManager.newSpeed == 5) {
                        this.myManager.goingUp(false, 0, 2);
                    } else if (this.myManager.newSpeed == 0) {
                        this.myManager.goingUp(false, 3, 2);
                    } else if (this.myManager.newSpeed == 3) {
                        this.myManager.goingUp(false, 2, 2);
                    } else {
                        this.myManager.goingUp(false, 1, 2);
                    }
                } else if (this.myManager.newSpeed > 0) {
                    if (this.myManager.newSpeed > 6) {
                        this.myManager.goingUp(true, -(this.myManager.newSpeed - 6), 2);
                    } else {
                        this.myManager.goingUp(true, -2, 2);
                    }
                } else {
                    this.myManager.goingUp(false, 3, 2);
                }
            }
            if (this.isDown[0] || (iKey & 2) != 0 && this.go) {
                if (!this.myManager.upDirection) {
                    if (this.myManager.newSpeed > 0) {
                        this.myManager.goingUp(false, -1, 1);
                    } else {
                        this.myManager.goingUp(true, 1, 1);
                    }
                } else if (this.myManager.newSpeed < this.myManager.maxSpeed) {
                    this.myManager.goingUp(true, 1, 1);
                } else {
                    this.myManager.goingUp(true, 0, 1);
                }
            }
            if ((iKey & 0x20) != 0 || this.moveRight) {
                this.myManager.goingRight(true, 4);
            }
            if ((iKey & 4) != 0 || this.moveLeft) {
                this.myManager.goingRight(false, 3);
            }
        }
    }

    public void commandAction(Command arg0, Displayable arg1) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    static {
        myInitialString = "0:00";
    }
}

