/*
 * Decompiled with CFR 0.152.
 */
package MyGame;

import MyGame.GameMainCanvas;
import MyGame.MainMidlet;

public class GameThread
extends Thread {
    private boolean myShouldPause;
    private boolean myShouldStop;
    GameMainCanvas myJeepCanvas;
    MainMidlet myMidlet;
    private long myLastRefreshTime;

    GameThread(GameMainCanvas canvas, MainMidlet midlet) {
        this.myJeepCanvas = canvas;
        this.myMidlet = midlet;
    }

    private long getWaitTime() {
        long retVal = 1L;
        long difference = System.currentTimeMillis() - this.myLastRefreshTime;
        if (difference < 33L) {
            retVal = 33L - difference;
        }
        return retVal;
    }

    void pauseGame() {
        this.myShouldPause = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resumeGame() {
        this.myShouldPause = false;
        GameThread gameThread = this;
        synchronized (gameThread) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void requestStop() {
        this.myShouldStop = true;
        GameThread gameThread = this;
        synchronized (gameThread) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.myJeepCanvas.flushKeys();
        this.myShouldStop = false;
        this.myShouldPause = false;
        try {
            this.myJeepCanvas.start();
        }
        catch (Exception e) {
            this.myMidlet.errorMsg(e);
        }
        while (true) {
            GameThread gameThread;
            this.myLastRefreshTime = System.currentTimeMillis();
            if (this.myShouldStop) break;
            while (this.myShouldPause) {
                gameThread = this;
                synchronized (gameThread) {
                    try {
                        this.wait();
                    }
                    catch (Exception e) {
                        this.myMidlet.errorMsg(e);
                    }
                }
            }
            this.myJeepCanvas.checkKeys();
            this.myJeepCanvas.advance();
            gameThread = this;
            synchronized (gameThread) {
                try {
                    this.wait(1L);
                    this.wait(this.getWaitTime());
                }
                catch (Exception e) {
                    this.myMidlet.errorMsg(e);
                }
            }
        }
    }
}

