/*
 * Decompiled with CFR 0.152.
 */
package MyGame;

import javax.microedition.rms.RecordStore;
import util.DataConverter;

public class ScoreInfo {
    boolean myNoDataSaved;
    private String userName;
    private String location;
    private String levelStore;
    private int myLevel;
    private int ticks;
    private int numberOfRecords;
    private int lastLowestScore;
    private int[] numberOfScoresRecord = new int[]{0, 0, 0};

    boolean getIsEmpty() {
        return this.myNoDataSaved;
    }

    int getLevel() {
        return this.myLevel;
    }

    int getNumberOfScoresRecord(int number) {
        return this.numberOfScoresRecord[number];
    }

    int getTicks() {
        return this.ticks;
    }

    String getName() {
        return this.userName;
    }

    String getLocation() {
        return this.location;
    }

    int getNumberOfRecord() {
        return this.numberOfRecords;
    }

    ScoreInfo(int level, String name, String locn, int tick) throws Exception {
        this.myLevel = level - 1;
        this.ticks = tick;
        this.userName = name;
        this.location = locn;
        this.saveInfo();
    }

    ScoreInfo() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadInfo(int level, int recordNumber) {
        RecordStore saveStore = null;
        this.myLevel = level;
        if (this.myLevel == 1) {
            this.levelStore = "L1";
        } else if (this.myLevel == 2) {
            this.levelStore = "L2";
        } else if (this.myLevel == 3) {
            this.levelStore = "L3";
        }
        try {
            saveStore = RecordStore.openRecordStore((String)this.levelStore, (boolean)true);
            this.numberOfScoresRecord[level - 1] = saveStore.getNumRecords();
            if (saveStore != null && saveStore.getNumRecords() > 0) {
                byte[] data = saveStore.getRecord(recordNumber);
                this.myLevel = data[0];
                byte[] fourBytesTicks = new byte[4];
                System.arraycopy(data, 1, fourBytesTicks, 0, 4);
                this.ticks = DataConverter.parseInt(fourBytesTicks);
                byte nameLength = data[5];
                byte[] byteNameData = new byte[nameLength];
                System.arraycopy(data, 6, byteNameData, 0, nameLength);
                this.userName = new String(byteNameData);
                byte[] byteLocnData = new byte[data.length - 6 - nameLength];
                System.arraycopy(data, 6 + nameLength, byteLocnData, 0, data.length - 6 - nameLength);
                this.location = new String(byteLocnData);
            } else {
                this.myNoDataSaved = true;
            }
        }
        catch (Exception e) {
            this.myNoDataSaved = true;
        }
        finally {
            try {
                if (saveStore != null) {
                    this.numberOfScoresRecord[level - 1] = saveStore.getNumRecords();
                    saveStore.closeRecordStore();
                }
            }
            catch (Exception e) {}
        }
    }

    int saveInfo() throws Exception {
        RecordStore saveStore = null;
        if (this.myLevel == 1) {
            this.levelStore = "L1";
        } else if (this.myLevel == 2) {
            this.levelStore = "L2";
        } else if (this.myLevel == 3) {
            this.levelStore = "L3";
        }
        try {
            byte[] byteNameData = this.userName.getBytes();
            byte[] byteLocationData = this.location.getBytes();
            byte[] data = new byte[6 + byteLocationData.length + byteNameData.length];
            data[0] = new Integer(this.myLevel).byteValue();
            byte[] tickBytes = DataConverter.intToFourBytes(this.ticks);
            System.arraycopy(tickBytes, 0, data, 1, 4);
            int nameLength = byteNameData.length;
            data[5] = new Integer(nameLength).byteValue();
            System.arraycopy(byteNameData, 0, data, 6, byteNameData.length);
            System.arraycopy(byteLocationData, 0, data, 6 + byteNameData.length, byteLocationData.length);
            saveStore = RecordStore.openRecordStore((String)this.levelStore, (boolean)true);
            if (saveStore.getNumRecords() < 10) {
                saveStore.addRecord(data, 0, data.length);
                if (saveStore.getNumRecords() > 1) {
                    for (int i = saveStore.getNumRecords(); i > 1; --i) {
                        byte[] recordBelow = saveStore.getRecord(i);
                        byte[] fourBytesTicksBelow = new byte[4];
                        System.arraycopy(recordBelow, 1, fourBytesTicksBelow, 0, 4);
                        int tickBelow = DataConverter.parseInt(fourBytesTicksBelow);
                        int recordBelowLenght = recordBelow.length;
                        byte[] recordAbove = saveStore.getRecord(i - 1);
                        byte[] fourBytesTicksAbove = new byte[4];
                        System.arraycopy(recordAbove, 1, fourBytesTicksAbove, 0, 4);
                        int tickAbove = DataConverter.parseInt(fourBytesTicksAbove);
                        int recordAboveLenght = recordAbove.length;
                        if (tickBelow >= tickAbove) continue;
                        saveStore.setRecord(i, recordAbove, 0, recordAboveLenght);
                        saveStore.setRecord(i - 1, recordBelow, 0, recordBelowLenght);
                    }
                }
            } else if (saveStore.getNumRecords() == 10) {
                byte[] lowestData = saveStore.getRecord(saveStore.getNumRecords());
                byte[] bytesTicks = new byte[4];
                System.arraycopy(lowestData, 1, bytesTicks, 0, 4);
                this.lastLowestScore = DataConverter.parseInt(bytesTicks);
                if (this.lastLowestScore > this.ticks) {
                    saveStore.setRecord(saveStore.getNumRecords(), data, 0, data.length);
                    for (int i = saveStore.getNumRecords(); i > 1; --i) {
                        byte[] recordBelow = saveStore.getRecord(i);
                        byte[] fourBytesTicksBelow = new byte[4];
                        System.arraycopy(recordBelow, 1, fourBytesTicksBelow, 0, 4);
                        int tickBelow = DataConverter.parseInt(fourBytesTicksBelow);
                        int recordBelowLenght = recordBelow.length;
                        byte[] recordAbove = saveStore.getRecord(i - 1);
                        byte[] fourBytesTicksAbove = new byte[4];
                        System.arraycopy(recordAbove, 1, fourBytesTicksAbove, 0, 4);
                        int tickAbove = DataConverter.parseInt(fourBytesTicksAbove);
                        int recordAboveLenght = recordAbove.length;
                        if (tickBelow >= tickAbove) continue;
                        saveStore.setRecord(i, recordAbove, 0, recordAboveLenght);
                        saveStore.setRecord(i - 1, recordBelow, 0, recordBelowLenght);
                    }
                }
            }
            this.numberOfScoresRecord[this.myLevel - 1] = saveStore.getNumRecords();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                if (saveStore != null) {
                    saveStore.closeRecordStore();
                }
            }
            catch (Exception e) {}
        }
        return 0;
    }
}

