/*
 * Decompiled with CFR 0.152.
 */
package MyGame;

import javax.microedition.rms.RecordStore;

public class Settings {
    private String levelStore = "settings";
    private int musicLevel;
    private int soundLevel;
    private int vibration;
    private int numberOfRecords = 0;

    int getMusicLevel() {
        return this.musicLevel;
    }

    int getSoundLevel() {
        return this.soundLevel;
    }

    int getVibration() {
        return this.vibration;
    }

    int getNumberOfRecord() {
        return this.numberOfRecords;
    }

    Settings(int music, int sound, int vibrate) throws Exception {
        this.musicLevel = music;
        this.soundLevel = sound;
        this.vibration = vibrate;
        this.saveSettings();
    }

    Settings() {
        this.loadSettings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadSettings() {
        RecordStore saveStore = null;
        try {
            saveStore = RecordStore.openRecordStore((String)this.levelStore, (boolean)true);
            this.numberOfRecords = saveStore.getNumRecords();
            if (saveStore != null && saveStore.getNumRecords() > 0) {
                byte[] data = saveStore.getRecord(1);
                this.musicLevel = data[0];
                this.soundLevel = data[1];
                this.vibration = data[2];
            }
        }
        catch (Exception e) {
        }
        finally {
            try {
                if (saveStore != null) {
                    saveStore.closeRecordStore();
                }
            }
            catch (Exception e) {}
        }
    }

    void saveSettings() throws Exception {
        RecordStore saveStore = null;
        try {
            byte[] data = new byte[]{new Integer(this.musicLevel).byteValue(), new Integer(this.soundLevel).byteValue(), new Integer(this.vibration).byteValue()};
            saveStore = RecordStore.openRecordStore((String)this.levelStore, (boolean)true);
            if (saveStore.getNumRecords() < 1) {
                saveStore.addRecord(data, 0, data.length);
            } else if (saveStore.getNumRecords() == 1) {
                saveStore.setRecord(1, data, 0, 3);
            }
            this.numberOfRecords = saveStore.getNumRecords();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                if (saveStore != null) {
                    saveStore.closeRecordStore();
                }
            }
            catch (Exception e) {}
        }
    }
}

