/*
 * Decompiled with CFR 0.152.
 */
package MyGame;

import MyGame.EnemyJeep;
import MyGame.GameMainCanvas;
import java.util.Random;

public class EnemyJeepThread
extends Thread {
    private boolean myShouldPause;
    private boolean myShouldStop;
    private EnemyJeep[] myEnemyJeep;
    private Random myRandom = new Random();

    EnemyJeepThread(GameMainCanvas canvas) throws Exception {
        this.myEnemyJeep = canvas.getEnemyJeep();
    }

    void pauseGame() {
        this.myShouldPause = true;
    }

    synchronized void resumeGame() {
        this.myShouldPause = false;
        this.notify();
    }

    synchronized void requestStop() {
        this.myShouldStop = true;
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.myShouldStop = false;
        this.myShouldPause = false;
        while (!this.myShouldStop) {
            EnemyJeepThread enemyJeepThread = this;
            synchronized (enemyJeepThread) {
                while (this.myShouldPause) {
                    try {
                        this.wait();
                    }
                    catch (Exception e) {}
                }
            }
            int waitTime = (10 + this.getRandomInt(10)) * 100;
            EnemyJeepThread e = this;
            synchronized (e) {
                try {
                    this.wait(waitTime);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.myShouldPause) continue;
            int whichEnemyJeep = this.getRandomInt(this.myEnemyJeep.length);
            this.myEnemyJeep[whichEnemyJeep].go();
        }
    }

    public int getRandomInt(int upper) {
        int retVal = this.myRandom.nextInt() % upper;
        if (retVal < 0) {
            retVal += upper;
        }
        return retVal;
    }
}

