/*
 * Decompiled with CFR 0.152.
 */
package MyGame;

import java.io.IOException;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.VolumeControl;

public class MusicMaker
implements PlayerListener {
    private Player music1;
    private Player food;
    private Player traffic;
    private Player loading;
    private Player repair;
    private Player gas;
    private boolean myShouldPause = false;
    private static boolean myGamePause = false;
    private int musicVolume = 60;
    private int soundVolume = 60;

    public MusicMaker(int music, int sound) throws IOException, MediaException {
        this.musicVolume = music;
        this.soundVolume = sound;
        InputStream a = this.getClass().getResourceAsStream("/resources/move.amr");
        this.music1 = Manager.createPlayer((InputStream)a, (String)"audio/amr");
        this.music1.realize();
        this.music1.addPlayerListener((PlayerListener)this);
        VolumeControl a1 = (VolumeControl)this.music1.getControl("VolumeControl");
        a1.setLevel(this.musicVolume);
        this.music1.prefetch();
        InputStream b = this.getClass().getResourceAsStream("/resources/food.amr");
        this.food = Manager.createPlayer((InputStream)b, (String)"audio/amr");
        this.food.realize();
        this.food.addPlayerListener((PlayerListener)this);
        VolumeControl b1 = (VolumeControl)this.food.getControl("VolumeControl");
        b1.setLevel(this.soundVolume);
        this.food.prefetch();
        InputStream c = this.getClass().getResourceAsStream("/resources/siren.amr");
        this.traffic = Manager.createPlayer((InputStream)c, (String)"audio/amr");
        this.traffic.realize();
        this.traffic.addPlayerListener((PlayerListener)this);
        VolumeControl c1 = (VolumeControl)this.traffic.getControl("VolumeControl");
        c1.setLevel(this.soundVolume);
        this.traffic.prefetch();
        InputStream d = this.getClass().getResourceAsStream("/resources/loading.amr");
        this.loading = Manager.createPlayer((InputStream)d, (String)"audio/amr");
        this.loading.realize();
        this.loading.addPlayerListener((PlayerListener)this);
        VolumeControl d1 = (VolumeControl)this.loading.getControl("VolumeControl");
        d1.setLevel(this.soundVolume);
        this.loading.prefetch();
        InputStream e = this.getClass().getResourceAsStream("/resources/repair.amr");
        this.repair = Manager.createPlayer((InputStream)e, (String)"audio/amr");
        this.repair.realize();
        this.repair.addPlayerListener((PlayerListener)this);
        VolumeControl e1 = (VolumeControl)this.repair.getControl("VolumeControl");
        e1.setLevel(this.soundVolume);
        this.repair.prefetch();
        InputStream f = this.getClass().getResourceAsStream("/resources/gas.amr");
        this.gas = Manager.createPlayer((InputStream)f, (String)"audio/amr");
        this.gas.realize();
        this.gas.addPlayerListener((PlayerListener)this);
        VolumeControl f1 = (VolumeControl)this.gas.getControl("VolumeControl");
        f1.setLevel(this.soundVolume);
        this.gas.prefetch();
    }

    public void pauseGame() {
        try {
            myGamePause = true;
            this.music1.stop();
            this.food.stop();
            this.traffic.stop();
            this.gas.stop();
            this.loading.stop();
            this.repair.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void resumeGame() {
        try {
            myGamePause = false;
            if (!this.myShouldPause) {
                this.music1.start();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    synchronized void toggle() {
        try {
            boolean bl = this.myShouldPause = !this.myShouldPause;
            if (this.myShouldPause) {
                if (this.music1 != null) {
                    this.music1.stop();
                }
            } else if (!myGamePause) {
                if (this.music1 == null) {
                    this.start(0);
                }
                this.music1.start();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void musicVolume(int vol) {
        VolumeControl vc = (VolumeControl)this.music1.getControl("VolumeControl");
        vc.setLevel(vol);
        this.musicVolume = vol;
    }

    void soundVolume(int vol) {
        VolumeControl c1 = (VolumeControl)this.traffic.getControl("VolumeControl");
        c1.setLevel(vol);
        VolumeControl d1 = (VolumeControl)this.loading.getControl("VolumeControl");
        d1.setLevel(vol);
        VolumeControl e1 = (VolumeControl)this.repair.getControl("VolumeControl");
        e1.setLevel(vol);
        VolumeControl f1 = (VolumeControl)this.gas.getControl("VolumeControl");
        f1.setLevel(vol);
        VolumeControl vc1 = (VolumeControl)this.food.getControl("VolumeControl");
        vc1.setLevel(vol);
    }

    synchronized void requestStop() {
        try {
            this.music1.stop();
            this.music1.close();
            this.music1 = null;
            this.food.stop();
            this.food.close();
            this.food = null;
            this.traffic.stop();
            this.traffic.close();
            this.traffic = null;
            this.gas.stop();
            this.gas.close();
            this.gas = null;
            this.loading.stop();
            this.loading.close();
            this.loading = null;
            this.repair.stop();
            this.repair.close();
            this.repair = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void start(int sound) {
        if (!this.myShouldPause && !myGamePause) {
            try {
                this.music1.stop();
            }
            catch (MediaException ex) {
                ex.printStackTrace();
            }
            if (sound == 0) {
                try {
                    this.music1.start();
                }
                catch (MediaException ex) {
                    ex.printStackTrace();
                }
            } else if (sound == 2) {
                try {
                    this.traffic.start();
                }
                catch (MediaException ex) {
                    ex.printStackTrace();
                }
            } else if (sound == 3) {
                try {
                    this.loading.start();
                }
                catch (MediaException ex) {
                    ex.printStackTrace();
                }
            } else if (sound == 4) {
                try {
                    this.repair.start();
                }
                catch (MediaException ex) {
                    ex.printStackTrace();
                }
            } else if (sound == 5) {
                try {
                    this.gas.start();
                }
                catch (MediaException ex) {
                    ex.printStackTrace();
                }
            } else if (sound == 6) {
                try {
                    this.food.start();
                }
                catch (MediaException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public void playerUpdate(Player player, String event, Object eventData) {
        if (event.equals("endOfMedia") && !this.myShouldPause && !myGamePause) {
            try {
                this.music1.start();
            }
            catch (MediaException ex) {
                ex.printStackTrace();
            }
        }
    }
}

