/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.TextBox;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class Dictionary
extends MIDlet
implements CommandListener {
    TextBox mainMenu;
    static Command QUIT_CMD = new Command("\u0412\u044b\u0445\u043e\u0434", 7, 2);
    static Command BACK_CMD = new Command("\u041d\u0430\u0437\u0430\u0434", 2, 2);
    static Command TRANSLATE_CMD = new Command("\u041f\u0435\u0440\u0435\u0432\u043e\u0434", 4, 1);
    static Command ORDER_BY_FREQUENCY_CMD = new Command("\u041f\u043e \u0447\u0430\u0441\u0442\u043e\u0442\u0435", 8, 1);
    static Command ORDER_BY_TIME_CMD = new Command("\u041f\u043e \u0432\u0440\u0435\u043c\u0435\u043d\u0438", 8, 1);
    static final int MAX_LENGTH = 32;
    static final int MAX_FILE_SIZE = 32768;
    static final int SELECTION_LIMIT = 32;
    static final char SEPARATOR = ':';
    Volume[] volumes;
    int nVolumes;
    byte[] buf = new byte[32768];
    int prevVolumeSize;
    int prevVolumeIndex;
    Vector translatedWords = new Vector();
    RecordStore store;

    private void openStore() {
        try {
            this.store = RecordStore.openRecordStore((String)"DICTIONARY", (boolean)true);
            int n = this.store.getNumRecords();
            this.translatedWords.setSize(n);
            for (int i = 0; i < n; ++i) {
                byte[] byArray = this.store.getRecord(i + 1);
                TranslatedWord translatedWord = new TranslatedWord();
                translatedWord.frequency = byArray[0] & 0xFF;
                translatedWord.word = new String(byArray, 1, byArray.length - 1);
                this.translatedWords.setElementAt(translatedWord, i);
            }
        }
        catch (RecordStoreException recordStoreException) {
            recordStoreException.printStackTrace();
            this.store = null;
        }
    }

    private void closeStore() {
        if (this.store != null) {
            try {
                this.store.closeRecordStore();
                this.store = null;
            }
            catch (RecordStoreException recordStoreException) {
                recordStoreException.printStackTrace();
            }
        }
    }

    void addTranslatedWord(String string) {
        int n = this.translatedWords.size();
        for (int i = 0; i < n; ++i) {
            TranslatedWord translatedWord = (TranslatedWord)this.translatedWords.elementAt(i);
            if (!translatedWord.word.equals(string)) continue;
            if (translatedWord.frequency < 255) {
                ++translatedWord.frequency;
                if (this.store != null) {
                    byte[] byArray = translatedWord.pack();
                    try {
                        this.store.setRecord(i + 1, byArray, 0, byArray.length);
                    }
                    catch (RecordStoreException recordStoreException) {
                        recordStoreException.printStackTrace();
                    }
                }
            }
            return;
        }
        TranslatedWord translatedWord = new TranslatedWord();
        translatedWord.word = string;
        translatedWord.frequency = 1;
        if (this.store != null) {
            byte[] byArray = translatedWord.pack();
            try {
                this.store.addRecord(byArray, 0, byArray.length);
            }
            catch (RecordStoreException recordStoreException) {
                recordStoreException.printStackTrace();
            }
        }
        this.translatedWords.addElement(translatedWord);
    }

    public Dictionary() {
        this.mainMenu = new TextBox("\u041f\u0440\u0435\u0444\u0438\u043a\u0441 \u0441\u043b\u043e\u0432\u0430", "", 32, 0);
        this.mainMenu.addCommand(QUIT_CMD);
        this.mainMenu.addCommand(TRANSLATE_CMD);
        this.buildIndex();
        this.openStore();
    }

    protected void destroyApp(boolean bl) {
        this.mainMenu = null;
        this.closeStore();
    }

    protected void pauseApp() {
    }

    protected void startApp() {
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.mainMenu);
        this.mainMenu.setCommandListener((CommandListener)this);
    }

    static String getString(byte[] byArray, int n, int n2) {
        char[] cArray = new char[n2];
        for (int i = 0; i < n2; ++i) {
            cArray[i] = (char)(byArray[n + i] & 0xFF);
        }
        return new String(cArray);
    }

    static int getUnicodeStringLength(byte[] byArray, int n) {
        byte by;
        while ((by = byArray[n]) != 0) {
            n += by + 2;
        }
        return n + 1;
    }

    static String getUnicodeString(byte[] byArray, int n) {
        int n2;
        char[] cArray = new char[256];
        int n3 = n;
        int n4 = 0;
        while ((n2 = byArray[n3++] & 0xFF) != 0) {
            int n5 = byArray[n3++] << 8;
            while (--n2 >= 0) {
                cArray[n4++] = (char)(n5 | byArray[n3++] & 0xFF);
            }
        }
        return new String(cArray, 0, n4);
    }

    static String rusLowerCase(String string) {
        return string.toLowerCase();
    }

    private void buildIndex() {
        int n;
        int n2;
        Object object;
        try {
            object = ((Object)((Object)this)).getClass().getResourceAsStream("/dictionary.idx");
            n2 = ((InputStream)object).read(this.buf);
            ((InputStream)object).close();
        }
        catch (IOException iOException) {
            throw new Error("Failed to read index");
        }
        object = new Vector();
        for (n = 0; n < n2; ++n) {
            Volume volume = new Volume();
            int n3 = n;
            while (this.buf[n3] != 58) {
                ++n3;
            }
            volume.first = Dictionary.getString(this.buf, n, n3 - n);
            n = ++n3;
            while (this.buf[n] != 10) {
                ++n;
            }
            volume.last = Dictionary.getString(this.buf, n3, n - n3);
            ((Vector)object).addElement(volume);
        }
        this.nVolumes = ((Vector)object).size();
        this.volumes = new Volume[this.nVolumes];
        this.prevVolumeIndex = -1;
        for (n = 0; n < this.nVolumes; ++n) {
            this.volumes[n] = (Volume)((Vector)object).elementAt(n);
        }
    }

    public Vector getSelection(String string) {
        if (this.nVolumes == 0) {
            this.buildIndex();
        }
        Vector<Translation> vector = new Vector<Translation>();
        int n = this.nVolumes;
        Volume[] volumeArray = this.volumes;
        boolean bl = false;
        try {
            int n2;
            for (n2 = 0; n2 < n && volumeArray[n2].last.compareTo(string) < 0; ++n2) {
            }
            while (n2 < n) {
                int n3;
                Object object;
                if (this.prevVolumeIndex != n2) {
                    object = ((Object)((Object)this)).getClass().getResourceAsStream("volume." + (n2 + 1));
                    n3 = ((InputStream)object).read(this.buf);
                    this.prevVolumeIndex = n2;
                    this.prevVolumeSize = n3;
                    ((InputStream)object).close();
                } else {
                    n3 = this.prevVolumeSize;
                }
                object = volumeArray[n2].first;
                int n4 = 0;
                while (n4 < n3) {
                    int n5 = n4;
                    while (this.buf[n4] != 58) {
                        ++n4;
                    }
                    String string2 = this.buf[n5] >= 48 && this.buf[n5] <= 57 ? ((String)object).substring(0, this.buf[n5] - 48) + Dictionary.getString(this.buf, n5 + 1, n4 - n5 - 1) : Dictionary.getString(this.buf, n5, n4 - n5);
                    n5 = ++n4;
                    n4 = Dictionary.getUnicodeStringLength(this.buf, n4);
                    if (string2.compareTo(string) >= 0) {
                        if (string2.startsWith(string)) {
                            bl = true;
                        } else if (bl) {
                            return vector;
                        }
                        vector.addElement(new Translation(string2, Dictionary.getUnicodeString(this.buf, n5)));
                        if (vector.size() == 32) {
                            return vector;
                        }
                    }
                    object = string2;
                }
                ++n2;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return vector;
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == QUIT_CMD) {
            this.destroyApp(true);
            this.notifyDestroyed();
        } else {
            String string = Dictionary.rusLowerCase(this.mainMenu.getString());
            if (string.length() == 0) {
                if (this.translatedWords.size() > 0) {
                    new TranslatedList(this);
                }
            } else {
                this.mainMenu.setTitle("\u041c\u0438\u043d\u0443\u0442\u043e\u0447\u043a\u0443");
                this.mainMenu.setString("\u0418\u0434\u0451\u0442 \u043f\u043e\u0438\u0441\u043a...");
                Vector vector = this.getSelection(string);
                switch (vector.size()) {
                    case 0: {
                        Alert alert = new Alert(string, "\u041d\u0435\u0442 \u0432\u0430\u0440\u0438\u0430\u043d\u0442\u043e\u0432", null, AlertType.ERROR);
                        alert.setTimeout(-2);
                        Display.getDisplay((MIDlet)this).setCurrent(alert, (Displayable)this.mainMenu);
                        break;
                    }
                    case 1: {
                        Translation translation = (Translation)vector.firstElement();
                        if (translation.word.equals(string)) {
                            new TranslationBox(this, (Displayable)this.mainMenu, (Translation)vector.firstElement());
                            break;
                        }
                    }
                    default: {
                        new PrefixList(this, (Displayable)this.mainMenu, vector);
                    }
                }
                this.mainMenu.setTitle("\u041f\u0440\u0435\u0444\u0438\u043a\u0441 \u0441\u043b\u043e\u0432\u0430");
                this.mainMenu.setString(string);
            }
        }
    }

    class Volume {
        String first;
        String last;

        Volume() {
        }
    }
}

