/*
 * Decompiled with CFR 0.152.
 */
package com.wordsteps.ui.dialogs;

import com.sun.lwuit.Command;
import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Dialog;
import com.sun.lwuit.TextArea;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.layouts.BorderLayout;
import com.sun.lwuit.layouts.BoxLayout;
import com.wordsteps.ui.common.TransparentLabel;
import com.wordsteps.ui.common.UIProfile;

public class CustomDialog
extends Dialog {
    private static CustomDialog instance;
    private TransparentLabel titleLabel = new TransparentLabel("");
    private TextArea textLabel;

    private CustomDialog() {
        UIProfile.applyFont(this.titleLabel.getStyle(), "dialog.title.font");
        this.titleLabel.setAlignment(4);
        this.titleLabel.getStyle().setFgColor(0xFFFFFF);
        this.titleLabel.getStyle().setBackgroundGradientEndColor(7190244);
        this.titleLabel.getStyle().setBackgroundGradientStartColor(11393263);
        this.titleLabel.getStyle().setBackgroundType((byte)6);
        this.textLabel = new TextArea("");
        this.textLabel.setEditable(false);
        this.textLabel.setFocusable(false);
        this.textLabel.getStyle().setBorder(null);
        this.textLabel.getStyle().setBgTransparency(0);
        this.textLabel.setGrowByContent(true);
        UIProfile.applyFont(this.textLabel.getStyle(), "dialog.font");
        this.setDialogType(4);
        this.createComponents();
    }

    private static CustomDialog getInstance() {
        if (instance == null) {
            instance = new CustomDialog();
        }
        return instance;
    }

    private void createComponents() {
        this.setLayout(new BorderLayout());
        Container container = new Container(new BoxLayout(2));
        container.addComponent(this.titleLabel);
        container.addComponent(this.textLabel);
        this.addComponent("Center", (Component)container);
    }

    private void createCommands() {
        this.removeAllCommands();
        this.addCommand(new Command("command.ok", 3){

            public void actionPerformed(ActionEvent evt) {
                CustomDialog.getInstance().dispose();
            }
        });
    }

    public static void show(String title, String text) {
        CustomDialog d = CustomDialog.getInstance();
        d.titleLabel.setText(title);
        d.textLabel.setText(text);
        d.createCommands();
        d.layoutContainer();
        d.showPacked("Center", true);
    }

    public static Command show(String title, String text, Command[] cmds) {
        CustomDialog d = CustomDialog.getInstance();
        d.titleLabel.setText(title);
        d.textLabel.setText(text);
        d.removeAllCommands();
        for (int i = 0; i < cmds.length; ++i) {
            d.addCommand(cmds[i]);
        }
        d.layoutContainer();
        return d.showPacked("Center", true);
    }
}

