/*
 * Decompiled with CFR 0.152.
 */
package com.wordsteps.ui.screen;

import com.sun.lwuit.ButtonGroup;
import com.sun.lwuit.ComboBox;
import com.sun.lwuit.Command;
import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Form;
import com.sun.lwuit.Image;
import com.sun.lwuit.Label;
import com.sun.lwuit.RadioButton;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.layouts.BoxLayout;
import com.sun.lwuit.list.ListCellRenderer;
import com.sun.lwuit.plaf.UIManager;
import com.wordsteps.WordSteps;
import com.wordsteps.model.Dictionary;
import com.wordsteps.model.DictionaryCache;
import com.wordsteps.model.Language;
import com.wordsteps.persistence.Configuration;
import com.wordsteps.ui.common.TransparentLabel;
import com.wordsteps.ui.common.UIProfile;
import com.wordsteps.ui.common.commands.BackCommand;
import com.wordsteps.ui.common.renderers.ChooseLanguageListCellRenderer;
import com.wordsteps.ui.dialogs.CustomDialog;
import com.wordsteps.ui.dialogs.LoadingProgressDialog;
import com.wordsteps.ui.screen.DictionaryListScreenForm;
import com.wordsteps.ui.screen.ScreenForm;
import com.wordsteps.ui.util.ImageRegistry;
import com.wordsteps.webservices.client.DictionariesServiceClient;

public class DownloadScreenForm
extends ScreenForm {
    private static final String IMAGE_ID = "download";
    private ComboBox speakLngComboBox;
    private ComboBox learningLngComboBox;
    private RadioButton sortByRate = new RadioButton("download.rating");
    private RadioButton sortByDate;

    public DownloadScreenForm(Form prevForm) {
        super(prevForm);
        this.sortByRate.getSelectedStyle().setBgColor(14608594);
        UIProfile.applyFont(this.sortByRate.getStyle(), "download.radio.font");
        UIProfile.applyFont(this.sortByRate.getSelectedStyle(), "download.radio.font");
        this.sortByDate = new RadioButton("download.date");
        this.sortByDate.setSelected(true);
        this.sortByDate.getSelectedStyle().setBgColor(14608594);
        UIProfile.applyFont(this.sortByDate.getStyle(), "download.radio.font");
        UIProfile.applyFont(this.sortByDate.getSelectedStyle(), "download.radio.font");
        this.setLayout(new BoxLayout(2));
        this.createComponents();
        this.createCommands();
    }

    private void createComponents() {
        ChooseLanguageListCellRenderer lngRnd = new ChooseLanguageListCellRenderer();
        this.speakLngComboBox = this.createChooseLanguageComponent(lngRnd);
        this.learningLngComboBox = this.createChooseLanguageComponent(lngRnd);
        this.addComponent(this.createLabeledComponent("download.ispeak", this.speakLngComboBox));
        this.addComponent(this.createLabeledComponent("download.ilearn", this.learningLngComboBox));
        TransparentLabel sortByLabel = new TransparentLabel("download.sortby");
        UIProfile.applyFont(sortByLabel.getStyle(), "download.label.font");
        UIProfile.applyMargin(sortByLabel.getStyle(), "download.label.margin");
        this.addComponent(sortByLabel);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.sortByRate);
        buttonGroup.add(this.sortByDate);
        this.addComponent(this.sortByRate);
        this.addComponent(this.sortByDate);
    }

    public void createCommands() {
        this.addCommand(new BackCommand(this.getPreviousScreenForm()), 0);
        this.addCommand(new Command("command.download", 12){

            public void actionPerformed(ActionEvent evt) {
                DownloadScreenForm.this.loadDictionaries();
            }
        }, 1);
    }

    public String getName() {
        return "download.title";
    }

    public String getShortName() {
        return "download.title";
    }

    private Dictionary[] wsLoadDictionaries() {
        DictionariesServiceClient service = new DictionariesServiceClient();
        String version = WordSteps.getInstance().getAppProperty("MIDlet-Version");
        String response = service.getUpdateInfo(version, Configuration.getInstance().getUiLanguage().getCode());
        if (response != null) {
            CustomDialog.show("dialog.information", response);
        }
        String sourceLanguage = ((Language)this.speakLngComboBox.getSelectedItem()).getCode();
        String targetLanguage = ((Language)this.learningLngComboBox.getSelectedItem()).getCode();
        String sortBy = this.sortByDate.isSelected() ? "date" : "rate";
        try {
            String platform = "j2me: " + System.getProperty("microedition.platform");
            Dictionary[] d = service.getDictionaries(platform, targetLanguage, sourceLanguage, sortBy);
            for (int i = 0; i < d.length; ++i) {
                DictionaryCache.getInstance().addDictionary(d[i], null);
            }
            return d;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return new Dictionary[0];
        }
    }

    private void saveLastLanguagePair() {
        Configuration conf = Configuration.getInstance();
        conf.setLastSourceLanguage((Language)this.speakLngComboBox.getSelectedItem());
        conf.setLastTargetLanguage((Language)this.learningLngComboBox.getSelectedItem());
    }

    private void loadDictionaries() {
        final LoadingProgressDialog progress = new LoadingProgressDialog();
        progress.showPacked("Center", false);
        new Thread(){

            public void run() {
                DownloadScreenForm.this.saveLastLanguagePair();
                DictionaryListScreenForm listForm = new DictionaryListScreenForm(DownloadScreenForm.this.getPreviousScreenForm());
                Dictionary[] d = DownloadScreenForm.this.wsLoadDictionaries();
                progress.dispose();
                if (d.length == 0) {
                    CustomDialog.show("dialog.information", UIManager.getInstance().localize("dialog.no.dics", "[NULL]"));
                } else {
                    listForm.setDictionaries(d);
                    listForm.show();
                }
            }
        }.start();
    }

    private ComboBox createChooseLanguageComponent(ListCellRenderer lngRnd) {
        ComboBox lngCombo = new ComboBox(Language.values);
        lngCombo.getSelectedStyle().setBgColor(14608594);
        lngCombo.setListCellRenderer(lngRnd);
        return lngCombo;
    }

    private Container createLabeledComponent(String text, Component cmpt) {
        Container c = new Container(new BoxLayout(2));
        Label l = new Label(text);
        UIProfile.applyFont(l.getStyle(), "download.label.font");
        UIProfile.applyMargin(l.getStyle(), "download.label.margin");
        c.addComponent(l);
        c.addComponent(cmpt);
        return c;
    }

    public Image getImage() {
        return ImageRegistry.getImage(IMAGE_ID);
    }

    protected void onShow() {
        Configuration conf = Configuration.getInstance();
        if (conf.isUseLastLanguages()) {
            this.speakLngComboBox.setSelectedItem(conf.getLastSourceLanguage());
            this.learningLngComboBox.setSelectedItem(conf.getLastTargetLanguage());
        } else {
            this.speakLngComboBox.setSelectedItem(conf.getDefaultSourceLanguage());
            this.learningLngComboBox.setSelectedItem(conf.getDefaultTargetLanguage());
        }
    }
}

