/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.html;

import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Font;
import com.sun.lwuit.Label;
import com.sun.lwuit.TextArea;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.html.CSSBgPainter;
import com.sun.lwuit.html.CSSBorder;
import com.sun.lwuit.html.CSSElement;
import com.sun.lwuit.html.CSSParser;
import com.sun.lwuit.html.CellConstraint;
import com.sun.lwuit.html.DocumentInfo;
import com.sun.lwuit.html.HTMLComponent;
import com.sun.lwuit.html.HTMLElement;
import com.sun.lwuit.html.HTMLFont;
import com.sun.lwuit.html.HTMLLink;
import com.sun.lwuit.html.HTMLListItem;
import com.sun.lwuit.html.HTMLTable;
import com.sun.lwuit.html.HTMLTableModel;
import com.sun.lwuit.layouts.BorderLayout;
import com.sun.lwuit.layouts.FlowLayout;
import com.sun.lwuit.plaf.Border;
import com.sun.lwuit.plaf.Style;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class CSSEngine {
    private static CSSEngine instance;
    private static Hashtable specialKeys;
    private Hashtable matchingFonts = new Hashtable();
    private static final int[] URL_ATTRIBUTES;
    static final int STYLE_UNSELECTED = 1;
    static final int STYLE_SELECTED = 2;
    static final int STYLE_PRESSED = 4;
    private static final int INDENT_LIST_STYLE_POSITION = 15;
    private static final int TEXT_TRANSFORM_NONE = 0;
    private static final int TEXT_TRANSFORM_UPPERCASE = 1;
    private static final int TEXT_TRANSFORM_LOWERCASE = 2;
    private static final int TEXT_TRANSFORM_CAPITALIZE = 3;
    private static final int INPUT_REQUIRED_TRUE = 0;
    private static final int INPUT_REQUIRED_FALSE = 1;
    private static final int BG_ATTACHMENT_FIXED = 0;
    private static final int BG_ATTACHMENT_SCROLL = 1;
    private static final int WHITE_SPACE_NORMAL = 0;
    private static final int WHITE_SPACE_PRE = 1;
    private static final int WHITE_SPACE_NOWRAP = 2;
    private static final int DISPLAY_INLINE = 0;
    private static final int DISPLAY_BLOCK = 1;
    private static final int DISPLAY_LIST_ITEM = 2;
    private static final int DISPLAY_NONE = 3;
    private static final int DISPLAY_MARQUEE = 4;
    private static final int FONT_VARIANT_NORMAL = 0;
    private static final int FONT_VARIANT_SMALLCAPS = 1;
    private static final int LIST_STYLE_POSITION_INSIDE = 0;
    private static final int LIST_STYLE_POSITION_OUTSIDE = 1;
    private static final int BORDER_STYLE_NONE = 0;
    private static final int BORDER_STYLE_SOLID = 1;
    private static final int BORDER_STYLE_GROOVE = 2;
    private static final int BORDER_STYLE_RIDGE = 3;
    private static final int BORDER_STYLE_INSET = 4;
    private static final int BORDER_STYLE_OUTSET = 5;
    private static final int BORDER_STYLE_DOTTED = 6;
    private static final int BORDER_STYLE_DASHED = 7;
    private static final int BORDER_STYLE_DOUBLE = 8;
    private static final int VISIBILITY_HIDDEN = 0;
    private static final int VISIBILITY_VISIBLE = 1;

    CSSEngine() {
    }

    static CSSEngine getInstance() {
        if (instance == null) {
            instance = new CSSEngine();
        }
        return instance;
    }

    static void addSpecialKey(String specialKeyName, int specialKeyCode) {
        if (specialKeys == null) {
            specialKeys = new Hashtable();
        }
        specialKeys.put(specialKeyName, new Integer(specialKeyCode));
    }

    private CSSElement[] sortSelectorsBySpecificity(CSSElement[] css) {
        Vector<CSSElement> sortedSelectors = new Vector<CSSElement>();
        for (int s = 0; s < css.length; ++s) {
            CSSElement cssRoot = css[s];
            String cssPageURL = cssRoot.getAttributeById(550);
            DocumentInfo cssDocInfo = null;
            if (cssPageURL != null) {
                cssDocInfo = new DocumentInfo(cssPageURL);
            }
            for (int iter = 0; iter < cssRoot.getNumChildren(); ++iter) {
                int i;
                CSSElement currentSelector = cssRoot.getCSSChildAt(iter);
                if (cssPageURL != null) {
                    for (i = 0; i < URL_ATTRIBUTES.length; ++i) {
                        String imageURL = CSSEngine.getCSSUrl(currentSelector.getAttributeById(URL_ATTRIBUTES[i]));
                        if (imageURL == null) continue;
                        imageURL = cssDocInfo.convertURL(imageURL);
                        currentSelector.setAttribute(currentSelector.getAttributeName(new Integer(URL_ATTRIBUTES[i])), "url(" + imageURL + ")");
                    }
                }
                int specificity = currentSelector.getSelectorSpecificity();
                for (i = 0; i < sortedSelectors.size() && specificity >= ((CSSElement)sortedSelectors.elementAt(i)).getSelectorSpecificity(); ++i) {
                }
                sortedSelectors.insertElementAt(currentSelector, i);
            }
        }
        css = new CSSElement[sortedSelectors.size()];
        for (int i = 0; i < sortedSelectors.size(); ++i) {
            css[i] = (CSSElement)sortedSelectors.elementAt(i);
        }
        return css;
    }

    void applyCSS(HTMLElement document, HTMLComponent htmlC, Vector externalCSS, Vector embeddedCSS) {
        int i;
        int externalSize = 0;
        int embeddedSize = 0;
        if (externalCSS != null) {
            externalSize = externalCSS.size();
        }
        if (embeddedCSS != null) {
            embeddedSize = embeddedCSS.size();
        }
        CSSElement[] css = new CSSElement[externalSize + embeddedSize];
        for (i = 0; i < externalSize; ++i) {
            css[i] = (CSSElement)externalCSS.elementAt(i);
        }
        for (i = 0; i < embeddedSize; ++i) {
            css[i + externalSize] = (CSSElement)embeddedCSS.elementAt(i);
        }
        css = this.sortSelectorsBySpecificity(css);
        this.applyCSS(document, htmlC, css, null);
    }

    private void applyCSS(HTMLElement element, HTMLComponent htmlC, CSSElement[] css, Vector nestedSelectors) {
        String styleStr;
        CSSElement currentSelector;
        String id = element.getAttributeById(1);
        String className = element.getAttributeById(0);
        Vector nextNestedSelectors = new Vector();
        for (int e = 0; e < css.length; ++e) {
            currentSelector = css[e];
            this.checkSelector(currentSelector, element, htmlC, className, id, nextNestedSelectors);
        }
        if (nestedSelectors != null) {
            Enumeration e = nestedSelectors.elements();
            while (e.hasMoreElements()) {
                currentSelector = (CSSElement)e.nextElement();
                this.checkSelector(currentSelector, element, htmlC, className, id, nextNestedSelectors);
            }
        }
        if (nextNestedSelectors.size() == 0) {
            nextNestedSelectors = null;
        }
        if ((styleStr = element.getAttributeById(2)) != null) {
            CSSElement style = null;
            styleStr = "{" + styleStr + "}";
            try {
                style = CSSParser.getInstance().parseCSS(new InputStreamReader(new ByteArrayInputStream(styleStr.getBytes())), htmlC);
                this.applyStyle(element, style, htmlC);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        for (int i = 0; i < element.getNumChildren(); ++i) {
            this.applyCSS((HTMLElement)element.getChildAt(i), htmlC, css, nextNestedSelectors);
        }
    }

    private void checkSelector(CSSElement currentSelector, HTMLElement element, HTMLComponent htmlC, String className, String id, Vector nextNestedSelectors) {
        if ((currentSelector.getSelectorTag() == null || !element.isTextElement() && currentSelector.getSelectorTag().equalsIgnoreCase(element.getName())) && (currentSelector.getSelectorClass() == null || this.containsClass(className, currentSelector.getSelectorClass())) && (currentSelector.getSelectorId() == null || currentSelector.getSelectorId().equalsIgnoreCase(id))) {
            if (currentSelector.getNumChildren() == 0) {
                if (element.getId() != 28 || (currentSelector.getSelectorPseudoClass() & 0xC) == 0 || !(element.getUi().firstElement() instanceof HTMLLink) || !((HTMLLink)element.getUi().firstElement()).linkVisited && (currentSelector.getSelectorPseudoClass() & 4) != 0 || ((HTMLLink)element.getUi().firstElement()).linkVisited && (currentSelector.getSelectorPseudoClass() & 8) != 0) {
                    this.applyStyle(element, currentSelector, htmlC);
                }
            } else {
                nextNestedSelectors.addElement(currentSelector.getChildAt(0));
                if (currentSelector.getSelectorTag() == null && currentSelector.getSelectorId() == null && currentSelector.getSelectorClass() == null) {
                    nextNestedSelectors.addElement(currentSelector);
                }
            }
        }
    }

    private boolean containsClass(String elementClass, String selectorClass) {
        if (elementClass == null || selectorClass == null) {
            return false;
        }
        elementClass = " " + elementClass + " ";
        int dotIndex = selectorClass.indexOf(46);
        while (dotIndex != -1) {
            String curWord = selectorClass.substring(0, dotIndex);
            if (elementClass.indexOf(" " + curWord + " ") == -1) {
                return false;
            }
            selectorClass = selectorClass.substring(dotIndex + 1);
            dotIndex = selectorClass.indexOf(46);
        }
        return elementClass.indexOf(" " + selectorClass + " ") != -1;
    }

    private void applyStyle(HTMLElement element, CSSElement selector, HTMLComponent htmlC) {
        if (element.getUi() != null) {
            for (int iter = 0; iter < element.getUi().size(); ++iter) {
                Object o = element.getUi().elementAt(iter);
                if (!(o instanceof Component)) continue;
                Component cmp = (Component)o;
                this.applyStyleToUIElement(cmp, selector, element, htmlC);
            }
        }
    }

    private int getApplicableStyles(Component cmp, CSSElement selector) {
        int result = 0;
        if (cmp instanceof HTMLLink) {
            int pseudoClass = selector.getSelectorPseudoClass();
            boolean done = false;
            if ((pseudoClass & 1) != 0) {
                result |= 2;
                done = true;
            }
            if ((pseudoClass & 2) != 0) {
                result |= 4;
                done = true;
            }
            if (!done) {
                result |= 3;
            }
        } else {
            result |= 3;
        }
        return result;
    }

    private void setColorRecursive(Component cmp, int color, CSSElement selector) {
        int styles = this.getApplicableStyles(cmp, selector);
        if ((styles & 1) != 0) {
            cmp.getUnselectedStyle().setFgColor(color);
        }
        if ((styles & 2) != 0) {
            cmp.getSelectedStyle().setFgColor(color);
        }
        if ((styles & 4) != 0) {
            ((HTMLLink)cmp).getPressedStyle().setFgColor(color);
        }
        if (cmp instanceof Container) {
            Container cont = (Container)cmp;
            for (int i = 0; i < cont.getComponentCount(); ++i) {
                if (cont.getComponentAt(i) instanceof HTMLLink) continue;
                this.setColorRecursive(cont.getComponentAt(i), color, selector);
            }
        }
    }

    private void setFontRecursive(HTMLComponent htmlC, Component cmp, String fontFamily, int fontSize, int fontStyle, int fontWeight, CSSElement selector) {
        if (cmp instanceof Container) {
            Container cont = (Container)cmp;
            for (int i = 0; i < cont.getComponentCount(); ++i) {
                this.setFontRecursive(htmlC, cont.getComponentAt(i), fontFamily, fontSize, fontStyle, fontWeight, selector);
            }
        } else if (cmp instanceof Label) {
            this.setMatchingFont(htmlC, cmp, fontFamily, fontSize, fontStyle, fontWeight, selector);
        }
    }

    private void setVisibleRecursive(Component cmp, boolean visible) {
        cmp.setEnabled(visible);
        cmp.setVisible(visible);
        if (cmp instanceof Container) {
            Container cont = (Container)cmp;
            for (int i = 0; i < cont.getComponentCount(); ++i) {
                this.setVisibleRecursive(cont.getComponentAt(i), visible);
            }
        }
    }

    private void setTextTransformRecursive(Component cmp, int transformType) {
        if (cmp instanceof Container) {
            Container cont = (Container)cmp;
            for (int i = 0; i < cont.getComponentCount(); ++i) {
                this.setTextTransformRecursive(cont.getComponentAt(i), transformType);
            }
        } else if (cmp instanceof Label) {
            Label label = (Label)cmp;
            switch (transformType) {
                case 1: {
                    label.setText(label.getText().toUpperCase());
                    break;
                }
                case 2: {
                    label.setText(label.getText().toLowerCase());
                    break;
                }
                case 3: {
                    String text = label.getText();
                    String newText = "";
                    boolean capNextLetter = true;
                    for (int i = 0; i < text.length(); ++i) {
                        char c = text.charAt(i);
                        if (CSSParser.isWhiteSpace(c)) {
                            capNextLetter = true;
                        } else if (capNextLetter) {
                            if (c >= 'a' && c <= 'z') {
                                c = (char)(c - 32);
                            }
                            capNextLetter = false;
                        }
                        newText = newText + c;
                    }
                    label.setText(newText);
                }
            }
        }
    }

    private void setTextAlignmentRecursive(Component cmp, int align) {
        if (cmp instanceof Container) {
            Container cont = (Container)cmp;
            if (cont.getLayout() instanceof FlowLayout) {
                cont.setLayout(new FlowLayout(align));
            }
            for (int i = 0; i < cont.getComponentCount(); ++i) {
                this.setTextAlignmentRecursive(cont.getComponentAt(i), align);
            }
        }
    }

    private void setTextIndentationRecursive(Component cmp, int indent) {
        if (cmp instanceof Container) {
            Container cont = (Container)cmp;
            if (cont.getLayout() instanceof FlowLayout && cont.getComponentCount() > 0) {
                cont.getComponentAt(0).getUnselectedStyle().setMargin(1, indent);
                cont.getComponentAt(0).getSelectedStyle().setMargin(1, indent);
            }
            for (int i = 0; i < cont.getComponentCount(); ++i) {
                this.setTextIndentationRecursive(cont.getComponentAt(i), indent);
            }
        }
    }

    private void setParentsVisible(Component cmp) {
        for (Container cont = cmp.getParent(); cont != null; cont = cont.getParent()) {
            cont.setVisible(true);
        }
    }

    private void setWrapText(Label label, Vector words, HTMLElement element, HTMLComponent htmlC) {
        Style selectedStyle = label.getSelectedStyle();
        Style unselectedStyle = label.getUnselectedStyle();
        Vector<Label> ui = new Vector<Label>();
        label.setText((String)words.elementAt(0) + ' ');
        HTMLLink link = null;
        if (label instanceof HTMLLink) {
            link = (HTMLLink)label;
        }
        ui.addElement(label);
        for (int i = 1; i < words.size(); ++i) {
            Label word = null;
            word = link != null ? new HTMLLink((String)words.elementAt(i) + ' ', link.link, htmlC, link, link.linkVisited) : new Label((String)words.elementAt(i) + ' ');
            word.setSelectedStyle(selectedStyle);
            word.setUnselectedStyle(unselectedStyle);
            label.getParent().addComponent(word);
            ui.addElement(word);
        }
        element.setAssociatedComponents(ui);
        label.getParent().revalidate();
    }

    private void setWrapRecursive(HTMLElement element, HTMLComponent htmlC) {
        if (element.isTextElement()) {
            String text = element.getText();
            Vector ui = element.getUi();
            if (text != null && ui != null && ui.size() == 1) {
                Vector words = htmlC.getWords(text, 1, false);
                Label label = (Label)ui.elementAt(0);
                this.setWrapText(label, words, element, htmlC);
            }
        }
        for (int i = 0; i < element.getNumChildren(); ++i) {
            this.setWrapRecursive((HTMLElement)element.getChildAt(i), htmlC);
        }
    }

    private void setNowrapText(Label label, Vector ui, String newText, HTMLElement element) {
        label.setText(newText);
        for (int i = 1; i < ui.size(); ++i) {
            Component cmp = (Component)ui.elementAt(i);
            cmp.getParent().removeComponent(cmp);
        }
        if (label instanceof HTMLLink) {
            ((HTMLLink)label).childLinks = new Vector();
        }
        element.setAssociatedComponents(label);
        label.getParent().revalidate();
    }

    private void setNowrapRecursive(HTMLElement element) {
        if (element.isTextElement()) {
            String text = element.getText();
            Vector ui = element.getUi();
            if (text != null && ui != null && ui.size() > 1) {
                String word = "";
                String newText = "";
                for (int c = 0; c < text.length(); ++c) {
                    char ch = text.charAt(c);
                    if (ch == ' ' || ch == '\n' || ch == '\r' || ch == '\t' || ch == '\n') {
                        if (word.equals("")) continue;
                        newText = newText + word + " ";
                        word = "";
                        continue;
                    }
                    word = word + ch;
                }
                if (!word.equals("")) {
                    newText = newText + word + " ";
                }
                Label label = (Label)ui.elementAt(0);
                this.setNowrapText(label, ui, newText, element);
            }
        }
        for (int i = 0; i < element.getNumChildren(); ++i) {
            this.setNowrapRecursive((HTMLElement)element.getChildAt(i));
        }
        element.recalcUi();
    }

    private void applyStyleToUIElement(Component ui, CSSElement selector, HTMLElement element, HTMLComponent htmlC) {
        int fontVariant;
        int index;
        String fontFamily;
        int indent;
        int transform;
        int valign;
        String url;
        int fgColor;
        int bgColor;
        int inputRequired;
        String v;
        int styles = this.getApplicableStyles(ui, selector);
        int space = selector.getAttrVal(531);
        if (space != -1) {
            switch (space) {
                case 0: {
                    this.setWrapRecursive(element, htmlC);
                    break;
                }
                case 2: {
                    this.setNowrapRecursive(element);
                    break;
                }
            }
        }
        if ((v = selector.getAttributeById(548)) != null && (element.getId() == 40 || element.getId() == 36) && ui instanceof TextArea) {
            v = CSSEngine.omitQuotesIfExist(v);
            ui = htmlC.setInputFormat((TextArea)ui, v);
            element.setAssociatedComponents(ui);
        }
        if ((inputRequired = selector.getAttrVal(549)) != -1 && (element.getId() == 40 || element.getId() == 36) && ui instanceof TextArea) {
            if (inputRequired == 0) {
                htmlC.setInputRequired((TextArea)ui, true);
            } else if (inputRequired == 1) {
                htmlC.setInputRequired((TextArea)ui, false);
            }
        }
        int disp = selector.getAttrVal(521);
        switch (disp) {
            case 3: {
                if (ui.getParent() != null) {
                    ui.getParent().removeComponent(ui);
                } else {
                    ((Container)ui).removeAll();
                }
                return;
            }
            case 4: {
                htmlC.marqueeComponents.addElement(ui);
            }
        }
        int visibility = selector.getAttrVal(530);
        if (visibility != -1) {
            boolean visible = visibility == 1;
            this.setVisibleRecursive(ui, visible);
            if (!visible) {
                return;
            }
            this.setParentsVisible(ui);
        }
        int width = selector.getAttrLengthVal(529, ui, htmlC.getWidth());
        int height = selector.getAttrLengthVal(528, ui, htmlC.getHeight());
        if (width != -1 || height != -1) {
            if (width == -1) {
                width = ui.getPreferredW();
            }
            if (height == -1) {
                height = ui.getPreferredH();
            }
            ui.setPreferredSize(new Dimension(width, height));
        }
        if ((bgColor = selector.getAttrVal(500)) != -1) {
            if ((styles & 1) != 0) {
                ui.getUnselectedStyle().setBgColor(bgColor);
                ui.getUnselectedStyle().setBgTransparency(255);
            }
            if ((styles & 2) != 0) {
                ui.getSelectedStyle().setBgColor(bgColor);
                ui.getSelectedStyle().setBgTransparency(255);
            }
            if ((styles & 4) != 0) {
                ((HTMLLink)ui).getPressedStyle().setBgColor(bgColor);
                ((HTMLLink)ui).getPressedStyle().setBgTransparency(255);
            }
        }
        if ((fgColor = selector.getAttrVal(519)) != -1) {
            this.setColorRecursive(ui, fgColor, selector);
        }
        if ((v = selector.getAttributeById(501)) != null && (url = CSSEngine.getCSSUrl(v)) != null) {
            CSSBgPainter bgPainter = new CSSBgPainter(ui);
            byte bgType = (byte)selector.getAttrVal(502);
            if (bgType == -1) {
                bgType = 2;
            }
            if ((styles & 2) != 0) {
                ui.getSelectedStyle().setBgPainter(bgPainter);
                ui.getSelectedStyle().setBackgroundType(bgType);
            }
            if ((styles & 1) != 0) {
                ui.getUnselectedStyle().setBgPainter(bgPainter);
                ui.getUnselectedStyle().setBackgroundType(bgType);
            }
            if ((styles & 4) != 0) {
                ((HTMLLink)ui).getPressedStyle().setBgPainter(bgPainter);
                ((HTMLLink)ui).getPressedStyle().setBackgroundType(bgType);
            }
            if (htmlC.showImages) {
                if (htmlC.getDocumentInfo() != null) {
                    htmlC.getThreadQueue().addBgImage(ui, htmlC.convertURL(url), styles);
                } else if (DocumentInfo.isAbsoluteURL(url)) {
                    htmlC.getThreadQueue().addBgImage(ui, url, styles);
                } else if (htmlC.getHTMLCallback() != null) {
                    htmlC.getHTMLCallback().parsingError(103, selector.getName(), selector.getAttributeName(new Integer(501)), url, "Ignoring background image file referred in a CSS file/segment (" + url + "), since page was set by setBody/setHTML/setDOM so there's no way to access relative URLs");
                }
            }
            for (int i = 504; i <= 505; ++i) {
                int pos = selector.getAttrVal(i);
                if (pos == -1) continue;
                bgPainter.setPosition(i, pos);
            }
            if (selector.getAttrVal(503) == 0) {
                bgPainter.setFixed();
            }
        }
        Component marginComp = ui;
        if (ui instanceof Label) {
            marginComp = ui.getParent();
        } else if (element.getId() == 34 && ui.getParent().getLayout() instanceof BorderLayout) {
            marginComp = ui.getParent();
        }
        for (int i = 535; i <= 538; ++i) {
            int marginPixels = -1;
            marginPixels = i == 535 || i == 537 ? selector.getAttrLengthVal(i, ui, htmlC.getHeight()) : selector.getAttrLengthVal(i, ui, htmlC.getWidth());
            if (marginPixels == -1) continue;
            if ((styles & 2) != 0) {
                marginComp.getSelectedStyle().setMargin(i - 535, marginPixels);
                if (ui instanceof HTMLLink && styles == 2) {
                    ((HTMLLink)ui).setParentChangesOnFocus();
                }
            }
            if ((styles & 1) == 0) continue;
            marginComp.getUnselectedStyle().setMargin(i - 535, marginPixels);
        }
        Component padComp = ui;
        if (ui instanceof Label) {
            padComp = ui.getParent();
        } else if (element.getId() == 34 && ui.getParent().getLayout() instanceof BorderLayout) {
            padComp = ui.getParent();
        }
        for (int i = 539; i <= 542; ++i) {
            int padPixels = -1;
            padPixels = i == 539 || i == 541 ? selector.getAttrLengthVal(i, ui, htmlC.getHeight()) : selector.getAttrLengthVal(i, ui, htmlC.getWidth());
            if (padPixels == -1) continue;
            if ((styles & 2) != 0) {
                padComp.getSelectedStyle().setPadding(i - 539, padPixels);
                if (ui instanceof HTMLLink && styles == 2) {
                    ((HTMLLink)ui).setParentChangesOnFocus();
                }
            }
            if ((styles & 1) == 0) continue;
            padComp.getUnselectedStyle().setPadding(i - 539, padPixels);
        }
        int align = selector.getAttrVal(543);
        if (align != -1) {
            switch (element.getId()) {
                case 43: 
                case 44: {
                    this.setTableCellAlignment(element, ui, align, true);
                    break;
                }
                case 45: {
                    this.setTableCellAlignmentTR(element, ui, align, true);
                    break;
                }
                case 42: {
                    this.setTableAlignment(ui, align, true);
                    break;
                }
                default: {
                    this.setTextAlignmentRecursive(ui, align);
                }
            }
        }
        if ((valign = selector.getAttrVal(520)) != -1) {
            switch (element.getId()) {
                case 43: 
                case 44: {
                    this.setTableCellAlignment(element, ui, valign, false);
                    break;
                }
                case 45: {
                    this.setTableCellAlignmentTR(element, ui, valign, false);
                    break;
                }
            }
        }
        if ((transform = selector.getAttrVal(546)) != -1) {
            this.setTextTransformRecursive(ui, transform);
        }
        if ((indent = selector.getAttrLengthVal(545, ui, htmlC.getWidth())) != -1) {
            this.setTextIndentationRecursive(ui, indent);
        }
        if ((fontFamily = selector.getAttributeById(523)) != null && (index = fontFamily.indexOf(44)) != -1) {
            fontFamily = fontFamily.substring(0, index);
        }
        int fontStyle = selector.getAttrVal(525);
        int fontWeight = selector.getAttrVal(526);
        int fontSize = selector.getAttrLengthVal(524, ui, ui.getStyle().getFont().getHeight());
        if (fontSize < -1) {
            int curSize = ui.getStyle().getFont().getHeight();
            if (fontSize == -2) {
                fontSize = curSize + 2;
            } else if (fontSize == -3) {
                fontSize = curSize - 2;
            }
        }
        if ((fontVariant = selector.getAttrVal(527)) == 1 && htmlC.isSmallCapsFontAvailable()) {
            fontFamily = "small-caps";
        }
        if (fontFamily != null || fontSize != -1 || fontStyle != -1 || fontWeight != -1) {
            this.setFontRecursive(htmlC, ui, fontFamily, fontSize, fontStyle, fontWeight, selector);
        }
        int listType = -1;
        String listImg = null;
        Component borderUi = ui;
        if (element.getId() == 34 || element.getId() == 33 || element.getId() == 32) {
            int listPos = selector.getAttrVal(533);
            if (listPos == 0) {
                ui.getStyle().setPadding(1, ui.getStyle().getMargin(1) + 15);
                Container parent = ui.getParent();
                if (parent.getLayout() instanceof BorderLayout) {
                    borderUi = parent;
                }
            }
            listType = selector.getAttrVal(534);
            listImg = CSSEngine.getCSSUrl(selector.getAttributeById(532));
        }
        Border[] borders = new Border[4];
        for (int i = 0; i <= 3; ++i) {
            borders[i] = this.createBorder(selector, borderUi, i, styles);
        }
        Border curBorder = borderUi.getUnselectedStyle().getBorder();
        if ((styles & 2) != 0 && (styles & 1) == 0) {
            curBorder = borderUi.getSelectedStyle().getBorder();
        }
        if ((styles & 4) != 0) {
            curBorder = ((HTMLLink)borderUi).getSelectedStyle().getBorder();
        }
        if (curBorder != null && curBorder instanceof CSSBorder) {
            ((CSSBorder)curBorder).mergeBorder(borders);
            borderUi.getParent().revalidate();
        } else {
            CSSBorder border = CSSBorder.createCSSBorder(borders, borderUi);
            if (border != null) {
                if ((styles & 2) != 0) {
                    borderUi.getSelectedStyle().setBorder(border);
                }
                if ((styles & 1) != 0) {
                    borderUi.getUnselectedStyle().setBorder(border);
                }
                if ((styles & 4) != 0) {
                    ((HTMLLink)borderUi).getPressedStyle().setBorder(border);
                }
                borderUi.getParent().revalidate();
            }
        }
        v = selector.getAttributeById(547);
        if (v != null && v.length() >= 1 && (element.getId() == 36 || element.getId() == 40 || element.getId() == 37 || element.getId() == 28 && ui instanceof HTMLLink && ((HTMLLink)ui).parentLink == null)) {
            int index2 = v.indexOf(44);
            boolean assigned = false;
            while (index2 != -1) {
                String key = v.substring(0, index2).trim();
                v = v.substring(index2 + 1);
                assigned = this.processAccessKeys(key, htmlC, ui);
                if (assigned) break;
                index2 = v.indexOf(44);
            }
            if (!assigned) {
                this.processAccessKeys(v.trim(), htmlC, ui);
            }
        }
        if (listType != -1 || listImg != null) {
            if (element.getId() == 34) {
                Component listItemCmp;
                Container bulletCont;
                Container liCont;
                Container liParent;
                Component firstComp;
                if (ui instanceof Container && (firstComp = (liParent = (liCont = (Container)ui).getParent()).getComponentAt(0)) instanceof Container && (bulletCont = (Container)firstComp).getComponentCount() > 0 && (listItemCmp = bulletCont.getComponentAt(0)) instanceof Component) {
                    HTMLListItem listItem = (HTMLListItem)listItemCmp;
                    listItem.setStyleType(listType);
                    listItem.setImage(listImg);
                }
            } else if (element.getId() == 33 || element.getId() == 32) {
                Container ulCont = (Container)ui;
                for (int i = 0; i < ulCont.getComponentCount(); ++i) {
                    Container liContFirstLine;
                    Container liCont;
                    Component cmp = ulCont.getComponentAt(i);
                    if (!(cmp instanceof Container) || (liCont = (Container)cmp).getComponentCount() < 1 || !((cmp = liCont.getComponentAt(0)) instanceof Container) || (liContFirstLine = (Container)cmp).getComponentCount() < 1 || !((cmp = liContFirstLine.getComponentAt(0)) instanceof HTMLListItem)) continue;
                    HTMLListItem listItem = (HTMLListItem)cmp;
                    listItem.setStyleType(listType);
                    listItem.setImage(listImg);
                }
            }
        }
    }

    private void setTableAlignment(Component ui, int align, boolean isHorizontal) {
        HTMLTable table = (HTMLTable)ui;
        HTMLTableModel model = (HTMLTableModel)table.getModel();
        model.setAlignToAll(isHorizontal, align);
        table.setModel(model);
    }

    private void setTableCellAlignment(HTMLElement tdTag, Component ui, int align, boolean isHorizontal) {
        HTMLElement trTag;
        for (trTag = (HTMLElement)tdTag.getParent(); trTag != null && trTag.getId() != 45; trTag = (HTMLElement)trTag.getParent()) {
        }
        this.setTableCellAlignmentTR(trTag, ui, align, isHorizontal);
    }

    private void setTableCellAlignmentTR(HTMLElement trTag, Component ui, int align, boolean isHorizontal) {
        if (trTag != null && trTag.getId() == 45) {
            HTMLElement tableTag;
            for (tableTag = (HTMLElement)trTag.getParent(); tableTag != null && tableTag.getId() != 42; tableTag = (HTMLElement)tableTag.getParent()) {
            }
            if (tableTag != null && tableTag.getId() == 42) {
                HTMLTable table = (HTMLTable)tableTag.getUi().elementAt(0);
                HTMLTableModel model = (HTMLTableModel)table.getModel();
                CellConstraint cConstraint = model.getConstraint(ui);
                if (isHorizontal) {
                    cConstraint.setHorizontalAlign(align);
                } else {
                    cConstraint.setVerticalAlign(align);
                }
                table.setModel(model);
            }
        }
    }

    private boolean processAccessKeys(String keyStr, HTMLComponent htmlC, Component ui) {
        int index = keyStr.indexOf(32);
        boolean isFirstKey = true;
        while (index != -1) {
            String key = keyStr.substring(0, index).trim();
            keyStr = keyStr.substring(index + 1);
            if (!this.processAccessKey(key, htmlC, ui, isFirstKey)) {
                return false;
            }
            isFirstKey = false;
            index = keyStr.indexOf(32);
        }
        return this.processAccessKey(keyStr, htmlC, ui, isFirstKey);
    }

    private boolean processAccessKey(String keyStr, HTMLComponent htmlC, Component ui, boolean override) {
        Integer key;
        if (keyStr.startsWith("\\")) {
            try {
                int keyCode = Integer.parseInt(keyStr.substring(1), 16);
                htmlC.addAccessKey((char)keyCode, ui, override);
                return true;
            }
            catch (NumberFormatException nfe) {
                return false;
            }
        }
        if (keyStr.length() == 1) {
            htmlC.addAccessKey(keyStr.charAt(0), ui, override);
            return true;
        }
        if (specialKeys != null && (key = (Integer)specialKeys.get(keyStr)) != null) {
            htmlC.addAccessKey(key, ui, override);
            return true;
        }
        return false;
    }

    Border createBorder(CSSElement styleAttributes, Component ui, int location, int styles) {
        int borderStyle = styleAttributes.getAttrVal(510 + location);
        if (borderStyle == -1 || borderStyle == 0) {
            return null;
        }
        int borderColor = styleAttributes.getAttrVal(514 + location);
        int borderWidth = styleAttributes.getAttrLengthVal(506 + location, ui, 0);
        if (borderWidth == -1) {
            borderWidth = CSSElement.BORDER_DEFAULT_WIDTH;
        }
        if ((styles & 2) != 0) {
            ui.getSelectedStyle().setPadding(location, ui.getStyle().getPadding(location) + borderWidth);
        }
        if ((styles & 1) != 0) {
            ui.getUnselectedStyle().setPadding(location, ui.getStyle().getPadding(location) + borderWidth);
        }
        if ((styles & 4) != 0) {
            ((HTMLLink)ui).getPressedStyle().setPadding(location, ui.getStyle().getPadding(location) + borderWidth);
        }
        Border border = null;
        switch (borderStyle) {
            case 1: 
            case 6: 
            case 7: 
            case 8: {
                if (borderColor != -1) {
                    border = Border.createLineBorder(borderWidth, borderColor);
                    break;
                }
                border = Border.createLineBorder(borderWidth);
                break;
            }
            case 4: {
                if (borderColor != -1) {
                    border = Border.createBevelRaised(0, 0, borderColor, borderColor);
                    break;
                }
                border = Border.createBevelLowered();
                break;
            }
            case 5: {
                if (borderColor != -1) {
                    border = Border.createBevelRaised(borderColor, borderColor, 0, 0);
                    break;
                }
                border = Border.createBevelRaised();
                break;
            }
            case 2: {
                if (borderColor != -1) {
                    border = Border.createEtchedRaised(borderColor, 0);
                    break;
                }
                border = Border.createEtchedRaised();
                break;
            }
            case 3: {
                border = borderColor != -1 ? Border.createEtchedLowered(borderColor, 0) : Border.createEtchedLowered();
            }
        }
        return border;
    }

    static String omitQuotesIfExist(String str) {
        if (str == null) {
            return null;
        }
        if ((str.charAt(0) == '\"' || str.charAt(0) == '\'') && str.length() >= 2) {
            str = str.substring(1, str.length() - 1);
        }
        return str;
    }

    private void setMatchingFont(HTMLComponent htmlC, Component cmp, String fontFamily, int fontSize, int fontStyle, int fontWeight, CSSElement selector) {
        int styles = this.getApplicableStyles(cmp, selector);
        Font curFont = cmp.getUnselectedStyle().getFont();
        if ((styles & 2) != 0 && (styles & 1) == 0) {
            curFont = cmp.getSelectedStyle().getFont();
        }
        if ((styles & 4) != 0) {
            curFont = ((HTMLLink)cmp).getPressedStyle().getFont();
        }
        int curSize = 0;
        boolean isBold = false;
        boolean isItalic = false;
        String curFamily = null;
        if (curFont.getCharset() == null) {
            switch (curFont.getFace()) {
                case 0: {
                    curFamily = "system";
                    break;
                }
                case 64: {
                    curFamily = "proportional";
                    break;
                }
                default: {
                    curFamily = "monospace";
                }
            }
            curSize = curFont.getHeight() - 2;
            isBold = (curFont.getStyle() & 1) != 0;
            isItalic = (curFont.getStyle() & 2) != 0;
        } else {
            HTMLFont hFont = htmlC.getHTMLFont(curFont);
            if (hFont != null) {
                curSize = hFont.getSize();
                isBold = hFont.isBold();
                isItalic = hFont.isItalic();
                curFamily = hFont.getFamily();
            }
        }
        if (fontFamily != null && curFamily != null && !fontFamily.equalsIgnoreCase(curFamily) || fontSize != curSize || isBold != (fontWeight == 1) || isItalic != (fontWeight == 2)) {
            String fontKey;
            Object obj;
            if (fontFamily == null && curFamily != null) {
                fontFamily = curFamily.toLowerCase();
            }
            if (fontSize == -1) {
                fontSize = curSize;
            }
            if (fontStyle == -1) {
                fontStyle = isItalic ? 2 : 0;
            }
            if (fontWeight == -1) {
                fontWeight = isBold ? 1 : 0;
            }
            if ((obj = this.matchingFonts.get(fontKey = fontFamily + "." + fontSize + "." + fontStyle + "." + fontWeight)) != null) {
                Font font = (Font)obj;
                this.setFontForStyles(styles, cmp, font);
                return;
            }
            Font font = null;
            if (curFont.getCharset() == null) {
                int systemFontSize = curFont.getSize();
                if (fontSize > curSize) {
                    if (systemFontSize == 8) {
                        systemFontSize = 0;
                    } else if (systemFontSize == 0) {
                        systemFontSize = 16;
                    }
                } else if (fontSize < curSize) {
                    if (systemFontSize == 16) {
                        systemFontSize = 0;
                    } else if (systemFontSize == 0) {
                        systemFontSize = 8;
                    }
                }
                font = Font.createSystemFont(curFont.getFace(), fontStyle + fontWeight, systemFontSize);
            } else {
                font = htmlC.getClosestFont(fontFamily, fontSize, fontStyle, fontWeight);
            }
            if (font != null) {
                this.matchingFonts.put(fontKey, font);
                this.setFontForStyles(styles, cmp, font);
            }
        }
    }

    private void setFontForStyles(int styles, Component cmp, Font font) {
        if ((styles & 1) != 0) {
            cmp.getUnselectedStyle().setFont(font);
        }
        if ((styles & 2) != 0) {
            cmp.getSelectedStyle().setFont(font);
        }
        if ((styles & 4) != 0) {
            ((HTMLLink)cmp).getPressedStyle().setFont(font);
        }
    }

    static String getCSSUrl(String cssURL) {
        int index;
        if (cssURL != null && cssURL.toLowerCase().startsWith("url(") && (index = cssURL.indexOf(41)) != -1) {
            cssURL = cssURL.substring(4, index);
            cssURL = cssURL.trim();
            cssURL = CSSEngine.omitQuotesIfExist(cssURL);
            return cssURL;
        }
        return null;
    }

    static {
        URL_ATTRIBUTES = new int[]{501, 532};
    }
}

