/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.html;

import com.sun.lwuit.html.CSSElement;
import java.util.Hashtable;

public class HTMLUtils {
    private static final String[] XML_CHAR_ENTITIES = new String[]{"lt", "gt", "amp", "quot", "apos"};
    private static final int[] XML_CHAR_ENTITIES_VALS = new int[]{60, 62, 38, 34, 39};
    private static final String[] HTML_BASIC_CHAR_ENTITY_STRINGS = new String[]{"nbsp", "iexcl", "cent", "pound", "curren", "yen", "brvbar", "sect", "uml", "copy", "ordf", "laquo", "not", "shy", "reg", "macr", "deg", "plusmn", "sup2", "sup3", "acute", "micro", "para", "middot", "cedil", "sup1", "ordm", "raquo", "frac14", "frac12", "frac34", "iquest", "Agrave", "Aacute", "Acirc", "Atilde", "Auml", "Aring", "AElig", "Ccedil", "Egrave", "Eacute", "Ecirc", "Euml", "Igrave", "Iacute", "Icirc", "Iuml", "ETH", "Ntilde", "Ograve", "Oacute", "Ocirc", "Otilde", "Ouml", "times", "Oslash", "Ugrave", "Uacute", "Ucirc", "Uuml", "Yacute", "THORN", "szlig", "agrave", "aacute", "acirc", "atilde", "auml", "aring", "aelig", "ccedil", "egrave", "eacute", "ecirc", "euml", "igrave", "iacute", "icirc", "iuml", "eth", "ntilde", "ograve", "oacute", "ocirc", "otilde", "ouml", "divide", "oslash", "ugrave", "uacute", "ucirc", "uuml", "yacute", "thorn", "yuml"};

    private HTMLUtils() {
    }

    public static String convertXMLCharEntity(String charEntity) {
        return HTMLUtils.convertCharEntity(charEntity, false, null);
    }

    public static String convertHTMLCharEntity(String charEntity) {
        return HTMLUtils.convertCharEntity(charEntity, true, null);
    }

    public static String convertCharEntity(String charEntity, boolean lookupHTMLentities, Hashtable userDefinedCharEntities) {
        int charCode = -1;
        if (charEntity.startsWith("#")) {
            if (charEntity.startsWith("#x")) {
                try {
                    charCode = Integer.parseInt(charEntity.substring(2), 16);
                }
                catch (NumberFormatException nfe) {}
            } else {
                try {
                    charCode = Integer.parseInt(charEntity.substring(1));
                }
                catch (NumberFormatException nfe) {}
            }
        } else {
            charCode = HTMLUtils.getCharEntityCode(charEntity, lookupHTMLentities, userDefinedCharEntities);
        }
        if (charCode != -1) {
            return "" + (char)charCode;
        }
        throw new IllegalArgumentException("Unknown character entity - " + charEntity);
    }

    private static int getCharEntityCode(String symbol, boolean html, Hashtable userDefined) {
        Object charObj;
        int val = -1;
        for (int i = 0; i < XML_CHAR_ENTITIES.length; ++i) {
            if (!symbol.equalsIgnoreCase(XML_CHAR_ENTITIES[i])) continue;
            return XML_CHAR_ENTITIES_VALS[i];
        }
        if (val != -1) {
            return val;
        }
        if (html && (val = CSSElement.getStringVal(symbol, HTML_BASIC_CHAR_ENTITY_STRINGS)) != -1) {
            return val + 160;
        }
        if (userDefined != null && (charObj = userDefined.get(symbol)) != null) {
            return (Integer)charObj;
        }
        return -1;
    }

    public static String encodeString(String str) {
        if (str == null) {
            return "";
        }
        String encodedStr = "";
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '-' || c == '.' || c == '_' || c == '~') {
                encodedStr = encodedStr + c;
                continue;
            }
            if (c >= '\u0080' && c <= '\uffff') {
                int firstLiteral = c / 256;
                int secLiteral = c % 256;
                if (c <= '\u07ff') {
                    firstLiteral = 192 + (firstLiteral << 2) + (secLiteral >> 6);
                    secLiteral = 128 + (secLiteral & 0x3F);
                    encodedStr = encodedStr + "%" + Integer.toHexString(firstLiteral).toUpperCase() + "%" + Integer.toHexString(secLiteral).toUpperCase();
                    continue;
                }
                int thirdLiteral = 128 + (secLiteral & 0x3F);
                secLiteral = 128 + (firstLiteral % 16 << 2) + (secLiteral >> 6);
                firstLiteral = 224 + (firstLiteral >> 4);
                encodedStr = encodedStr + "%" + Integer.toHexString(firstLiteral).toUpperCase() + "%" + Integer.toHexString(secLiteral).toUpperCase() + "%" + Integer.toHexString(thirdLiteral).toUpperCase();
                continue;
            }
            String prefix = "%";
            if (c < '\u0010') {
                prefix = prefix + "0";
            }
            encodedStr = encodedStr + prefix + Integer.toHexString(c).toUpperCase();
        }
        return encodedStr;
    }
}

