/*
 * Decompiled with CFR 0.152.
 */
package com.wordsteps;

import com.sun.lwuit.Display;
import com.sun.lwuit.impl.midp.VKBImplementationFactory;
import com.sun.lwuit.plaf.UIManager;
import com.sun.lwuit.util.Resources;
import com.wordsteps.model.Dictionary;
import com.wordsteps.model.DictionaryCache;
import com.wordsteps.persistence.Configuration;
import com.wordsteps.persistence.DefaultDictionaries;
import com.wordsteps.persistence.PersistenceManager;
import com.wordsteps.ui.common.WSLookAndFeel;
import com.wordsteps.ui.screen.MainScreenForm;
import com.wordsteps.ui.screen.SplashScreenForm;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.midlet.MIDlet;

public class WordSteps
extends MIDlet {
    private static WordSteps instance;
    private Resources resources;
    private Timer timer;

    public WordSteps() {
        instance = this;
    }

    public void startApp() {
        VKBImplementationFactory.init();
        Display.init((Object)this);
        this.configureMIDlet();
        this.timer = new Timer();
        this.timer.schedule((TimerTask)new SplashScreenTimerTask(), 500L);
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean unconditional) {
    }

    public static WordSteps getInstance() {
        return instance;
    }

    private void configureMIDlet() {
        UIManager.getInstance().setLookAndFeel(new WSLookAndFeel());
        Configuration configuration = Configuration.getInstance();
        if (configuration.isFirstTime()) {
            configuration.setFirstTime(false);
            Dictionary[] dictionaries = DefaultDictionaries.dictionaries;
            for (int i = 0; i < dictionaries.length; ++i) {
                PersistenceManager.saveDictionary(dictionaries[i]);
            }
        }
        Display.getInstance().setThirdSoftButton(true);
    }

    public synchronized Resources getResources() {
        if (this.resources == null) {
            try {
                this.resources = Resources.open("/themes/LWUITtheme.res");
            }
            catch (IOException ex) {
                ex.printStackTrace();
                throw new RuntimeException("Unable to load theme " + ex.getMessage());
            }
        }
        return this.resources;
    }

    private class SplashScreenTimerTask
    extends TimerTask {
        public SplashScreenTimerTask() {
            new SplashScreenForm().show();
        }

        public void run() {
            Resources theme = WordSteps.this.getResources();
            UIManager.getInstance().setThemeProps(theme.getTheme(theme.getThemeResourceNames()[0]));
            Display.getInstance().callSerially(new Runnable(){

                public void run() {
                    DictionaryCache.getInstance();
                    new MainScreenForm().show();
                }
            });
            WordSteps.this.timer.cancel();
        }
    }
}

