/*
 * Decompiled with CFR 0.152.
 */
package com.wordsteps.model;

import com.wordsteps.model.DictionaryChangeListener;
import com.wordsteps.model.DictionaryInfo;
import com.wordsteps.model.Language;
import com.wordsteps.model.LearningStatus;
import com.wordsteps.model.Word;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Dictionary {
    private Vector listeners = new Vector();
    private int id;
    private int storageId;
    private boolean recent;
    private DictionaryInfo info = new DictionaryInfo();
    private Word[] words;
    private LearningStatus status = new LearningStatus();

    public Dictionary() {
    }

    public Dictionary(int id, boolean recent, DictionaryInfo info, Word[] words) {
        this.id = id;
        this.recent = recent;
        this.info = info;
        this.words = words;
    }

    public DictionaryInfo getInfo() {
        return this.info;
    }

    public void setInfo(DictionaryInfo info) {
        this.info = info;
    }

    public Word[] getWords() {
        return this.words;
    }

    public void setWords(Word[] words) {
        this.words = words;
    }

    public LearningStatus getStatus() {
        return this.status;
    }

    public void setStatus(LearningStatus status) {
        this.status = status;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public boolean isRecent() {
        return this.recent;
    }

    public void setRecent(boolean recent) {
        this.recent = recent;
    }

    public byte[] serialize() throws IOException {
        int i;
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataOutputStream dout = new DataOutputStream(bout);
        dout.writeBoolean(this.recent);
        dout.writeInt(this.id);
        dout.writeUTF(this.info.getName());
        dout.writeUTF(this.info.getTargetLanguage().getCode());
        dout.writeUTF(this.info.getSourceLanguage().getCode());
        dout.writeInt(this.info.getRate());
        dout.writeInt(this.info.getComplexity());
        dout.writeLong(this.info.getCreationDate().getTime());
        dout.writeUTF(this.info.getAuthor());
        dout.writeInt(this.info.getCategories().length);
        for (i = 0; i < this.info.getCategories().length; ++i) {
            dout.writeUTF(this.info.getCategories()[i]);
        }
        dout.writeInt(this.words.length);
        for (i = 0; i < this.words.length; ++i) {
            dout.writeUTF(this.words[i].getTranslation());
            dout.writeUTF(this.words[i].getTranscription());
            dout.writeUTF(this.words[i].getWord());
            Hashtable ex = this.words[i].getExercisesHashTable();
            Enumeration keys = ex.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                Boolean value = (Boolean)ex.get(key);
                dout.writeUTF(key);
                dout.writeBoolean(value);
            }
        }
        dout.close();
        return bout.toByteArray();
    }

    public void deserialize(byte[] data) throws IOException {
        DataInputStream din = new DataInputStream(new ByteArrayInputStream(data));
        this.recent = din.readBoolean();
        this.id = din.readInt();
        this.info = new DictionaryInfo();
        this.info.setName(din.readUTF());
        this.info.setTargetLanguage(Language.parse(din.readUTF()));
        this.info.setSourceLanguage(Language.parse(din.readUTF()));
        this.info.setRate(din.readInt());
        this.info.setComplexity(din.readInt());
        this.info.setCreationDate(new Date(din.readLong()));
        this.info.setAuthor(din.readUTF());
        int categoriesCount = din.readInt();
        String[] categories = new String[categoriesCount];
        for (int i = 0; i < categoriesCount; ++i) {
            categories[i] = din.readUTF();
        }
        this.info.setCategories(categories);
        int wordsCount = din.readInt();
        this.words = new Word[wordsCount];
        for (int i = 0; i < wordsCount; ++i) {
            this.words[i] = new Word();
            this.words[i].setTranslation(din.readUTF());
            this.words[i].setTranscription(din.readUTF());
            this.words[i].setWord(din.readUTF());
            for (int j = 0; j < 5; ++j) {
                String exId = din.readUTF();
                boolean exPassed = din.readBoolean();
                if (!exPassed) continue;
                this.words[i].addExercise(exId);
            }
        }
        din.close();
    }

    public void addListener(DictionaryChangeListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.addElement(listener);
        }
    }

    public int getStorageId() {
        return this.storageId;
    }

    public void setStorageId(int storageId) {
        this.storageId = storageId;
    }

    public void delete() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            DictionaryChangeListener lst = (DictionaryChangeListener)this.listeners.elementAt(i);
            lst.dictionaryDeleted(this);
        }
    }

    public int getLearntWordsCount() {
        int c = 0;
        if (this.words != null) {
            for (int i = 0; i < this.words.length; ++i) {
                if (!this.words[i].isLearnt()) continue;
                ++c;
            }
        }
        return c;
    }

    public int hashCode() {
        int hash = 1;
        hash = 31 * hash + this.id;
        hash = 31 * hash + this.storageId;
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Dictionary d = (Dictionary)obj;
        return this.id == d.getId() && this.storageId == d.getStorageId();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Dictionary: { id = ").append(this.id).append(", storageId = ").append(this.storageId).append(", recent = ").append(this.recent).append(", info = ").append(this.info).append(" }");
        return buf.toString();
    }
}

