/*
 * Decompiled with CFR 0.152.
 */
package com.wordsteps.persistence;

import com.sun.lwuit.plaf.UIManager;
import com.wordsteps.WordSteps;
import com.wordsteps.model.Language;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;

public class Configuration {
    public static final String STORAGE_ID = "conf_storage";
    private static final Configuration instance = new Configuration();
    private boolean firstTime = true;
    private boolean notifyUpdates = true;
    private boolean useLastLanguages = false;
    private Language defaultSourceLanguage = Language.EN;
    private Language defaultTargetLanguage = Language.ES;
    private Language lastSourceLanguage = Language.EN;
    private Language lastTargetLanguage = Language.ES;
    private Language uiLanguage = Language.EN;
    private boolean isReverseSoftButtons = false;
    private int recordId = -1;
    private String midletVersion = "1.0.0";

    private Configuration() {
        this.loadConfiguration();
        this.midletVersion = WordSteps.getInstance().getAppProperty("MIDlet-Version");
        if (this.isFirstTime()) {
            this.defaultSourceLanguage = Language.parse(WordSteps.getInstance().getAppProperty("defaultSourceLanguage"));
            this.defaultTargetLanguage = Language.parse(WordSteps.getInstance().getAppProperty("defaultTargetLanguage"));
            this.uiLanguage = Language.parse(WordSteps.getInstance().getAppProperty("uiLanguage"));
            UIManager.getInstance().setResourceBundle(WordSteps.getInstance().getResources().getL10N("localization", this.uiLanguage.getCode()));
        }
    }

    public static Configuration getInstance() {
        return instance;
    }

    private void loadConfiguration() {
        try {
            RecordStore rs = RecordStore.openRecordStore((String)STORAGE_ID, (boolean)true);
            RecordEnumeration e = rs.enumerateRecords(null, null, true);
            if (e.hasNextElement()) {
                this.recordId = e.nextRecordId();
                DataInputStream in = new DataInputStream(new ByteArrayInputStream(rs.getRecord(this.recordId)));
                this.firstTime = in.readBoolean();
                this.notifyUpdates = in.readBoolean();
                this.useLastLanguages = in.readBoolean();
                this.defaultSourceLanguage = Language.parse(in.readUTF());
                this.defaultTargetLanguage = Language.parse(in.readUTF());
                this.setLastSourceLanguage(Language.parse(in.readUTF()));
                this.setLastTargetLanguage(Language.parse(in.readUTF()));
                this.uiLanguage = Language.parse(in.readUTF());
                this.isReverseSoftButtons = in.readBoolean();
                UIManager.getInstance().getLookAndFeel().setReverseSoftButtons(this.isReverseSoftButtons);
                UIManager.getInstance().setResourceBundle(WordSteps.getInstance().getResources().getL10N("localization", this.uiLanguage.getCode()));
                in.close();
            }
            rs.closeRecordStore();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void saveConfiguration() {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            DataOutputStream dout = new DataOutputStream(out);
            dout.writeBoolean(this.firstTime);
            dout.writeBoolean(this.notifyUpdates);
            dout.writeBoolean(this.useLastLanguages);
            dout.writeUTF(this.defaultSourceLanguage.getCode());
            dout.writeUTF(this.defaultTargetLanguage.getCode());
            dout.writeUTF(this.getLastSourceLanguage().getCode());
            dout.writeUTF(this.getLastTargetLanguage().getCode());
            dout.writeUTF(this.uiLanguage.getCode());
            dout.writeBoolean(this.isReverseSoftButtons);
            dout.close();
            RecordStore rs = RecordStore.openRecordStore((String)STORAGE_ID, (boolean)true);
            byte[] data = out.toByteArray();
            if (this.recordId != -1) {
                rs.setRecord(this.recordId, data, 0, data.length);
            } else {
                this.recordId = rs.addRecord(data, 0, data.length);
            }
            rs.closeRecordStore();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public final boolean isFirstTime() {
        return this.firstTime;
    }

    public void setFirstTime(boolean firstTime) {
        this.firstTime = firstTime;
        this.saveConfiguration();
    }

    public boolean isNotifyUpdates() {
        return this.notifyUpdates;
    }

    public void setNotifyUpdates(boolean notifyUpdates) {
        this.notifyUpdates = notifyUpdates;
        this.saveConfiguration();
    }

    public boolean isUseLastLanguages() {
        return this.useLastLanguages;
    }

    public void setUseLastLanguages(boolean useLastLanguages) {
        this.useLastLanguages = useLastLanguages;
        this.saveConfiguration();
    }

    public Language getDefaultSourceLanguage() {
        return this.defaultSourceLanguage;
    }

    public void setDefaultSourceLanguage(Language defaultSourceLanguage) {
        this.defaultSourceLanguage = defaultSourceLanguage;
        this.saveConfiguration();
    }

    public Language getDefaultTargetLanguage() {
        return this.defaultTargetLanguage;
    }

    public void setDefaultTargetLanguage(Language defaultTargetLanguage) {
        this.defaultTargetLanguage = defaultTargetLanguage;
        this.saveConfiguration();
    }

    public Language getLastSourceLanguage() {
        return this.lastSourceLanguage;
    }

    public void setLastSourceLanguage(Language lastSourceLanguage) {
        this.lastSourceLanguage = lastSourceLanguage;
    }

    public Language getLastTargetLanguage() {
        return this.lastTargetLanguage;
    }

    public void setLastTargetLanguage(Language lastTargetLanguage) {
        this.lastTargetLanguage = lastTargetLanguage;
    }

    public Language getUiLanguage() {
        return this.uiLanguage;
    }

    public void setUiLanguage(Language uiLanguage) {
        this.uiLanguage = uiLanguage;
        UIManager.getInstance().setResourceBundle(WordSteps.getInstance().getResources().getL10N("localization", uiLanguage.getCode()));
        this.saveConfiguration();
    }

    public boolean isReverseSoftButtons() {
        return this.isReverseSoftButtons;
    }

    public void setReverseSoftButtons(boolean isReverseSoftButtons) {
        this.isReverseSoftButtons = isReverseSoftButtons;
        this.saveConfiguration();
    }

    public String getMidletVersion() {
        return this.midletVersion;
    }
}

