/*
 * Decompiled with CFR 0.152.
 */
package com.wordsteps.persistence;

import com.wordsteps.model.Dictionary;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;

public class PersistenceManager {
    private static final String RS_ID = "rs-dic";

    public static Dictionary[] loadDictionaties() {
        try {
            RecordStore rs = RecordStore.openRecordStore((String)RS_ID, (boolean)true);
            RecordEnumeration recordEnum = rs.enumerateRecords(null, null, true);
            Dictionary[] dics = new Dictionary[rs.getNumRecords()];
            int i = 0;
            while (recordEnum.hasNextElement()) {
                Dictionary d = new Dictionary();
                int recordId = recordEnum.nextRecordId();
                d.deserialize(rs.getRecord(recordId));
                d.setStorageId(recordId);
                dics[i] = d;
                ++i;
            }
            rs.closeRecordStore();
            return dics;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static int getDictionariesCount() {
        try {
            RecordStore rs = RecordStore.openRecordStore((String)RS_ID, (boolean)true);
            int count = rs.getNumRecords();
            rs.closeRecordStore();
            return count;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return -1;
        }
    }

    public static void saveDictionary(Dictionary dic) {
        try {
            RecordStore rs = RecordStore.openRecordStore((String)RS_ID, (boolean)true);
            byte[] data = dic.serialize();
            dic.setStorageId(rs.addRecord(data, 0, data.length));
            rs.closeRecordStore();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void removeDictionary(int storageId) {
        try {
            RecordStore.openRecordStore((String)RS_ID, (boolean)true).deleteRecord(storageId);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void updateDictionary(Dictionary dic) {
        try {
            RecordStore rs = RecordStore.openRecordStore((String)RS_ID, (boolean)true);
            byte[] data = dic.serialize();
            rs.setRecord(dic.getStorageId(), data, 0, data.length);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static String _toString() {
        StringBuffer buf = new StringBuffer();
        Dictionary[] d = PersistenceManager.loadDictionaties();
        for (int i = 0; i < d.length; ++i) {
            buf.append("[").append(i + 1).append(": ").append(d[i].toString());
            if (i < d.length - 1) {
                buf.append("\n");
                continue;
            }
            buf.append("]");
        }
        return buf.toString();
    }
}

