/*
 * Decompiled with CFR 0.152.
 */
package com.wordsteps.ui.screen;

import com.sun.lwuit.Command;
import com.sun.lwuit.Form;
import com.sun.lwuit.Image;
import com.sun.lwuit.List;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.layouts.BoxLayout;
import com.sun.lwuit.list.DefaultListModel;
import com.sun.lwuit.plaf.UIManager;
import com.wordsteps.model.Dictionary;
import com.wordsteps.model.DictionaryChangeListener;
import com.wordsteps.model.DictionarySelectionProvider;
import com.wordsteps.ui.common.Constants;
import com.wordsteps.ui.common.commands.BackCommand;
import com.wordsteps.ui.common.commands.DeleteCommand;
import com.wordsteps.ui.common.renderers.DictionaryListCellRenderer;
import com.wordsteps.ui.screen.PreviewScreenForm;
import com.wordsteps.ui.screen.ScreenForm;
import com.wordsteps.ui.util.ImageRegistry;

public class DictionaryListScreenForm
extends ScreenForm
implements ActionListener,
DictionarySelectionProvider,
DictionaryChangeListener {
    private static final String IMAGE_ID = "list";
    protected List dictionaryList = new List(){

        protected boolean isSelectableInteraction() {
            return false;
        }
    };
    private Command backCommand;
    private Command deleteCommand;
    private Command previewCommand;

    public DictionaryListScreenForm(Form prevForm) {
        super(prevForm);
        this.dictionaryList.setIgnoreFocusComponentWhenUnfocused(true);
        this.setScrollable(false);
        this.setLayout(new BoxLayout(2));
        this.createComponents();
        this.createDictionaryList();
        this.createCommands();
    }

    protected void createComponents() {
    }

    private void createDictionaryList() {
        this.dictionaryList.setListCellRenderer(new DictionaryListCellRenderer());
        this.dictionaryList.addActionListener(this);
        this.addComponent(this.dictionaryList);
    }

    public void createCommands() {
        this.backCommand = new BackCommand(this.getPreviousScreenForm());
        this.deleteCommand = new DeleteCommand(this);
        this.previewCommand = new Command(UIManager.getInstance().localize("command.preview", "[NULL]")){

            public void actionPerformed(ActionEvent evt) {
                PreviewScreenForm form = new PreviewScreenForm(DictionaryListScreenForm.this);
                form.setDictionary(DictionaryListScreenForm.this.getSelectedDictionary());
                form.show();
            }
        };
        this.addCommand(this.backCommand, 0);
        this.addCommand(this.deleteCommand, 1);
        this.addCommand(this.previewCommand, 2);
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() instanceof List) {
            this.previewCommand.actionPerformed(evt);
        }
    }

    public void setDictionaries(Dictionary[] dictionaries) {
        this.dictionaryList.setModel(new DefaultListModel(dictionaries));
        this.updateCommands();
    }

    public Image getImage() {
        return ImageRegistry.getImage(IMAGE_ID);
    }

    public String getName() {
        return "new.dictionaries.title";
    }

    public String getShortName() {
        return "dictionaries.title";
    }

    public Dictionary getSelectedDictionary() {
        Dictionary selection = (Dictionary)this.dictionaryList.getSelectedItem();
        if (selection != null) {
            selection.addListener(this);
        }
        return selection;
    }

    public void dictionaryUpdated(Dictionary dic) {
    }

    public void dictionaryDeleted(Dictionary dic) {
        this.dictionaryList.getModel().removeItem(this.dictionaryList.getSelectedIndex());
        this.updateCommands();
    }

    public void initState() {
        this.setFocused(this.dictionaryList);
    }

    public void show() {
        this.initState();
        super.show();
    }

    protected void updateCommands() {
        if (this.dictionaryList.getModel().getSize() == 0) {
            if (this.getCommandCount() > 1) {
                this.removeAllCommands();
                this.addCommand(this.backCommand, 0);
                this.addCommand(Constants.NULL_COMMAND_0, 1);
                this.addCommand(Constants.NULL_COMMAND_1, 2);
            }
        } else {
            boolean isFound = false;
            for (int i = 0; i < this.getCommandCount(); ++i) {
                Command cmd = this.getCommand(i);
                if (!this.previewCommand.equals(cmd) && !this.deleteCommand.equals(cmd)) continue;
                isFound = true;
                break;
            }
            if (!isFound) {
                this.removeCommand(Constants.NULL_COMMAND_1);
                this.removeCommand(Constants.NULL_COMMAND_0);
                this.addCommand(this.deleteCommand, 1);
                this.addCommand(this.previewCommand, 2);
            }
        }
    }
}

