/*
 * Decompiled with CFR 0.152.
 */
package com.wordsteps.ui.screen.exercise;

import com.sun.lwuit.Command;
import com.sun.lwuit.Display;
import com.sun.lwuit.Label;
import com.sun.lwuit.List;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.layouts.BoxLayout;
import com.sun.lwuit.list.DefaultListModel;
import com.sun.lwuit.plaf.Border;
import com.sun.lwuit.plaf.UIManager;
import com.wordsteps.model.exercise.Exercise;
import com.wordsteps.model.exercise.tasks.StatefulSelection;
import com.wordsteps.model.exercise.tasks.Task;
import com.wordsteps.ui.common.Constants;
import com.wordsteps.ui.common.UIProfile;
import com.wordsteps.ui.common.renderers.SelectionExerciseListCellRenderer;
import com.wordsteps.ui.screen.exercise.ExerciseForm;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;

public class SelectionExerciseForm
extends ExerciseForm
implements ActionListener {
    private Label sourceWord = new Label("");
    private List targetWords;

    public SelectionExerciseForm(Exercise exercise) {
        super(exercise);
        this.sourceWord.setAlignment(4);
        this.sourceWord.getStyle().setBgColor(15333118);
        this.sourceWord.getStyle().setBorder(Border.createRoundBorder(15, 15, 12508914));
        UIProfile.applyFont(this.sourceWord.getStyle(), "exercise.statement.font");
        UIProfile.applyPadding(this.sourceWord.getStyle(), "exercise.statement.padding");
        this.targetWords = new List();
        this.targetWords.setIgnoreFocusComponentWhenUnfocused(true);
        this.targetWords.setListCellRenderer(new SelectionExerciseListCellRenderer());
        this.targetWords.setSelectCommandText(UIManager.getInstance().localize("command.select", "[NULL]"));
        this.setLayout(new BoxLayout(2));
        this.createComponents();
        this.createCommands();
    }

    private void createComponents() {
        this.targetWords.addActionListener(this);
        this.addComponent(this.getDescriptionComponent());
        this.addComponent(this.sourceWord);
        this.addComponent(this.targetWords);
    }

    public void createCommands() {
        this.addCommand(new Command("command.back", 1){

            public void actionPerformed(ActionEvent evt) {
                if (SelectionExerciseForm.this.getPreviousScreenForm() != null) {
                    SelectionExerciseForm.this.getPreviousScreenForm().show();
                }
            }
        }, 0);
        this.addCommand(Constants.NULL_COMMAND_0, 1);
    }

    protected void initState() {
        this.currentTask = 0;
        for (int i = 0; i < this.tasks.length; ++i) {
            this.tasks[i].setInput(null);
        }
    }

    protected void displayCurrentState() {
        super.displayCurrentState();
        Vector statement = (Vector)this.tasks[this.currentTask].getStatement();
        this.sourceWord.setText((String)statement.elementAt(0));
        Object[] answers = new StatefulSelection[statement.size() - 1];
        for (int i = 1; i < statement.size(); ++i) {
            answers[i - 1] = (StatefulSelection)statement.elementAt(i);
        }
        this.targetWords.setModel(new DefaultListModel(answers));
        this.targetWords.setFocus(true);
    }

    protected void checkInput(Object input) {
        Task task = this.tasks[this.currentTask];
        task.setInput(input);
        if (task.check()) {
            ((StatefulSelection)input).setStatus(1);
            this.targetWords.removeActionListener(this);
            Timer timer = new Timer();
            timer.schedule((TimerTask)new NextTaskTimerTask(timer), 500L);
        } else {
            ((StatefulSelection)input).setStatus(2);
        }
    }

    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() instanceof List) {
            this.checkInput(((List)ae.getSource()).getSelectedItem());
        }
    }

    class NextTaskTimerTask
    extends TimerTask {
        private Timer timer;

        public NextTaskTimerTask(Timer timer) {
            this.timer = timer;
        }

        public void run() {
            Display.getInstance().callSerially(new Runnable(){

                public void run() {
                    SelectionExerciseForm.this.targetWords.addActionListener(SelectionExerciseForm.this);
                    SelectionExerciseForm.this.nextTask();
                }
            });
            this.timer.cancel();
        }
    }
}

