/*
 * Decompiled with CFR 0.152.
 */
package org.ksoap2.serialization;

import java.util.Hashtable;
import java.util.Vector;
import org.ksoap2.serialization.KvmSerializable;
import org.ksoap2.serialization.PropertyInfo;

public class SoapObject
implements KvmSerializable {
    String namespace;
    String name;
    Vector info = new Vector();
    Vector data = new Vector();

    public SoapObject(String string, String string2) {
        this.namespace = string;
        this.name = string2;
    }

    public boolean equals(Object object) {
        if (!(object instanceof SoapObject)) {
            return false;
        }
        SoapObject soapObject = (SoapObject)object;
        int n = this.data.size();
        if (n != soapObject.data.size()) {
            return false;
        }
        try {
            for (int i = 0; i < n; ++i) {
                if (this.data.elementAt(i).equals(soapObject.getProperty(((PropertyInfo)this.info.elementAt((int)i)).name))) continue;
                return false;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public String getName() {
        return this.name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Object getProperty(int n) {
        return this.data.elementAt(n);
    }

    public Object getProperty(String string) {
        for (int i = 0; i < this.data.size(); ++i) {
            if (!string.equals(((PropertyInfo)this.info.elementAt((int)i)).name)) continue;
            return this.data.elementAt(i);
        }
        throw new RuntimeException("illegal property: " + string);
    }

    public int getPropertyCount() {
        return this.data.size();
    }

    public void getPropertyInfo(int n, Hashtable hashtable, PropertyInfo propertyInfo) {
        PropertyInfo propertyInfo2 = (PropertyInfo)this.info.elementAt(n);
        propertyInfo.name = propertyInfo2.name;
        propertyInfo.namespace = propertyInfo2.namespace;
        propertyInfo.flags = propertyInfo2.flags;
        propertyInfo.type = propertyInfo2.type;
        propertyInfo.elementType = propertyInfo2.elementType;
    }

    public SoapObject newInstance() {
        SoapObject soapObject = new SoapObject(this.namespace, this.name);
        for (int i = 0; i < this.data.size(); ++i) {
            PropertyInfo propertyInfo = (PropertyInfo)this.info.elementAt(i);
            soapObject.addProperty(propertyInfo, this.data.elementAt(i));
        }
        return soapObject;
    }

    public void setProperty(int n, Object object) {
        this.data.setElementAt(object, n);
    }

    public SoapObject addProperty(String string, Object object) {
        PropertyInfo propertyInfo = new PropertyInfo();
        propertyInfo.name = string;
        propertyInfo.type = object == null ? PropertyInfo.OBJECT_CLASS : object.getClass();
        return this.addProperty(propertyInfo, object);
    }

    public SoapObject addProperty(PropertyInfo propertyInfo, Object object) {
        this.info.addElement(propertyInfo);
        this.data.addElement(object);
        return this;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("" + this.name + "{");
        for (int i = 0; i < this.getPropertyCount(); ++i) {
            stringBuffer.append("" + ((PropertyInfo)this.info.elementAt((int)i)).name + "=" + this.getProperty(i) + "; ");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }
}

