/*
 * Decompiled with CFR 0.152.
 */
package com.wordsteps.model.exercise;

import com.wordsteps.model.Dictionary;
import com.wordsteps.model.DictionaryChangeListener;
import com.wordsteps.model.exercise.tasks.Task;

public abstract class Exercise {
    private Dictionary dictionary;
    private String id;
    private String name;
    private String details;
    private DictionaryChangeListener dictionaryListener;

    public Exercise(String id, String name, String details) {
        this.id = id;
        this.name = name;
        this.details = details;
    }

    public abstract Task[] getTasks();

    public Dictionary getDictionary() {
        return this.dictionary;
    }

    public void setDictionary(Dictionary dictionary) {
        this.dictionary = dictionary;
        if (this.dictionaryListener != null) {
            this.dictionaryListener.dictionaryUpdated(dictionary);
        }
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDetails() {
        return this.details;
    }

    public void setDictionaryListener(DictionaryChangeListener dictionaryListener) {
        this.dictionaryListener = dictionaryListener;
    }
}

