/*
 * Decompiled with CFR 0.152.
 */
package com.wordsteps.ui.common.renderers;

import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Label;
import com.sun.lwuit.List;
import com.sun.lwuit.layouts.BorderLayout;
import com.sun.lwuit.layouts.BoxLayout;
import com.sun.lwuit.list.ListCellRenderer;
import com.sun.lwuit.plaf.UIManager;
import com.wordsteps.model.Dictionary;
import com.wordsteps.ui.common.TickerListLabel;
import com.wordsteps.ui.common.TransparentLabel;
import com.wordsteps.ui.common.UIProfile;
import com.wordsteps.ui.util.ImageRegistry;

public class DictionaryListCellRenderer
implements ListCellRenderer {
    private DictionaryListCellRenderer selectedRenderer;
    private TickerListLabel dicName = new TickerListLabel("");
    private TransparentLabel dictStatus;
    private TransparentLabel srcLang;
    private TransparentLabel dstLang;
    private Container bottom;
    private Container langPair;
    private Container container;
    private Label focus;

    public DictionaryListCellRenderer() {
        UIProfile.applyFont(this.dicName.getStyle(), "dictionaries.dicname.font");
        this.dictStatus = new TransparentLabel("");
        UIProfile.applyFont(this.dictStatus.getStyle(), "dictionaries.status.font");
        this.srcLang = new TransparentLabel("");
        this.dstLang = new TransparentLabel("");
        this.bottom = new Container(new BorderLayout());
        this.langPair = new Container(new BoxLayout(1));
        this.container = new Container(new BoxLayout(2));
        this.focus = new Label("");
        this.dicName.setAlignment(1);
        this.langPair.addComponent(this.srcLang);
        this.langPair.addComponent(new TransparentLabel("\u2192"));
        this.langPair.addComponent(this.dstLang);
        this.bottom.addComponent("Center", (Component)this.langPair);
        this.bottom.addComponent("East", (Component)this.dictStatus);
        this.container.addComponent(this.dicName);
        this.container.addComponent(this.bottom);
        this.container.addComponent(new TransparentLabel(ImageRegistry.getImage("word-list.separator")));
        this.focus.getStyle().setBgColor(14608594);
    }

    public Component getListCellRendererComponent(List list, Object value, int index, boolean isSelected) {
        Dictionary dic = (Dictionary)value;
        this.dicName.setText(dic.getInfo().getName());
        this.srcLang.setIcon(ImageRegistry.getImage(dic.getInfo().getSourceLanguage().getCode()));
        this.dstLang.setIcon(ImageRegistry.getImage(dic.getInfo().getTargetLanguage().getCode()));
        int wc = dic.getWords().length;
        int lw = dic.getLearntWordsCount();
        StringBuffer text = new StringBuffer(UIManager.getInstance().localize("dictionaries.learnt", "[NULL]"));
        text.append(' ').append(lw).append(' ').append(UIManager.getInstance().localize("dictionaries.of", "[NULL]"));
        text.append(' ').append(wc);
        this.dictStatus.setText(text.toString());
        if (isSelected) {
            DictionaryListCellRenderer renderer = this.getSelectedRenderer();
            if (index == list.getSelectedIndex() && list.hasFocus()) {
                renderer.getListCellRendererComponent(list, value, index, false);
                renderer.dicName.checkAnimation(list);
                return renderer.container;
            }
        }
        return this.container;
    }

    public Component getListFocusComponent(List list) {
        return this.focus;
    }

    public DictionaryListCellRenderer getSelectedRenderer() {
        if (this.selectedRenderer == null) {
            this.selectedRenderer = new DictionaryListCellRenderer();
        }
        return this.selectedRenderer;
    }
}

