/*
 * Decompiled with CFR 0.152.
 */
package com.wordsteps.ui.screen;

import com.sun.lwuit.CheckBox;
import com.sun.lwuit.ComboBox;
import com.sun.lwuit.Command;
import com.sun.lwuit.Form;
import com.sun.lwuit.Image;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.layouts.BoxLayout;
import com.sun.lwuit.plaf.LookAndFeel;
import com.sun.lwuit.plaf.UIManager;
import com.wordsteps.model.Language;
import com.wordsteps.persistence.Configuration;
import com.wordsteps.ui.common.TransparentLabel;
import com.wordsteps.ui.common.UIProfile;
import com.wordsteps.ui.common.commands.BackCommand;
import com.wordsteps.ui.common.renderers.ChooseLanguageListCellRenderer;
import com.wordsteps.ui.dialogs.CustomDialog;
import com.wordsteps.ui.screen.MainScreenForm;
import com.wordsteps.ui.screen.ScreenForm;
import com.wordsteps.ui.screen.exercise.ExerciseFormBundle;
import com.wordsteps.ui.util.ImageRegistry;

public class SettingsScreenForm
extends ScreenForm {
    private static final String IMAGE_ID = "settings";
    private ComboBox uiLanguage = new ComboBox(new Object[]{Language.EN, Language.RU});
    private CheckBox reverseSoftButtons;
    private Language oldUILanguage;
    private boolean isReverseSoftButtons;

    public SettingsScreenForm(Form prevForm) {
        super(prevForm);
        this.uiLanguage.setListCellRenderer(new ChooseLanguageListCellRenderer());
        this.uiLanguage.getSelectedStyle().setBgColor(14608594);
        UIProfile.applyFont(this.uiLanguage.getUnselectedStyle(), "settings.control.font");
        UIProfile.applyFont(this.uiLanguage.getSelectedStyle(), "settings.control.font");
        this.reverseSoftButtons = new CheckBox("settings.reverse.buttons");
        this.reverseSoftButtons.getSelectedStyle().setBgColor(14608594);
        UIProfile.applyFont(this.reverseSoftButtons.getUnselectedStyle(), "settings.control.font");
        UIProfile.applyFont(this.reverseSoftButtons.getSelectedStyle(), "settings.control.font");
        TransparentLabel title = new TransparentLabel("settings.title");
        title.setAlignment(4);
        title.setStyle(this.getTitleStyle());
        this.setTitleComponent(title);
        this.setLayout(new BoxLayout(2));
        this.createComponents();
        this.createCommands();
    }

    private void createComponents() {
        TransparentLabel uiLangLabel = new TransparentLabel("settings.interfacelanguage");
        UIProfile.applyFont(uiLangLabel.getStyle(), "settings.label.font");
        this.addComponent(uiLangLabel);
        this.addComponent(this.uiLanguage);
        this.addComponent(new TransparentLabel(ImageRegistry.getImage("word-list.separator")));
        this.addComponent(this.reverseSoftButtons);
    }

    protected void onShow() {
        Configuration conf = Configuration.getInstance();
        this.oldUILanguage = conf.getUiLanguage();
        this.uiLanguage.setSelectedItem(this.oldUILanguage);
        this.isReverseSoftButtons = conf.isReverseSoftButtons();
        this.reverseSoftButtons.setSelected(this.isReverseSoftButtons);
    }

    public void createCommands() {
        this.addCommand(new BackCommand(this.getPreviousScreenForm()), 0);
        this.addCommand(new Command("command.save", 11){

            public void actionPerformed(ActionEvent evt) {
                Configuration conf = Configuration.getInstance();
                if (!SettingsScreenForm.this.oldUILanguage.equals(SettingsScreenForm.this.uiLanguage.getSelectedItem()) || SettingsScreenForm.this.isReverseSoftButtons != SettingsScreenForm.this.reverseSoftButtons.isSelected()) {
                    CustomDialog.show("dialog.information", UIManager.getInstance().localize("settings.localization.changed", "[NULL]"));
                    conf.setUiLanguage((Language)SettingsScreenForm.this.uiLanguage.getSelectedItem());
                    conf.setReverseSoftButtons(SettingsScreenForm.this.reverseSoftButtons.isSelected());
                    LookAndFeel laf = UIManager.getInstance().getLookAndFeel();
                    laf.setReverseSoftButtons(SettingsScreenForm.this.reverseSoftButtons.isSelected());
                    ExerciseFormBundle.getInstance().reload();
                    new MainScreenForm().show();
                    return;
                }
                Form prevForm = SettingsScreenForm.this.getPreviousScreenForm();
                if (prevForm != null) {
                    prevForm.show();
                }
            }
        }, 1);
    }

    public String getName() {
        return "settings.title";
    }

    public String getShortName() {
        return UIManager.getInstance().localize("settings.title", "[NULL]");
    }

    public void actionPerformed(ActionEvent evt) {
    }

    public Image getImage() {
        return ImageRegistry.getImage(IMAGE_ID);
    }
}

