/*
 * Decompiled with CFR 0.152.
 */
package org.ksoap2.transport;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import org.ksoap2.SoapEnvelope;
import org.ksoap2.SoapFault;
import org.ksoap2.transport.ServiceConnection;
import org.ksoap2.transport.ServiceConnectionMidp;
import org.ksoap2.transport.Transport;
import org.xmlpull.v1.XmlPullParserException;

public class HttpTransport
extends Transport {
    ServiceConnection connection;
    OutputStream os;
    InputStream is;
    private boolean connected = false;

    public HttpTransport(String string) {
        super(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void call(String string, SoapEnvelope soapEnvelope) throws IOException, XmlPullParserException {
        if (string == null) {
            string = "\"\"";
        }
        byte[] byArray = this.createRequestData(soapEnvelope);
        this.requestDump = this.debug ? new String(byArray) : null;
        this.responseDump = null;
        try {
            this.connected = true;
            this.connection = this.getServiceConnection();
            this.connection.setRequestProperty("SOAPAction", string);
            this.connection.setRequestProperty("Content-Type", "text/xml");
            this.connection.setRequestProperty("Content-Length", "" + byArray.length);
            this.connection.setRequestProperty("User-Agent", "kSOAP/2.0");
            this.connection.setRequestMethod("POST");
            this.os = this.connection.openOutputStream();
            this.os.write(byArray, 0, byArray.length);
            this.os.close();
            byArray = null;
            this.is = this.connection.openInputStream();
            if (this.debug) {
                int n;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byte[] byArray2 = new byte[256];
                while ((n = this.is.read(byArray2, 0, 256)) != -1) {
                    byteArrayOutputStream.write(byArray2, 0, n);
                }
                byteArrayOutputStream.flush();
                byArray2 = byteArrayOutputStream.toByteArray();
                this.responseDump = new String(byArray2);
                this.is.close();
                this.is = new ByteArrayInputStream(byArray2);
            }
            this.parseResponse(soapEnvelope, this.is);
        }
        finally {
            if (!this.connected) {
                throw new InterruptedIOException();
            }
            this.reset();
        }
        if (soapEnvelope.bodyIn instanceof SoapFault) {
            throw (SoapFault)soapEnvelope.bodyIn;
        }
    }

    public void reset() {
        this.connected = false;
        if (this.is != null) {
            try {
                this.is.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.is = null;
        }
        if (this.connection != null) {
            try {
                this.connection.disconnect();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.connection = null;
        }
    }

    protected ServiceConnection getServiceConnection() throws IOException {
        return new ServiceConnectionMidp(this.url);
    }
}

