/*
 * Decompiled with CFR 0.152.
 */
package InneractiveSDK;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.lcdui.Image;

class IAGifDecoder {
    protected static final int STATUS_OK = 0;
    protected static final int STATUS_FORMAT_ERROR = 1;
    protected static final int STATUS_OPEN_ERROR = 2;
    protected DataInputStream in;
    protected int status;
    protected int width;
    protected int height;
    protected boolean gctFlag;
    protected int gctSize;
    protected int loopCount = 1;
    protected int[] gct;
    protected int[] lct;
    protected int[] act;
    protected int bgIndex;
    protected int bgColor;
    protected int lastBgColor;
    protected int pixelAspect;
    protected boolean lctFlag;
    protected boolean interlace;
    protected int lctSize;
    protected int ix;
    protected int iy;
    protected int iw;
    protected int ih;
    protected int lx;
    protected int ly;
    protected int lw;
    protected int lh;
    protected static Image imageData;
    protected static Image lastImage;
    protected byte[] block = new byte[256];
    protected int blockSize = 0;
    protected int dispose = 0;
    protected int lastDispose = 0;
    protected boolean transparency = false;
    protected int delay = 0;
    protected int transIndex;
    protected static final int MaxStackSize = 4096;
    protected short[] prefix;
    protected byte[] suffix;
    protected byte[] pixelStack;
    protected byte[] pixels;
    protected int[] dest;
    protected int[] prev;
    protected Vector frames;
    protected int frameCount;

    IAGifDecoder() {
    }

    protected int getDelay(int n) {
        this.delay = -1;
        if (n >= 0 && n < this.frameCount) {
            this.delay = ((GifFrame)this.frames.elementAt((int)n)).delay;
        }
        return this.delay;
    }

    protected int getFrameCount() {
        return this.frameCount;
    }

    protected Image getImage() {
        return this.getFrame(0);
    }

    protected int getLoopCount() {
        return this.loopCount;
    }

    protected void setPixels() {
        int n;
        int n2;
        int n3;
        int n4;
        try {
            this.dest = new int[this.width * this.height];
            imageData.getRGB(this.dest, 0, this.width, 0, 0, this.width, this.height);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.lastDispose > 0) {
            if (this.lastDispose == 3) {
                int n5 = this.frameCount - 2;
                lastImage = n5 > 0 ? this.getFrame(n5 - 1) : null;
            }
            if (lastImage != null) {
                try {
                    this.prev = new int[this.width * this.height];
                    lastImage.getRGB(this.prev, 0, this.width, 0, 0, this.width, this.height);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                System.arraycopy(this.prev, 0, this.dest, 0, this.width * this.height);
                if (this.lastDispose == 2) {
                    int n6 = 0;
                    if (!this.transparency) {
                        n6 = this.lastBgColor;
                    }
                    for (n4 = 0; n4 < this.lh; ++n4) {
                        n3 = (this.ly + n4) * this.width + this.lx;
                        n2 = n3 + this.lw;
                        for (n = n3; n < n2; ++n) {
                            this.dest[n] = n6;
                        }
                    }
                }
            }
        }
        int n7 = 1;
        n4 = 8;
        n3 = 0;
        for (n2 = 0; n2 < this.ih; ++n2) {
            n = n2;
            if (this.interlace) {
                if (n3 >= this.ih) {
                    switch (++n7) {
                        case 2: {
                            n3 = 4;
                            break;
                        }
                        case 3: {
                            n3 = 2;
                            n4 = 4;
                            break;
                        }
                        case 4: {
                            n3 = 1;
                            n4 = 2;
                        }
                    }
                }
                n = n3;
                n3 += n4;
            }
            if ((n += this.iy) >= this.height) continue;
            int n8 = n * this.width;
            int n9 = n8 + this.ix;
            int n10 = n9 + this.iw;
            if (n8 + this.width < n10) {
                n10 = n8 + this.width;
            }
            int n11 = n2 * this.iw;
            while (n9 < n10) {
                int n12;
                int n13;
                if ((n13 = this.act[n12 = this.pixels[n11++] & 0xFF]) != 0) {
                    this.dest[n9] = n13;
                }
                ++n9;
            }
        }
        imageData = Image.createRGBImage((int[])this.dest, (int)this.width, (int)this.height, (boolean)false);
    }

    protected Image getFrame(int n) {
        Image image = null;
        if (n >= 0 && n < this.frameCount) {
            image = ((GifFrame)this.frames.elementAt((int)n)).image;
        }
        return image;
    }

    protected int read(DataInputStream dataInputStream) {
        this.init();
        if (dataInputStream != null) {
            this.in = dataInputStream;
            this.readHeader();
            if (!this.err()) {
                this.readContents();
                if (this.frameCount < 0) {
                    this.status = 1;
                }
            }
        } else {
            this.status = 2;
        }
        try {
            if (null != dataInputStream) {
                dataInputStream.close();
                dataInputStream = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.status;
    }

    protected int read(InputStream inputStream) {
        this.init();
        if (inputStream != null) {
            if (!(inputStream instanceof DataInputStream)) {
                this.in = new DataInputStream(inputStream);
            }
            this.readHeader();
            if (!this.err()) {
                this.readContents();
                if (this.frameCount < 0) {
                    this.status = 1;
                }
            }
        } else {
            this.status = 2;
        }
        try {
            if (null != inputStream) {
                inputStream.close();
                this.in.close();
                inputStream = null;
                this.in = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int read(String string) {
        this.status = 0;
        try {
            InputStream inputStream = this.getClass().getResourceAsStream(string);
            this.status = this.read(inputStream);
        }
        catch (Exception exception) {
            this.status = 2;
        }
        finally {
            if (null != this.in) {
                try {
                    this.in.close();
                    this.in = null;
                }
                catch (Exception exception) {}
            }
        }
        return this.status;
    }

    protected void decodeImageData() {
        int n;
        int n2 = -1;
        int n3 = this.iw * this.ih;
        if (this.pixels == null || this.pixels.length < n3) {
            this.pixels = new byte[n3];
        }
        if (this.prefix == null) {
            this.prefix = new short[4096];
        }
        if (this.suffix == null) {
            this.suffix = new byte[4096];
        }
        if (this.pixelStack == null) {
            this.pixelStack = new byte[4097];
        }
        int n4 = this.read();
        int n5 = 1 << n4;
        int n6 = n5 + 1;
        int n7 = n5 + 2;
        int n8 = n2;
        int n9 = n4 + 1;
        int n10 = (1 << n9) - 1;
        for (n = 0; n < n5; ++n) {
            this.prefix[n] = 0;
            this.suffix[n] = (byte)n;
        }
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        int n15 = 0;
        int n16 = 0;
        int n17 = 0;
        int n18 = 0;
        while (n18 < n3) {
            if (n13 == 0) {
                if (n16 < n9) {
                    if (n15 == 0) {
                        n15 = this.readBlock();
                        if (n15 <= 0) break;
                        n11 = 0;
                    }
                    n17 += (this.block[n11] & 0xFF) << n16;
                    n16 += 8;
                    ++n11;
                    --n15;
                    continue;
                }
                n = n17 & n10;
                n17 >>= n9;
                n16 -= n9;
                if (n > n7 || n == n6) break;
                if (n == n5) {
                    n9 = n4 + 1;
                    n10 = (1 << n9) - 1;
                    n7 = n5 + 2;
                    n8 = n2;
                    continue;
                }
                if (n8 == n2) {
                    this.pixelStack[n13++] = this.suffix[n];
                    n8 = n;
                    n14 = n;
                    continue;
                }
                int n19 = n;
                if (n == n7) {
                    this.pixelStack[n13++] = (byte)n14;
                    n = n8;
                }
                while (n > n5) {
                    this.pixelStack[n13++] = this.suffix[n];
                    n = this.prefix[n];
                }
                n14 = this.suffix[n] & 0xFF;
                if (n7 >= 4096) break;
                this.pixelStack[n13++] = (byte)n14;
                this.prefix[n7] = (short)n8;
                this.suffix[n7] = (byte)n14;
                if ((++n7 & n10) == 0 && n7 < 4096) {
                    ++n9;
                    n10 += n7;
                }
                n8 = n19;
            }
            this.pixels[n12++] = this.pixelStack[--n13];
            ++n18;
        }
        for (n18 = n12; n18 < n3; ++n18) {
            this.pixels[n18] = 0;
        }
    }

    protected boolean err() {
        return this.status != 0;
    }

    protected void init() {
        this.status = 0;
        this.frameCount = 0;
        this.frames = new Vector();
        this.gct = null;
        this.lct = null;
    }

    protected int read() {
        int n = 0;
        try {
            n = this.in.read();
        }
        catch (IOException iOException) {
            this.status = 1;
        }
        return n;
    }

    protected int readBlock() {
        int n;
        this.blockSize = this.read();
        if (this.blockSize > 0) {
            try {
                int n2 = 0;
                for (n = 0; n < this.blockSize && (n2 = this.in.read(this.block, n, this.blockSize - n)) != -1; n += n2) {
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (n < this.blockSize) {
                this.status = 1;
            }
        }
        return n;
    }

    protected int[] readColorTable(int n) {
        int n2 = 3 * n;
        int[] nArray = null;
        byte[] byArray = new byte[n2];
        int n3 = 0;
        try {
            for (n3 = 0; n3 < n2; ++n3) {
                byArray[n3] = this.in.readByte();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (n3 < n2) {
            this.status = 1;
        } else {
            nArray = new int[256];
            int n4 = 0;
            int n5 = 0;
            while (n4 < n) {
                int n6 = byArray[n5++] & 0xFF;
                int n7 = byArray[n5++] & 0xFF;
                int n8 = byArray[n5++] & 0xFF;
                nArray[n4++] = 0xFF000000 | n6 << 16 | n7 << 8 | n8;
            }
        }
        return nArray;
    }

    protected void readContents() {
        boolean bl = false;
        while (!bl && !this.err()) {
            int n = this.read();
            block0 : switch (n) {
                case 44: {
                    this.readImage();
                    break;
                }
                case 33: {
                    n = this.read();
                    switch (n) {
                        case 249: {
                            this.readGraphicControlExt();
                            break block0;
                        }
                        case 255: {
                            this.readBlock();
                            String string = "";
                            for (int i = 0; i < 11; ++i) {
                                string = string + (char)this.block[i];
                            }
                            if (string.equals("NETSCAPE2.0")) {
                                this.readNetscapeExt();
                                break block0;
                            }
                            this.skip();
                            break block0;
                        }
                    }
                    this.skip();
                    break;
                }
                case 59: {
                    bl = true;
                    break;
                }
                case 0: {
                    break;
                }
                default: {
                    this.status = 1;
                }
            }
        }
    }

    protected void readGraphicControlExt() {
        this.read();
        int n = this.read();
        this.dispose = (n & 0x1C) >> 2;
        if (this.dispose == 0) {
            this.dispose = 1;
        }
        this.transparency = (n & 1) != 0;
        this.delay = this.readShort() * 10;
        this.transIndex = this.read();
        this.read();
    }

    protected void readHeader() {
        String string = "";
        for (int i = 0; i < 6; ++i) {
            string = string + (char)this.read();
        }
        if (!string.startsWith("GIF")) {
            this.status = 1;
            return;
        }
        this.readLSD();
        if (this.gctFlag && !this.err()) {
            this.gct = this.readColorTable(this.gctSize);
            this.bgColor = this.gct[this.bgIndex];
        }
    }

    protected void readImage() {
        this.ix = this.readShort();
        this.iy = this.readShort();
        this.iw = this.readShort();
        this.ih = this.readShort();
        int n = this.read();
        this.lctFlag = (n & 0x80) != 0;
        this.interlace = (n & 0x40) != 0;
        this.lctSize = 2 << (n & 7);
        if (this.lctFlag) {
            this.lct = this.readColorTable(this.lctSize);
            this.act = this.lct;
        } else {
            this.act = this.gct;
            if (this.bgIndex == this.transIndex) {
                this.bgColor = 0;
            }
        }
        int n2 = 0;
        if (this.transparency) {
            n2 = this.act[this.transIndex];
            this.act[this.transIndex] = 0;
        }
        if (this.act == null) {
            this.status = 1;
        }
        if (this.err()) {
            return;
        }
        this.decodeImageData();
        this.skip();
        if (this.err()) {
            return;
        }
        ++this.frameCount;
        imageData = Image.createImage((int)this.width, (int)this.height);
        this.setPixels();
        this.frames.addElement(new GifFrame(imageData, this.delay));
        if (this.transparency) {
            this.act[this.transIndex] = n2;
        }
        this.resetFrame();
    }

    protected void readLSD() {
        this.width = this.readShort();
        this.height = this.readShort();
        int n = this.read();
        this.gctFlag = (n & 0x80) != 0;
        this.gctSize = 2 << (n & 7);
        this.bgIndex = this.read();
        this.pixelAspect = this.read();
    }

    protected void readNetscapeExt() {
        do {
            this.readBlock();
            if (this.block[0] != 1) continue;
            int n = this.block[1] & 0xFF;
            int n2 = this.block[2] & 0xFF;
            this.loopCount = n2 << 8 | n;
        } while (this.blockSize > 0 && !this.err());
    }

    protected int readShort() {
        return this.read() | this.read() << 8;
    }

    protected void resetFrame() {
        this.lastDispose = this.dispose;
        this.lx = this.ix;
        this.ly = this.iy;
        this.lw = this.iw;
        this.lh = this.ih;
        lastImage = imageData;
        this.lastBgColor = this.bgColor;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        this.lct = null;
    }

    protected void skip() {
        do {
            this.readBlock();
        } while (this.blockSize > 0 && !this.err());
    }

    void closeAllConnections() {
        try {
            if (this.in != null) {
                this.in.close();
                this.in = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static class GifFrame {
        public Image image;
        public int delay;

        public GifFrame(Image image, int n) {
            this.image = image;
            this.delay = n;
        }
    }
}

