/*
 * Decompiled with CFR 0.152.
 */
package com.neosoft.gui;

import Main.Main;
import gui.Gradient;
import gui.Panel;
import gui.Search;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Image;

public final class VirtualList
extends Panel {
    private int cursor;
    private int shift;
    private int maxel;
    private Image[] imges;
    private String[] list = new String[0];
    private boolean drag = false;
    private int drag_start;
    private boolean moved = false;
    private boolean scroll_down = false;
    private boolean scroll_up = false;
    private Thread scroll_down_thread;
    private Thread scroll_up_thread;

    public VirtualList(String title) {
        super(title, Main.list_panelicons);
        this.imges = new Image[0];
    }

    protected void showNotify() {
        this.clearScreen();
        this.panel_draw();
        if (!this.panel_getActive() && this.cursor > -1) {
            this.drawCursor();
        }
        this.drawList();
    }

    private void drawCursor() {
        Gradient.gradientBox(this.gr, 0x9999FF, 0x1111FF, 5, this.cursor * (this.fh + 3) + 15 + this.fh, this.sw - 12, this.fh + 4, 0, 'c');
    }

    private void drawList() {
        int cur = 0;
        for (int i = this.shift; i < this.maxel + this.shift; ++i) {
            if (!this.panel_getActive() && i == this.cursor + this.shift) {
                this.gr.setColor(0xFFFFFF);
            } else {
                this.gr.setColor(0);
            }
            int iw = 0;
            if (this.imges != null && i < this.imges.length && this.imges[i] != null) {
                this.gr.drawImage(this.imges[i], 9, (cur + 1) * (this.fh + 3) + 7 - (this.imges[i].getWidth() - this.fh) / 2, 20);
                iw = this.imges[i].getWidth();
            }
            this.gr.drawString(this.list[i], 12 + iw, (cur + 1) * (this.fh + 3) + 15, 20);
            ++cur;
        }
    }

    public final void addList(String[] str, Image[] i) {
        this.cursor = 0;
        this.list = str;
        this.maxel = this.sh / (this.fh + 4) - 2;
        if (str.length < this.maxel) {
            this.maxel = str.length;
        }
        this.imges = null;
        str = null;
        this.imges = i;
        System.gc();
    }

    public final void addElement(String name, Image img) {
        if (name != null) {
            String[] tmpname = new String[this.list.length + 1];
            System.arraycopy(this.list, 0, tmpname, 0, this.list.length);
            tmpname[this.list.length] = name;
            this.list = tmpname;
            tmpname = null;
            System.gc();
        }
        if (img != null) {
            Image[] tmpimg = new Image[this.imges.length + 1];
            System.arraycopy(this.imges, 0, tmpimg, 0, this.imges.length);
            tmpimg[this.imges.length] = img;
            this.imges = tmpimg;
            tmpimg = null;
            System.gc();
        }
        this.maxel = this.sh / (this.fh + 4) - 2;
        if (this.list.length < this.maxel) {
            this.maxel = this.list.length;
        }
    }

    public final int getSelectedIndex() {
        return this.cursor + this.shift;
    }

    public final String getString(int i) {
        return this.list[i];
    }

    public final String[] getStrings() {
        return this.list;
    }

    private void moveUp() {
        --this.cursor;
        if (this.cursor == 0 && this.shift != 0) {
            ++this.cursor;
            --this.shift;
        }
    }

    private void moveDown() {
        ++this.cursor;
        if (this.cursor == this.maxel - 1 && this.cursor != this.list.length - this.shift - 1) {
            --this.cursor;
            ++this.shift;
        }
    }

    public final void setCursor(String str) {
        int pos = 0;
        for (int i = 0; i < this.list.length; ++i) {
            if (this.list[i].indexOf(str) != 0) continue;
            pos = i;
            break;
        }
        this.cursor = pos;
        this.shift = 0;
        while (this.cursor > this.list.length - 1) {
            --this.cursor;
        }
        while (this.cursor > this.maxel - 2 && this.cursor != this.list.length - 1) {
            --this.cursor;
            ++this.shift;
        }
        if (this.cursor == this.list.length - 1) {
            this.cursor = this.maxel - 1;
            this.shift = this.list.length - this.maxel;
        }
    }

    private void scroll_up_init() {
        this.scroll_up_thread = new Thread(){

            public void run() {
                while (VirtualList.this.scroll_up) {
                    VirtualList.this.moveUp();
                    if (VirtualList.this.cursor < 0) {
                        VirtualList.this.cursor = 0;
                        VirtualList.this.shift = 0;
                        break;
                    }
                    VirtualList.this.showNotify();
                    VirtualList.this.flushGraphics();
                    try {
                        1.sleep(80L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        };
        if (!this.scroll_up_thread.isAlive()) {
            this.scroll_up_thread.start();
        }
    }

    private void scroll_down_init() {
        this.scroll_down_thread = new Thread(){

            public void run() {
                while (VirtualList.this.scroll_down) {
                    VirtualList.this.moveDown();
                    if (VirtualList.this.cursor + VirtualList.this.shift > VirtualList.this.list.length - 1) {
                        VirtualList.this.cursor--;
                        break;
                    }
                    VirtualList.this.showNotify();
                    VirtualList.this.flushGraphics();
                    try {
                        2.sleep(80L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        };
        if (!this.scroll_down_thread.isAlive()) {
            this.scroll_down_thread.start();
        }
    }

    public final void keyRepeated(int i) {
        if (this.hasRepeatEvents()) {
            i = this.getGameAction(i);
            switch (i) {
                case 1: {
                    this.moveUp();
                    if (this.cursor < 0 && !this.panel_getActive()) {
                        this.panel_setActive(true);
                        break;
                    }
                    if (this.cursor >= 0 || !this.panel_getActive()) break;
                    this.cursor = 0;
                    break;
                }
                case 6: {
                    if (this.panel_getActive()) {
                        this.panel_setActive(false);
                        this.cursor = 0;
                        this.shift = 0;
                        break;
                    }
                    this.moveDown();
                    if (this.cursor + this.shift <= this.list.length - 1) break;
                    --this.cursor;
                }
            }
            this.showNotify();
            this.flushGraphics();
        }
    }

    public final void keyPressed(int i) {
        if (Main.isSonyEricsson() && i == -11) {
            Main.setCurrent((Displayable)Main.interf);
            return;
        }
        i = this.getGameAction(i);
        switch (i) {
            case 1: {
                this.moveUp();
                if (this.cursor < 0 && !this.panel_getActive()) {
                    this.panel_setActive(true);
                    break;
                }
                if (this.cursor >= 0 || !this.panel_getActive()) break;
                this.cursor = 0;
                break;
            }
            case 6: {
                if (this.panel_getActive()) {
                    this.panel_setActive(false);
                    this.cursor = 0;
                    this.shift = 0;
                    break;
                }
                this.moveDown();
                if (this.shift + this.cursor <= this.list.length - 1) break;
                this.cursor = 0;
                this.shift = 0;
                break;
            }
            case 2: {
                if (this.panel_getActive()) {
                    this.panel_moveleft();
                    break;
                }
                this.cursor = 0;
                this.shift = 0;
                break;
            }
            case 5: {
                if (this.panel_getActive()) {
                    this.panel_moveright();
                    break;
                }
                this.cursor = this.maxel - 1;
                this.shift = this.list.length - this.maxel;
                break;
            }
            case 8: {
                if (this.panel_getActive()) {
                    this.commandAction(this.panel_getPos());
                    break;
                }
                if (this.panel_getActive()) break;
                this.commandAction(this.getSelectedIndex());
            }
        }
        this.showNotify();
        this.flushGraphics();
    }

    public final void pointerPressed(int px, int py) {
        if (this.hasPointerEvents()) {
            int cursor_pos = this.cursor * (this.fh + 3) + 15 + this.fh;
            if (py >= 0 && py <= this.panel_getHeight()) {
                int[] cells = this.panel_getCells();
                int action = -1;
                for (int i = 0; i < cells.length; ++i) {
                    if (px < cells[i] || px >= cells[i] + 18) continue;
                    action = i;
                    break;
                }
                if (action != -1) {
                    this.panel_setCursor(action);
                    this.panel_setActive(true);
                    this.commandAction(action);
                } else {
                    this.scroll_up = true;
                    this.scroll_up_init();
                }
            } else if (py >= cursor_pos && py <= cursor_pos + this.fh + 4) {
                this.drag_start = py;
                this.drag = true;
                this.moved = false;
            } else if (py > this.sh - this.fh - this.fh) {
                this.scroll_down = true;
                this.scroll_down_init();
            }
            this.showNotify();
            this.flushGraphics();
        }
    }

    public final void pointerReleased(int px, int py) {
        if (this.hasPointerEvents()) {
            if (this.drag) {
                this.drag = false;
                if (!this.moved) {
                    this.commandAction(this.getSelectedIndex());
                }
            }
            if (this.scroll_down) {
                this.scroll_down = false;
            }
            if (this.scroll_up) {
                this.scroll_up = false;
            }
        }
    }

    public final void pointerDragged(int px, int py) {
        if (this.hasPointerEvents() && this.hasPointerMotionEvents() && this.drag) {
            if (py < this.drag_start - this.fh - 2) {
                this.moved = true;
                this.drag_start = py;
                this.moveUp();
                if (this.cursor < 0) {
                    this.cursor = 0;
                    this.shift = 0;
                }
            } else if (py > this.drag_start + this.fh + 2) {
                this.moved = true;
                this.drag_start = py;
                this.moveDown();
                if (this.cursor + this.shift > this.list.length - 1) {
                    --this.cursor;
                }
            }
            this.showNotify();
            this.flushGraphics();
        }
    }

    private void commandAction(int command) {
        if (this.panel_getActive()) {
            if (this.hasPointerEvents()) {
                this.panel_setActive(false);
                this.cursor = 0;
            }
            if (command == 0) {
                new Search((Displayable)this);
            } else if (command == 1) {
                Main.setCurrent((Displayable)Main.interf);
            }
            return;
        }
        if (!this.panel_getActive()) {
            Main.main.set_language(this.list[this.getSelectedIndex()], (Object)this);
        }
    }
}

