/*
 * Decompiled with CFR 0.152.
 */
public class TXCar {
    public static final int SEGLEN = 256;
    public static final int SEGWIDTH = 512;
    private static final int WEIGHT = 5000;
    private static final int G_ACCEL = 10;
    private static final int F_ENGINE = 2000;
    private static final int SEG_METERS = 11;
    private static final int MAX_WHEEL = 40;
    private int K_ROAD = 200;
    private int POWER_MAX = 50000;
    private int MAX_SPEED;
    private int[] obstScore = new int[]{10, 15, 10, 20, 20};
    public int x_pos;
    public int y_pos;
    public int z_pos = 1024;
    public int prev_x_pos;
    public int prev_z_pos = 1024;
    public int h_pos;
    public int object_climb_angle;
    public int cell_climb_angle;
    public int object_spin_angle;
    public int cell_spin_angle;
    public int added_climb_angle;
    public int weaponNumber;
    public int rocketNumber = 0;
    public long timeForShowScore;
    public int scoreNumber;
    public int life;
    public boolean myshoot = false;
    public boolean shooted = false;
    public boolean finished = false;
    public int outOfTime;
    public int shacking;
    public final int MAX_LIFE;
    public int getRocket;
    private int pedals;
    private int skid_angle;
    private int skiding;
    private int wheel_angle;
    public int velocity;
    private int hVel;
    private int type;
    public long currentTurboTime;
    public final long maxTurboTime;
    public final long maxChargingTime;
    public int showCharging = 0;
    public boolean keyUp;
    public boolean keyDown;
    public boolean keyLeft;
    public boolean keyRight;
    private boolean is_visible = false;
    private int __sa;
    private int __ca;
    int dirZ = 256;
    int dirX = 0;
    int icurve = 0;
    int dir = 4;
    int carAngle = 0;
    int angleVelocity = 0;
    boolean carLeft;
    boolean carRight;
    boolean carTurbo;
    boolean carTurboWait;
    int shakingType;
    int carY;

    public TXCar() {
        this.MAX_LIFE = 160000;
        this.maxTurboTime = 5000L;
        this.maxChargingTime = 10000L;
    }

    public int getVelocity() {
        return 36 * this.velocity / 2560;
    }

    public int getCell() {
        return this.z_pos / 65536;
    }

    public int getCellOffs() {
        return this.z_pos / 256 % 256;
    }

    public int getObjectSpin() {
        return this.object_spin_angle / 256;
    }

    public int getCellSpin() {
        return this.cell_spin_angle / 256;
    }

    final void setPos(int n, int n2) {
        TXSegInfo[] tXSegInfoArray = TripleX.getInstance().getSegInfo();
        int n3 = tXSegInfoArray.length * 256 * 256;
        this.z_pos = n * 256;
        if (this.z_pos >= n3) {
            this.z_pos -= n3;
        } else if (this.z_pos < 0) {
            this.z_pos += n3;
        }
        this.x_pos = n2 * 256;
    }

    void tick(long l) {
        int n;
        this.carRight = false;
        this.carLeft = false;
        this.prev_x_pos = this.x_pos;
        this.prev_z_pos = this.z_pos;
        if (!this.finished && this.life > 1) {
            if ((long)this.life < l + 2L) {
                this.life = 0;
                this.outOfTime = 30;
            } else {
                this.life = (int)((long)this.life - l);
            }
        }
        int n2 = this.z_pos / 256;
        TXSegInfo tXSegInfo = TripleX.getInstance().getSegInfo()[n2];
        if (this.keyUp && !this.carTurbo) {
            if (this.currentTurboTime >= 5000L) {
                this.currentTurboTime = 5000L;
                this.carTurbo = true;
            } else {
                this.showCharging = 3;
            }
        }
        if (this.keyDown) {
            this.carTurbo = false;
        }
        if (this.carTurbo) {
            this.currentTurboTime -= l;
            if (this.currentTurboTime <= 0L) {
                this.currentTurboTime = 0L;
                this.carTurbo = false;
            }
        } else {
            this.currentTurboTime += l / 3L;
            if (this.currentTurboTime > 5000L) {
                this.currentTurboTime = 5000L;
            }
        }
        if (l > 200L) {
            l = 200L;
        }
        if (this.keyLeft) {
            if (this.angleVelocity < 0) {
                this.angleVelocity = 0;
                this.carLeft = false;
            }
            this.angleVelocity = (int)((long)this.angleVelocity + 102400L * l / 1000L);
            if (this.angleVelocity > 1280) {
                this.carLeft = true;
            }
        }
        if (this.keyRight) {
            if (this.angleVelocity > 0) {
                this.angleVelocity = 0;
                this.carRight = false;
            }
            this.angleVelocity = (int)((long)this.angleVelocity - 102400L * l / 1000L);
            if (this.angleVelocity < -1280) {
                this.carRight = true;
            }
        }
        if (!this.keyLeft && !this.keyRight) {
            this.angleVelocity /= 2;
        }
        this.velocity = this.keyDown || this.finished ? (int)((long)this.velocity - 256L * l / 1000L) : (this.carTurbo ? (int)((long)this.velocity + 512L * l / 1000L) : (int)((long)this.velocity + 256L * l / 1000L));
        int n3 = 1664;
        if (n2 > TripleX.getInstance().getSegInfo().length - 40 && this.outOfTime == 0 && this.life > 0) {
            if (!this.finished) {
                TXIngameCanvas.bonusScore = this.life / 1000 * 10;
            }
            this.finished = true;
        } else {
            n3 = this.outOfTime > 0 ? (n3 -= n3 / 4) : (this.carTurbo ? 3840 : 2304);
        }
        if (this.velocity > n3) {
            this.velocity = n3;
        } else if (this.velocity < 0) {
            this.velocity = 0;
        }
        int n4 = (int)(l * (long)this.velocity / 1000L);
        if (n4 != 0) {
            long l2 = l;
            n = (int)((long)(256 * this.velocity) / (2L * l2));
            if (this.angleVelocity > n) {
                this.angleVelocity = n;
            } else if (this.angleVelocity < -n) {
                this.angleVelocity = -n;
            }
            this.carAngle = (int)((long)this.carAngle + (long)this.angleVelocity * l / 1000L);
            if (256 * tXSegInfo.absoluteCurve + this.carAngle < -3840) {
                this.carAngle = -256 * tXSegInfo.absoluteCurve - 3840;
            } else if (256 * tXSegInfo.absoluteCurve + this.carAngle > 3840) {
                this.carAngle = -256 * tXSegInfo.absoluteCurve + 3840;
            }
        }
        int n5 = tXSegInfo.absoluteCurve + this.carAngle / 256;
        int n6 = TXMath.sin(n5);
        n = TXMath.cos(n5);
        long l3 = l * (long)this.velocity / 256L;
        this.x_pos = (int)((long)this.x_pos + l3 * (long)n6 / 1000L);
        this.z_pos = (int)((long)this.z_pos + l3 * (long)n / 1000L);
        if (this.x_pos < -190) {
            if (this.velocity > 2048) {
                this.velocity = 2048;
            }
            this.carAngle = (int)((long)this.carAngle + l * 25L * 256L / 1000L);
            this.x_pos = -190;
            this.carLeft = true;
        } else if (this.x_pos > 190) {
            if (this.velocity > 2048) {
                this.velocity = 2048;
            }
            this.carAngle = (int)((long)this.carAngle - l * 25L * 256L / 1000L);
            this.x_pos = 190;
            this.carRight = true;
        }
        this.proceedCollisions();
    }

    void proceedCollisions() {
        int n = this.z_pos / 256;
        TXSegInfo[] tXSegInfoArray = TripleX.getInstance().getSegInfo();
        TXSegInfo tXSegInfo = tXSegInfoArray[n - 1];
        if (tXSegInfo.obj != null) {
            TXRoadObject tXRoadObject = tXSegInfo.obj;
            int n2 = tXRoadObject.objX;
            if (!tXRoadObject.gone) {
                tXRoadObject.gone = true;
                if (tXRoadObject.objID != 5) {
                    if (TXMath.abs(this.x_pos + n2) < 80) {
                        this.velocity /= 20;
                        if (this.life < 0) {
                            this.life = 0;
                        }
                        tXRoadObject.blow = true;
                        this.shakingType = tXRoadObject.objID;
                        this.shacking = 4;
                        if (tXRoadObject.objID == 1) {
                            TripleX.getInstance();
                            TripleX.playSound(4);
                            tXRoadObject.image = -1;
                            TripleX.vibrate(500);
                        } else {
                            TripleX.getInstance();
                            TripleX.playSound(1);
                            TripleX.vibrate(250);
                        }
                    } else {
                        TripleX.score += this.obstScore[tXRoadObject.objID] + TripleX.difLevel * 3;
                        TXIngameCanvas.needScore = true;
                        this.scoreNumber = this.obstScore[tXRoadObject.objID] + TripleX.difLevel * 3;
                        this.timeForShowScore = System.currentTimeMillis() + 800L;
                        TXIngameCanvas.firstScore = true;
                    }
                } else if (TXMath.abs(this.x_pos + n2) < 80) {
                    this.getRocket = 5;
                    TXIngameCanvas.getInstance().needWeapon = true;
                    TXIngameCanvas.getInstance().needNebo = true;
                    ++this.rocketNumber;
                }
            }
        }
    }
}

