/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;

public final class BPFontReader {
    private static final boolean IS_DEBUG = false;
    private static final String RESOURCES_FILE_NAME = "r";
    public static String[][] textAsString;
    public static int[][][] textAsOffset;
    private static char[][] alphabetAsChar;
    private static int[][] alphabetAsOffset;
    public static Image[] alphabetAsImage;
    public static int[] fontHeight;
    private static int[] alphabetIndex;
    private static int[] letterSpacing;

    public static void init(MIDlet midlet, String lang, boolean loadImages) {
        DataInputStream buff = null;
        try {
            int a;
            buff = new DataInputStream(midlet.getClass().getResourceAsStream(RESOURCES_FILE_NAME));
            int alphabetCount = buff.readInt();
            alphabetAsImage = new Image[alphabetCount];
            for (a = 0; a < alphabetCount; ++a) {
                byte[] imageInBytes = new byte[buff.readInt()];
                for (int i = 0; i < imageInBytes.length; ++i) {
                    imageInBytes[i] = buff.readByte();
                }
                Image tmpImg = Image.createImage((byte[])imageInBytes, (int)0, (int)imageInBytes.length);
                if (!loadImages) continue;
                BPFontReader.alphabetAsImage[a] = tmpImg;
            }
            if (lang == null) {
                return;
            }
            fontHeight = new int[alphabetCount];
            alphabetAsChar = new char[alphabetCount][];
            alphabetAsOffset = new int[alphabetCount][];
            for (a = 0; a < alphabetCount; ++a) {
                BPFontReader.fontHeight[a] = buff.readInt();
                int offsetsLength = buff.readInt();
                BPFontReader.alphabetAsOffset[a] = new int[offsetsLength];
                for (int o = 0; o < offsetsLength; ++o) {
                    BPFontReader.alphabetAsOffset[a][o] = buff.readInt();
                }
                int alphabetLength = buff.readInt();
                BPFontReader.alphabetAsChar[a] = new char[alphabetLength];
                for (int c = 0; c < alphabetLength; ++c) {
                    BPFontReader.alphabetAsChar[a][c] = (char)(buff.readChar() ^ c);
                }
            }
            int langCounter = buff.readInt();
            boolean isLangMatched = false;
            for (int lc = 0; lc < langCounter; ++lc) {
                String langID = buff.readUTF();
                int textCounter = buff.readInt();
                textAsString = new String[textCounter][];
                alphabetIndex = new int[textCounter];
                letterSpacing = new int[textCounter];
                textAsOffset = new int[textCounter][][];
                for (int t = 0; t < textCounter; ++t) {
                    int options = buff.readInt();
                    if (options == 0 || options == 1) {
                        int lines = buff.readInt();
                        BPFontReader.textAsString[t] = new String[lines];
                        for (int i = 0; i < lines; ++i) {
                            BPFontReader.textAsString[t][i] = new String(BPFontReader.decodeText(buff.readUTF()));
                        }
                        continue;
                    }
                    BPFontReader.alphabetIndex[t] = options - 2;
                    BPFontReader.letterSpacing[t] = buff.readInt();
                    int yLength = buff.readInt();
                    BPFontReader.textAsOffset[t] = new int[yLength][];
                    for (int ty = 0; ty < yLength; ++ty) {
                        int xLength = buff.readInt();
                        BPFontReader.textAsOffset[t][ty] = new int[xLength];
                        for (int tx = 0; tx < xLength; ++tx) {
                            BPFontReader.textAsOffset[t][ty][tx] = buff.readInt();
                        }
                    }
                }
                if (!langID.equals(lang)) continue;
                isLangMatched = true;
                break;
            }
            buff.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        System.gc();
    }

    public static void freeMemory(boolean releaseText) {
        alphabetAsImage = null;
        if (releaseText) {
            textAsString = null;
            textAsOffset = null;
            alphabetAsChar = null;
            alphabetAsOffset = null;
            fontHeight = null;
            alphabetIndex = null;
        }
        System.gc();
    }

    private static char[] decodeText(String text) {
        char[] decode = new char[text.length()];
        for (int f = 0; f < text.length(); f = (int)((char)(f + 1))) {
            decode[f] = (char)(text.charAt(f) ^ f);
        }
        return decode;
    }

    public static void drawSystemText(String text, int x, int y, Font font, int RGBColor, Graphics g) {
        g.setFont(font);
        g.setColor(RGBColor);
        g.drawString(text, x, y, 20);
    }

    public static void drawGraphicText(int textId, int lineId, int x, int y, Graphics g) {
        try {
            int[] text = textAsOffset[textId][lineId];
            int alphabetId = alphabetIndex[textId];
            int fontWidth = alphabetAsImage[alphabetId].getWidth();
            for (int i = 0; i < text.length; ++i) {
                int currentOffset = alphabetAsOffset[alphabetId][text[i]];
                int width = alphabetAsOffset[alphabetId][text[i] + 1] - currentOffset;
                int row = currentOffset / fontWidth;
                int col = currentOffset - row * fontWidth;
                g.setClip(x - i, y, width, fontHeight[alphabetId]);
                g.drawImage(alphabetAsImage[alphabetId], x - i - col, y - row * fontHeight[alphabetId], 20);
                x += width + letterSpacing[textId];
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void drawGraphicText(String text, int x, int y, int alphabetId, int letterSpacing, Graphics g) {
        int fontWidth = alphabetAsImage[alphabetId].getWidth();
        for (int i = 0; i < text.length(); ++i) {
            int index;
            char c = text.charAt(i);
            for (index = 0; index < alphabetAsChar[alphabetId].length && alphabetAsChar[alphabetId][index] != c; ++index) {
            }
            int currentOffset = alphabetAsOffset[alphabetId][index];
            int width = alphabetAsOffset[alphabetId][index + 1] - currentOffset;
            int row = currentOffset / fontWidth;
            int col = currentOffset - row * fontWidth;
            g.setClip(x - i, y, width, fontHeight[alphabetId]);
            g.drawImage(alphabetAsImage[alphabetId], x - col - i, y - row * fontHeight[alphabetId], 20);
            x += width + letterSpacing;
        }
    }

    public static int getTextWidth(String text, int alphabetId, int letterSpacing) {
        int letterSpacingLoc = letterSpacing - 1;
        int length = 0;
        for (int i = 0; i < text.length(); ++i) {
            int index;
            char c = text.charAt(i);
            for (index = 0; index < alphabetAsChar[alphabetId].length && alphabetAsChar[alphabetId][index] != c; ++index) {
            }
            length += alphabetAsOffset[alphabetId][index + 1] - alphabetAsOffset[alphabetId][index] + letterSpacingLoc;
        }
        return length - letterSpacingLoc;
    }

    public static int getGraphicTextWidth(int textId, int lineId) {
        int length = 0;
        int alphabetId = alphabetIndex[textId];
        int[] text = textAsOffset[textId][lineId];
        for (int i = 0; i < text.length; ++i) {
            length += alphabetAsOffset[alphabetId][text[i] + 1] - alphabetAsOffset[alphabetId][text[i]] + letterSpacing[textId] - 1;
        }
        return length - letterSpacing[textId] + 1;
    }
}

