/*
 * Decompiled with CFR 0.152.
 */
package world;

import java.io.DataInputStream;
import java.io.InputStream;
import pixelGraphics.EncodedImage;
import pixelGraphics.PixelGraphics;
import root.Util;

public class Sprite2D {
    public int spriteHeight;
    public short[] anchorX;
    public short[] anchorY;
    private boolean horizontalSymmetry;
    private boolean verticalSymmetry;
    private int framesPerAngle;
    private int numberOfSets;
    private int numberOfHorizontalAngles;
    private int numberOfVerticalAngles;
    private short[] horizontalAngles;
    private short[] verticalAngles;
    private byte[] horizontalSet;
    private byte[] verticalSet;
    private short[] imageHeight;
    private int[] widthFactor;
    public int numberOfColors;
    public int[] colorData;
    public EncodedImage[] objectImage;
    public static final int angleShift = 2;
    boolean odbiciePionowe;
    boolean odbiciePoziome;

    public Sprite2D(String fileName, int height, short[] horizontalAngles, short[] verticalAngles, boolean horizontalSymmetry, boolean verticalSymmetry) throws Exception {
        int i;
        this.spriteHeight = height;
        this.horizontalSymmetry = horizontalSymmetry;
        this.verticalSymmetry = verticalSymmetry;
        this.horizontalAngles = horizontalAngles;
        this.verticalAngles = verticalAngles;
        this.numberOfHorizontalAngles = horizontalAngles == null ? 1 : horizontalAngles.length;
        this.numberOfVerticalAngles = verticalAngles == null ? 1 : verticalAngles.length;
        this.calculateAngleSets();
        InputStream is = this.getClass().getResourceAsStream(fileName);
        DataInputStream dis = new DataInputStream(is);
        byte freeBitsNumber = dis.readByte();
        this.framesPerAngle = dis.readByte();
        this.numberOfSets = dis.readByte();
        this.objectImage = new EncodedImage[this.numberOfSets * this.framesPerAngle];
        this.imageHeight = new short[this.numberOfSets];
        this.widthFactor = new int[this.numberOfSets];
        this.anchorX = new short[this.numberOfSets];
        this.anchorY = new short[this.numberOfSets];
        int pointer = 0;
        for (int i2 = 0; i2 < this.numberOfSets; ++i2) {
            int j = 0;
            while (j < this.framesPerAngle) {
                this.objectImage[pointer] = new EncodedImage(dis, false, freeBitsNumber);
                ++j;
                ++pointer;
            }
            this.imageHeight[i2] = (short)this.objectImage[i2 * this.framesPerAngle].imageHeight;
            this.widthFactor[i2] = (this.objectImage[i2 * this.framesPerAngle].imageWidth * 16 << 12) / this.imageHeight[i2];
        }
        this.numberOfColors = dis.readByte();
        this.colorData = new int[this.numberOfColors];
        for (i = 0; i < this.numberOfColors; ++i) {
            short color = dis.readShort();
            this.colorData[i] = ((color & 0xF00) << 12) + ((color & 0xF0) << 8) + ((color & 0xF) << 4);
        }
        pointer = 0;
        for (i = 0; i < this.numberOfSets; ++i) {
            int j = 0;
            while (j < this.framesPerAngle) {
                this.objectImage[pointer].setColorTable(this.numberOfColors, this.colorData);
                ++j;
                ++pointer;
            }
        }
        for (i = 0; i < this.numberOfSets; ++i) {
            this.anchorX[i] = dis.readShort();
            this.anchorY[i] = dis.readShort();
        }
        dis.close();
    }

    private void calculateAngleSets() {
        int i;
        int iMax;
        int frame;
        int angle;
        if (this.numberOfHorizontalAngles > 1) {
            this.horizontalSet = this.horizontalSymmetry ? new byte[46] : new byte[91];
            angle = this.horizontalAngles[0] + this.horizontalAngles[1] >> 3;
            frame = 0;
            iMax = this.horizontalSymmetry ? 45 : 90;
            for (i = 0; i <= iMax; ++i) {
                if (i > angle) {
                    angle = (frame = (int)((byte)(frame + 1))) >= this.numberOfHorizontalAngles - 1 ? 400 : this.horizontalAngles[frame] + this.horizontalAngles[frame + 1] >> 3;
                }
                this.horizontalSet[i] = frame;
            }
        }
        if (this.numberOfVerticalAngles > 1) {
            this.verticalSet = this.verticalSymmetry ? new byte[23] : new byte[46];
            angle = this.verticalAngles[0] + this.verticalAngles[1] >> 3;
            frame = 0;
            iMax = this.verticalSymmetry ? 22 : 45;
            for (i = 0; i <= iMax; ++i) {
                if (i > angle) {
                    angle = (frame = (int)((byte)(frame + 1))) >= this.numberOfVerticalAngles - 1 ? 400 : this.verticalAngles[frame] + this.verticalAngles[frame + 1] >> 3;
                }
                this.verticalSet[i] = frame;
            }
        }
    }

    public void draw3D(PixelGraphics pixelGraphics, int x, int y, int height, int z, int angleHorizontal, int angleVertical, int targetColor, int colorFactor) throws Exception {
        try {
            int set = this.returnSet(angleHorizontal, angleVertical);
            int frame = 0;
            int pointer = set * this.framesPerAngle;
            if (this.framesPerAngle > 1) {
                while (++frame < this.framesPerAngle && this.objectImage[pointer].imageHeight + this.objectImage[pointer + 1].imageHeight >> 1 > height) {
                    ++pointer;
                }
                --frame;
            }
            EncodedImage drawingImage = this.objectImage[pointer];
            int wsp = (height << 16) / this.imageHeight[set];
            int width = height * this.widthFactor[set] >> 16;
            y -= this.anchorY[set] * wsp >> 16;
            if (this.odbiciePoziome) {
                drawingImage.drawSymmetry3D(pixelGraphics, x -= width - (this.anchorX[set] * wsp >> 16), y, width, height, z, targetColor, colorFactor);
            } else {
                drawingImage.draw3D(pixelGraphics, x -= this.anchorX[set] * wsp >> 16, y, width, height, z, targetColor, colorFactor);
            }
        }
        catch (Exception e) {
            Util.critical(e, "Draw 3D " + x + " " + y + " " + height + " " + z + " " + targetColor);
        }
    }

    private int returnSet(int angleHorizontal, int angleVertical) {
        int set = 0;
        try {
            int setVertical;
            byte setHorizontal;
            if (this.numberOfHorizontalAngles < 2) {
                setHorizontal = 0;
                this.odbiciePoziome = false;
            } else {
                while (angleHorizontal >= 360) {
                    angleHorizontal -= 360;
                }
                while (angleHorizontal < 0) {
                    angleHorizontal += 360;
                }
                if (angleHorizontal > 180 && this.horizontalSymmetry) {
                    setHorizontal = this.horizontalSet[360 - angleHorizontal >> 2];
                    this.odbiciePoziome = true;
                } else {
                    setHorizontal = this.horizontalSet[angleHorizontal >> 2];
                    this.odbiciePoziome = false;
                }
            }
            if (this.numberOfVerticalAngles < 2) {
                setVertical = 0;
                this.odbiciePionowe = false;
            } else if ((angleVertical += 90) > 90 && this.verticalSymmetry) {
                setVertical = this.verticalSet[180 - angleVertical >> 2];
                this.odbiciePionowe = true;
            } else {
                setVertical = this.verticalSet[angleVertical >> 2];
                this.odbiciePionowe = false;
            }
            set = setHorizontal + setVertical * this.numberOfHorizontalAngles;
        }
        catch (Exception e) {
            Util.critical(e, "Return Set " + angleHorizontal + " " + angleVertical + " " + set);
        }
        return set;
    }
}

