/*
 * Decompiled with CFR 0.152.
 */
package world;

import math.Math;
import root.Util;

public class TerrainTexture {
    public int textureWidth;
    public int textureHeight;
    public int textureWidthInTiles;
    public int textureWidthInTilesMask;
    public int tileWidth;
    public int tileWidthMask;
    public int tileWidthLog;
    public byte[][] textureTable;
    public int numberOfColors;
    public int[] baseColors;
    public byte[] textureTableTemp;

    public TerrainTexture(int tilesInLine, int tileWidth, int numberOfColors, int[] colorsTable) {
        this.numberOfColors = numberOfColors;
        this.baseColors = colorsTable;
        this.textureWidthInTiles = tilesInLine;
        this.textureWidthInTilesMask = tilesInLine - 1;
        this.textureHeight = this.textureWidth = tilesInLine * tileWidth;
        this.tileWidth = tileWidth;
        this.tileWidthMask = tileWidth - 1;
        this.tileWidthLog = Math.log(tileWidth);
        int textureWidthSqr = this.textureWidth * this.textureWidth;
        int textureWidthDiv2 = this.textureWidth >> 1;
        int textureWidthMask = this.textureWidth - 1;
        int textureWidthSqrMask = textureWidthSqr - 1;
        this.textureTable = new byte[this.textureWidthInTiles * this.textureWidthInTiles][tileWidth * tileWidth];
        this.textureTable[0][0] = (byte)Util.random(numberOfColors);
        this.textureTable[this.returnTile((int)textureWidthDiv2, (int)0)][0] = (byte)Util.random(numberOfColors);
        this.textureTable[this.returnTile((int)0, (int)textureWidthDiv2)][0] = (byte)Util.random(numberOfColors);
        this.textureTable[this.returnTile((int)textureWidthDiv2, (int)textureWidthDiv2)][0] = (byte)Util.random(numberOfColors);
        int delta = this.textureWidth >> 1;
        int deltaDiv2 = delta >> 1;
        int randomValue = numberOfColors >> 1;
        while (delta >= 2) {
            int value;
            int x;
            int y;
            for (y = 0; y < this.textureWidth; y += delta) {
                for (x = deltaDiv2; x < this.textureWidth; x += delta) {
                    value = (this.returnValue(x - deltaDiv2, y) + this.returnValue(x + deltaDiv2 & textureWidthMask, y) >> 1) + Util.randomWithMinus(randomValue);
                    if (value < 0) {
                        value = -value;
                    }
                    if (value >= numberOfColors) {
                        value = (numberOfColors << 1) - value - 1;
                    }
                    this.textureTable[this.returnTile((int)x, (int)y)][this.returnIndexInTile((int)x, (int)y)] = (byte)value;
                }
            }
            for (y = deltaDiv2; y < this.textureWidth; y += delta) {
                for (x = 0; x < this.textureWidth; x += deltaDiv2) {
                    value = (this.returnValue(x, y - deltaDiv2) + this.returnValue(x, y + deltaDiv2 & textureWidthMask) >> 1) + Util.randomWithMinus(randomValue);
                    if (value < 0) {
                        value = -value;
                    }
                    if (value >= numberOfColors) {
                        value = (numberOfColors << 1) - value - 1;
                    }
                    this.textureTable[this.returnTile((int)x, (int)y)][this.returnIndexInTile((int)x, (int)y)] = (byte)value;
                }
            }
            delta >>= 1;
            deltaDiv2 >>= 1;
            randomValue = (randomValue << 1) / 3;
        }
    }

    public byte[] returnTextureTable(int tileX, int tileY) {
        return this.textureTable[(tileX & this.textureWidthInTilesMask) + (tileY & this.textureWidthInTilesMask) * this.textureWidthInTiles];
    }

    private int returnTile(int x, int y) {
        return (x >> this.tileWidthLog) + (y >> this.tileWidthLog) * this.textureWidthInTiles;
    }

    private int returnIndexInTile(int x, int y) {
        return (x & this.tileWidthMask) + (y & this.tileWidthMask) * this.tileWidth;
    }

    private byte returnValue(int x, int y) {
        return this.textureTable[this.returnTile(x, y)][this.returnIndexInTile(x, y)];
    }

    public void setCurrentTile(int tileX, int tileY) {
        this.textureTableTemp = this.textureTable[(tileX & this.textureWidthInTilesMask) + (tileY & this.textureWidthInTilesMask) * this.textureWidthInTiles];
    }

    public int getColor(int pointer) {
        return this.baseColors[this.textureTableTemp[pointer]];
    }

    public int getColor(int pointer, int height) {
        return this.baseColors[this.textureTableTemp[pointer]];
    }

    public void calculateColors(int sunAngle, int sunColor, int ambientColor) {
    }
}

