/*
 * Decompiled with CFR 0.152.
 */
package pixelGraphics;

import java.io.DataInputStream;
import pixelGraphics.PixelGraphics;
import root.Util;

public class EncodedImage {
    public int imageWidth;
    public int imageHeight;
    public byte[] colorTable;
    public byte[] lengthTable;
    public byte numberOfColors;
    public int[] colorData;

    public EncodedImage(String resourceName, boolean loadColorTable) {
        DataInputStream dis = new DataInputStream(this.getClass().getResourceAsStream(resourceName));
        this.rleLoading(dis, -1);
        if (loadColorTable) {
            this.loadColorTable(dis);
        }
    }

    public EncodedImage(DataInputStream dis, boolean loadColorTable, int freeBitsNumber) {
        this.rleLoading(dis, freeBitsNumber);
        if (loadColorTable) {
            this.loadColorTable(dis);
        }
    }

    private void rleLoading(DataInputStream dis, int lengthBits) {
        try {
            int doOdczytu;
            this.imageWidth = dis.readShort();
            this.imageHeight = dis.readShort();
            if (lengthBits == -1) {
                lengthBits = dis.readByte();
            }
            int colorBits = 8 - lengthBits;
            int colorMask = (1 << colorBits) - 1;
            int lengthMask = (1 << lengthBits) - 1 << colorBits;
            int lengthAdd = 1 << lengthBits;
            int dlugoscKolor = dis.readShort();
            int dlugoscPowtorzenia = dis.readShort();
            this.colorTable = new byte[dlugoscKolor];
            this.lengthTable = new byte[dlugoscKolor];
            int odczytano = 0;
            for (doOdczytu = dlugoscKolor; doOdczytu > 0; doOdczytu -= odczytano) {
                odczytano = dis.read(this.colorTable, dlugoscKolor - doOdczytu, doOdczytu);
            }
            odczytano = 0;
            for (doOdczytu = dlugoscPowtorzenia; doOdczytu > 0; doOdczytu -= odczytano) {
                odczytano = dis.read(this.lengthTable, dlugoscKolor - doOdczytu, doOdczytu);
            }
            int powtorzeniaAlfa = 0;
            int powtorzeniaReszta = 0;
            int liczbaPrzedzialowAlfa = 0;
            int liczbaPrzedzialowReszta = 0;
            int polozeniePowtorzenia = dlugoscKolor - dlugoscPowtorzenia;
            for (int i = 0; i < dlugoscKolor; ++i) {
                byte powtorzenia;
                byte kolor = this.colorTable[i];
                if ((kolor & lengthMask) != 0) {
                    powtorzenia = (byte)(kolor >> colorBits);
                    if (powtorzenia < 0) {
                        powtorzenia = (byte)(lengthAdd - powtorzenia);
                    }
                    kolor = (byte)(kolor & colorMask);
                } else {
                    powtorzenia = this.lengthTable[polozeniePowtorzenia++];
                }
                this.colorTable[i] = kolor;
                this.lengthTable[i] = powtorzenia;
                if (kolor == 0) {
                    powtorzeniaAlfa += powtorzenia;
                    ++liczbaPrzedzialowAlfa;
                    continue;
                }
                powtorzeniaReszta += powtorzenia;
                ++liczbaPrzedzialowReszta;
            }
        }
        catch (Exception e) {
            Util.critical(e, "rleLoading");
        }
    }

    private void loadColorTable(DataInputStream dis) {
        try {
            this.numberOfColors = dis.readByte();
            this.colorData = new int[this.numberOfColors];
            for (int i = 0; i < this.numberOfColors; ++i) {
                short color = dis.readShort();
                this.colorData[i] = ((color & 0xF00) << 12) + ((color & 0xF0) << 8) + ((color & 0xF) << 4);
            }
        }
        catch (Exception e) {
            Util.critical(e, "loadImageTable");
        }
    }

    public void setColorTable(int numberOfColors, int[] colorData) {
        this.numberOfColors = (byte)numberOfColors;
        this.colorData = colorData;
    }

    public void draw3D(PixelGraphics pixelGraphics, int x, int y, int width, int height, int z, int targetColor, int colorFactor) throws Exception {
        int tablePointer;
        int[] colorDataTemp;
        int minX;
        int minY;
        int[] pixelTable = pixelGraphics.renderTable;
        byte[] zBuffer = pixelGraphics.zBuffer;
        int tableWidth = pixelGraphics.renderWidth;
        int tableHeight = pixelGraphics.renderHeight;
        byte byteZ = (byte)z;
        int maxY = y < pixelGraphics.clipMaxY - height ? height : pixelGraphics.clipMaxY - y;
        int drawHeight = maxY - (minY = y >= pixelGraphics.clipMinY ? 0 : pixelGraphics.clipMinY - y);
        if (drawHeight <= 0) {
            return;
        }
        int maxX = x < pixelGraphics.clipMaxX - width ? width : pixelGraphics.clipMaxX - x;
        int drawWidth = maxX - (minX = x >= pixelGraphics.clipMinX ? 0 : pixelGraphics.clipMinX - x);
        if (drawWidth <= 0) {
            return;
        }
        int intervalX = (this.imageWidth << 16) / width;
        int intervalY = (this.imageHeight << 16) / height;
        int line = 0;
        int[] lineNumber = new int[height];
        for (int i = 0; i < height; ++i) {
            lineNumber[i] = line >> 16;
            line += intervalY;
        }
        int imagePointer = 0;
        int decodePointer = 0;
        int imagePointerT = this.lengthTable[decodePointer++] << 16;
        if (targetColor >= 0) {
            colorDataTemp = new int[this.numberOfColors];
            for (int i = this.numberOfColors - 1; i >= 0; --i) {
                colorDataTemp[i] = this.colorData[i] * colorFactor + targetColor >> 4 | 0xFF000000;
            }
        } else {
            colorDataTemp = this.colorData;
        }
        if (intervalY >= 65536) {
            for (int yR = minY; yR < maxY; ++yR) {
                tablePointer = x + minX + (y + yR) * tableWidth - 1;
                imagePointer = (lineNumber[yR] * this.imageWidth << 16) + minX * intervalX;
                while (imagePointer >= imagePointerT) {
                    imagePointerT += this.lengthTable[decodePointer++] << 16;
                }
                byte color = this.colorTable[decodePointer - 1];
                int xR = minX;
                while (xR < maxX) {
                    if (imagePointer >= imagePointerT) {
                        imagePointerT += this.lengthTable[decodePointer] << 16;
                        color = this.colorTable[decodePointer++];
                    }
                    if (color == 0) {
                        int temp = (imagePointerT - imagePointer) / intervalX + 1;
                        xR += temp;
                        tablePointer += temp;
                        imagePointer += temp * intervalX;
                    }
                    int color2 = colorDataTemp[color];
                    while (imagePointer < imagePointerT && xR++ < maxX) {
                        if (zBuffer[++tablePointer] >= z) {
                            pixelTable[tablePointer] = color2;
                            zBuffer[tablePointer] = byteZ;
                        }
                        imagePointer += intervalX;
                    }
                }
            }
        } else {
            int yR = minY;
            int maxYM = maxY - 1;
            while (yR < maxY) {
                int color2;
                int temp;
                tablePointer = x + minX + (y + yR) * tableWidth - 1;
                imagePointer = (lineNumber[yR] * this.imageWidth << 16) + minX * intervalX;
                int imageLine = lineNumber[yR++];
                int numberOfLines = 1;
                while (yR < maxY && lineNumber[yR] == imageLine) {
                    ++numberOfLines;
                    ++yR;
                }
                while (imagePointer >= imagePointerT) {
                    imagePointerT += this.lengthTable[decodePointer++] << 16;
                }
                byte color = this.colorTable[decodePointer - 1];
                int xR = minX;
                if (numberOfLines == 1) {
                    while (xR < maxX) {
                        if (imagePointer >= imagePointerT) {
                            imagePointerT += this.lengthTable[decodePointer] << 16;
                            color = this.colorTable[decodePointer++];
                        }
                        if (color == 0) {
                            temp = (imagePointerT - imagePointer) / intervalX + 1;
                            xR += temp;
                            tablePointer += temp;
                            imagePointer += temp * intervalX;
                        }
                        color2 = colorDataTemp[color];
                        while (imagePointer < imagePointerT && xR++ < maxX) {
                            if (zBuffer[++tablePointer] >= z) {
                                pixelTable[tablePointer] = color2;
                                zBuffer[tablePointer] = byteZ;
                            }
                            imagePointer += intervalX;
                        }
                    }
                    continue;
                }
                if (numberOfLines == 2) {
                    int tablePointer2 = tablePointer + tableWidth;
                    while (xR < maxX) {
                        if (imagePointer >= imagePointerT) {
                            imagePointerT += this.lengthTable[decodePointer] << 16;
                            color = this.colorTable[decodePointer++];
                        }
                        if (color == 0) {
                            temp = (imagePointerT - imagePointer) / intervalX + 1;
                            xR += temp;
                            tablePointer += temp;
                            tablePointer2 += temp;
                            imagePointer += temp * intervalX;
                        }
                        color2 = colorDataTemp[color];
                        while (imagePointer < imagePointerT && xR++ < maxX) {
                            if (zBuffer[++tablePointer] >= z) {
                                pixelTable[tablePointer] = color2;
                                zBuffer[tablePointer] = byteZ;
                            }
                            if (zBuffer[++tablePointer2] >= z) {
                                pixelTable[tablePointer2] = color2;
                                zBuffer[tablePointer2] = byteZ;
                            }
                            imagePointer += intervalX;
                        }
                    }
                    continue;
                }
                while (xR < maxX) {
                    if (imagePointer >= imagePointerT) {
                        imagePointerT += this.lengthTable[decodePointer] << 16;
                        color = this.colorTable[decodePointer++];
                    }
                    if (color == 0) {
                        temp = (imagePointerT - imagePointer) / intervalX + 1;
                        xR += temp;
                        tablePointer += temp;
                        imagePointer += temp * intervalX;
                    }
                    color2 = colorDataTemp[color];
                    while (imagePointer < imagePointerT && xR++ < maxX) {
                        int tablePointerT = ++tablePointer;
                        for (int i = numberOfLines; i > 0; --i) {
                            if (zBuffer[tablePointerT] >= z) {
                                pixelTable[tablePointerT] = color2;
                                zBuffer[tablePointerT] = byteZ;
                            }
                            tablePointerT += tableWidth;
                        }
                        imagePointer += intervalX;
                    }
                }
            }
        }
    }

    public void drawSymmetry3D(PixelGraphics pixelGraphics, int x, int y, int width, int height, int z, int targetColor, int colorFactor) throws Exception {
        int tablePointer;
        int[] colorDataTemp;
        int minX;
        int minY;
        int[] pixelTable = pixelGraphics.renderTable;
        byte[] zBuffer = pixelGraphics.zBuffer;
        int tableWidth = pixelGraphics.renderWidth;
        int tableHeight = pixelGraphics.renderHeight;
        byte byteZ = (byte)z;
        int maxY = y < pixelGraphics.clipMaxY - height ? height : pixelGraphics.clipMaxY - y;
        int drawHeight = maxY - (minY = y >= pixelGraphics.clipMinY ? 0 : pixelGraphics.clipMinY - y);
        if (drawHeight <= 0) {
            return;
        }
        int maxX = x < pixelGraphics.clipMaxX - width ? width : pixelGraphics.clipMaxX - x;
        int drawWidth = maxX - (minX = x >= pixelGraphics.clipMinX ? 0 : pixelGraphics.clipMinX - x);
        if (drawWidth <= 0) {
            return;
        }
        int intervalX = (this.imageWidth << 16) / width;
        int intervalY = (this.imageHeight << 16) / height;
        int line = 0;
        int[] lineNumber = new int[height];
        for (int i = 0; i < height; ++i) {
            lineNumber[i] = line >> 16;
            line += intervalY;
        }
        int imagePointer = 0;
        int decodePointer = 0;
        int imagePointerT = this.lengthTable[decodePointer++] << 16;
        if (targetColor >= 0) {
            colorDataTemp = new int[this.numberOfColors];
            for (int i = this.numberOfColors - 1; i >= 0; --i) {
                colorDataTemp[i] = this.colorData[i] * colorFactor + targetColor >> 4 | 0xFF000000;
            }
        } else {
            colorDataTemp = this.colorData;
        }
        minX = width - maxX;
        maxX = minX + drawWidth;
        int widthM = width - 1;
        if (intervalY >= 65536) {
            for (int yR = minY; yR < maxY; ++yR) {
                tablePointer = x + width - minX + (y + yR) * tableWidth;
                imagePointer = (lineNumber[yR] * this.imageWidth << 16) + minX * intervalX;
                while (imagePointer >= imagePointerT) {
                    imagePointerT += this.lengthTable[decodePointer++] << 16;
                }
                byte color = this.colorTable[decodePointer - 1];
                int xR = minX;
                while (xR < maxX) {
                    if (imagePointer >= imagePointerT) {
                        imagePointerT += this.lengthTable[decodePointer] << 16;
                        color = this.colorTable[decodePointer++];
                    }
                    if (color == 0) {
                        int temp = (imagePointerT - imagePointer) / intervalX + 1;
                        xR += temp;
                        tablePointer -= temp;
                        imagePointer += temp * intervalX;
                    }
                    int color2 = colorDataTemp[color];
                    while (imagePointer < imagePointerT && xR++ < maxX) {
                        if (zBuffer[--tablePointer] >= z) {
                            pixelTable[tablePointer] = color2;
                            zBuffer[tablePointer] = byteZ;
                        }
                        imagePointer += intervalX;
                    }
                }
            }
        } else {
            int yR = minY;
            int maxYM = maxY - 1;
            while (yR < maxY) {
                int color2;
                int temp;
                tablePointer = x + width - minX + (y + yR) * tableWidth;
                imagePointer = (lineNumber[yR] * this.imageWidth << 16) + minX * intervalX;
                int imageLine = lineNumber[yR++];
                int numberOfLines = 1;
                while (yR < maxY && lineNumber[yR] == imageLine) {
                    ++numberOfLines;
                    ++yR;
                }
                while (imagePointer >= imagePointerT) {
                    imagePointerT += this.lengthTable[decodePointer++] << 16;
                }
                byte color = this.colorTable[decodePointer - 1];
                int xR = minX;
                if (numberOfLines == 1) {
                    while (xR < maxX) {
                        if (imagePointer >= imagePointerT) {
                            imagePointerT += this.lengthTable[decodePointer] << 16;
                            color = this.colorTable[decodePointer++];
                        }
                        if (color == 0) {
                            temp = (imagePointerT - imagePointer) / intervalX + 1;
                            xR += temp;
                            tablePointer -= temp;
                            imagePointer += temp * intervalX;
                        }
                        color2 = colorDataTemp[color];
                        while (imagePointer < imagePointerT && xR++ < maxX) {
                            if (zBuffer[--tablePointer] >= z) {
                                pixelTable[tablePointer] = color2;
                                zBuffer[tablePointer] = byteZ;
                            }
                            imagePointer += intervalX;
                        }
                    }
                    continue;
                }
                if (numberOfLines == 2) {
                    int tablePointer2 = tablePointer + tableWidth;
                    while (xR < maxX) {
                        if (imagePointer >= imagePointerT) {
                            imagePointerT += this.lengthTable[decodePointer] << 16;
                            color = this.colorTable[decodePointer++];
                        }
                        if (color == 0) {
                            temp = (imagePointerT - imagePointer) / intervalX + 1;
                            xR += temp;
                            tablePointer -= temp;
                            tablePointer2 -= temp;
                            imagePointer += temp * intervalX;
                        }
                        color2 = colorDataTemp[color];
                        while (imagePointer < imagePointerT && xR++ < maxX) {
                            if (zBuffer[--tablePointer] >= z) {
                                pixelTable[tablePointer] = color2;
                                zBuffer[tablePointer] = byteZ;
                            }
                            if (zBuffer[--tablePointer2] >= z) {
                                pixelTable[tablePointer2] = color2;
                                zBuffer[tablePointer2] = byteZ;
                            }
                            imagePointer += intervalX;
                        }
                    }
                    continue;
                }
                while (xR < maxX) {
                    if (imagePointer >= imagePointerT) {
                        imagePointerT += this.lengthTable[decodePointer] << 16;
                        color = this.colorTable[decodePointer++];
                    }
                    if (color == 0) {
                        temp = (imagePointerT - imagePointer) / intervalX + 1;
                        xR += temp;
                        tablePointer -= temp;
                        imagePointer += temp * intervalX;
                    }
                    color2 = colorDataTemp[color];
                    while (imagePointer < imagePointerT && xR++ < maxX) {
                        int tablePointerT = --tablePointer;
                        for (int i = numberOfLines; i > 0; --i) {
                            if (zBuffer[tablePointerT] >= z) {
                                pixelTable[tablePointerT] = color2;
                                zBuffer[tablePointerT] = byteZ;
                            }
                            tablePointerT += tableWidth;
                        }
                        imagePointer += intervalX;
                    }
                }
            }
        }
    }

    protected int anchorX(int anchor, int x, int width) {
        if ((anchor & 1) != 0) {
            return x - (width >> 1);
        }
        if ((anchor & 8) != 0) {
            return x - width;
        }
        return x;
    }

    protected int anchorY(int anchor, int y, int height) {
        if ((anchor & 2) != 0) {
            return y - (height >> 1);
        }
        if ((anchor & 0x20) != 0) {
            return y - height;
        }
        return y;
    }
}

