/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.log.file;

import de.enough.polish.log.LogEntry;
import de.enough.polish.log.LogHandler;
import de.enough.polish.util.ArrayList;
import java.io.PrintStream;
import java.util.Enumeration;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import javax.microedition.io.file.FileSystemRegistry;

public class FileLogHandler
extends LogHandler
implements Runnable {
    private PrintStream out;
    private boolean isShuttingDown;
    private ArrayList scheduledLogEntries;
    private boolean isPermanentLogError;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleLogEntry(LogEntry entry) throws Exception {
        if (this.isPermanentLogError) {
            return;
        }
        if (this.scheduledLogEntries == null) {
            this.scheduledLogEntries = new ArrayList(7);
            Thread thread = new Thread(this);
            thread.start();
        }
        ArrayList arrayList = this.scheduledLogEntries;
        synchronized (arrayList) {
            this.scheduledLogEntries.add(entry);
            this.scheduledLogEntries.notify();
        }
    }

    public void exit() {
        super.exit();
        if (this.out != null) {
            this.out.close();
            this.out = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object url;
        FileConnection connection = null;
        FileLogHandler fileLogHandler = this;
        synchronized (fileLogHandler) {
            url = null;
            String root = null;
            Enumeration enumeration = FileSystemRegistry.listRoots();
            String roots = "";
            root = (String)enumeration.nextElement();
            url = "file:///" + root + "j2melog.txt";
            try {
                connection = (FileConnection)Connector.open((String)url, (int)3);
                if (!connection.exists()) {
                    connection.create();
                }
                this.out = new PrintStream(connection.openOutputStream());
                this.out.println("time\tlevel\tclass\tline\tmessage\terror");
            }
            catch (Exception e2) {
                e2.printStackTrace();
                System.err.println("Unable to open file log: " + e2);
                this.isPermanentLogError = true;
                return;
            }
        }
        while (!this.isShuttingDown) {
            Object entry;
            while (this.scheduledLogEntries.size() != 0) {
                url = this.scheduledLogEntries;
                synchronized (url) {
                    entry = (LogEntry)this.scheduledLogEntries.remove(0);
                }
                StringBuffer buffer = new StringBuffer();
                buffer.append(((LogEntry)entry).time).append('\t').append(((LogEntry)entry).level).append('\t').append(((LogEntry)entry).className).append('\t').append(((LogEntry)entry).lineNumber).append('\t').append(((LogEntry)entry).message).append('\t').append(((LogEntry)entry).exception);
                try {
                    this.out.println(buffer.toString());
                }
                catch (Exception e3) {
                    e3.printStackTrace();
                    System.err.println("Unable to write log entry: " + e3);
                }
            }
            try {
                entry = this.scheduledLogEntries;
                synchronized (entry) {
                    this.scheduledLogEntries.wait();
                }
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }
}

