/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.log.bluetooth;

import de.enough.polish.log.LogEntry;
import de.enough.polish.log.LogHandler;
import de.enough.polish.util.ArrayList;
import javax.bluetooth.DiscoveryAgent;
import javax.bluetooth.L2CAPConnection;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.UUID;
import javax.microedition.io.Connector;

public class BluetoothLogHandler
extends LogHandler
implements Runnable {
    private ArrayList buffer;
    private L2CAPConnection connection;
    private Exception exception;

    public BluetoothLogHandler() {
        Thread thread = new Thread(this);
        thread.start();
    }

    public void handleLogEntry(LogEntry logEntry) throws Exception {
        if (this.connection != null) {
            this.connection.send(logEntry.toString().getBytes());
        } else {
            ArrayList list = this.buffer;
            if (list != null) {
                list.add(logEntry);
            } else if (this.exception != null) {
                Exception e2 = this.exception;
                this.exception = null;
                throw e2;
            }
        }
    }

    public void run() {
        try {
            LocalDevice localDevice = LocalDevice.getLocalDevice();
            DiscoveryAgent agent = localDevice.getDiscoveryAgent();
            String connectionUrl = agent.selectService(new UUID(256L), 0, false);
            if (connectionUrl == null) {
                return;
            }
            this.connection = (L2CAPConnection)Connector.open((String)connectionUrl);
            ArrayList list = this.buffer;
            this.buffer = null;
            for (int i = 0; i < list.size(); ++i) {
                LogEntry entry = (LogEntry)list.get(i);
                this.connection.send(entry.toString().getBytes());
            }
        }
        catch (Exception e2) {
            this.exception = e2;
            e2.printStackTrace();
            this.buffer = null;
        }
    }
}

