/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui;

import de.enough.polish.util.ImageUtil;
import javax.microedition.lcdui.CustomItem;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class PictureBrowserItem
extends CustomItem {
    private Image[] thumbnails;
    private int[][] thumbnailsRGBData;
    private int selectedThumbIndex = 0;
    private int thumbnailWidth;
    private int thumbnailHeight;
    private int selectedWidth;
    private int selectedHeight;
    private String[] urls;
    private int paddingHorizontal = 1;
    private int paddingVertical = 1;

    public PictureBrowserItem(String label, Image[] thumbnails, String[] urls, int scaleFactor) {
        super(label);
        this.thumbnails = thumbnails;
        this.urls = urls;
        Image thumbnail = thumbnails[0];
        this.thumbnailWidth = thumbnail.getWidth() * scaleFactor / 100;
        this.thumbnailHeight = thumbnail.getHeight() * scaleFactor / 100;
        this.selectedWidth = this.thumbnailWidth * 2 + this.paddingVertical;
        this.selectedHeight = this.thumbnailHeight * 2 + this.paddingVertical;
        int size = this.thumbnailWidth * this.thumbnailHeight;
        this.thumbnailsRGBData = new int[thumbnails.length][];
        for (int i = 0; i < thumbnails.length; ++i) {
            int w = thumbnails[i].getWidth();
            int h = thumbnails[i].getHeight();
            int[] rgbData = new int[w * h];
            this.thumbnails[i].getRGB(rgbData, 0, w, 0, 0, w, h);
            if (i == this.selectedThumbIndex) {
                this.thumbnailsRGBData[i] = new int[this.selectedHeight * this.selectedWidth];
                ImageUtil.scale(rgbData, this.selectedWidth, this.selectedHeight, w, h, this.thumbnailsRGBData[i]);
                continue;
            }
            this.thumbnailsRGBData[i] = new int[size];
            ImageUtil.scale(rgbData, this.thumbnailWidth, this.thumbnailHeight, w, h, this.thumbnailsRGBData[i]);
        }
    }

    public int getNumberOfThumbnails() {
        return this.thumbnailsRGBData.length;
    }

    protected int getMinContentWidth() {
        return this.thumbnailWidth * 2 + 2 * this.paddingHorizontal + this.selectedWidth;
    }

    protected int getMinContentHeight() {
        return this.thumbnailHeight * 2 + this.paddingVertical;
    }

    protected int getPrefContentWidth(int availableHeight) {
        return this.getMinContentWidth();
    }

    protected int getPrefContentHeight(int availableWidth) {
        return this.getMinContentHeight();
    }

    public void setSelectedThumbIndex(int index) {
        int[] newSelectedRbgData = this.thumbnailsRGBData[index];
        if (index == this.selectedThumbIndex && newSelectedRbgData != null) {
            return;
        }
        Image thumbnail = this.thumbnails[index];
        int width = thumbnail.getWidth();
        int height = thumbnail.getHeight();
        int[] rgbData = new int[width * height];
        thumbnail.getRGB(rgbData, 0, width, 0, 0, width, height);
        newSelectedRbgData = new int[this.selectedHeight * this.selectedWidth];
        ImageUtil.scale(rgbData, this.selectedWidth, this.selectedHeight, width, height, newSelectedRbgData);
        if (this.thumbnailsRGBData[this.selectedThumbIndex] != null) {
            Image selectedThumb = this.thumbnails[this.selectedThumbIndex];
            width = selectedThumb.getWidth();
            height = selectedThumb.getHeight();
            rgbData = new int[width * height];
            selectedThumb.getRGB(rgbData, 0, width, 0, 0, width, height);
            this.thumbnailsRGBData[this.selectedThumbIndex] = new int[this.thumbnailWidth * this.thumbnailHeight];
            ImageUtil.scale(rgbData, this.thumbnailWidth, this.thumbnailHeight, width, height, this.thumbnailsRGBData[this.selectedThumbIndex]);
        }
        this.thumbnailsRGBData[index] = newSelectedRbgData;
        this.selectedThumbIndex = index;
        this.repaint();
    }

    protected void paint(Graphics g2, int w, int h) {
        int translateX = g2.getTranslateX();
        int translateY = g2.getTranslateY();
        g2.translate(-translateX, -translateY);
        int index = this.selectedThumbIndex - Math.min(2, this.thumbnails.length - 1);
        if (index < 0) {
            index = this.thumbnails.length + index;
        }
        int number = Math.min(5, this.thumbnails.length);
        int x = translateX;
        int y = translateY;
        for (int i = 0; i < number; ++i) {
            if (index == this.selectedThumbIndex) {
                y = translateY;
                g2.drawRGB(this.thumbnailsRGBData[index], 0, this.selectedWidth, x += this.thumbnailWidth + this.paddingHorizontal, y, this.selectedWidth, this.selectedHeight, false);
                x += this.selectedWidth + this.paddingHorizontal;
            } else {
                g2.drawRGB(this.thumbnailsRGBData[index], 0, this.thumbnailWidth, x, y, this.thumbnailWidth, this.thumbnailHeight, false);
                y += this.thumbnailHeight + this.paddingVertical;
            }
            if (++index != this.thumbnails.length) continue;
            index = 0;
        }
        g2.translate(translateX, translateY);
    }

    protected boolean traverse(int dir, int viewportWidth, int viewportHeight, int[] visRect_inout) {
        if (this.thumbnails.length > 1) {
            if (dir == 2) {
                if (this.selectedThumbIndex == 0) {
                    this.setSelectedThumbIndex(this.thumbnails.length - 1);
                } else {
                    this.setSelectedThumbIndex(this.selectedThumbIndex - 1);
                }
                return true;
            }
            if (dir == 5) {
                if (this.selectedThumbIndex < this.thumbnails.length - 1) {
                    this.setSelectedThumbIndex(this.selectedThumbIndex + 1);
                } else {
                    this.setSelectedThumbIndex(0);
                }
                return true;
            }
        }
        return false;
    }

    public int getSelectedThumbIndex() {
        return this.selectedThumbIndex;
    }

    public String getUrl(int i) {
        if (this.urls == null) {
            return null;
        }
        return this.urls[i];
    }
}

