/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.util;

import de.enough.polish.util.Comparator;

public final class Arrays
implements Comparator {
    private static final Comparator STRING_COMPARATOR = new Arrays();

    private Arrays() {
    }

    public int compare(Object o1, Object o2) {
        return o1.toString().compareTo(o2.toString());
    }

    public static void sort(Object[] obj) {
        Arrays.sort(obj, STRING_COMPARATOR);
    }

    public static void shellSort(Object[] array) {
        Arrays.shellSort(array, STRING_COMPARATOR);
    }

    public static void shellSort(Object[] array, Comparator comparator) {
        int increment = 3;
        while (true) {
            for (int i = 0; i < array.length; ++i) {
                Object temp = array[i];
                for (int j = i; j >= increment && comparator.compare(array[j - increment], temp) > 0; j -= increment) {
                    array[j] = array[j - increment];
                }
                array[j] = temp;
            }
            if (increment == 1) break;
            increment >>= 1;
        }
    }

    public static void quicksort(Object[] obj) {
        Arrays.quicksort(obj, obj.length, STRING_COMPARATOR);
    }

    public static void iQuick(int[] array, int elements) {
        int left = 0;
        int right = elements - 1;
        int top = 0;
        int sSize = elements / 2;
        int[] lStack = new int[sSize];
        int[] rStack = new int[sSize];
        lStack[top] = left;
        rStack[top] = right;
        while (top >= 0) {
            left = lStack[top];
            right = rStack[top];
            --top;
            while (left < right) {
                int i = left;
                int j = right;
                int x = array[(left + right) / 2];
                while (i <= j) {
                    while (array[i] < x) {
                        ++i;
                    }
                    while (array[j] > x) {
                        --j;
                    }
                    if (i > j) continue;
                    int tmp = array[i];
                    array[i] = array[j];
                    array[j] = tmp;
                    ++i;
                    --j;
                }
                if (j - left < right - i) {
                    if (i < right) {
                        lStack[++top] = i;
                        rStack[top] = right;
                    }
                    right = j;
                    continue;
                }
                if (left < j) {
                    lStack[++top] = left;
                    rStack[top] = j;
                }
                left = i;
            }
        }
    }

    public static void quicksort(Object[] obj, int elements, Comparator comparator) {
        int left = 0;
        int right = elements - 1;
        int top = 0;
        int sSize = elements / 2;
        int[] lStack = new int[sSize];
        int[] rStack = new int[sSize];
        lStack[top] = left;
        rStack[top] = right;
        while (top >= 0) {
            left = lStack[top];
            right = rStack[top];
            --top;
            while (left < right) {
                int i = left;
                int j = right;
                Object tmp = obj[(left + right) / 2];
                while (i <= j) {
                    while (comparator.compare(tmp, obj[i]) > 0) {
                        ++i;
                    }
                    while (comparator.compare(tmp, obj[j]) < 0) {
                        --j;
                    }
                    if (i > j) continue;
                    tmp = obj[i];
                    obj[i] = obj[j];
                    obj[j] = tmp;
                    ++i;
                    --j;
                }
                if (j - left < right - i) {
                    if (i < right) {
                        lStack[++top] = i;
                        rStack[top] = right;
                    }
                    right = j;
                    continue;
                }
                if (left < j) {
                    lStack[++top] = left;
                    rStack[top] = j;
                }
                left = i;
            }
        }
    }

    public static void sort(Object[] obj, Comparator comparator) {
        Arrays.shellSort(obj, comparator);
    }

    public static boolean equals(Object array1, Object array2) {
        if (array1 instanceof byte[]) {
            byte[] pa1 = (byte[])array1;
            byte[] pa2 = (byte[])array2;
            if (pa1.length != pa2.length) {
                return false;
            }
            for (int i = 0; i < pa1.length; ++i) {
                byte p1 = pa1[i];
                byte p2 = pa2[i];
                if (p1 == p2) continue;
                return false;
            }
        } else if (array1 instanceof short[]) {
            short[] pa1 = (short[])array1;
            short[] pa2 = (short[])array2;
            if (pa1.length != pa2.length) {
                return false;
            }
            for (int i = 0; i < pa1.length; ++i) {
                short p1 = pa1[i];
                short p2 = pa2[i];
                if (p1 == p2) continue;
                return false;
            }
        } else if (array1 instanceof int[]) {
            int[] pa1 = (int[])array1;
            int[] pa2 = (int[])array2;
            if (pa1.length != pa2.length) {
                return false;
            }
            for (int i = 0; i < pa1.length; ++i) {
                int p1 = pa1[i];
                int p2 = pa2[i];
                if (p1 == p2) continue;
                return false;
            }
        } else if (array1 instanceof long[]) {
            long[] pa1 = (long[])array1;
            long[] pa2 = (long[])array2;
            if (pa1.length != pa2.length) {
                return false;
            }
            for (int i = 0; i < pa1.length; ++i) {
                long p1 = pa1[i];
                long p2 = pa2[i];
                if (p1 == p2) continue;
                return false;
            }
        } else if (array1 instanceof boolean[]) {
            boolean[] pa1 = (boolean[])array1;
            boolean[] pa2 = (boolean[])array2;
            if (pa1.length != pa2.length) {
                return false;
            }
            for (int i = 0; i < pa1.length; ++i) {
                boolean p1 = pa1[i];
                boolean p2 = pa2[i];
                if (p1 == p2) continue;
                return false;
            }
        } else if (array1 instanceof float[]) {
            float[] pa1 = (float[])array1;
            float[] pa2 = (float[])array2;
            if (pa1.length != pa2.length) {
                return false;
            }
            for (int i = 0; i < pa1.length; ++i) {
                float p1 = pa1[i];
                float p2 = pa2[i];
                if (p1 == p2) continue;
                return false;
            }
        } else if (array1 instanceof double[]) {
            double[] pa1 = (double[])array1;
            double[] pa2 = (double[])array2;
            if (pa1.length != pa2.length) {
                return false;
            }
            for (int i = 0; i < pa1.length; ++i) {
                double p1 = pa1[i];
                double p2 = pa2[i];
                if (p1 == p2) continue;
                return false;
            }
        } else if (array1 instanceof Object[]) {
            Object[] oa1 = (Object[])array1;
            Object[] oa2 = (Object[])array2;
            if (oa1.length != oa2.length) {
                return false;
            }
            for (int i = 0; i < oa1.length; ++i) {
                Object o1 = oa1[i];
                Object o2 = oa2[i];
                if ((o1 != null || o2 == null) && o1.equals(o2)) continue;
                return false;
            }
        } else {
            return array1.equals(array2);
        }
        return true;
    }
}

