/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.util;

import de.enough.polish.util.BitMapFontViewer;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import javax.microedition.lcdui.Image;

public final class BitMapFont {
    private static Hashtable fontsByUrl = new Hashtable();
    private String fontUrl;
    private Image fontImage;
    private boolean hasMixedCase;
    private byte[] characterWidths;
    private short[] xPositions;
    private String characterMap;
    private int fontHeight;
    private int spaceIndex;

    private BitMapFont(String fontUrl) {
        this.fontUrl = fontUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BitMapFontViewer getViewer(String input) {
        if (this.fontImage == null) {
            InputStream in = null;
            try {
                String map;
                in = this.getClass().getResourceAsStream(this.fontUrl);
                if (in == null) {
                    BitMapFontViewer bitMapFontViewer = null;
                    return bitMapFontViewer;
                }
                DataInputStream dataIn = new DataInputStream(in);
                this.hasMixedCase = dataIn.readBoolean();
                this.characterMap = map = dataIn.readUTF();
                this.spaceIndex = map.indexOf(32);
                int length = map.length();
                this.characterWidths = new byte[length];
                this.xPositions = new short[length];
                short xPos = 0;
                for (int i = 0; i < length; ++i) {
                    byte width;
                    this.characterWidths[i] = width = dataIn.readByte();
                    this.xPositions[i] = xPos;
                    xPos = (short)(xPos + width);
                }
                this.fontImage = Image.createImage((InputStream)in);
                this.fontHeight = this.fontImage.getHeight();
                this.fontUrl = null;
            }
            catch (IOException e2) {
                BitMapFontViewer map = null;
                return map;
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException e3) {}
            }
        }
        if (!this.hasMixedCase) {
            input = input.toLowerCase();
        }
        int length = input.length();
        int[] indeces = new int[length];
        for (int i = length - 1; i >= 0; --i) {
            char inputCharacter = input.charAt(i);
            indeces[i] = inputCharacter == '\n' ? -2 : this.characterMap.indexOf(inputCharacter);
        }
        return new BitMapFontViewer(this.fontImage, indeces, this.xPositions, this.characterWidths, this.fontHeight, this.spaceIndex, 1);
    }

    public static BitMapFont getInstance(String url) {
        BitMapFont font = (BitMapFont)fontsByUrl.get(url);
        if (font == null) {
            font = new BitMapFont(url);
            fontsByUrl.put(url, font);
        }
        return font;
    }

    public static void removeInstance(String url) {
        fontsByUrl.remove(url);
    }
}

