/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.util;

import de.enough.polish.util.MathUtil;
import de.enough.polish.util.RgbImage;

public final class ImageUtil {
    private ImageUtil() {
    }

    public static void scale(int scaleFactor, int width, int height, int[] rgbData, int[] scaledRgbData) {
        int yStart = (height - height * 100 / scaleFactor) / 2 * width;
        int xStart = (width - width * 100 / scaleFactor) / 2;
        for (int y = 0; y < height; ++y) {
            int c1 = y * width;
            int c2 = yStart + y * 100 / scaleFactor * width;
            for (int x = 0; x < width; ++x) {
                scaledRgbData[c1 + x] = rgbData[c2 + xStart + x * 100 / scaleFactor];
            }
        }
    }

    public static void scale(int opacity, int scaleFactor, int width, int height, int[] rgbData, int[] scaledRgbData) {
        opacity = opacity << 24 | 0xFFFFFF;
        int yStart = (height - height * 100 / scaleFactor) / 2 * width;
        int xStart = (width - width * 100 / scaleFactor) / 2;
        for (int y = 0; y < height; ++y) {
            int c1 = y * width;
            int c2 = yStart + y * 100 / scaleFactor * width;
            for (int x = 0; x < width; ++x) {
                scaledRgbData[c1 + x] = rgbData[c2 + xStart + x * 100 / scaleFactor] & opacity;
            }
        }
    }

    public static int[] scale(int scaledWidth, int scaledHeight, int scanlength, int sourceWidth, int sourceHeight, int[] rgbData) {
        int[] scaledRgbData = new int[scaledWidth * scaledHeight];
        for (int y = 0; y < scaledHeight; ++y) {
            int c1 = y * scaledWidth;
            int c2 = y * sourceHeight / scaledHeight * scanlength;
            for (int x = 0; x < scaledWidth; ++x) {
                scaledRgbData[c1 + x] = rgbData[c2 + x * sourceWidth / scaledWidth];
            }
        }
        return scaledRgbData;
    }

    public static void rotate(RgbImage image, int angle) {
        ImageUtil.rotate(image, angle, image.getWidth() / 2, image.getHeight() / 2);
    }

    public static void rotate(RgbImage image, int angle, int referenceX, int referenceY) {
        int[] rgbData = image.getRgbData();
        int width = image.getWidth();
        int height = image.getHeight();
        double degreeCos = Math.cos(Math.PI * (double)angle / 180.0);
        double degreeSin = Math.sin(Math.PI * (double)angle / 180.0);
        int rotatedWidth = ImageUtil.getRotatedWidth(angle, width, height, degreeCos, degreeSin);
        int rotatedHeight = ImageUtil.getRotatedHeight(angle, width, height, degreeCos, degreeSin);
        int[] rotatedRgbData = new int[rotatedWidth * rotatedHeight];
        ImageUtil.rotate(rgbData, width, height, referenceX, referenceY, 0xFFFFFF, degreeCos, degreeSin, rotatedRgbData, rotatedWidth, rotatedHeight);
        image.setRgbData(rotatedRgbData, rotatedWidth);
        image.setWidth(rotatedWidth);
        image.setHeight(rotatedHeight);
    }

    public static final int[] rotate(int[] argbArray, int width, int height, int degree, int backgroundColor) {
        return ImageUtil.rotate(argbArray, width, height, degree, width / 2, height / 2, backgroundColor);
    }

    public static final int[] rotate(int[] sourceRgbData, int width, int height, int targetRgbData, int degree, double degreeCos, double degreeSin, int backgroundColor) {
        return ImageUtil.rotate(sourceRgbData, width, height, degree, width / 2, height / 2, backgroundColor);
    }

    public static final int[] rotate(int[] sourceRgbData, int width, int height, int degree, int referenceX, int referenceY, int backgroundColor) {
        double degreeCos = Math.cos(Math.PI * (double)degree / 180.0);
        double degreeSin = Math.sin(Math.PI * (double)degree / 180.0);
        int rotatedWidth = ImageUtil.getRotatedWidth(degree, width, height, degreeCos, degreeSin);
        int rotatedHeight = ImageUtil.getRotatedHeight(degree, width, height, degreeCos, degreeSin);
        int[] rotatedRGB = new int[rotatedHeight * rotatedWidth];
        ImageUtil.rotate(sourceRgbData, width, height, referenceX, referenceY, backgroundColor, degreeCos, degreeSin, rotatedRGB, rotatedWidth, rotatedHeight);
        return rotatedRGB;
    }

    public static void rotate(int[] sourceRgbData, int width, int height, int referenceX, int referenceY, int backgroundColor, double degreeCos, double degreeSin, int[] rotatedRGB, int rotatedWidth, int rotatedHeight) {
        int halfOfWidth = width / 2;
        int halfOfHeigth = height / 2;
        for (int x = 0; x < rotatedWidth; ++x) {
            for (int y = 0; y < rotatedHeight; ++y) {
                int refX = x - referenceX;
                int refY = y - referenceY;
                int newX = (int)((double)refX * degreeCos + (double)refY * degreeSin);
                int newY = (int)((double)refY * degreeCos - (double)refX * degreeSin);
                if ((newX += halfOfWidth) >= 0 && newX < width && (newY += halfOfHeigth) >= 0 && newY < height) {
                    int sumXY = newX + newY * width;
                    rotatedRGB[x + y * rotatedWidth] = sourceRgbData[sumXY];
                    continue;
                }
                rotatedRGB[x + y * rotatedWidth] = backgroundColor;
            }
        }
    }

    public static final int getRotatedHeight(int degree, int width, int heigth, double degreeCos, double degreeSin) {
        long maxY;
        if (degree == -90 || degree == 90 || degree == 270 || degree == -270) {
            return width;
        }
        if (degree == 360 || degree == 180 || degree == 0) {
            return heigth;
        }
        long pointY1 = MathUtil.round(0.0 * degreeSin + 0.0 * degreeCos);
        long pointY2 = MathUtil.round((double)width * degreeSin + 0.0 * degreeCos);
        long pointY3 = MathUtil.round(0.0 * degreeSin + (double)heigth * degreeCos);
        long pointY4 = MathUtil.round((double)width * degreeSin + (double)heigth * degreeCos);
        long minY = pointY1;
        if (pointY2 < minY) {
            minY = pointY2;
        }
        if (pointY3 < minY) {
            minY = pointY3;
        }
        if (pointY4 < minY) {
            minY = pointY4;
        }
        if (pointY2 > (maxY = pointY1)) {
            maxY = pointY2;
        }
        if (pointY3 > maxY) {
            maxY = pointY3;
        }
        if (pointY4 > maxY) {
            maxY = pointY4;
        }
        return (int)(maxY - minY);
    }

    public static final int getRotatedWidth(int degree, int width, int heigth, double degreeCos, double degreeSin) {
        long maxX;
        if (degree == -90 || degree == 90 || degree == 270 || degree == -270) {
            return heigth;
        }
        if (degree == 360 || degree == 180 || degree == 0) {
            return width;
        }
        long pointX1 = MathUtil.round(0.0 * degreeCos - 0.0 * degreeSin);
        long pointX2 = MathUtil.round((double)width * degreeCos - 0.0 * degreeSin);
        long pointX3 = MathUtil.round(0.0 * degreeCos - (double)heigth * degreeSin);
        long pointX4 = MathUtil.round((double)width * degreeCos - (double)heigth * degreeSin);
        long minX = pointX1;
        if (pointX2 < minX) {
            minX = pointX2;
        }
        if (pointX3 < minX) {
            minX = pointX3;
        }
        if (pointX4 < minX) {
            minX = pointX4;
        }
        if (pointX2 > (maxX = pointX1)) {
            maxX = pointX2;
        }
        if (pointX3 > maxX) {
            maxX = pointX3;
        }
        if (pointX4 > maxX) {
            maxX = pointX4;
        }
        return (int)(maxX - minX);
    }

    public static final int[] scale(int[] rgbData, int newWidth, int newHeight, int oldWidth, int oldHeight) {
        int[] newrgbData = new int[newWidth * newHeight];
        ImageUtil.scale(rgbData, newWidth, newHeight, oldWidth, oldHeight, newrgbData);
        return newrgbData;
    }

    public static final int[] stretchVertical(int[] argbArray, int topStrechFactor, int bottomStrechFactor, int width, int heigth) {
        int biggerWidth;
        int procentualScalingHeight;
        int newWidthTop = width * topStrechFactor / 100;
        int newWidthBottom = width * bottomStrechFactor / 100;
        if (newWidthTop < newWidthBottom) {
            procentualScalingHeight = (newWidthBottom - newWidthTop) / heigth;
            biggerWidth = newWidthBottom;
        } else {
            procentualScalingHeight = (newWidthTop - newWidthBottom) / heigth;
            biggerWidth = newWidthTop;
        }
        int[] newArgbArray = new int[biggerWidth * heigth];
        return ImageUtil.stretchVertical(argbArray, newWidthTop, newWidthBottom, biggerWidth, width, heigth, procentualScalingHeight, newArgbArray);
    }

    public static final int[] stretchVertical(int[] argbArray, int newWidthTop, int newWidthBottom, int biggerWidth, int width, int heigth, int procentualScalingHeight, int[] newArgbArray) {
        if (procentualScalingHeight == 0) {
            ++procentualScalingHeight;
        }
        int length = newArgbArray.length;
        int oldLength = argbArray.length;
        int insideCurrentY = 0;
        int insideCurrentX = 0;
        int outsideCurrentX = 0;
        int sum1 = (biggerWidth - newWidthTop) / 2;
        int sum2 = biggerWidth - (biggerWidth - newWidthTop) / 2;
        for (int i = 0; i < length; ++i) {
            if ((outsideCurrentX = (outsideCurrentX + 1) % biggerWidth) == 0) {
                if (newWidthTop < newWidthBottom) {
                    sum1 = (biggerWidth - (newWidthTop += procentualScalingHeight)) / 2;
                    sum2 = biggerWidth - (biggerWidth - newWidthTop) / 2;
                } else if (newWidthTop > newWidthBottom) {
                    sum1 = (biggerWidth - (newWidthTop -= procentualScalingHeight)) / 2;
                    sum2 = biggerWidth - (biggerWidth - newWidthTop) / 2;
                }
                ++insideCurrentY;
                insideCurrentX = 0;
            }
            if (outsideCurrentX >= sum1 && outsideCurrentX < sum2) {
                insideCurrentX = (insideCurrentX + 1) % newWidthTop;
                newArgbArray[i] = argbArray[ImageUtil.scaledPixel(oldLength, width, heigth, newWidthTop, heigth, insideCurrentX, insideCurrentY)];
                continue;
            }
            newArgbArray[i] = 0;
        }
        return newArgbArray;
    }

    public static final int scaledPixel(int oldLength, int oldWidth, int oldHeigth, int newWidth, int newHeigth, int currentX, int currentY) {
        int horizontalScaleFactorPercent = newWidth * 100 / oldWidth;
        int verticalShrinkFactorPercent = newHeigth * 100 / oldHeigth;
        int targetArrayIndex = currentX * 100 / horizontalScaleFactorPercent + oldWidth * (currentY * 100 / verticalShrinkFactorPercent);
        if (targetArrayIndex >= oldLength) {
            targetArrayIndex = oldLength - 1;
        }
        if (targetArrayIndex < 0) {
            targetArrayIndex = 0;
        }
        return targetArrayIndex;
    }

    public static final int[] stretchHorizontal(int[] argbArray, int leftStrechFactor, int rightStrechFactor, int width, int heigth) {
        int biggerHeigth;
        int procentualScalingWidth;
        int newHeigthLeft = heigth * leftStrechFactor / 100;
        int newHeigthRight = heigth * rightStrechFactor / 100;
        if (newHeigthLeft < newHeigthRight) {
            procentualScalingWidth = (newHeigthRight - newHeigthLeft) / width;
            biggerHeigth = newHeigthRight;
        } else {
            procentualScalingWidth = (newHeigthLeft - newHeigthRight) / width;
            biggerHeigth = newHeigthLeft;
        }
        int[] newArgbArray = new int[biggerHeigth * width];
        return ImageUtil.stretchHorizontal(argbArray, newHeigthLeft, newHeigthRight, biggerHeigth, width, heigth, procentualScalingWidth, newArgbArray);
    }

    public static final int[] stretchHorizontal(int[] argbArray, int newLeftHeigth, int newRigthHeigth, int biggerHeigth, int width, int heigth, int procentualScalingHeight, int[] newArgbArray) {
        if (procentualScalingHeight == 0) {
            ++procentualScalingHeight;
        }
        int length = newArgbArray.length;
        int oldLength = argbArray.length;
        int idX = 0;
        int idY = 0;
        int x = 0;
        int y = 0;
        int whereIamAt = 0;
        int newHeigth = newLeftHeigth;
        int startColumn = (biggerHeigth - newHeigth) / 2;
        int endColumn = biggerHeigth - (biggerHeigth - newHeigth) / 2;
        for (int i = 0; i < length; ++i) {
            if (startColumn <= idY && endColumn >= idY) {
                newArgbArray[whereIamAt] = argbArray[ImageUtil.scaledPixel(oldLength, width, heigth, width, newHeigth, x, y)];
                y = (y + 1) % newHeigth;
            } else {
                newArgbArray[whereIamAt] = 0;
            }
            idY = (idY + 1) % biggerHeigth;
            whereIamAt = idX + idY * width;
            if (idY != 0) continue;
            ++idX;
            ++x;
            y = 0;
            if (newLeftHeigth < newRigthHeigth) {
                newHeigth += procentualScalingHeight;
            } else if (newLeftHeigth > newRigthHeigth) {
                newHeigth -= procentualScalingHeight;
            }
            startColumn = (biggerHeigth - newHeigth) / 2;
            endColumn = biggerHeigth - (biggerHeigth - newHeigth) / 2;
        }
        return newArgbArray;
    }

    public static final void scale(int[] rgbData, int newWidth, int newHeight, int oldWidth, int oldHeight, int[] newrgbData) {
        int currentX = 0;
        int currentY = 0;
        int oldLenght = rgbData.length;
        int newLength = newrgbData.length;
        int verticalShrinkFactorPercent = newHeight * 100 / oldHeight;
        int horizontalScaleFactorPercent = newWidth * 100 / oldWidth;
        for (int i = 0; i < newLength; ++i) {
            int targetArrayIndex;
            if ((currentX = (currentX + 1) % newWidth) == 0) {
                ++currentY;
            }
            if ((targetArrayIndex = currentX * 100 / horizontalScaleFactorPercent + oldWidth * (currentY * 100 / verticalShrinkFactorPercent)) >= oldLenght) {
                targetArrayIndex = oldLenght - 1;
            }
            if (targetArrayIndex < 0) {
                targetArrayIndex = 0;
            }
            newrgbData[i] = rgbData[targetArrayIndex];
        }
    }
}

