/*
 * Decompiled with CFR 0.152.
 */
package aeMods;

import java.io.InputStream;
import java.util.Hashtable;
import java.util.Vector;

public class IniFile {
    private static Object Float;
    final Hashtable hashtable = new Hashtable();
    private boolean printInfo = false;

    public static IniFile createFromResource(String file) {
        file = IniFile.getStringFromResource(file);
        return new IniFile(file);
    }

    public static IniFile createFromResourceWithKeys(String file) {
        file = IniFile.getStringFromResource(file);
        return new IniFile(file, true);
    }

    public IniFile(String str) {
        String[] lines = IniFile.cutOnStrings(str, '\n');
        for (int i = 0; i < lines.length; ++i) {
            int charIndex = lines[i].indexOf(61);
            if (charIndex < 0) continue;
            charIndex = charIndex >= 192 && charIndex <= 255 ? charIndex + 848 : charIndex;
            String key = lines[i].substring(0, charIndex).trim();
            String val = lines[i].substring(charIndex + 1).trim();
            this.hashtable.put(key, val);
        }
    }

    public IniFile(String str, boolean keys) {
        Hashtable<String, String> tmp = null;
        String[] lines = IniFile.cutOnStrings(str, '\n');
        String key = "";
        for (int i = 0; i < lines.length; ++i) {
            if (lines[i].charAt(0) == '[') {
                key = lines[i].substring(1, lines[i].length() - 1);
                tmp = new Hashtable<String, String>();
                this.hashtable.put(key, tmp);
                continue;
            }
            int charIndex = lines[i].indexOf(61);
            if (charIndex < 0) continue;
            String key2 = lines[i].substring(0, charIndex).trim();
            String val = lines[i].substring(charIndex + 1).trim();
            tmp.put(key2, val);
        }
    }

    public String get(String group, String key) {
        try {
            String val = (String)((Hashtable)this.hashtable.get(group)).get(key);
            return val;
        }
        catch (Exception e) {
            return null;
        }
    }

    public byte getByte(String group, String key) {
        return IniFile.parseByte(this.get(group, key));
    }

    public int getInt(String group, String key) {
        return IniFile.parseInt(this.get(group, key));
    }

    public int getInt(String group, String key, int def) {
        String tmp = this.get(group, key);
        if (tmp == null) {
            return def;
        }
        return IniFile.parseInt(tmp);
    }

    public String get(String key) {
        return (String)this.hashtable.get(key);
    }

    public byte getByte(String key) {
        return IniFile.parseByte(this.get(key));
    }

    public int getInt(String key) {
        return IniFile.parseInt(this.get(key));
    }

    public int getInt(String key, int def) {
        String tmp = this.get(key);
        if (tmp == null) {
            return def;
        }
        return IniFile.parseInt(tmp);
    }

    public long getLong(String key) {
        return IniFile.parseLong(this.get(key));
    }

    public static byte parseByte(String val) {
        val = IniFile.deleteExtremeSpaces(val);
        return (byte)Integer.parseInt(val);
    }

    public static int parseInt(String val) {
        val = IniFile.deleteExtremeSpaces(val);
        return Integer.parseInt(val);
    }

    public static long parseLong(String val) {
        val = IniFile.deleteExtremeSpaces(val);
        return Long.parseLong(val);
    }

    public static String deleteExtremeSpaces(String s) {
        while (s.length() > 0 && s.charAt(0) == ' ') {
            s = s.substring(1, s.length());
        }
        while (s.length() > 0 && s.charAt(0) == '+') {
            s = s.substring(1, s.length());
        }
        while (s.length() > 0 && s.charAt(0) == '0') {
            s = s.substring(1, s.length());
        }
        while (s.length() > 0 && s.charAt(s.length() - 1) == ' ') {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    public static String removeEmpty(String s) {
        while (s.length() > 0 && s.charAt(0) == ' ') {
            s = s.substring(1, s.length());
        }
        while (s.length() > 0 && s.charAt(s.length() - 1) == ' ') {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    public static String removeSpaces(String s) {
        char[] array = s.toCharArray();
        int sub = 0;
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != ' ') continue;
            int back = 0;
            for (int l = i; l >= 0; --l) {
                if (array[l] != '\"') continue;
                ++back;
            }
            if (back % 2 == 0) continue;
            ++sub;
        }
        char[] array2 = new char[array.length - sub];
        sub = 0;
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == ' ') {
                int back = 0;
                for (int l = i; l >= 0; --l) {
                    if (array[l] != '\"') continue;
                    ++back;
                }
                if (back % 2 != 0) continue;
                array2[sub] = array[i];
                ++sub;
                continue;
            }
            array2[sub] = array[i];
            ++sub;
        }
        return new String(array2);
    }

    public static int countChars(String str, char ch) {
        if (str == null) {
            return 0;
        }
        int c = 0;
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) != ch) continue;
            ++c;
        }
        return c;
    }

    public static String getStringFromResource(String file) {
        InputStream var1 = null;
        try {
            int var2;
            var1 = new Object().getClass().getResourceAsStream(file);
            StringBuffer var5 = new StringBuffer();
            while ((var2 = var1.read()) != -1) {
                if (var2 == 13) continue;
                var2 = var2 >= 192 && var2 <= 255 ? var2 + 848 : var2;
                var5.append((char)var2);
            }
            var1.close();
            return var5.toString();
        }
        catch (Exception var4) {
            System.out.println("ERROR in getStr: " + var4);
            if (var1 != null) {
                try {
                    var1.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    private static Vector fragments(String str, char d) {
        return IniFile.fragments(str, d, false);
    }

    private static Vector fragments(String str, char d, boolean addEmpty) {
        Vector<String> fragments = new Vector<String>();
        int end = 0;
        while (end < str.length()) {
            while (end < str.length() && str.charAt(end) == d) {
                if (addEmpty && end < str.length() - 1 && str.charAt(end + 1) == d) {
                    fragments.addElement(null);
                }
                ++end;
            }
            int begin = end;
            while (end < str.length() && str.charAt(end) != d) {
                ++end;
            }
            if (begin >= end) continue;
            String frg = str.substring(begin, end);
            fragments.addElement(frg);
        }
        return fragments;
    }

    public static String[] cutOnStrings(String str, char d) {
        Vector var2 = IniFile.fragments(str, d);
        Object[] var3 = new String[var2.size()];
        var2.copyInto(var3);
        return var3;
    }

    public static int[] cutOnInts(String str, char d) {
        String[] cuts = IniFile.cutOnStrings(str, d);
        int[] out = new int[cuts.length];
        for (int i = 0; i < cuts.length; ++i) {
            out[i] = IniFile.parseInt(cuts[i]);
        }
        return out;
    }

    public static Hashtable stringToHashtable(String in) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String[] lines = IniFile.cutOnStrings(in, '\n');
        for (int i = 0; i < lines.length; ++i) {
            int charIndex = lines[i].indexOf(61);
            if (charIndex < 0) continue;
            String key = lines[i].substring(0, charIndex).trim();
            String val = lines[i].substring(charIndex + 1).trim();
            hashtable.put(key, val);
        }
        return hashtable;
    }
}

