/*
 * Decompiled with CFR 0.152.
 */
package com.bgate.game;

import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

public class Bullet {
    public Sprite[] bullet;
    public boolean[] isDie;
    public int max;
    public int count;
    public int[] seq = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13};
    public int h;
    public Image tipImg;
    public Sprite tip;
    public int[] tipseq = new int[]{0, 0, 1, 1};

    public Bullet(int max, Image img, int w, int h) throws IOException {
        this.max = max;
        this.count = max;
        this.bullet = new Sprite[max];
        this.isDie = new boolean[max];
        for (int i = 0; i < max; ++i) {
            this.bullet[i] = new Sprite(img, w, h);
            this.bullet[i].setFrameSequence(this.seq);
            this.bullet[i].setFrame(13);
        }
        this.tipImg = Image.createImage((String)"/img/icontip.png");
        this.tip = new Sprite(this.tipImg, 19, 25);
        this.tip.setFrameSequence(this.tipseq);
    }

    public void fire() {
        if (this.count > 0) {
            --this.count;
            this.isDie[this.count] = true;
        }
    }

    public void loadbullet() {
        if (this.count == 0) {
            this.count = this.max;
            for (int i = 0; i < this.max; ++i) {
                this.bullet[i].setFrame(13);
                this.bullet[i].setVisible(true);
                this.isDie[i] = false;
            }
        }
    }

    public void setState(int w, int h) {
        if (h > 260) {
            for (int i = 0; i < this.max; ++i) {
                this.bullet[i].setPosition(w - 35 - 11 * i, 245);
            }
        } else {
            for (int i = 0; i < this.max; ++i) {
                this.bullet[i].setPosition(w - 35 - 11 * i, 205);
            }
        }
    }

    public void moveBullet() {
        for (int i = 0; i < this.max; ++i) {
            if (!this.isDie[i]) continue;
            if (this.bullet[i].getFrame() != 0) {
                this.bullet[i].prevFrame();
                continue;
            }
            this.bullet[i].setVisible(false);
        }
    }

    public void paint(Graphics g) {
        for (int i = 0; i < this.max; ++i) {
            this.bullet[i].paint(g);
        }
        this.tip.paint(g);
    }

    public Image getTipImg() {
        return this.tipImg;
    }
}

