/*
 * Decompiled with CFR 0.152.
 */
package com.bgate.game;

import com.bgate.game.BaseRMS;
import com.bgate.screen.LevelScreen;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;

public class HighScore
extends BaseRMS {
    public static int[] values = new int[40];
    private boolean isHighScore = false;
    public int oldscore;

    public HighScore(String rmsName) {
        super(rmsName);
        this.initValues();
    }

    private void initValues() {
        for (int i = 0; i < values.length; ++i) {
            HighScore.values[i] = 0;
        }
    }

    public void loadScores() throws Exception {
        try {
            this.open();
            this.loadData();
            if (this.getRecordStore() != null) {
                this.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getOldScore() {
        return this.oldscore;
    }

    public int[] getValues() {
        return values;
    }

    public void reset() throws Exception {
        this.open();
        this.initValues();
        this.updateData();
        if (this.getRecordStore() != null) {
            this.close();
        }
    }

    public void updateScores(int stage, int score) throws Exception {
        try {
            this.open();
            int index = (stage - 1) * 10 + LevelScreen.choice - 1;
            if (score > values[index]) {
                this.oldscore = values[index];
                HighScore.values[index] = score;
            }
            this.updateData();
            if (this.getRecordStore() != null) {
                this.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isHighScore(int stage, int level, int score) throws Exception {
        boolean isHighScore = false;
        try {
            if (score >= values[(stage - 1) * 10 + level - 1]) {
                isHighScore = true;
            }
        }
        catch (Exception e) {
            throw new Exception(this.getRMSName() + "::isHighScore::" + e);
        }
        return isHighScore;
    }

    protected void loadData() {
        try {
            byte[] record = this.getRecordStore().getRecord(1);
            DataInputStream istream = new DataInputStream(new ByteArrayInputStream(record, 0, record.length));
            for (int i = 0; i < values.length; ++i) {
                HighScore.values[i] = istream.readInt();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void createDefaultData() {
        try {
            ByteArrayOutputStream bstream = new ByteArrayOutputStream(12);
            DataOutputStream ostream = new DataOutputStream(bstream);
            for (int i = 0; i < values.length; ++i) {
                ostream.writeInt(values[i]);
            }
            ostream.flush();
            ostream.close();
            byte[] record = bstream.toByteArray();
            this.getRecordStore().addRecord(record, 0, record.length);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void updateData() {
        try {
            ByteArrayOutputStream bstream = new ByteArrayOutputStream(12);
            DataOutputStream ostream = new DataOutputStream(bstream);
            for (int i = 0; i < values.length; ++i) {
                ostream.writeInt(values[i]);
            }
            ostream.flush();
            ostream.close();
            byte[] record = bstream.toByteArray();
            this.getRecordStore().setRecord(1, record, 0, record.length);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

