/*
 * Decompiled with CFR 0.152.
 */
package com.bgate.core;

import com.bgate.core.Screen;
import javax.microedition.lcdui.Graphics;

public abstract class View {
    public Screen screen;
    public int width;
    public int height;
    public int delay;
    public int state;
    public int beforeState;
    public int typeScreen;
    public boolean show;

    public View(Screen screen) {
        this.screen = screen;
        this.width = screen.getWidth();
        this.height = screen.getHeight();
        this.delay = screen.delay;
        this.typeScreen = this.screen.type;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setState(int newState) {
        this.beforeState = this.state;
        this.state = newState;
    }

    public void show(boolean show) {
        this.show = show;
    }

    public boolean isShow() {
        return this.show;
    }

    public abstract void init();

    public abstract void update();

    public abstract void present(Graphics var1);

    public abstract void pause();

    public abstract void resume();

    public abstract void dispose();

    public abstract void upKeyPressed();

    public abstract void downKeyPressed();

    public abstract void rightKeyPressed();

    public abstract void leftKeyPressed();

    public abstract void fireKeyPressed();

    public abstract void softKeyLeftPressed();

    public abstract void softKeyRightPressed();

    public abstract void numberKeyPressed(int var1);

    public abstract void upKeyRealeased();

    public abstract void downKeyRealeased();

    public abstract void rightKeyRealeased();

    public abstract void leftKeyRealeased();

    public abstract void upKeytRepeated();

    public abstract void downKeyRepeated();

    public abstract void rightKeyRepeated();

    public abstract void leftKeyRepeated();

    public abstract void pointerPressed(int var1, int var2);

    public abstract void pointerReleased(int var1, int var2);

    public abstract void pointerDragged(int var1, int var2);

    public boolean inBounds(int pointerX, int pointerY, int boxX, int boxY, int width, int height) {
        return pointerX > boxX && pointerX < boxX + width - 1 && pointerY > boxY && pointerY < boxY + height - 1;
    }
}

