
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Canvas;
import java.io.DataInputStream;
import java.util.Random;

public class Logo extends Canvas implements Runnable {

    M gMIDlet;


    private static final int PHONE_SAMSUNG_Z105 = 1;
    private static final int PHONE_SHARP_GX20 = 2;
    private static final int PHONE_SAMSUNG_Z110 = 3;
    private static final int PHONE_MOTO_E1000 = 4;
    private static final int PHONE_NOKIA_60 = 5;

    static int phone = PHONE_MOTO_E1000; // runtime
    static int phone_p = phone; // preprocessor


    final static boolean loadWhileLogo = phone_p != PHONE_SAMSUNG_Z105 && phone_p != PHONE_SHARP_GX20;
    final static boolean quickLogo = phone_p == PHONE_SAMSUNG_Z105; // draws less frames and faster processing

  // living mobile logo
  static int[] logoColors = {getColorOfRGB(84, 84, 84), getColorOfRGB(84, 84, 84), getColorOfRGB(84, 84, 84), getColorOfRGB(255, 255, 255), getColorOfRGB(40, 40, 150), getColorOfRGB(255, 153, 0)};
  static int logoTilesX, logoTilesY;
  static byte[][] logoMap;
  static int[] sqColors = {getColorOfRGB(255, 255, 255), getColorOfRGB(255, 153, 0)};
  final static int sqTilesX = 88;
  final static int sqTilesY = 5;
  static byte[][] sqMap;
  static int[] urlColors = {getColorOfRGB(255, 255, 255), getColorOfRGB(255, 255, 255), getColorOfRGB(255, 255, 255), getColorOfRGB(255, 153, 0)};
  static int urlTilesX, urlTilesY;
  static byte[][] urlMap;
  final static int logoAnimLength = loadWhileLogo ? 44 : (quickLogo ? 20 : 30);

  // low resolution living mobile logo
  static int logo2TilesX, logo2TilesY;
  static byte[][] logo2Map;

    static final int LRES = 1;
    static final int QVGA = 2;
    static final int MRES = 3;

    private int res = LRES;

    static boolean debug = true;
    boolean skipIntro = false;

    static final int MODE_LOADING = 1;
    private int mode = MODE_LOADING;
    private String url="";
    private Graphics g2;

    //todo co sem?
    int SCR_H;
    int SCR_W;
    private Random rnd = new Random(System.currentTimeMillis());

    public Logo(M gMIDlet) {
        this.gMIDlet = gMIDlet;
        this.setFullScreenMode(true);
        SCR_H = getHeight();
        SCR_W = getWidth();
    }

    public void loadLogo() {
        try {
          DataInputStream in = new DataInputStream(this.getClass().getResourceAsStream("/lm.bin"));
          logoTilesX = in.read();
          logoTilesY = in.read();
          logoMap = new byte[logoTilesY][logoTilesX];
          for(int i=0; i<logoTilesY; i++) in.readFully(logoMap[i]);
          in.close();
          if(res == LRES) {
            in = new DataInputStream(this.getClass().getResourceAsStream("/lm2.bin"));
            logo2TilesX = in.read();
            logo2TilesY = in.read();
            logo2Map = new byte[logo2TilesY][logo2TilesX];
            for(int i=0; i<logo2TilesY; i++) in.readFully(logo2Map[i]);
            in.close();
          }
          sqMap = new byte[sqTilesY][sqTilesX];
          in = new DataInputStream(this.getClass().getResourceAsStream("/url.bin"));
          urlTilesX = in.read();
          urlTilesY = in.read();
          urlMap = new byte[urlTilesY][urlTilesX];
          for(int i=0; i<urlTilesY; i++) in.readFully(urlMap[i]);
          in.close();
        }
        catch (Exception e) {if(debug) System.out.println("ex loading lm logo");e.printStackTrace();}
  }

  public void loadImages(Image[] array) {
    int i;
//    if(!skipIntro && mode == MODE_LOADING && !loadWhileLogo) {
    for(i=0; i<logoAnimLength; i++) {
      drawLoad(i);
    }
  }

  public void drawLoad(int i) {
    if(i < logoAnimLength) {
      if(!quickLogo || i < logoAnimLength*2/3 || i%2 == 0) {
        // draw Living Mobile logo
        int spc = SCR_H/60; // space between logo and url
        if(i == 0) {
          g2.setColor(255, 255, 255);
          g2.fillRect(0, 0, getWidth(), getHeight());
        }
        int p = i*100/logoAnimLength;
        if(res == LRES) {
          processBinaryMap(logoMap, (byte)0, (byte)3, p);
          processBinaryMap(logoMap, (byte)1, (byte)4, p);
          processBinaryMap(logo2Map, (byte)0, (byte)3, p);
          processBinaryMap(logo2Map, (byte)2, (byte)5, p);
        }
        else {
          processBinaryMap(logoMap, (byte)0, (byte)3, p);
          processBinaryMap(logoMap, (byte)1, (byte)4, p);
          processBinaryMap(logoMap, (byte)2, (byte)5, p);
        }
        processBinaryMap(sqMap, (byte)0, (byte)1, p);
        processBinaryMap(urlMap, (byte)0, (byte)2, p);
        processBinaryMap(urlMap, (byte)1, (byte)3, p);
        if(res == QVGA) {
          drawBinaryMap(g2, logoMap, (SCR_W-240)/2, (SCR_H-10*3-10)/2-spc, 2, 1, logoColors, i==0 ? true:false, true);
          drawBinaryMap(g2, sqMap, 0, 0, 2, 1, sqColors, false, false);
          drawBinaryMap(g2, sqMap, 0, getHeight()-sqTilesY*3, 2, 1, sqColors, false, true);
        }
        else if(res == MRES){
          drawBinaryMap(g2, logoMap, (SCR_W-160)/2, (SCR_H-10*2-10)/2-spc, 1, 1, logoColors, i==0 ? true:false, true);
          drawBinaryMap(g2, sqMap, 0, 0, 1, 1, sqColors, false, false);
          drawBinaryMap(g2, sqMap, 0, getHeight()-sqTilesY*2, 1, 1, sqColors, false, true);
        }
        else if(res == LRES) {
          drawBinaryMap(g2, logoMap, (SCR_W-126)/2, (SCR_H-10*2-10)/2-spc, 1, 1, logoColors, i==0 ? true:false, true);
          drawBinaryMap(g2, logo2Map, (SCR_W-126)/2, (SCR_H-10*2-10)/2-30-spc, 1, 1, logoColors, i==0 ? true:false, true);
          drawBinaryMap(g2, sqMap, 0, 0, 1, 1, sqColors, false, false);
          drawBinaryMap(g2, sqMap, 0, getHeight()-sqTilesY*2, 1, 1, sqColors, false, true);
        }
        drawBinaryMap(g2, urlMap, (SCR_W-urlTilesX)/2, (SCR_H+10*3-10)/2+spc, 1, 0, urlColors, false, true);
      }
      if(phone == PHONE_SAMSUNG_Z110 || phone == PHONE_MOTO_E1000) {
        try {Thread.sleep(50);} catch (Exception e) {} // otherwise too fast
      }
    }
    repaint();
    serviceRepaints();
  }

  public void processBinaryMap(byte[][] map, byte t1, byte t2, int percent) {
    try {
      if(quickLogo) {
        int ix, iy;
        int[] randomValues = new int[20];
        int randomLength = randomValues.length;
        for(ix=0; ix<randomLength; ix++) randomValues[ix] = Math.abs(rnd.nextInt()%100);
        int maxX = map[0].length;
        int maxY = map.length;
        for(iy=0; iy<maxY; iy++) {
          for(ix=0; ix<maxX; ix++) {
            if(map[iy][ix] == t1 && randomValues[(ix*iy)%randomLength] < percent) map[iy][ix] = t2;
          }
        }
      }
      else {
        for(int iy=0; iy<map.length; iy++) {
          for(int ix=0; ix<map[0].length; ix++) {
            if(map[iy][ix] == t1 && Math.abs(rnd.nextInt()%100) < percent) map[iy][ix] = t2;
          }
        }
      }
    }
    catch (Exception e) {
      if(debug) {System.out.println("ex processing logo"); e.printStackTrace();}
    }
  }

  public void drawBinaryMap(Graphics g, byte[][] map, int x, int y, int size, int spc, int[] colors,
                            boolean drawAll, boolean lastOnFrame) {
    //int drawn = 0;
    for(int iy=0; iy<map.length; iy++) {
      for(int ix=0; ix<map[0].length; ix++) {
        if(map[iy][ix] < 0) continue;
        if(!drawAll && map[iy][ix] < colors.length/2) continue; // color did not change yet
        //drawn++;
        g.setColor(colors[map[iy][ix]]);
        g.fillRect(x+ix*(size+spc), y+iy*(size+spc), size, size);
        if(lastOnFrame && map[iy][ix] >= colors.length/2) map[iy][ix] = -1; // tag color as final
      }
    }
    //System.out.println("d: " + drawn);
  }

  final static int getColorOfRGB(int r, int g, int b) {
      return (((r & 0xff) << 16) + ((g & 0xff) << 8) + (b & 0xff));
  }

    protected void paint(Graphics g) {
        g2 = g;
    }


    public void run() {
        //ziskam g
        while(g2 == null) {
            repaint();
            serviceRepaints();
        }
        loadLogo();     //nejdriv vse nahrat
        loadImages(null);

        //pockat
        try {
            Thread.sleep(600);
        } catch (InterruptedException e) {
        }
        //ukoncit
        gMIDlet.exit();
    }
}