/*
 * Decompiled with CFR 0.152.
 */
public class FGTimer {
    private int m_elapsedTime;
    private int m_startTime;
    private int m_original;
    private int m_endTime;
    private boolean m_bPaused;
    private boolean m_bNeedToRegister;

    public FGTimer() {
        this.initInternals(true);
    }

    public FGTimer(boolean bl) {
        this.initInternals(bl);
    }

    private void initInternals(boolean bl) {
        this.m_elapsedTime = 0;
        this.m_startTime = 0;
        this.m_original = 0;
        this.m_endTime = 0;
        this.m_bPaused = true;
        this.m_bNeedToRegister = bl;
    }

    public void unregisterSelf() {
        FGEngine.getEngine().getTimerRegistry().removePointer(this);
    }

    public void start(int n) {
        if (this.m_bNeedToRegister) {
            FGEngine.getEngine().getTimerRegistry().addPointer(this);
            this.m_bNeedToRegister = false;
        }
        this.m_original = n;
        this.m_startTime = this.getCurrentTime();
        this.m_endTime = this.m_startTime + this.m_original;
        this.m_bPaused = false;
    }

    public void advance(int n) {
        this.m_endTime -= n;
        this.m_startTime -= n;
    }

    public void startAt(int n, int n2) {
        this.m_original = n;
        this.m_startTime = this.getCurrentTime() - n2;
        this.m_endTime = this.m_startTime + this.m_original;
        this.m_bPaused = false;
    }

    public void pause() {
        if (this.m_bPaused) {
            return;
        }
        this.m_elapsedTime = this.getCurrentTime() - this.m_startTime;
        this.m_bPaused = true;
    }

    public void resume() {
        if (!this.m_bPaused) {
            return;
        }
        this.m_startTime = this.getCurrentTime() - this.m_elapsedTime;
        this.m_endTime = this.m_startTime + this.m_original;
        this.m_bPaused = false;
    }

    public int elapsedTime() {
        int n = 0;
        if (this.m_bPaused) {
            n = this.m_elapsedTime;
        } else {
            int n2 = this.getCurrentTime();
            n = n2 - this.m_startTime;
        }
        if (n < 0) {
            n = 0;
        }
        return n;
    }

    public int remainingTime() {
        if (this.m_bPaused) {
            return this.m_original - this.m_elapsedTime;
        }
        return this.m_endTime - this.getCurrentTime();
    }

    public int totalTime() {
        return this.m_original;
    }

    public boolean isOver() {
        if (this.m_bPaused) {
            return this.m_elapsedTime >= this.m_original;
        }
        return this.getCurrentTime() > this.m_endTime;
    }

    public boolean isPaused() {
        return this.m_bPaused;
    }

    public int getCurrentTime() {
        return (int)System.currentTimeMillis();
    }

    public void save(FGDataWriter fGDataWriter) {
        this.pause();
        fGDataWriter.writeInt(this.m_original);
        fGDataWriter.writeInt(this.elapsedTime());
    }

    public void load(FGDataReader fGDataReader) {
        this.m_original = fGDataReader.readInt();
        this.m_elapsedTime = fGDataReader.readInt();
        this.m_bPaused = true;
    }
}

