/*
 * Decompiled with CFR 0.152.
 */
class FGImageMaker {
    private int m_width;
    private int m_height;
    private int[] m_pixels;

    public void init(int n, int n2) {
        this.m_pixels = new int[n * n2];
        this.m_width = n;
        this.m_height = n2;
        for (int i = 0; i < this.m_width * this.m_height; ++i) {
            this.m_pixels[i] = 0;
        }
    }

    public int getPixel(int n, int n2, int n3) {
        if (n < 0 || n >= this.m_width) {
            return 0;
        }
        if (n2 < 0 || n2 >= this.m_height) {
            return 0;
        }
        return this.m_pixels[n + n2 * this.m_width] << 8;
    }

    public void setPixel(int n, int n2, int n3) {
        if (n < 0 || n >= this.m_width) {
            return;
        }
        if (n2 < 0 || n2 >= this.m_height) {
            return;
        }
        this.m_pixels[n + n2 * this.m_width] = n3 | 0xFF000000;
    }

    public void drawLine(int n, int n2, int n3, int n4, int n5) {
        int n6;
        boolean bl;
        if (n == n3) {
            for (int i = n2; i <= n4; ++i) {
                this.setPixel(n, i, n5);
            }
            return;
        }
        if (n2 == n4) {
            for (int i = n; i <= n3; ++i) {
                this.setPixel(i, n4, n5);
            }
            return;
        }
        int n7 = n3 - n;
        boolean bl2 = bl = Math.abs(n4 - n2) > Math.abs(n3 - n);
        if (bl) {
            n6 = n2;
            n2 = n;
            n = n6;
            n6 = n4;
            n4 = n3;
            n3 = n6;
        }
        if (n > n3) {
            n6 = n;
            n = n3;
            n3 = n6;
            n6 = n2;
            n2 = n4;
            n4 = n6;
        }
        n6 = n3 - n;
        int n8 = Math.abs(n4 - n2);
        int n9 = -n6 / 2;
        int n10 = n2;
        int n11 = n2 < n4 ? 1 : -1;
        for (int i = n; i <= n3; ++i) {
            if (bl) {
                this.setPixel(n10, i, n5);
            } else {
                this.setPixel(i, n10, n5);
            }
            if ((n9 += n8) <= 0) continue;
            n10 += n11;
            n9 -= n6;
        }
    }

    void drawRect(int n, int n2, int n3, int n4, int n5) {
        this.drawLine(n, n2, n + n3, n2, n5);
        this.drawLine(n, n2 + n4, n + n3, n2 + n4, n5);
        this.drawLine(n, n2, n, n2 + n4, n5);
        this.drawLine(n + n3, n2, n + n3, n2 + n4, n5);
    }

    void fillRect(int n, int n2, int n3, int n4, int n5) {
        for (int i = n; i < n + n3; ++i) {
            for (int j = n2; j < n2 + n4; ++j) {
                this.setPixel(i, j, n5);
            }
        }
    }

    public FGImage getImage() {
        FGImage fGImage = new FGImage();
        fGImage.init(this.m_pixels, this.m_width, this.m_height);
        return fGImage;
    }

    public int getWidth() {
        return this.m_width;
    }

    public int getHeight() {
        return this.m_height;
    }
}

