/*
 * Decompiled with CFR 0.152.
 */
class FGAnimation {
    public static final int MAX_IMAGES = 40;
    FGImage[] m_frames = new FGImage[40];
    FGTimer m_timer = new FGTimer();
    int m_numFrames;
    int m_cycleTime;
    boolean m_bPlayingOnce;

    FGAnimation() {
    }

    void init(int n) {
        this.m_cycleTime = n;
        this.m_numFrames = 0;
        this.m_bPlayingOnce = false;
        this.m_timer.start(0);
        for (int i = 0; i < 40; ++i) {
            this.m_frames[i] = null;
        }
    }

    public void clearArt() {
        this.init(100);
    }

    void init(FGAnimation fGAnimation) {
        this.m_numFrames = fGAnimation.m_numFrames;
        this.m_cycleTime = fGAnimation.m_cycleTime;
        this.m_bPlayingOnce = false;
        for (int i = 0; i < this.m_numFrames; ++i) {
            this.m_frames[i] = fGAnimation.m_frames[i];
        }
        this.m_timer.start(0);
    }

    void addFrame(FGImage fGImage) {
        if (this.m_numFrames >= 40) {
            FGEngine.fatal("too namy frames added to anim.");
            return;
        }
        this.m_frames[this.m_numFrames] = fGImage;
        ++this.m_numFrames;
    }

    void addFrameSet(FGResLoader fGResLoader, String string, String string2, int n, boolean bl, boolean bl2) {
        for (int i = 0; i < n; ++i) {
            FGImage fGImage = fGResLoader.getImageFromSet(string, string2, i, bl, bl2);
            this.addFrame(fGImage);
        }
    }

    int getDuration() {
        return this.m_cycleTime * this.m_numFrames;
    }

    FGImage getFrame(int n) {
        if (n < 0) {
            return null;
        }
        if (n >= this.m_numFrames) {
            return null;
        }
        return this.m_frames[n];
    }

    void playOnce() {
        this.m_timer.start(this.getDuration());
        this.m_bPlayingOnce = true;
    }

    void restart() {
        this.m_timer.start(this.getDuration());
        this.m_bPlayingOnce = false;
    }

    boolean finishedPlaying() {
        if (!this.m_bPlayingOnce) {
            return false;
        }
        return this.m_timer.isOver();
    }

    FGImage getCurrentFrame() {
        if (this.m_numFrames == 0) {
            return null;
        }
        if (!this.m_timer.isPaused() && this.m_timer.isOver() && !this.m_bPlayingOnce) {
            this.m_timer.start(this.getDuration());
            return this.m_frames[0];
        }
        int n = this.m_timer.elapsedTime() / this.m_cycleTime;
        if (n >= this.m_numFrames) {
            n = this.m_numFrames - 1;
        }
        return this.m_frames[n];
    }

    void pause() {
        this.m_timer.pause();
    }

    void resume() {
        this.m_timer.resume();
    }
}

